/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.log.Log;
import com.thinkaurelius.titan.diskstorage.log.LogManager;
import com.thinkaurelius.titan.diskstorage.log.Message;
import com.thinkaurelius.titan.diskstorage.log.MessageReader;
import com.thinkaurelius.titan.diskstorage.log.ReadMarker;
import com.thinkaurelius.titan.diskstorage.log.util.FutureMessage;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;

public class TestMockLog
implements LogManager {
    public static final ConfigOption<Boolean> LOG_MOCK_FAILADD = new ConfigOption(GraphDatabaseConfiguration.LOG_NS, "fail-adds", "Sets the log to reject adding messages. FOR TESTING ONLY", ConfigOption.Type.LOCAL, (Object)false).hide();
    private final Map<String, TestLog> openLogs = Maps.newHashMap();
    private final boolean failAdds;
    private final String senderId;
    private final TimestampProvider times;

    public TestMockLog(Configuration config) {
        this.failAdds = (Boolean)config.get(LOG_MOCK_FAILADD, new String[0]);
        this.senderId = (String)config.get(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, new String[0]);
        this.times = (TimestampProvider)config.get(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0]);
    }

    public synchronized Log openLog(String name) throws BackendException {
        TestLog log = this.openLogs.get(name);
        if (log == null) {
            log = new TestLog(name);
            this.openLogs.put(name, log);
        }
        return log;
    }

    public synchronized void close() throws BackendException {
        this.openLogs.clear();
    }

    private class TestMessage
    implements Message {
        private final Instant time;
        private final StaticBuffer content;

        private TestMessage(StaticBuffer content) {
            this.time = TestMockLog.this.times.getTime();
            this.content = content;
        }

        public String getSenderId() {
            return TestMockLog.this.senderId;
        }

        public Instant getTimestamp() {
            return this.time;
        }

        public StaticBuffer getContent() {
            return this.content;
        }
    }

    private class TestLog
    implements Log {
        private final String name;
        private final Set<MessageReader> readers = Sets.newHashSet();
        private List<FutureMessage<TestMessage>> messageBacklog = Lists.newArrayList();

        private TestLog(String name) {
            this.name = name;
        }

        public synchronized Future<Message> add(StaticBuffer content) {
            TestMessage msg = new TestMessage(content);
            FutureMessage fmsg = new FutureMessage((Message)msg);
            if (TestMockLog.this.failAdds) {
                System.out.println("Failed message add");
                throw new TitanException("Log unavailable");
            }
            if (this.readers.isEmpty()) {
                this.messageBacklog.add((FutureMessage<TestMessage>)fmsg);
            } else {
                this.process((FutureMessage<TestMessage>)fmsg);
            }
            return fmsg;
        }

        private void process(FutureMessage<TestMessage> fmsg) {
            for (MessageReader reader : this.readers) {
                reader.read(fmsg.getMessage());
            }
            fmsg.delivered();
        }

        public synchronized Future<Message> add(StaticBuffer content, StaticBuffer key) {
            return this.add(content);
        }

        public synchronized void registerReader(ReadMarker readMarker, MessageReader ... reader) {
            this.registerReaders(readMarker, Arrays.asList(reader));
        }

        public synchronized void registerReaders(ReadMarker readMarker, Iterable<MessageReader> readers) {
            for (FutureMessage<TestMessage> fmsg : this.messageBacklog) {
                this.process(fmsg);
            }
            this.messageBacklog = null;
            Iterables.addAll(this.readers, readers);
        }

        public synchronized boolean unregisterReader(MessageReader reader) {
            return this.readers.remove(reader);
        }

        public String getName() {
            return this.name;
        }

        public void close() throws BackendException {
            this.readers.clear();
        }
    }
}

