/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanGraphTransaction;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexProperty;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanSchemaElement;
import com.thinkaurelius.titan.diskstorage.util.TestLockerManager;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.testcategory.SerialTests;
import com.thinkaurelius.titan.testutil.TitanAssert;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SerialTests.class})
public abstract class TitanEventualGraphTest
extends TitanGraphBaseTest {
    private Logger log = LoggerFactory.getLogger(TitanEventualGraphTest.class);

    @Test
    public void verifyEligibility() {
        Preconditions.checkArgument((!this.graph.getConfiguration().getBackend().getStoreFeatures().hasTxIsolation() ? 1 : 0) != 0, (Object)"This test suite only applies to eventually consistent data stores");
    }

    @Test
    public void concurrentIndexTest() {
        this.makeVertexIndexedUniqueKey("uid", String.class);
        this.makeVertexIndexedKey("value", Object.class);
        this.finishSchema();
        TitanVertex v = this.tx.addVertex(new Object[]{"uid", "v"});
        this.clopen(new Object[0]);
        TitanTransaction tx1 = this.graph.newTransaction();
        TitanTransaction tx2 = this.graph.newTransaction();
        TitanEventualGraphTest.getVertex(tx1, "uid", (Object)"v").property(VertexProperty.Cardinality.single, "value", (Object)11, new Object[0]);
        TitanEventualGraphTest.getVertex(tx2, "uid", (Object)"v").property(VertexProperty.Cardinality.single, "value", (Object)11, new Object[0]);
        tx1.commit();
        tx2.commit();
        Assert.assertEquals((Object)"v", (Object)Iterators.getOnlyElement((Iterator)((TitanVertex)Iterables.getOnlyElement((Iterable)this.tx.query().has("value", (Object)11).vertices())).values(new String[]{"uid"})));
    }

    @Test
    public void testTimestampSetting() {
        this.clopen(TitanEventualGraphTest.option(GraphDatabaseConfiguration.STORE_META_TIMESTAMPS, "edgestore"), true, TitanEventualGraphTest.option(GraphDatabaseConfiguration.STORE_META_TTL, "edgestore"), true);
        TitanTransaction tx1 = this.graph.buildTransaction().commitTime(Instant.ofEpochSecond(100L)).start();
        String name = "name";
        String age = "age";
        String address = "address";
        TitanVertex v1 = tx1.addVertex(new Object[]{name, "a"});
        TitanVertex v2 = tx1.addVertex(new Object[]{age, "14", name, "b", age, "42"});
        tx1.commit();
        long id1 = TitanEventualGraphTest.getId((Element)v1);
        long id2 = TitanEventualGraphTest.getId((Element)v2);
        TitanTransaction tx2 = this.graph.buildTransaction().commitTime(Instant.ofEpochSecond(1000L)).start();
        v1 = TitanEventualGraphTest.getV((TitanGraphTransaction)tx2, id1);
        v2 = TitanEventualGraphTest.getV((TitanGraphTransaction)tx2, id2);
        Iterator propiter = v1.properties(new String[]{name});
        while (propiter.hasNext()) {
            VertexProperty prop = (VertexProperty)propiter.next();
            if (this.features.hasTimestamps()) {
                Instant t = (Instant)prop.value("~timestamp");
                Assert.assertEquals((long)100L, (long)t.getEpochSecond());
                Assert.assertEquals((long)Instant.ofEpochSecond(0L, 1000L).getNano(), (long)t.getNano());
            }
            if (!this.features.hasCellTTL()) continue;
            Duration d = (Duration)prop.value("~ttl");
            Assert.assertEquals((long)0L, (long)d.getSeconds());
            Assert.assertTrue((boolean)d.isZero());
        }
        Assert.assertEquals((long)1L, (long)v1.query().propertyCount());
        Assert.assertEquals((long)1L, (long)v1.query().has("~timestamp", (TitanPredicate)Cmp.GREATER_THAN, (Object)Instant.ofEpochSecond(10L)).propertyCount());
        Assert.assertEquals((long)1L, (long)v1.query().has("~timestamp", (Object)Instant.ofEpochSecond(100L, 1000L)).propertyCount());
        v1.property(name).remove();
        v1.property(VertexProperty.Cardinality.single, address, (Object)"xyz", new Object[0]);
        TitanEdge edge = v2.addEdge("parent", (Vertex)v1, new Object[0]);
        tx2.commit();
        Object edgeId = edge.id();
        TitanVertex afterTx2 = TitanEventualGraphTest.getV((TitanGraphTransaction)this.graph, id1);
        Assert.assertFalse((boolean)afterTx2.keys().contains(name));
        Assert.assertEquals((Object)"xyz", (Object)afterTx2.value(address));
        TitanAssert.assertCount(1L, afterTx2.query().direction(Direction.IN).labels(new String[]{"parent"}).edges());
        Assert.assertNotNull((Object)TitanEventualGraphTest.getE((TitanGraphTransaction)this.graph, edgeId));
        this.graph.tx().commit();
        TitanTransaction tx3 = this.graph.buildTransaction().commitTime(Instant.ofEpochSecond(200L)).start();
        v1 = TitanEventualGraphTest.getV((TitanGraphTransaction)tx3, id1);
        v1.property(address).remove();
        tx3.commit();
        TitanVertex afterTx3 = TitanEventualGraphTest.getV((TitanGraphTransaction)this.graph, id1);
        this.graph.tx().commit();
        Assert.assertEquals((Object)"xyz", (Object)afterTx3.value(address));
        TitanTransaction tx4 = this.graph.buildTransaction().commitTime(Instant.ofEpochSecond(2000L)).start();
        v2 = TitanEventualGraphTest.getV((TitanGraphTransaction)tx4, id2);
        v2.property(VertexProperty.Cardinality.single, age, (Object)"15", new Object[0]);
        TitanEventualGraphTest.getE((TitanGraphTransaction)tx4, edgeId).remove();
        tx4.commit();
        TitanVertex afterTx4 = TitanEventualGraphTest.getV((TitanGraphTransaction)this.graph, id2);
        Assert.assertEquals((Object)"15", (Object)afterTx4.value(age));
        TitanAssert.assertCount(0L, afterTx4.query().direction(Direction.OUT).labels(new String[]{"parent"}).edges());
        Assert.assertNull((Object)TitanEventualGraphTest.getE((TitanGraphTransaction)this.graph, edgeId));
        TitanTransaction tx5 = this.graph.buildTransaction().commitTime(Instant.ofEpochSecond(1500L)).start();
        v2 = TitanEventualGraphTest.getV((TitanGraphTransaction)tx5, id2);
        v2.property(VertexProperty.Cardinality.single, age, (Object)"16", new Object[0]);
        tx5.commit();
        TitanVertex afterTx5 = TitanEventualGraphTest.getV((TitanGraphTransaction)this.graph, id2);
        Assert.assertEquals((Object)"15", (Object)afterTx5.value(age));
    }

    @Test
    public void testTimestampedEdgeUpdates() {
        this.clopen(TitanEventualGraphTest.option(GraphDatabaseConfiguration.STORE_META_TIMESTAMPS, "edgestore"), true, TitanEventualGraphTest.option(GraphDatabaseConfiguration.STORE_META_TTL, "edgestore"), true);
        TitanTransaction tx = this.graph.buildTransaction().commitTime(Instant.ofEpochSecond(100L)).start();
        TitanVertex v1 = tx.addVertex(new Object[0]);
        TitanVertex v2 = tx.addVertex(new Object[0]);
        TitanEdge e = v1.addEdge("related", (Vertex)v2, new Object[0]);
        e.property("time", (Object)25);
        tx.commit();
        tx = this.graph.buildTransaction().commitTime(Instant.ofEpochSecond(200L)).start();
        v1 = tx.getVertex(v1.longId());
        Assert.assertNotNull((Object)v1);
        e = (Edge)Iterators.getOnlyElement((Iterator)v1.edges(Direction.OUT, new String[]{"related"}));
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)25, (Object)e.value("time"));
        e.property("time", (Object)125);
        tx.commit();
        tx = this.graph.buildTransaction().commitTime(Instant.ofEpochSecond(300L)).start();
        v1 = tx.getVertex(v1.longId());
        Assert.assertNotNull((Object)v1);
        e = (Edge)Iterators.getOnlyElement((Iterator)v1.edges(Direction.OUT, new String[]{"related"}));
        Assert.assertEquals((Object)125, (Object)e.value("time"));
        e.remove();
        tx.commit();
    }

    @Test
    public void testBatchLoadingNoLock() {
        this.testBatchLoadingLocking(true);
    }

    @Test
    public void testLockException() {
        try {
            this.testBatchLoadingLocking(false);
            Assert.fail();
        }
        catch (TitanException e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            Assert.assertEquals(UnsupportedOperationException.class, cause.getClass());
        }
    }

    public void testBatchLoadingLocking(boolean batchloading) {
        TitanVertex v;
        int i;
        PropertyKey uid = this.makeKey("uid", Long.class);
        TitanGraphIndex uidIndex = this.mgmt.buildIndex("uid", Vertex.class).unique().addKey(uid).buildCompositeIndex();
        this.mgmt.setConsistency((TitanSchemaElement)uid, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((TitanSchemaElement)uidIndex, ConsistencyModifier.LOCK);
        EdgeLabel knows = this.mgmt.makeEdgeLabel("knows").multiplicity(Multiplicity.ONE2ONE).make();
        this.mgmt.setConsistency((TitanSchemaElement)knows, ConsistencyModifier.LOCK);
        this.finishSchema();
        TestLockerManager.ERROR_ON_LOCKING = true;
        this.clopen(TitanEventualGraphTest.option(GraphDatabaseConfiguration.STORAGE_BATCH, new String[0]), batchloading, TitanEventualGraphTest.option(GraphDatabaseConfiguration.LOCK_BACKEND, new String[0]), "test");
        int numV = 10000;
        long start = System.currentTimeMillis();
        for (i = 0; i < numV; ++i) {
            v = this.tx.addVertex(new Object[]{"uid", i + 1});
            v.addEdge("knows", (Vertex)v, new Object[0]);
        }
        this.clopen(new Object[0]);
        for (i = 0; i < Math.min(numV, 300); ++i) {
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has("uid", (Object)(i + 1)).vertices()));
            v = (TitanVertex)Iterables.getOnlyElement((Iterable)this.graph.query().has("uid", (Object)(i + 1)).vertices());
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges()));
        }
    }

    @Test
    public void testConsistencyModifier() throws InterruptedException {
        PropertyKey sig = this.makeKey("sig", Integer.class);
        PropertyKey weight = this.makeKey("weight", Double.class);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SET).make();
        PropertyKey value = this.mgmt.makePropertyKey("value").dataType(Integer.class).cardinality(Cardinality.LIST).make();
        PropertyKey valuef = this.mgmt.makePropertyKey("valuef").dataType(Integer.class).cardinality(Cardinality.LIST).make();
        this.mgmt.setConsistency((TitanSchemaElement)valuef, ConsistencyModifier.FORK);
        EdgeLabel em = this.mgmt.makeEdgeLabel("em").multiplicity(Multiplicity.MULTI).make();
        EdgeLabel emf = this.mgmt.makeEdgeLabel("emf").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.setConsistency((TitanSchemaElement)emf, ConsistencyModifier.FORK);
        EdgeLabel es = this.mgmt.makeEdgeLabel("es").multiplicity(Multiplicity.SIMPLE).make();
        EdgeLabel o2o = this.mgmt.makeEdgeLabel("o2o").multiplicity(Multiplicity.ONE2ONE).make();
        EdgeLabel o2m = this.mgmt.makeEdgeLabel("o2m").multiplicity(Multiplicity.ONE2MANY).make();
        this.finishSchema();
        TitanVertex u = this.tx.addVertex(new Object[0]);
        TitanVertex v = this.tx.addVertex(new Object[0]);
        TitanRelation[] rs = new TitanRelation[9];
        boolean txid = true;
        rs[0] = this.sign((TitanRelation)v.property("weight", (Object)5.0), 1);
        rs[1] = this.sign((TitanRelation)v.property("name", (Object)"John"), 1);
        rs[2] = this.sign((TitanRelation)v.property("value", (Object)2), 1);
        rs[3] = this.sign((TitanRelation)v.property("valuef", (Object)2), 1);
        rs[6] = this.sign((TitanRelation)v.addEdge("es", (Vertex)u, new Object[0]), 1);
        rs[7] = this.sign((TitanRelation)v.addEdge("o2o", (Vertex)u, new Object[0]), 1);
        rs[8] = this.sign((TitanRelation)v.addEdge("o2m", (Vertex)u, new Object[0]), 1);
        rs[4] = this.sign((TitanRelation)v.addEdge("em", (Vertex)u, new Object[0]), 1);
        rs[5] = this.sign((TitanRelation)v.addEdge("emf", (Vertex)u, new Object[0]), 1);
        this.newTx();
        long vid = TitanEventualGraphTest.getId((Element)v);
        long uid = TitanEventualGraphTest.getId((Element)u);
        TitanTransaction tx1 = this.graph.newTransaction();
        TitanTransaction tx2 = this.graph.newTransaction();
        int wintx = 20;
        this.processTx(tx1, 10, vid, uid);
        this.processTx(tx2, 20, vid, uid);
        tx1.commit();
        Thread.sleep(5L);
        tx2.commit();
        this.newTx();
        v = TitanEventualGraphTest.getV((TitanGraphTransaction)this.tx, vid);
        Assert.assertEquals((double)6.0, (double)((Double)v.value("weight")), (double)1.0E-5);
        VertexProperty p = (VertexProperty)TitanEventualGraphTest.getOnlyElement(v.properties(new String[]{"weight"}));
        Assert.assertEquals((long)20L, (long)((Integer)p.value("sig")).intValue());
        p = (VertexProperty)TitanEventualGraphTest.getOnlyElement(v.properties(new String[]{"name"}));
        Assert.assertEquals((Object)"Bob", (Object)p.value());
        Assert.assertEquals((long)20L, (long)((Integer)p.value("sig")).intValue());
        p = (VertexProperty)TitanEventualGraphTest.getOnlyElement(v.properties(new String[]{"value"}));
        Assert.assertEquals((long)rs[2].longId(), (long)TitanEventualGraphTest.getId((Element)p));
        Assert.assertEquals((long)20L, (long)((Integer)p.value("sig")).intValue());
        TitanAssert.assertCount(2L, v.properties(new String[]{"valuef"}));
        Iterator ppiter = v.properties(new String[]{"valuef"});
        while (ppiter.hasNext()) {
            VertexProperty pp = (VertexProperty)ppiter.next();
            Assert.assertNotEquals((long)rs[3].longId(), (long)TitanEventualGraphTest.getId((Element)pp));
            Assert.assertEquals((Object)2, (Object)pp.value());
        }
        Edge e = (Edge)TitanEventualGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"es"}).edges());
        Assert.assertEquals((long)20L, (long)((Integer)e.value("sig")).intValue());
        Assert.assertNotEquals((long)rs[6].longId(), (long)TitanEventualGraphTest.getId((Element)e));
        e = (Edge)TitanEventualGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"o2o"}).edges());
        Assert.assertEquals((long)20L, (long)((Integer)e.value("sig")).intValue());
        Assert.assertEquals((long)rs[7].longId(), (long)TitanEventualGraphTest.getId((Element)e));
        e = (Edge)TitanEventualGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"o2m"}).edges());
        Assert.assertEquals((long)20L, (long)((Integer)e.value("sig")).intValue());
        Assert.assertNotEquals((long)rs[8].longId(), (long)TitanEventualGraphTest.getId((Element)e));
        e = (Edge)TitanEventualGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"em"}).edges());
        Assert.assertEquals((long)20L, (long)((Integer)e.value("sig")).intValue());
        Assert.assertEquals((long)rs[4].longId(), (long)TitanEventualGraphTest.getId((Element)e));
        for (Edge ee : v.query().direction(Direction.OUT).labels(new String[]{"emf"}).edges()) {
            Assert.assertNotEquals((long)rs[5].longId(), (long)TitanEventualGraphTest.getId((Element)ee));
            Assert.assertEquals((Object)uid, (Object)ee.inVertex().id());
        }
    }

    private void processTx(TitanTransaction tx, int txid, long vid, long uid) {
        TitanVertex v = TitanEventualGraphTest.getV((TitanGraphTransaction)tx, vid);
        TitanVertex u = TitanEventualGraphTest.getV((TitanGraphTransaction)tx, uid);
        Assert.assertEquals((double)5.0, (double)((Double)v.value("weight")), (double)1.0E-5);
        VertexProperty p = (VertexProperty)TitanEventualGraphTest.getOnlyElement(v.properties(new String[]{"weight"}));
        Assert.assertEquals((long)1L, (long)((Integer)p.value("sig")).intValue());
        this.sign((TitanRelation)v.property("weight", (Object)6.0), txid);
        p = (VertexProperty)TitanEventualGraphTest.getOnlyElement(v.properties(new String[]{"name"}));
        Assert.assertEquals((long)1L, (long)((Integer)p.value("sig")).intValue());
        Assert.assertEquals((Object)"John", (Object)p.value());
        p.remove();
        this.sign((TitanRelation)v.property("name", (Object)"Bob"), txid);
        for (String pkey : new String[]{"value", "valuef"}) {
            p = (VertexProperty)TitanEventualGraphTest.getOnlyElement(v.properties(new String[]{pkey}));
            Assert.assertEquals((long)1L, (long)((Integer)p.value("sig")).intValue());
            Assert.assertEquals((Object)2, (Object)p.value());
            this.sign((TitanRelation)((TitanVertexProperty)p), txid);
        }
        Edge e = (Edge)TitanEventualGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"es"}).edges());
        Assert.assertEquals((long)1L, (long)((Integer)e.value("sig")).intValue());
        e.remove();
        this.sign((TitanRelation)v.addEdge("es", (Vertex)u, new Object[0]), txid);
        e = (Edge)TitanEventualGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"o2o"}).edges());
        Assert.assertEquals((long)1L, (long)((Integer)e.value("sig")).intValue());
        this.sign((TitanRelation)((TitanEdge)e), txid);
        e = (Edge)TitanEventualGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"o2m"}).edges());
        Assert.assertEquals((long)1L, (long)((Integer)e.value("sig")).intValue());
        e.remove();
        this.sign((TitanRelation)v.addEdge("o2m", (Vertex)u, new Object[0]), txid);
        for (String label : new String[]{"em", "emf"}) {
            e = (Edge)TitanEventualGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{label}).edges());
            Assert.assertEquals((long)1L, (long)((Integer)e.value("sig")).intValue());
            this.sign((TitanRelation)((TitanEdge)e), txid);
        }
    }

    private TitanRelation sign(TitanRelation r, int id) {
        r.property("sig", (Object)id);
        return r;
    }
}

