/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.testcategory.MemoryTests;
import com.thinkaurelius.titan.testutil.JUnitBenchmarkProvider;
import com.thinkaurelius.titan.testutil.MemoryAssess;
import com.thinkaurelius.titan.testutil.TitanAssert;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;

@Category(value={MemoryTests.class})
public abstract class TitanGraphPerformanceMemoryTest
extends TitanGraphBaseTest {
    @Rule
    public TestRule benchmark = JUnitBenchmarkProvider.get();

    @Test
    public void testMemoryLeakage() {
        long memoryBaseline = 0L;
        SummaryStatistics stats = new SummaryStatistics();
        int numRuns = 25;
        for (int r = 0; r < numRuns; ++r) {
            if (r == 1 || r == numRuns - 1) {
                memoryBaseline = MemoryAssess.getMemoryUse();
                stats.addValue((double)memoryBaseline);
            }
            for (int t = 0; t < 1000; ++t) {
                this.graph.addVertex(new Object[0]);
                this.graph.tx().rollback();
                TitanTransaction tx = this.graph.newTransaction();
                tx.addVertex(new Object[0]);
                tx.rollback();
            }
            if (r == 1 || r == numRuns - 1) {
                memoryBaseline = MemoryAssess.getMemoryUse();
                stats.addValue((double)memoryBaseline);
            }
            this.clopen(new Object[0]);
        }
        System.out.println("Average: " + stats.getMean() + " Std. Dev: " + stats.getStandardDeviation());
        Assert.assertTrue((stats.getStandardDeviation() < stats.getMin() ? 1 : 0) != 0);
    }

    @Test
    public void testTransactionalMemory() throws Exception {
        int t;
        int t2;
        this.makeVertexIndexedUniqueKey("uid", Long.class);
        this.makeKey("name", String.class);
        PropertyKey time = this.makeKey("time", Integer.class);
        this.mgmt.makeEdgeLabel("friend").signature(new PropertyKey[]{time}).directed().make();
        this.finishSchema();
        final Random random = new Random();
        int rounds = 100;
        int commitSize = 1500;
        final AtomicInteger uidCounter = new AtomicInteger(0);
        Thread[] writeThreads = new Thread[4];
        long start = System.currentTimeMillis();
        for (t2 = 0; t2 < writeThreads.length; ++t2) {
            writeThreads[t2] = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int r = 0; r < 100; ++r) {
                        TitanTransaction tx = TitanGraphPerformanceMemoryTest.this.graph.newTransaction();
                        TitanVertex previous = null;
                        for (int c = 0; c < 1500; ++c) {
                            TitanVertex v = tx.addVertex(new Object[0]);
                            long uid = uidCounter.incrementAndGet();
                            v.property(VertexProperty.Cardinality.single, "uid", (Object)uid, new Object[0]);
                            v.property(VertexProperty.Cardinality.single, "name", (Object)("user" + uid), new Object[0]);
                            if (previous != null) {
                                v.addEdge("friend", (Vertex)previous, new Object[]{"time", Math.abs(random.nextInt())});
                            }
                            previous = v;
                        }
                        tx.commit();
                    }
                }
            });
            writeThreads[t2].start();
        }
        for (t2 = 0; t2 < writeThreads.length; ++t2) {
            writeThreads[t2].join();
        }
        System.out.println("Write time for " + 150000 * writeThreads.length + " vertices & edges: " + (System.currentTimeMillis() - start));
        final int maxUID = uidCounter.get();
        int trials = 1000;
        String fixedName = "john";
        Thread[] readThreads = new Thread[Runtime.getRuntime().availableProcessors() * 2];
        start = System.currentTimeMillis();
        for (t = 0; t < readThreads.length; ++t) {
            readThreads[t] = new Thread(new Runnable(){

                @Override
                public void run() {
                    TitanTransaction tx = TitanGraphPerformanceMemoryTest.this.graph.newTransaction();
                    long ruid = random.nextInt(maxUID) + 1;
                    TitanGraphBaseTest.getVertex(tx, "uid", (Object)ruid).property(VertexProperty.Cardinality.single, "name", (Object)"john", new Object[0]);
                    for (int t = 1; t <= 1000; ++t) {
                        TitanVertex v = TitanGraphBaseTest.getVertex(tx, "uid", (Object)(random.nextInt(maxUID) + 1));
                        TitanAssert.assertCount(2L, v.properties(new String[0]));
                        int count = 0;
                        for (TitanEdge e : v.query().direction(Direction.BOTH).edges()) {
                            ++count;
                            Assert.assertTrue(((Integer)e.value("time") >= 0 ? 1 : 0) != 0);
                        }
                        Assert.assertTrue((count <= 2 ? 1 : 0) != 0);
                    }
                    Assert.assertEquals((Object)"john", (Object)TitanGraphBaseTest.getVertex(tx, "uid", (Object)ruid).value("name"));
                    tx.commit();
                }
            });
            readThreads[t].start();
        }
        for (t = 0; t < readThreads.length; ++t) {
            readThreads[t].join();
        }
        System.out.println("Read time for " + 1000 * readThreads.length + " vertex lookups: " + (System.currentTimeMillis() - start));
    }
}

