/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.example.GraphOfTheGodsFactory;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.TitanIndexTest;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONReader;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONWriter;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class TitanIoTest
extends TitanGraphBaseTest {
    private GeometryFactory gf;
    private Function<Geoshape, Geoshape> makePoly = place -> {
        double x = Math.floor(place.getPoint().getLongitude());
        double y = Math.floor(place.getPoint().getLatitude());
        return Geoshape.polygon((double[])new double[]{x, y, x, y + 1.0, x + 1.0, y + 1.0, x + 1.0, y, x, y, x, y});
    };
    private Function<Geoshape, Geoshape> makeLine = place -> {
        double x = Math.floor(place.getPoint().getLongitude());
        double y = Math.floor(place.getPoint().getLatitude());
        return Geoshape.line((double[])new double[]{x, y, x, y + 1.0, x + 1.0, y + 1.0, x + 1.0, y});
    };
    private Function<Geoshape, Geoshape> makeMultiPoint = place -> {
        double x = Math.floor(place.getPoint().getLongitude());
        double y = Math.floor(place.getPoint().getLatitude());
        return Geoshape.geoshape((Geometry)this.gf.createMultiPoint(new Coordinate[]{new Coordinate(x, y), new Coordinate(x + 1.0, y + 1.0)}));
    };
    private Function<Geoshape, Geoshape> makeMultiLine = place -> {
        double x = Math.floor(place.getPoint().getLongitude());
        double y = Math.floor(place.getPoint().getLatitude());
        return Geoshape.geoshape((Geometry)this.gf.createMultiLineString(new LineString[]{this.gf.createLineString(new Coordinate[]{new Coordinate(x, y), new Coordinate(x + 1.0, y + 1.0)}), this.gf.createLineString(new Coordinate[]{new Coordinate(x - 1.0, y - 1.0), new Coordinate(x, y)})}));
    };
    private Function<Geoshape, Geoshape> makeMultiPolygon = place -> {
        double x = Math.floor(place.getPoint().getLongitude());
        double y = Math.floor(place.getPoint().getLatitude());
        return Geoshape.geoshape((Geometry)this.gf.createMultiPolygon(new Polygon[]{this.gf.createPolygon(new Coordinate[]{new Coordinate(x, y), new Coordinate(x + 1.0, y), new Coordinate(x + 1.0, y + 1.0), new Coordinate(x, y)}), this.gf.createPolygon(new Coordinate[]{new Coordinate(x + 2.0, y + 2.0), new Coordinate(x + 2.0, y + 3.0), new Coordinate(x + 3.0, y + 3.0), new Coordinate(x + 2.0, y + 2.0)})}));
    };

    @Before
    public void setup() {
        this.gf = new GeometryFactory();
        GraphOfTheGodsFactory.loadWithoutMixedIndex((TitanGraph)this.graph, (boolean)true);
        TitanManagement mgmt = this.graph.openManagement();
        mgmt.makePropertyKey("shape").dataType(Geoshape.class).make();
        mgmt.commit();
    }

    @Test
    public void testSerializationReadWriteAsGraphSONEmbedded() throws Exception {
        this.testSerializationReadWriteAsGraphSONEmbedded(null);
        this.testSerializationReadWriteAsGraphSONEmbedded(this.makeLine);
        this.testSerializationReadWriteAsGraphSONEmbedded(this.makePoly);
        this.testSerializationReadWriteAsGraphSONEmbedded(this.makeMultiPoint);
        this.testSerializationReadWriteAsGraphSONEmbedded(this.makeMultiLine);
        this.testSerializationReadWriteAsGraphSONEmbedded(this.makeMultiPolygon);
    }

    @Test
    public void testSerializationReadWriteAsGryo() throws Exception {
        this.testSerializationReadWriteAsGryo(null);
        this.testSerializationReadWriteAsGryo(this.makeLine);
        this.testSerializationReadWriteAsGryo(this.makePoly);
        this.testSerializationReadWriteAsGryo(this.makeMultiPoint);
        this.testSerializationReadWriteAsGryo(this.makeMultiLine);
        this.testSerializationReadWriteAsGryo(this.makeMultiPolygon);
    }

    public void testSerializationReadWriteAsGraphSONEmbedded(Function<Geoshape, Geoshape> makeGeoshape) throws Exception {
        if (makeGeoshape != null) {
            this.addGeoshape(makeGeoshape);
        }
        GraphSONMapper m = ((GraphSONIo)this.graph.io(IoCore.graphson())).mapper().embedTypes(true).create();
        GraphSONWriter writer = ((GraphSONIo)this.graph.io(IoCore.graphson())).writer().mapper((Mapper)m).create();
        FileOutputStream fos = new FileOutputStream("/tmp/test.json");
        writer.writeGraph((OutputStream)fos, (Graph)this.graph);
        TitanIoTest.clearGraph(this.config);
        this.open(this.config);
        GraphSONReader reader = ((GraphSONIo)this.graph.io(IoCore.graphson())).reader().mapper((Mapper)m).create();
        FileInputStream fis = new FileInputStream("/tmp/test.json");
        reader.readGraph((InputStream)fis, (Graph)this.graph);
        TitanIndexTest.assertGraphOfTheGods((TitanGraph)this.graph);
        if (makeGeoshape != null) {
            this.assertGeoshape(makeGeoshape);
        }
    }

    private void testSerializationReadWriteAsGryo(Function<Geoshape, Geoshape> makeGeoshape) throws Exception {
        if (makeGeoshape != null) {
            this.addGeoshape(makeGeoshape);
        }
        ((GryoIo)this.graph.io(IoCore.gryo())).writeGraph("/tmp/test.kryo");
        TitanIoTest.clearGraph(this.config);
        this.open(this.config);
        ((GryoIo)this.graph.io(IoCore.gryo())).readGraph("/tmp/test.kryo");
        TitanIndexTest.assertGraphOfTheGods((TitanGraph)this.graph);
        if (makeGeoshape != null) {
            this.assertGeoshape(makeGeoshape);
        }
    }

    private void addGeoshape(Function<Geoshape, Geoshape> makeGeoshape) {
        TitanTransaction tx = this.graph.newTransaction();
        this.graph.traversal().E(new Object[0]).has("place").toList().stream().forEach(e -> {
            Geoshape place = (Geoshape)e.property("place").value();
            e.property("shape", makeGeoshape.apply(place));
        });
        tx.commit();
    }

    private void assertGeoshape(Function<Geoshape, Geoshape> makeGeoshape) {
        this.graph.traversal().E(new Object[0]).has("place").toList().stream().forEach(e -> {
            Assert.assertTrue((boolean)e.property("shape").isPresent());
            Geoshape place = (Geoshape)e.property("place").value();
            Geoshape expected = (Geoshape)makeGeoshape.apply(place);
            Geoshape actual = (Geoshape)e.property("shape").value();
            Assert.assertEquals((Object)expected, (Object)actual);
        });
    }
}

