/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricFilter;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanGraphTransaction;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanSchemaElement;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.util.CacheMetricsAction;
import com.thinkaurelius.titan.diskstorage.util.MetricInstrumentedStore;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertexLabel;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.types.CompositeIndexType;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.testcategory.SerialTests;
import com.thinkaurelius.titan.testutil.TitanAssert;
import com.thinkaurelius.titan.util.stats.MetricManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SerialTests.class})
public abstract class TitanOperationCountingTest
extends TitanGraphBaseTest {
    public MetricManager metric;
    public final String SYSTEM_METRICS = "com.thinkaurelius.titan.sys";
    private String metricsPrefix;

    public abstract WriteConfiguration getBaseConfiguration();

    public abstract boolean storeUsesConsistentKeyLocker();

    @Override
    public WriteConfiguration getConfiguration() {
        WriteConfiguration config = this.getBaseConfiguration();
        ModifiableConfiguration mconf = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, config, BasicConfiguration.Restriction.NONE);
        mconf.set(GraphDatabaseConfiguration.BASIC_METRICS, (Object)true, new String[0]);
        mconf.set(GraphDatabaseConfiguration.METRICS_MERGE_STORES, (Object)false, new String[0]);
        mconf.set(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (Object)false, new String[0]);
        mconf.set(GraphDatabaseConfiguration.DB_CACHE, (Object)false, new String[0]);
        return config;
    }

    @Override
    public void open(WriteConfiguration config) {
        this.metric = MetricManager.INSTANCE;
        super.open(config);
    }

    private void verifyLockingOverwrite(String storeName, long num) {
        if (this.storeUsesConsistentKeyLocker()) {
            this.verifyStoreMetrics(storeName, (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)(2L * num)));
            this.verifyStoreMetrics(storeName + "_lock_", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)num, (Object)"mutate", (Object)(2L * num)));
        } else {
            this.verifyStoreMetrics(storeName, (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)num, (Object)"acquireLock", (Object)num));
        }
    }

    @Test
    public void testIdCounts() {
        this.makeVertexIndexedUniqueKey("uid", Integer.class);
        this.mgmt.setConsistency((TitanSchemaElement)this.mgmt.getGraphIndex("uid"), ConsistencyModifier.LOCK);
        this.finishSchema();
        this.verifyStoreMetrics("titan_ids", "com.thinkaurelius.titan.sys", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)3L, (Object)"getSlice", (Object)6L));
    }

    @Test
    public void testReadOperations() {
        this.testReadOperations(false);
    }

    @Test
    public void testReadOperationsWithCache() {
        this.testReadOperations(true);
    }

    public void testReadOperations(boolean cache) {
        this.metricsPrefix = "testReadOperations" + cache;
        this.resetEdgeCacheCounts();
        this.makeVertexIndexedUniqueKey("uid", Integer.class);
        this.mgmt.setConsistency((TitanSchemaElement)this.mgmt.getGraphIndex("uid"), ConsistencyModifier.LOCK);
        this.finishSchema();
        if (cache) {
            this.clopen(TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE, new String[0]), true, TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_CLEAN_WAIT, new String[0]), 0, TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_TIME, new String[0]), 0);
        } else {
            this.clopen(new Object[0]);
        }
        TitanTransaction tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        tx.makePropertyKey("name").dataType(String.class).make();
        tx.makeEdgeLabel("knows").make();
        tx.makeVertexLabel("person").make();
        tx.commit();
        this.verifyStoreMetrics("edgestore");
        this.verifyLockingOverwrite("graphindex", 3L);
        this.verifyStoreMetrics("storeManager", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)1L));
        this.resetMetrics();
        this.metricsPrefix = "com.thinkaurelius.titan.sys.schema";
        this.resetMetrics();
        for (int t = 0; t < 10; ++t) {
            tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
            Assert.assertTrue((boolean)tx.containsRelationType("name"));
            Assert.assertTrue((boolean)tx.containsRelationType("knows"));
            Assert.assertTrue((boolean)tx.containsVertexLabel("person"));
            PropertyKey name = tx.getPropertyKey("name");
            EdgeLabel knows = tx.getEdgeLabel("knows");
            VertexLabel person = tx.getVertexLabel("person");
            PropertyKey uid = tx.getPropertyKey("uid");
            Assert.assertEquals((Object)"name", (Object)name.name());
            Assert.assertEquals((Object)"knows", (Object)knows.name());
            Assert.assertEquals((Object)"person", (Object)person.name());
            Assert.assertEquals((Object)"uid", (Object)uid.name());
            Assert.assertEquals((Object)Cardinality.SINGLE, (Object)name.cardinality());
            Assert.assertEquals((Object)Multiplicity.MULTI, (Object)knows.multiplicity());
            Assert.assertFalse((boolean)person.isPartitioned());
            Assert.assertEquals(Integer.class, (Object)uid.dataType());
            InternalRelationType namei = (InternalRelationType)name;
            InternalRelationType knowsi = (InternalRelationType)knows;
            InternalRelationType uidi = (InternalRelationType)uid;
            Assert.assertNull((Object)namei.getBaseType());
            Assert.assertNull((Object)knowsi.getBaseType());
            IndexType index = (IndexType)Iterables.getOnlyElement((Iterable)uidi.getKeyIndexes());
            Assert.assertEquals((long)1L, (long)index.getFieldKeys().length);
            Assert.assertEquals((Object)ElementCategory.VERTEX, (Object)index.getElement());
            Assert.assertEquals((Object)ConsistencyModifier.LOCK, (Object)((CompositeIndexType)index).getConsistencyModifier());
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)uidi.getRelationIndexes()));
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)namei.getRelationIndexes()));
            Assert.assertEquals((Object)namei, (Object)Iterables.getOnlyElement((Iterable)namei.getRelationIndexes()));
            Assert.assertEquals((Object)knowsi, (Object)Iterables.getOnlyElement((Iterable)knowsi.getRelationIndexes()));
            Assert.assertEquals((long)0L, (long)((InternalVertexLabel)person).getTTL());
            tx.commit();
            this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)19L));
            this.verifyStoreMetrics("graphindex", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)4L, (Object)"acquireLock", (Object)0L));
        }
        this.metricsPrefix = "add" + cache;
        tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        TitanVertex v = tx.addVertex(new Object[0]);
        TitanVertex u = tx.addVertex("person");
        v.property(VertexProperty.Cardinality.single, "uid", (Object)1, new Object[0]);
        u.property(VertexProperty.Cardinality.single, "name", (Object)"juju", new Object[0]);
        TitanEdge e = v.addEdge("knows", (Vertex)u, new Object[0]);
        e.property("name", (Object)"edge");
        tx.commit();
        this.verifyStoreMetrics("edgestore");
        this.verifyLockingOverwrite("graphindex", 1L);
        for (int i = 1; i <= 30; ++i) {
            this.metricsPrefix = "op" + i + cache;
            tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
            v = (TitanVertex)TitanOperationCountingTest.getOnlyElement(tx.query().has("uid", (Object)1).vertices());
            Assert.assertEquals((long)1L, (long)((Integer)v.value("uid")).intValue());
            u = (TitanVertex)TitanOperationCountingTest.getOnlyElement(v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).vertices());
            e = (Edge)TitanOperationCountingTest.getOnlyElement(u.query().direction(Direction.IN).labels(new String[]{"knows"}).edges());
            Assert.assertEquals((Object)"juju", (Object)u.value("name"));
            Assert.assertEquals((Object)"edge", (Object)e.value("name"));
            tx.commit();
            if (!cache || i == 0) {
                this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)4L));
                this.verifyStoreMetrics("graphindex", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)1L));
                continue;
            }
            if (!cache || i <= 20) continue;
            this.verifyStoreMetrics("edgestore");
            this.verifyStoreMetrics("graphindex");
        }
    }

    @Test
    public void testSettingProperty() throws Exception {
        this.metricsPrefix = "testSettingProperty";
        this.mgmt.makePropertyKey("foo").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.finishSchema();
        TitanVertex v = this.tx.addVertex(new Object[0]);
        v.property("foo", (Object)"bar");
        this.tx.commit();
        TitanTransaction tx = this.graph.buildTransaction().checkExternalVertexExistence(false).groupName(this.metricsPrefix).start();
        v = tx.getVertex(v.longId());
        v.property("foo", (Object)"bus");
        tx.commit();
        this.verifyStoreMetrics("edgestore");
        this.verifyStoreMetrics("graphindex");
        this.verifyStoreMetrics("storeManager", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)1L));
        tx = this.graph.buildTransaction().checkExternalVertexExistence(false).groupName(this.metricsPrefix).start();
        v = tx.getVertex(v.longId());
        v.property("foo", (Object)"band");
        Assert.assertEquals((Object)"band", (Object)v.property("foo").value());
        Assert.assertEquals((long)1L, (long)Iterators.size((Iterator)v.properties(new String[]{"foo"})));
        Assert.assertEquals((long)1L, (long)Iterators.size((Iterator)v.properties(new String[0])));
        tx.commit();
        this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)2L));
        this.verifyStoreMetrics("graphindex");
        this.verifyStoreMetrics("storeManager", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)2L));
        this.verifyStoreMetrics("titan_ids");
    }

    @Test
    public void testKCVSAccess1() throws InterruptedException {
        this.metricsPrefix = "testKCVSAccess1";
        TitanTransaction tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        TitanVertex v = tx.addVertex(new Object[]{"age", 25, "name", "john"});
        TitanVertex u = tx.addVertex(new Object[]{"age", 35, "name", "mary"});
        v.addEdge("knows", (Vertex)u, new Object[0]);
        tx.commit();
        this.verifyStoreMetrics("edgestore");
        this.verifyLockingOverwrite("graphindex", 3L);
        this.verifyStoreMetrics("storeManager", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)(1L + (long)(this.features.hasTxIsolation() ? 0 : 1))));
        this.verifyTypeCacheMetrics(3, 0);
        tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        v = TitanOperationCountingTest.getV((TitanGraphTransaction)tx, v);
        TitanAssert.assertCount(2L, v.properties(new String[0]));
        this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)2L));
        this.verifyTypeCacheMetrics(3, 4);
        tx.commit();
        tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        v = TitanOperationCountingTest.getV((TitanGraphTransaction)tx, v);
        TitanAssert.assertCount(2L, v.properties(new String[0]));
        this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)4L));
        this.verifyTypeCacheMetrics(3, 4);
        tx.commit();
        tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        v = TitanOperationCountingTest.getV((TitanGraphTransaction)tx, v);
        Assert.assertNotNull((Object)v.value("age"));
        Assert.assertNotNull((Object)v.value("name"));
        this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)7L));
        this.verifyTypeCacheMetrics(5, 8);
        tx.commit();
        tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        v = TitanOperationCountingTest.getV((TitanGraphTransaction)tx, v);
        Assert.assertNotNull((Object)v.value("age"));
        Assert.assertNotNull((Object)v.value("name"));
        TitanAssert.assertCount(1L, v.query().direction(Direction.BOTH).edges());
        this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)11L));
        this.verifyTypeCacheMetrics(5, 10);
        tx.commit();
        this.verifyLockingOverwrite("graphindex", 3L);
        this.verifyStoreMetrics("storeManager", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)(1L + (long)(this.features.hasTxIsolation() ? 0 : 1))));
    }

    @Test
    public void checkPropertyLockingAndIndex() {
        PropertyKey uid = this.makeKey("uid", String.class);
        TitanGraphIndex index = this.mgmt.buildIndex("uid", Vertex.class).unique().addKey(uid).buildCompositeIndex();
        this.mgmt.setConsistency((TitanSchemaElement)index, ConsistencyModifier.LOCK);
        this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.mgmt.makePropertyKey("age").dataType(Integer.class).make();
        this.finishSchema();
        this.metricsPrefix = "checkPropertyLockingAndIndex";
        TitanTransaction tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        TitanVertex v = tx.addVertex(new Object[]{"uid", "v1", "age", 25, "name", "john"});
        Assert.assertEquals((Object)25, (Object)v.property("age").value());
        tx.commit();
        this.verifyStoreMetrics("edgestore");
        this.verifyLockingOverwrite("graphindex", 1L);
        this.verifyStoreMetrics("storeManager", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)1L));
        this.resetMetrics();
        tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        v = (TitanVertex)Iterables.getOnlyElement((Iterable)tx.query().has("uid", (TitanPredicate)Cmp.EQUAL, (Object)"v1").vertices());
        Assert.assertEquals((Object)25, (Object)v.property("age").value());
        tx.commit();
        this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)1L));
        this.verifyStoreMetrics("graphindex", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)1L));
        this.verifyStoreMetrics("storeManager");
    }

    @Test
    public void checkFastPropertyTrue() {
        this.checkFastProperty(true);
    }

    @Test
    public void checkFastPropertyFalse() {
        this.checkFastProperty(false);
    }

    public void checkFastProperty(boolean fastProperty) {
        this.makeKey("uid", String.class);
        this.makeKey("name", String.class);
        this.makeKey("age", String.class);
        this.finishSchema();
        this.clopen(TitanOperationCountingTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), fastProperty);
        this.metricsPrefix = "checkFastProperty" + fastProperty;
        TitanTransaction tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        TitanVertex v = tx.addVertex(new Object[]{"uid", "v1", "age", 25, "name", "john"});
        tx.commit();
        this.verifyStoreMetrics("edgestore");
        this.verifyStoreMetrics("graphindex");
        this.verifyStoreMetrics("storeManager", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)1L));
        tx = this.graph.buildTransaction().groupName(this.metricsPrefix).start();
        v = TitanOperationCountingTest.getV((TitanGraphTransaction)tx, v);
        Assert.assertEquals((Object)"v1", (Object)v.property("uid").value());
        Assert.assertEquals((Object)"25", (Object)v.property("age").value());
        Assert.assertEquals((Object)"john", (Object)v.property("name").value());
        tx.commit();
        if (fastProperty) {
            this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)2L));
        } else {
            this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)4L));
        }
        this.verifyStoreMetrics("graphindex");
        this.verifyStoreMetrics("storeManager", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)1L));
    }

    public void verifyStoreMetrics(String storeName) {
        this.verifyStoreMetrics(storeName, new HashMap<String, Long>(0));
    }

    public void verifyStoreMetrics(String storeName, Map<String, Long> operationCounts) {
        this.verifyStoreMetrics(storeName, this.metricsPrefix, operationCounts);
    }

    public void verifyStoreMetrics(String storeName, String prefix, Map<String, Long> operationCounts) {
        for (String operation : MetricInstrumentedStore.OPERATION_NAMES) {
            Long count = operationCounts.get(operation);
            if (count == null) {
                count = 0L;
            }
            Assert.assertEquals((String)Joiner.on((String)".").join((Object)prefix, (Object)storeName, new Object[]{operation, "calls"}), (long)count, (long)this.metric.getCounter(prefix, new String[]{storeName, operation, "calls"}).getCount());
        }
    }

    public void verifyTypeCacheMetrics(int nameMisses, int relationMisses) {
        this.verifyTypeCacheMetrics(this.metricsPrefix, nameMisses, relationMisses);
    }

    public void verifyTypeCacheMetrics(String prefix, int nameMisses, int relationMisses) {
        Assert.assertEquals((String)"On type cache name misses", (long)nameMisses, (long)this.metric.getCounter("com.thinkaurelius.titan.sys", new String[]{"schemacache", "name", CacheMetricsAction.MISS.getName()}).getCount());
        Assert.assertTrue(((long)nameMisses <= this.metric.getCounter("com.thinkaurelius.titan.sys", new String[]{"schemacache", "name", CacheMetricsAction.RETRIEVAL.getName()}).getCount() ? 1 : 0) != 0);
        Assert.assertEquals((String)"On type cache relation misses", (long)relationMisses, (long)this.metric.getCounter("com.thinkaurelius.titan.sys", new String[]{"schemacache", "relations", CacheMetricsAction.MISS.getName()}).getCount());
        Assert.assertTrue(((long)relationMisses <= this.metric.getCounter("com.thinkaurelius.titan.sys", new String[]{"schemacache", "relations", CacheMetricsAction.RETRIEVAL.getName()}).getCount() ? 1 : 0) != 0);
    }

    public void printAllMetrics() {
        this.printAllMetrics(this.metricsPrefix);
    }

    public void printAllMetrics(String prefix) {
        ArrayList<String> storeNames = new ArrayList<String>();
        storeNames.add("edgestore");
        storeNames.add("graphindex");
        storeNames.add("titan_ids");
        storeNames.add("storeManager");
        if (this.storeUsesConsistentKeyLocker()) {
            storeNames.add("edgestore_lock_");
            storeNames.add("graphindex_lock_");
        }
        for (String store : storeNames) {
            System.out.println("######## Store: " + store + " (" + prefix + ")");
            for (String operation : MetricInstrumentedStore.OPERATION_NAMES) {
                System.out.println("-- Operation: " + operation);
                System.out.print("\t");
                System.out.println(this.metric.getCounter(prefix, new String[]{store, operation, "calls"}).getCount());
                System.out.print("\t");
                System.out.println(this.metric.getTimer(prefix, new String[]{store, operation, "time"}).getMeanRate());
                if (operation != "getSlice") continue;
                System.out.print("\t");
                System.out.println(this.metric.getCounter(prefix, new String[]{store, operation, "entries-returned"}).getCount());
            }
        }
    }

    @Test
    public void testCacheConcurrency() throws InterruptedException {
        this.metricsPrefix = "tCC";
        Object[] newConfig = new Object[]{TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE, new String[0]), true, TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_TIME, new String[0]), 0, TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_CLEAN_WAIT, new String[0]), 0, TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_SIZE, new String[0]), 0.25, TitanOperationCountingTest.option(GraphDatabaseConfiguration.BASIC_METRICS, new String[0]), true, TitanOperationCountingTest.option(GraphDatabaseConfiguration.METRICS_MERGE_STORES, new String[0]), false, TitanOperationCountingTest.option(GraphDatabaseConfiguration.METRICS_PREFIX, new String[0]), this.metricsPrefix};
        this.clopen(newConfig);
        String prop = "someProp";
        this.makeKey("someProp", Integer.class);
        this.finishSchema();
        int numV = 100;
        final long[] vids = new long[100];
        for (int i = 0; i < 100; ++i) {
            TitanVertex v = this.graph.addVertex(new Object[]{"someProp", 0});
            this.graph.tx().commit();
            vids[i] = TitanOperationCountingTest.getId((Element)v);
        }
        this.clopen(newConfig);
        this.resetEdgeCacheCounts();
        final AtomicBoolean[] precommit = new AtomicBoolean[100];
        final AtomicBoolean[] postcommit = new AtomicBoolean[100];
        for (int i = 0; i < 100; ++i) {
            precommit[i] = new AtomicBoolean(false);
            postcommit[i] = new AtomicBoolean(false);
        }
        final AtomicInteger lookups = new AtomicInteger(0);
        final Random random = new Random();
        int updateSleepTime = 40;
        int readSleepTime = 2;
        final int numReads = Math.round(4000.0f);
        Thread reader = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int reads = 0; reads < numReads; ++reads) {
                    int pos = random.nextInt(vids.length);
                    long vid = vids[pos];
                    TitanVertex v = TitanGraphBaseTest.getV((TitanGraphTransaction)TitanOperationCountingTest.this.graph, vid);
                    Assert.assertNotNull((Object)v);
                    boolean postCommit = postcommit[pos].get();
                    Integer value = (Integer)v.value("someProp");
                    lookups.incrementAndGet();
                    Assert.assertNotNull((String)("On pos [" + pos + "]"), (Object)value);
                    if (!precommit[pos].get()) {
                        Assert.assertEquals((long)0L, (long)value.intValue());
                    } else if (postCommit) {
                        Assert.assertEquals((long)1L, (long)value.intValue());
                    }
                    TitanOperationCountingTest.this.graph.tx().commit();
                    try {
                        Thread.sleep(2L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        });
        reader.start();
        Thread updater = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 100; ++i) {
                    try {
                        TitanVertex v = TitanGraphBaseTest.getV((TitanGraphTransaction)TitanOperationCountingTest.this.graph, vids[i]);
                        v.property(VertexProperty.Cardinality.single, "someProp", (Object)1, new Object[0]);
                        precommit[i].set(true);
                        TitanOperationCountingTest.this.graph.tx().commit();
                        postcommit[i].set(true);
                        Thread.sleep(40L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Unexpected interruption", e);
                    }
                }
            }
        });
        updater.start();
        updater.join();
        reader.join();
        System.out.println("Retrievals: " + this.getEdgeCacheRetrievals());
        System.out.println("Hits: " + (this.getEdgeCacheRetrievals() - this.getEdgeCacheMisses()));
        System.out.println("Misses: " + this.getEdgeCacheMisses());
        Assert.assertEquals((long)numReads, (long)lookups.get());
        Assert.assertEquals((long)(2 * numReads + 100), (long)this.getEdgeCacheRetrievals());
        int minMisses = 200;
        Assert.assertTrue((String)("Min misses [" + minMisses + "] vs actual [" + this.getEdgeCacheMisses() + "]"), ((long)minMisses <= this.getEdgeCacheMisses() && (long)(4 * minMisses) >= this.getEdgeCacheMisses() ? 1 : 0) != 0);
    }

    private long getEdgeCacheRetrievals() {
        return this.metric.getCounter(this.metricsPrefix, new String[]{"edgestore.cache", CacheMetricsAction.RETRIEVAL.getName()}).getCount();
    }

    private long getEdgeCacheMisses() {
        return this.metric.getCounter(this.metricsPrefix, new String[]{"edgestore.cache", CacheMetricsAction.MISS.getName()}).getCount();
    }

    private void resetEdgeCacheCounts() {
        Counter counter = this.metric.getCounter(this.metricsPrefix, new String[]{"edgestore.cache", CacheMetricsAction.RETRIEVAL.getName()});
        counter.dec(counter.getCount());
        counter = this.metric.getCounter(this.metricsPrefix, new String[]{"edgestore.cache", CacheMetricsAction.MISS.getName()});
        counter.dec(counter.getCount());
    }

    private void resetMetrics() {
        MetricManager.INSTANCE.getRegistry().removeMatching(MetricFilter.ALL);
    }

    @Test
    public void testCacheSpeedup() {
        Object[] newConfig = new Object[]{TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE, new String[0]), true, TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_TIME, new String[0]), 0};
        this.clopen(newConfig);
        int numV = 1000;
        TitanVertex previous = null;
        for (int i = 0; i < numV; ++i) {
            TitanVertex v = this.graph.addVertex(new Object[]{"name", "v" + i});
            if (previous != null) {
                v.addEdge("knows", (Vertex)previous, new Object[0]);
            }
            previous = v;
        }
        this.graph.tx().commit();
        long vertexId = TitanOperationCountingTest.getId(previous);
        TitanAssert.assertCount(numV, this.graph.query().vertices());
        this.clopen(newConfig);
        double timecoldglobal = 0.0;
        double timewarmglobal = 0.0;
        double timehotglobal = 0.0;
        int outerRepeat = 20;
        int measurements = 10;
        Assert.assertTrue((measurements < outerRepeat ? 1 : 0) != 0);
        int innerRepeat = 2;
        for (int c = 0; c < outerRepeat; ++c) {
            double timecold = this.testAllVertices(vertexId, numV);
            double timewarm = 0.0;
            double timehot = 0.0;
            for (int i = 0; i < innerRepeat; ++i) {
                this.graph.tx().commit();
                timewarm += this.testAllVertices(vertexId, numV);
                for (int j = 0; j < innerRepeat; ++j) {
                    timehot += this.testAllVertices(vertexId, numV);
                }
            }
            timewarm /= (double)innerRepeat;
            timehot /= (double)(innerRepeat * innerRepeat);
            if (c >= outerRepeat - measurements) {
                timecoldglobal += timecold;
                timewarmglobal += timewarm;
                timehotglobal += timehot;
            }
            this.clopen(newConfig);
        }
        System.out.println(TitanOperationCountingTest.round(timecoldglobal /= (double)measurements) + "\t" + TitanOperationCountingTest.round(timewarmglobal /= (double)measurements) + "\t" + TitanOperationCountingTest.round(timehotglobal /= (double)measurements));
        Assert.assertTrue((String)(timecoldglobal + " vs " + timewarmglobal), (timecoldglobal > timewarmglobal * 2.0 ? 1 : 0) != 0);
    }

    private double testAllVertices(long vid, int numV) {
        long start = System.nanoTime();
        TitanVertex v = TitanOperationCountingTest.getV((TitanGraphTransaction)this.graph, vid);
        for (int i = 1; i < numV; ++i) {
            v = (TitanVertex)TitanOperationCountingTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"knows"}).vertices());
        }
        return (double)(System.nanoTime() - start) / 1000000.0;
    }
}

