/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.olap;

import com.thinkaurelius.titan.olap.ShortestDistanceMessageCombiner;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageCombiner;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.util.AbstractVertexProgramBuilder;
import org.apache.tinkerpop.gremlin.process.computer.util.StaticVertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortestDistanceVertexProgram
extends StaticVertexProgram<Long> {
    private static final Logger log = LoggerFactory.getLogger(ShortestDistanceVertexProgram.class);
    private MessageScope.Local<Long> incidentMessageScope;
    public static final String DISTANCE = "titan.shortestDistanceVertexProgram.distance";
    public static final String MAX_DEPTH = "titan.shortestDistanceVertexProgram.maxDepth";
    public static final String WEIGHT_PROPERTY = "titan.shortestDistanceVertexProgram.weightProperty";
    public static final String SEED = "titan.shortestDistanceVertexProgram.seedID";
    private int maxDepth;
    private long seed;
    private String weightProperty;
    private static final Set<VertexComputeKey> COMPUTE_KEYS = new HashSet<VertexComputeKey>(Arrays.asList(VertexComputeKey.of((String)"titan.shortestDistanceVertexProgram.distance", (boolean)false)));

    private ShortestDistanceVertexProgram() {
    }

    public void loadState(Graph graph, Configuration configuration) {
        this.maxDepth = configuration.getInt(MAX_DEPTH);
        this.seed = configuration.getLong(SEED);
        this.weightProperty = configuration.getString(WEIGHT_PROPERTY, "distance");
        this.incidentMessageScope = MessageScope.Local.of(() -> __.inE((String[])new String[0]), (msg, edge) -> msg + (long)((Integer)edge.value(this.weightProperty)).intValue());
        log.debug("Loaded maxDepth={}", (Object)this.maxDepth);
    }

    public void storeState(Configuration configuration) {
        configuration.setProperty("gremlin.vertexProgram", (Object)ShortestDistanceVertexProgram.class.getName());
        configuration.setProperty(MAX_DEPTH, (Object)this.maxDepth);
    }

    public Set<VertexComputeKey> getVertexComputeKeys() {
        return COMPUTE_KEYS;
    }

    public Optional<MessageCombiner<Long>> getMessageCombiner() {
        return ShortestDistanceMessageCombiner.instance();
    }

    public Set<MessageScope> getMessageScopes(Memory memory) {
        HashSet<MessageScope> set = new HashSet<MessageScope>();
        set.add((MessageScope)this.incidentMessageScope);
        return set;
    }

    public GraphComputer.ResultGraph getPreferredResultGraph() {
        return GraphComputer.ResultGraph.ORIGINAL;
    }

    public GraphComputer.Persist getPreferredPersist() {
        return GraphComputer.Persist.VERTEX_PROPERTIES;
    }

    public void setup(Memory memory) {
    }

    public void execute(Vertex vertex, Messenger<Long> messenger, Memory memory) {
        if (memory.isInitialIteration()) {
            if (vertex.id().equals(this.seed)) {
                log.debug("Sent initial message from {}", vertex.id());
                vertex.property(VertexProperty.Cardinality.single, DISTANCE, (Object)0L, new Object[0]);
                messenger.sendMessage(this.incidentMessageScope, (Object)0L);
            }
        } else {
            Iterator distances = messenger.receiveMessages();
            Long shortestDistanceSeenOnThisIteration = IteratorUtils.stream((Iterator)distances).reduce((a, b) -> Math.min(a, b)).orElse(null);
            if (null == shortestDistanceSeenOnThisIteration) {
                return;
            }
            VertexProperty currentShortestVP = vertex.property(DISTANCE);
            if (!currentShortestVP.isPresent() || (Long)currentShortestVP.value() > shortestDistanceSeenOnThisIteration) {
                vertex.property(VertexProperty.Cardinality.single, DISTANCE, (Object)shortestDistanceSeenOnThisIteration, new Object[0]);
                messenger.sendMessage(this.incidentMessageScope, (Object)shortestDistanceSeenOnThisIteration);
            }
        }
    }

    public boolean terminate(Memory memory) {
        return memory.getIteration() >= this.maxDepth;
    }

    public String toString() {
        return StringFactory.vertexProgramString((VertexProgram)this, (String)("maxDepth=" + this.maxDepth));
    }

    public static Builder build() {
        return new Builder();
    }

    public VertexProgram.Features getFeatures() {
        return new VertexProgram.Features(){

            public boolean requiresLocalMessageScopes() {
                return true;
            }

            public boolean requiresVertexPropertyAddition() {
                return true;
            }
        };
    }

    public static class Builder
    extends AbstractVertexProgramBuilder<Builder> {
        private Builder() {
            super(ShortestDistanceVertexProgram.class);
        }

        public Builder maxDepth(int maxDepth) {
            this.configuration.setProperty(ShortestDistanceVertexProgram.MAX_DEPTH, (Object)maxDepth);
            return this;
        }

        public Builder seed(long seed) {
            this.configuration.setProperty(ShortestDistanceVertexProgram.SEED, (Object)seed);
            return this;
        }
    }
}

