/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.testutil;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomGenerator {
    private static final Logger log = LoggerFactory.getLogger(RandomGenerator.class);
    private static final int standardLower = 7;
    private static final int standardUpper = 21;
    private static final Random random = new Random();

    public static String[] randomStrings(int number) {
        return RandomGenerator.randomStrings(number, 7, 21);
    }

    public static String[] randomStrings(int number, int lowerLen, int upperLen) {
        String[] ret = new String[number];
        for (int i = 0; i < number; ++i) {
            ret[i] = RandomGenerator.randomString(lowerLen, upperLen);
        }
        return ret;
    }

    public static String randomString() {
        return RandomGenerator.randomString(7, 21);
    }

    public static String randomString(int lowerLen, int upperLen) {
        assert (lowerLen > 0 && upperLen >= lowerLen);
        int length = RandomGenerator.randomInt(lowerLen, upperLen);
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            s.append((char)RandomGenerator.randomInt(97, 120));
        }
        return s.toString();
    }

    public static int randomInt(int lower, int upper) {
        assert (upper > lower);
        int interval = upper - lower;
        double rand = Math.floor(Math.random() * (double)interval) + (double)lower;
        if (rand >= (double)upper) {
            rand = upper - 1;
        }
        return (int)rand;
    }

    public static long randomLong(long lower, long upper) {
        assert (upper > lower);
        long interval = upper - lower;
        double rand = Math.floor(Math.random() * (double)interval) + (double)lower;
        if (rand >= (double)upper) {
            rand = upper - 1L;
        }
        return (long)rand;
    }

    @Test
    public void testRandomInt() {
        long sum = 0L;
        int trials = 100000;
        for (int i = 0; i < trials; ++i) {
            sum += (long)RandomGenerator.randomInt(1, 101);
        }
        double avg = (double)sum * 1.0 / (double)trials;
        double error = 5.0 / Math.pow(trials, 0.3);
        Assert.assertTrue((Math.abs(avg - 50.5) < error ? 1 : 0) != 0);
    }

    @Test
    public void testRandomLong() {
        long sum = 0L;
        int trials = 100000;
        for (int i = 0; i < trials; ++i) {
            sum += RandomGenerator.randomLong(1L, 101L);
        }
        double avg = (double)sum * 1.0 / (double)trials;
        double error = 5.0 / Math.pow(trials, 0.3);
        Assert.assertEquals((double)50.5, (double)avg, (double)error);
    }

    @Test
    public void testRandomString() {
        for (int i = 0; i < 20; ++i) {
            log.debug(RandomGenerator.randomString(5, 20));
        }
    }
}

