/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.testutil;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.junit.Assert;

public class TitanAssert {
    public static void assertCount(long expected, Object object) {
        Assert.assertEquals((long)expected, (long)TitanAssert.size(object));
    }

    public static <V extends Element> void assertEmpty(Object object) {
        Assert.assertTrue((boolean)TitanAssert.isEmpty(object));
    }

    public static <V extends Element> void assertNotEmpty(Object object) {
        Assert.assertFalse((boolean)TitanAssert.isEmpty(object));
    }

    public static int size(Object obj) {
        Preconditions.checkArgument((obj != null ? 1 : 0) != 0);
        if (obj instanceof Traversal) {
            return TitanAssert.size(((Traversal)obj).toList());
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Iterable) {
            return Iterables.size((Iterable)((Iterable)obj));
        }
        if (obj instanceof Iterator) {
            return Iterators.size((Iterator)((Iterator)obj));
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj);
        }
        throw new IllegalArgumentException("Cannot determine size of: " + obj);
    }

    public static boolean isEmpty(Object obj) {
        Preconditions.checkArgument((obj != null ? 1 : 0) != 0);
        if (obj instanceof Traversal) {
            return !((Traversal)obj).hasNext();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Iterable) {
            return Iterables.isEmpty((Iterable)((Iterable)obj));
        }
        if (obj instanceof Iterator) {
            return !((Iterator)obj).hasNext();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        throw new IllegalArgumentException("Cannot determine size of: " + obj);
    }
}

