// Compiled by ClojureScript 1.9.908 {}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.Uri');
goog.require('no.en.core');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__28335__auto__ = v;
if(cljs.core.truth_(and__28335__auto__)){
return (v > (0));
} else {
return and__28335__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(!(clojure.string.blank_QMARK_.call(null,s))){
return cljs.core.reduce.call(null,(function (p1__35427_SHARP_,p2__35426_SHARP_){
var vec__35428 = clojure.string.split.call(null,p2__35426_SHARP_,/=/);
var k = cljs.core.nth.call(null,vec__35428,(0),null);
var v = cljs.core.nth.call(null,vec__35428,(1),null);
return cljs.core.assoc.call(null,p1__35427_SHARP_,cljs.core.keyword.call(null,no.en.core.url_decode.call(null,k)),no.en.core.url_decode.call(null,v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(!(clojure.string.blank_QMARK_.call(null,url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"scheme","scheme",90199613),cljs.core.keyword.call(null,uri.getScheme()),new cljs.core.Keyword(null,"server-name","server-name",-1012104295),uri.getDomain(),new cljs.core.Keyword(null,"server-port","server-port",663745648),cljs_http.client.if_pos.call(null,uri.getPort()),new cljs.core.Keyword(null,"uri","uri",-774711847),uri.getPath(),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),((cljs.core.not.call(null,query_data.isEmpty()))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join(''):null),new cljs.core.Keyword(null,"query-params","query-params",900640534),((cljs.core.not.call(null,query_data.isEmpty()))?cljs_http.client.parse_query_params.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,cljs.core.name.call(null,k))),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p1__35431_SHARP_){
return cljs_http.client.encode_val.call(null,k,p1__35431_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__35432){
var vec__35433 = p__35432;
var k = cljs.core.nth.call(null,vec__35433,(0),null);
var v = cljs.core.nth.call(null,vec__35433,(1),null);
if(cljs.core.coll_QMARK_.call(null,v)){
return cljs_http.client.encode_vals.call(null,k,v);
} else {
return cljs_http.client.encode_val.call(null,k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap.call(null,esc_chars,cljs.core.map.call(null,((function (esc_chars){
return (function (p1__35436_SHARP_){
return ["\\",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__35436_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.call(null,cljs.core.str,cljs.core.replace.call(null,cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__28335__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"head","head",-771383919),request_method);
if(and__28335__auto__){
var and__28335__auto____$1 = cljs.core.not_EQ_.call(null,(204),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response));
if(and__28335__auto____$1){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,["(?i)",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs_http.client.escape_special.call(null,content_type))].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__28335__auto____$1;
}
} else {
return and__28335__auto__;
}
})())){
return cljs.core.update_in.call(null,response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669)], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"edn-params","edn-params",894273052).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/edn"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"edn-params","edn-params",894273052)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.pr_str.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__35437_SHARP_){
return cljs_http.client.decode_body.call(null,p1__35437_SHARP_,cljs.reader.read_string,"application/edn",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(var_args){
var args__29523__auto__ = [];
var len__29516__auto___35444 = arguments.length;
var i__29517__auto___35445 = (0);
while(true){
if((i__29517__auto___35445 < len__29516__auto___35444)){
args__29523__auto__.push((arguments[i__29517__auto___35445]));

var G__35446 = (i__29517__auto___35445 + (1));
i__29517__auto___35445 = G__35446;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__35440){
var vec__35441 = p__35440;
var default_headers = cljs.core.nth.call(null,vec__35441,(0),null);
return ((function (vec__35441,default_headers){
return (function (request){
var temp__4655__auto__ = (function (){var or__28347__auto__ = new cljs.core.Keyword(null,"default-headers","default-headers",-43146094).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var default_headers__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc.call(null,request,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094),default_headers__$1));
} else {
return client.call(null,request);
}
});
;})(vec__35441,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq35438){
var G__35439 = cljs.core.first.call(null,seq35438);
var seq35438__$1 = cljs.core.next.call(null,seq35438);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__35439,seq35438__$1);
});

cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(var_args){
var args__29523__auto__ = [];
var len__29516__auto___35453 = arguments.length;
var i__29517__auto___35454 = (0);
while(true){
if((i__29517__auto___35454 < len__29516__auto___35453)){
args__29523__auto__.push((arguments[i__29517__auto___35454]));

var G__35455 = (i__29517__auto___35454 + (1));
i__29517__auto___35454 = G__35455;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__35449){
var vec__35450 = p__35449;
var accept = cljs.core.nth.call(null,vec__35450,(0),null);
return ((function (vec__35450,accept){
return (function (request){
var temp__4655__auto__ = (function (){var or__28347__auto__ = new cljs.core.Keyword(null,"accept","accept",1874130431).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var accept__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"accept"], null),accept__$1));
} else {
return client.call(null,request);
}
});
;})(vec__35450,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq35447){
var G__35448 = cljs.core.first.call(null,seq35447);
var seq35447__$1 = cljs.core.next.call(null,seq35447);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__35448,seq35447__$1);
});

cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(var_args){
var args__29523__auto__ = [];
var len__29516__auto___35462 = arguments.length;
var i__29517__auto___35463 = (0);
while(true){
if((i__29517__auto___35463 < len__29516__auto___35462)){
args__29523__auto__.push((arguments[i__29517__auto___35463]));

var G__35464 = (i__29517__auto___35463 + (1));
i__29517__auto___35463 = G__35464;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__35458){
var vec__35459 = p__35458;
var content_type = cljs.core.nth.call(null,vec__35459,(0),null);
return ((function (vec__35459,content_type){
return (function (request){
var temp__4655__auto__ = (function (){var or__28347__auto__ = new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var content_type__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),content_type__$1));
} else {
return client.call(null,request);
}
});
;})(vec__35459,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq35456){
var G__35457 = cljs.core.first.call(null,seq35456);
var seq35456__$1 = cljs.core.next.call(null,seq35456);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__35457,seq35456__$1);
});

cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"decoding","decoding",-568180903),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140),cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 *   Content Type header.
 * 
 *   A :transit-opts map can be optionally provided with the following keys:
 * 
 *   :encoding                #{:json, :json-verbose}
 *   :decoding                #{:json, :json-verbose}
 *   :encoding/decoding-opts  appropriate map of options to be passed to
 *                         transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"transit-params","transit-params",357261095).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var map__35465 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__35465__$1 = ((((!((map__35465 == null)))?((((map__35465.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35465.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35465):map__35465);
var encoding = cljs.core.get.call(null,map__35465__$1,new cljs.core.Keyword(null,"encoding","encoding",1728578272));
var encoding_opts = cljs.core.get.call(null,map__35465__$1,new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631));
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/transit+json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"transit-params","transit-params",357261095)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.transit_encode.call(null,params,encoding,encoding_opts)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__35469 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__35469__$1 = ((((!((map__35469 == null)))?((((map__35469.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35469.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35469):map__35469);
var decoding = cljs.core.get.call(null,map__35469__$1,new cljs.core.Keyword(null,"decoding","decoding",-568180903));
var decoding_opts = cljs.core.get.call(null,map__35469__$1,new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140));
var transit_decode = ((function (map__35469,map__35469__$1,decoding,decoding_opts){
return (function (p1__35467_SHARP_){
return cljs_http.util.transit_decode.call(null,p1__35467_SHARP_,decoding,decoding_opts);
});})(map__35469,map__35469__$1,decoding,decoding_opts))
;
return cljs.core.async.map.call(null,((function (map__35469,map__35469__$1,decoding,decoding_opts,transit_decode){
return (function (p1__35468_SHARP_){
return cljs_http.client.decode_body.call(null,p1__35468_SHARP_,transit_decode,"application/transit+json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
});})(map__35469,map__35469__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"json-params","json-params",-1112693596).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"json-params","json-params",-1112693596)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.json_encode.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__35471_SHARP_){
return cljs_http.client.decode_body.call(null,p1__35471_SHARP_,cljs_http.util.json_decode,"application/json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__35472){
var map__35473 = p__35472;
var map__35473__$1 = ((((!((map__35473 == null)))?((((map__35473.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35473.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35473):map__35473);
var req = map__35473__$1;
var query_params = cljs.core.get.call(null,map__35473__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
if(cljs.core.truth_(query_params)){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"query-params","query-params",900640534)),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),cljs_http.client.generate_query_string.call(null,query_params)));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__35475){
var map__35476 = p__35475;
var map__35476__$1 = ((((!((map__35476 == null)))?((((map__35476.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35476.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35476):map__35476);
var request = map__35476__$1;
var form_params = cljs.core.get.call(null,map__35476__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
var request_method = cljs.core.get.call(null,map__35476__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.call(null,map__35476__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
if(cljs.core.truth_((function (){var and__28335__auto__ = form_params;
if(cljs.core.truth_(and__28335__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__28335__auto__;
}
})())){
var headers__$1 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/x-www-form-urlencoded"], null),headers);
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"form-params","form-params",1884296467)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_query_string.call(null,form_params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__35478_35488 = cljs.core.seq.call(null,params);
var chunk__35479_35489 = null;
var count__35480_35490 = (0);
var i__35481_35491 = (0);
while(true){
if((i__35481_35491 < count__35480_35490)){
var vec__35482_35492 = cljs.core._nth.call(null,chunk__35479_35489,i__35481_35491);
var k_35493 = cljs.core.nth.call(null,vec__35482_35492,(0),null);
var v_35494 = cljs.core.nth.call(null,vec__35482_35492,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_35494)){
form_data.append(cljs.core.name.call(null,k_35493),cljs.core.first.call(null,v_35494),cljs.core.second.call(null,v_35494));
} else {
form_data.append(cljs.core.name.call(null,k_35493),v_35494);
}

var G__35495 = seq__35478_35488;
var G__35496 = chunk__35479_35489;
var G__35497 = count__35480_35490;
var G__35498 = (i__35481_35491 + (1));
seq__35478_35488 = G__35495;
chunk__35479_35489 = G__35496;
count__35480_35490 = G__35497;
i__35481_35491 = G__35498;
continue;
} else {
var temp__4657__auto___35499 = cljs.core.seq.call(null,seq__35478_35488);
if(temp__4657__auto___35499){
var seq__35478_35500__$1 = temp__4657__auto___35499;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35478_35500__$1)){
var c__29186__auto___35501 = cljs.core.chunk_first.call(null,seq__35478_35500__$1);
var G__35502 = cljs.core.chunk_rest.call(null,seq__35478_35500__$1);
var G__35503 = c__29186__auto___35501;
var G__35504 = cljs.core.count.call(null,c__29186__auto___35501);
var G__35505 = (0);
seq__35478_35488 = G__35502;
chunk__35479_35489 = G__35503;
count__35480_35490 = G__35504;
i__35481_35491 = G__35505;
continue;
} else {
var vec__35485_35506 = cljs.core.first.call(null,seq__35478_35500__$1);
var k_35507 = cljs.core.nth.call(null,vec__35485_35506,(0),null);
var v_35508 = cljs.core.nth.call(null,vec__35485_35506,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_35508)){
form_data.append(cljs.core.name.call(null,k_35507),cljs.core.first.call(null,v_35508),cljs.core.second.call(null,v_35508));
} else {
form_data.append(cljs.core.name.call(null,k_35507),v_35508);
}

var G__35509 = cljs.core.next.call(null,seq__35478_35500__$1);
var G__35510 = null;
var G__35511 = (0);
var G__35512 = (0);
seq__35478_35488 = G__35509;
chunk__35479_35489 = G__35510;
count__35480_35490 = G__35511;
i__35481_35491 = G__35512;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__35513){
var map__35514 = p__35513;
var map__35514__$1 = ((((!((map__35514 == null)))?((((map__35514.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35514.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35514):map__35514);
var request = map__35514__$1;
var multipart_params = cljs.core.get.call(null,map__35514__$1,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707));
var request_method = cljs.core.get.call(null,map__35514__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core.truth_((function (){var and__28335__auto__ = multipart_params;
if(cljs.core.truth_(and__28335__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__28335__auto__;
}
})())){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_form_data.call(null,multipart_params)));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4655__auto__ = new cljs.core.Keyword(null,"method","method",55703592).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var m = temp__4655__auto__;
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"method","method",55703592)),new cljs.core.Keyword(null,"request-method","request-method",1764796830),m));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__35516_SHARP_){
return client.call(null,cljs.core.assoc.call(null,p1__35516_SHARP_,new cljs.core.Keyword(null,"server-name","server-name",-1012104295),server_name));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__35518){
var map__35519 = p__35518;
var map__35519__$1 = ((((!((map__35519 == null)))?((((map__35519.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35519.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35519):map__35519);
var req = map__35519__$1;
var query_params = cljs.core.get.call(null,map__35519__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
var temp__4655__auto__ = cljs_http.client.parse_url.call(null,new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4655__auto__)){
var spec = temp__4655__auto__;
return client.call(null,cljs.core.update_in.call(null,cljs.core.dissoc.call(null,cljs.core.merge.call(null,req,spec),new cljs.core.Keyword(null,"url","url",276297046)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534)], null),((function (spec,temp__4655__auto__,map__35519,map__35519__$1,req,query_params){
return (function (p1__35517_SHARP_){
return cljs.core.merge.call(null,p1__35517_SHARP_,query_params);
});})(spec,temp__4655__auto__,map__35519,map__35519__$1,req,query_params))
));
} else {
return client.call(null,req);
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 *   an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(var_args){
var args__29523__auto__ = [];
var len__29516__auto___35527 = arguments.length;
var i__29517__auto___35528 = (0);
while(true){
if((i__29517__auto___35528 < len__29516__auto___35527)){
args__29523__auto__.push((arguments[i__29517__auto___35528]));

var G__35529 = (i__29517__auto___35528 + (1));
i__29517__auto___35528 = G__35529;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__35523){
var vec__35524 = p__35523;
var credentials = cljs.core.nth.call(null,vec__35524,(0),null);
return ((function (vec__35524,credentials){
return (function (req){
var credentials__$1 = (function (){var or__28347__auto__ = new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_.call(null,credentials__$1))){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),cljs_http.util.basic_auth.call(null,credentials__$1)));
} else {
return client.call(null,req);
}
});
;})(vec__35524,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq35521){
var G__35522 = cljs.core.first.call(null,seq35521);
var seq35521__$1 = cljs.core.next.call(null,seq35521);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__35522,seq35521__$1);
});

/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4655__auto__ = new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var oauth_token = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(oauth_token)].join('')));
} else {
return client.call(null,req);
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var custom_channel = temp__4655__auto__;
return cljs.core.async.pipe.call(null,client.call(null,request),custom_channel);
} else {
return client.call(null,request);
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers.call(null,cljs_http.client.wrap_channel_from_request_map.call(null,cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_json_response.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_transit_response.call(null,cljs_http.client.wrap_transit_params.call(null,cljs_http.client.wrap_edn_response.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_multipart_params.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request.call(null,cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(var_args){
var args__29523__auto__ = [];
var len__29516__auto___35536 = arguments.length;
var i__29517__auto___35537 = (0);
while(true){
if((i__29517__auto___35537 < len__29516__auto___35536)){
args__29523__auto__.push((arguments[i__29517__auto___35537]));

var G__35538 = (i__29517__auto___35537 + (1));
i__29517__auto___35537 = G__35538;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35532){
var vec__35533 = p__35532;
var req = cljs.core.nth.call(null,vec__35533,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq35530){
var G__35531 = cljs.core.first.call(null,seq35530);
var seq35530__$1 = cljs.core.next.call(null,seq35530);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__35531,seq35530__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(var_args){
var args__29523__auto__ = [];
var len__29516__auto___35545 = arguments.length;
var i__29517__auto___35546 = (0);
while(true){
if((i__29517__auto___35546 < len__29516__auto___35545)){
args__29523__auto__.push((arguments[i__29517__auto___35546]));

var G__35547 = (i__29517__auto___35546 + (1));
i__29517__auto___35546 = G__35547;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35541){
var vec__35542 = p__35541;
var req = cljs.core.nth.call(null,vec__35542,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq35539){
var G__35540 = cljs.core.first.call(null,seq35539);
var seq35539__$1 = cljs.core.next.call(null,seq35539);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__35540,seq35539__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(var_args){
var args__29523__auto__ = [];
var len__29516__auto___35554 = arguments.length;
var i__29517__auto___35555 = (0);
while(true){
if((i__29517__auto___35555 < len__29516__auto___35554)){
args__29523__auto__.push((arguments[i__29517__auto___35555]));

var G__35556 = (i__29517__auto___35555 + (1));
i__29517__auto___35555 = G__35556;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35550){
var vec__35551 = p__35550;
var req = cljs.core.nth.call(null,vec__35551,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"head","head",-771383919),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq35548){
var G__35549 = cljs.core.first.call(null,seq35548);
var seq35548__$1 = cljs.core.next.call(null,seq35548);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__35549,seq35548__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(var_args){
var args__29523__auto__ = [];
var len__29516__auto___35563 = arguments.length;
var i__29517__auto___35564 = (0);
while(true){
if((i__29517__auto___35564 < len__29516__auto___35563)){
args__29523__auto__.push((arguments[i__29517__auto___35564]));

var G__35565 = (i__29517__auto___35564 + (1));
i__29517__auto___35564 = G__35565;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35559){
var vec__35560 = p__35559;
var req = cljs.core.nth.call(null,vec__35560,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"jsonp","jsonp",226119588),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq35557){
var G__35558 = cljs.core.first.call(null,seq35557);
var seq35557__$1 = cljs.core.next.call(null,seq35557);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__35558,seq35557__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(var_args){
var args__29523__auto__ = [];
var len__29516__auto___35572 = arguments.length;
var i__29517__auto___35573 = (0);
while(true){
if((i__29517__auto___35573 < len__29516__auto___35572)){
args__29523__auto__.push((arguments[i__29517__auto___35573]));

var G__35574 = (i__29517__auto___35573 + (1));
i__29517__auto___35573 = G__35574;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35568){
var vec__35569 = p__35568;
var req = cljs.core.nth.call(null,vec__35569,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"move","move",-2110884309),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq35566){
var G__35567 = cljs.core.first.call(null,seq35566);
var seq35566__$1 = cljs.core.next.call(null,seq35566);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__35567,seq35566__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(var_args){
var args__29523__auto__ = [];
var len__29516__auto___35581 = arguments.length;
var i__29517__auto___35582 = (0);
while(true){
if((i__29517__auto___35582 < len__29516__auto___35581)){
args__29523__auto__.push((arguments[i__29517__auto___35582]));

var G__35583 = (i__29517__auto___35582 + (1));
i__29517__auto___35582 = G__35583;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35577){
var vec__35578 = p__35577;
var req = cljs.core.nth.call(null,vec__35578,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq35575){
var G__35576 = cljs.core.first.call(null,seq35575);
var seq35575__$1 = cljs.core.next.call(null,seq35575);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__35576,seq35575__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(var_args){
var args__29523__auto__ = [];
var len__29516__auto___35590 = arguments.length;
var i__29517__auto___35591 = (0);
while(true){
if((i__29517__auto___35591 < len__29516__auto___35590)){
args__29523__auto__.push((arguments[i__29517__auto___35591]));

var G__35592 = (i__29517__auto___35591 + (1));
i__29517__auto___35591 = G__35592;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35586){
var vec__35587 = p__35586;
var req = cljs.core.nth.call(null,vec__35587,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq35584){
var G__35585 = cljs.core.first.call(null,seq35584);
var seq35584__$1 = cljs.core.next.call(null,seq35584);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__35585,seq35584__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(var_args){
var args__29523__auto__ = [];
var len__29516__auto___35599 = arguments.length;
var i__29517__auto___35600 = (0);
while(true){
if((i__29517__auto___35600 < len__29516__auto___35599)){
args__29523__auto__.push((arguments[i__29517__auto___35600]));

var G__35601 = (i__29517__auto___35600 + (1));
i__29517__auto___35600 = G__35601;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35595){
var vec__35596 = p__35595;
var req = cljs.core.nth.call(null,vec__35596,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq35593){
var G__35594 = cljs.core.first.call(null,seq35593);
var seq35593__$1 = cljs.core.next.call(null,seq35593);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__35594,seq35593__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(var_args){
var args__29523__auto__ = [];
var len__29516__auto___35608 = arguments.length;
var i__29517__auto___35609 = (0);
while(true){
if((i__29517__auto___35609 < len__29516__auto___35608)){
args__29523__auto__.push((arguments[i__29517__auto___35609]));

var G__35610 = (i__29517__auto___35609 + (1));
i__29517__auto___35609 = G__35610;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__35604){
var vec__35605 = p__35604;
var req = cljs.core.nth.call(null,vec__35605,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq35602){
var G__35603 = cljs.core.first.call(null,seq35602);
var seq35602__$1 = cljs.core.next.call(null,seq35602);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__35603,seq35602__$1);
});


//# sourceMappingURL=client.js.map?rel=1503639572256
