// Compiled by ClojureScript 1.9.908 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.13";
figwheel.client.js_stringify = (((typeof JSON !== 'undefined') && (!((JSON.stringify == null))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e32086){if((e32086 instanceof Error)){
var e = e32086;
return "Error: Unable to stringify";
} else {
throw e32086;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__32089 = arguments.length;
switch (G__32089) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__32087_SHARP_){
if(typeof p1__32087_SHARP_ === 'string'){
return p1__32087_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__32087_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__29523__auto__ = [];
var len__29516__auto___32092 = arguments.length;
var i__29517__auto___32093 = (0);
while(true){
if((i__29517__auto___32093 < len__29516__auto___32092)){
args__29523__auto__.push((arguments[i__29517__auto___32093]));

var G__32094 = (i__29517__auto___32093 + (1));
i__29517__auto___32093 = G__32094;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((0) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29524__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq32091){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq32091));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__29523__auto__ = [];
var len__29516__auto___32096 = arguments.length;
var i__29517__auto___32097 = (0);
while(true){
if((i__29517__auto___32097 < len__29516__auto___32096)){
args__29523__auto__.push((arguments[i__29517__auto___32097]));

var G__32098 = (i__29517__auto___32097 + (1));
i__29517__auto___32097 = G__32098;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((0) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29524__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq32095){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq32095));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__32099){
var map__32100 = p__32099;
var map__32100__$1 = ((((!((map__32100 == null)))?((((map__32100.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32100.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32100):map__32100);
var message = cljs.core.get.call(null,map__32100__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__32100__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__28347__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__28335__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__28335__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__28335__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__31823__auto___32179 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31823__auto___32179,ch){
return (function (){
var f__31824__auto__ = (function (){var switch__31802__auto__ = ((function (c__31823__auto___32179,ch){
return (function (state_32151){
var state_val_32152 = (state_32151[(1)]);
if((state_val_32152 === (7))){
var inst_32147 = (state_32151[(2)]);
var state_32151__$1 = state_32151;
var statearr_32153_32180 = state_32151__$1;
(statearr_32153_32180[(2)] = inst_32147);

(statearr_32153_32180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (1))){
var state_32151__$1 = state_32151;
var statearr_32154_32181 = state_32151__$1;
(statearr_32154_32181[(2)] = null);

(statearr_32154_32181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (4))){
var inst_32104 = (state_32151[(7)]);
var inst_32104__$1 = (state_32151[(2)]);
var state_32151__$1 = (function (){var statearr_32155 = state_32151;
(statearr_32155[(7)] = inst_32104__$1);

return statearr_32155;
})();
if(cljs.core.truth_(inst_32104__$1)){
var statearr_32156_32182 = state_32151__$1;
(statearr_32156_32182[(1)] = (5));

} else {
var statearr_32157_32183 = state_32151__$1;
(statearr_32157_32183[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (15))){
var inst_32111 = (state_32151[(8)]);
var inst_32126 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_32111);
var inst_32127 = cljs.core.first.call(null,inst_32126);
var inst_32128 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_32127);
var inst_32129 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32128)].join('');
var inst_32130 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_32129);
var state_32151__$1 = state_32151;
var statearr_32158_32184 = state_32151__$1;
(statearr_32158_32184[(2)] = inst_32130);

(statearr_32158_32184[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (13))){
var inst_32135 = (state_32151[(2)]);
var state_32151__$1 = state_32151;
var statearr_32159_32185 = state_32151__$1;
(statearr_32159_32185[(2)] = inst_32135);

(statearr_32159_32185[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (6))){
var state_32151__$1 = state_32151;
var statearr_32160_32186 = state_32151__$1;
(statearr_32160_32186[(2)] = null);

(statearr_32160_32186[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (17))){
var inst_32133 = (state_32151[(2)]);
var state_32151__$1 = state_32151;
var statearr_32161_32187 = state_32151__$1;
(statearr_32161_32187[(2)] = inst_32133);

(statearr_32161_32187[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (3))){
var inst_32149 = (state_32151[(2)]);
var state_32151__$1 = state_32151;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32151__$1,inst_32149);
} else {
if((state_val_32152 === (12))){
var inst_32110 = (state_32151[(9)]);
var inst_32124 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_32110,opts);
var state_32151__$1 = state_32151;
if(cljs.core.truth_(inst_32124)){
var statearr_32162_32188 = state_32151__$1;
(statearr_32162_32188[(1)] = (15));

} else {
var statearr_32163_32189 = state_32151__$1;
(statearr_32163_32189[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (2))){
var state_32151__$1 = state_32151;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32151__$1,(4),ch);
} else {
if((state_val_32152 === (11))){
var inst_32111 = (state_32151[(8)]);
var inst_32116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32117 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_32111);
var inst_32118 = cljs.core.async.timeout.call(null,(1000));
var inst_32119 = [inst_32117,inst_32118];
var inst_32120 = (new cljs.core.PersistentVector(null,2,(5),inst_32116,inst_32119,null));
var state_32151__$1 = state_32151;
return cljs.core.async.ioc_alts_BANG_.call(null,state_32151__$1,(14),inst_32120);
} else {
if((state_val_32152 === (9))){
var inst_32111 = (state_32151[(8)]);
var inst_32137 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_32138 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_32111);
var inst_32139 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_32138);
var inst_32140 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32139)].join('');
var inst_32141 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_32140);
var state_32151__$1 = (function (){var statearr_32164 = state_32151;
(statearr_32164[(10)] = inst_32137);

return statearr_32164;
})();
var statearr_32165_32190 = state_32151__$1;
(statearr_32165_32190[(2)] = inst_32141);

(statearr_32165_32190[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (5))){
var inst_32104 = (state_32151[(7)]);
var inst_32106 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_32107 = (new cljs.core.PersistentArrayMap(null,2,inst_32106,null));
var inst_32108 = (new cljs.core.PersistentHashSet(null,inst_32107,null));
var inst_32109 = figwheel.client.focus_msgs.call(null,inst_32108,inst_32104);
var inst_32110 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_32109);
var inst_32111 = cljs.core.first.call(null,inst_32109);
var inst_32112 = figwheel.client.autoload_QMARK_.call(null);
var state_32151__$1 = (function (){var statearr_32166 = state_32151;
(statearr_32166[(8)] = inst_32111);

(statearr_32166[(9)] = inst_32110);

return statearr_32166;
})();
if(cljs.core.truth_(inst_32112)){
var statearr_32167_32191 = state_32151__$1;
(statearr_32167_32191[(1)] = (8));

} else {
var statearr_32168_32192 = state_32151__$1;
(statearr_32168_32192[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (14))){
var inst_32122 = (state_32151[(2)]);
var state_32151__$1 = state_32151;
var statearr_32169_32193 = state_32151__$1;
(statearr_32169_32193[(2)] = inst_32122);

(statearr_32169_32193[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (16))){
var state_32151__$1 = state_32151;
var statearr_32170_32194 = state_32151__$1;
(statearr_32170_32194[(2)] = null);

(statearr_32170_32194[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (10))){
var inst_32143 = (state_32151[(2)]);
var state_32151__$1 = (function (){var statearr_32171 = state_32151;
(statearr_32171[(11)] = inst_32143);

return statearr_32171;
})();
var statearr_32172_32195 = state_32151__$1;
(statearr_32172_32195[(2)] = null);

(statearr_32172_32195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32152 === (8))){
var inst_32110 = (state_32151[(9)]);
var inst_32114 = figwheel.client.reload_file_state_QMARK_.call(null,inst_32110,opts);
var state_32151__$1 = state_32151;
if(cljs.core.truth_(inst_32114)){
var statearr_32173_32196 = state_32151__$1;
(statearr_32173_32196[(1)] = (11));

} else {
var statearr_32174_32197 = state_32151__$1;
(statearr_32174_32197[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31823__auto___32179,ch))
;
return ((function (switch__31802__auto__,c__31823__auto___32179,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__31803__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__31803__auto____0 = (function (){
var statearr_32175 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32175[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__31803__auto__);

(statearr_32175[(1)] = (1));

return statearr_32175;
});
var figwheel$client$file_reloader_plugin_$_state_machine__31803__auto____1 = (function (state_32151){
while(true){
var ret_value__31804__auto__ = (function (){try{while(true){
var result__31805__auto__ = switch__31802__auto__.call(null,state_32151);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31805__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31805__auto__;
}
break;
}
}catch (e32176){if((e32176 instanceof Object)){
var ex__31806__auto__ = e32176;
var statearr_32177_32198 = state_32151;
(statearr_32177_32198[(5)] = ex__31806__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32151);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32176;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31804__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32199 = state_32151;
state_32151 = G__32199;
continue;
} else {
return ret_value__31804__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__31803__auto__ = function(state_32151){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__31803__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__31803__auto____1.call(this,state_32151);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__31803__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__31803__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__31803__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__31803__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__31803__auto__;
})()
;})(switch__31802__auto__,c__31823__auto___32179,ch))
})();
var state__31825__auto__ = (function (){var statearr_32178 = f__31824__auto__.call(null);
(statearr_32178[(6)] = c__31823__auto___32179);

return statearr_32178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31825__auto__);
});})(c__31823__auto___32179,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__32200_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__32200_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_32202 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_32202){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e32201){if((e32201 instanceof Error)){
var e = e32201;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_32202], null));
} else {
var e = e32201;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_32202))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__32203){
var map__32204 = p__32203;
var map__32204__$1 = ((((!((map__32204 == null)))?((((map__32204.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32204.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32204):map__32204);
var opts = map__32204__$1;
var build_id = cljs.core.get.call(null,map__32204__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__32204,map__32204__$1,opts,build_id){
return (function (p__32206){
var vec__32207 = p__32206;
var seq__32208 = cljs.core.seq.call(null,vec__32207);
var first__32209 = cljs.core.first.call(null,seq__32208);
var seq__32208__$1 = cljs.core.next.call(null,seq__32208);
var map__32210 = first__32209;
var map__32210__$1 = ((((!((map__32210 == null)))?((((map__32210.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32210.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32210):map__32210);
var msg = map__32210__$1;
var msg_name = cljs.core.get.call(null,map__32210__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__32208__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__32207,seq__32208,first__32209,seq__32208__$1,map__32210,map__32210__$1,msg,msg_name,_,map__32204,map__32204__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__32207,seq__32208,first__32209,seq__32208__$1,map__32210,map__32210__$1,msg,msg_name,_,map__32204,map__32204__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__32204,map__32204__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__32212){
var vec__32213 = p__32212;
var seq__32214 = cljs.core.seq.call(null,vec__32213);
var first__32215 = cljs.core.first.call(null,seq__32214);
var seq__32214__$1 = cljs.core.next.call(null,seq__32214);
var map__32216 = first__32215;
var map__32216__$1 = ((((!((map__32216 == null)))?((((map__32216.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32216.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32216):map__32216);
var msg = map__32216__$1;
var msg_name = cljs.core.get.call(null,map__32216__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__32214__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__32218){
var map__32219 = p__32218;
var map__32219__$1 = ((((!((map__32219 == null)))?((((map__32219.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32219.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32219):map__32219);
var on_compile_warning = cljs.core.get.call(null,map__32219__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__32219__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__32219,map__32219__$1,on_compile_warning,on_compile_fail){
return (function (p__32221){
var vec__32222 = p__32221;
var seq__32223 = cljs.core.seq.call(null,vec__32222);
var first__32224 = cljs.core.first.call(null,seq__32223);
var seq__32223__$1 = cljs.core.next.call(null,seq__32223);
var map__32225 = first__32224;
var map__32225__$1 = ((((!((map__32225 == null)))?((((map__32225.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32225.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32225):map__32225);
var msg = map__32225__$1;
var msg_name = cljs.core.get.call(null,map__32225__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__32223__$1;
var pred__32227 = cljs.core._EQ_;
var expr__32228 = msg_name;
if(cljs.core.truth_(pred__32227.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__32228))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__32227.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__32228))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__32219,map__32219__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__31823__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31823__auto__,msg_hist,msg_names,msg){
return (function (){
var f__31824__auto__ = (function (){var switch__31802__auto__ = ((function (c__31823__auto__,msg_hist,msg_names,msg){
return (function (state_32317){
var state_val_32318 = (state_32317[(1)]);
if((state_val_32318 === (7))){
var inst_32237 = (state_32317[(2)]);
var state_32317__$1 = state_32317;
if(cljs.core.truth_(inst_32237)){
var statearr_32319_32366 = state_32317__$1;
(statearr_32319_32366[(1)] = (8));

} else {
var statearr_32320_32367 = state_32317__$1;
(statearr_32320_32367[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (20))){
var inst_32311 = (state_32317[(2)]);
var state_32317__$1 = state_32317;
var statearr_32321_32368 = state_32317__$1;
(statearr_32321_32368[(2)] = inst_32311);

(statearr_32321_32368[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (27))){
var inst_32307 = (state_32317[(2)]);
var state_32317__$1 = state_32317;
var statearr_32322_32369 = state_32317__$1;
(statearr_32322_32369[(2)] = inst_32307);

(statearr_32322_32369[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (1))){
var inst_32230 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_32317__$1 = state_32317;
if(cljs.core.truth_(inst_32230)){
var statearr_32323_32370 = state_32317__$1;
(statearr_32323_32370[(1)] = (2));

} else {
var statearr_32324_32371 = state_32317__$1;
(statearr_32324_32371[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (24))){
var inst_32309 = (state_32317[(2)]);
var state_32317__$1 = state_32317;
var statearr_32325_32372 = state_32317__$1;
(statearr_32325_32372[(2)] = inst_32309);

(statearr_32325_32372[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (4))){
var inst_32315 = (state_32317[(2)]);
var state_32317__$1 = state_32317;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32317__$1,inst_32315);
} else {
if((state_val_32318 === (15))){
var inst_32313 = (state_32317[(2)]);
var state_32317__$1 = state_32317;
var statearr_32326_32373 = state_32317__$1;
(statearr_32326_32373[(2)] = inst_32313);

(statearr_32326_32373[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (21))){
var inst_32266 = (state_32317[(2)]);
var inst_32267 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32268 = figwheel.client.auto_jump_to_error.call(null,opts,inst_32267);
var state_32317__$1 = (function (){var statearr_32327 = state_32317;
(statearr_32327[(7)] = inst_32266);

return statearr_32327;
})();
var statearr_32328_32374 = state_32317__$1;
(statearr_32328_32374[(2)] = inst_32268);

(statearr_32328_32374[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (31))){
var inst_32296 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_32317__$1 = state_32317;
if(cljs.core.truth_(inst_32296)){
var statearr_32329_32375 = state_32317__$1;
(statearr_32329_32375[(1)] = (34));

} else {
var statearr_32330_32376 = state_32317__$1;
(statearr_32330_32376[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (32))){
var inst_32305 = (state_32317[(2)]);
var state_32317__$1 = state_32317;
var statearr_32331_32377 = state_32317__$1;
(statearr_32331_32377[(2)] = inst_32305);

(statearr_32331_32377[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (33))){
var inst_32292 = (state_32317[(2)]);
var inst_32293 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32294 = figwheel.client.auto_jump_to_error.call(null,opts,inst_32293);
var state_32317__$1 = (function (){var statearr_32332 = state_32317;
(statearr_32332[(8)] = inst_32292);

return statearr_32332;
})();
var statearr_32333_32378 = state_32317__$1;
(statearr_32333_32378[(2)] = inst_32294);

(statearr_32333_32378[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (13))){
var inst_32251 = figwheel.client.heads_up.clear.call(null);
var state_32317__$1 = state_32317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32317__$1,(16),inst_32251);
} else {
if((state_val_32318 === (22))){
var inst_32272 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32273 = figwheel.client.heads_up.append_warning_message.call(null,inst_32272);
var state_32317__$1 = state_32317;
var statearr_32334_32379 = state_32317__$1;
(statearr_32334_32379[(2)] = inst_32273);

(statearr_32334_32379[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (36))){
var inst_32303 = (state_32317[(2)]);
var state_32317__$1 = state_32317;
var statearr_32335_32380 = state_32317__$1;
(statearr_32335_32380[(2)] = inst_32303);

(statearr_32335_32380[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (29))){
var inst_32283 = (state_32317[(2)]);
var inst_32284 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32285 = figwheel.client.auto_jump_to_error.call(null,opts,inst_32284);
var state_32317__$1 = (function (){var statearr_32336 = state_32317;
(statearr_32336[(9)] = inst_32283);

return statearr_32336;
})();
var statearr_32337_32381 = state_32317__$1;
(statearr_32337_32381[(2)] = inst_32285);

(statearr_32337_32381[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (6))){
var inst_32232 = (state_32317[(10)]);
var state_32317__$1 = state_32317;
var statearr_32338_32382 = state_32317__$1;
(statearr_32338_32382[(2)] = inst_32232);

(statearr_32338_32382[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (28))){
var inst_32279 = (state_32317[(2)]);
var inst_32280 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32281 = figwheel.client.heads_up.display_warning.call(null,inst_32280);
var state_32317__$1 = (function (){var statearr_32339 = state_32317;
(statearr_32339[(11)] = inst_32279);

return statearr_32339;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32317__$1,(29),inst_32281);
} else {
if((state_val_32318 === (25))){
var inst_32277 = figwheel.client.heads_up.clear.call(null);
var state_32317__$1 = state_32317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32317__$1,(28),inst_32277);
} else {
if((state_val_32318 === (34))){
var inst_32298 = figwheel.client.heads_up.flash_loaded.call(null);
var state_32317__$1 = state_32317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32317__$1,(37),inst_32298);
} else {
if((state_val_32318 === (17))){
var inst_32257 = (state_32317[(2)]);
var inst_32258 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32259 = figwheel.client.auto_jump_to_error.call(null,opts,inst_32258);
var state_32317__$1 = (function (){var statearr_32340 = state_32317;
(statearr_32340[(12)] = inst_32257);

return statearr_32340;
})();
var statearr_32341_32383 = state_32317__$1;
(statearr_32341_32383[(2)] = inst_32259);

(statearr_32341_32383[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (3))){
var inst_32249 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_32317__$1 = state_32317;
if(cljs.core.truth_(inst_32249)){
var statearr_32342_32384 = state_32317__$1;
(statearr_32342_32384[(1)] = (13));

} else {
var statearr_32343_32385 = state_32317__$1;
(statearr_32343_32385[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (12))){
var inst_32245 = (state_32317[(2)]);
var state_32317__$1 = state_32317;
var statearr_32344_32386 = state_32317__$1;
(statearr_32344_32386[(2)] = inst_32245);

(statearr_32344_32386[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (2))){
var inst_32232 = (state_32317[(10)]);
var inst_32232__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_32317__$1 = (function (){var statearr_32345 = state_32317;
(statearr_32345[(10)] = inst_32232__$1);

return statearr_32345;
})();
if(cljs.core.truth_(inst_32232__$1)){
var statearr_32346_32387 = state_32317__$1;
(statearr_32346_32387[(1)] = (5));

} else {
var statearr_32347_32388 = state_32317__$1;
(statearr_32347_32388[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (23))){
var inst_32275 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_32317__$1 = state_32317;
if(cljs.core.truth_(inst_32275)){
var statearr_32348_32389 = state_32317__$1;
(statearr_32348_32389[(1)] = (25));

} else {
var statearr_32349_32390 = state_32317__$1;
(statearr_32349_32390[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (35))){
var state_32317__$1 = state_32317;
var statearr_32350_32391 = state_32317__$1;
(statearr_32350_32391[(2)] = null);

(statearr_32350_32391[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (19))){
var inst_32270 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_32317__$1 = state_32317;
if(cljs.core.truth_(inst_32270)){
var statearr_32351_32392 = state_32317__$1;
(statearr_32351_32392[(1)] = (22));

} else {
var statearr_32352_32393 = state_32317__$1;
(statearr_32352_32393[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (11))){
var inst_32241 = (state_32317[(2)]);
var state_32317__$1 = state_32317;
var statearr_32353_32394 = state_32317__$1;
(statearr_32353_32394[(2)] = inst_32241);

(statearr_32353_32394[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (9))){
var inst_32243 = figwheel.client.heads_up.clear.call(null);
var state_32317__$1 = state_32317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32317__$1,(12),inst_32243);
} else {
if((state_val_32318 === (5))){
var inst_32234 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_32317__$1 = state_32317;
var statearr_32354_32395 = state_32317__$1;
(statearr_32354_32395[(2)] = inst_32234);

(statearr_32354_32395[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (14))){
var inst_32261 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_32317__$1 = state_32317;
if(cljs.core.truth_(inst_32261)){
var statearr_32355_32396 = state_32317__$1;
(statearr_32355_32396[(1)] = (18));

} else {
var statearr_32356_32397 = state_32317__$1;
(statearr_32356_32397[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (26))){
var inst_32287 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_32317__$1 = state_32317;
if(cljs.core.truth_(inst_32287)){
var statearr_32357_32398 = state_32317__$1;
(statearr_32357_32398[(1)] = (30));

} else {
var statearr_32358_32399 = state_32317__$1;
(statearr_32358_32399[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (16))){
var inst_32253 = (state_32317[(2)]);
var inst_32254 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32255 = figwheel.client.heads_up.display_exception.call(null,inst_32254);
var state_32317__$1 = (function (){var statearr_32359 = state_32317;
(statearr_32359[(13)] = inst_32253);

return statearr_32359;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32317__$1,(17),inst_32255);
} else {
if((state_val_32318 === (30))){
var inst_32289 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32290 = figwheel.client.heads_up.display_warning.call(null,inst_32289);
var state_32317__$1 = state_32317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32317__$1,(33),inst_32290);
} else {
if((state_val_32318 === (10))){
var inst_32247 = (state_32317[(2)]);
var state_32317__$1 = state_32317;
var statearr_32360_32400 = state_32317__$1;
(statearr_32360_32400[(2)] = inst_32247);

(statearr_32360_32400[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (18))){
var inst_32263 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32264 = figwheel.client.heads_up.display_exception.call(null,inst_32263);
var state_32317__$1 = state_32317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32317__$1,(21),inst_32264);
} else {
if((state_val_32318 === (37))){
var inst_32300 = (state_32317[(2)]);
var state_32317__$1 = state_32317;
var statearr_32361_32401 = state_32317__$1;
(statearr_32361_32401[(2)] = inst_32300);

(statearr_32361_32401[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32318 === (8))){
var inst_32239 = figwheel.client.heads_up.flash_loaded.call(null);
var state_32317__$1 = state_32317;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32317__$1,(11),inst_32239);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31823__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__31802__auto__,c__31823__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31803__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31803__auto____0 = (function (){
var statearr_32362 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32362[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31803__auto__);

(statearr_32362[(1)] = (1));

return statearr_32362;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31803__auto____1 = (function (state_32317){
while(true){
var ret_value__31804__auto__ = (function (){try{while(true){
var result__31805__auto__ = switch__31802__auto__.call(null,state_32317);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31805__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31805__auto__;
}
break;
}
}catch (e32363){if((e32363 instanceof Object)){
var ex__31806__auto__ = e32363;
var statearr_32364_32402 = state_32317;
(statearr_32364_32402[(5)] = ex__31806__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32317);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32363;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31804__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32403 = state_32317;
state_32317 = G__32403;
continue;
} else {
return ret_value__31804__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31803__auto__ = function(state_32317){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31803__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31803__auto____1.call(this,state_32317);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31803__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31803__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31803__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31803__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__31803__auto__;
})()
;})(switch__31802__auto__,c__31823__auto__,msg_hist,msg_names,msg))
})();
var state__31825__auto__ = (function (){var statearr_32365 = f__31824__auto__.call(null);
(statearr_32365[(6)] = c__31823__auto__);

return statearr_32365;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31825__auto__);
});})(c__31823__auto__,msg_hist,msg_names,msg))
);

return c__31823__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__31823__auto___32432 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31823__auto___32432,ch){
return (function (){
var f__31824__auto__ = (function (){var switch__31802__auto__ = ((function (c__31823__auto___32432,ch){
return (function (state_32418){
var state_val_32419 = (state_32418[(1)]);
if((state_val_32419 === (1))){
var state_32418__$1 = state_32418;
var statearr_32420_32433 = state_32418__$1;
(statearr_32420_32433[(2)] = null);

(statearr_32420_32433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32419 === (2))){
var state_32418__$1 = state_32418;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32418__$1,(4),ch);
} else {
if((state_val_32419 === (3))){
var inst_32416 = (state_32418[(2)]);
var state_32418__$1 = state_32418;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32418__$1,inst_32416);
} else {
if((state_val_32419 === (4))){
var inst_32406 = (state_32418[(7)]);
var inst_32406__$1 = (state_32418[(2)]);
var state_32418__$1 = (function (){var statearr_32421 = state_32418;
(statearr_32421[(7)] = inst_32406__$1);

return statearr_32421;
})();
if(cljs.core.truth_(inst_32406__$1)){
var statearr_32422_32434 = state_32418__$1;
(statearr_32422_32434[(1)] = (5));

} else {
var statearr_32423_32435 = state_32418__$1;
(statearr_32423_32435[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32419 === (5))){
var inst_32406 = (state_32418[(7)]);
var inst_32408 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_32406);
var state_32418__$1 = state_32418;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32418__$1,(8),inst_32408);
} else {
if((state_val_32419 === (6))){
var state_32418__$1 = state_32418;
var statearr_32424_32436 = state_32418__$1;
(statearr_32424_32436[(2)] = null);

(statearr_32424_32436[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32419 === (7))){
var inst_32414 = (state_32418[(2)]);
var state_32418__$1 = state_32418;
var statearr_32425_32437 = state_32418__$1;
(statearr_32425_32437[(2)] = inst_32414);

(statearr_32425_32437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32419 === (8))){
var inst_32410 = (state_32418[(2)]);
var state_32418__$1 = (function (){var statearr_32426 = state_32418;
(statearr_32426[(8)] = inst_32410);

return statearr_32426;
})();
var statearr_32427_32438 = state_32418__$1;
(statearr_32427_32438[(2)] = null);

(statearr_32427_32438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__31823__auto___32432,ch))
;
return ((function (switch__31802__auto__,c__31823__auto___32432,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__31803__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__31803__auto____0 = (function (){
var statearr_32428 = [null,null,null,null,null,null,null,null,null];
(statearr_32428[(0)] = figwheel$client$heads_up_plugin_$_state_machine__31803__auto__);

(statearr_32428[(1)] = (1));

return statearr_32428;
});
var figwheel$client$heads_up_plugin_$_state_machine__31803__auto____1 = (function (state_32418){
while(true){
var ret_value__31804__auto__ = (function (){try{while(true){
var result__31805__auto__ = switch__31802__auto__.call(null,state_32418);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31805__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31805__auto__;
}
break;
}
}catch (e32429){if((e32429 instanceof Object)){
var ex__31806__auto__ = e32429;
var statearr_32430_32439 = state_32418;
(statearr_32430_32439[(5)] = ex__31806__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32418);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32429;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31804__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32440 = state_32418;
state_32418 = G__32440;
continue;
} else {
return ret_value__31804__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__31803__auto__ = function(state_32418){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__31803__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__31803__auto____1.call(this,state_32418);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__31803__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__31803__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__31803__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__31803__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__31803__auto__;
})()
;})(switch__31802__auto__,c__31823__auto___32432,ch))
})();
var state__31825__auto__ = (function (){var statearr_32431 = f__31824__auto__.call(null);
(statearr_32431[(6)] = c__31823__auto___32432);

return statearr_32431;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31825__auto__);
});})(c__31823__auto___32432,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__31823__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31823__auto__){
return (function (){
var f__31824__auto__ = (function (){var switch__31802__auto__ = ((function (c__31823__auto__){
return (function (state_32446){
var state_val_32447 = (state_32446[(1)]);
if((state_val_32447 === (1))){
var inst_32441 = cljs.core.async.timeout.call(null,(3000));
var state_32446__$1 = state_32446;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32446__$1,(2),inst_32441);
} else {
if((state_val_32447 === (2))){
var inst_32443 = (state_32446[(2)]);
var inst_32444 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_32446__$1 = (function (){var statearr_32448 = state_32446;
(statearr_32448[(7)] = inst_32443);

return statearr_32448;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32446__$1,inst_32444);
} else {
return null;
}
}
});})(c__31823__auto__))
;
return ((function (switch__31802__auto__,c__31823__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__31803__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__31803__auto____0 = (function (){
var statearr_32449 = [null,null,null,null,null,null,null,null];
(statearr_32449[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__31803__auto__);

(statearr_32449[(1)] = (1));

return statearr_32449;
});
var figwheel$client$enforce_project_plugin_$_state_machine__31803__auto____1 = (function (state_32446){
while(true){
var ret_value__31804__auto__ = (function (){try{while(true){
var result__31805__auto__ = switch__31802__auto__.call(null,state_32446);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31805__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31805__auto__;
}
break;
}
}catch (e32450){if((e32450 instanceof Object)){
var ex__31806__auto__ = e32450;
var statearr_32451_32453 = state_32446;
(statearr_32451_32453[(5)] = ex__31806__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32446);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32450;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31804__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32454 = state_32446;
state_32446 = G__32454;
continue;
} else {
return ret_value__31804__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__31803__auto__ = function(state_32446){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__31803__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__31803__auto____1.call(this,state_32446);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__31803__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__31803__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__31803__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__31803__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__31803__auto__;
})()
;})(switch__31802__auto__,c__31823__auto__))
})();
var state__31825__auto__ = (function (){var statearr_32452 = f__31824__auto__.call(null);
(statearr_32452[(6)] = c__31823__auto__);

return statearr_32452;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31825__auto__);
});})(c__31823__auto__))
);

return c__31823__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__4657__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__4657__auto__)){
var figwheel_version = temp__4657__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__31823__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31823__auto__,figwheel_version,temp__4657__auto__){
return (function (){
var f__31824__auto__ = (function (){var switch__31802__auto__ = ((function (c__31823__auto__,figwheel_version,temp__4657__auto__){
return (function (state_32461){
var state_val_32462 = (state_32461[(1)]);
if((state_val_32462 === (1))){
var inst_32455 = cljs.core.async.timeout.call(null,(2000));
var state_32461__$1 = state_32461;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32461__$1,(2),inst_32455);
} else {
if((state_val_32462 === (2))){
var inst_32457 = (state_32461[(2)]);
var inst_32458 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_32459 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_32458);
var state_32461__$1 = (function (){var statearr_32463 = state_32461;
(statearr_32463[(7)] = inst_32457);

return statearr_32463;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32461__$1,inst_32459);
} else {
return null;
}
}
});})(c__31823__auto__,figwheel_version,temp__4657__auto__))
;
return ((function (switch__31802__auto__,c__31823__auto__,figwheel_version,temp__4657__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31803__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31803__auto____0 = (function (){
var statearr_32464 = [null,null,null,null,null,null,null,null];
(statearr_32464[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31803__auto__);

(statearr_32464[(1)] = (1));

return statearr_32464;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31803__auto____1 = (function (state_32461){
while(true){
var ret_value__31804__auto__ = (function (){try{while(true){
var result__31805__auto__ = switch__31802__auto__.call(null,state_32461);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31805__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31805__auto__;
}
break;
}
}catch (e32465){if((e32465 instanceof Object)){
var ex__31806__auto__ = e32465;
var statearr_32466_32468 = state_32461;
(statearr_32466_32468[(5)] = ex__31806__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32461);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32465;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31804__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32469 = state_32461;
state_32461 = G__32469;
continue;
} else {
return ret_value__31804__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31803__auto__ = function(state_32461){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31803__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31803__auto____1.call(this,state_32461);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31803__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31803__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31803__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31803__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__31803__auto__;
})()
;})(switch__31802__auto__,c__31823__auto__,figwheel_version,temp__4657__auto__))
})();
var state__31825__auto__ = (function (){var statearr_32467 = f__31824__auto__.call(null);
(statearr_32467[(6)] = c__31823__auto__);

return statearr_32467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31825__auto__);
});})(c__31823__auto__,figwheel_version,temp__4657__auto__))
);

return c__31823__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__32470){
var map__32471 = p__32470;
var map__32471__$1 = ((((!((map__32471 == null)))?((((map__32471.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32471.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32471):map__32471);
var file = cljs.core.get.call(null,map__32471__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__32471__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__32471__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__32473 = "";
var G__32473__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32473),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__32473);
var G__32473__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32473__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__32473__$1);
if(cljs.core.truth_((function (){var and__28335__auto__ = line;
if(cljs.core.truth_(and__28335__auto__)){
return column;
} else {
return and__28335__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32473__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__32473__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__32474){
var map__32475 = p__32474;
var map__32475__$1 = ((((!((map__32475 == null)))?((((map__32475.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32475.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32475):map__32475);
var ed = map__32475__$1;
var formatted_exception = cljs.core.get.call(null,map__32475__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__32475__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__32475__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__32477_32481 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__32478_32482 = null;
var count__32479_32483 = (0);
var i__32480_32484 = (0);
while(true){
if((i__32480_32484 < count__32479_32483)){
var msg_32485 = cljs.core._nth.call(null,chunk__32478_32482,i__32480_32484);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_32485);

var G__32486 = seq__32477_32481;
var G__32487 = chunk__32478_32482;
var G__32488 = count__32479_32483;
var G__32489 = (i__32480_32484 + (1));
seq__32477_32481 = G__32486;
chunk__32478_32482 = G__32487;
count__32479_32483 = G__32488;
i__32480_32484 = G__32489;
continue;
} else {
var temp__4657__auto___32490 = cljs.core.seq.call(null,seq__32477_32481);
if(temp__4657__auto___32490){
var seq__32477_32491__$1 = temp__4657__auto___32490;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32477_32491__$1)){
var c__29186__auto___32492 = cljs.core.chunk_first.call(null,seq__32477_32491__$1);
var G__32493 = cljs.core.chunk_rest.call(null,seq__32477_32491__$1);
var G__32494 = c__29186__auto___32492;
var G__32495 = cljs.core.count.call(null,c__29186__auto___32492);
var G__32496 = (0);
seq__32477_32481 = G__32493;
chunk__32478_32482 = G__32494;
count__32479_32483 = G__32495;
i__32480_32484 = G__32496;
continue;
} else {
var msg_32497 = cljs.core.first.call(null,seq__32477_32491__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_32497);

var G__32498 = cljs.core.next.call(null,seq__32477_32491__$1);
var G__32499 = null;
var G__32500 = (0);
var G__32501 = (0);
seq__32477_32481 = G__32498;
chunk__32478_32482 = G__32499;
count__32479_32483 = G__32500;
i__32480_32484 = G__32501;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__32502){
var map__32503 = p__32502;
var map__32503__$1 = ((((!((map__32503 == null)))?((((map__32503.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32503.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32503):map__32503);
var w = map__32503__$1;
var message = cljs.core.get.call(null,map__32503__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/figwheel/client.cljs",33,1,363,363,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__28335__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__28335__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__28335__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__32505 = cljs.core.seq.call(null,plugins);
var chunk__32506 = null;
var count__32507 = (0);
var i__32508 = (0);
while(true){
if((i__32508 < count__32507)){
var vec__32509 = cljs.core._nth.call(null,chunk__32506,i__32508);
var k = cljs.core.nth.call(null,vec__32509,(0),null);
var plugin = cljs.core.nth.call(null,vec__32509,(1),null);
if(cljs.core.truth_(plugin)){
var pl_32515 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__32505,chunk__32506,count__32507,i__32508,pl_32515,vec__32509,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_32515.call(null,msg_hist);
});})(seq__32505,chunk__32506,count__32507,i__32508,pl_32515,vec__32509,k,plugin))
);
} else {
}

var G__32516 = seq__32505;
var G__32517 = chunk__32506;
var G__32518 = count__32507;
var G__32519 = (i__32508 + (1));
seq__32505 = G__32516;
chunk__32506 = G__32517;
count__32507 = G__32518;
i__32508 = G__32519;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__32505);
if(temp__4657__auto__){
var seq__32505__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32505__$1)){
var c__29186__auto__ = cljs.core.chunk_first.call(null,seq__32505__$1);
var G__32520 = cljs.core.chunk_rest.call(null,seq__32505__$1);
var G__32521 = c__29186__auto__;
var G__32522 = cljs.core.count.call(null,c__29186__auto__);
var G__32523 = (0);
seq__32505 = G__32520;
chunk__32506 = G__32521;
count__32507 = G__32522;
i__32508 = G__32523;
continue;
} else {
var vec__32512 = cljs.core.first.call(null,seq__32505__$1);
var k = cljs.core.nth.call(null,vec__32512,(0),null);
var plugin = cljs.core.nth.call(null,vec__32512,(1),null);
if(cljs.core.truth_(plugin)){
var pl_32524 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__32505,chunk__32506,count__32507,i__32508,pl_32524,vec__32512,k,plugin,seq__32505__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_32524.call(null,msg_hist);
});})(seq__32505,chunk__32506,count__32507,i__32508,pl_32524,vec__32512,k,plugin,seq__32505__$1,temp__4657__auto__))
);
} else {
}

var G__32525 = cljs.core.next.call(null,seq__32505__$1);
var G__32526 = null;
var G__32527 = (0);
var G__32528 = (0);
seq__32505 = G__32525;
chunk__32506 = G__32526;
count__32507 = G__32527;
i__32508 = G__32528;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__32530 = arguments.length;
switch (G__32530) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__32531_32536 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__32532_32537 = null;
var count__32533_32538 = (0);
var i__32534_32539 = (0);
while(true){
if((i__32534_32539 < count__32533_32538)){
var msg_32540 = cljs.core._nth.call(null,chunk__32532_32537,i__32534_32539);
figwheel.client.socket.handle_incoming_message.call(null,msg_32540);

var G__32541 = seq__32531_32536;
var G__32542 = chunk__32532_32537;
var G__32543 = count__32533_32538;
var G__32544 = (i__32534_32539 + (1));
seq__32531_32536 = G__32541;
chunk__32532_32537 = G__32542;
count__32533_32538 = G__32543;
i__32534_32539 = G__32544;
continue;
} else {
var temp__4657__auto___32545 = cljs.core.seq.call(null,seq__32531_32536);
if(temp__4657__auto___32545){
var seq__32531_32546__$1 = temp__4657__auto___32545;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32531_32546__$1)){
var c__29186__auto___32547 = cljs.core.chunk_first.call(null,seq__32531_32546__$1);
var G__32548 = cljs.core.chunk_rest.call(null,seq__32531_32546__$1);
var G__32549 = c__29186__auto___32547;
var G__32550 = cljs.core.count.call(null,c__29186__auto___32547);
var G__32551 = (0);
seq__32531_32536 = G__32548;
chunk__32532_32537 = G__32549;
count__32533_32538 = G__32550;
i__32534_32539 = G__32551;
continue;
} else {
var msg_32552 = cljs.core.first.call(null,seq__32531_32546__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_32552);

var G__32553 = cljs.core.next.call(null,seq__32531_32546__$1);
var G__32554 = null;
var G__32555 = (0);
var G__32556 = (0);
seq__32531_32536 = G__32553;
chunk__32532_32537 = G__32554;
count__32533_32538 = G__32555;
i__32534_32539 = G__32556;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__29523__auto__ = [];
var len__29516__auto___32561 = arguments.length;
var i__29517__auto___32562 = (0);
while(true){
if((i__29517__auto___32562 < len__29516__auto___32561)){
args__29523__auto__.push((arguments[i__29517__auto___32562]));

var G__32563 = (i__29517__auto___32562 + (1));
i__29517__auto___32562 = G__32563;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((0) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__29524__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__32558){
var map__32559 = p__32558;
var map__32559__$1 = ((((!((map__32559 == null)))?((((map__32559.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32559.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32559):map__32559);
var opts = map__32559__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq32557){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq32557));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e32564){if((e32564 instanceof Error)){
var e = e32564;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e32564;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__32565){
var map__32566 = p__32565;
var map__32566__$1 = ((((!((map__32566 == null)))?((((map__32566.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32566.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32566):map__32566);
var msg_name = cljs.core.get.call(null,map__32566__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1503694112648
