// Compiled by ClojureScript 1.9.908 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__28347__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__28347__auto__){
return or__28347__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__28347__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
var or__28347__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__28347__auto____$1)){
return or__28347__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__34512_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__34512_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__34513 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__34514 = null;
var count__34515 = (0);
var i__34516 = (0);
while(true){
if((i__34516 < count__34515)){
var n = cljs.core._nth.call(null,chunk__34514,i__34516);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__34517 = seq__34513;
var G__34518 = chunk__34514;
var G__34519 = count__34515;
var G__34520 = (i__34516 + (1));
seq__34513 = G__34517;
chunk__34514 = G__34518;
count__34515 = G__34519;
i__34516 = G__34520;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__34513);
if(temp__4657__auto__){
var seq__34513__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34513__$1)){
var c__29186__auto__ = cljs.core.chunk_first.call(null,seq__34513__$1);
var G__34521 = cljs.core.chunk_rest.call(null,seq__34513__$1);
var G__34522 = c__29186__auto__;
var G__34523 = cljs.core.count.call(null,c__29186__auto__);
var G__34524 = (0);
seq__34513 = G__34521;
chunk__34514 = G__34522;
count__34515 = G__34523;
i__34516 = G__34524;
continue;
} else {
var n = cljs.core.first.call(null,seq__34513__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__34525 = cljs.core.next.call(null,seq__34513__$1);
var G__34526 = null;
var G__34527 = (0);
var G__34528 = (0);
seq__34513 = G__34525;
chunk__34514 = G__34526;
count__34515 = G__34527;
i__34516 = G__34528;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__34538_34546 = cljs.core.seq.call(null,deps);
var chunk__34539_34547 = null;
var count__34540_34548 = (0);
var i__34541_34549 = (0);
while(true){
if((i__34541_34549 < count__34540_34548)){
var dep_34550 = cljs.core._nth.call(null,chunk__34539_34547,i__34541_34549);
topo_sort_helper_STAR_.call(null,dep_34550,(depth + (1)),state);

var G__34551 = seq__34538_34546;
var G__34552 = chunk__34539_34547;
var G__34553 = count__34540_34548;
var G__34554 = (i__34541_34549 + (1));
seq__34538_34546 = G__34551;
chunk__34539_34547 = G__34552;
count__34540_34548 = G__34553;
i__34541_34549 = G__34554;
continue;
} else {
var temp__4657__auto___34555 = cljs.core.seq.call(null,seq__34538_34546);
if(temp__4657__auto___34555){
var seq__34538_34556__$1 = temp__4657__auto___34555;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34538_34556__$1)){
var c__29186__auto___34557 = cljs.core.chunk_first.call(null,seq__34538_34556__$1);
var G__34558 = cljs.core.chunk_rest.call(null,seq__34538_34556__$1);
var G__34559 = c__29186__auto___34557;
var G__34560 = cljs.core.count.call(null,c__29186__auto___34557);
var G__34561 = (0);
seq__34538_34546 = G__34558;
chunk__34539_34547 = G__34559;
count__34540_34548 = G__34560;
i__34541_34549 = G__34561;
continue;
} else {
var dep_34562 = cljs.core.first.call(null,seq__34538_34556__$1);
topo_sort_helper_STAR_.call(null,dep_34562,(depth + (1)),state);

var G__34563 = cljs.core.next.call(null,seq__34538_34556__$1);
var G__34564 = null;
var G__34565 = (0);
var G__34566 = (0);
seq__34538_34546 = G__34563;
chunk__34539_34547 = G__34564;
count__34540_34548 = G__34565;
i__34541_34549 = G__34566;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__34542){
var vec__34543 = p__34542;
var seq__34544 = cljs.core.seq.call(null,vec__34543);
var first__34545 = cljs.core.first.call(null,seq__34544);
var seq__34544__$1 = cljs.core.next.call(null,seq__34544);
var x = first__34545;
var xs = seq__34544__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__34543,seq__34544,first__34545,seq__34544__$1,x,xs,get_deps__$1){
return (function (p1__34529_SHARP_){
return clojure.set.difference.call(null,p1__34529_SHARP_,x);
});})(vec__34543,seq__34544,first__34545,seq__34544__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__34567 = cljs.core.seq.call(null,provides);
var chunk__34568 = null;
var count__34569 = (0);
var i__34570 = (0);
while(true){
if((i__34570 < count__34569)){
var prov = cljs.core._nth.call(null,chunk__34568,i__34570);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__34571_34579 = cljs.core.seq.call(null,requires);
var chunk__34572_34580 = null;
var count__34573_34581 = (0);
var i__34574_34582 = (0);
while(true){
if((i__34574_34582 < count__34573_34581)){
var req_34583 = cljs.core._nth.call(null,chunk__34572_34580,i__34574_34582);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34583,prov);

var G__34584 = seq__34571_34579;
var G__34585 = chunk__34572_34580;
var G__34586 = count__34573_34581;
var G__34587 = (i__34574_34582 + (1));
seq__34571_34579 = G__34584;
chunk__34572_34580 = G__34585;
count__34573_34581 = G__34586;
i__34574_34582 = G__34587;
continue;
} else {
var temp__4657__auto___34588 = cljs.core.seq.call(null,seq__34571_34579);
if(temp__4657__auto___34588){
var seq__34571_34589__$1 = temp__4657__auto___34588;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34571_34589__$1)){
var c__29186__auto___34590 = cljs.core.chunk_first.call(null,seq__34571_34589__$1);
var G__34591 = cljs.core.chunk_rest.call(null,seq__34571_34589__$1);
var G__34592 = c__29186__auto___34590;
var G__34593 = cljs.core.count.call(null,c__29186__auto___34590);
var G__34594 = (0);
seq__34571_34579 = G__34591;
chunk__34572_34580 = G__34592;
count__34573_34581 = G__34593;
i__34574_34582 = G__34594;
continue;
} else {
var req_34595 = cljs.core.first.call(null,seq__34571_34589__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34595,prov);

var G__34596 = cljs.core.next.call(null,seq__34571_34589__$1);
var G__34597 = null;
var G__34598 = (0);
var G__34599 = (0);
seq__34571_34579 = G__34596;
chunk__34572_34580 = G__34597;
count__34573_34581 = G__34598;
i__34574_34582 = G__34599;
continue;
}
} else {
}
}
break;
}

var G__34600 = seq__34567;
var G__34601 = chunk__34568;
var G__34602 = count__34569;
var G__34603 = (i__34570 + (1));
seq__34567 = G__34600;
chunk__34568 = G__34601;
count__34569 = G__34602;
i__34570 = G__34603;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__34567);
if(temp__4657__auto__){
var seq__34567__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34567__$1)){
var c__29186__auto__ = cljs.core.chunk_first.call(null,seq__34567__$1);
var G__34604 = cljs.core.chunk_rest.call(null,seq__34567__$1);
var G__34605 = c__29186__auto__;
var G__34606 = cljs.core.count.call(null,c__29186__auto__);
var G__34607 = (0);
seq__34567 = G__34604;
chunk__34568 = G__34605;
count__34569 = G__34606;
i__34570 = G__34607;
continue;
} else {
var prov = cljs.core.first.call(null,seq__34567__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__34575_34608 = cljs.core.seq.call(null,requires);
var chunk__34576_34609 = null;
var count__34577_34610 = (0);
var i__34578_34611 = (0);
while(true){
if((i__34578_34611 < count__34577_34610)){
var req_34612 = cljs.core._nth.call(null,chunk__34576_34609,i__34578_34611);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34612,prov);

var G__34613 = seq__34575_34608;
var G__34614 = chunk__34576_34609;
var G__34615 = count__34577_34610;
var G__34616 = (i__34578_34611 + (1));
seq__34575_34608 = G__34613;
chunk__34576_34609 = G__34614;
count__34577_34610 = G__34615;
i__34578_34611 = G__34616;
continue;
} else {
var temp__4657__auto___34617__$1 = cljs.core.seq.call(null,seq__34575_34608);
if(temp__4657__auto___34617__$1){
var seq__34575_34618__$1 = temp__4657__auto___34617__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34575_34618__$1)){
var c__29186__auto___34619 = cljs.core.chunk_first.call(null,seq__34575_34618__$1);
var G__34620 = cljs.core.chunk_rest.call(null,seq__34575_34618__$1);
var G__34621 = c__29186__auto___34619;
var G__34622 = cljs.core.count.call(null,c__29186__auto___34619);
var G__34623 = (0);
seq__34575_34608 = G__34620;
chunk__34576_34609 = G__34621;
count__34577_34610 = G__34622;
i__34578_34611 = G__34623;
continue;
} else {
var req_34624 = cljs.core.first.call(null,seq__34575_34618__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_34624,prov);

var G__34625 = cljs.core.next.call(null,seq__34575_34618__$1);
var G__34626 = null;
var G__34627 = (0);
var G__34628 = (0);
seq__34575_34608 = G__34625;
chunk__34576_34609 = G__34626;
count__34577_34610 = G__34627;
i__34578_34611 = G__34628;
continue;
}
} else {
}
}
break;
}

var G__34629 = cljs.core.next.call(null,seq__34567__$1);
var G__34630 = null;
var G__34631 = (0);
var G__34632 = (0);
seq__34567 = G__34629;
chunk__34568 = G__34630;
count__34569 = G__34631;
i__34570 = G__34632;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__34633_34637 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__34634_34638 = null;
var count__34635_34639 = (0);
var i__34636_34640 = (0);
while(true){
if((i__34636_34640 < count__34635_34639)){
var ns_34641 = cljs.core._nth.call(null,chunk__34634_34638,i__34636_34640);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_34641);

var G__34642 = seq__34633_34637;
var G__34643 = chunk__34634_34638;
var G__34644 = count__34635_34639;
var G__34645 = (i__34636_34640 + (1));
seq__34633_34637 = G__34642;
chunk__34634_34638 = G__34643;
count__34635_34639 = G__34644;
i__34636_34640 = G__34645;
continue;
} else {
var temp__4657__auto___34646 = cljs.core.seq.call(null,seq__34633_34637);
if(temp__4657__auto___34646){
var seq__34633_34647__$1 = temp__4657__auto___34646;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34633_34647__$1)){
var c__29186__auto___34648 = cljs.core.chunk_first.call(null,seq__34633_34647__$1);
var G__34649 = cljs.core.chunk_rest.call(null,seq__34633_34647__$1);
var G__34650 = c__29186__auto___34648;
var G__34651 = cljs.core.count.call(null,c__29186__auto___34648);
var G__34652 = (0);
seq__34633_34637 = G__34649;
chunk__34634_34638 = G__34650;
count__34635_34639 = G__34651;
i__34636_34640 = G__34652;
continue;
} else {
var ns_34653 = cljs.core.first.call(null,seq__34633_34647__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_34653);

var G__34654 = cljs.core.next.call(null,seq__34633_34647__$1);
var G__34655 = null;
var G__34656 = (0);
var G__34657 = (0);
seq__34633_34637 = G__34654;
chunk__34634_34638 = G__34655;
count__34635_34639 = G__34656;
i__34636_34640 = G__34657;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__28347__auto__ = goog.require__;
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__34658__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__34658 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34659__i = 0, G__34659__a = new Array(arguments.length -  0);
while (G__34659__i < G__34659__a.length) {G__34659__a[G__34659__i] = arguments[G__34659__i + 0]; ++G__34659__i;}
  args = new cljs.core.IndexedSeq(G__34659__a,0,null);
} 
return G__34658__delegate.call(this,args);};
G__34658.cljs$lang$maxFixedArity = 0;
G__34658.cljs$lang$applyTo = (function (arglist__34660){
var args = cljs.core.seq(arglist__34660);
return G__34658__delegate(args);
});
G__34658.cljs$core$IFn$_invoke$arity$variadic = G__34658__delegate;
return G__34658;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = ((typeof goog.net.jsloader.safeLoad !== 'undefined')?(function (p1__34661_SHARP_,p2__34662_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34661_SHARP_)].join('')),p2__34662_SHARP_);
}):((typeof goog.net.jsloader.load !== 'undefined')?(function (p1__34663_SHARP_,p2__34664_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34663_SHARP_)].join(''),p2__34664_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__34665 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__34665.addCallback(((function (G__34665){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__34665))
);

G__34665.addErrback(((function (G__34665){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__34665))
);

return G__34665;
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__34666 = cljs.core._EQ_;
var expr__34667 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__34666.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__34667))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__34666,expr__34667){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__34666,expr__34667))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__34666,expr__34667){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e34669){if((e34669 instanceof Error)){
var e = e34669;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e34669;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__34666,expr__34667))
} else {
if(cljs.core.truth_(pred__34666.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__34667))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__34666.call(null,new cljs.core.Keyword(null,"react-native","react-native",-1543085138),expr__34667))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__34666.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__34667))){
return ((function (pred__34666,expr__34667){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e34670){if((e34670 instanceof Error)){
var e = e34670;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e34670;

}
}})());
});
;})(pred__34666,expr__34667))
} else {
return ((function (pred__34666,expr__34667){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__34666,expr__34667))
}
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__34671,callback){
var map__34672 = p__34671;
var map__34672__$1 = ((((!((map__34672 == null)))?((((map__34672.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34672.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34672):map__34672);
var file_msg = map__34672__$1;
var request_url = cljs.core.get.call(null,map__34672__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__34672,map__34672__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__34672,map__34672__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__30946__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto__){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto__){
return (function (state_34696){
var state_val_34697 = (state_34696[(1)]);
if((state_val_34697 === (7))){
var inst_34692 = (state_34696[(2)]);
var state_34696__$1 = state_34696;
var statearr_34698_34715 = state_34696__$1;
(statearr_34698_34715[(2)] = inst_34692);

(statearr_34698_34715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34697 === (1))){
var state_34696__$1 = state_34696;
var statearr_34699_34716 = state_34696__$1;
(statearr_34699_34716[(2)] = null);

(statearr_34699_34716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34697 === (4))){
var inst_34676 = (state_34696[(7)]);
var inst_34676__$1 = (state_34696[(2)]);
var state_34696__$1 = (function (){var statearr_34700 = state_34696;
(statearr_34700[(7)] = inst_34676__$1);

return statearr_34700;
})();
if(cljs.core.truth_(inst_34676__$1)){
var statearr_34701_34717 = state_34696__$1;
(statearr_34701_34717[(1)] = (5));

} else {
var statearr_34702_34718 = state_34696__$1;
(statearr_34702_34718[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34697 === (6))){
var state_34696__$1 = state_34696;
var statearr_34703_34719 = state_34696__$1;
(statearr_34703_34719[(2)] = null);

(statearr_34703_34719[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34697 === (3))){
var inst_34694 = (state_34696[(2)]);
var state_34696__$1 = state_34696;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34696__$1,inst_34694);
} else {
if((state_val_34697 === (2))){
var state_34696__$1 = state_34696;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34696__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_34697 === (11))){
var inst_34688 = (state_34696[(2)]);
var state_34696__$1 = (function (){var statearr_34704 = state_34696;
(statearr_34704[(8)] = inst_34688);

return statearr_34704;
})();
var statearr_34705_34720 = state_34696__$1;
(statearr_34705_34720[(2)] = null);

(statearr_34705_34720[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34697 === (9))){
var inst_34680 = (state_34696[(9)]);
var inst_34682 = (state_34696[(10)]);
var inst_34684 = inst_34682.call(null,inst_34680);
var state_34696__$1 = state_34696;
var statearr_34706_34721 = state_34696__$1;
(statearr_34706_34721[(2)] = inst_34684);

(statearr_34706_34721[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34697 === (5))){
var inst_34676 = (state_34696[(7)]);
var inst_34678 = figwheel.client.file_reloading.blocking_load.call(null,inst_34676);
var state_34696__$1 = state_34696;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34696__$1,(8),inst_34678);
} else {
if((state_val_34697 === (10))){
var inst_34680 = (state_34696[(9)]);
var inst_34686 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_34680);
var state_34696__$1 = state_34696;
var statearr_34707_34722 = state_34696__$1;
(statearr_34707_34722[(2)] = inst_34686);

(statearr_34707_34722[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34697 === (8))){
var inst_34676 = (state_34696[(7)]);
var inst_34682 = (state_34696[(10)]);
var inst_34680 = (state_34696[(2)]);
var inst_34681 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_34682__$1 = cljs.core.get.call(null,inst_34681,inst_34676);
var state_34696__$1 = (function (){var statearr_34708 = state_34696;
(statearr_34708[(9)] = inst_34680);

(statearr_34708[(10)] = inst_34682__$1);

return statearr_34708;
})();
if(cljs.core.truth_(inst_34682__$1)){
var statearr_34709_34723 = state_34696__$1;
(statearr_34709_34723[(1)] = (9));

} else {
var statearr_34710_34724 = state_34696__$1;
(statearr_34710_34724[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto__))
;
return ((function (switch__30858__auto__,c__30946__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__30859__auto__ = null;
var figwheel$client$file_reloading$state_machine__30859__auto____0 = (function (){
var statearr_34711 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34711[(0)] = figwheel$client$file_reloading$state_machine__30859__auto__);

(statearr_34711[(1)] = (1));

return statearr_34711;
});
var figwheel$client$file_reloading$state_machine__30859__auto____1 = (function (state_34696){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_34696);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e34712){if((e34712 instanceof Object)){
var ex__30862__auto__ = e34712;
var statearr_34713_34725 = state_34696;
(statearr_34713_34725[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34696);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34712;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34726 = state_34696;
state_34696 = G__34726;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__30859__auto__ = function(state_34696){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__30859__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__30859__auto____1.call(this,state_34696);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__30859__auto____0;
figwheel$client$file_reloading$state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__30859__auto____1;
return figwheel$client$file_reloading$state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto__))
})();
var state__30948__auto__ = (function (){var statearr_34714 = f__30947__auto__.call(null);
(statearr_34714[(6)] = c__30946__auto__);

return statearr_34714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto__))
);

return c__30946__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__34727,callback){
var map__34728 = p__34727;
var map__34728__$1 = ((((!((map__34728 == null)))?((((map__34728.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34728.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34728):map__34728);
var file_msg = map__34728__$1;
var namespace = cljs.core.get.call(null,map__34728__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__34728,map__34728__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__34728,map__34728__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__34730){
var map__34731 = p__34730;
var map__34731__$1 = ((((!((map__34731 == null)))?((((map__34731.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34731.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34731):map__34731);
var file_msg = map__34731__$1;
var namespace = cljs.core.get.call(null,map__34731__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__34733){
var map__34734 = p__34733;
var map__34734__$1 = ((((!((map__34734 == null)))?((((map__34734.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34734.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34734):map__34734);
var file_msg = map__34734__$1;
var namespace = cljs.core.get.call(null,map__34734__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__28335__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__28335__auto__){
var or__28347__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
var or__28347__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28347__auto____$1)){
return or__28347__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__28335__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__34736,callback){
var map__34737 = p__34736;
var map__34737__$1 = ((((!((map__34737 == null)))?((((map__34737.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34737.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34737):map__34737);
var file_msg = map__34737__$1;
var request_url = cljs.core.get.call(null,map__34737__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__34737__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__30946__auto___34787 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto___34787,out){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto___34787,out){
return (function (state_34772){
var state_val_34773 = (state_34772[(1)]);
if((state_val_34773 === (1))){
var inst_34746 = cljs.core.seq.call(null,files);
var inst_34747 = cljs.core.first.call(null,inst_34746);
var inst_34748 = cljs.core.next.call(null,inst_34746);
var inst_34749 = files;
var state_34772__$1 = (function (){var statearr_34774 = state_34772;
(statearr_34774[(7)] = inst_34748);

(statearr_34774[(8)] = inst_34747);

(statearr_34774[(9)] = inst_34749);

return statearr_34774;
})();
var statearr_34775_34788 = state_34772__$1;
(statearr_34775_34788[(2)] = null);

(statearr_34775_34788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34773 === (2))){
var inst_34755 = (state_34772[(10)]);
var inst_34749 = (state_34772[(9)]);
var inst_34754 = cljs.core.seq.call(null,inst_34749);
var inst_34755__$1 = cljs.core.first.call(null,inst_34754);
var inst_34756 = cljs.core.next.call(null,inst_34754);
var inst_34757 = (inst_34755__$1 == null);
var inst_34758 = cljs.core.not.call(null,inst_34757);
var state_34772__$1 = (function (){var statearr_34776 = state_34772;
(statearr_34776[(10)] = inst_34755__$1);

(statearr_34776[(11)] = inst_34756);

return statearr_34776;
})();
if(inst_34758){
var statearr_34777_34789 = state_34772__$1;
(statearr_34777_34789[(1)] = (4));

} else {
var statearr_34778_34790 = state_34772__$1;
(statearr_34778_34790[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34773 === (3))){
var inst_34770 = (state_34772[(2)]);
var state_34772__$1 = state_34772;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34772__$1,inst_34770);
} else {
if((state_val_34773 === (4))){
var inst_34755 = (state_34772[(10)]);
var inst_34760 = figwheel.client.file_reloading.reload_js_file.call(null,inst_34755);
var state_34772__$1 = state_34772;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34772__$1,(7),inst_34760);
} else {
if((state_val_34773 === (5))){
var inst_34766 = cljs.core.async.close_BANG_.call(null,out);
var state_34772__$1 = state_34772;
var statearr_34779_34791 = state_34772__$1;
(statearr_34779_34791[(2)] = inst_34766);

(statearr_34779_34791[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34773 === (6))){
var inst_34768 = (state_34772[(2)]);
var state_34772__$1 = state_34772;
var statearr_34780_34792 = state_34772__$1;
(statearr_34780_34792[(2)] = inst_34768);

(statearr_34780_34792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34773 === (7))){
var inst_34756 = (state_34772[(11)]);
var inst_34762 = (state_34772[(2)]);
var inst_34763 = cljs.core.async.put_BANG_.call(null,out,inst_34762);
var inst_34749 = inst_34756;
var state_34772__$1 = (function (){var statearr_34781 = state_34772;
(statearr_34781[(12)] = inst_34763);

(statearr_34781[(9)] = inst_34749);

return statearr_34781;
})();
var statearr_34782_34793 = state_34772__$1;
(statearr_34782_34793[(2)] = null);

(statearr_34782_34793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__30946__auto___34787,out))
;
return ((function (switch__30858__auto__,c__30946__auto___34787,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30859__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30859__auto____0 = (function (){
var statearr_34783 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34783[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30859__auto__);

(statearr_34783[(1)] = (1));

return statearr_34783;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30859__auto____1 = (function (state_34772){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_34772);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e34784){if((e34784 instanceof Object)){
var ex__30862__auto__ = e34784;
var statearr_34785_34794 = state_34772;
(statearr_34785_34794[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34772);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34784;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34795 = state_34772;
state_34772 = G__34795;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30859__auto__ = function(state_34772){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30859__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30859__auto____1.call(this,state_34772);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30859__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30859__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto___34787,out))
})();
var state__30948__auto__ = (function (){var statearr_34786 = f__30947__auto__.call(null);
(statearr_34786[(6)] = c__30946__auto___34787);

return statearr_34786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto___34787,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__34796,opts){
var map__34797 = p__34796;
var map__34797__$1 = ((((!((map__34797 == null)))?((((map__34797.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34797.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34797):map__34797);
var eval_body = cljs.core.get.call(null,map__34797__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__34797__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__28335__auto__ = eval_body;
if(cljs.core.truth_(and__28335__auto__)){
return typeof eval_body === 'string';
} else {
return and__28335__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e34799){var e = e34799;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__34800_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__34800_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__34801){
var vec__34802 = p__34801;
var k = cljs.core.nth.call(null,vec__34802,(0),null);
var v = cljs.core.nth.call(null,vec__34802,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__34805){
var vec__34806 = p__34805;
var k = cljs.core.nth.call(null,vec__34806,(0),null);
var v = cljs.core.nth.call(null,vec__34806,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__34812,p__34813){
var map__34814 = p__34812;
var map__34814__$1 = ((((!((map__34814 == null)))?((((map__34814.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34814.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34814):map__34814);
var opts = map__34814__$1;
var before_jsload = cljs.core.get.call(null,map__34814__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__34814__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__34814__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__34815 = p__34813;
var map__34815__$1 = ((((!((map__34815 == null)))?((((map__34815.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34815.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34815):map__34815);
var msg = map__34815__$1;
var files = cljs.core.get.call(null,map__34815__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__34815__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__34815__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__30946__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__30947__auto__ = (function (){var switch__30858__auto__ = ((function (c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_34969){
var state_val_34970 = (state_34969[(1)]);
if((state_val_34970 === (7))){
var inst_34831 = (state_34969[(7)]);
var inst_34829 = (state_34969[(8)]);
var inst_34830 = (state_34969[(9)]);
var inst_34832 = (state_34969[(10)]);
var inst_34837 = cljs.core._nth.call(null,inst_34830,inst_34832);
var inst_34838 = figwheel.client.file_reloading.eval_body.call(null,inst_34837,opts);
var inst_34839 = (inst_34832 + (1));
var tmp34971 = inst_34831;
var tmp34972 = inst_34829;
var tmp34973 = inst_34830;
var inst_34829__$1 = tmp34972;
var inst_34830__$1 = tmp34973;
var inst_34831__$1 = tmp34971;
var inst_34832__$1 = inst_34839;
var state_34969__$1 = (function (){var statearr_34974 = state_34969;
(statearr_34974[(7)] = inst_34831__$1);

(statearr_34974[(8)] = inst_34829__$1);

(statearr_34974[(9)] = inst_34830__$1);

(statearr_34974[(11)] = inst_34838);

(statearr_34974[(10)] = inst_34832__$1);

return statearr_34974;
})();
var statearr_34975_35058 = state_34969__$1;
(statearr_34975_35058[(2)] = null);

(statearr_34975_35058[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (20))){
var inst_34872 = (state_34969[(12)]);
var inst_34880 = figwheel.client.file_reloading.sort_files.call(null,inst_34872);
var state_34969__$1 = state_34969;
var statearr_34976_35059 = state_34969__$1;
(statearr_34976_35059[(2)] = inst_34880);

(statearr_34976_35059[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (27))){
var state_34969__$1 = state_34969;
var statearr_34977_35060 = state_34969__$1;
(statearr_34977_35060[(2)] = null);

(statearr_34977_35060[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (1))){
var inst_34821 = (state_34969[(13)]);
var inst_34818 = before_jsload.call(null,files);
var inst_34819 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_34820 = (function (){return ((function (inst_34821,inst_34818,inst_34819,state_val_34970,c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__34809_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__34809_SHARP_);
});
;})(inst_34821,inst_34818,inst_34819,state_val_34970,c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34821__$1 = cljs.core.filter.call(null,inst_34820,files);
var inst_34822 = cljs.core.not_empty.call(null,inst_34821__$1);
var state_34969__$1 = (function (){var statearr_34978 = state_34969;
(statearr_34978[(14)] = inst_34819);

(statearr_34978[(15)] = inst_34818);

(statearr_34978[(13)] = inst_34821__$1);

return statearr_34978;
})();
if(cljs.core.truth_(inst_34822)){
var statearr_34979_35061 = state_34969__$1;
(statearr_34979_35061[(1)] = (2));

} else {
var statearr_34980_35062 = state_34969__$1;
(statearr_34980_35062[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (24))){
var state_34969__$1 = state_34969;
var statearr_34981_35063 = state_34969__$1;
(statearr_34981_35063[(2)] = null);

(statearr_34981_35063[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (39))){
var inst_34922 = (state_34969[(16)]);
var state_34969__$1 = state_34969;
var statearr_34982_35064 = state_34969__$1;
(statearr_34982_35064[(2)] = inst_34922);

(statearr_34982_35064[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (46))){
var inst_34964 = (state_34969[(2)]);
var state_34969__$1 = state_34969;
var statearr_34983_35065 = state_34969__$1;
(statearr_34983_35065[(2)] = inst_34964);

(statearr_34983_35065[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (4))){
var inst_34866 = (state_34969[(2)]);
var inst_34867 = cljs.core.List.EMPTY;
var inst_34868 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_34867);
var inst_34869 = (function (){return ((function (inst_34866,inst_34867,inst_34868,state_val_34970,c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__34810_SHARP_){
var and__28335__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__34810_SHARP_);
if(cljs.core.truth_(and__28335__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__34810_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__34810_SHARP_)));
} else {
return and__28335__auto__;
}
});
;})(inst_34866,inst_34867,inst_34868,state_val_34970,c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34870 = cljs.core.filter.call(null,inst_34869,files);
var inst_34871 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_34872 = cljs.core.concat.call(null,inst_34870,inst_34871);
var state_34969__$1 = (function (){var statearr_34984 = state_34969;
(statearr_34984[(17)] = inst_34866);

(statearr_34984[(12)] = inst_34872);

(statearr_34984[(18)] = inst_34868);

return statearr_34984;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_34985_35066 = state_34969__$1;
(statearr_34985_35066[(1)] = (16));

} else {
var statearr_34986_35067 = state_34969__$1;
(statearr_34986_35067[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (15))){
var inst_34856 = (state_34969[(2)]);
var state_34969__$1 = state_34969;
var statearr_34987_35068 = state_34969__$1;
(statearr_34987_35068[(2)] = inst_34856);

(statearr_34987_35068[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (21))){
var inst_34882 = (state_34969[(19)]);
var inst_34882__$1 = (state_34969[(2)]);
var inst_34883 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_34882__$1);
var state_34969__$1 = (function (){var statearr_34988 = state_34969;
(statearr_34988[(19)] = inst_34882__$1);

return statearr_34988;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34969__$1,(22),inst_34883);
} else {
if((state_val_34970 === (31))){
var inst_34967 = (state_34969[(2)]);
var state_34969__$1 = state_34969;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34969__$1,inst_34967);
} else {
if((state_val_34970 === (32))){
var inst_34922 = (state_34969[(16)]);
var inst_34927 = inst_34922.cljs$lang$protocol_mask$partition0$;
var inst_34928 = (inst_34927 & (64));
var inst_34929 = inst_34922.cljs$core$ISeq$;
var inst_34930 = (cljs.core.PROTOCOL_SENTINEL === inst_34929);
var inst_34931 = (inst_34928) || (inst_34930);
var state_34969__$1 = state_34969;
if(cljs.core.truth_(inst_34931)){
var statearr_34989_35069 = state_34969__$1;
(statearr_34989_35069[(1)] = (35));

} else {
var statearr_34990_35070 = state_34969__$1;
(statearr_34990_35070[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (40))){
var inst_34944 = (state_34969[(20)]);
var inst_34943 = (state_34969[(2)]);
var inst_34944__$1 = cljs.core.get.call(null,inst_34943,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_34945 = cljs.core.get.call(null,inst_34943,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_34946 = cljs.core.not_empty.call(null,inst_34944__$1);
var state_34969__$1 = (function (){var statearr_34991 = state_34969;
(statearr_34991[(20)] = inst_34944__$1);

(statearr_34991[(21)] = inst_34945);

return statearr_34991;
})();
if(cljs.core.truth_(inst_34946)){
var statearr_34992_35071 = state_34969__$1;
(statearr_34992_35071[(1)] = (41));

} else {
var statearr_34993_35072 = state_34969__$1;
(statearr_34993_35072[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (33))){
var state_34969__$1 = state_34969;
var statearr_34994_35073 = state_34969__$1;
(statearr_34994_35073[(2)] = false);

(statearr_34994_35073[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (13))){
var inst_34842 = (state_34969[(22)]);
var inst_34846 = cljs.core.chunk_first.call(null,inst_34842);
var inst_34847 = cljs.core.chunk_rest.call(null,inst_34842);
var inst_34848 = cljs.core.count.call(null,inst_34846);
var inst_34829 = inst_34847;
var inst_34830 = inst_34846;
var inst_34831 = inst_34848;
var inst_34832 = (0);
var state_34969__$1 = (function (){var statearr_34995 = state_34969;
(statearr_34995[(7)] = inst_34831);

(statearr_34995[(8)] = inst_34829);

(statearr_34995[(9)] = inst_34830);

(statearr_34995[(10)] = inst_34832);

return statearr_34995;
})();
var statearr_34996_35074 = state_34969__$1;
(statearr_34996_35074[(2)] = null);

(statearr_34996_35074[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (22))){
var inst_34885 = (state_34969[(23)]);
var inst_34886 = (state_34969[(24)]);
var inst_34882 = (state_34969[(19)]);
var inst_34890 = (state_34969[(25)]);
var inst_34885__$1 = (state_34969[(2)]);
var inst_34886__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_34885__$1);
var inst_34887 = (function (){var all_files = inst_34882;
var res_SINGLEQUOTE_ = inst_34885__$1;
var res = inst_34886__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_34885,inst_34886,inst_34882,inst_34890,inst_34885__$1,inst_34886__$1,state_val_34970,c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__34811_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__34811_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_34885,inst_34886,inst_34882,inst_34890,inst_34885__$1,inst_34886__$1,state_val_34970,c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34888 = cljs.core.filter.call(null,inst_34887,inst_34885__$1);
var inst_34889 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_34890__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_34889);
var inst_34891 = cljs.core.not_empty.call(null,inst_34890__$1);
var state_34969__$1 = (function (){var statearr_34997 = state_34969;
(statearr_34997[(23)] = inst_34885__$1);

(statearr_34997[(24)] = inst_34886__$1);

(statearr_34997[(26)] = inst_34888);

(statearr_34997[(25)] = inst_34890__$1);

return statearr_34997;
})();
if(cljs.core.truth_(inst_34891)){
var statearr_34998_35075 = state_34969__$1;
(statearr_34998_35075[(1)] = (23));

} else {
var statearr_34999_35076 = state_34969__$1;
(statearr_34999_35076[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (36))){
var state_34969__$1 = state_34969;
var statearr_35000_35077 = state_34969__$1;
(statearr_35000_35077[(2)] = false);

(statearr_35000_35077[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (41))){
var inst_34944 = (state_34969[(20)]);
var inst_34948 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_34949 = cljs.core.map.call(null,inst_34948,inst_34944);
var inst_34950 = cljs.core.pr_str.call(null,inst_34949);
var inst_34951 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34950)].join('');
var inst_34952 = figwheel.client.utils.log.call(null,inst_34951);
var state_34969__$1 = state_34969;
var statearr_35001_35078 = state_34969__$1;
(statearr_35001_35078[(2)] = inst_34952);

(statearr_35001_35078[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (43))){
var inst_34945 = (state_34969[(21)]);
var inst_34955 = (state_34969[(2)]);
var inst_34956 = cljs.core.not_empty.call(null,inst_34945);
var state_34969__$1 = (function (){var statearr_35002 = state_34969;
(statearr_35002[(27)] = inst_34955);

return statearr_35002;
})();
if(cljs.core.truth_(inst_34956)){
var statearr_35003_35079 = state_34969__$1;
(statearr_35003_35079[(1)] = (44));

} else {
var statearr_35004_35080 = state_34969__$1;
(statearr_35004_35080[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (29))){
var inst_34885 = (state_34969[(23)]);
var inst_34886 = (state_34969[(24)]);
var inst_34882 = (state_34969[(19)]);
var inst_34888 = (state_34969[(26)]);
var inst_34890 = (state_34969[(25)]);
var inst_34922 = (state_34969[(16)]);
var inst_34918 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_34921 = (function (){var all_files = inst_34882;
var res_SINGLEQUOTE_ = inst_34885;
var res = inst_34886;
var files_not_loaded = inst_34888;
var dependencies_that_loaded = inst_34890;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34885,inst_34886,inst_34882,inst_34888,inst_34890,inst_34922,inst_34918,state_val_34970,c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34920){
var map__35005 = p__34920;
var map__35005__$1 = ((((!((map__35005 == null)))?((((map__35005.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35005.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35005):map__35005);
var namespace = cljs.core.get.call(null,map__35005__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34885,inst_34886,inst_34882,inst_34888,inst_34890,inst_34922,inst_34918,state_val_34970,c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34922__$1 = cljs.core.group_by.call(null,inst_34921,inst_34888);
var inst_34924 = (inst_34922__$1 == null);
var inst_34925 = cljs.core.not.call(null,inst_34924);
var state_34969__$1 = (function (){var statearr_35007 = state_34969;
(statearr_35007[(28)] = inst_34918);

(statearr_35007[(16)] = inst_34922__$1);

return statearr_35007;
})();
if(inst_34925){
var statearr_35008_35081 = state_34969__$1;
(statearr_35008_35081[(1)] = (32));

} else {
var statearr_35009_35082 = state_34969__$1;
(statearr_35009_35082[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (44))){
var inst_34945 = (state_34969[(21)]);
var inst_34958 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_34945);
var inst_34959 = cljs.core.pr_str.call(null,inst_34958);
var inst_34960 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34959)].join('');
var inst_34961 = figwheel.client.utils.log.call(null,inst_34960);
var state_34969__$1 = state_34969;
var statearr_35010_35083 = state_34969__$1;
(statearr_35010_35083[(2)] = inst_34961);

(statearr_35010_35083[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (6))){
var inst_34863 = (state_34969[(2)]);
var state_34969__$1 = state_34969;
var statearr_35011_35084 = state_34969__$1;
(statearr_35011_35084[(2)] = inst_34863);

(statearr_35011_35084[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (28))){
var inst_34888 = (state_34969[(26)]);
var inst_34915 = (state_34969[(2)]);
var inst_34916 = cljs.core.not_empty.call(null,inst_34888);
var state_34969__$1 = (function (){var statearr_35012 = state_34969;
(statearr_35012[(29)] = inst_34915);

return statearr_35012;
})();
if(cljs.core.truth_(inst_34916)){
var statearr_35013_35085 = state_34969__$1;
(statearr_35013_35085[(1)] = (29));

} else {
var statearr_35014_35086 = state_34969__$1;
(statearr_35014_35086[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (25))){
var inst_34886 = (state_34969[(24)]);
var inst_34902 = (state_34969[(2)]);
var inst_34903 = cljs.core.not_empty.call(null,inst_34886);
var state_34969__$1 = (function (){var statearr_35015 = state_34969;
(statearr_35015[(30)] = inst_34902);

return statearr_35015;
})();
if(cljs.core.truth_(inst_34903)){
var statearr_35016_35087 = state_34969__$1;
(statearr_35016_35087[(1)] = (26));

} else {
var statearr_35017_35088 = state_34969__$1;
(statearr_35017_35088[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (34))){
var inst_34938 = (state_34969[(2)]);
var state_34969__$1 = state_34969;
if(cljs.core.truth_(inst_34938)){
var statearr_35018_35089 = state_34969__$1;
(statearr_35018_35089[(1)] = (38));

} else {
var statearr_35019_35090 = state_34969__$1;
(statearr_35019_35090[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (17))){
var state_34969__$1 = state_34969;
var statearr_35020_35091 = state_34969__$1;
(statearr_35020_35091[(2)] = recompile_dependents);

(statearr_35020_35091[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (3))){
var state_34969__$1 = state_34969;
var statearr_35021_35092 = state_34969__$1;
(statearr_35021_35092[(2)] = null);

(statearr_35021_35092[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (12))){
var inst_34859 = (state_34969[(2)]);
var state_34969__$1 = state_34969;
var statearr_35022_35093 = state_34969__$1;
(statearr_35022_35093[(2)] = inst_34859);

(statearr_35022_35093[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (2))){
var inst_34821 = (state_34969[(13)]);
var inst_34828 = cljs.core.seq.call(null,inst_34821);
var inst_34829 = inst_34828;
var inst_34830 = null;
var inst_34831 = (0);
var inst_34832 = (0);
var state_34969__$1 = (function (){var statearr_35023 = state_34969;
(statearr_35023[(7)] = inst_34831);

(statearr_35023[(8)] = inst_34829);

(statearr_35023[(9)] = inst_34830);

(statearr_35023[(10)] = inst_34832);

return statearr_35023;
})();
var statearr_35024_35094 = state_34969__$1;
(statearr_35024_35094[(2)] = null);

(statearr_35024_35094[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (23))){
var inst_34885 = (state_34969[(23)]);
var inst_34886 = (state_34969[(24)]);
var inst_34882 = (state_34969[(19)]);
var inst_34888 = (state_34969[(26)]);
var inst_34890 = (state_34969[(25)]);
var inst_34893 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_34895 = (function (){var all_files = inst_34882;
var res_SINGLEQUOTE_ = inst_34885;
var res = inst_34886;
var files_not_loaded = inst_34888;
var dependencies_that_loaded = inst_34890;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34885,inst_34886,inst_34882,inst_34888,inst_34890,inst_34893,state_val_34970,c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34894){
var map__35025 = p__34894;
var map__35025__$1 = ((((!((map__35025 == null)))?((((map__35025.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35025.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35025):map__35025);
var request_url = cljs.core.get.call(null,map__35025__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34885,inst_34886,inst_34882,inst_34888,inst_34890,inst_34893,state_val_34970,c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34896 = cljs.core.reverse.call(null,inst_34890);
var inst_34897 = cljs.core.map.call(null,inst_34895,inst_34896);
var inst_34898 = cljs.core.pr_str.call(null,inst_34897);
var inst_34899 = figwheel.client.utils.log.call(null,inst_34898);
var state_34969__$1 = (function (){var statearr_35027 = state_34969;
(statearr_35027[(31)] = inst_34893);

return statearr_35027;
})();
var statearr_35028_35095 = state_34969__$1;
(statearr_35028_35095[(2)] = inst_34899);

(statearr_35028_35095[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (35))){
var state_34969__$1 = state_34969;
var statearr_35029_35096 = state_34969__$1;
(statearr_35029_35096[(2)] = true);

(statearr_35029_35096[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (19))){
var inst_34872 = (state_34969[(12)]);
var inst_34878 = figwheel.client.file_reloading.expand_files.call(null,inst_34872);
var state_34969__$1 = state_34969;
var statearr_35030_35097 = state_34969__$1;
(statearr_35030_35097[(2)] = inst_34878);

(statearr_35030_35097[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (11))){
var state_34969__$1 = state_34969;
var statearr_35031_35098 = state_34969__$1;
(statearr_35031_35098[(2)] = null);

(statearr_35031_35098[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (9))){
var inst_34861 = (state_34969[(2)]);
var state_34969__$1 = state_34969;
var statearr_35032_35099 = state_34969__$1;
(statearr_35032_35099[(2)] = inst_34861);

(statearr_35032_35099[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (5))){
var inst_34831 = (state_34969[(7)]);
var inst_34832 = (state_34969[(10)]);
var inst_34834 = (inst_34832 < inst_34831);
var inst_34835 = inst_34834;
var state_34969__$1 = state_34969;
if(cljs.core.truth_(inst_34835)){
var statearr_35033_35100 = state_34969__$1;
(statearr_35033_35100[(1)] = (7));

} else {
var statearr_35034_35101 = state_34969__$1;
(statearr_35034_35101[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (14))){
var inst_34842 = (state_34969[(22)]);
var inst_34851 = cljs.core.first.call(null,inst_34842);
var inst_34852 = figwheel.client.file_reloading.eval_body.call(null,inst_34851,opts);
var inst_34853 = cljs.core.next.call(null,inst_34842);
var inst_34829 = inst_34853;
var inst_34830 = null;
var inst_34831 = (0);
var inst_34832 = (0);
var state_34969__$1 = (function (){var statearr_35035 = state_34969;
(statearr_35035[(7)] = inst_34831);

(statearr_35035[(8)] = inst_34829);

(statearr_35035[(32)] = inst_34852);

(statearr_35035[(9)] = inst_34830);

(statearr_35035[(10)] = inst_34832);

return statearr_35035;
})();
var statearr_35036_35102 = state_34969__$1;
(statearr_35036_35102[(2)] = null);

(statearr_35036_35102[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (45))){
var state_34969__$1 = state_34969;
var statearr_35037_35103 = state_34969__$1;
(statearr_35037_35103[(2)] = null);

(statearr_35037_35103[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (26))){
var inst_34885 = (state_34969[(23)]);
var inst_34886 = (state_34969[(24)]);
var inst_34882 = (state_34969[(19)]);
var inst_34888 = (state_34969[(26)]);
var inst_34890 = (state_34969[(25)]);
var inst_34905 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_34907 = (function (){var all_files = inst_34882;
var res_SINGLEQUOTE_ = inst_34885;
var res = inst_34886;
var files_not_loaded = inst_34888;
var dependencies_that_loaded = inst_34890;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34885,inst_34886,inst_34882,inst_34888,inst_34890,inst_34905,state_val_34970,c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__34906){
var map__35038 = p__34906;
var map__35038__$1 = ((((!((map__35038 == null)))?((((map__35038.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35038.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35038):map__35038);
var namespace = cljs.core.get.call(null,map__35038__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__35038__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34885,inst_34886,inst_34882,inst_34888,inst_34890,inst_34905,state_val_34970,c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34908 = cljs.core.map.call(null,inst_34907,inst_34886);
var inst_34909 = cljs.core.pr_str.call(null,inst_34908);
var inst_34910 = figwheel.client.utils.log.call(null,inst_34909);
var inst_34911 = (function (){var all_files = inst_34882;
var res_SINGLEQUOTE_ = inst_34885;
var res = inst_34886;
var files_not_loaded = inst_34888;
var dependencies_that_loaded = inst_34890;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34885,inst_34886,inst_34882,inst_34888,inst_34890,inst_34905,inst_34907,inst_34908,inst_34909,inst_34910,state_val_34970,c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_34885,inst_34886,inst_34882,inst_34888,inst_34890,inst_34905,inst_34907,inst_34908,inst_34909,inst_34910,state_val_34970,c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_34912 = setTimeout(inst_34911,(10));
var state_34969__$1 = (function (){var statearr_35040 = state_34969;
(statearr_35040[(33)] = inst_34905);

(statearr_35040[(34)] = inst_34910);

return statearr_35040;
})();
var statearr_35041_35104 = state_34969__$1;
(statearr_35041_35104[(2)] = inst_34912);

(statearr_35041_35104[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (16))){
var state_34969__$1 = state_34969;
var statearr_35042_35105 = state_34969__$1;
(statearr_35042_35105[(2)] = reload_dependents);

(statearr_35042_35105[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (38))){
var inst_34922 = (state_34969[(16)]);
var inst_34940 = cljs.core.apply.call(null,cljs.core.hash_map,inst_34922);
var state_34969__$1 = state_34969;
var statearr_35043_35106 = state_34969__$1;
(statearr_35043_35106[(2)] = inst_34940);

(statearr_35043_35106[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (30))){
var state_34969__$1 = state_34969;
var statearr_35044_35107 = state_34969__$1;
(statearr_35044_35107[(2)] = null);

(statearr_35044_35107[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (10))){
var inst_34842 = (state_34969[(22)]);
var inst_34844 = cljs.core.chunked_seq_QMARK_.call(null,inst_34842);
var state_34969__$1 = state_34969;
if(inst_34844){
var statearr_35045_35108 = state_34969__$1;
(statearr_35045_35108[(1)] = (13));

} else {
var statearr_35046_35109 = state_34969__$1;
(statearr_35046_35109[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (18))){
var inst_34876 = (state_34969[(2)]);
var state_34969__$1 = state_34969;
if(cljs.core.truth_(inst_34876)){
var statearr_35047_35110 = state_34969__$1;
(statearr_35047_35110[(1)] = (19));

} else {
var statearr_35048_35111 = state_34969__$1;
(statearr_35048_35111[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (42))){
var state_34969__$1 = state_34969;
var statearr_35049_35112 = state_34969__$1;
(statearr_35049_35112[(2)] = null);

(statearr_35049_35112[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (37))){
var inst_34935 = (state_34969[(2)]);
var state_34969__$1 = state_34969;
var statearr_35050_35113 = state_34969__$1;
(statearr_35050_35113[(2)] = inst_34935);

(statearr_35050_35113[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34970 === (8))){
var inst_34829 = (state_34969[(8)]);
var inst_34842 = (state_34969[(22)]);
var inst_34842__$1 = cljs.core.seq.call(null,inst_34829);
var state_34969__$1 = (function (){var statearr_35051 = state_34969;
(statearr_35051[(22)] = inst_34842__$1);

return statearr_35051;
})();
if(inst_34842__$1){
var statearr_35052_35114 = state_34969__$1;
(statearr_35052_35114[(1)] = (10));

} else {
var statearr_35053_35115 = state_34969__$1;
(statearr_35053_35115[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__30858__auto__,c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30859__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30859__auto____0 = (function (){
var statearr_35054 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35054[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__30859__auto__);

(statearr_35054[(1)] = (1));

return statearr_35054;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30859__auto____1 = (function (state_34969){
while(true){
var ret_value__30860__auto__ = (function (){try{while(true){
var result__30861__auto__ = switch__30858__auto__.call(null,state_34969);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30861__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30861__auto__;
}
break;
}
}catch (e35055){if((e35055 instanceof Object)){
var ex__30862__auto__ = e35055;
var statearr_35056_35116 = state_34969;
(statearr_35056_35116[(5)] = ex__30862__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34969);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35055;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30860__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35117 = state_34969;
state_34969 = G__35117;
continue;
} else {
return ret_value__30860__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__30859__auto__ = function(state_34969){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30859__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30859__auto____1.call(this,state_34969);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__30859__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__30859__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__30859__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30859__auto__;
})()
;})(switch__30858__auto__,c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__30948__auto__ = (function (){var statearr_35057 = f__30947__auto__.call(null);
(statearr_35057[(6)] = c__30946__auto__);

return statearr_35057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30948__auto__);
});})(c__30946__auto__,map__34814,map__34814__$1,opts,before_jsload,on_jsload,reload_dependents,map__34815,map__34815__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__30946__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__35120,link){
var map__35121 = p__35120;
var map__35121__$1 = ((((!((map__35121 == null)))?((((map__35121.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35121.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35121):map__35121);
var file = cljs.core.get.call(null,map__35121__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__35121,map__35121__$1,file){
return (function (p1__35118_SHARP_,p2__35119_SHARP_){
if(cljs.core._EQ_.call(null,p1__35118_SHARP_,p2__35119_SHARP_)){
return p1__35118_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__35121,map__35121__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__35124){
var map__35125 = p__35124;
var map__35125__$1 = ((((!((map__35125 == null)))?((((map__35125.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35125.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35125):map__35125);
var match_length = cljs.core.get.call(null,map__35125__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__35125__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__35123_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__35123_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__35127_SHARP_,p2__35128_SHARP_){
return cljs.core.assoc.call(null,p1__35127_SHARP_,cljs.core.get.call(null,p2__35128_SHARP_,key),p2__35128_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__4655__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4655__auto__)){
var link = temp__4655__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__4655__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__4655__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_35129 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_35129);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_35129);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__35130,p__35131){
var map__35132 = p__35130;
var map__35132__$1 = ((((!((map__35132 == null)))?((((map__35132.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35132.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35132):map__35132);
var on_cssload = cljs.core.get.call(null,map__35132__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__35133 = p__35131;
var map__35133__$1 = ((((!((map__35133 == null)))?((((map__35133.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35133.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35133):map__35133);
var files_msg = map__35133__$1;
var files = cljs.core.get.call(null,map__35133__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__4657__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__4657__auto__)){
var f_datas = temp__4657__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1503639571666
