// Compiled by ClojureScript 1.9.908 {}
goog.provide('cmr.client.http');
goog.require('cljs.core');
goog.require('cljs_http.client');
goog.require('cljs.core.async');
goog.require('cmr.client.ingest.util');
cmr.client.http.make_channel = (function cmr$client$http$make_channel(client){
if(cljs.core.truth_(cljs.core.get_in.call(null,client,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"parent-client-options","parent-client-options",-175529788),new cljs.core.Keyword(null,"return-body?","return-body?",930286761)], null)))){
return cljs.core.async.promise_chan.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"body","body",-2049205669)));
} else {
return cljs.core.async.promise_chan.call(null);
}
});
cmr.client.http.get_default_options = (function cmr$client$http$get_default_options(client){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222),false], null);
});
cmr.client.http.make_http_options = (function cmr$client$http$make_http_options(client,call_options){
return cljs.core.merge.call(null,cmr.client.http.get_default_options.call(null,client),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"channel","channel",734187692),cmr.client.http.make_channel.call(null,client)], null),new cljs.core.Keyword(null,"http-options","http-options",1919701946).cljs$core$IFn$_invoke$arity$1(client),call_options);
});

/**
 * An interface for ClojureScript HTTP clients.
 * @interface
 */
cmr.client.http.HTTPClientAPI = function(){};

cmr.client.http.get = (function cmr$client$http$get(var_args){
var G__36774 = arguments.length;
switch (G__36774) {
case 2:
return cmr.client.http.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cmr.client.http.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('cmr.client.http.get', cmr.client.http.get);

cmr.client.http.get.cljs$core$IFn$_invoke$arity$2 = (function (this$,url){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$get$arity$2 == null)))){
return this$.cmr$client$http$HTTPClientAPI$get$arity$2(this$,url);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.get[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url);
} else {
var m__29031__auto____$1 = (cmr.client.http.get["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.get",this$);
}
}
}
});

cmr.client.http.get.cljs$core$IFn$_invoke$arity$3 = (function (this$,url,opts){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$get$arity$3 == null)))){
return this$.cmr$client$http$HTTPClientAPI$get$arity$3(this$,url,opts);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.get[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url,opts);
} else {
var m__29031__auto____$1 = (cmr.client.http.get["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url,opts);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.get",this$);
}
}
}
});

cmr.client.http.get.cljs$lang$maxFixedArity = 3;


cmr.client.http.head = (function cmr$client$http$head(var_args){
var G__36776 = arguments.length;
switch (G__36776) {
case 2:
return cmr.client.http.head.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cmr.client.http.head.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('cmr.client.http.head', cmr.client.http.head);

cmr.client.http.head.cljs$core$IFn$_invoke$arity$2 = (function (this$,url){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$head$arity$2 == null)))){
return this$.cmr$client$http$HTTPClientAPI$head$arity$2(this$,url);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.head[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url);
} else {
var m__29031__auto____$1 = (cmr.client.http.head["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.head",this$);
}
}
}
});

cmr.client.http.head.cljs$core$IFn$_invoke$arity$3 = (function (this$,url,opts){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$head$arity$3 == null)))){
return this$.cmr$client$http$HTTPClientAPI$head$arity$3(this$,url,opts);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.head[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url,opts);
} else {
var m__29031__auto____$1 = (cmr.client.http.head["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url,opts);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.head",this$);
}
}
}
});

cmr.client.http.head.cljs$lang$maxFixedArity = 3;


cmr.client.http.put = (function cmr$client$http$put(var_args){
var G__36778 = arguments.length;
switch (G__36778) {
case 2:
return cmr.client.http.put.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cmr.client.http.put.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('cmr.client.http.put', cmr.client.http.put);

cmr.client.http.put.cljs$core$IFn$_invoke$arity$2 = (function (this$,url){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$put$arity$2 == null)))){
return this$.cmr$client$http$HTTPClientAPI$put$arity$2(this$,url);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.put[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url);
} else {
var m__29031__auto____$1 = (cmr.client.http.put["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.put",this$);
}
}
}
});

cmr.client.http.put.cljs$core$IFn$_invoke$arity$3 = (function (this$,url,opts){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$put$arity$3 == null)))){
return this$.cmr$client$http$HTTPClientAPI$put$arity$3(this$,url,opts);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.put[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url,opts);
} else {
var m__29031__auto____$1 = (cmr.client.http.put["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url,opts);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.put",this$);
}
}
}
});

cmr.client.http.put.cljs$lang$maxFixedArity = 3;


cmr.client.http.post = (function cmr$client$http$post(var_args){
var G__36780 = arguments.length;
switch (G__36780) {
case 2:
return cmr.client.http.post.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cmr.client.http.post.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('cmr.client.http.post', cmr.client.http.post);

cmr.client.http.post.cljs$core$IFn$_invoke$arity$2 = (function (this$,url){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$post$arity$2 == null)))){
return this$.cmr$client$http$HTTPClientAPI$post$arity$2(this$,url);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.post[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url);
} else {
var m__29031__auto____$1 = (cmr.client.http.post["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.post",this$);
}
}
}
});

cmr.client.http.post.cljs$core$IFn$_invoke$arity$3 = (function (this$,url,opts){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$post$arity$3 == null)))){
return this$.cmr$client$http$HTTPClientAPI$post$arity$3(this$,url,opts);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.post[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url,opts);
} else {
var m__29031__auto____$1 = (cmr.client.http.post["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url,opts);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.post",this$);
}
}
}
});

cmr.client.http.post.cljs$lang$maxFixedArity = 3;


cmr.client.http.delete$ = (function cmr$client$http$delete(var_args){
var G__36782 = arguments.length;
switch (G__36782) {
case 2:
return cmr.client.http.delete$.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cmr.client.http.delete$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('cmr.client.http.delete$', cmr.client.http.delete$);

cmr.client.http.delete$.cljs$core$IFn$_invoke$arity$2 = (function (this$,url){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$delete$arity$2 == null)))){
return this$.cmr$client$http$HTTPClientAPI$delete$arity$2(this$,url);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.delete$[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url);
} else {
var m__29031__auto____$1 = (cmr.client.http.delete$["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.delete",this$);
}
}
}
});

cmr.client.http.delete$.cljs$core$IFn$_invoke$arity$3 = (function (this$,url,opts){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$delete$arity$3 == null)))){
return this$.cmr$client$http$HTTPClientAPI$delete$arity$3(this$,url,opts);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.delete$[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url,opts);
} else {
var m__29031__auto____$1 = (cmr.client.http.delete$["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url,opts);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.delete",this$);
}
}
}
});

cmr.client.http.delete$.cljs$lang$maxFixedArity = 3;


cmr.client.http.copy = (function cmr$client$http$copy(var_args){
var G__36784 = arguments.length;
switch (G__36784) {
case 2:
return cmr.client.http.copy.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cmr.client.http.copy.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('cmr.client.http.copy', cmr.client.http.copy);

cmr.client.http.copy.cljs$core$IFn$_invoke$arity$2 = (function (this$,url){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$copy$arity$2 == null)))){
return this$.cmr$client$http$HTTPClientAPI$copy$arity$2(this$,url);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.copy[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url);
} else {
var m__29031__auto____$1 = (cmr.client.http.copy["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.copy",this$);
}
}
}
});

cmr.client.http.copy.cljs$core$IFn$_invoke$arity$3 = (function (this$,url,opts){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$copy$arity$3 == null)))){
return this$.cmr$client$http$HTTPClientAPI$copy$arity$3(this$,url,opts);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.copy[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url,opts);
} else {
var m__29031__auto____$1 = (cmr.client.http.copy["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url,opts);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.copy",this$);
}
}
}
});

cmr.client.http.copy.cljs$lang$maxFixedArity = 3;


cmr.client.http.move = (function cmr$client$http$move(var_args){
var G__36786 = arguments.length;
switch (G__36786) {
case 2:
return cmr.client.http.move.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cmr.client.http.move.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('cmr.client.http.move', cmr.client.http.move);

cmr.client.http.move.cljs$core$IFn$_invoke$arity$2 = (function (this$,url){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$move$arity$2 == null)))){
return this$.cmr$client$http$HTTPClientAPI$move$arity$2(this$,url);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.move[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url);
} else {
var m__29031__auto____$1 = (cmr.client.http.move["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.move",this$);
}
}
}
});

cmr.client.http.move.cljs$core$IFn$_invoke$arity$3 = (function (this$,url,opts){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$move$arity$3 == null)))){
return this$.cmr$client$http$HTTPClientAPI$move$arity$3(this$,url,opts);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.move[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url,opts);
} else {
var m__29031__auto____$1 = (cmr.client.http.move["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url,opts);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.move",this$);
}
}
}
});

cmr.client.http.move.cljs$lang$maxFixedArity = 3;


cmr.client.http.patch = (function cmr$client$http$patch(var_args){
var G__36788 = arguments.length;
switch (G__36788) {
case 2:
return cmr.client.http.patch.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cmr.client.http.patch.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('cmr.client.http.patch', cmr.client.http.patch);

cmr.client.http.patch.cljs$core$IFn$_invoke$arity$2 = (function (this$,url){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$patch$arity$2 == null)))){
return this$.cmr$client$http$HTTPClientAPI$patch$arity$2(this$,url);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.patch[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url);
} else {
var m__29031__auto____$1 = (cmr.client.http.patch["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.patch",this$);
}
}
}
});

cmr.client.http.patch.cljs$core$IFn$_invoke$arity$3 = (function (this$,url,opts){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$patch$arity$3 == null)))){
return this$.cmr$client$http$HTTPClientAPI$patch$arity$3(this$,url,opts);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.patch[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url,opts);
} else {
var m__29031__auto____$1 = (cmr.client.http.patch["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url,opts);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.patch",this$);
}
}
}
});

cmr.client.http.patch.cljs$lang$maxFixedArity = 3;


cmr.client.http.options = (function cmr$client$http$options(var_args){
var G__36790 = arguments.length;
switch (G__36790) {
case 2:
return cmr.client.http.options.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cmr.client.http.options.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('cmr.client.http.options', cmr.client.http.options);

cmr.client.http.options.cljs$core$IFn$_invoke$arity$2 = (function (this$,url){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$options$arity$2 == null)))){
return this$.cmr$client$http$HTTPClientAPI$options$arity$2(this$,url);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.options[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url);
} else {
var m__29031__auto____$1 = (cmr.client.http.options["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.options",this$);
}
}
}
});

cmr.client.http.options.cljs$core$IFn$_invoke$arity$3 = (function (this$,url,opts){
if((!((this$ == null))) && (!((this$.cmr$client$http$HTTPClientAPI$options$arity$3 == null)))){
return this$.cmr$client$http$HTTPClientAPI$options$arity$3(this$,url,opts);
} else {
var x__29030__auto__ = (((this$ == null))?null:this$);
var m__29031__auto__ = (cmr.client.http.options[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,this$,url,opts);
} else {
var m__29031__auto____$1 = (cmr.client.http.options["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,this$,url,opts);
} else {
throw cljs.core.missing_protocol.call(null,"HTTPClientAPI.options",this$);
}
}
}
});

cmr.client.http.options.cljs$lang$maxFixedArity = 3;



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cmr.client.http.HTTPClientData = (function (parent_client_options,http_options,__meta,__extmap,__hash){
this.parent_client_options = parent_client_options;
this.http_options = http_options;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
cmr.client.http.HTTPClientData.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__28987__auto__,k__28988__auto__){
var self__ = this;
var this__28987__auto____$1 = this;
return this__28987__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__28988__auto__,null);
});

cmr.client.http.HTTPClientData.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__28989__auto__,k36801,else__28990__auto__){
var self__ = this;
var this__28989__auto____$1 = this;
var G__36805 = k36801;
var G__36805__$1 = (((G__36805 instanceof cljs.core.Keyword))?G__36805.fqn:null);
switch (G__36805__$1) {
case "parent-client-options":
return self__.parent_client_options;

break;
case "http-options":
return self__.http_options;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k36801,else__28990__auto__);

}
});

cmr.client.http.HTTPClientData.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__29001__auto__,writer__29002__auto__,opts__29003__auto__){
var self__ = this;
var this__29001__auto____$1 = this;
var pr_pair__29004__auto__ = ((function (this__29001__auto____$1){
return (function (keyval__29005__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__29002__auto__,cljs.core.pr_writer,""," ","",opts__29003__auto__,keyval__29005__auto__);
});})(this__29001__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__29002__auto__,pr_pair__29004__auto__,"#cmr.client.http.HTTPClientData{",", ","}",opts__29003__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parent-client-options","parent-client-options",-175529788),self__.parent_client_options],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"http-options","http-options",1919701946),self__.http_options],null))], null),self__.__extmap));
});

cmr.client.http.HTTPClientData.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__36800){
var self__ = this;
var G__36800__$1 = this;
return (new cljs.core.RecordIter((0),G__36800__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"parent-client-options","parent-client-options",-175529788),new cljs.core.Keyword(null,"http-options","http-options",1919701946)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

cmr.client.http.HTTPClientData.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__28985__auto__){
var self__ = this;
var this__28985__auto____$1 = this;
return self__.__meta;
});

cmr.client.http.HTTPClientData.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__28982__auto__){
var self__ = this;
var this__28982__auto____$1 = this;
return (new cmr.client.http.HTTPClientData(self__.parent_client_options,self__.http_options,self__.__meta,self__.__extmap,self__.__hash));
});

cmr.client.http.HTTPClientData.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__28991__auto__){
var self__ = this;
var this__28991__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});

cmr.client.http.HTTPClientData.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__28983__auto__){
var self__ = this;
var this__28983__auto____$1 = this;
var h__28801__auto__ = self__.__hash;
if(!((h__28801__auto__ == null))){
return h__28801__auto__;
} else {
var h__28801__auto____$1 = ((function (h__28801__auto__,this__28983__auto____$1){
return (function (coll__28984__auto__){
return (-1244141832 ^ cljs.core.hash_unordered_coll.call(null,coll__28984__auto__));
});})(h__28801__auto__,this__28983__auto____$1))
.call(null,this__28983__auto____$1);
self__.__hash = h__28801__auto____$1;

return h__28801__auto____$1;
}
});

cmr.client.http.HTTPClientData.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this36802,other36803){
var self__ = this;
var this36802__$1 = this;
return (!((other36803 == null))) && ((this36802__$1.constructor === other36803.constructor)) && (cljs.core._EQ_.call(null,this36802__$1.parent_client_options,other36803.parent_client_options)) && (cljs.core._EQ_.call(null,this36802__$1.http_options,other36803.http_options)) && (cljs.core._EQ_.call(null,this36802__$1.__extmap,other36803.__extmap));
});

cmr.client.http.HTTPClientData.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__28996__auto__,k__28997__auto__){
var self__ = this;
var this__28996__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"parent-client-options","parent-client-options",-175529788),null,new cljs.core.Keyword(null,"http-options","http-options",1919701946),null], null), null),k__28997__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__28996__auto____$1),self__.__meta),k__28997__auto__);
} else {
return (new cmr.client.http.HTTPClientData(self__.parent_client_options,self__.http_options,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__28997__auto__)),null));
}
});

cmr.client.http.HTTPClientData.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__28994__auto__,k__28995__auto__,G__36800){
var self__ = this;
var this__28994__auto____$1 = this;
var pred__36806 = cljs.core.keyword_identical_QMARK_;
var expr__36807 = k__28995__auto__;
if(cljs.core.truth_(pred__36806.call(null,new cljs.core.Keyword(null,"parent-client-options","parent-client-options",-175529788),expr__36807))){
return (new cmr.client.http.HTTPClientData(G__36800,self__.http_options,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__36806.call(null,new cljs.core.Keyword(null,"http-options","http-options",1919701946),expr__36807))){
return (new cmr.client.http.HTTPClientData(self__.parent_client_options,G__36800,self__.__meta,self__.__extmap,null));
} else {
return (new cmr.client.http.HTTPClientData(self__.parent_client_options,self__.http_options,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__28995__auto__,G__36800),null));
}
}
});

cmr.client.http.HTTPClientData.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__28999__auto__){
var self__ = this;
var this__28999__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parent-client-options","parent-client-options",-175529788),self__.parent_client_options],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"http-options","http-options",1919701946),self__.http_options],null))], null),self__.__extmap));
});

cmr.client.http.HTTPClientData.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__28986__auto__,G__36800){
var self__ = this;
var this__28986__auto____$1 = this;
return (new cmr.client.http.HTTPClientData(self__.parent_client_options,self__.http_options,G__36800,self__.__extmap,self__.__hash));
});

cmr.client.http.HTTPClientData.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__28992__auto__,entry__28993__auto__){
var self__ = this;
var this__28992__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__28993__auto__)){
return this__28992__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__28993__auto__,(0)),cljs.core._nth.call(null,entry__28993__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__28992__auto____$1,entry__28993__auto__);
}
});

cmr.client.http.HTTPClientData.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parent-client-options","parent-client-options",1465001739,null),new cljs.core.Symbol(null,"http-options","http-options",-734733823,null)], null);
});

cmr.client.http.HTTPClientData.cljs$lang$type = true;

cmr.client.http.HTTPClientData.cljs$lang$ctorPrSeq = (function (this__29023__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"cmr.client.http/HTTPClientData");
});

cmr.client.http.HTTPClientData.cljs$lang$ctorPrWriter = (function (this__29023__auto__,writer__29024__auto__){
return cljs.core._write.call(null,writer__29024__auto__,"cmr.client.http/HTTPClientData");
});

cmr.client.http.__GT_HTTPClientData = (function cmr$client$http$__GT_HTTPClientData(parent_client_options,http_options){
return (new cmr.client.http.HTTPClientData(parent_client_options,http_options,null,null,null));
});

cmr.client.http.map__GT_HTTPClientData = (function cmr$client$http$map__GT_HTTPClientData(G__36804){
return (new cmr.client.http.HTTPClientData(new cljs.core.Keyword(null,"parent-client-options","parent-client-options",-175529788).cljs$core$IFn$_invoke$arity$1(G__36804),new cljs.core.Keyword(null,"http-options","http-options",1919701946).cljs$core$IFn$_invoke$arity$1(G__36804),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__36804,new cljs.core.Keyword(null,"parent-client-options","parent-client-options",-175529788),new cljs.core.Keyword(null,"http-options","http-options",1919701946))),null));
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$ = cljs.core.PROTOCOL_SENTINEL;

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$get$arity$2 = (function (this$,url){
var this$__$1 = this;
return cmr.client.http.get.call(null,this$__$1,url,cljs.core.PersistentArrayMap.EMPTY);
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$get$arity$3 = (function (this$,url,options){
var this$__$1 = this;
return cljs_http.client.get.call(null,url,cmr.client.http.make_http_options.call(null,this$__$1,options));
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$head$arity$2 = (function (this$,url){
var this$__$1 = this;
return cmr.client.http.head.call(null,this$__$1,url,cljs.core.PersistentArrayMap.EMPTY);
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$head$arity$3 = (function (this$,url,options){
var this$__$1 = this;
return new cljs.core.Keyword(null,"not-implemented","not-implemented",1918806714);
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$put$arity$2 = (function (this$,url){
var this$__$1 = this;
return cmr.client.http.put.call(null,this$__$1,url,cljs.core.PersistentArrayMap.EMPTY);
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$put$arity$3 = (function (this$,url,options){
var this$__$1 = this;
return new cljs.core.Keyword(null,"not-implemented","not-implemented",1918806714);
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$post$arity$2 = (function (this$,url){
var this$__$1 = this;
return cmr.client.http.post.call(null,this$__$1,url,cljs.core.PersistentArrayMap.EMPTY);
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$post$arity$3 = (function (this$,url,options){
var this$__$1 = this;
return new cljs.core.Keyword(null,"not-implemented","not-implemented",1918806714);
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$delete$arity$2 = (function (this$,url){
var this$__$1 = this;
return cmr.client.http.delete$.call(null,this$__$1,url,cljs.core.PersistentArrayMap.EMPTY);
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$delete$arity$3 = (function (this$,url,options){
var this$__$1 = this;
return new cljs.core.Keyword(null,"not-implemented","not-implemented",1918806714);
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$copy$arity$2 = (function (this$,url){
var this$__$1 = this;
return cmr.client.http.copy.call(null,this$__$1,url,cljs.core.PersistentArrayMap.EMPTY);
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$copy$arity$3 = (function (this$,url,options){
var this$__$1 = this;
return new cljs.core.Keyword(null,"not-implemented","not-implemented",1918806714);
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$move$arity$2 = (function (this$,url){
var this$__$1 = this;
return cmr.client.http.move.call(null,this$__$1,url,cljs.core.PersistentArrayMap.EMPTY);
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$move$arity$3 = (function (this$,url,options){
var this$__$1 = this;
return new cljs.core.Keyword(null,"not-implemented","not-implemented",1918806714);
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$patch$arity$2 = (function (this$,url){
var this$__$1 = this;
return cmr.client.http.patch.call(null,this$__$1,url,cljs.core.PersistentArrayMap.EMPTY);
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$patch$arity$3 = (function (this$,url,options){
var this$__$1 = this;
return new cljs.core.Keyword(null,"not-implemented","not-implemented",1918806714);
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$options$arity$2 = (function (this$,url){
var this$__$1 = this;
return cmr.client.http.options.call(null,this$__$1,url,cljs.core.PersistentArrayMap.EMPTY);
});

cmr.client.http.HTTPClientData.prototype.cmr$client$http$HTTPClientAPI$options$arity$3 = (function (this$,url,options){
var this$__$1 = this;
return new cljs.core.Keyword(null,"not-implemented","not-implemented",1918806714);
});
cmr.client.http.create_client = (function cmr$client$http$create_client(var_args){
var G__36811 = arguments.length;
switch (G__36811) {
case 0:
return cmr.client.http.create_client.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cmr.client.http.create_client.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cmr.client.http.create_client.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('cmr.client.http.create_client', cmr.client.http.create_client);

cmr.client.http.create_client.cljs$core$IFn$_invoke$arity$0 = (function (){
return cmr.client.http.create_client.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

cmr.client.http.create_client.cljs$core$IFn$_invoke$arity$1 = (function (http_options){
return cmr.client.http.create_client.call(null,cljs.core.PersistentArrayMap.EMPTY,http_options);
});

cmr.client.http.create_client.cljs$core$IFn$_invoke$arity$2 = (function (parent_client_options,http_options){
return cmr.client.http.__GT_HTTPClientData.call(null,parent_client_options,http_options);
});

cmr.client.http.create_client.cljs$lang$maxFixedArity = 2;


//# sourceMappingURL=http.js.map?rel=1503783871183
