// Compiled by ClojureScript 1.9.908 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.13";
figwheel.client.js_stringify = (((typeof JSON !== 'undefined') && (!((JSON.stringify == null))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e32292){if((e32292 instanceof Error)){
var e = e32292;
return "Error: Unable to stringify";
} else {
throw e32292;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__32295 = arguments.length;
switch (G__32295) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__32293_SHARP_){
if(typeof p1__32293_SHARP_ === 'string'){
return p1__32293_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__32293_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__29523__auto__ = [];
var len__29516__auto___32298 = arguments.length;
var i__29517__auto___32299 = (0);
while(true){
if((i__29517__auto___32299 < len__29516__auto___32298)){
args__29523__auto__.push((arguments[i__29517__auto___32299]));

var G__32300 = (i__29517__auto___32299 + (1));
i__29517__auto___32299 = G__32300;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((0) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29524__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq32297){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq32297));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__29523__auto__ = [];
var len__29516__auto___32302 = arguments.length;
var i__29517__auto___32303 = (0);
while(true){
if((i__29517__auto___32303 < len__29516__auto___32302)){
args__29523__auto__.push((arguments[i__29517__auto___32303]));

var G__32304 = (i__29517__auto___32303 + (1));
i__29517__auto___32303 = G__32304;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((0) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29524__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq32301){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq32301));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__32305){
var map__32306 = p__32305;
var map__32306__$1 = ((((!((map__32306 == null)))?((((map__32306.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32306.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32306):map__32306);
var message = cljs.core.get.call(null,map__32306__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__32306__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__28347__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__28335__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__28335__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__28335__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__31003__auto___32385 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31003__auto___32385,ch){
return (function (){
var f__31004__auto__ = (function (){var switch__30982__auto__ = ((function (c__31003__auto___32385,ch){
return (function (state_32357){
var state_val_32358 = (state_32357[(1)]);
if((state_val_32358 === (7))){
var inst_32353 = (state_32357[(2)]);
var state_32357__$1 = state_32357;
var statearr_32359_32386 = state_32357__$1;
(statearr_32359_32386[(2)] = inst_32353);

(statearr_32359_32386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32358 === (1))){
var state_32357__$1 = state_32357;
var statearr_32360_32387 = state_32357__$1;
(statearr_32360_32387[(2)] = null);

(statearr_32360_32387[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32358 === (4))){
var inst_32310 = (state_32357[(7)]);
var inst_32310__$1 = (state_32357[(2)]);
var state_32357__$1 = (function (){var statearr_32361 = state_32357;
(statearr_32361[(7)] = inst_32310__$1);

return statearr_32361;
})();
if(cljs.core.truth_(inst_32310__$1)){
var statearr_32362_32388 = state_32357__$1;
(statearr_32362_32388[(1)] = (5));

} else {
var statearr_32363_32389 = state_32357__$1;
(statearr_32363_32389[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32358 === (15))){
var inst_32317 = (state_32357[(8)]);
var inst_32332 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_32317);
var inst_32333 = cljs.core.first.call(null,inst_32332);
var inst_32334 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_32333);
var inst_32335 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32334)].join('');
var inst_32336 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_32335);
var state_32357__$1 = state_32357;
var statearr_32364_32390 = state_32357__$1;
(statearr_32364_32390[(2)] = inst_32336);

(statearr_32364_32390[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32358 === (13))){
var inst_32341 = (state_32357[(2)]);
var state_32357__$1 = state_32357;
var statearr_32365_32391 = state_32357__$1;
(statearr_32365_32391[(2)] = inst_32341);

(statearr_32365_32391[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32358 === (6))){
var state_32357__$1 = state_32357;
var statearr_32366_32392 = state_32357__$1;
(statearr_32366_32392[(2)] = null);

(statearr_32366_32392[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32358 === (17))){
var inst_32339 = (state_32357[(2)]);
var state_32357__$1 = state_32357;
var statearr_32367_32393 = state_32357__$1;
(statearr_32367_32393[(2)] = inst_32339);

(statearr_32367_32393[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32358 === (3))){
var inst_32355 = (state_32357[(2)]);
var state_32357__$1 = state_32357;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32357__$1,inst_32355);
} else {
if((state_val_32358 === (12))){
var inst_32316 = (state_32357[(9)]);
var inst_32330 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_32316,opts);
var state_32357__$1 = state_32357;
if(cljs.core.truth_(inst_32330)){
var statearr_32368_32394 = state_32357__$1;
(statearr_32368_32394[(1)] = (15));

} else {
var statearr_32369_32395 = state_32357__$1;
(statearr_32369_32395[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32358 === (2))){
var state_32357__$1 = state_32357;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32357__$1,(4),ch);
} else {
if((state_val_32358 === (11))){
var inst_32317 = (state_32357[(8)]);
var inst_32322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32323 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_32317);
var inst_32324 = cljs.core.async.timeout.call(null,(1000));
var inst_32325 = [inst_32323,inst_32324];
var inst_32326 = (new cljs.core.PersistentVector(null,2,(5),inst_32322,inst_32325,null));
var state_32357__$1 = state_32357;
return cljs.core.async.ioc_alts_BANG_.call(null,state_32357__$1,(14),inst_32326);
} else {
if((state_val_32358 === (9))){
var inst_32317 = (state_32357[(8)]);
var inst_32343 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_32344 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_32317);
var inst_32345 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_32344);
var inst_32346 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32345)].join('');
var inst_32347 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_32346);
var state_32357__$1 = (function (){var statearr_32370 = state_32357;
(statearr_32370[(10)] = inst_32343);

return statearr_32370;
})();
var statearr_32371_32396 = state_32357__$1;
(statearr_32371_32396[(2)] = inst_32347);

(statearr_32371_32396[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32358 === (5))){
var inst_32310 = (state_32357[(7)]);
var inst_32312 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_32313 = (new cljs.core.PersistentArrayMap(null,2,inst_32312,null));
var inst_32314 = (new cljs.core.PersistentHashSet(null,inst_32313,null));
var inst_32315 = figwheel.client.focus_msgs.call(null,inst_32314,inst_32310);
var inst_32316 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_32315);
var inst_32317 = cljs.core.first.call(null,inst_32315);
var inst_32318 = figwheel.client.autoload_QMARK_.call(null);
var state_32357__$1 = (function (){var statearr_32372 = state_32357;
(statearr_32372[(8)] = inst_32317);

(statearr_32372[(9)] = inst_32316);

return statearr_32372;
})();
if(cljs.core.truth_(inst_32318)){
var statearr_32373_32397 = state_32357__$1;
(statearr_32373_32397[(1)] = (8));

} else {
var statearr_32374_32398 = state_32357__$1;
(statearr_32374_32398[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32358 === (14))){
var inst_32328 = (state_32357[(2)]);
var state_32357__$1 = state_32357;
var statearr_32375_32399 = state_32357__$1;
(statearr_32375_32399[(2)] = inst_32328);

(statearr_32375_32399[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32358 === (16))){
var state_32357__$1 = state_32357;
var statearr_32376_32400 = state_32357__$1;
(statearr_32376_32400[(2)] = null);

(statearr_32376_32400[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32358 === (10))){
var inst_32349 = (state_32357[(2)]);
var state_32357__$1 = (function (){var statearr_32377 = state_32357;
(statearr_32377[(11)] = inst_32349);

return statearr_32377;
})();
var statearr_32378_32401 = state_32357__$1;
(statearr_32378_32401[(2)] = null);

(statearr_32378_32401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32358 === (8))){
var inst_32316 = (state_32357[(9)]);
var inst_32320 = figwheel.client.reload_file_state_QMARK_.call(null,inst_32316,opts);
var state_32357__$1 = state_32357;
if(cljs.core.truth_(inst_32320)){
var statearr_32379_32402 = state_32357__$1;
(statearr_32379_32402[(1)] = (11));

} else {
var statearr_32380_32403 = state_32357__$1;
(statearr_32380_32403[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31003__auto___32385,ch))
;
return ((function (switch__30982__auto__,c__31003__auto___32385,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__30983__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__30983__auto____0 = (function (){
var statearr_32381 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32381[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__30983__auto__);

(statearr_32381[(1)] = (1));

return statearr_32381;
});
var figwheel$client$file_reloader_plugin_$_state_machine__30983__auto____1 = (function (state_32357){
while(true){
var ret_value__30984__auto__ = (function (){try{while(true){
var result__30985__auto__ = switch__30982__auto__.call(null,state_32357);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30985__auto__;
}
break;
}
}catch (e32382){if((e32382 instanceof Object)){
var ex__30986__auto__ = e32382;
var statearr_32383_32404 = state_32357;
(statearr_32383_32404[(5)] = ex__30986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32357);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32382;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32405 = state_32357;
state_32357 = G__32405;
continue;
} else {
return ret_value__30984__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__30983__auto__ = function(state_32357){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__30983__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__30983__auto____1.call(this,state_32357);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__30983__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__30983__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__30983__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__30983__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__30983__auto__;
})()
;})(switch__30982__auto__,c__31003__auto___32385,ch))
})();
var state__31005__auto__ = (function (){var statearr_32384 = f__31004__auto__.call(null);
(statearr_32384[(6)] = c__31003__auto___32385);

return statearr_32384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31005__auto__);
});})(c__31003__auto___32385,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__32406_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__32406_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_32408 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_32408){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e32407){if((e32407 instanceof Error)){
var e = e32407;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_32408], null));
} else {
var e = e32407;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_32408))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__32409){
var map__32410 = p__32409;
var map__32410__$1 = ((((!((map__32410 == null)))?((((map__32410.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32410.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32410):map__32410);
var opts = map__32410__$1;
var build_id = cljs.core.get.call(null,map__32410__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__32410,map__32410__$1,opts,build_id){
return (function (p__32412){
var vec__32413 = p__32412;
var seq__32414 = cljs.core.seq.call(null,vec__32413);
var first__32415 = cljs.core.first.call(null,seq__32414);
var seq__32414__$1 = cljs.core.next.call(null,seq__32414);
var map__32416 = first__32415;
var map__32416__$1 = ((((!((map__32416 == null)))?((((map__32416.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32416.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32416):map__32416);
var msg = map__32416__$1;
var msg_name = cljs.core.get.call(null,map__32416__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__32414__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__32413,seq__32414,first__32415,seq__32414__$1,map__32416,map__32416__$1,msg,msg_name,_,map__32410,map__32410__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__32413,seq__32414,first__32415,seq__32414__$1,map__32416,map__32416__$1,msg,msg_name,_,map__32410,map__32410__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__32410,map__32410__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__32418){
var vec__32419 = p__32418;
var seq__32420 = cljs.core.seq.call(null,vec__32419);
var first__32421 = cljs.core.first.call(null,seq__32420);
var seq__32420__$1 = cljs.core.next.call(null,seq__32420);
var map__32422 = first__32421;
var map__32422__$1 = ((((!((map__32422 == null)))?((((map__32422.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32422.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32422):map__32422);
var msg = map__32422__$1;
var msg_name = cljs.core.get.call(null,map__32422__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__32420__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__32424){
var map__32425 = p__32424;
var map__32425__$1 = ((((!((map__32425 == null)))?((((map__32425.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32425.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32425):map__32425);
var on_compile_warning = cljs.core.get.call(null,map__32425__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__32425__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__32425,map__32425__$1,on_compile_warning,on_compile_fail){
return (function (p__32427){
var vec__32428 = p__32427;
var seq__32429 = cljs.core.seq.call(null,vec__32428);
var first__32430 = cljs.core.first.call(null,seq__32429);
var seq__32429__$1 = cljs.core.next.call(null,seq__32429);
var map__32431 = first__32430;
var map__32431__$1 = ((((!((map__32431 == null)))?((((map__32431.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32431.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32431):map__32431);
var msg = map__32431__$1;
var msg_name = cljs.core.get.call(null,map__32431__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__32429__$1;
var pred__32433 = cljs.core._EQ_;
var expr__32434 = msg_name;
if(cljs.core.truth_(pred__32433.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__32434))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__32433.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__32434))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__32425,map__32425__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__31003__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31003__auto__,msg_hist,msg_names,msg){
return (function (){
var f__31004__auto__ = (function (){var switch__30982__auto__ = ((function (c__31003__auto__,msg_hist,msg_names,msg){
return (function (state_32523){
var state_val_32524 = (state_32523[(1)]);
if((state_val_32524 === (7))){
var inst_32443 = (state_32523[(2)]);
var state_32523__$1 = state_32523;
if(cljs.core.truth_(inst_32443)){
var statearr_32525_32572 = state_32523__$1;
(statearr_32525_32572[(1)] = (8));

} else {
var statearr_32526_32573 = state_32523__$1;
(statearr_32526_32573[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (20))){
var inst_32517 = (state_32523[(2)]);
var state_32523__$1 = state_32523;
var statearr_32527_32574 = state_32523__$1;
(statearr_32527_32574[(2)] = inst_32517);

(statearr_32527_32574[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (27))){
var inst_32513 = (state_32523[(2)]);
var state_32523__$1 = state_32523;
var statearr_32528_32575 = state_32523__$1;
(statearr_32528_32575[(2)] = inst_32513);

(statearr_32528_32575[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (1))){
var inst_32436 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_32523__$1 = state_32523;
if(cljs.core.truth_(inst_32436)){
var statearr_32529_32576 = state_32523__$1;
(statearr_32529_32576[(1)] = (2));

} else {
var statearr_32530_32577 = state_32523__$1;
(statearr_32530_32577[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (24))){
var inst_32515 = (state_32523[(2)]);
var state_32523__$1 = state_32523;
var statearr_32531_32578 = state_32523__$1;
(statearr_32531_32578[(2)] = inst_32515);

(statearr_32531_32578[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (4))){
var inst_32521 = (state_32523[(2)]);
var state_32523__$1 = state_32523;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32523__$1,inst_32521);
} else {
if((state_val_32524 === (15))){
var inst_32519 = (state_32523[(2)]);
var state_32523__$1 = state_32523;
var statearr_32532_32579 = state_32523__$1;
(statearr_32532_32579[(2)] = inst_32519);

(statearr_32532_32579[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (21))){
var inst_32472 = (state_32523[(2)]);
var inst_32473 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32474 = figwheel.client.auto_jump_to_error.call(null,opts,inst_32473);
var state_32523__$1 = (function (){var statearr_32533 = state_32523;
(statearr_32533[(7)] = inst_32472);

return statearr_32533;
})();
var statearr_32534_32580 = state_32523__$1;
(statearr_32534_32580[(2)] = inst_32474);

(statearr_32534_32580[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (31))){
var inst_32502 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_32523__$1 = state_32523;
if(cljs.core.truth_(inst_32502)){
var statearr_32535_32581 = state_32523__$1;
(statearr_32535_32581[(1)] = (34));

} else {
var statearr_32536_32582 = state_32523__$1;
(statearr_32536_32582[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (32))){
var inst_32511 = (state_32523[(2)]);
var state_32523__$1 = state_32523;
var statearr_32537_32583 = state_32523__$1;
(statearr_32537_32583[(2)] = inst_32511);

(statearr_32537_32583[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (33))){
var inst_32498 = (state_32523[(2)]);
var inst_32499 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32500 = figwheel.client.auto_jump_to_error.call(null,opts,inst_32499);
var state_32523__$1 = (function (){var statearr_32538 = state_32523;
(statearr_32538[(8)] = inst_32498);

return statearr_32538;
})();
var statearr_32539_32584 = state_32523__$1;
(statearr_32539_32584[(2)] = inst_32500);

(statearr_32539_32584[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (13))){
var inst_32457 = figwheel.client.heads_up.clear.call(null);
var state_32523__$1 = state_32523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32523__$1,(16),inst_32457);
} else {
if((state_val_32524 === (22))){
var inst_32478 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32479 = figwheel.client.heads_up.append_warning_message.call(null,inst_32478);
var state_32523__$1 = state_32523;
var statearr_32540_32585 = state_32523__$1;
(statearr_32540_32585[(2)] = inst_32479);

(statearr_32540_32585[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (36))){
var inst_32509 = (state_32523[(2)]);
var state_32523__$1 = state_32523;
var statearr_32541_32586 = state_32523__$1;
(statearr_32541_32586[(2)] = inst_32509);

(statearr_32541_32586[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (29))){
var inst_32489 = (state_32523[(2)]);
var inst_32490 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32491 = figwheel.client.auto_jump_to_error.call(null,opts,inst_32490);
var state_32523__$1 = (function (){var statearr_32542 = state_32523;
(statearr_32542[(9)] = inst_32489);

return statearr_32542;
})();
var statearr_32543_32587 = state_32523__$1;
(statearr_32543_32587[(2)] = inst_32491);

(statearr_32543_32587[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (6))){
var inst_32438 = (state_32523[(10)]);
var state_32523__$1 = state_32523;
var statearr_32544_32588 = state_32523__$1;
(statearr_32544_32588[(2)] = inst_32438);

(statearr_32544_32588[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (28))){
var inst_32485 = (state_32523[(2)]);
var inst_32486 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32487 = figwheel.client.heads_up.display_warning.call(null,inst_32486);
var state_32523__$1 = (function (){var statearr_32545 = state_32523;
(statearr_32545[(11)] = inst_32485);

return statearr_32545;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32523__$1,(29),inst_32487);
} else {
if((state_val_32524 === (25))){
var inst_32483 = figwheel.client.heads_up.clear.call(null);
var state_32523__$1 = state_32523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32523__$1,(28),inst_32483);
} else {
if((state_val_32524 === (34))){
var inst_32504 = figwheel.client.heads_up.flash_loaded.call(null);
var state_32523__$1 = state_32523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32523__$1,(37),inst_32504);
} else {
if((state_val_32524 === (17))){
var inst_32463 = (state_32523[(2)]);
var inst_32464 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32465 = figwheel.client.auto_jump_to_error.call(null,opts,inst_32464);
var state_32523__$1 = (function (){var statearr_32546 = state_32523;
(statearr_32546[(12)] = inst_32463);

return statearr_32546;
})();
var statearr_32547_32589 = state_32523__$1;
(statearr_32547_32589[(2)] = inst_32465);

(statearr_32547_32589[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (3))){
var inst_32455 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_32523__$1 = state_32523;
if(cljs.core.truth_(inst_32455)){
var statearr_32548_32590 = state_32523__$1;
(statearr_32548_32590[(1)] = (13));

} else {
var statearr_32549_32591 = state_32523__$1;
(statearr_32549_32591[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (12))){
var inst_32451 = (state_32523[(2)]);
var state_32523__$1 = state_32523;
var statearr_32550_32592 = state_32523__$1;
(statearr_32550_32592[(2)] = inst_32451);

(statearr_32550_32592[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (2))){
var inst_32438 = (state_32523[(10)]);
var inst_32438__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_32523__$1 = (function (){var statearr_32551 = state_32523;
(statearr_32551[(10)] = inst_32438__$1);

return statearr_32551;
})();
if(cljs.core.truth_(inst_32438__$1)){
var statearr_32552_32593 = state_32523__$1;
(statearr_32552_32593[(1)] = (5));

} else {
var statearr_32553_32594 = state_32523__$1;
(statearr_32553_32594[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (23))){
var inst_32481 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_32523__$1 = state_32523;
if(cljs.core.truth_(inst_32481)){
var statearr_32554_32595 = state_32523__$1;
(statearr_32554_32595[(1)] = (25));

} else {
var statearr_32555_32596 = state_32523__$1;
(statearr_32555_32596[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (35))){
var state_32523__$1 = state_32523;
var statearr_32556_32597 = state_32523__$1;
(statearr_32556_32597[(2)] = null);

(statearr_32556_32597[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (19))){
var inst_32476 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_32523__$1 = state_32523;
if(cljs.core.truth_(inst_32476)){
var statearr_32557_32598 = state_32523__$1;
(statearr_32557_32598[(1)] = (22));

} else {
var statearr_32558_32599 = state_32523__$1;
(statearr_32558_32599[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (11))){
var inst_32447 = (state_32523[(2)]);
var state_32523__$1 = state_32523;
var statearr_32559_32600 = state_32523__$1;
(statearr_32559_32600[(2)] = inst_32447);

(statearr_32559_32600[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (9))){
var inst_32449 = figwheel.client.heads_up.clear.call(null);
var state_32523__$1 = state_32523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32523__$1,(12),inst_32449);
} else {
if((state_val_32524 === (5))){
var inst_32440 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_32523__$1 = state_32523;
var statearr_32560_32601 = state_32523__$1;
(statearr_32560_32601[(2)] = inst_32440);

(statearr_32560_32601[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (14))){
var inst_32467 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_32523__$1 = state_32523;
if(cljs.core.truth_(inst_32467)){
var statearr_32561_32602 = state_32523__$1;
(statearr_32561_32602[(1)] = (18));

} else {
var statearr_32562_32603 = state_32523__$1;
(statearr_32562_32603[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (26))){
var inst_32493 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_32523__$1 = state_32523;
if(cljs.core.truth_(inst_32493)){
var statearr_32563_32604 = state_32523__$1;
(statearr_32563_32604[(1)] = (30));

} else {
var statearr_32564_32605 = state_32523__$1;
(statearr_32564_32605[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (16))){
var inst_32459 = (state_32523[(2)]);
var inst_32460 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32461 = figwheel.client.heads_up.display_exception.call(null,inst_32460);
var state_32523__$1 = (function (){var statearr_32565 = state_32523;
(statearr_32565[(13)] = inst_32459);

return statearr_32565;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32523__$1,(17),inst_32461);
} else {
if((state_val_32524 === (30))){
var inst_32495 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32496 = figwheel.client.heads_up.display_warning.call(null,inst_32495);
var state_32523__$1 = state_32523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32523__$1,(33),inst_32496);
} else {
if((state_val_32524 === (10))){
var inst_32453 = (state_32523[(2)]);
var state_32523__$1 = state_32523;
var statearr_32566_32606 = state_32523__$1;
(statearr_32566_32606[(2)] = inst_32453);

(statearr_32566_32606[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (18))){
var inst_32469 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32470 = figwheel.client.heads_up.display_exception.call(null,inst_32469);
var state_32523__$1 = state_32523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32523__$1,(21),inst_32470);
} else {
if((state_val_32524 === (37))){
var inst_32506 = (state_32523[(2)]);
var state_32523__$1 = state_32523;
var statearr_32567_32607 = state_32523__$1;
(statearr_32567_32607[(2)] = inst_32506);

(statearr_32567_32607[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32524 === (8))){
var inst_32445 = figwheel.client.heads_up.flash_loaded.call(null);
var state_32523__$1 = state_32523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32523__$1,(11),inst_32445);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31003__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__30982__auto__,c__31003__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30983__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30983__auto____0 = (function (){
var statearr_32568 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32568[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30983__auto__);

(statearr_32568[(1)] = (1));

return statearr_32568;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30983__auto____1 = (function (state_32523){
while(true){
var ret_value__30984__auto__ = (function (){try{while(true){
var result__30985__auto__ = switch__30982__auto__.call(null,state_32523);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30985__auto__;
}
break;
}
}catch (e32569){if((e32569 instanceof Object)){
var ex__30986__auto__ = e32569;
var statearr_32570_32608 = state_32523;
(statearr_32570_32608[(5)] = ex__30986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32523);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32569;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32609 = state_32523;
state_32523 = G__32609;
continue;
} else {
return ret_value__30984__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30983__auto__ = function(state_32523){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30983__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30983__auto____1.call(this,state_32523);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30983__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30983__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30983__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30983__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30983__auto__;
})()
;})(switch__30982__auto__,c__31003__auto__,msg_hist,msg_names,msg))
})();
var state__31005__auto__ = (function (){var statearr_32571 = f__31004__auto__.call(null);
(statearr_32571[(6)] = c__31003__auto__);

return statearr_32571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31005__auto__);
});})(c__31003__auto__,msg_hist,msg_names,msg))
);

return c__31003__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__31003__auto___32638 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31003__auto___32638,ch){
return (function (){
var f__31004__auto__ = (function (){var switch__30982__auto__ = ((function (c__31003__auto___32638,ch){
return (function (state_32624){
var state_val_32625 = (state_32624[(1)]);
if((state_val_32625 === (1))){
var state_32624__$1 = state_32624;
var statearr_32626_32639 = state_32624__$1;
(statearr_32626_32639[(2)] = null);

(statearr_32626_32639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32625 === (2))){
var state_32624__$1 = state_32624;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32624__$1,(4),ch);
} else {
if((state_val_32625 === (3))){
var inst_32622 = (state_32624[(2)]);
var state_32624__$1 = state_32624;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32624__$1,inst_32622);
} else {
if((state_val_32625 === (4))){
var inst_32612 = (state_32624[(7)]);
var inst_32612__$1 = (state_32624[(2)]);
var state_32624__$1 = (function (){var statearr_32627 = state_32624;
(statearr_32627[(7)] = inst_32612__$1);

return statearr_32627;
})();
if(cljs.core.truth_(inst_32612__$1)){
var statearr_32628_32640 = state_32624__$1;
(statearr_32628_32640[(1)] = (5));

} else {
var statearr_32629_32641 = state_32624__$1;
(statearr_32629_32641[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32625 === (5))){
var inst_32612 = (state_32624[(7)]);
var inst_32614 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_32612);
var state_32624__$1 = state_32624;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32624__$1,(8),inst_32614);
} else {
if((state_val_32625 === (6))){
var state_32624__$1 = state_32624;
var statearr_32630_32642 = state_32624__$1;
(statearr_32630_32642[(2)] = null);

(statearr_32630_32642[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32625 === (7))){
var inst_32620 = (state_32624[(2)]);
var state_32624__$1 = state_32624;
var statearr_32631_32643 = state_32624__$1;
(statearr_32631_32643[(2)] = inst_32620);

(statearr_32631_32643[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32625 === (8))){
var inst_32616 = (state_32624[(2)]);
var state_32624__$1 = (function (){var statearr_32632 = state_32624;
(statearr_32632[(8)] = inst_32616);

return statearr_32632;
})();
var statearr_32633_32644 = state_32624__$1;
(statearr_32633_32644[(2)] = null);

(statearr_32633_32644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__31003__auto___32638,ch))
;
return ((function (switch__30982__auto__,c__31003__auto___32638,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__30983__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__30983__auto____0 = (function (){
var statearr_32634 = [null,null,null,null,null,null,null,null,null];
(statearr_32634[(0)] = figwheel$client$heads_up_plugin_$_state_machine__30983__auto__);

(statearr_32634[(1)] = (1));

return statearr_32634;
});
var figwheel$client$heads_up_plugin_$_state_machine__30983__auto____1 = (function (state_32624){
while(true){
var ret_value__30984__auto__ = (function (){try{while(true){
var result__30985__auto__ = switch__30982__auto__.call(null,state_32624);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30985__auto__;
}
break;
}
}catch (e32635){if((e32635 instanceof Object)){
var ex__30986__auto__ = e32635;
var statearr_32636_32645 = state_32624;
(statearr_32636_32645[(5)] = ex__30986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32624);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32635;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32646 = state_32624;
state_32624 = G__32646;
continue;
} else {
return ret_value__30984__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__30983__auto__ = function(state_32624){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__30983__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__30983__auto____1.call(this,state_32624);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__30983__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__30983__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__30983__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__30983__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__30983__auto__;
})()
;})(switch__30982__auto__,c__31003__auto___32638,ch))
})();
var state__31005__auto__ = (function (){var statearr_32637 = f__31004__auto__.call(null);
(statearr_32637[(6)] = c__31003__auto___32638);

return statearr_32637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31005__auto__);
});})(c__31003__auto___32638,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__31003__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31003__auto__){
return (function (){
var f__31004__auto__ = (function (){var switch__30982__auto__ = ((function (c__31003__auto__){
return (function (state_32652){
var state_val_32653 = (state_32652[(1)]);
if((state_val_32653 === (1))){
var inst_32647 = cljs.core.async.timeout.call(null,(3000));
var state_32652__$1 = state_32652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32652__$1,(2),inst_32647);
} else {
if((state_val_32653 === (2))){
var inst_32649 = (state_32652[(2)]);
var inst_32650 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_32652__$1 = (function (){var statearr_32654 = state_32652;
(statearr_32654[(7)] = inst_32649);

return statearr_32654;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32652__$1,inst_32650);
} else {
return null;
}
}
});})(c__31003__auto__))
;
return ((function (switch__30982__auto__,c__31003__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__30983__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__30983__auto____0 = (function (){
var statearr_32655 = [null,null,null,null,null,null,null,null];
(statearr_32655[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__30983__auto__);

(statearr_32655[(1)] = (1));

return statearr_32655;
});
var figwheel$client$enforce_project_plugin_$_state_machine__30983__auto____1 = (function (state_32652){
while(true){
var ret_value__30984__auto__ = (function (){try{while(true){
var result__30985__auto__ = switch__30982__auto__.call(null,state_32652);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30985__auto__;
}
break;
}
}catch (e32656){if((e32656 instanceof Object)){
var ex__30986__auto__ = e32656;
var statearr_32657_32659 = state_32652;
(statearr_32657_32659[(5)] = ex__30986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32652);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32656;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32660 = state_32652;
state_32652 = G__32660;
continue;
} else {
return ret_value__30984__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__30983__auto__ = function(state_32652){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__30983__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__30983__auto____1.call(this,state_32652);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__30983__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__30983__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__30983__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__30983__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__30983__auto__;
})()
;})(switch__30982__auto__,c__31003__auto__))
})();
var state__31005__auto__ = (function (){var statearr_32658 = f__31004__auto__.call(null);
(statearr_32658[(6)] = c__31003__auto__);

return statearr_32658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31005__auto__);
});})(c__31003__auto__))
);

return c__31003__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__4657__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__4657__auto__)){
var figwheel_version = temp__4657__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__31003__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31003__auto__,figwheel_version,temp__4657__auto__){
return (function (){
var f__31004__auto__ = (function (){var switch__30982__auto__ = ((function (c__31003__auto__,figwheel_version,temp__4657__auto__){
return (function (state_32667){
var state_val_32668 = (state_32667[(1)]);
if((state_val_32668 === (1))){
var inst_32661 = cljs.core.async.timeout.call(null,(2000));
var state_32667__$1 = state_32667;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32667__$1,(2),inst_32661);
} else {
if((state_val_32668 === (2))){
var inst_32663 = (state_32667[(2)]);
var inst_32664 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_32665 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_32664);
var state_32667__$1 = (function (){var statearr_32669 = state_32667;
(statearr_32669[(7)] = inst_32663);

return statearr_32669;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32667__$1,inst_32665);
} else {
return null;
}
}
});})(c__31003__auto__,figwheel_version,temp__4657__auto__))
;
return ((function (switch__30982__auto__,c__31003__auto__,figwheel_version,temp__4657__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30983__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30983__auto____0 = (function (){
var statearr_32670 = [null,null,null,null,null,null,null,null];
(statearr_32670[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30983__auto__);

(statearr_32670[(1)] = (1));

return statearr_32670;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30983__auto____1 = (function (state_32667){
while(true){
var ret_value__30984__auto__ = (function (){try{while(true){
var result__30985__auto__ = switch__30982__auto__.call(null,state_32667);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30985__auto__;
}
break;
}
}catch (e32671){if((e32671 instanceof Object)){
var ex__30986__auto__ = e32671;
var statearr_32672_32674 = state_32667;
(statearr_32672_32674[(5)] = ex__30986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32667);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32671;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32675 = state_32667;
state_32667 = G__32675;
continue;
} else {
return ret_value__30984__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30983__auto__ = function(state_32667){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30983__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30983__auto____1.call(this,state_32667);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30983__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30983__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30983__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30983__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30983__auto__;
})()
;})(switch__30982__auto__,c__31003__auto__,figwheel_version,temp__4657__auto__))
})();
var state__31005__auto__ = (function (){var statearr_32673 = f__31004__auto__.call(null);
(statearr_32673[(6)] = c__31003__auto__);

return statearr_32673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31005__auto__);
});})(c__31003__auto__,figwheel_version,temp__4657__auto__))
);

return c__31003__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__32676){
var map__32677 = p__32676;
var map__32677__$1 = ((((!((map__32677 == null)))?((((map__32677.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32677.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32677):map__32677);
var file = cljs.core.get.call(null,map__32677__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__32677__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__32677__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__32679 = "";
var G__32679__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32679),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__32679);
var G__32679__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32679__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__32679__$1);
if(cljs.core.truth_((function (){var and__28335__auto__ = line;
if(cljs.core.truth_(and__28335__auto__)){
return column;
} else {
return and__28335__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32679__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__32679__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__32680){
var map__32681 = p__32680;
var map__32681__$1 = ((((!((map__32681 == null)))?((((map__32681.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32681.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32681):map__32681);
var ed = map__32681__$1;
var formatted_exception = cljs.core.get.call(null,map__32681__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__32681__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__32681__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__32683_32687 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__32684_32688 = null;
var count__32685_32689 = (0);
var i__32686_32690 = (0);
while(true){
if((i__32686_32690 < count__32685_32689)){
var msg_32691 = cljs.core._nth.call(null,chunk__32684_32688,i__32686_32690);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_32691);

var G__32692 = seq__32683_32687;
var G__32693 = chunk__32684_32688;
var G__32694 = count__32685_32689;
var G__32695 = (i__32686_32690 + (1));
seq__32683_32687 = G__32692;
chunk__32684_32688 = G__32693;
count__32685_32689 = G__32694;
i__32686_32690 = G__32695;
continue;
} else {
var temp__4657__auto___32696 = cljs.core.seq.call(null,seq__32683_32687);
if(temp__4657__auto___32696){
var seq__32683_32697__$1 = temp__4657__auto___32696;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32683_32697__$1)){
var c__29186__auto___32698 = cljs.core.chunk_first.call(null,seq__32683_32697__$1);
var G__32699 = cljs.core.chunk_rest.call(null,seq__32683_32697__$1);
var G__32700 = c__29186__auto___32698;
var G__32701 = cljs.core.count.call(null,c__29186__auto___32698);
var G__32702 = (0);
seq__32683_32687 = G__32699;
chunk__32684_32688 = G__32700;
count__32685_32689 = G__32701;
i__32686_32690 = G__32702;
continue;
} else {
var msg_32703 = cljs.core.first.call(null,seq__32683_32697__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_32703);

var G__32704 = cljs.core.next.call(null,seq__32683_32697__$1);
var G__32705 = null;
var G__32706 = (0);
var G__32707 = (0);
seq__32683_32687 = G__32704;
chunk__32684_32688 = G__32705;
count__32685_32689 = G__32706;
i__32686_32690 = G__32707;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__32708){
var map__32709 = p__32708;
var map__32709__$1 = ((((!((map__32709 == null)))?((((map__32709.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32709.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32709):map__32709);
var w = map__32709__$1;
var message = cljs.core.get.call(null,map__32709__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/public/js/out/figwheel/client.cljs",33,1,363,363,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/public/js/out/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__28335__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__28335__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__28335__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__32711 = cljs.core.seq.call(null,plugins);
var chunk__32712 = null;
var count__32713 = (0);
var i__32714 = (0);
while(true){
if((i__32714 < count__32713)){
var vec__32715 = cljs.core._nth.call(null,chunk__32712,i__32714);
var k = cljs.core.nth.call(null,vec__32715,(0),null);
var plugin = cljs.core.nth.call(null,vec__32715,(1),null);
if(cljs.core.truth_(plugin)){
var pl_32721 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__32711,chunk__32712,count__32713,i__32714,pl_32721,vec__32715,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_32721.call(null,msg_hist);
});})(seq__32711,chunk__32712,count__32713,i__32714,pl_32721,vec__32715,k,plugin))
);
} else {
}

var G__32722 = seq__32711;
var G__32723 = chunk__32712;
var G__32724 = count__32713;
var G__32725 = (i__32714 + (1));
seq__32711 = G__32722;
chunk__32712 = G__32723;
count__32713 = G__32724;
i__32714 = G__32725;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__32711);
if(temp__4657__auto__){
var seq__32711__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32711__$1)){
var c__29186__auto__ = cljs.core.chunk_first.call(null,seq__32711__$1);
var G__32726 = cljs.core.chunk_rest.call(null,seq__32711__$1);
var G__32727 = c__29186__auto__;
var G__32728 = cljs.core.count.call(null,c__29186__auto__);
var G__32729 = (0);
seq__32711 = G__32726;
chunk__32712 = G__32727;
count__32713 = G__32728;
i__32714 = G__32729;
continue;
} else {
var vec__32718 = cljs.core.first.call(null,seq__32711__$1);
var k = cljs.core.nth.call(null,vec__32718,(0),null);
var plugin = cljs.core.nth.call(null,vec__32718,(1),null);
if(cljs.core.truth_(plugin)){
var pl_32730 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__32711,chunk__32712,count__32713,i__32714,pl_32730,vec__32718,k,plugin,seq__32711__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_32730.call(null,msg_hist);
});})(seq__32711,chunk__32712,count__32713,i__32714,pl_32730,vec__32718,k,plugin,seq__32711__$1,temp__4657__auto__))
);
} else {
}

var G__32731 = cljs.core.next.call(null,seq__32711__$1);
var G__32732 = null;
var G__32733 = (0);
var G__32734 = (0);
seq__32711 = G__32731;
chunk__32712 = G__32732;
count__32713 = G__32733;
i__32714 = G__32734;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__32736 = arguments.length;
switch (G__32736) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__32737_32742 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__32738_32743 = null;
var count__32739_32744 = (0);
var i__32740_32745 = (0);
while(true){
if((i__32740_32745 < count__32739_32744)){
var msg_32746 = cljs.core._nth.call(null,chunk__32738_32743,i__32740_32745);
figwheel.client.socket.handle_incoming_message.call(null,msg_32746);

var G__32747 = seq__32737_32742;
var G__32748 = chunk__32738_32743;
var G__32749 = count__32739_32744;
var G__32750 = (i__32740_32745 + (1));
seq__32737_32742 = G__32747;
chunk__32738_32743 = G__32748;
count__32739_32744 = G__32749;
i__32740_32745 = G__32750;
continue;
} else {
var temp__4657__auto___32751 = cljs.core.seq.call(null,seq__32737_32742);
if(temp__4657__auto___32751){
var seq__32737_32752__$1 = temp__4657__auto___32751;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32737_32752__$1)){
var c__29186__auto___32753 = cljs.core.chunk_first.call(null,seq__32737_32752__$1);
var G__32754 = cljs.core.chunk_rest.call(null,seq__32737_32752__$1);
var G__32755 = c__29186__auto___32753;
var G__32756 = cljs.core.count.call(null,c__29186__auto___32753);
var G__32757 = (0);
seq__32737_32742 = G__32754;
chunk__32738_32743 = G__32755;
count__32739_32744 = G__32756;
i__32740_32745 = G__32757;
continue;
} else {
var msg_32758 = cljs.core.first.call(null,seq__32737_32752__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_32758);

var G__32759 = cljs.core.next.call(null,seq__32737_32752__$1);
var G__32760 = null;
var G__32761 = (0);
var G__32762 = (0);
seq__32737_32742 = G__32759;
chunk__32738_32743 = G__32760;
count__32739_32744 = G__32761;
i__32740_32745 = G__32762;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__29523__auto__ = [];
var len__29516__auto___32767 = arguments.length;
var i__29517__auto___32768 = (0);
while(true){
if((i__29517__auto___32768 < len__29516__auto___32767)){
args__29523__auto__.push((arguments[i__29517__auto___32768]));

var G__32769 = (i__29517__auto___32768 + (1));
i__29517__auto___32768 = G__32769;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((0) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__29524__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__32764){
var map__32765 = p__32764;
var map__32765__$1 = ((((!((map__32765 == null)))?((((map__32765.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32765.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32765):map__32765);
var opts = map__32765__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq32763){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq32763));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e32770){if((e32770 instanceof Error)){
var e = e32770;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e32770;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__32771){
var map__32772 = p__32771;
var map__32772__$1 = ((((!((map__32772 == null)))?((((map__32772.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32772.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32772):map__32772);
var msg_name = cljs.core.get.call(null,map__32772__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1503709583235
