// Compiled by ClojureScript 1.9.908 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__28347__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__28347__auto__){
return or__28347__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__28347__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
var or__28347__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__28347__auto____$1)){
return or__28347__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__31082_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__31082_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__31083 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__31084 = null;
var count__31085 = (0);
var i__31086 = (0);
while(true){
if((i__31086 < count__31085)){
var n = cljs.core._nth.call(null,chunk__31084,i__31086);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__31087 = seq__31083;
var G__31088 = chunk__31084;
var G__31089 = count__31085;
var G__31090 = (i__31086 + (1));
seq__31083 = G__31087;
chunk__31084 = G__31088;
count__31085 = G__31089;
i__31086 = G__31090;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__31083);
if(temp__4657__auto__){
var seq__31083__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31083__$1)){
var c__29186__auto__ = cljs.core.chunk_first.call(null,seq__31083__$1);
var G__31091 = cljs.core.chunk_rest.call(null,seq__31083__$1);
var G__31092 = c__29186__auto__;
var G__31093 = cljs.core.count.call(null,c__29186__auto__);
var G__31094 = (0);
seq__31083 = G__31091;
chunk__31084 = G__31092;
count__31085 = G__31093;
i__31086 = G__31094;
continue;
} else {
var n = cljs.core.first.call(null,seq__31083__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__31095 = cljs.core.next.call(null,seq__31083__$1);
var G__31096 = null;
var G__31097 = (0);
var G__31098 = (0);
seq__31083 = G__31095;
chunk__31084 = G__31096;
count__31085 = G__31097;
i__31086 = G__31098;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__31108_31116 = cljs.core.seq.call(null,deps);
var chunk__31109_31117 = null;
var count__31110_31118 = (0);
var i__31111_31119 = (0);
while(true){
if((i__31111_31119 < count__31110_31118)){
var dep_31120 = cljs.core._nth.call(null,chunk__31109_31117,i__31111_31119);
topo_sort_helper_STAR_.call(null,dep_31120,(depth + (1)),state);

var G__31121 = seq__31108_31116;
var G__31122 = chunk__31109_31117;
var G__31123 = count__31110_31118;
var G__31124 = (i__31111_31119 + (1));
seq__31108_31116 = G__31121;
chunk__31109_31117 = G__31122;
count__31110_31118 = G__31123;
i__31111_31119 = G__31124;
continue;
} else {
var temp__4657__auto___31125 = cljs.core.seq.call(null,seq__31108_31116);
if(temp__4657__auto___31125){
var seq__31108_31126__$1 = temp__4657__auto___31125;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31108_31126__$1)){
var c__29186__auto___31127 = cljs.core.chunk_first.call(null,seq__31108_31126__$1);
var G__31128 = cljs.core.chunk_rest.call(null,seq__31108_31126__$1);
var G__31129 = c__29186__auto___31127;
var G__31130 = cljs.core.count.call(null,c__29186__auto___31127);
var G__31131 = (0);
seq__31108_31116 = G__31128;
chunk__31109_31117 = G__31129;
count__31110_31118 = G__31130;
i__31111_31119 = G__31131;
continue;
} else {
var dep_31132 = cljs.core.first.call(null,seq__31108_31126__$1);
topo_sort_helper_STAR_.call(null,dep_31132,(depth + (1)),state);

var G__31133 = cljs.core.next.call(null,seq__31108_31126__$1);
var G__31134 = null;
var G__31135 = (0);
var G__31136 = (0);
seq__31108_31116 = G__31133;
chunk__31109_31117 = G__31134;
count__31110_31118 = G__31135;
i__31111_31119 = G__31136;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__31112){
var vec__31113 = p__31112;
var seq__31114 = cljs.core.seq.call(null,vec__31113);
var first__31115 = cljs.core.first.call(null,seq__31114);
var seq__31114__$1 = cljs.core.next.call(null,seq__31114);
var x = first__31115;
var xs = seq__31114__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__31113,seq__31114,first__31115,seq__31114__$1,x,xs,get_deps__$1){
return (function (p1__31099_SHARP_){
return clojure.set.difference.call(null,p1__31099_SHARP_,x);
});})(vec__31113,seq__31114,first__31115,seq__31114__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__31137 = cljs.core.seq.call(null,provides);
var chunk__31138 = null;
var count__31139 = (0);
var i__31140 = (0);
while(true){
if((i__31140 < count__31139)){
var prov = cljs.core._nth.call(null,chunk__31138,i__31140);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__31141_31149 = cljs.core.seq.call(null,requires);
var chunk__31142_31150 = null;
var count__31143_31151 = (0);
var i__31144_31152 = (0);
while(true){
if((i__31144_31152 < count__31143_31151)){
var req_31153 = cljs.core._nth.call(null,chunk__31142_31150,i__31144_31152);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_31153,prov);

var G__31154 = seq__31141_31149;
var G__31155 = chunk__31142_31150;
var G__31156 = count__31143_31151;
var G__31157 = (i__31144_31152 + (1));
seq__31141_31149 = G__31154;
chunk__31142_31150 = G__31155;
count__31143_31151 = G__31156;
i__31144_31152 = G__31157;
continue;
} else {
var temp__4657__auto___31158 = cljs.core.seq.call(null,seq__31141_31149);
if(temp__4657__auto___31158){
var seq__31141_31159__$1 = temp__4657__auto___31158;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31141_31159__$1)){
var c__29186__auto___31160 = cljs.core.chunk_first.call(null,seq__31141_31159__$1);
var G__31161 = cljs.core.chunk_rest.call(null,seq__31141_31159__$1);
var G__31162 = c__29186__auto___31160;
var G__31163 = cljs.core.count.call(null,c__29186__auto___31160);
var G__31164 = (0);
seq__31141_31149 = G__31161;
chunk__31142_31150 = G__31162;
count__31143_31151 = G__31163;
i__31144_31152 = G__31164;
continue;
} else {
var req_31165 = cljs.core.first.call(null,seq__31141_31159__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_31165,prov);

var G__31166 = cljs.core.next.call(null,seq__31141_31159__$1);
var G__31167 = null;
var G__31168 = (0);
var G__31169 = (0);
seq__31141_31149 = G__31166;
chunk__31142_31150 = G__31167;
count__31143_31151 = G__31168;
i__31144_31152 = G__31169;
continue;
}
} else {
}
}
break;
}

var G__31170 = seq__31137;
var G__31171 = chunk__31138;
var G__31172 = count__31139;
var G__31173 = (i__31140 + (1));
seq__31137 = G__31170;
chunk__31138 = G__31171;
count__31139 = G__31172;
i__31140 = G__31173;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__31137);
if(temp__4657__auto__){
var seq__31137__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31137__$1)){
var c__29186__auto__ = cljs.core.chunk_first.call(null,seq__31137__$1);
var G__31174 = cljs.core.chunk_rest.call(null,seq__31137__$1);
var G__31175 = c__29186__auto__;
var G__31176 = cljs.core.count.call(null,c__29186__auto__);
var G__31177 = (0);
seq__31137 = G__31174;
chunk__31138 = G__31175;
count__31139 = G__31176;
i__31140 = G__31177;
continue;
} else {
var prov = cljs.core.first.call(null,seq__31137__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__31145_31178 = cljs.core.seq.call(null,requires);
var chunk__31146_31179 = null;
var count__31147_31180 = (0);
var i__31148_31181 = (0);
while(true){
if((i__31148_31181 < count__31147_31180)){
var req_31182 = cljs.core._nth.call(null,chunk__31146_31179,i__31148_31181);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_31182,prov);

var G__31183 = seq__31145_31178;
var G__31184 = chunk__31146_31179;
var G__31185 = count__31147_31180;
var G__31186 = (i__31148_31181 + (1));
seq__31145_31178 = G__31183;
chunk__31146_31179 = G__31184;
count__31147_31180 = G__31185;
i__31148_31181 = G__31186;
continue;
} else {
var temp__4657__auto___31187__$1 = cljs.core.seq.call(null,seq__31145_31178);
if(temp__4657__auto___31187__$1){
var seq__31145_31188__$1 = temp__4657__auto___31187__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31145_31188__$1)){
var c__29186__auto___31189 = cljs.core.chunk_first.call(null,seq__31145_31188__$1);
var G__31190 = cljs.core.chunk_rest.call(null,seq__31145_31188__$1);
var G__31191 = c__29186__auto___31189;
var G__31192 = cljs.core.count.call(null,c__29186__auto___31189);
var G__31193 = (0);
seq__31145_31178 = G__31190;
chunk__31146_31179 = G__31191;
count__31147_31180 = G__31192;
i__31148_31181 = G__31193;
continue;
} else {
var req_31194 = cljs.core.first.call(null,seq__31145_31188__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_31194,prov);

var G__31195 = cljs.core.next.call(null,seq__31145_31188__$1);
var G__31196 = null;
var G__31197 = (0);
var G__31198 = (0);
seq__31145_31178 = G__31195;
chunk__31146_31179 = G__31196;
count__31147_31180 = G__31197;
i__31148_31181 = G__31198;
continue;
}
} else {
}
}
break;
}

var G__31199 = cljs.core.next.call(null,seq__31137__$1);
var G__31200 = null;
var G__31201 = (0);
var G__31202 = (0);
seq__31137 = G__31199;
chunk__31138 = G__31200;
count__31139 = G__31201;
i__31140 = G__31202;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__31203_31207 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__31204_31208 = null;
var count__31205_31209 = (0);
var i__31206_31210 = (0);
while(true){
if((i__31206_31210 < count__31205_31209)){
var ns_31211 = cljs.core._nth.call(null,chunk__31204_31208,i__31206_31210);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_31211);

var G__31212 = seq__31203_31207;
var G__31213 = chunk__31204_31208;
var G__31214 = count__31205_31209;
var G__31215 = (i__31206_31210 + (1));
seq__31203_31207 = G__31212;
chunk__31204_31208 = G__31213;
count__31205_31209 = G__31214;
i__31206_31210 = G__31215;
continue;
} else {
var temp__4657__auto___31216 = cljs.core.seq.call(null,seq__31203_31207);
if(temp__4657__auto___31216){
var seq__31203_31217__$1 = temp__4657__auto___31216;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31203_31217__$1)){
var c__29186__auto___31218 = cljs.core.chunk_first.call(null,seq__31203_31217__$1);
var G__31219 = cljs.core.chunk_rest.call(null,seq__31203_31217__$1);
var G__31220 = c__29186__auto___31218;
var G__31221 = cljs.core.count.call(null,c__29186__auto___31218);
var G__31222 = (0);
seq__31203_31207 = G__31219;
chunk__31204_31208 = G__31220;
count__31205_31209 = G__31221;
i__31206_31210 = G__31222;
continue;
} else {
var ns_31223 = cljs.core.first.call(null,seq__31203_31217__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_31223);

var G__31224 = cljs.core.next.call(null,seq__31203_31217__$1);
var G__31225 = null;
var G__31226 = (0);
var G__31227 = (0);
seq__31203_31207 = G__31224;
chunk__31204_31208 = G__31225;
count__31205_31209 = G__31226;
i__31206_31210 = G__31227;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__28347__auto__ = goog.require__;
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__31228__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__31228 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__31229__i = 0, G__31229__a = new Array(arguments.length -  0);
while (G__31229__i < G__31229__a.length) {G__31229__a[G__31229__i] = arguments[G__31229__i + 0]; ++G__31229__i;}
  args = new cljs.core.IndexedSeq(G__31229__a,0,null);
} 
return G__31228__delegate.call(this,args);};
G__31228.cljs$lang$maxFixedArity = 0;
G__31228.cljs$lang$applyTo = (function (arglist__31230){
var args = cljs.core.seq(arglist__31230);
return G__31228__delegate(args);
});
G__31228.cljs$core$IFn$_invoke$arity$variadic = G__31228__delegate;
return G__31228;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = ((typeof goog.net.jsloader.safeLoad !== 'undefined')?(function (p1__31231_SHARP_,p2__31232_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31231_SHARP_)].join('')),p2__31232_SHARP_);
}):((typeof goog.net.jsloader.load !== 'undefined')?(function (p1__31233_SHARP_,p2__31234_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31233_SHARP_)].join(''),p2__31234_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__31235 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__31235.addCallback(((function (G__31235){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__31235))
);

G__31235.addErrback(((function (G__31235){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__31235))
);

return G__31235;
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__31236 = cljs.core._EQ_;
var expr__31237 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__31236.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__31237))){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern,pred__31236,expr__31237){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern,pred__31236,expr__31237))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path,pred__31236,expr__31237){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e31239){if((e31239 instanceof Error)){
var e = e31239;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e31239;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path,pred__31236,expr__31237))
} else {
if(cljs.core.truth_(pred__31236.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__31237))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__31236.call(null,new cljs.core.Keyword(null,"react-native","react-native",-1543085138),expr__31237))){
return figwheel.client.file_reloading.reload_file_in_html_env;
} else {
if(cljs.core.truth_(pred__31236.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__31237))){
return ((function (pred__31236,expr__31237){
return (function (request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e31240){if((e31240 instanceof Error)){
var e = e31240;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e31240;

}
}})());
});
;})(pred__31236,expr__31237))
} else {
return ((function (pred__31236,expr__31237){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__31236,expr__31237))
}
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__31241,callback){
var map__31242 = p__31241;
var map__31242__$1 = ((((!((map__31242 == null)))?((((map__31242.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31242.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31242):map__31242);
var file_msg = map__31242__$1;
var request_url = cljs.core.get.call(null,map__31242__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__31242,map__31242__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__31242,map__31242__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__31003__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31003__auto__){
return (function (){
var f__31004__auto__ = (function (){var switch__30982__auto__ = ((function (c__31003__auto__){
return (function (state_31266){
var state_val_31267 = (state_31266[(1)]);
if((state_val_31267 === (7))){
var inst_31262 = (state_31266[(2)]);
var state_31266__$1 = state_31266;
var statearr_31268_31285 = state_31266__$1;
(statearr_31268_31285[(2)] = inst_31262);

(statearr_31268_31285[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31267 === (1))){
var state_31266__$1 = state_31266;
var statearr_31269_31286 = state_31266__$1;
(statearr_31269_31286[(2)] = null);

(statearr_31269_31286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31267 === (4))){
var inst_31246 = (state_31266[(7)]);
var inst_31246__$1 = (state_31266[(2)]);
var state_31266__$1 = (function (){var statearr_31270 = state_31266;
(statearr_31270[(7)] = inst_31246__$1);

return statearr_31270;
})();
if(cljs.core.truth_(inst_31246__$1)){
var statearr_31271_31287 = state_31266__$1;
(statearr_31271_31287[(1)] = (5));

} else {
var statearr_31272_31288 = state_31266__$1;
(statearr_31272_31288[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31267 === (6))){
var state_31266__$1 = state_31266;
var statearr_31273_31289 = state_31266__$1;
(statearr_31273_31289[(2)] = null);

(statearr_31273_31289[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31267 === (3))){
var inst_31264 = (state_31266[(2)]);
var state_31266__$1 = state_31266;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31266__$1,inst_31264);
} else {
if((state_val_31267 === (2))){
var state_31266__$1 = state_31266;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31266__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_31267 === (11))){
var inst_31258 = (state_31266[(2)]);
var state_31266__$1 = (function (){var statearr_31274 = state_31266;
(statearr_31274[(8)] = inst_31258);

return statearr_31274;
})();
var statearr_31275_31290 = state_31266__$1;
(statearr_31275_31290[(2)] = null);

(statearr_31275_31290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31267 === (9))){
var inst_31252 = (state_31266[(9)]);
var inst_31250 = (state_31266[(10)]);
var inst_31254 = inst_31252.call(null,inst_31250);
var state_31266__$1 = state_31266;
var statearr_31276_31291 = state_31266__$1;
(statearr_31276_31291[(2)] = inst_31254);

(statearr_31276_31291[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31267 === (5))){
var inst_31246 = (state_31266[(7)]);
var inst_31248 = figwheel.client.file_reloading.blocking_load.call(null,inst_31246);
var state_31266__$1 = state_31266;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31266__$1,(8),inst_31248);
} else {
if((state_val_31267 === (10))){
var inst_31250 = (state_31266[(10)]);
var inst_31256 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_31250);
var state_31266__$1 = state_31266;
var statearr_31277_31292 = state_31266__$1;
(statearr_31277_31292[(2)] = inst_31256);

(statearr_31277_31292[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31267 === (8))){
var inst_31246 = (state_31266[(7)]);
var inst_31252 = (state_31266[(9)]);
var inst_31250 = (state_31266[(2)]);
var inst_31251 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_31252__$1 = cljs.core.get.call(null,inst_31251,inst_31246);
var state_31266__$1 = (function (){var statearr_31278 = state_31266;
(statearr_31278[(9)] = inst_31252__$1);

(statearr_31278[(10)] = inst_31250);

return statearr_31278;
})();
if(cljs.core.truth_(inst_31252__$1)){
var statearr_31279_31293 = state_31266__$1;
(statearr_31279_31293[(1)] = (9));

} else {
var statearr_31280_31294 = state_31266__$1;
(statearr_31280_31294[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31003__auto__))
;
return ((function (switch__30982__auto__,c__31003__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__30983__auto__ = null;
var figwheel$client$file_reloading$state_machine__30983__auto____0 = (function (){
var statearr_31281 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31281[(0)] = figwheel$client$file_reloading$state_machine__30983__auto__);

(statearr_31281[(1)] = (1));

return statearr_31281;
});
var figwheel$client$file_reloading$state_machine__30983__auto____1 = (function (state_31266){
while(true){
var ret_value__30984__auto__ = (function (){try{while(true){
var result__30985__auto__ = switch__30982__auto__.call(null,state_31266);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30985__auto__;
}
break;
}
}catch (e31282){if((e31282 instanceof Object)){
var ex__30986__auto__ = e31282;
var statearr_31283_31295 = state_31266;
(statearr_31283_31295[(5)] = ex__30986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31266);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31282;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31296 = state_31266;
state_31266 = G__31296;
continue;
} else {
return ret_value__30984__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__30983__auto__ = function(state_31266){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__30983__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__30983__auto____1.call(this,state_31266);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__30983__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__30983__auto____0;
figwheel$client$file_reloading$state_machine__30983__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__30983__auto____1;
return figwheel$client$file_reloading$state_machine__30983__auto__;
})()
;})(switch__30982__auto__,c__31003__auto__))
})();
var state__31005__auto__ = (function (){var statearr_31284 = f__31004__auto__.call(null);
(statearr_31284[(6)] = c__31003__auto__);

return statearr_31284;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31005__auto__);
});})(c__31003__auto__))
);

return c__31003__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__31297,callback){
var map__31298 = p__31297;
var map__31298__$1 = ((((!((map__31298 == null)))?((((map__31298.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31298.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31298):map__31298);
var file_msg = map__31298__$1;
var namespace = cljs.core.get.call(null,map__31298__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__31298,map__31298__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__31298,map__31298__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__31300){
var map__31301 = p__31300;
var map__31301__$1 = ((((!((map__31301 == null)))?((((map__31301.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31301.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31301):map__31301);
var file_msg = map__31301__$1;
var namespace = cljs.core.get.call(null,map__31301__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__31303){
var map__31304 = p__31303;
var map__31304__$1 = ((((!((map__31304 == null)))?((((map__31304.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31304.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31304):map__31304);
var file_msg = map__31304__$1;
var namespace = cljs.core.get.call(null,map__31304__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__28335__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__28335__auto__){
var or__28347__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
var or__28347__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__28347__auto____$1)){
return or__28347__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__28335__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__31306,callback){
var map__31307 = p__31306;
var map__31307__$1 = ((((!((map__31307 == null)))?((((map__31307.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31307.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31307):map__31307);
var file_msg = map__31307__$1;
var request_url = cljs.core.get.call(null,map__31307__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__31307__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__31003__auto___31357 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31003__auto___31357,out){
return (function (){
var f__31004__auto__ = (function (){var switch__30982__auto__ = ((function (c__31003__auto___31357,out){
return (function (state_31342){
var state_val_31343 = (state_31342[(1)]);
if((state_val_31343 === (1))){
var inst_31316 = cljs.core.seq.call(null,files);
var inst_31317 = cljs.core.first.call(null,inst_31316);
var inst_31318 = cljs.core.next.call(null,inst_31316);
var inst_31319 = files;
var state_31342__$1 = (function (){var statearr_31344 = state_31342;
(statearr_31344[(7)] = inst_31318);

(statearr_31344[(8)] = inst_31319);

(statearr_31344[(9)] = inst_31317);

return statearr_31344;
})();
var statearr_31345_31358 = state_31342__$1;
(statearr_31345_31358[(2)] = null);

(statearr_31345_31358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31343 === (2))){
var inst_31319 = (state_31342[(8)]);
var inst_31325 = (state_31342[(10)]);
var inst_31324 = cljs.core.seq.call(null,inst_31319);
var inst_31325__$1 = cljs.core.first.call(null,inst_31324);
var inst_31326 = cljs.core.next.call(null,inst_31324);
var inst_31327 = (inst_31325__$1 == null);
var inst_31328 = cljs.core.not.call(null,inst_31327);
var state_31342__$1 = (function (){var statearr_31346 = state_31342;
(statearr_31346[(11)] = inst_31326);

(statearr_31346[(10)] = inst_31325__$1);

return statearr_31346;
})();
if(inst_31328){
var statearr_31347_31359 = state_31342__$1;
(statearr_31347_31359[(1)] = (4));

} else {
var statearr_31348_31360 = state_31342__$1;
(statearr_31348_31360[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31343 === (3))){
var inst_31340 = (state_31342[(2)]);
var state_31342__$1 = state_31342;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31342__$1,inst_31340);
} else {
if((state_val_31343 === (4))){
var inst_31325 = (state_31342[(10)]);
var inst_31330 = figwheel.client.file_reloading.reload_js_file.call(null,inst_31325);
var state_31342__$1 = state_31342;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31342__$1,(7),inst_31330);
} else {
if((state_val_31343 === (5))){
var inst_31336 = cljs.core.async.close_BANG_.call(null,out);
var state_31342__$1 = state_31342;
var statearr_31349_31361 = state_31342__$1;
(statearr_31349_31361[(2)] = inst_31336);

(statearr_31349_31361[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31343 === (6))){
var inst_31338 = (state_31342[(2)]);
var state_31342__$1 = state_31342;
var statearr_31350_31362 = state_31342__$1;
(statearr_31350_31362[(2)] = inst_31338);

(statearr_31350_31362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31343 === (7))){
var inst_31326 = (state_31342[(11)]);
var inst_31332 = (state_31342[(2)]);
var inst_31333 = cljs.core.async.put_BANG_.call(null,out,inst_31332);
var inst_31319 = inst_31326;
var state_31342__$1 = (function (){var statearr_31351 = state_31342;
(statearr_31351[(8)] = inst_31319);

(statearr_31351[(12)] = inst_31333);

return statearr_31351;
})();
var statearr_31352_31363 = state_31342__$1;
(statearr_31352_31363[(2)] = null);

(statearr_31352_31363[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__31003__auto___31357,out))
;
return ((function (switch__30982__auto__,c__31003__auto___31357,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30983__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30983__auto____0 = (function (){
var statearr_31353 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31353[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30983__auto__);

(statearr_31353[(1)] = (1));

return statearr_31353;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__30983__auto____1 = (function (state_31342){
while(true){
var ret_value__30984__auto__ = (function (){try{while(true){
var result__30985__auto__ = switch__30982__auto__.call(null,state_31342);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30985__auto__;
}
break;
}
}catch (e31354){if((e31354 instanceof Object)){
var ex__30986__auto__ = e31354;
var statearr_31355_31364 = state_31342;
(statearr_31355_31364[(5)] = ex__30986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31342);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31354;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31365 = state_31342;
state_31342 = G__31365;
continue;
} else {
return ret_value__30984__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30983__auto__ = function(state_31342){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30983__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30983__auto____1.call(this,state_31342);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30983__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30983__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__30983__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__30983__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__30983__auto__;
})()
;})(switch__30982__auto__,c__31003__auto___31357,out))
})();
var state__31005__auto__ = (function (){var statearr_31356 = f__31004__auto__.call(null);
(statearr_31356[(6)] = c__31003__auto___31357);

return statearr_31356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31005__auto__);
});})(c__31003__auto___31357,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__31366,opts){
var map__31367 = p__31366;
var map__31367__$1 = ((((!((map__31367 == null)))?((((map__31367.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31367.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31367):map__31367);
var eval_body = cljs.core.get.call(null,map__31367__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__31367__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__28335__auto__ = eval_body;
if(cljs.core.truth_(and__28335__auto__)){
return typeof eval_body === 'string';
} else {
return and__28335__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e31369){var e = e31369;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__31370_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__31370_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__31371){
var vec__31372 = p__31371;
var k = cljs.core.nth.call(null,vec__31372,(0),null);
var v = cljs.core.nth.call(null,vec__31372,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__31375){
var vec__31376 = p__31375;
var k = cljs.core.nth.call(null,vec__31376,(0),null);
var v = cljs.core.nth.call(null,vec__31376,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__31382,p__31383){
var map__31384 = p__31382;
var map__31384__$1 = ((((!((map__31384 == null)))?((((map__31384.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31384.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31384):map__31384);
var opts = map__31384__$1;
var before_jsload = cljs.core.get.call(null,map__31384__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__31384__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__31384__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__31385 = p__31383;
var map__31385__$1 = ((((!((map__31385 == null)))?((((map__31385.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31385.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31385):map__31385);
var msg = map__31385__$1;
var files = cljs.core.get.call(null,map__31385__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__31385__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__31385__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__31003__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__31004__auto__ = (function (){var switch__30982__auto__ = ((function (c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_31539){
var state_val_31540 = (state_31539[(1)]);
if((state_val_31540 === (7))){
var inst_31399 = (state_31539[(7)]);
var inst_31402 = (state_31539[(8)]);
var inst_31400 = (state_31539[(9)]);
var inst_31401 = (state_31539[(10)]);
var inst_31407 = cljs.core._nth.call(null,inst_31400,inst_31402);
var inst_31408 = figwheel.client.file_reloading.eval_body.call(null,inst_31407,opts);
var inst_31409 = (inst_31402 + (1));
var tmp31541 = inst_31399;
var tmp31542 = inst_31400;
var tmp31543 = inst_31401;
var inst_31399__$1 = tmp31541;
var inst_31400__$1 = tmp31542;
var inst_31401__$1 = tmp31543;
var inst_31402__$1 = inst_31409;
var state_31539__$1 = (function (){var statearr_31544 = state_31539;
(statearr_31544[(7)] = inst_31399__$1);

(statearr_31544[(11)] = inst_31408);

(statearr_31544[(8)] = inst_31402__$1);

(statearr_31544[(9)] = inst_31400__$1);

(statearr_31544[(10)] = inst_31401__$1);

return statearr_31544;
})();
var statearr_31545_31628 = state_31539__$1;
(statearr_31545_31628[(2)] = null);

(statearr_31545_31628[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (20))){
var inst_31442 = (state_31539[(12)]);
var inst_31450 = figwheel.client.file_reloading.sort_files.call(null,inst_31442);
var state_31539__$1 = state_31539;
var statearr_31546_31629 = state_31539__$1;
(statearr_31546_31629[(2)] = inst_31450);

(statearr_31546_31629[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (27))){
var state_31539__$1 = state_31539;
var statearr_31547_31630 = state_31539__$1;
(statearr_31547_31630[(2)] = null);

(statearr_31547_31630[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (1))){
var inst_31391 = (state_31539[(13)]);
var inst_31388 = before_jsload.call(null,files);
var inst_31389 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_31390 = (function (){return ((function (inst_31391,inst_31388,inst_31389,state_val_31540,c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__31379_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__31379_SHARP_);
});
;})(inst_31391,inst_31388,inst_31389,state_val_31540,c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31391__$1 = cljs.core.filter.call(null,inst_31390,files);
var inst_31392 = cljs.core.not_empty.call(null,inst_31391__$1);
var state_31539__$1 = (function (){var statearr_31548 = state_31539;
(statearr_31548[(13)] = inst_31391__$1);

(statearr_31548[(14)] = inst_31388);

(statearr_31548[(15)] = inst_31389);

return statearr_31548;
})();
if(cljs.core.truth_(inst_31392)){
var statearr_31549_31631 = state_31539__$1;
(statearr_31549_31631[(1)] = (2));

} else {
var statearr_31550_31632 = state_31539__$1;
(statearr_31550_31632[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (24))){
var state_31539__$1 = state_31539;
var statearr_31551_31633 = state_31539__$1;
(statearr_31551_31633[(2)] = null);

(statearr_31551_31633[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (39))){
var inst_31492 = (state_31539[(16)]);
var state_31539__$1 = state_31539;
var statearr_31552_31634 = state_31539__$1;
(statearr_31552_31634[(2)] = inst_31492);

(statearr_31552_31634[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (46))){
var inst_31534 = (state_31539[(2)]);
var state_31539__$1 = state_31539;
var statearr_31553_31635 = state_31539__$1;
(statearr_31553_31635[(2)] = inst_31534);

(statearr_31553_31635[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (4))){
var inst_31436 = (state_31539[(2)]);
var inst_31437 = cljs.core.List.EMPTY;
var inst_31438 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_31437);
var inst_31439 = (function (){return ((function (inst_31436,inst_31437,inst_31438,state_val_31540,c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__31380_SHARP_){
var and__28335__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__31380_SHARP_);
if(cljs.core.truth_(and__28335__auto__)){
return (cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__31380_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__31380_SHARP_)));
} else {
return and__28335__auto__;
}
});
;})(inst_31436,inst_31437,inst_31438,state_val_31540,c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31440 = cljs.core.filter.call(null,inst_31439,files);
var inst_31441 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_31442 = cljs.core.concat.call(null,inst_31440,inst_31441);
var state_31539__$1 = (function (){var statearr_31554 = state_31539;
(statearr_31554[(12)] = inst_31442);

(statearr_31554[(17)] = inst_31438);

(statearr_31554[(18)] = inst_31436);

return statearr_31554;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_31555_31636 = state_31539__$1;
(statearr_31555_31636[(1)] = (16));

} else {
var statearr_31556_31637 = state_31539__$1;
(statearr_31556_31637[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (15))){
var inst_31426 = (state_31539[(2)]);
var state_31539__$1 = state_31539;
var statearr_31557_31638 = state_31539__$1;
(statearr_31557_31638[(2)] = inst_31426);

(statearr_31557_31638[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (21))){
var inst_31452 = (state_31539[(19)]);
var inst_31452__$1 = (state_31539[(2)]);
var inst_31453 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_31452__$1);
var state_31539__$1 = (function (){var statearr_31558 = state_31539;
(statearr_31558[(19)] = inst_31452__$1);

return statearr_31558;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31539__$1,(22),inst_31453);
} else {
if((state_val_31540 === (31))){
var inst_31537 = (state_31539[(2)]);
var state_31539__$1 = state_31539;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31539__$1,inst_31537);
} else {
if((state_val_31540 === (32))){
var inst_31492 = (state_31539[(16)]);
var inst_31497 = inst_31492.cljs$lang$protocol_mask$partition0$;
var inst_31498 = (inst_31497 & (64));
var inst_31499 = inst_31492.cljs$core$ISeq$;
var inst_31500 = (cljs.core.PROTOCOL_SENTINEL === inst_31499);
var inst_31501 = (inst_31498) || (inst_31500);
var state_31539__$1 = state_31539;
if(cljs.core.truth_(inst_31501)){
var statearr_31559_31639 = state_31539__$1;
(statearr_31559_31639[(1)] = (35));

} else {
var statearr_31560_31640 = state_31539__$1;
(statearr_31560_31640[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (40))){
var inst_31514 = (state_31539[(20)]);
var inst_31513 = (state_31539[(2)]);
var inst_31514__$1 = cljs.core.get.call(null,inst_31513,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_31515 = cljs.core.get.call(null,inst_31513,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_31516 = cljs.core.not_empty.call(null,inst_31514__$1);
var state_31539__$1 = (function (){var statearr_31561 = state_31539;
(statearr_31561[(21)] = inst_31515);

(statearr_31561[(20)] = inst_31514__$1);

return statearr_31561;
})();
if(cljs.core.truth_(inst_31516)){
var statearr_31562_31641 = state_31539__$1;
(statearr_31562_31641[(1)] = (41));

} else {
var statearr_31563_31642 = state_31539__$1;
(statearr_31563_31642[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (33))){
var state_31539__$1 = state_31539;
var statearr_31564_31643 = state_31539__$1;
(statearr_31564_31643[(2)] = false);

(statearr_31564_31643[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (13))){
var inst_31412 = (state_31539[(22)]);
var inst_31416 = cljs.core.chunk_first.call(null,inst_31412);
var inst_31417 = cljs.core.chunk_rest.call(null,inst_31412);
var inst_31418 = cljs.core.count.call(null,inst_31416);
var inst_31399 = inst_31417;
var inst_31400 = inst_31416;
var inst_31401 = inst_31418;
var inst_31402 = (0);
var state_31539__$1 = (function (){var statearr_31565 = state_31539;
(statearr_31565[(7)] = inst_31399);

(statearr_31565[(8)] = inst_31402);

(statearr_31565[(9)] = inst_31400);

(statearr_31565[(10)] = inst_31401);

return statearr_31565;
})();
var statearr_31566_31644 = state_31539__$1;
(statearr_31566_31644[(2)] = null);

(statearr_31566_31644[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (22))){
var inst_31456 = (state_31539[(23)]);
var inst_31460 = (state_31539[(24)]);
var inst_31455 = (state_31539[(25)]);
var inst_31452 = (state_31539[(19)]);
var inst_31455__$1 = (state_31539[(2)]);
var inst_31456__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_31455__$1);
var inst_31457 = (function (){var all_files = inst_31452;
var res_SINGLEQUOTE_ = inst_31455__$1;
var res = inst_31456__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_31456,inst_31460,inst_31455,inst_31452,inst_31455__$1,inst_31456__$1,state_val_31540,c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__31381_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__31381_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_31456,inst_31460,inst_31455,inst_31452,inst_31455__$1,inst_31456__$1,state_val_31540,c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31458 = cljs.core.filter.call(null,inst_31457,inst_31455__$1);
var inst_31459 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_31460__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_31459);
var inst_31461 = cljs.core.not_empty.call(null,inst_31460__$1);
var state_31539__$1 = (function (){var statearr_31567 = state_31539;
(statearr_31567[(23)] = inst_31456__$1);

(statearr_31567[(26)] = inst_31458);

(statearr_31567[(24)] = inst_31460__$1);

(statearr_31567[(25)] = inst_31455__$1);

return statearr_31567;
})();
if(cljs.core.truth_(inst_31461)){
var statearr_31568_31645 = state_31539__$1;
(statearr_31568_31645[(1)] = (23));

} else {
var statearr_31569_31646 = state_31539__$1;
(statearr_31569_31646[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (36))){
var state_31539__$1 = state_31539;
var statearr_31570_31647 = state_31539__$1;
(statearr_31570_31647[(2)] = false);

(statearr_31570_31647[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (41))){
var inst_31514 = (state_31539[(20)]);
var inst_31518 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_31519 = cljs.core.map.call(null,inst_31518,inst_31514);
var inst_31520 = cljs.core.pr_str.call(null,inst_31519);
var inst_31521 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31520)].join('');
var inst_31522 = figwheel.client.utils.log.call(null,inst_31521);
var state_31539__$1 = state_31539;
var statearr_31571_31648 = state_31539__$1;
(statearr_31571_31648[(2)] = inst_31522);

(statearr_31571_31648[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (43))){
var inst_31515 = (state_31539[(21)]);
var inst_31525 = (state_31539[(2)]);
var inst_31526 = cljs.core.not_empty.call(null,inst_31515);
var state_31539__$1 = (function (){var statearr_31572 = state_31539;
(statearr_31572[(27)] = inst_31525);

return statearr_31572;
})();
if(cljs.core.truth_(inst_31526)){
var statearr_31573_31649 = state_31539__$1;
(statearr_31573_31649[(1)] = (44));

} else {
var statearr_31574_31650 = state_31539__$1;
(statearr_31574_31650[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (29))){
var inst_31456 = (state_31539[(23)]);
var inst_31458 = (state_31539[(26)]);
var inst_31492 = (state_31539[(16)]);
var inst_31460 = (state_31539[(24)]);
var inst_31455 = (state_31539[(25)]);
var inst_31452 = (state_31539[(19)]);
var inst_31488 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_31491 = (function (){var all_files = inst_31452;
var res_SINGLEQUOTE_ = inst_31455;
var res = inst_31456;
var files_not_loaded = inst_31458;
var dependencies_that_loaded = inst_31460;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31456,inst_31458,inst_31492,inst_31460,inst_31455,inst_31452,inst_31488,state_val_31540,c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__31490){
var map__31575 = p__31490;
var map__31575__$1 = ((((!((map__31575 == null)))?((((map__31575.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31575.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31575):map__31575);
var namespace = cljs.core.get.call(null,map__31575__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31456,inst_31458,inst_31492,inst_31460,inst_31455,inst_31452,inst_31488,state_val_31540,c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31492__$1 = cljs.core.group_by.call(null,inst_31491,inst_31458);
var inst_31494 = (inst_31492__$1 == null);
var inst_31495 = cljs.core.not.call(null,inst_31494);
var state_31539__$1 = (function (){var statearr_31577 = state_31539;
(statearr_31577[(16)] = inst_31492__$1);

(statearr_31577[(28)] = inst_31488);

return statearr_31577;
})();
if(inst_31495){
var statearr_31578_31651 = state_31539__$1;
(statearr_31578_31651[(1)] = (32));

} else {
var statearr_31579_31652 = state_31539__$1;
(statearr_31579_31652[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (44))){
var inst_31515 = (state_31539[(21)]);
var inst_31528 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_31515);
var inst_31529 = cljs.core.pr_str.call(null,inst_31528);
var inst_31530 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31529)].join('');
var inst_31531 = figwheel.client.utils.log.call(null,inst_31530);
var state_31539__$1 = state_31539;
var statearr_31580_31653 = state_31539__$1;
(statearr_31580_31653[(2)] = inst_31531);

(statearr_31580_31653[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (6))){
var inst_31433 = (state_31539[(2)]);
var state_31539__$1 = state_31539;
var statearr_31581_31654 = state_31539__$1;
(statearr_31581_31654[(2)] = inst_31433);

(statearr_31581_31654[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (28))){
var inst_31458 = (state_31539[(26)]);
var inst_31485 = (state_31539[(2)]);
var inst_31486 = cljs.core.not_empty.call(null,inst_31458);
var state_31539__$1 = (function (){var statearr_31582 = state_31539;
(statearr_31582[(29)] = inst_31485);

return statearr_31582;
})();
if(cljs.core.truth_(inst_31486)){
var statearr_31583_31655 = state_31539__$1;
(statearr_31583_31655[(1)] = (29));

} else {
var statearr_31584_31656 = state_31539__$1;
(statearr_31584_31656[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (25))){
var inst_31456 = (state_31539[(23)]);
var inst_31472 = (state_31539[(2)]);
var inst_31473 = cljs.core.not_empty.call(null,inst_31456);
var state_31539__$1 = (function (){var statearr_31585 = state_31539;
(statearr_31585[(30)] = inst_31472);

return statearr_31585;
})();
if(cljs.core.truth_(inst_31473)){
var statearr_31586_31657 = state_31539__$1;
(statearr_31586_31657[(1)] = (26));

} else {
var statearr_31587_31658 = state_31539__$1;
(statearr_31587_31658[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (34))){
var inst_31508 = (state_31539[(2)]);
var state_31539__$1 = state_31539;
if(cljs.core.truth_(inst_31508)){
var statearr_31588_31659 = state_31539__$1;
(statearr_31588_31659[(1)] = (38));

} else {
var statearr_31589_31660 = state_31539__$1;
(statearr_31589_31660[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (17))){
var state_31539__$1 = state_31539;
var statearr_31590_31661 = state_31539__$1;
(statearr_31590_31661[(2)] = recompile_dependents);

(statearr_31590_31661[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (3))){
var state_31539__$1 = state_31539;
var statearr_31591_31662 = state_31539__$1;
(statearr_31591_31662[(2)] = null);

(statearr_31591_31662[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (12))){
var inst_31429 = (state_31539[(2)]);
var state_31539__$1 = state_31539;
var statearr_31592_31663 = state_31539__$1;
(statearr_31592_31663[(2)] = inst_31429);

(statearr_31592_31663[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (2))){
var inst_31391 = (state_31539[(13)]);
var inst_31398 = cljs.core.seq.call(null,inst_31391);
var inst_31399 = inst_31398;
var inst_31400 = null;
var inst_31401 = (0);
var inst_31402 = (0);
var state_31539__$1 = (function (){var statearr_31593 = state_31539;
(statearr_31593[(7)] = inst_31399);

(statearr_31593[(8)] = inst_31402);

(statearr_31593[(9)] = inst_31400);

(statearr_31593[(10)] = inst_31401);

return statearr_31593;
})();
var statearr_31594_31664 = state_31539__$1;
(statearr_31594_31664[(2)] = null);

(statearr_31594_31664[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (23))){
var inst_31456 = (state_31539[(23)]);
var inst_31458 = (state_31539[(26)]);
var inst_31460 = (state_31539[(24)]);
var inst_31455 = (state_31539[(25)]);
var inst_31452 = (state_31539[(19)]);
var inst_31463 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_31465 = (function (){var all_files = inst_31452;
var res_SINGLEQUOTE_ = inst_31455;
var res = inst_31456;
var files_not_loaded = inst_31458;
var dependencies_that_loaded = inst_31460;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31456,inst_31458,inst_31460,inst_31455,inst_31452,inst_31463,state_val_31540,c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__31464){
var map__31595 = p__31464;
var map__31595__$1 = ((((!((map__31595 == null)))?((((map__31595.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31595.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31595):map__31595);
var request_url = cljs.core.get.call(null,map__31595__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31456,inst_31458,inst_31460,inst_31455,inst_31452,inst_31463,state_val_31540,c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31466 = cljs.core.reverse.call(null,inst_31460);
var inst_31467 = cljs.core.map.call(null,inst_31465,inst_31466);
var inst_31468 = cljs.core.pr_str.call(null,inst_31467);
var inst_31469 = figwheel.client.utils.log.call(null,inst_31468);
var state_31539__$1 = (function (){var statearr_31597 = state_31539;
(statearr_31597[(31)] = inst_31463);

return statearr_31597;
})();
var statearr_31598_31665 = state_31539__$1;
(statearr_31598_31665[(2)] = inst_31469);

(statearr_31598_31665[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (35))){
var state_31539__$1 = state_31539;
var statearr_31599_31666 = state_31539__$1;
(statearr_31599_31666[(2)] = true);

(statearr_31599_31666[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (19))){
var inst_31442 = (state_31539[(12)]);
var inst_31448 = figwheel.client.file_reloading.expand_files.call(null,inst_31442);
var state_31539__$1 = state_31539;
var statearr_31600_31667 = state_31539__$1;
(statearr_31600_31667[(2)] = inst_31448);

(statearr_31600_31667[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (11))){
var state_31539__$1 = state_31539;
var statearr_31601_31668 = state_31539__$1;
(statearr_31601_31668[(2)] = null);

(statearr_31601_31668[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (9))){
var inst_31431 = (state_31539[(2)]);
var state_31539__$1 = state_31539;
var statearr_31602_31669 = state_31539__$1;
(statearr_31602_31669[(2)] = inst_31431);

(statearr_31602_31669[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (5))){
var inst_31402 = (state_31539[(8)]);
var inst_31401 = (state_31539[(10)]);
var inst_31404 = (inst_31402 < inst_31401);
var inst_31405 = inst_31404;
var state_31539__$1 = state_31539;
if(cljs.core.truth_(inst_31405)){
var statearr_31603_31670 = state_31539__$1;
(statearr_31603_31670[(1)] = (7));

} else {
var statearr_31604_31671 = state_31539__$1;
(statearr_31604_31671[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (14))){
var inst_31412 = (state_31539[(22)]);
var inst_31421 = cljs.core.first.call(null,inst_31412);
var inst_31422 = figwheel.client.file_reloading.eval_body.call(null,inst_31421,opts);
var inst_31423 = cljs.core.next.call(null,inst_31412);
var inst_31399 = inst_31423;
var inst_31400 = null;
var inst_31401 = (0);
var inst_31402 = (0);
var state_31539__$1 = (function (){var statearr_31605 = state_31539;
(statearr_31605[(7)] = inst_31399);

(statearr_31605[(8)] = inst_31402);

(statearr_31605[(32)] = inst_31422);

(statearr_31605[(9)] = inst_31400);

(statearr_31605[(10)] = inst_31401);

return statearr_31605;
})();
var statearr_31606_31672 = state_31539__$1;
(statearr_31606_31672[(2)] = null);

(statearr_31606_31672[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (45))){
var state_31539__$1 = state_31539;
var statearr_31607_31673 = state_31539__$1;
(statearr_31607_31673[(2)] = null);

(statearr_31607_31673[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (26))){
var inst_31456 = (state_31539[(23)]);
var inst_31458 = (state_31539[(26)]);
var inst_31460 = (state_31539[(24)]);
var inst_31455 = (state_31539[(25)]);
var inst_31452 = (state_31539[(19)]);
var inst_31475 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_31477 = (function (){var all_files = inst_31452;
var res_SINGLEQUOTE_ = inst_31455;
var res = inst_31456;
var files_not_loaded = inst_31458;
var dependencies_that_loaded = inst_31460;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31456,inst_31458,inst_31460,inst_31455,inst_31452,inst_31475,state_val_31540,c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__31476){
var map__31608 = p__31476;
var map__31608__$1 = ((((!((map__31608 == null)))?((((map__31608.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31608.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31608):map__31608);
var namespace = cljs.core.get.call(null,map__31608__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__31608__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31456,inst_31458,inst_31460,inst_31455,inst_31452,inst_31475,state_val_31540,c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31478 = cljs.core.map.call(null,inst_31477,inst_31456);
var inst_31479 = cljs.core.pr_str.call(null,inst_31478);
var inst_31480 = figwheel.client.utils.log.call(null,inst_31479);
var inst_31481 = (function (){var all_files = inst_31452;
var res_SINGLEQUOTE_ = inst_31455;
var res = inst_31456;
var files_not_loaded = inst_31458;
var dependencies_that_loaded = inst_31460;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31456,inst_31458,inst_31460,inst_31455,inst_31452,inst_31475,inst_31477,inst_31478,inst_31479,inst_31480,state_val_31540,c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31456,inst_31458,inst_31460,inst_31455,inst_31452,inst_31475,inst_31477,inst_31478,inst_31479,inst_31480,state_val_31540,c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31482 = setTimeout(inst_31481,(10));
var state_31539__$1 = (function (){var statearr_31610 = state_31539;
(statearr_31610[(33)] = inst_31475);

(statearr_31610[(34)] = inst_31480);

return statearr_31610;
})();
var statearr_31611_31674 = state_31539__$1;
(statearr_31611_31674[(2)] = inst_31482);

(statearr_31611_31674[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (16))){
var state_31539__$1 = state_31539;
var statearr_31612_31675 = state_31539__$1;
(statearr_31612_31675[(2)] = reload_dependents);

(statearr_31612_31675[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (38))){
var inst_31492 = (state_31539[(16)]);
var inst_31510 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31492);
var state_31539__$1 = state_31539;
var statearr_31613_31676 = state_31539__$1;
(statearr_31613_31676[(2)] = inst_31510);

(statearr_31613_31676[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (30))){
var state_31539__$1 = state_31539;
var statearr_31614_31677 = state_31539__$1;
(statearr_31614_31677[(2)] = null);

(statearr_31614_31677[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (10))){
var inst_31412 = (state_31539[(22)]);
var inst_31414 = cljs.core.chunked_seq_QMARK_.call(null,inst_31412);
var state_31539__$1 = state_31539;
if(inst_31414){
var statearr_31615_31678 = state_31539__$1;
(statearr_31615_31678[(1)] = (13));

} else {
var statearr_31616_31679 = state_31539__$1;
(statearr_31616_31679[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (18))){
var inst_31446 = (state_31539[(2)]);
var state_31539__$1 = state_31539;
if(cljs.core.truth_(inst_31446)){
var statearr_31617_31680 = state_31539__$1;
(statearr_31617_31680[(1)] = (19));

} else {
var statearr_31618_31681 = state_31539__$1;
(statearr_31618_31681[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (42))){
var state_31539__$1 = state_31539;
var statearr_31619_31682 = state_31539__$1;
(statearr_31619_31682[(2)] = null);

(statearr_31619_31682[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (37))){
var inst_31505 = (state_31539[(2)]);
var state_31539__$1 = state_31539;
var statearr_31620_31683 = state_31539__$1;
(statearr_31620_31683[(2)] = inst_31505);

(statearr_31620_31683[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31540 === (8))){
var inst_31399 = (state_31539[(7)]);
var inst_31412 = (state_31539[(22)]);
var inst_31412__$1 = cljs.core.seq.call(null,inst_31399);
var state_31539__$1 = (function (){var statearr_31621 = state_31539;
(statearr_31621[(22)] = inst_31412__$1);

return statearr_31621;
})();
if(inst_31412__$1){
var statearr_31622_31684 = state_31539__$1;
(statearr_31622_31684[(1)] = (10));

} else {
var statearr_31623_31685 = state_31539__$1;
(statearr_31623_31685[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__30982__auto__,c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30983__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30983__auto____0 = (function (){
var statearr_31624 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31624[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__30983__auto__);

(statearr_31624[(1)] = (1));

return statearr_31624;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__30983__auto____1 = (function (state_31539){
while(true){
var ret_value__30984__auto__ = (function (){try{while(true){
var result__30985__auto__ = switch__30982__auto__.call(null,state_31539);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30985__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30985__auto__;
}
break;
}
}catch (e31625){if((e31625 instanceof Object)){
var ex__30986__auto__ = e31625;
var statearr_31626_31686 = state_31539;
(statearr_31626_31686[(5)] = ex__30986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31539);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31625;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30984__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31687 = state_31539;
state_31539 = G__31687;
continue;
} else {
return ret_value__30984__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__30983__auto__ = function(state_31539){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30983__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30983__auto____1.call(this,state_31539);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__30983__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__30983__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__30983__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__30983__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__30983__auto__;
})()
;})(switch__30982__auto__,c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__31005__auto__ = (function (){var statearr_31627 = f__31004__auto__.call(null);
(statearr_31627[(6)] = c__31003__auto__);

return statearr_31627;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31005__auto__);
});})(c__31003__auto__,map__31384,map__31384__$1,opts,before_jsload,on_jsload,reload_dependents,map__31385,map__31385__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__31003__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__31690,link){
var map__31691 = p__31690;
var map__31691__$1 = ((((!((map__31691 == null)))?((((map__31691.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31691.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31691):map__31691);
var file = cljs.core.get.call(null,map__31691__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__31691,map__31691__$1,file){
return (function (p1__31688_SHARP_,p2__31689_SHARP_){
if(cljs.core._EQ_.call(null,p1__31688_SHARP_,p2__31689_SHARP_)){
return p1__31688_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__31691,map__31691__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__31694){
var map__31695 = p__31694;
var map__31695__$1 = ((((!((map__31695 == null)))?((((map__31695.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31695.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31695):map__31695);
var match_length = cljs.core.get.call(null,map__31695__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__31695__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__31693_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__31693_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__31697_SHARP_,p2__31698_SHARP_){
return cljs.core.assoc.call(null,p1__31697_SHARP_,cljs.core.get.call(null,p2__31698_SHARP_,key),p2__31698_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__4655__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4655__auto__)){
var link = temp__4655__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__4655__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__4655__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_31699 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_31699);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_31699);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__31700,p__31701){
var map__31702 = p__31700;
var map__31702__$1 = ((((!((map__31702 == null)))?((((map__31702.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31702.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31702):map__31702);
var on_cssload = cljs.core.get.call(null,map__31702__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__31703 = p__31701;
var map__31703__$1 = ((((!((map__31703 == null)))?((((map__31703.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31703.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31703):map__31703);
var files_msg = map__31703__$1;
var files = cljs.core.get.call(null,map__31703__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__4657__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__4657__auto__)){
var f_datas = temp__4657__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1503709582151
