(ns cmr.client.http.core
  (:require
   [cmr.client.common.util :as util]
   [cmr.client.http.impl :as impl])
  (:import (cmr.client.http.impl HTTPClientData))
  (:refer-clojure :exclude [get]))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Protocols &tc.   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defprotocol HTTPClientAPI
  "An interface for Clojure HTTP clients."
  (get [this url] [this url opts])
  (head [this url] [this url opts])
  (put [this url] [this url opts])
  (post [this url] [this url opts])
  (delete [this url] [this url opts])
  (copy [this url] [this url opts])
  (move [this url] [this url opts])
  (patch [this url] [this url opts])
  (options [this url] [this url opts]))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   Implementation   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(extend HTTPClientData
        HTTPClientAPI
        impl/client-behaviour)

(def create-client
  (util/create-http-client-constructor
    #'cmr.client.http.core/create-client
    impl/->HTTPClientData))
