// Compiled by ClojureScript 1.9.908 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__38763 = arguments.length;
switch (G__38763) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async38764 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38764 = (function (f,blockable,meta38765){
this.f = f;
this.blockable = blockable;
this.meta38765 = meta38765;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38764.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38766,meta38765__$1){
var self__ = this;
var _38766__$1 = this;
return (new cljs.core.async.t_cljs$core$async38764(self__.f,self__.blockable,meta38765__$1));
});

cljs.core.async.t_cljs$core$async38764.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38766){
var self__ = this;
var _38766__$1 = this;
return self__.meta38765;
});

cljs.core.async.t_cljs$core$async38764.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38764.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async38764.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async38764.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async38764.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta38765","meta38765",1636674601,null)], null);
});

cljs.core.async.t_cljs$core$async38764.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38764.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38764";

cljs.core.async.t_cljs$core$async38764.cljs$lang$ctorPrWriter = (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async38764");
});

cljs.core.async.__GT_t_cljs$core$async38764 = (function cljs$core$async$__GT_t_cljs$core$async38764(f__$1,blockable__$1,meta38765){
return (new cljs.core.async.t_cljs$core$async38764(f__$1,blockable__$1,meta38765));
});

}

return (new cljs.core.async.t_cljs$core$async38764(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__38770 = arguments.length;
switch (G__38770) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__38773 = arguments.length;
switch (G__38773) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__38776 = arguments.length;
switch (G__38776) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_38778 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_38778);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_38778,ret){
return (function (){
return fn1.call(null,val_38778);
});})(val_38778,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__38780 = arguments.length;
switch (G__38780) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__29292__auto___38782 = n;
var x_38783 = (0);
while(true){
if((x_38783 < n__29292__auto___38782)){
(a[x_38783] = (0));

var G__38784 = (x_38783 + (1));
x_38783 = G__38784;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__38785 = (i + (1));
i = G__38785;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async38786 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38786 = (function (flag,meta38787){
this.flag = flag;
this.meta38787 = meta38787;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38786.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_38788,meta38787__$1){
var self__ = this;
var _38788__$1 = this;
return (new cljs.core.async.t_cljs$core$async38786(self__.flag,meta38787__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async38786.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_38788){
var self__ = this;
var _38788__$1 = this;
return self__.meta38787;
});})(flag))
;

cljs.core.async.t_cljs$core$async38786.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38786.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async38786.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async38786.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async38786.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta38787","meta38787",396334432,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async38786.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38786.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38786";

cljs.core.async.t_cljs$core$async38786.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async38786");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async38786 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async38786(flag__$1,meta38787){
return (new cljs.core.async.t_cljs$core$async38786(flag__$1,meta38787));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async38786(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async38789 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38789 = (function (flag,cb,meta38790){
this.flag = flag;
this.cb = cb;
this.meta38790 = meta38790;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async38789.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38791,meta38790__$1){
var self__ = this;
var _38791__$1 = this;
return (new cljs.core.async.t_cljs$core$async38789(self__.flag,self__.cb,meta38790__$1));
});

cljs.core.async.t_cljs$core$async38789.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38791){
var self__ = this;
var _38791__$1 = this;
return self__.meta38790;
});

cljs.core.async.t_cljs$core$async38789.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async38789.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async38789.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async38789.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async38789.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta38790","meta38790",511338940,null)], null);
});

cljs.core.async.t_cljs$core$async38789.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38789.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38789";

cljs.core.async.t_cljs$core$async38789.cljs$lang$ctorPrWriter = (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async38789");
});

cljs.core.async.__GT_t_cljs$core$async38789 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async38789(flag__$1,cb__$1,meta38790){
return (new cljs.core.async.t_cljs$core$async38789(flag__$1,cb__$1,meta38790));
});

}

return (new cljs.core.async.t_cljs$core$async38789(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__38792_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__38792_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__38793_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__38793_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__28347__auto__ = wport;
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return port;
}
})()], null));
} else {
var G__38794 = (i + (1));
i = G__38794;
continue;
}
} else {
return null;
}
break;
}
})();
var or__28347__auto__ = ret;
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__28335__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__28335__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__28335__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__29523__auto__ = [];
var len__29516__auto___38800 = arguments.length;
var i__29517__auto___38801 = (0);
while(true){
if((i__29517__auto___38801 < len__29516__auto___38800)){
args__29523__auto__.push((arguments[i__29517__auto___38801]));

var G__38802 = (i__29517__auto___38801 + (1));
i__29517__auto___38801 = G__38802;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__38797){
var map__38798 = p__38797;
var map__38798__$1 = ((((!((map__38798 == null)))?((((map__38798.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38798.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38798):map__38798);
var opts = map__38798__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq38795){
var G__38796 = cljs.core.first.call(null,seq38795);
var seq38795__$1 = cljs.core.next.call(null,seq38795);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__38796,seq38795__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__38804 = arguments.length;
switch (G__38804) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__30790__auto___38850 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto___38850){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto___38850){
return (function (state_38828){
var state_val_38829 = (state_38828[(1)]);
if((state_val_38829 === (7))){
var inst_38824 = (state_38828[(2)]);
var state_38828__$1 = state_38828;
var statearr_38830_38851 = state_38828__$1;
(statearr_38830_38851[(2)] = inst_38824);

(statearr_38830_38851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38829 === (1))){
var state_38828__$1 = state_38828;
var statearr_38831_38852 = state_38828__$1;
(statearr_38831_38852[(2)] = null);

(statearr_38831_38852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38829 === (4))){
var inst_38807 = (state_38828[(7)]);
var inst_38807__$1 = (state_38828[(2)]);
var inst_38808 = (inst_38807__$1 == null);
var state_38828__$1 = (function (){var statearr_38832 = state_38828;
(statearr_38832[(7)] = inst_38807__$1);

return statearr_38832;
})();
if(cljs.core.truth_(inst_38808)){
var statearr_38833_38853 = state_38828__$1;
(statearr_38833_38853[(1)] = (5));

} else {
var statearr_38834_38854 = state_38828__$1;
(statearr_38834_38854[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38829 === (13))){
var state_38828__$1 = state_38828;
var statearr_38835_38855 = state_38828__$1;
(statearr_38835_38855[(2)] = null);

(statearr_38835_38855[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38829 === (6))){
var inst_38807 = (state_38828[(7)]);
var state_38828__$1 = state_38828;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38828__$1,(11),to,inst_38807);
} else {
if((state_val_38829 === (3))){
var inst_38826 = (state_38828[(2)]);
var state_38828__$1 = state_38828;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38828__$1,inst_38826);
} else {
if((state_val_38829 === (12))){
var state_38828__$1 = state_38828;
var statearr_38836_38856 = state_38828__$1;
(statearr_38836_38856[(2)] = null);

(statearr_38836_38856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38829 === (2))){
var state_38828__$1 = state_38828;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38828__$1,(4),from);
} else {
if((state_val_38829 === (11))){
var inst_38817 = (state_38828[(2)]);
var state_38828__$1 = state_38828;
if(cljs.core.truth_(inst_38817)){
var statearr_38837_38857 = state_38828__$1;
(statearr_38837_38857[(1)] = (12));

} else {
var statearr_38838_38858 = state_38828__$1;
(statearr_38838_38858[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38829 === (9))){
var state_38828__$1 = state_38828;
var statearr_38839_38859 = state_38828__$1;
(statearr_38839_38859[(2)] = null);

(statearr_38839_38859[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38829 === (5))){
var state_38828__$1 = state_38828;
if(cljs.core.truth_(close_QMARK_)){
var statearr_38840_38860 = state_38828__$1;
(statearr_38840_38860[(1)] = (8));

} else {
var statearr_38841_38861 = state_38828__$1;
(statearr_38841_38861[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38829 === (14))){
var inst_38822 = (state_38828[(2)]);
var state_38828__$1 = state_38828;
var statearr_38842_38862 = state_38828__$1;
(statearr_38842_38862[(2)] = inst_38822);

(statearr_38842_38862[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38829 === (10))){
var inst_38814 = (state_38828[(2)]);
var state_38828__$1 = state_38828;
var statearr_38843_38863 = state_38828__$1;
(statearr_38843_38863[(2)] = inst_38814);

(statearr_38843_38863[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38829 === (8))){
var inst_38811 = cljs.core.async.close_BANG_.call(null,to);
var state_38828__$1 = state_38828;
var statearr_38844_38864 = state_38828__$1;
(statearr_38844_38864[(2)] = inst_38811);

(statearr_38844_38864[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto___38850))
;
return ((function (switch__30769__auto__,c__30790__auto___38850){
return (function() {
var cljs$core$async$state_machine__30770__auto__ = null;
var cljs$core$async$state_machine__30770__auto____0 = (function (){
var statearr_38845 = [null,null,null,null,null,null,null,null];
(statearr_38845[(0)] = cljs$core$async$state_machine__30770__auto__);

(statearr_38845[(1)] = (1));

return statearr_38845;
});
var cljs$core$async$state_machine__30770__auto____1 = (function (state_38828){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_38828);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e38846){if((e38846 instanceof Object)){
var ex__30773__auto__ = e38846;
var statearr_38847_38865 = state_38828;
(statearr_38847_38865[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38828);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38846;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38866 = state_38828;
state_38828 = G__38866;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$state_machine__30770__auto__ = function(state_38828){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30770__auto____1.call(this,state_38828);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30770__auto____0;
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30770__auto____1;
return cljs$core$async$state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto___38850))
})();
var state__30792__auto__ = (function (){var statearr_38848 = f__30791__auto__.call(null);
(statearr_38848[(6)] = c__30790__auto___38850);

return statearr_38848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto___38850))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__38867){
var vec__38868 = p__38867;
var v = cljs.core.nth.call(null,vec__38868,(0),null);
var p = cljs.core.nth.call(null,vec__38868,(1),null);
var job = vec__38868;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__30790__auto___39039 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto___39039,res,vec__38868,v,p,job,jobs,results){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto___39039,res,vec__38868,v,p,job,jobs,results){
return (function (state_38875){
var state_val_38876 = (state_38875[(1)]);
if((state_val_38876 === (1))){
var state_38875__$1 = state_38875;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38875__$1,(2),res,v);
} else {
if((state_val_38876 === (2))){
var inst_38872 = (state_38875[(2)]);
var inst_38873 = cljs.core.async.close_BANG_.call(null,res);
var state_38875__$1 = (function (){var statearr_38877 = state_38875;
(statearr_38877[(7)] = inst_38872);

return statearr_38877;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38875__$1,inst_38873);
} else {
return null;
}
}
});})(c__30790__auto___39039,res,vec__38868,v,p,job,jobs,results))
;
return ((function (switch__30769__auto__,c__30790__auto___39039,res,vec__38868,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____0 = (function (){
var statearr_38878 = [null,null,null,null,null,null,null,null];
(statearr_38878[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__);

(statearr_38878[(1)] = (1));

return statearr_38878;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____1 = (function (state_38875){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_38875);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e38879){if((e38879 instanceof Object)){
var ex__30773__auto__ = e38879;
var statearr_38880_39040 = state_38875;
(statearr_38880_39040[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38875);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38879;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39041 = state_38875;
state_38875 = G__39041;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__ = function(state_38875){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____1.call(this,state_38875);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto___39039,res,vec__38868,v,p,job,jobs,results))
})();
var state__30792__auto__ = (function (){var statearr_38881 = f__30791__auto__.call(null);
(statearr_38881[(6)] = c__30790__auto___39039);

return statearr_38881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto___39039,res,vec__38868,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__38882){
var vec__38883 = p__38882;
var v = cljs.core.nth.call(null,vec__38883,(0),null);
var p = cljs.core.nth.call(null,vec__38883,(1),null);
var job = vec__38883;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__29292__auto___39042 = n;
var __39043 = (0);
while(true){
if((__39043 < n__29292__auto___39042)){
var G__38886_39044 = type;
var G__38886_39045__$1 = (((G__38886_39044 instanceof cljs.core.Keyword))?G__38886_39044.fqn:null);
switch (G__38886_39045__$1) {
case "compute":
var c__30790__auto___39047 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__39043,c__30790__auto___39047,G__38886_39044,G__38886_39045__$1,n__29292__auto___39042,jobs,results,process,async){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (__39043,c__30790__auto___39047,G__38886_39044,G__38886_39045__$1,n__29292__auto___39042,jobs,results,process,async){
return (function (state_38899){
var state_val_38900 = (state_38899[(1)]);
if((state_val_38900 === (1))){
var state_38899__$1 = state_38899;
var statearr_38901_39048 = state_38899__$1;
(statearr_38901_39048[(2)] = null);

(statearr_38901_39048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38900 === (2))){
var state_38899__$1 = state_38899;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38899__$1,(4),jobs);
} else {
if((state_val_38900 === (3))){
var inst_38897 = (state_38899[(2)]);
var state_38899__$1 = state_38899;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38899__$1,inst_38897);
} else {
if((state_val_38900 === (4))){
var inst_38889 = (state_38899[(2)]);
var inst_38890 = process.call(null,inst_38889);
var state_38899__$1 = state_38899;
if(cljs.core.truth_(inst_38890)){
var statearr_38902_39049 = state_38899__$1;
(statearr_38902_39049[(1)] = (5));

} else {
var statearr_38903_39050 = state_38899__$1;
(statearr_38903_39050[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38900 === (5))){
var state_38899__$1 = state_38899;
var statearr_38904_39051 = state_38899__$1;
(statearr_38904_39051[(2)] = null);

(statearr_38904_39051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38900 === (6))){
var state_38899__$1 = state_38899;
var statearr_38905_39052 = state_38899__$1;
(statearr_38905_39052[(2)] = null);

(statearr_38905_39052[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38900 === (7))){
var inst_38895 = (state_38899[(2)]);
var state_38899__$1 = state_38899;
var statearr_38906_39053 = state_38899__$1;
(statearr_38906_39053[(2)] = inst_38895);

(statearr_38906_39053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__39043,c__30790__auto___39047,G__38886_39044,G__38886_39045__$1,n__29292__auto___39042,jobs,results,process,async))
;
return ((function (__39043,switch__30769__auto__,c__30790__auto___39047,G__38886_39044,G__38886_39045__$1,n__29292__auto___39042,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____0 = (function (){
var statearr_38907 = [null,null,null,null,null,null,null];
(statearr_38907[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__);

(statearr_38907[(1)] = (1));

return statearr_38907;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____1 = (function (state_38899){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_38899);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e38908){if((e38908 instanceof Object)){
var ex__30773__auto__ = e38908;
var statearr_38909_39054 = state_38899;
(statearr_38909_39054[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38899);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38908;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39055 = state_38899;
state_38899 = G__39055;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__ = function(state_38899){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____1.call(this,state_38899);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__;
})()
;})(__39043,switch__30769__auto__,c__30790__auto___39047,G__38886_39044,G__38886_39045__$1,n__29292__auto___39042,jobs,results,process,async))
})();
var state__30792__auto__ = (function (){var statearr_38910 = f__30791__auto__.call(null);
(statearr_38910[(6)] = c__30790__auto___39047);

return statearr_38910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(__39043,c__30790__auto___39047,G__38886_39044,G__38886_39045__$1,n__29292__auto___39042,jobs,results,process,async))
);


break;
case "async":
var c__30790__auto___39056 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__39043,c__30790__auto___39056,G__38886_39044,G__38886_39045__$1,n__29292__auto___39042,jobs,results,process,async){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (__39043,c__30790__auto___39056,G__38886_39044,G__38886_39045__$1,n__29292__auto___39042,jobs,results,process,async){
return (function (state_38923){
var state_val_38924 = (state_38923[(1)]);
if((state_val_38924 === (1))){
var state_38923__$1 = state_38923;
var statearr_38925_39057 = state_38923__$1;
(statearr_38925_39057[(2)] = null);

(statearr_38925_39057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38924 === (2))){
var state_38923__$1 = state_38923;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38923__$1,(4),jobs);
} else {
if((state_val_38924 === (3))){
var inst_38921 = (state_38923[(2)]);
var state_38923__$1 = state_38923;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38923__$1,inst_38921);
} else {
if((state_val_38924 === (4))){
var inst_38913 = (state_38923[(2)]);
var inst_38914 = async.call(null,inst_38913);
var state_38923__$1 = state_38923;
if(cljs.core.truth_(inst_38914)){
var statearr_38926_39058 = state_38923__$1;
(statearr_38926_39058[(1)] = (5));

} else {
var statearr_38927_39059 = state_38923__$1;
(statearr_38927_39059[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38924 === (5))){
var state_38923__$1 = state_38923;
var statearr_38928_39060 = state_38923__$1;
(statearr_38928_39060[(2)] = null);

(statearr_38928_39060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38924 === (6))){
var state_38923__$1 = state_38923;
var statearr_38929_39061 = state_38923__$1;
(statearr_38929_39061[(2)] = null);

(statearr_38929_39061[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38924 === (7))){
var inst_38919 = (state_38923[(2)]);
var state_38923__$1 = state_38923;
var statearr_38930_39062 = state_38923__$1;
(statearr_38930_39062[(2)] = inst_38919);

(statearr_38930_39062[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__39043,c__30790__auto___39056,G__38886_39044,G__38886_39045__$1,n__29292__auto___39042,jobs,results,process,async))
;
return ((function (__39043,switch__30769__auto__,c__30790__auto___39056,G__38886_39044,G__38886_39045__$1,n__29292__auto___39042,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____0 = (function (){
var statearr_38931 = [null,null,null,null,null,null,null];
(statearr_38931[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__);

(statearr_38931[(1)] = (1));

return statearr_38931;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____1 = (function (state_38923){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_38923);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e38932){if((e38932 instanceof Object)){
var ex__30773__auto__ = e38932;
var statearr_38933_39063 = state_38923;
(statearr_38933_39063[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38923);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38932;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39064 = state_38923;
state_38923 = G__39064;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__ = function(state_38923){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____1.call(this,state_38923);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__;
})()
;})(__39043,switch__30769__auto__,c__30790__auto___39056,G__38886_39044,G__38886_39045__$1,n__29292__auto___39042,jobs,results,process,async))
})();
var state__30792__auto__ = (function (){var statearr_38934 = f__30791__auto__.call(null);
(statearr_38934[(6)] = c__30790__auto___39056);

return statearr_38934;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(__39043,c__30790__auto___39056,G__38886_39044,G__38886_39045__$1,n__29292__auto___39042,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__38886_39045__$1)].join('')));

}

var G__39065 = (__39043 + (1));
__39043 = G__39065;
continue;
} else {
}
break;
}

var c__30790__auto___39066 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto___39066,jobs,results,process,async){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto___39066,jobs,results,process,async){
return (function (state_38956){
var state_val_38957 = (state_38956[(1)]);
if((state_val_38957 === (1))){
var state_38956__$1 = state_38956;
var statearr_38958_39067 = state_38956__$1;
(statearr_38958_39067[(2)] = null);

(statearr_38958_39067[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38957 === (2))){
var state_38956__$1 = state_38956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38956__$1,(4),from);
} else {
if((state_val_38957 === (3))){
var inst_38954 = (state_38956[(2)]);
var state_38956__$1 = state_38956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38956__$1,inst_38954);
} else {
if((state_val_38957 === (4))){
var inst_38937 = (state_38956[(7)]);
var inst_38937__$1 = (state_38956[(2)]);
var inst_38938 = (inst_38937__$1 == null);
var state_38956__$1 = (function (){var statearr_38959 = state_38956;
(statearr_38959[(7)] = inst_38937__$1);

return statearr_38959;
})();
if(cljs.core.truth_(inst_38938)){
var statearr_38960_39068 = state_38956__$1;
(statearr_38960_39068[(1)] = (5));

} else {
var statearr_38961_39069 = state_38956__$1;
(statearr_38961_39069[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38957 === (5))){
var inst_38940 = cljs.core.async.close_BANG_.call(null,jobs);
var state_38956__$1 = state_38956;
var statearr_38962_39070 = state_38956__$1;
(statearr_38962_39070[(2)] = inst_38940);

(statearr_38962_39070[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38957 === (6))){
var inst_38937 = (state_38956[(7)]);
var inst_38942 = (state_38956[(8)]);
var inst_38942__$1 = cljs.core.async.chan.call(null,(1));
var inst_38943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38944 = [inst_38937,inst_38942__$1];
var inst_38945 = (new cljs.core.PersistentVector(null,2,(5),inst_38943,inst_38944,null));
var state_38956__$1 = (function (){var statearr_38963 = state_38956;
(statearr_38963[(8)] = inst_38942__$1);

return statearr_38963;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38956__$1,(8),jobs,inst_38945);
} else {
if((state_val_38957 === (7))){
var inst_38952 = (state_38956[(2)]);
var state_38956__$1 = state_38956;
var statearr_38964_39071 = state_38956__$1;
(statearr_38964_39071[(2)] = inst_38952);

(statearr_38964_39071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38957 === (8))){
var inst_38942 = (state_38956[(8)]);
var inst_38947 = (state_38956[(2)]);
var state_38956__$1 = (function (){var statearr_38965 = state_38956;
(statearr_38965[(9)] = inst_38947);

return statearr_38965;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_38956__$1,(9),results,inst_38942);
} else {
if((state_val_38957 === (9))){
var inst_38949 = (state_38956[(2)]);
var state_38956__$1 = (function (){var statearr_38966 = state_38956;
(statearr_38966[(10)] = inst_38949);

return statearr_38966;
})();
var statearr_38967_39072 = state_38956__$1;
(statearr_38967_39072[(2)] = null);

(statearr_38967_39072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__30790__auto___39066,jobs,results,process,async))
;
return ((function (switch__30769__auto__,c__30790__auto___39066,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____0 = (function (){
var statearr_38968 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38968[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__);

(statearr_38968[(1)] = (1));

return statearr_38968;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____1 = (function (state_38956){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_38956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e38969){if((e38969 instanceof Object)){
var ex__30773__auto__ = e38969;
var statearr_38970_39073 = state_38956;
(statearr_38970_39073[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_38956);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e38969;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39074 = state_38956;
state_38956 = G__39074;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__ = function(state_38956){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____1.call(this,state_38956);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto___39066,jobs,results,process,async))
})();
var state__30792__auto__ = (function (){var statearr_38971 = f__30791__auto__.call(null);
(statearr_38971[(6)] = c__30790__auto___39066);

return statearr_38971;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto___39066,jobs,results,process,async))
);


var c__30790__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto__,jobs,results,process,async){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto__,jobs,results,process,async){
return (function (state_39009){
var state_val_39010 = (state_39009[(1)]);
if((state_val_39010 === (7))){
var inst_39005 = (state_39009[(2)]);
var state_39009__$1 = state_39009;
var statearr_39011_39075 = state_39009__$1;
(statearr_39011_39075[(2)] = inst_39005);

(statearr_39011_39075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39010 === (20))){
var state_39009__$1 = state_39009;
var statearr_39012_39076 = state_39009__$1;
(statearr_39012_39076[(2)] = null);

(statearr_39012_39076[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39010 === (1))){
var state_39009__$1 = state_39009;
var statearr_39013_39077 = state_39009__$1;
(statearr_39013_39077[(2)] = null);

(statearr_39013_39077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39010 === (4))){
var inst_38974 = (state_39009[(7)]);
var inst_38974__$1 = (state_39009[(2)]);
var inst_38975 = (inst_38974__$1 == null);
var state_39009__$1 = (function (){var statearr_39014 = state_39009;
(statearr_39014[(7)] = inst_38974__$1);

return statearr_39014;
})();
if(cljs.core.truth_(inst_38975)){
var statearr_39015_39078 = state_39009__$1;
(statearr_39015_39078[(1)] = (5));

} else {
var statearr_39016_39079 = state_39009__$1;
(statearr_39016_39079[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39010 === (15))){
var inst_38987 = (state_39009[(8)]);
var state_39009__$1 = state_39009;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39009__$1,(18),to,inst_38987);
} else {
if((state_val_39010 === (21))){
var inst_39000 = (state_39009[(2)]);
var state_39009__$1 = state_39009;
var statearr_39017_39080 = state_39009__$1;
(statearr_39017_39080[(2)] = inst_39000);

(statearr_39017_39080[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39010 === (13))){
var inst_39002 = (state_39009[(2)]);
var state_39009__$1 = (function (){var statearr_39018 = state_39009;
(statearr_39018[(9)] = inst_39002);

return statearr_39018;
})();
var statearr_39019_39081 = state_39009__$1;
(statearr_39019_39081[(2)] = null);

(statearr_39019_39081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39010 === (6))){
var inst_38974 = (state_39009[(7)]);
var state_39009__$1 = state_39009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39009__$1,(11),inst_38974);
} else {
if((state_val_39010 === (17))){
var inst_38995 = (state_39009[(2)]);
var state_39009__$1 = state_39009;
if(cljs.core.truth_(inst_38995)){
var statearr_39020_39082 = state_39009__$1;
(statearr_39020_39082[(1)] = (19));

} else {
var statearr_39021_39083 = state_39009__$1;
(statearr_39021_39083[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39010 === (3))){
var inst_39007 = (state_39009[(2)]);
var state_39009__$1 = state_39009;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39009__$1,inst_39007);
} else {
if((state_val_39010 === (12))){
var inst_38984 = (state_39009[(10)]);
var state_39009__$1 = state_39009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39009__$1,(14),inst_38984);
} else {
if((state_val_39010 === (2))){
var state_39009__$1 = state_39009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39009__$1,(4),results);
} else {
if((state_val_39010 === (19))){
var state_39009__$1 = state_39009;
var statearr_39022_39084 = state_39009__$1;
(statearr_39022_39084[(2)] = null);

(statearr_39022_39084[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39010 === (11))){
var inst_38984 = (state_39009[(2)]);
var state_39009__$1 = (function (){var statearr_39023 = state_39009;
(statearr_39023[(10)] = inst_38984);

return statearr_39023;
})();
var statearr_39024_39085 = state_39009__$1;
(statearr_39024_39085[(2)] = null);

(statearr_39024_39085[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39010 === (9))){
var state_39009__$1 = state_39009;
var statearr_39025_39086 = state_39009__$1;
(statearr_39025_39086[(2)] = null);

(statearr_39025_39086[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39010 === (5))){
var state_39009__$1 = state_39009;
if(cljs.core.truth_(close_QMARK_)){
var statearr_39026_39087 = state_39009__$1;
(statearr_39026_39087[(1)] = (8));

} else {
var statearr_39027_39088 = state_39009__$1;
(statearr_39027_39088[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39010 === (14))){
var inst_38987 = (state_39009[(8)]);
var inst_38989 = (state_39009[(11)]);
var inst_38987__$1 = (state_39009[(2)]);
var inst_38988 = (inst_38987__$1 == null);
var inst_38989__$1 = cljs.core.not.call(null,inst_38988);
var state_39009__$1 = (function (){var statearr_39028 = state_39009;
(statearr_39028[(8)] = inst_38987__$1);

(statearr_39028[(11)] = inst_38989__$1);

return statearr_39028;
})();
if(inst_38989__$1){
var statearr_39029_39089 = state_39009__$1;
(statearr_39029_39089[(1)] = (15));

} else {
var statearr_39030_39090 = state_39009__$1;
(statearr_39030_39090[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39010 === (16))){
var inst_38989 = (state_39009[(11)]);
var state_39009__$1 = state_39009;
var statearr_39031_39091 = state_39009__$1;
(statearr_39031_39091[(2)] = inst_38989);

(statearr_39031_39091[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39010 === (10))){
var inst_38981 = (state_39009[(2)]);
var state_39009__$1 = state_39009;
var statearr_39032_39092 = state_39009__$1;
(statearr_39032_39092[(2)] = inst_38981);

(statearr_39032_39092[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39010 === (18))){
var inst_38992 = (state_39009[(2)]);
var state_39009__$1 = state_39009;
var statearr_39033_39093 = state_39009__$1;
(statearr_39033_39093[(2)] = inst_38992);

(statearr_39033_39093[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39010 === (8))){
var inst_38978 = cljs.core.async.close_BANG_.call(null,to);
var state_39009__$1 = state_39009;
var statearr_39034_39094 = state_39009__$1;
(statearr_39034_39094[(2)] = inst_38978);

(statearr_39034_39094[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto__,jobs,results,process,async))
;
return ((function (switch__30769__auto__,c__30790__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____0 = (function (){
var statearr_39035 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39035[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__);

(statearr_39035[(1)] = (1));

return statearr_39035;
});
var cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____1 = (function (state_39009){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_39009);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e39036){if((e39036 instanceof Object)){
var ex__30773__auto__ = e39036;
var statearr_39037_39095 = state_39009;
(statearr_39037_39095[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39009);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39036;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39096 = state_39009;
state_39009 = G__39096;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__ = function(state_39009){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____1.call(this,state_39009);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__30770__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto__,jobs,results,process,async))
})();
var state__30792__auto__ = (function (){var statearr_39038 = f__30791__auto__.call(null);
(statearr_39038[(6)] = c__30790__auto__);

return statearr_39038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto__,jobs,results,process,async))
);

return c__30790__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__39098 = arguments.length;
switch (G__39098) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__39101 = arguments.length;
switch (G__39101) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__39104 = arguments.length;
switch (G__39104) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__30790__auto___39153 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto___39153,tc,fc){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto___39153,tc,fc){
return (function (state_39130){
var state_val_39131 = (state_39130[(1)]);
if((state_val_39131 === (7))){
var inst_39126 = (state_39130[(2)]);
var state_39130__$1 = state_39130;
var statearr_39132_39154 = state_39130__$1;
(statearr_39132_39154[(2)] = inst_39126);

(statearr_39132_39154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39131 === (1))){
var state_39130__$1 = state_39130;
var statearr_39133_39155 = state_39130__$1;
(statearr_39133_39155[(2)] = null);

(statearr_39133_39155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39131 === (4))){
var inst_39107 = (state_39130[(7)]);
var inst_39107__$1 = (state_39130[(2)]);
var inst_39108 = (inst_39107__$1 == null);
var state_39130__$1 = (function (){var statearr_39134 = state_39130;
(statearr_39134[(7)] = inst_39107__$1);

return statearr_39134;
})();
if(cljs.core.truth_(inst_39108)){
var statearr_39135_39156 = state_39130__$1;
(statearr_39135_39156[(1)] = (5));

} else {
var statearr_39136_39157 = state_39130__$1;
(statearr_39136_39157[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39131 === (13))){
var state_39130__$1 = state_39130;
var statearr_39137_39158 = state_39130__$1;
(statearr_39137_39158[(2)] = null);

(statearr_39137_39158[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39131 === (6))){
var inst_39107 = (state_39130[(7)]);
var inst_39113 = p.call(null,inst_39107);
var state_39130__$1 = state_39130;
if(cljs.core.truth_(inst_39113)){
var statearr_39138_39159 = state_39130__$1;
(statearr_39138_39159[(1)] = (9));

} else {
var statearr_39139_39160 = state_39130__$1;
(statearr_39139_39160[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39131 === (3))){
var inst_39128 = (state_39130[(2)]);
var state_39130__$1 = state_39130;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39130__$1,inst_39128);
} else {
if((state_val_39131 === (12))){
var state_39130__$1 = state_39130;
var statearr_39140_39161 = state_39130__$1;
(statearr_39140_39161[(2)] = null);

(statearr_39140_39161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39131 === (2))){
var state_39130__$1 = state_39130;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39130__$1,(4),ch);
} else {
if((state_val_39131 === (11))){
var inst_39107 = (state_39130[(7)]);
var inst_39117 = (state_39130[(2)]);
var state_39130__$1 = state_39130;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39130__$1,(8),inst_39117,inst_39107);
} else {
if((state_val_39131 === (9))){
var state_39130__$1 = state_39130;
var statearr_39141_39162 = state_39130__$1;
(statearr_39141_39162[(2)] = tc);

(statearr_39141_39162[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39131 === (5))){
var inst_39110 = cljs.core.async.close_BANG_.call(null,tc);
var inst_39111 = cljs.core.async.close_BANG_.call(null,fc);
var state_39130__$1 = (function (){var statearr_39142 = state_39130;
(statearr_39142[(8)] = inst_39110);

return statearr_39142;
})();
var statearr_39143_39163 = state_39130__$1;
(statearr_39143_39163[(2)] = inst_39111);

(statearr_39143_39163[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39131 === (14))){
var inst_39124 = (state_39130[(2)]);
var state_39130__$1 = state_39130;
var statearr_39144_39164 = state_39130__$1;
(statearr_39144_39164[(2)] = inst_39124);

(statearr_39144_39164[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39131 === (10))){
var state_39130__$1 = state_39130;
var statearr_39145_39165 = state_39130__$1;
(statearr_39145_39165[(2)] = fc);

(statearr_39145_39165[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39131 === (8))){
var inst_39119 = (state_39130[(2)]);
var state_39130__$1 = state_39130;
if(cljs.core.truth_(inst_39119)){
var statearr_39146_39166 = state_39130__$1;
(statearr_39146_39166[(1)] = (12));

} else {
var statearr_39147_39167 = state_39130__$1;
(statearr_39147_39167[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto___39153,tc,fc))
;
return ((function (switch__30769__auto__,c__30790__auto___39153,tc,fc){
return (function() {
var cljs$core$async$state_machine__30770__auto__ = null;
var cljs$core$async$state_machine__30770__auto____0 = (function (){
var statearr_39148 = [null,null,null,null,null,null,null,null,null];
(statearr_39148[(0)] = cljs$core$async$state_machine__30770__auto__);

(statearr_39148[(1)] = (1));

return statearr_39148;
});
var cljs$core$async$state_machine__30770__auto____1 = (function (state_39130){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_39130);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e39149){if((e39149 instanceof Object)){
var ex__30773__auto__ = e39149;
var statearr_39150_39168 = state_39130;
(statearr_39150_39168[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39130);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39149;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39169 = state_39130;
state_39130 = G__39169;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$state_machine__30770__auto__ = function(state_39130){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30770__auto____1.call(this,state_39130);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30770__auto____0;
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30770__auto____1;
return cljs$core$async$state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto___39153,tc,fc))
})();
var state__30792__auto__ = (function (){var statearr_39151 = f__30791__auto__.call(null);
(statearr_39151[(6)] = c__30790__auto___39153);

return statearr_39151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto___39153,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__30790__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto__){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto__){
return (function (state_39190){
var state_val_39191 = (state_39190[(1)]);
if((state_val_39191 === (7))){
var inst_39186 = (state_39190[(2)]);
var state_39190__$1 = state_39190;
var statearr_39192_39210 = state_39190__$1;
(statearr_39192_39210[(2)] = inst_39186);

(statearr_39192_39210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39191 === (1))){
var inst_39170 = init;
var state_39190__$1 = (function (){var statearr_39193 = state_39190;
(statearr_39193[(7)] = inst_39170);

return statearr_39193;
})();
var statearr_39194_39211 = state_39190__$1;
(statearr_39194_39211[(2)] = null);

(statearr_39194_39211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39191 === (4))){
var inst_39173 = (state_39190[(8)]);
var inst_39173__$1 = (state_39190[(2)]);
var inst_39174 = (inst_39173__$1 == null);
var state_39190__$1 = (function (){var statearr_39195 = state_39190;
(statearr_39195[(8)] = inst_39173__$1);

return statearr_39195;
})();
if(cljs.core.truth_(inst_39174)){
var statearr_39196_39212 = state_39190__$1;
(statearr_39196_39212[(1)] = (5));

} else {
var statearr_39197_39213 = state_39190__$1;
(statearr_39197_39213[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39191 === (6))){
var inst_39173 = (state_39190[(8)]);
var inst_39170 = (state_39190[(7)]);
var inst_39177 = (state_39190[(9)]);
var inst_39177__$1 = f.call(null,inst_39170,inst_39173);
var inst_39178 = cljs.core.reduced_QMARK_.call(null,inst_39177__$1);
var state_39190__$1 = (function (){var statearr_39198 = state_39190;
(statearr_39198[(9)] = inst_39177__$1);

return statearr_39198;
})();
if(inst_39178){
var statearr_39199_39214 = state_39190__$1;
(statearr_39199_39214[(1)] = (8));

} else {
var statearr_39200_39215 = state_39190__$1;
(statearr_39200_39215[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39191 === (3))){
var inst_39188 = (state_39190[(2)]);
var state_39190__$1 = state_39190;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39190__$1,inst_39188);
} else {
if((state_val_39191 === (2))){
var state_39190__$1 = state_39190;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39190__$1,(4),ch);
} else {
if((state_val_39191 === (9))){
var inst_39177 = (state_39190[(9)]);
var inst_39170 = inst_39177;
var state_39190__$1 = (function (){var statearr_39201 = state_39190;
(statearr_39201[(7)] = inst_39170);

return statearr_39201;
})();
var statearr_39202_39216 = state_39190__$1;
(statearr_39202_39216[(2)] = null);

(statearr_39202_39216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39191 === (5))){
var inst_39170 = (state_39190[(7)]);
var state_39190__$1 = state_39190;
var statearr_39203_39217 = state_39190__$1;
(statearr_39203_39217[(2)] = inst_39170);

(statearr_39203_39217[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39191 === (10))){
var inst_39184 = (state_39190[(2)]);
var state_39190__$1 = state_39190;
var statearr_39204_39218 = state_39190__$1;
(statearr_39204_39218[(2)] = inst_39184);

(statearr_39204_39218[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39191 === (8))){
var inst_39177 = (state_39190[(9)]);
var inst_39180 = cljs.core.deref.call(null,inst_39177);
var state_39190__$1 = state_39190;
var statearr_39205_39219 = state_39190__$1;
(statearr_39205_39219[(2)] = inst_39180);

(statearr_39205_39219[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto__))
;
return ((function (switch__30769__auto__,c__30790__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__30770__auto__ = null;
var cljs$core$async$reduce_$_state_machine__30770__auto____0 = (function (){
var statearr_39206 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39206[(0)] = cljs$core$async$reduce_$_state_machine__30770__auto__);

(statearr_39206[(1)] = (1));

return statearr_39206;
});
var cljs$core$async$reduce_$_state_machine__30770__auto____1 = (function (state_39190){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_39190);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e39207){if((e39207 instanceof Object)){
var ex__30773__auto__ = e39207;
var statearr_39208_39220 = state_39190;
(statearr_39208_39220[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39190);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39207;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39221 = state_39190;
state_39190 = G__39221;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__30770__auto__ = function(state_39190){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__30770__auto____1.call(this,state_39190);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__30770__auto____0;
cljs$core$async$reduce_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__30770__auto____1;
return cljs$core$async$reduce_$_state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto__))
})();
var state__30792__auto__ = (function (){var statearr_39209 = f__30791__auto__.call(null);
(statearr_39209[(6)] = c__30790__auto__);

return statearr_39209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto__))
);

return c__30790__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__30790__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto__,f__$1){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto__,f__$1){
return (function (state_39227){
var state_val_39228 = (state_39227[(1)]);
if((state_val_39228 === (1))){
var inst_39222 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_39227__$1 = state_39227;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39227__$1,(2),inst_39222);
} else {
if((state_val_39228 === (2))){
var inst_39224 = (state_39227[(2)]);
var inst_39225 = f__$1.call(null,inst_39224);
var state_39227__$1 = state_39227;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39227__$1,inst_39225);
} else {
return null;
}
}
});})(c__30790__auto__,f__$1))
;
return ((function (switch__30769__auto__,c__30790__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__30770__auto__ = null;
var cljs$core$async$transduce_$_state_machine__30770__auto____0 = (function (){
var statearr_39229 = [null,null,null,null,null,null,null];
(statearr_39229[(0)] = cljs$core$async$transduce_$_state_machine__30770__auto__);

(statearr_39229[(1)] = (1));

return statearr_39229;
});
var cljs$core$async$transduce_$_state_machine__30770__auto____1 = (function (state_39227){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_39227);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e39230){if((e39230 instanceof Object)){
var ex__30773__auto__ = e39230;
var statearr_39231_39233 = state_39227;
(statearr_39231_39233[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39227);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39230;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39234 = state_39227;
state_39227 = G__39234;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__30770__auto__ = function(state_39227){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__30770__auto____1.call(this,state_39227);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__30770__auto____0;
cljs$core$async$transduce_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__30770__auto____1;
return cljs$core$async$transduce_$_state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto__,f__$1))
})();
var state__30792__auto__ = (function (){var statearr_39232 = f__30791__auto__.call(null);
(statearr_39232[(6)] = c__30790__auto__);

return statearr_39232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto__,f__$1))
);

return c__30790__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__39236 = arguments.length;
switch (G__39236) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__30790__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto__){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto__){
return (function (state_39261){
var state_val_39262 = (state_39261[(1)]);
if((state_val_39262 === (7))){
var inst_39243 = (state_39261[(2)]);
var state_39261__$1 = state_39261;
var statearr_39263_39284 = state_39261__$1;
(statearr_39263_39284[(2)] = inst_39243);

(statearr_39263_39284[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39262 === (1))){
var inst_39237 = cljs.core.seq.call(null,coll);
var inst_39238 = inst_39237;
var state_39261__$1 = (function (){var statearr_39264 = state_39261;
(statearr_39264[(7)] = inst_39238);

return statearr_39264;
})();
var statearr_39265_39285 = state_39261__$1;
(statearr_39265_39285[(2)] = null);

(statearr_39265_39285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39262 === (4))){
var inst_39238 = (state_39261[(7)]);
var inst_39241 = cljs.core.first.call(null,inst_39238);
var state_39261__$1 = state_39261;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39261__$1,(7),ch,inst_39241);
} else {
if((state_val_39262 === (13))){
var inst_39255 = (state_39261[(2)]);
var state_39261__$1 = state_39261;
var statearr_39266_39286 = state_39261__$1;
(statearr_39266_39286[(2)] = inst_39255);

(statearr_39266_39286[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39262 === (6))){
var inst_39246 = (state_39261[(2)]);
var state_39261__$1 = state_39261;
if(cljs.core.truth_(inst_39246)){
var statearr_39267_39287 = state_39261__$1;
(statearr_39267_39287[(1)] = (8));

} else {
var statearr_39268_39288 = state_39261__$1;
(statearr_39268_39288[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39262 === (3))){
var inst_39259 = (state_39261[(2)]);
var state_39261__$1 = state_39261;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39261__$1,inst_39259);
} else {
if((state_val_39262 === (12))){
var state_39261__$1 = state_39261;
var statearr_39269_39289 = state_39261__$1;
(statearr_39269_39289[(2)] = null);

(statearr_39269_39289[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39262 === (2))){
var inst_39238 = (state_39261[(7)]);
var state_39261__$1 = state_39261;
if(cljs.core.truth_(inst_39238)){
var statearr_39270_39290 = state_39261__$1;
(statearr_39270_39290[(1)] = (4));

} else {
var statearr_39271_39291 = state_39261__$1;
(statearr_39271_39291[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39262 === (11))){
var inst_39252 = cljs.core.async.close_BANG_.call(null,ch);
var state_39261__$1 = state_39261;
var statearr_39272_39292 = state_39261__$1;
(statearr_39272_39292[(2)] = inst_39252);

(statearr_39272_39292[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39262 === (9))){
var state_39261__$1 = state_39261;
if(cljs.core.truth_(close_QMARK_)){
var statearr_39273_39293 = state_39261__$1;
(statearr_39273_39293[(1)] = (11));

} else {
var statearr_39274_39294 = state_39261__$1;
(statearr_39274_39294[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39262 === (5))){
var inst_39238 = (state_39261[(7)]);
var state_39261__$1 = state_39261;
var statearr_39275_39295 = state_39261__$1;
(statearr_39275_39295[(2)] = inst_39238);

(statearr_39275_39295[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39262 === (10))){
var inst_39257 = (state_39261[(2)]);
var state_39261__$1 = state_39261;
var statearr_39276_39296 = state_39261__$1;
(statearr_39276_39296[(2)] = inst_39257);

(statearr_39276_39296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39262 === (8))){
var inst_39238 = (state_39261[(7)]);
var inst_39248 = cljs.core.next.call(null,inst_39238);
var inst_39238__$1 = inst_39248;
var state_39261__$1 = (function (){var statearr_39277 = state_39261;
(statearr_39277[(7)] = inst_39238__$1);

return statearr_39277;
})();
var statearr_39278_39297 = state_39261__$1;
(statearr_39278_39297[(2)] = null);

(statearr_39278_39297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto__))
;
return ((function (switch__30769__auto__,c__30790__auto__){
return (function() {
var cljs$core$async$state_machine__30770__auto__ = null;
var cljs$core$async$state_machine__30770__auto____0 = (function (){
var statearr_39279 = [null,null,null,null,null,null,null,null];
(statearr_39279[(0)] = cljs$core$async$state_machine__30770__auto__);

(statearr_39279[(1)] = (1));

return statearr_39279;
});
var cljs$core$async$state_machine__30770__auto____1 = (function (state_39261){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_39261);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e39280){if((e39280 instanceof Object)){
var ex__30773__auto__ = e39280;
var statearr_39281_39298 = state_39261;
(statearr_39281_39298[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39261);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39280;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39299 = state_39261;
state_39261 = G__39299;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$state_machine__30770__auto__ = function(state_39261){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30770__auto____1.call(this,state_39261);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30770__auto____0;
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30770__auto____1;
return cljs$core$async$state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto__))
})();
var state__30792__auto__ = (function (){var statearr_39282 = f__30791__auto__.call(null);
(statearr_39282[(6)] = c__30790__auto__);

return statearr_39282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto__))
);

return c__30790__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__29030__auto__ = (((_ == null))?null:_);
var m__29031__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,_);
} else {
var m__29031__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__29031__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,ch);
} else {
var m__29031__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m);
} else {
var m__29031__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async39300 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39300 = (function (ch,cs,meta39301){
this.ch = ch;
this.cs = cs;
this.meta39301 = meta39301;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async39300.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_39302,meta39301__$1){
var self__ = this;
var _39302__$1 = this;
return (new cljs.core.async.t_cljs$core$async39300(self__.ch,self__.cs,meta39301__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async39300.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_39302){
var self__ = this;
var _39302__$1 = this;
return self__.meta39301;
});})(cs))
;

cljs.core.async.t_cljs$core$async39300.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async39300.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async39300.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async39300.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async39300.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async39300.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async39300.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta39301","meta39301",1336088247,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async39300.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async39300.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39300";

cljs.core.async.t_cljs$core$async39300.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async39300");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async39300 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async39300(ch__$1,cs__$1,meta39301){
return (new cljs.core.async.t_cljs$core$async39300(ch__$1,cs__$1,meta39301));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async39300(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__30790__auto___39522 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto___39522,cs,m,dchan,dctr,done){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto___39522,cs,m,dchan,dctr,done){
return (function (state_39437){
var state_val_39438 = (state_39437[(1)]);
if((state_val_39438 === (7))){
var inst_39433 = (state_39437[(2)]);
var state_39437__$1 = state_39437;
var statearr_39439_39523 = state_39437__$1;
(statearr_39439_39523[(2)] = inst_39433);

(statearr_39439_39523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (20))){
var inst_39336 = (state_39437[(7)]);
var inst_39348 = cljs.core.first.call(null,inst_39336);
var inst_39349 = cljs.core.nth.call(null,inst_39348,(0),null);
var inst_39350 = cljs.core.nth.call(null,inst_39348,(1),null);
var state_39437__$1 = (function (){var statearr_39440 = state_39437;
(statearr_39440[(8)] = inst_39349);

return statearr_39440;
})();
if(cljs.core.truth_(inst_39350)){
var statearr_39441_39524 = state_39437__$1;
(statearr_39441_39524[(1)] = (22));

} else {
var statearr_39442_39525 = state_39437__$1;
(statearr_39442_39525[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (27))){
var inst_39305 = (state_39437[(9)]);
var inst_39385 = (state_39437[(10)]);
var inst_39378 = (state_39437[(11)]);
var inst_39380 = (state_39437[(12)]);
var inst_39385__$1 = cljs.core._nth.call(null,inst_39378,inst_39380);
var inst_39386 = cljs.core.async.put_BANG_.call(null,inst_39385__$1,inst_39305,done);
var state_39437__$1 = (function (){var statearr_39443 = state_39437;
(statearr_39443[(10)] = inst_39385__$1);

return statearr_39443;
})();
if(cljs.core.truth_(inst_39386)){
var statearr_39444_39526 = state_39437__$1;
(statearr_39444_39526[(1)] = (30));

} else {
var statearr_39445_39527 = state_39437__$1;
(statearr_39445_39527[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (1))){
var state_39437__$1 = state_39437;
var statearr_39446_39528 = state_39437__$1;
(statearr_39446_39528[(2)] = null);

(statearr_39446_39528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (24))){
var inst_39336 = (state_39437[(7)]);
var inst_39355 = (state_39437[(2)]);
var inst_39356 = cljs.core.next.call(null,inst_39336);
var inst_39314 = inst_39356;
var inst_39315 = null;
var inst_39316 = (0);
var inst_39317 = (0);
var state_39437__$1 = (function (){var statearr_39447 = state_39437;
(statearr_39447[(13)] = inst_39316);

(statearr_39447[(14)] = inst_39314);

(statearr_39447[(15)] = inst_39315);

(statearr_39447[(16)] = inst_39355);

(statearr_39447[(17)] = inst_39317);

return statearr_39447;
})();
var statearr_39448_39529 = state_39437__$1;
(statearr_39448_39529[(2)] = null);

(statearr_39448_39529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (39))){
var state_39437__$1 = state_39437;
var statearr_39452_39530 = state_39437__$1;
(statearr_39452_39530[(2)] = null);

(statearr_39452_39530[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (4))){
var inst_39305 = (state_39437[(9)]);
var inst_39305__$1 = (state_39437[(2)]);
var inst_39306 = (inst_39305__$1 == null);
var state_39437__$1 = (function (){var statearr_39453 = state_39437;
(statearr_39453[(9)] = inst_39305__$1);

return statearr_39453;
})();
if(cljs.core.truth_(inst_39306)){
var statearr_39454_39531 = state_39437__$1;
(statearr_39454_39531[(1)] = (5));

} else {
var statearr_39455_39532 = state_39437__$1;
(statearr_39455_39532[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (15))){
var inst_39316 = (state_39437[(13)]);
var inst_39314 = (state_39437[(14)]);
var inst_39315 = (state_39437[(15)]);
var inst_39317 = (state_39437[(17)]);
var inst_39332 = (state_39437[(2)]);
var inst_39333 = (inst_39317 + (1));
var tmp39449 = inst_39316;
var tmp39450 = inst_39314;
var tmp39451 = inst_39315;
var inst_39314__$1 = tmp39450;
var inst_39315__$1 = tmp39451;
var inst_39316__$1 = tmp39449;
var inst_39317__$1 = inst_39333;
var state_39437__$1 = (function (){var statearr_39456 = state_39437;
(statearr_39456[(13)] = inst_39316__$1);

(statearr_39456[(14)] = inst_39314__$1);

(statearr_39456[(18)] = inst_39332);

(statearr_39456[(15)] = inst_39315__$1);

(statearr_39456[(17)] = inst_39317__$1);

return statearr_39456;
})();
var statearr_39457_39533 = state_39437__$1;
(statearr_39457_39533[(2)] = null);

(statearr_39457_39533[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (21))){
var inst_39359 = (state_39437[(2)]);
var state_39437__$1 = state_39437;
var statearr_39461_39534 = state_39437__$1;
(statearr_39461_39534[(2)] = inst_39359);

(statearr_39461_39534[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (31))){
var inst_39385 = (state_39437[(10)]);
var inst_39389 = done.call(null,null);
var inst_39390 = cljs.core.async.untap_STAR_.call(null,m,inst_39385);
var state_39437__$1 = (function (){var statearr_39462 = state_39437;
(statearr_39462[(19)] = inst_39389);

return statearr_39462;
})();
var statearr_39463_39535 = state_39437__$1;
(statearr_39463_39535[(2)] = inst_39390);

(statearr_39463_39535[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (32))){
var inst_39378 = (state_39437[(11)]);
var inst_39377 = (state_39437[(20)]);
var inst_39379 = (state_39437[(21)]);
var inst_39380 = (state_39437[(12)]);
var inst_39392 = (state_39437[(2)]);
var inst_39393 = (inst_39380 + (1));
var tmp39458 = inst_39378;
var tmp39459 = inst_39377;
var tmp39460 = inst_39379;
var inst_39377__$1 = tmp39459;
var inst_39378__$1 = tmp39458;
var inst_39379__$1 = tmp39460;
var inst_39380__$1 = inst_39393;
var state_39437__$1 = (function (){var statearr_39464 = state_39437;
(statearr_39464[(22)] = inst_39392);

(statearr_39464[(11)] = inst_39378__$1);

(statearr_39464[(20)] = inst_39377__$1);

(statearr_39464[(21)] = inst_39379__$1);

(statearr_39464[(12)] = inst_39380__$1);

return statearr_39464;
})();
var statearr_39465_39536 = state_39437__$1;
(statearr_39465_39536[(2)] = null);

(statearr_39465_39536[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (40))){
var inst_39405 = (state_39437[(23)]);
var inst_39409 = done.call(null,null);
var inst_39410 = cljs.core.async.untap_STAR_.call(null,m,inst_39405);
var state_39437__$1 = (function (){var statearr_39466 = state_39437;
(statearr_39466[(24)] = inst_39409);

return statearr_39466;
})();
var statearr_39467_39537 = state_39437__$1;
(statearr_39467_39537[(2)] = inst_39410);

(statearr_39467_39537[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (33))){
var inst_39396 = (state_39437[(25)]);
var inst_39398 = cljs.core.chunked_seq_QMARK_.call(null,inst_39396);
var state_39437__$1 = state_39437;
if(inst_39398){
var statearr_39468_39538 = state_39437__$1;
(statearr_39468_39538[(1)] = (36));

} else {
var statearr_39469_39539 = state_39437__$1;
(statearr_39469_39539[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (13))){
var inst_39326 = (state_39437[(26)]);
var inst_39329 = cljs.core.async.close_BANG_.call(null,inst_39326);
var state_39437__$1 = state_39437;
var statearr_39470_39540 = state_39437__$1;
(statearr_39470_39540[(2)] = inst_39329);

(statearr_39470_39540[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (22))){
var inst_39349 = (state_39437[(8)]);
var inst_39352 = cljs.core.async.close_BANG_.call(null,inst_39349);
var state_39437__$1 = state_39437;
var statearr_39471_39541 = state_39437__$1;
(statearr_39471_39541[(2)] = inst_39352);

(statearr_39471_39541[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (36))){
var inst_39396 = (state_39437[(25)]);
var inst_39400 = cljs.core.chunk_first.call(null,inst_39396);
var inst_39401 = cljs.core.chunk_rest.call(null,inst_39396);
var inst_39402 = cljs.core.count.call(null,inst_39400);
var inst_39377 = inst_39401;
var inst_39378 = inst_39400;
var inst_39379 = inst_39402;
var inst_39380 = (0);
var state_39437__$1 = (function (){var statearr_39472 = state_39437;
(statearr_39472[(11)] = inst_39378);

(statearr_39472[(20)] = inst_39377);

(statearr_39472[(21)] = inst_39379);

(statearr_39472[(12)] = inst_39380);

return statearr_39472;
})();
var statearr_39473_39542 = state_39437__$1;
(statearr_39473_39542[(2)] = null);

(statearr_39473_39542[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (41))){
var inst_39396 = (state_39437[(25)]);
var inst_39412 = (state_39437[(2)]);
var inst_39413 = cljs.core.next.call(null,inst_39396);
var inst_39377 = inst_39413;
var inst_39378 = null;
var inst_39379 = (0);
var inst_39380 = (0);
var state_39437__$1 = (function (){var statearr_39474 = state_39437;
(statearr_39474[(11)] = inst_39378);

(statearr_39474[(20)] = inst_39377);

(statearr_39474[(21)] = inst_39379);

(statearr_39474[(12)] = inst_39380);

(statearr_39474[(27)] = inst_39412);

return statearr_39474;
})();
var statearr_39475_39543 = state_39437__$1;
(statearr_39475_39543[(2)] = null);

(statearr_39475_39543[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (43))){
var state_39437__$1 = state_39437;
var statearr_39476_39544 = state_39437__$1;
(statearr_39476_39544[(2)] = null);

(statearr_39476_39544[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (29))){
var inst_39421 = (state_39437[(2)]);
var state_39437__$1 = state_39437;
var statearr_39477_39545 = state_39437__$1;
(statearr_39477_39545[(2)] = inst_39421);

(statearr_39477_39545[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (44))){
var inst_39430 = (state_39437[(2)]);
var state_39437__$1 = (function (){var statearr_39478 = state_39437;
(statearr_39478[(28)] = inst_39430);

return statearr_39478;
})();
var statearr_39479_39546 = state_39437__$1;
(statearr_39479_39546[(2)] = null);

(statearr_39479_39546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (6))){
var inst_39369 = (state_39437[(29)]);
var inst_39368 = cljs.core.deref.call(null,cs);
var inst_39369__$1 = cljs.core.keys.call(null,inst_39368);
var inst_39370 = cljs.core.count.call(null,inst_39369__$1);
var inst_39371 = cljs.core.reset_BANG_.call(null,dctr,inst_39370);
var inst_39376 = cljs.core.seq.call(null,inst_39369__$1);
var inst_39377 = inst_39376;
var inst_39378 = null;
var inst_39379 = (0);
var inst_39380 = (0);
var state_39437__$1 = (function (){var statearr_39480 = state_39437;
(statearr_39480[(29)] = inst_39369__$1);

(statearr_39480[(30)] = inst_39371);

(statearr_39480[(11)] = inst_39378);

(statearr_39480[(20)] = inst_39377);

(statearr_39480[(21)] = inst_39379);

(statearr_39480[(12)] = inst_39380);

return statearr_39480;
})();
var statearr_39481_39547 = state_39437__$1;
(statearr_39481_39547[(2)] = null);

(statearr_39481_39547[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (28))){
var inst_39396 = (state_39437[(25)]);
var inst_39377 = (state_39437[(20)]);
var inst_39396__$1 = cljs.core.seq.call(null,inst_39377);
var state_39437__$1 = (function (){var statearr_39482 = state_39437;
(statearr_39482[(25)] = inst_39396__$1);

return statearr_39482;
})();
if(inst_39396__$1){
var statearr_39483_39548 = state_39437__$1;
(statearr_39483_39548[(1)] = (33));

} else {
var statearr_39484_39549 = state_39437__$1;
(statearr_39484_39549[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (25))){
var inst_39379 = (state_39437[(21)]);
var inst_39380 = (state_39437[(12)]);
var inst_39382 = (inst_39380 < inst_39379);
var inst_39383 = inst_39382;
var state_39437__$1 = state_39437;
if(cljs.core.truth_(inst_39383)){
var statearr_39485_39550 = state_39437__$1;
(statearr_39485_39550[(1)] = (27));

} else {
var statearr_39486_39551 = state_39437__$1;
(statearr_39486_39551[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (34))){
var state_39437__$1 = state_39437;
var statearr_39487_39552 = state_39437__$1;
(statearr_39487_39552[(2)] = null);

(statearr_39487_39552[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (17))){
var state_39437__$1 = state_39437;
var statearr_39488_39553 = state_39437__$1;
(statearr_39488_39553[(2)] = null);

(statearr_39488_39553[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (3))){
var inst_39435 = (state_39437[(2)]);
var state_39437__$1 = state_39437;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39437__$1,inst_39435);
} else {
if((state_val_39438 === (12))){
var inst_39364 = (state_39437[(2)]);
var state_39437__$1 = state_39437;
var statearr_39489_39554 = state_39437__$1;
(statearr_39489_39554[(2)] = inst_39364);

(statearr_39489_39554[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (2))){
var state_39437__$1 = state_39437;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39437__$1,(4),ch);
} else {
if((state_val_39438 === (23))){
var state_39437__$1 = state_39437;
var statearr_39490_39555 = state_39437__$1;
(statearr_39490_39555[(2)] = null);

(statearr_39490_39555[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (35))){
var inst_39419 = (state_39437[(2)]);
var state_39437__$1 = state_39437;
var statearr_39491_39556 = state_39437__$1;
(statearr_39491_39556[(2)] = inst_39419);

(statearr_39491_39556[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (19))){
var inst_39336 = (state_39437[(7)]);
var inst_39340 = cljs.core.chunk_first.call(null,inst_39336);
var inst_39341 = cljs.core.chunk_rest.call(null,inst_39336);
var inst_39342 = cljs.core.count.call(null,inst_39340);
var inst_39314 = inst_39341;
var inst_39315 = inst_39340;
var inst_39316 = inst_39342;
var inst_39317 = (0);
var state_39437__$1 = (function (){var statearr_39492 = state_39437;
(statearr_39492[(13)] = inst_39316);

(statearr_39492[(14)] = inst_39314);

(statearr_39492[(15)] = inst_39315);

(statearr_39492[(17)] = inst_39317);

return statearr_39492;
})();
var statearr_39493_39557 = state_39437__$1;
(statearr_39493_39557[(2)] = null);

(statearr_39493_39557[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (11))){
var inst_39314 = (state_39437[(14)]);
var inst_39336 = (state_39437[(7)]);
var inst_39336__$1 = cljs.core.seq.call(null,inst_39314);
var state_39437__$1 = (function (){var statearr_39494 = state_39437;
(statearr_39494[(7)] = inst_39336__$1);

return statearr_39494;
})();
if(inst_39336__$1){
var statearr_39495_39558 = state_39437__$1;
(statearr_39495_39558[(1)] = (16));

} else {
var statearr_39496_39559 = state_39437__$1;
(statearr_39496_39559[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (9))){
var inst_39366 = (state_39437[(2)]);
var state_39437__$1 = state_39437;
var statearr_39497_39560 = state_39437__$1;
(statearr_39497_39560[(2)] = inst_39366);

(statearr_39497_39560[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (5))){
var inst_39312 = cljs.core.deref.call(null,cs);
var inst_39313 = cljs.core.seq.call(null,inst_39312);
var inst_39314 = inst_39313;
var inst_39315 = null;
var inst_39316 = (0);
var inst_39317 = (0);
var state_39437__$1 = (function (){var statearr_39498 = state_39437;
(statearr_39498[(13)] = inst_39316);

(statearr_39498[(14)] = inst_39314);

(statearr_39498[(15)] = inst_39315);

(statearr_39498[(17)] = inst_39317);

return statearr_39498;
})();
var statearr_39499_39561 = state_39437__$1;
(statearr_39499_39561[(2)] = null);

(statearr_39499_39561[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (14))){
var state_39437__$1 = state_39437;
var statearr_39500_39562 = state_39437__$1;
(statearr_39500_39562[(2)] = null);

(statearr_39500_39562[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (45))){
var inst_39427 = (state_39437[(2)]);
var state_39437__$1 = state_39437;
var statearr_39501_39563 = state_39437__$1;
(statearr_39501_39563[(2)] = inst_39427);

(statearr_39501_39563[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (26))){
var inst_39369 = (state_39437[(29)]);
var inst_39423 = (state_39437[(2)]);
var inst_39424 = cljs.core.seq.call(null,inst_39369);
var state_39437__$1 = (function (){var statearr_39502 = state_39437;
(statearr_39502[(31)] = inst_39423);

return statearr_39502;
})();
if(inst_39424){
var statearr_39503_39564 = state_39437__$1;
(statearr_39503_39564[(1)] = (42));

} else {
var statearr_39504_39565 = state_39437__$1;
(statearr_39504_39565[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (16))){
var inst_39336 = (state_39437[(7)]);
var inst_39338 = cljs.core.chunked_seq_QMARK_.call(null,inst_39336);
var state_39437__$1 = state_39437;
if(inst_39338){
var statearr_39505_39566 = state_39437__$1;
(statearr_39505_39566[(1)] = (19));

} else {
var statearr_39506_39567 = state_39437__$1;
(statearr_39506_39567[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (38))){
var inst_39416 = (state_39437[(2)]);
var state_39437__$1 = state_39437;
var statearr_39507_39568 = state_39437__$1;
(statearr_39507_39568[(2)] = inst_39416);

(statearr_39507_39568[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (30))){
var state_39437__$1 = state_39437;
var statearr_39508_39569 = state_39437__$1;
(statearr_39508_39569[(2)] = null);

(statearr_39508_39569[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (10))){
var inst_39315 = (state_39437[(15)]);
var inst_39317 = (state_39437[(17)]);
var inst_39325 = cljs.core._nth.call(null,inst_39315,inst_39317);
var inst_39326 = cljs.core.nth.call(null,inst_39325,(0),null);
var inst_39327 = cljs.core.nth.call(null,inst_39325,(1),null);
var state_39437__$1 = (function (){var statearr_39509 = state_39437;
(statearr_39509[(26)] = inst_39326);

return statearr_39509;
})();
if(cljs.core.truth_(inst_39327)){
var statearr_39510_39570 = state_39437__$1;
(statearr_39510_39570[(1)] = (13));

} else {
var statearr_39511_39571 = state_39437__$1;
(statearr_39511_39571[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (18))){
var inst_39362 = (state_39437[(2)]);
var state_39437__$1 = state_39437;
var statearr_39512_39572 = state_39437__$1;
(statearr_39512_39572[(2)] = inst_39362);

(statearr_39512_39572[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (42))){
var state_39437__$1 = state_39437;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39437__$1,(45),dchan);
} else {
if((state_val_39438 === (37))){
var inst_39305 = (state_39437[(9)]);
var inst_39396 = (state_39437[(25)]);
var inst_39405 = (state_39437[(23)]);
var inst_39405__$1 = cljs.core.first.call(null,inst_39396);
var inst_39406 = cljs.core.async.put_BANG_.call(null,inst_39405__$1,inst_39305,done);
var state_39437__$1 = (function (){var statearr_39513 = state_39437;
(statearr_39513[(23)] = inst_39405__$1);

return statearr_39513;
})();
if(cljs.core.truth_(inst_39406)){
var statearr_39514_39573 = state_39437__$1;
(statearr_39514_39573[(1)] = (39));

} else {
var statearr_39515_39574 = state_39437__$1;
(statearr_39515_39574[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39438 === (8))){
var inst_39316 = (state_39437[(13)]);
var inst_39317 = (state_39437[(17)]);
var inst_39319 = (inst_39317 < inst_39316);
var inst_39320 = inst_39319;
var state_39437__$1 = state_39437;
if(cljs.core.truth_(inst_39320)){
var statearr_39516_39575 = state_39437__$1;
(statearr_39516_39575[(1)] = (10));

} else {
var statearr_39517_39576 = state_39437__$1;
(statearr_39517_39576[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto___39522,cs,m,dchan,dctr,done))
;
return ((function (switch__30769__auto__,c__30790__auto___39522,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__30770__auto__ = null;
var cljs$core$async$mult_$_state_machine__30770__auto____0 = (function (){
var statearr_39518 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39518[(0)] = cljs$core$async$mult_$_state_machine__30770__auto__);

(statearr_39518[(1)] = (1));

return statearr_39518;
});
var cljs$core$async$mult_$_state_machine__30770__auto____1 = (function (state_39437){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_39437);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e39519){if((e39519 instanceof Object)){
var ex__30773__auto__ = e39519;
var statearr_39520_39577 = state_39437;
(statearr_39520_39577[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39437);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39519;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39578 = state_39437;
state_39437 = G__39578;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__30770__auto__ = function(state_39437){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__30770__auto____1.call(this,state_39437);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__30770__auto____0;
cljs$core$async$mult_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__30770__auto____1;
return cljs$core$async$mult_$_state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto___39522,cs,m,dchan,dctr,done))
})();
var state__30792__auto__ = (function (){var statearr_39521 = f__30791__auto__.call(null);
(statearr_39521[(6)] = c__30790__auto___39522);

return statearr_39521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto___39522,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__39580 = arguments.length;
switch (G__39580) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,ch);
} else {
var m__29031__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,ch);
} else {
var m__29031__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m);
} else {
var m__29031__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,state_map);
} else {
var m__29031__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,mode);
} else {
var m__29031__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__29523__auto__ = [];
var len__29516__auto___39592 = arguments.length;
var i__29517__auto___39593 = (0);
while(true){
if((i__29517__auto___39593 < len__29516__auto___39592)){
args__29523__auto__.push((arguments[i__29517__auto___39593]));

var G__39594 = (i__29517__auto___39593 + (1));
i__29517__auto___39593 = G__39594;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((3) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29524__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__39586){
var map__39587 = p__39586;
var map__39587__$1 = ((((!((map__39587 == null)))?((((map__39587.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39587.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__39587):map__39587);
var opts = map__39587__$1;
var statearr_39589_39595 = state;
(statearr_39589_39595[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__39587,map__39587__$1,opts){
return (function (val){
var statearr_39590_39596 = state;
(statearr_39590_39596[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__39587,map__39587__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_39591_39597 = state;
(statearr_39591_39597[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq39582){
var G__39583 = cljs.core.first.call(null,seq39582);
var seq39582__$1 = cljs.core.next.call(null,seq39582);
var G__39584 = cljs.core.first.call(null,seq39582__$1);
var seq39582__$2 = cljs.core.next.call(null,seq39582__$1);
var G__39585 = cljs.core.first.call(null,seq39582__$2);
var seq39582__$3 = cljs.core.next.call(null,seq39582__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__39583,G__39584,G__39585,seq39582__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async39598 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39598 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta39599){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta39599 = meta39599;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async39598.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_39600,meta39599__$1){
var self__ = this;
var _39600__$1 = this;
return (new cljs.core.async.t_cljs$core$async39598(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta39599__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39598.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_39600){
var self__ = this;
var _39600__$1 = this;
return self__.meta39599;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39598.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async39598.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39598.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async39598.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39598.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39598.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39598.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39598.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39598.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta39599","meta39599",949585599,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39598.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async39598.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39598";

cljs.core.async.t_cljs$core$async39598.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async39598");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async39598 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async39598(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta39599){
return (new cljs.core.async.t_cljs$core$async39598(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta39599));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async39598(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30790__auto___39762 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto___39762,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto___39762,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_39702){
var state_val_39703 = (state_39702[(1)]);
if((state_val_39703 === (7))){
var inst_39617 = (state_39702[(2)]);
var state_39702__$1 = state_39702;
var statearr_39704_39763 = state_39702__$1;
(statearr_39704_39763[(2)] = inst_39617);

(statearr_39704_39763[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (20))){
var inst_39629 = (state_39702[(7)]);
var state_39702__$1 = state_39702;
var statearr_39705_39764 = state_39702__$1;
(statearr_39705_39764[(2)] = inst_39629);

(statearr_39705_39764[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (27))){
var state_39702__$1 = state_39702;
var statearr_39706_39765 = state_39702__$1;
(statearr_39706_39765[(2)] = null);

(statearr_39706_39765[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (1))){
var inst_39604 = (state_39702[(8)]);
var inst_39604__$1 = calc_state.call(null);
var inst_39606 = (inst_39604__$1 == null);
var inst_39607 = cljs.core.not.call(null,inst_39606);
var state_39702__$1 = (function (){var statearr_39707 = state_39702;
(statearr_39707[(8)] = inst_39604__$1);

return statearr_39707;
})();
if(inst_39607){
var statearr_39708_39766 = state_39702__$1;
(statearr_39708_39766[(1)] = (2));

} else {
var statearr_39709_39767 = state_39702__$1;
(statearr_39709_39767[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (24))){
var inst_39662 = (state_39702[(9)]);
var inst_39653 = (state_39702[(10)]);
var inst_39676 = (state_39702[(11)]);
var inst_39676__$1 = inst_39653.call(null,inst_39662);
var state_39702__$1 = (function (){var statearr_39710 = state_39702;
(statearr_39710[(11)] = inst_39676__$1);

return statearr_39710;
})();
if(cljs.core.truth_(inst_39676__$1)){
var statearr_39711_39768 = state_39702__$1;
(statearr_39711_39768[(1)] = (29));

} else {
var statearr_39712_39769 = state_39702__$1;
(statearr_39712_39769[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (4))){
var inst_39620 = (state_39702[(2)]);
var state_39702__$1 = state_39702;
if(cljs.core.truth_(inst_39620)){
var statearr_39713_39770 = state_39702__$1;
(statearr_39713_39770[(1)] = (8));

} else {
var statearr_39714_39771 = state_39702__$1;
(statearr_39714_39771[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (15))){
var inst_39647 = (state_39702[(2)]);
var state_39702__$1 = state_39702;
if(cljs.core.truth_(inst_39647)){
var statearr_39715_39772 = state_39702__$1;
(statearr_39715_39772[(1)] = (19));

} else {
var statearr_39716_39773 = state_39702__$1;
(statearr_39716_39773[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (21))){
var inst_39652 = (state_39702[(12)]);
var inst_39652__$1 = (state_39702[(2)]);
var inst_39653 = cljs.core.get.call(null,inst_39652__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_39654 = cljs.core.get.call(null,inst_39652__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_39655 = cljs.core.get.call(null,inst_39652__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_39702__$1 = (function (){var statearr_39717 = state_39702;
(statearr_39717[(10)] = inst_39653);

(statearr_39717[(13)] = inst_39654);

(statearr_39717[(12)] = inst_39652__$1);

return statearr_39717;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_39702__$1,(22),inst_39655);
} else {
if((state_val_39703 === (31))){
var inst_39684 = (state_39702[(2)]);
var state_39702__$1 = state_39702;
if(cljs.core.truth_(inst_39684)){
var statearr_39718_39774 = state_39702__$1;
(statearr_39718_39774[(1)] = (32));

} else {
var statearr_39719_39775 = state_39702__$1;
(statearr_39719_39775[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (32))){
var inst_39661 = (state_39702[(14)]);
var state_39702__$1 = state_39702;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39702__$1,(35),out,inst_39661);
} else {
if((state_val_39703 === (33))){
var inst_39652 = (state_39702[(12)]);
var inst_39629 = inst_39652;
var state_39702__$1 = (function (){var statearr_39720 = state_39702;
(statearr_39720[(7)] = inst_39629);

return statearr_39720;
})();
var statearr_39721_39776 = state_39702__$1;
(statearr_39721_39776[(2)] = null);

(statearr_39721_39776[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (13))){
var inst_39629 = (state_39702[(7)]);
var inst_39636 = inst_39629.cljs$lang$protocol_mask$partition0$;
var inst_39637 = (inst_39636 & (64));
var inst_39638 = inst_39629.cljs$core$ISeq$;
var inst_39639 = (cljs.core.PROTOCOL_SENTINEL === inst_39638);
var inst_39640 = (inst_39637) || (inst_39639);
var state_39702__$1 = state_39702;
if(cljs.core.truth_(inst_39640)){
var statearr_39722_39777 = state_39702__$1;
(statearr_39722_39777[(1)] = (16));

} else {
var statearr_39723_39778 = state_39702__$1;
(statearr_39723_39778[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (22))){
var inst_39662 = (state_39702[(9)]);
var inst_39661 = (state_39702[(14)]);
var inst_39660 = (state_39702[(2)]);
var inst_39661__$1 = cljs.core.nth.call(null,inst_39660,(0),null);
var inst_39662__$1 = cljs.core.nth.call(null,inst_39660,(1),null);
var inst_39663 = (inst_39661__$1 == null);
var inst_39664 = cljs.core._EQ_.call(null,inst_39662__$1,change);
var inst_39665 = (inst_39663) || (inst_39664);
var state_39702__$1 = (function (){var statearr_39724 = state_39702;
(statearr_39724[(9)] = inst_39662__$1);

(statearr_39724[(14)] = inst_39661__$1);

return statearr_39724;
})();
if(cljs.core.truth_(inst_39665)){
var statearr_39725_39779 = state_39702__$1;
(statearr_39725_39779[(1)] = (23));

} else {
var statearr_39726_39780 = state_39702__$1;
(statearr_39726_39780[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (36))){
var inst_39652 = (state_39702[(12)]);
var inst_39629 = inst_39652;
var state_39702__$1 = (function (){var statearr_39727 = state_39702;
(statearr_39727[(7)] = inst_39629);

return statearr_39727;
})();
var statearr_39728_39781 = state_39702__$1;
(statearr_39728_39781[(2)] = null);

(statearr_39728_39781[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (29))){
var inst_39676 = (state_39702[(11)]);
var state_39702__$1 = state_39702;
var statearr_39729_39782 = state_39702__$1;
(statearr_39729_39782[(2)] = inst_39676);

(statearr_39729_39782[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (6))){
var state_39702__$1 = state_39702;
var statearr_39730_39783 = state_39702__$1;
(statearr_39730_39783[(2)] = false);

(statearr_39730_39783[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (28))){
var inst_39672 = (state_39702[(2)]);
var inst_39673 = calc_state.call(null);
var inst_39629 = inst_39673;
var state_39702__$1 = (function (){var statearr_39731 = state_39702;
(statearr_39731[(7)] = inst_39629);

(statearr_39731[(15)] = inst_39672);

return statearr_39731;
})();
var statearr_39732_39784 = state_39702__$1;
(statearr_39732_39784[(2)] = null);

(statearr_39732_39784[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (25))){
var inst_39698 = (state_39702[(2)]);
var state_39702__$1 = state_39702;
var statearr_39733_39785 = state_39702__$1;
(statearr_39733_39785[(2)] = inst_39698);

(statearr_39733_39785[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (34))){
var inst_39696 = (state_39702[(2)]);
var state_39702__$1 = state_39702;
var statearr_39734_39786 = state_39702__$1;
(statearr_39734_39786[(2)] = inst_39696);

(statearr_39734_39786[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (17))){
var state_39702__$1 = state_39702;
var statearr_39735_39787 = state_39702__$1;
(statearr_39735_39787[(2)] = false);

(statearr_39735_39787[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (3))){
var state_39702__$1 = state_39702;
var statearr_39736_39788 = state_39702__$1;
(statearr_39736_39788[(2)] = false);

(statearr_39736_39788[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (12))){
var inst_39700 = (state_39702[(2)]);
var state_39702__$1 = state_39702;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39702__$1,inst_39700);
} else {
if((state_val_39703 === (2))){
var inst_39604 = (state_39702[(8)]);
var inst_39609 = inst_39604.cljs$lang$protocol_mask$partition0$;
var inst_39610 = (inst_39609 & (64));
var inst_39611 = inst_39604.cljs$core$ISeq$;
var inst_39612 = (cljs.core.PROTOCOL_SENTINEL === inst_39611);
var inst_39613 = (inst_39610) || (inst_39612);
var state_39702__$1 = state_39702;
if(cljs.core.truth_(inst_39613)){
var statearr_39737_39789 = state_39702__$1;
(statearr_39737_39789[(1)] = (5));

} else {
var statearr_39738_39790 = state_39702__$1;
(statearr_39738_39790[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (23))){
var inst_39661 = (state_39702[(14)]);
var inst_39667 = (inst_39661 == null);
var state_39702__$1 = state_39702;
if(cljs.core.truth_(inst_39667)){
var statearr_39739_39791 = state_39702__$1;
(statearr_39739_39791[(1)] = (26));

} else {
var statearr_39740_39792 = state_39702__$1;
(statearr_39740_39792[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (35))){
var inst_39687 = (state_39702[(2)]);
var state_39702__$1 = state_39702;
if(cljs.core.truth_(inst_39687)){
var statearr_39741_39793 = state_39702__$1;
(statearr_39741_39793[(1)] = (36));

} else {
var statearr_39742_39794 = state_39702__$1;
(statearr_39742_39794[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (19))){
var inst_39629 = (state_39702[(7)]);
var inst_39649 = cljs.core.apply.call(null,cljs.core.hash_map,inst_39629);
var state_39702__$1 = state_39702;
var statearr_39743_39795 = state_39702__$1;
(statearr_39743_39795[(2)] = inst_39649);

(statearr_39743_39795[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (11))){
var inst_39629 = (state_39702[(7)]);
var inst_39633 = (inst_39629 == null);
var inst_39634 = cljs.core.not.call(null,inst_39633);
var state_39702__$1 = state_39702;
if(inst_39634){
var statearr_39744_39796 = state_39702__$1;
(statearr_39744_39796[(1)] = (13));

} else {
var statearr_39745_39797 = state_39702__$1;
(statearr_39745_39797[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (9))){
var inst_39604 = (state_39702[(8)]);
var state_39702__$1 = state_39702;
var statearr_39746_39798 = state_39702__$1;
(statearr_39746_39798[(2)] = inst_39604);

(statearr_39746_39798[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (5))){
var state_39702__$1 = state_39702;
var statearr_39747_39799 = state_39702__$1;
(statearr_39747_39799[(2)] = true);

(statearr_39747_39799[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (14))){
var state_39702__$1 = state_39702;
var statearr_39748_39800 = state_39702__$1;
(statearr_39748_39800[(2)] = false);

(statearr_39748_39800[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (26))){
var inst_39662 = (state_39702[(9)]);
var inst_39669 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_39662);
var state_39702__$1 = state_39702;
var statearr_39749_39801 = state_39702__$1;
(statearr_39749_39801[(2)] = inst_39669);

(statearr_39749_39801[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (16))){
var state_39702__$1 = state_39702;
var statearr_39750_39802 = state_39702__$1;
(statearr_39750_39802[(2)] = true);

(statearr_39750_39802[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (38))){
var inst_39692 = (state_39702[(2)]);
var state_39702__$1 = state_39702;
var statearr_39751_39803 = state_39702__$1;
(statearr_39751_39803[(2)] = inst_39692);

(statearr_39751_39803[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (30))){
var inst_39662 = (state_39702[(9)]);
var inst_39653 = (state_39702[(10)]);
var inst_39654 = (state_39702[(13)]);
var inst_39679 = cljs.core.empty_QMARK_.call(null,inst_39653);
var inst_39680 = inst_39654.call(null,inst_39662);
var inst_39681 = cljs.core.not.call(null,inst_39680);
var inst_39682 = (inst_39679) && (inst_39681);
var state_39702__$1 = state_39702;
var statearr_39752_39804 = state_39702__$1;
(statearr_39752_39804[(2)] = inst_39682);

(statearr_39752_39804[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (10))){
var inst_39604 = (state_39702[(8)]);
var inst_39625 = (state_39702[(2)]);
var inst_39626 = cljs.core.get.call(null,inst_39625,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_39627 = cljs.core.get.call(null,inst_39625,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_39628 = cljs.core.get.call(null,inst_39625,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_39629 = inst_39604;
var state_39702__$1 = (function (){var statearr_39753 = state_39702;
(statearr_39753[(16)] = inst_39627);

(statearr_39753[(17)] = inst_39628);

(statearr_39753[(7)] = inst_39629);

(statearr_39753[(18)] = inst_39626);

return statearr_39753;
})();
var statearr_39754_39805 = state_39702__$1;
(statearr_39754_39805[(2)] = null);

(statearr_39754_39805[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (18))){
var inst_39644 = (state_39702[(2)]);
var state_39702__$1 = state_39702;
var statearr_39755_39806 = state_39702__$1;
(statearr_39755_39806[(2)] = inst_39644);

(statearr_39755_39806[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (37))){
var state_39702__$1 = state_39702;
var statearr_39756_39807 = state_39702__$1;
(statearr_39756_39807[(2)] = null);

(statearr_39756_39807[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39703 === (8))){
var inst_39604 = (state_39702[(8)]);
var inst_39622 = cljs.core.apply.call(null,cljs.core.hash_map,inst_39604);
var state_39702__$1 = state_39702;
var statearr_39757_39808 = state_39702__$1;
(statearr_39757_39808[(2)] = inst_39622);

(statearr_39757_39808[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto___39762,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__30769__auto__,c__30790__auto___39762,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__30770__auto__ = null;
var cljs$core$async$mix_$_state_machine__30770__auto____0 = (function (){
var statearr_39758 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39758[(0)] = cljs$core$async$mix_$_state_machine__30770__auto__);

(statearr_39758[(1)] = (1));

return statearr_39758;
});
var cljs$core$async$mix_$_state_machine__30770__auto____1 = (function (state_39702){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_39702);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e39759){if((e39759 instanceof Object)){
var ex__30773__auto__ = e39759;
var statearr_39760_39809 = state_39702;
(statearr_39760_39809[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39702);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39759;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39810 = state_39702;
state_39702 = G__39810;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__30770__auto__ = function(state_39702){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__30770__auto____1.call(this,state_39702);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__30770__auto____0;
cljs$core$async$mix_$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__30770__auto____1;
return cljs$core$async$mix_$_state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto___39762,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__30792__auto__ = (function (){var statearr_39761 = f__30791__auto__.call(null);
(statearr_39761[(6)] = c__30790__auto___39762);

return statearr_39761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto___39762,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__29030__auto__ = (((p == null))?null:p);
var m__29031__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__29031__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__29030__auto__ = (((p == null))?null:p);
var m__29031__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,p,v,ch);
} else {
var m__29031__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__39812 = arguments.length;
switch (G__39812) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__29030__auto__ = (((p == null))?null:p);
var m__29031__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,p);
} else {
var m__29031__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__29030__auto__ = (((p == null))?null:p);
var m__29031__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,p,v);
} else {
var m__29031__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__39816 = arguments.length;
switch (G__39816) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__28347__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__28347__auto__,mults){
return (function (p1__39814_SHARP_){
if(cljs.core.truth_(p1__39814_SHARP_.call(null,topic))){
return p1__39814_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__39814_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__28347__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async39817 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39817 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta39818){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta39818 = meta39818;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async39817.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_39819,meta39818__$1){
var self__ = this;
var _39819__$1 = this;
return (new cljs.core.async.t_cljs$core$async39817(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta39818__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39817.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_39819){
var self__ = this;
var _39819__$1 = this;
return self__.meta39818;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39817.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async39817.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39817.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async39817.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39817.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39817.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39817.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39817.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta39818","meta39818",-580402925,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39817.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async39817.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39817";

cljs.core.async.t_cljs$core$async39817.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async39817");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async39817 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async39817(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta39818){
return (new cljs.core.async.t_cljs$core$async39817(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta39818));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async39817(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__30790__auto___39937 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto___39937,mults,ensure_mult,p){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto___39937,mults,ensure_mult,p){
return (function (state_39891){
var state_val_39892 = (state_39891[(1)]);
if((state_val_39892 === (7))){
var inst_39887 = (state_39891[(2)]);
var state_39891__$1 = state_39891;
var statearr_39893_39938 = state_39891__$1;
(statearr_39893_39938[(2)] = inst_39887);

(statearr_39893_39938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (20))){
var state_39891__$1 = state_39891;
var statearr_39894_39939 = state_39891__$1;
(statearr_39894_39939[(2)] = null);

(statearr_39894_39939[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (1))){
var state_39891__$1 = state_39891;
var statearr_39895_39940 = state_39891__$1;
(statearr_39895_39940[(2)] = null);

(statearr_39895_39940[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (24))){
var inst_39870 = (state_39891[(7)]);
var inst_39879 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_39870);
var state_39891__$1 = state_39891;
var statearr_39896_39941 = state_39891__$1;
(statearr_39896_39941[(2)] = inst_39879);

(statearr_39896_39941[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (4))){
var inst_39822 = (state_39891[(8)]);
var inst_39822__$1 = (state_39891[(2)]);
var inst_39823 = (inst_39822__$1 == null);
var state_39891__$1 = (function (){var statearr_39897 = state_39891;
(statearr_39897[(8)] = inst_39822__$1);

return statearr_39897;
})();
if(cljs.core.truth_(inst_39823)){
var statearr_39898_39942 = state_39891__$1;
(statearr_39898_39942[(1)] = (5));

} else {
var statearr_39899_39943 = state_39891__$1;
(statearr_39899_39943[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (15))){
var inst_39864 = (state_39891[(2)]);
var state_39891__$1 = state_39891;
var statearr_39900_39944 = state_39891__$1;
(statearr_39900_39944[(2)] = inst_39864);

(statearr_39900_39944[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (21))){
var inst_39884 = (state_39891[(2)]);
var state_39891__$1 = (function (){var statearr_39901 = state_39891;
(statearr_39901[(9)] = inst_39884);

return statearr_39901;
})();
var statearr_39902_39945 = state_39891__$1;
(statearr_39902_39945[(2)] = null);

(statearr_39902_39945[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (13))){
var inst_39846 = (state_39891[(10)]);
var inst_39848 = cljs.core.chunked_seq_QMARK_.call(null,inst_39846);
var state_39891__$1 = state_39891;
if(inst_39848){
var statearr_39903_39946 = state_39891__$1;
(statearr_39903_39946[(1)] = (16));

} else {
var statearr_39904_39947 = state_39891__$1;
(statearr_39904_39947[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (22))){
var inst_39876 = (state_39891[(2)]);
var state_39891__$1 = state_39891;
if(cljs.core.truth_(inst_39876)){
var statearr_39905_39948 = state_39891__$1;
(statearr_39905_39948[(1)] = (23));

} else {
var statearr_39906_39949 = state_39891__$1;
(statearr_39906_39949[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (6))){
var inst_39822 = (state_39891[(8)]);
var inst_39872 = (state_39891[(11)]);
var inst_39870 = (state_39891[(7)]);
var inst_39870__$1 = topic_fn.call(null,inst_39822);
var inst_39871 = cljs.core.deref.call(null,mults);
var inst_39872__$1 = cljs.core.get.call(null,inst_39871,inst_39870__$1);
var state_39891__$1 = (function (){var statearr_39907 = state_39891;
(statearr_39907[(11)] = inst_39872__$1);

(statearr_39907[(7)] = inst_39870__$1);

return statearr_39907;
})();
if(cljs.core.truth_(inst_39872__$1)){
var statearr_39908_39950 = state_39891__$1;
(statearr_39908_39950[(1)] = (19));

} else {
var statearr_39909_39951 = state_39891__$1;
(statearr_39909_39951[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (25))){
var inst_39881 = (state_39891[(2)]);
var state_39891__$1 = state_39891;
var statearr_39910_39952 = state_39891__$1;
(statearr_39910_39952[(2)] = inst_39881);

(statearr_39910_39952[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (17))){
var inst_39846 = (state_39891[(10)]);
var inst_39855 = cljs.core.first.call(null,inst_39846);
var inst_39856 = cljs.core.async.muxch_STAR_.call(null,inst_39855);
var inst_39857 = cljs.core.async.close_BANG_.call(null,inst_39856);
var inst_39858 = cljs.core.next.call(null,inst_39846);
var inst_39832 = inst_39858;
var inst_39833 = null;
var inst_39834 = (0);
var inst_39835 = (0);
var state_39891__$1 = (function (){var statearr_39911 = state_39891;
(statearr_39911[(12)] = inst_39832);

(statearr_39911[(13)] = inst_39835);

(statearr_39911[(14)] = inst_39834);

(statearr_39911[(15)] = inst_39833);

(statearr_39911[(16)] = inst_39857);

return statearr_39911;
})();
var statearr_39912_39953 = state_39891__$1;
(statearr_39912_39953[(2)] = null);

(statearr_39912_39953[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (3))){
var inst_39889 = (state_39891[(2)]);
var state_39891__$1 = state_39891;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39891__$1,inst_39889);
} else {
if((state_val_39892 === (12))){
var inst_39866 = (state_39891[(2)]);
var state_39891__$1 = state_39891;
var statearr_39913_39954 = state_39891__$1;
(statearr_39913_39954[(2)] = inst_39866);

(statearr_39913_39954[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (2))){
var state_39891__$1 = state_39891;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39891__$1,(4),ch);
} else {
if((state_val_39892 === (23))){
var state_39891__$1 = state_39891;
var statearr_39914_39955 = state_39891__$1;
(statearr_39914_39955[(2)] = null);

(statearr_39914_39955[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (19))){
var inst_39822 = (state_39891[(8)]);
var inst_39872 = (state_39891[(11)]);
var inst_39874 = cljs.core.async.muxch_STAR_.call(null,inst_39872);
var state_39891__$1 = state_39891;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_39891__$1,(22),inst_39874,inst_39822);
} else {
if((state_val_39892 === (11))){
var inst_39846 = (state_39891[(10)]);
var inst_39832 = (state_39891[(12)]);
var inst_39846__$1 = cljs.core.seq.call(null,inst_39832);
var state_39891__$1 = (function (){var statearr_39915 = state_39891;
(statearr_39915[(10)] = inst_39846__$1);

return statearr_39915;
})();
if(inst_39846__$1){
var statearr_39916_39956 = state_39891__$1;
(statearr_39916_39956[(1)] = (13));

} else {
var statearr_39917_39957 = state_39891__$1;
(statearr_39917_39957[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (9))){
var inst_39868 = (state_39891[(2)]);
var state_39891__$1 = state_39891;
var statearr_39918_39958 = state_39891__$1;
(statearr_39918_39958[(2)] = inst_39868);

(statearr_39918_39958[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (5))){
var inst_39829 = cljs.core.deref.call(null,mults);
var inst_39830 = cljs.core.vals.call(null,inst_39829);
var inst_39831 = cljs.core.seq.call(null,inst_39830);
var inst_39832 = inst_39831;
var inst_39833 = null;
var inst_39834 = (0);
var inst_39835 = (0);
var state_39891__$1 = (function (){var statearr_39919 = state_39891;
(statearr_39919[(12)] = inst_39832);

(statearr_39919[(13)] = inst_39835);

(statearr_39919[(14)] = inst_39834);

(statearr_39919[(15)] = inst_39833);

return statearr_39919;
})();
var statearr_39920_39959 = state_39891__$1;
(statearr_39920_39959[(2)] = null);

(statearr_39920_39959[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (14))){
var state_39891__$1 = state_39891;
var statearr_39924_39960 = state_39891__$1;
(statearr_39924_39960[(2)] = null);

(statearr_39924_39960[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (16))){
var inst_39846 = (state_39891[(10)]);
var inst_39850 = cljs.core.chunk_first.call(null,inst_39846);
var inst_39851 = cljs.core.chunk_rest.call(null,inst_39846);
var inst_39852 = cljs.core.count.call(null,inst_39850);
var inst_39832 = inst_39851;
var inst_39833 = inst_39850;
var inst_39834 = inst_39852;
var inst_39835 = (0);
var state_39891__$1 = (function (){var statearr_39925 = state_39891;
(statearr_39925[(12)] = inst_39832);

(statearr_39925[(13)] = inst_39835);

(statearr_39925[(14)] = inst_39834);

(statearr_39925[(15)] = inst_39833);

return statearr_39925;
})();
var statearr_39926_39961 = state_39891__$1;
(statearr_39926_39961[(2)] = null);

(statearr_39926_39961[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (10))){
var inst_39832 = (state_39891[(12)]);
var inst_39835 = (state_39891[(13)]);
var inst_39834 = (state_39891[(14)]);
var inst_39833 = (state_39891[(15)]);
var inst_39840 = cljs.core._nth.call(null,inst_39833,inst_39835);
var inst_39841 = cljs.core.async.muxch_STAR_.call(null,inst_39840);
var inst_39842 = cljs.core.async.close_BANG_.call(null,inst_39841);
var inst_39843 = (inst_39835 + (1));
var tmp39921 = inst_39832;
var tmp39922 = inst_39834;
var tmp39923 = inst_39833;
var inst_39832__$1 = tmp39921;
var inst_39833__$1 = tmp39923;
var inst_39834__$1 = tmp39922;
var inst_39835__$1 = inst_39843;
var state_39891__$1 = (function (){var statearr_39927 = state_39891;
(statearr_39927[(17)] = inst_39842);

(statearr_39927[(12)] = inst_39832__$1);

(statearr_39927[(13)] = inst_39835__$1);

(statearr_39927[(14)] = inst_39834__$1);

(statearr_39927[(15)] = inst_39833__$1);

return statearr_39927;
})();
var statearr_39928_39962 = state_39891__$1;
(statearr_39928_39962[(2)] = null);

(statearr_39928_39962[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (18))){
var inst_39861 = (state_39891[(2)]);
var state_39891__$1 = state_39891;
var statearr_39929_39963 = state_39891__$1;
(statearr_39929_39963[(2)] = inst_39861);

(statearr_39929_39963[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39892 === (8))){
var inst_39835 = (state_39891[(13)]);
var inst_39834 = (state_39891[(14)]);
var inst_39837 = (inst_39835 < inst_39834);
var inst_39838 = inst_39837;
var state_39891__$1 = state_39891;
if(cljs.core.truth_(inst_39838)){
var statearr_39930_39964 = state_39891__$1;
(statearr_39930_39964[(1)] = (10));

} else {
var statearr_39931_39965 = state_39891__$1;
(statearr_39931_39965[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto___39937,mults,ensure_mult,p))
;
return ((function (switch__30769__auto__,c__30790__auto___39937,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__30770__auto__ = null;
var cljs$core$async$state_machine__30770__auto____0 = (function (){
var statearr_39932 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39932[(0)] = cljs$core$async$state_machine__30770__auto__);

(statearr_39932[(1)] = (1));

return statearr_39932;
});
var cljs$core$async$state_machine__30770__auto____1 = (function (state_39891){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_39891);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e39933){if((e39933 instanceof Object)){
var ex__30773__auto__ = e39933;
var statearr_39934_39966 = state_39891;
(statearr_39934_39966[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_39891);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e39933;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39967 = state_39891;
state_39891 = G__39967;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$state_machine__30770__auto__ = function(state_39891){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30770__auto____1.call(this,state_39891);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30770__auto____0;
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30770__auto____1;
return cljs$core$async$state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto___39937,mults,ensure_mult,p))
})();
var state__30792__auto__ = (function (){var statearr_39935 = f__30791__auto__.call(null);
(statearr_39935[(6)] = c__30790__auto___39937);

return statearr_39935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto___39937,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__39969 = arguments.length;
switch (G__39969) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__39972 = arguments.length;
switch (G__39972) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__39975 = arguments.length;
switch (G__39975) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__30790__auto___40042 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto___40042,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto___40042,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_40014){
var state_val_40015 = (state_40014[(1)]);
if((state_val_40015 === (7))){
var state_40014__$1 = state_40014;
var statearr_40016_40043 = state_40014__$1;
(statearr_40016_40043[(2)] = null);

(statearr_40016_40043[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40015 === (1))){
var state_40014__$1 = state_40014;
var statearr_40017_40044 = state_40014__$1;
(statearr_40017_40044[(2)] = null);

(statearr_40017_40044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40015 === (4))){
var inst_39978 = (state_40014[(7)]);
var inst_39980 = (inst_39978 < cnt);
var state_40014__$1 = state_40014;
if(cljs.core.truth_(inst_39980)){
var statearr_40018_40045 = state_40014__$1;
(statearr_40018_40045[(1)] = (6));

} else {
var statearr_40019_40046 = state_40014__$1;
(statearr_40019_40046[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40015 === (15))){
var inst_40010 = (state_40014[(2)]);
var state_40014__$1 = state_40014;
var statearr_40020_40047 = state_40014__$1;
(statearr_40020_40047[(2)] = inst_40010);

(statearr_40020_40047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40015 === (13))){
var inst_40003 = cljs.core.async.close_BANG_.call(null,out);
var state_40014__$1 = state_40014;
var statearr_40021_40048 = state_40014__$1;
(statearr_40021_40048[(2)] = inst_40003);

(statearr_40021_40048[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40015 === (6))){
var state_40014__$1 = state_40014;
var statearr_40022_40049 = state_40014__$1;
(statearr_40022_40049[(2)] = null);

(statearr_40022_40049[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40015 === (3))){
var inst_40012 = (state_40014[(2)]);
var state_40014__$1 = state_40014;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40014__$1,inst_40012);
} else {
if((state_val_40015 === (12))){
var inst_40000 = (state_40014[(8)]);
var inst_40000__$1 = (state_40014[(2)]);
var inst_40001 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_40000__$1);
var state_40014__$1 = (function (){var statearr_40023 = state_40014;
(statearr_40023[(8)] = inst_40000__$1);

return statearr_40023;
})();
if(cljs.core.truth_(inst_40001)){
var statearr_40024_40050 = state_40014__$1;
(statearr_40024_40050[(1)] = (13));

} else {
var statearr_40025_40051 = state_40014__$1;
(statearr_40025_40051[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40015 === (2))){
var inst_39977 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_39978 = (0);
var state_40014__$1 = (function (){var statearr_40026 = state_40014;
(statearr_40026[(7)] = inst_39978);

(statearr_40026[(9)] = inst_39977);

return statearr_40026;
})();
var statearr_40027_40052 = state_40014__$1;
(statearr_40027_40052[(2)] = null);

(statearr_40027_40052[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40015 === (11))){
var inst_39978 = (state_40014[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_40014,(10),Object,null,(9));
var inst_39987 = chs__$1.call(null,inst_39978);
var inst_39988 = done.call(null,inst_39978);
var inst_39989 = cljs.core.async.take_BANG_.call(null,inst_39987,inst_39988);
var state_40014__$1 = state_40014;
var statearr_40028_40053 = state_40014__$1;
(statearr_40028_40053[(2)] = inst_39989);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40014__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40015 === (9))){
var inst_39978 = (state_40014[(7)]);
var inst_39991 = (state_40014[(2)]);
var inst_39992 = (inst_39978 + (1));
var inst_39978__$1 = inst_39992;
var state_40014__$1 = (function (){var statearr_40029 = state_40014;
(statearr_40029[(7)] = inst_39978__$1);

(statearr_40029[(10)] = inst_39991);

return statearr_40029;
})();
var statearr_40030_40054 = state_40014__$1;
(statearr_40030_40054[(2)] = null);

(statearr_40030_40054[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40015 === (5))){
var inst_39998 = (state_40014[(2)]);
var state_40014__$1 = (function (){var statearr_40031 = state_40014;
(statearr_40031[(11)] = inst_39998);

return statearr_40031;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40014__$1,(12),dchan);
} else {
if((state_val_40015 === (14))){
var inst_40000 = (state_40014[(8)]);
var inst_40005 = cljs.core.apply.call(null,f,inst_40000);
var state_40014__$1 = state_40014;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40014__$1,(16),out,inst_40005);
} else {
if((state_val_40015 === (16))){
var inst_40007 = (state_40014[(2)]);
var state_40014__$1 = (function (){var statearr_40032 = state_40014;
(statearr_40032[(12)] = inst_40007);

return statearr_40032;
})();
var statearr_40033_40055 = state_40014__$1;
(statearr_40033_40055[(2)] = null);

(statearr_40033_40055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40015 === (10))){
var inst_39982 = (state_40014[(2)]);
var inst_39983 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_40014__$1 = (function (){var statearr_40034 = state_40014;
(statearr_40034[(13)] = inst_39982);

return statearr_40034;
})();
var statearr_40035_40056 = state_40014__$1;
(statearr_40035_40056[(2)] = inst_39983);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40014__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40015 === (8))){
var inst_39996 = (state_40014[(2)]);
var state_40014__$1 = state_40014;
var statearr_40036_40057 = state_40014__$1;
(statearr_40036_40057[(2)] = inst_39996);

(statearr_40036_40057[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto___40042,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__30769__auto__,c__30790__auto___40042,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__30770__auto__ = null;
var cljs$core$async$state_machine__30770__auto____0 = (function (){
var statearr_40037 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40037[(0)] = cljs$core$async$state_machine__30770__auto__);

(statearr_40037[(1)] = (1));

return statearr_40037;
});
var cljs$core$async$state_machine__30770__auto____1 = (function (state_40014){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_40014);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e40038){if((e40038 instanceof Object)){
var ex__30773__auto__ = e40038;
var statearr_40039_40058 = state_40014;
(statearr_40039_40058[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40014);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40038;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40059 = state_40014;
state_40014 = G__40059;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$state_machine__30770__auto__ = function(state_40014){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30770__auto____1.call(this,state_40014);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30770__auto____0;
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30770__auto____1;
return cljs$core$async$state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto___40042,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__30792__auto__ = (function (){var statearr_40040 = f__30791__auto__.call(null);
(statearr_40040[(6)] = c__30790__auto___40042);

return statearr_40040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto___40042,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__40062 = arguments.length;
switch (G__40062) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30790__auto___40116 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto___40116,out){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto___40116,out){
return (function (state_40094){
var state_val_40095 = (state_40094[(1)]);
if((state_val_40095 === (7))){
var inst_40073 = (state_40094[(7)]);
var inst_40074 = (state_40094[(8)]);
var inst_40073__$1 = (state_40094[(2)]);
var inst_40074__$1 = cljs.core.nth.call(null,inst_40073__$1,(0),null);
var inst_40075 = cljs.core.nth.call(null,inst_40073__$1,(1),null);
var inst_40076 = (inst_40074__$1 == null);
var state_40094__$1 = (function (){var statearr_40096 = state_40094;
(statearr_40096[(9)] = inst_40075);

(statearr_40096[(7)] = inst_40073__$1);

(statearr_40096[(8)] = inst_40074__$1);

return statearr_40096;
})();
if(cljs.core.truth_(inst_40076)){
var statearr_40097_40117 = state_40094__$1;
(statearr_40097_40117[(1)] = (8));

} else {
var statearr_40098_40118 = state_40094__$1;
(statearr_40098_40118[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40095 === (1))){
var inst_40063 = cljs.core.vec.call(null,chs);
var inst_40064 = inst_40063;
var state_40094__$1 = (function (){var statearr_40099 = state_40094;
(statearr_40099[(10)] = inst_40064);

return statearr_40099;
})();
var statearr_40100_40119 = state_40094__$1;
(statearr_40100_40119[(2)] = null);

(statearr_40100_40119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40095 === (4))){
var inst_40064 = (state_40094[(10)]);
var state_40094__$1 = state_40094;
return cljs.core.async.ioc_alts_BANG_.call(null,state_40094__$1,(7),inst_40064);
} else {
if((state_val_40095 === (6))){
var inst_40090 = (state_40094[(2)]);
var state_40094__$1 = state_40094;
var statearr_40101_40120 = state_40094__$1;
(statearr_40101_40120[(2)] = inst_40090);

(statearr_40101_40120[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40095 === (3))){
var inst_40092 = (state_40094[(2)]);
var state_40094__$1 = state_40094;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40094__$1,inst_40092);
} else {
if((state_val_40095 === (2))){
var inst_40064 = (state_40094[(10)]);
var inst_40066 = cljs.core.count.call(null,inst_40064);
var inst_40067 = (inst_40066 > (0));
var state_40094__$1 = state_40094;
if(cljs.core.truth_(inst_40067)){
var statearr_40103_40121 = state_40094__$1;
(statearr_40103_40121[(1)] = (4));

} else {
var statearr_40104_40122 = state_40094__$1;
(statearr_40104_40122[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40095 === (11))){
var inst_40064 = (state_40094[(10)]);
var inst_40083 = (state_40094[(2)]);
var tmp40102 = inst_40064;
var inst_40064__$1 = tmp40102;
var state_40094__$1 = (function (){var statearr_40105 = state_40094;
(statearr_40105[(10)] = inst_40064__$1);

(statearr_40105[(11)] = inst_40083);

return statearr_40105;
})();
var statearr_40106_40123 = state_40094__$1;
(statearr_40106_40123[(2)] = null);

(statearr_40106_40123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40095 === (9))){
var inst_40074 = (state_40094[(8)]);
var state_40094__$1 = state_40094;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40094__$1,(11),out,inst_40074);
} else {
if((state_val_40095 === (5))){
var inst_40088 = cljs.core.async.close_BANG_.call(null,out);
var state_40094__$1 = state_40094;
var statearr_40107_40124 = state_40094__$1;
(statearr_40107_40124[(2)] = inst_40088);

(statearr_40107_40124[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40095 === (10))){
var inst_40086 = (state_40094[(2)]);
var state_40094__$1 = state_40094;
var statearr_40108_40125 = state_40094__$1;
(statearr_40108_40125[(2)] = inst_40086);

(statearr_40108_40125[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40095 === (8))){
var inst_40075 = (state_40094[(9)]);
var inst_40064 = (state_40094[(10)]);
var inst_40073 = (state_40094[(7)]);
var inst_40074 = (state_40094[(8)]);
var inst_40078 = (function (){var cs = inst_40064;
var vec__40069 = inst_40073;
var v = inst_40074;
var c = inst_40075;
return ((function (cs,vec__40069,v,c,inst_40075,inst_40064,inst_40073,inst_40074,state_val_40095,c__30790__auto___40116,out){
return (function (p1__40060_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__40060_SHARP_);
});
;})(cs,vec__40069,v,c,inst_40075,inst_40064,inst_40073,inst_40074,state_val_40095,c__30790__auto___40116,out))
})();
var inst_40079 = cljs.core.filterv.call(null,inst_40078,inst_40064);
var inst_40064__$1 = inst_40079;
var state_40094__$1 = (function (){var statearr_40109 = state_40094;
(statearr_40109[(10)] = inst_40064__$1);

return statearr_40109;
})();
var statearr_40110_40126 = state_40094__$1;
(statearr_40110_40126[(2)] = null);

(statearr_40110_40126[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto___40116,out))
;
return ((function (switch__30769__auto__,c__30790__auto___40116,out){
return (function() {
var cljs$core$async$state_machine__30770__auto__ = null;
var cljs$core$async$state_machine__30770__auto____0 = (function (){
var statearr_40111 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40111[(0)] = cljs$core$async$state_machine__30770__auto__);

(statearr_40111[(1)] = (1));

return statearr_40111;
});
var cljs$core$async$state_machine__30770__auto____1 = (function (state_40094){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_40094);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e40112){if((e40112 instanceof Object)){
var ex__30773__auto__ = e40112;
var statearr_40113_40127 = state_40094;
(statearr_40113_40127[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40094);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40112;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40128 = state_40094;
state_40094 = G__40128;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$state_machine__30770__auto__ = function(state_40094){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30770__auto____1.call(this,state_40094);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30770__auto____0;
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30770__auto____1;
return cljs$core$async$state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto___40116,out))
})();
var state__30792__auto__ = (function (){var statearr_40114 = f__30791__auto__.call(null);
(statearr_40114[(6)] = c__30790__auto___40116);

return statearr_40114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto___40116,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__40130 = arguments.length;
switch (G__40130) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30790__auto___40175 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto___40175,out){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto___40175,out){
return (function (state_40154){
var state_val_40155 = (state_40154[(1)]);
if((state_val_40155 === (7))){
var inst_40136 = (state_40154[(7)]);
var inst_40136__$1 = (state_40154[(2)]);
var inst_40137 = (inst_40136__$1 == null);
var inst_40138 = cljs.core.not.call(null,inst_40137);
var state_40154__$1 = (function (){var statearr_40156 = state_40154;
(statearr_40156[(7)] = inst_40136__$1);

return statearr_40156;
})();
if(inst_40138){
var statearr_40157_40176 = state_40154__$1;
(statearr_40157_40176[(1)] = (8));

} else {
var statearr_40158_40177 = state_40154__$1;
(statearr_40158_40177[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40155 === (1))){
var inst_40131 = (0);
var state_40154__$1 = (function (){var statearr_40159 = state_40154;
(statearr_40159[(8)] = inst_40131);

return statearr_40159;
})();
var statearr_40160_40178 = state_40154__$1;
(statearr_40160_40178[(2)] = null);

(statearr_40160_40178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40155 === (4))){
var state_40154__$1 = state_40154;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40154__$1,(7),ch);
} else {
if((state_val_40155 === (6))){
var inst_40149 = (state_40154[(2)]);
var state_40154__$1 = state_40154;
var statearr_40161_40179 = state_40154__$1;
(statearr_40161_40179[(2)] = inst_40149);

(statearr_40161_40179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40155 === (3))){
var inst_40151 = (state_40154[(2)]);
var inst_40152 = cljs.core.async.close_BANG_.call(null,out);
var state_40154__$1 = (function (){var statearr_40162 = state_40154;
(statearr_40162[(9)] = inst_40151);

return statearr_40162;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40154__$1,inst_40152);
} else {
if((state_val_40155 === (2))){
var inst_40131 = (state_40154[(8)]);
var inst_40133 = (inst_40131 < n);
var state_40154__$1 = state_40154;
if(cljs.core.truth_(inst_40133)){
var statearr_40163_40180 = state_40154__$1;
(statearr_40163_40180[(1)] = (4));

} else {
var statearr_40164_40181 = state_40154__$1;
(statearr_40164_40181[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40155 === (11))){
var inst_40131 = (state_40154[(8)]);
var inst_40141 = (state_40154[(2)]);
var inst_40142 = (inst_40131 + (1));
var inst_40131__$1 = inst_40142;
var state_40154__$1 = (function (){var statearr_40165 = state_40154;
(statearr_40165[(8)] = inst_40131__$1);

(statearr_40165[(10)] = inst_40141);

return statearr_40165;
})();
var statearr_40166_40182 = state_40154__$1;
(statearr_40166_40182[(2)] = null);

(statearr_40166_40182[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40155 === (9))){
var state_40154__$1 = state_40154;
var statearr_40167_40183 = state_40154__$1;
(statearr_40167_40183[(2)] = null);

(statearr_40167_40183[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40155 === (5))){
var state_40154__$1 = state_40154;
var statearr_40168_40184 = state_40154__$1;
(statearr_40168_40184[(2)] = null);

(statearr_40168_40184[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40155 === (10))){
var inst_40146 = (state_40154[(2)]);
var state_40154__$1 = state_40154;
var statearr_40169_40185 = state_40154__$1;
(statearr_40169_40185[(2)] = inst_40146);

(statearr_40169_40185[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40155 === (8))){
var inst_40136 = (state_40154[(7)]);
var state_40154__$1 = state_40154;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40154__$1,(11),out,inst_40136);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto___40175,out))
;
return ((function (switch__30769__auto__,c__30790__auto___40175,out){
return (function() {
var cljs$core$async$state_machine__30770__auto__ = null;
var cljs$core$async$state_machine__30770__auto____0 = (function (){
var statearr_40170 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40170[(0)] = cljs$core$async$state_machine__30770__auto__);

(statearr_40170[(1)] = (1));

return statearr_40170;
});
var cljs$core$async$state_machine__30770__auto____1 = (function (state_40154){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_40154);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e40171){if((e40171 instanceof Object)){
var ex__30773__auto__ = e40171;
var statearr_40172_40186 = state_40154;
(statearr_40172_40186[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40154);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40171;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40187 = state_40154;
state_40154 = G__40187;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$state_machine__30770__auto__ = function(state_40154){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30770__auto____1.call(this,state_40154);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30770__auto____0;
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30770__auto____1;
return cljs$core$async$state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto___40175,out))
})();
var state__30792__auto__ = (function (){var statearr_40173 = f__30791__auto__.call(null);
(statearr_40173[(6)] = c__30790__auto___40175);

return statearr_40173;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto___40175,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async40189 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40189 = (function (f,ch,meta40190){
this.f = f;
this.ch = ch;
this.meta40190 = meta40190;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async40189.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40191,meta40190__$1){
var self__ = this;
var _40191__$1 = this;
return (new cljs.core.async.t_cljs$core$async40189(self__.f,self__.ch,meta40190__$1));
});

cljs.core.async.t_cljs$core$async40189.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40191){
var self__ = this;
var _40191__$1 = this;
return self__.meta40190;
});

cljs.core.async.t_cljs$core$async40189.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40189.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async40189.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async40189.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40189.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async40192 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40192 = (function (f,ch,meta40190,_,fn1,meta40193){
this.f = f;
this.ch = ch;
this.meta40190 = meta40190;
this._ = _;
this.fn1 = fn1;
this.meta40193 = meta40193;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async40192.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_40194,meta40193__$1){
var self__ = this;
var _40194__$1 = this;
return (new cljs.core.async.t_cljs$core$async40192(self__.f,self__.ch,self__.meta40190,self__._,self__.fn1,meta40193__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async40192.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_40194){
var self__ = this;
var _40194__$1 = this;
return self__.meta40193;
});})(___$1))
;

cljs.core.async.t_cljs$core$async40192.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40192.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async40192.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async40192.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__40188_SHARP_){
return f1.call(null,(((p1__40188_SHARP_ == null))?null:self__.f.call(null,p1__40188_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async40192.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta40190","meta40190",-243143141,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async40189","cljs.core.async/t_cljs$core$async40189",1541778118,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta40193","meta40193",327455279,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async40192.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40192.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40192";

cljs.core.async.t_cljs$core$async40192.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async40192");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async40192 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async40192(f__$1,ch__$1,meta40190__$1,___$2,fn1__$1,meta40193){
return (new cljs.core.async.t_cljs$core$async40192(f__$1,ch__$1,meta40190__$1,___$2,fn1__$1,meta40193));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async40192(self__.f,self__.ch,self__.meta40190,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__28335__auto__ = ret;
if(cljs.core.truth_(and__28335__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__28335__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async40189.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40189.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async40189.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta40190","meta40190",-243143141,null)], null);
});

cljs.core.async.t_cljs$core$async40189.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40189.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40189";

cljs.core.async.t_cljs$core$async40189.cljs$lang$ctorPrWriter = (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async40189");
});

cljs.core.async.__GT_t_cljs$core$async40189 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async40189(f__$1,ch__$1,meta40190){
return (new cljs.core.async.t_cljs$core$async40189(f__$1,ch__$1,meta40190));
});

}

return (new cljs.core.async.t_cljs$core$async40189(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async40195 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40195 = (function (f,ch,meta40196){
this.f = f;
this.ch = ch;
this.meta40196 = meta40196;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async40195.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40197,meta40196__$1){
var self__ = this;
var _40197__$1 = this;
return (new cljs.core.async.t_cljs$core$async40195(self__.f,self__.ch,meta40196__$1));
});

cljs.core.async.t_cljs$core$async40195.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40197){
var self__ = this;
var _40197__$1 = this;
return self__.meta40196;
});

cljs.core.async.t_cljs$core$async40195.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40195.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async40195.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40195.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async40195.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40195.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async40195.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta40196","meta40196",1827153527,null)], null);
});

cljs.core.async.t_cljs$core$async40195.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40195.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40195";

cljs.core.async.t_cljs$core$async40195.cljs$lang$ctorPrWriter = (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async40195");
});

cljs.core.async.__GT_t_cljs$core$async40195 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async40195(f__$1,ch__$1,meta40196){
return (new cljs.core.async.t_cljs$core$async40195(f__$1,ch__$1,meta40196));
});

}

return (new cljs.core.async.t_cljs$core$async40195(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async40198 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40198 = (function (p,ch,meta40199){
this.p = p;
this.ch = ch;
this.meta40199 = meta40199;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async40198.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40200,meta40199__$1){
var self__ = this;
var _40200__$1 = this;
return (new cljs.core.async.t_cljs$core$async40198(self__.p,self__.ch,meta40199__$1));
});

cljs.core.async.t_cljs$core$async40198.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40200){
var self__ = this;
var _40200__$1 = this;
return self__.meta40199;
});

cljs.core.async.t_cljs$core$async40198.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40198.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async40198.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async40198.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40198.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async40198.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async40198.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async40198.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta40199","meta40199",1564513999,null)], null);
});

cljs.core.async.t_cljs$core$async40198.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40198.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40198";

cljs.core.async.t_cljs$core$async40198.cljs$lang$ctorPrWriter = (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async40198");
});

cljs.core.async.__GT_t_cljs$core$async40198 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async40198(p__$1,ch__$1,meta40199){
return (new cljs.core.async.t_cljs$core$async40198(p__$1,ch__$1,meta40199));
});

}

return (new cljs.core.async.t_cljs$core$async40198(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__40202 = arguments.length;
switch (G__40202) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30790__auto___40242 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto___40242,out){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto___40242,out){
return (function (state_40223){
var state_val_40224 = (state_40223[(1)]);
if((state_val_40224 === (7))){
var inst_40219 = (state_40223[(2)]);
var state_40223__$1 = state_40223;
var statearr_40225_40243 = state_40223__$1;
(statearr_40225_40243[(2)] = inst_40219);

(statearr_40225_40243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40224 === (1))){
var state_40223__$1 = state_40223;
var statearr_40226_40244 = state_40223__$1;
(statearr_40226_40244[(2)] = null);

(statearr_40226_40244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40224 === (4))){
var inst_40205 = (state_40223[(7)]);
var inst_40205__$1 = (state_40223[(2)]);
var inst_40206 = (inst_40205__$1 == null);
var state_40223__$1 = (function (){var statearr_40227 = state_40223;
(statearr_40227[(7)] = inst_40205__$1);

return statearr_40227;
})();
if(cljs.core.truth_(inst_40206)){
var statearr_40228_40245 = state_40223__$1;
(statearr_40228_40245[(1)] = (5));

} else {
var statearr_40229_40246 = state_40223__$1;
(statearr_40229_40246[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40224 === (6))){
var inst_40205 = (state_40223[(7)]);
var inst_40210 = p.call(null,inst_40205);
var state_40223__$1 = state_40223;
if(cljs.core.truth_(inst_40210)){
var statearr_40230_40247 = state_40223__$1;
(statearr_40230_40247[(1)] = (8));

} else {
var statearr_40231_40248 = state_40223__$1;
(statearr_40231_40248[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40224 === (3))){
var inst_40221 = (state_40223[(2)]);
var state_40223__$1 = state_40223;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40223__$1,inst_40221);
} else {
if((state_val_40224 === (2))){
var state_40223__$1 = state_40223;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40223__$1,(4),ch);
} else {
if((state_val_40224 === (11))){
var inst_40213 = (state_40223[(2)]);
var state_40223__$1 = state_40223;
var statearr_40232_40249 = state_40223__$1;
(statearr_40232_40249[(2)] = inst_40213);

(statearr_40232_40249[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40224 === (9))){
var state_40223__$1 = state_40223;
var statearr_40233_40250 = state_40223__$1;
(statearr_40233_40250[(2)] = null);

(statearr_40233_40250[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40224 === (5))){
var inst_40208 = cljs.core.async.close_BANG_.call(null,out);
var state_40223__$1 = state_40223;
var statearr_40234_40251 = state_40223__$1;
(statearr_40234_40251[(2)] = inst_40208);

(statearr_40234_40251[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40224 === (10))){
var inst_40216 = (state_40223[(2)]);
var state_40223__$1 = (function (){var statearr_40235 = state_40223;
(statearr_40235[(8)] = inst_40216);

return statearr_40235;
})();
var statearr_40236_40252 = state_40223__$1;
(statearr_40236_40252[(2)] = null);

(statearr_40236_40252[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40224 === (8))){
var inst_40205 = (state_40223[(7)]);
var state_40223__$1 = state_40223;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40223__$1,(11),out,inst_40205);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto___40242,out))
;
return ((function (switch__30769__auto__,c__30790__auto___40242,out){
return (function() {
var cljs$core$async$state_machine__30770__auto__ = null;
var cljs$core$async$state_machine__30770__auto____0 = (function (){
var statearr_40237 = [null,null,null,null,null,null,null,null,null];
(statearr_40237[(0)] = cljs$core$async$state_machine__30770__auto__);

(statearr_40237[(1)] = (1));

return statearr_40237;
});
var cljs$core$async$state_machine__30770__auto____1 = (function (state_40223){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_40223);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e40238){if((e40238 instanceof Object)){
var ex__30773__auto__ = e40238;
var statearr_40239_40253 = state_40223;
(statearr_40239_40253[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40223);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40238;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40254 = state_40223;
state_40223 = G__40254;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$state_machine__30770__auto__ = function(state_40223){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30770__auto____1.call(this,state_40223);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30770__auto____0;
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30770__auto____1;
return cljs$core$async$state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto___40242,out))
})();
var state__30792__auto__ = (function (){var statearr_40240 = f__30791__auto__.call(null);
(statearr_40240[(6)] = c__30790__auto___40242);

return statearr_40240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto___40242,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__40256 = arguments.length;
switch (G__40256) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__30790__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto__){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto__){
return (function (state_40319){
var state_val_40320 = (state_40319[(1)]);
if((state_val_40320 === (7))){
var inst_40315 = (state_40319[(2)]);
var state_40319__$1 = state_40319;
var statearr_40321_40359 = state_40319__$1;
(statearr_40321_40359[(2)] = inst_40315);

(statearr_40321_40359[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (20))){
var inst_40285 = (state_40319[(7)]);
var inst_40296 = (state_40319[(2)]);
var inst_40297 = cljs.core.next.call(null,inst_40285);
var inst_40271 = inst_40297;
var inst_40272 = null;
var inst_40273 = (0);
var inst_40274 = (0);
var state_40319__$1 = (function (){var statearr_40322 = state_40319;
(statearr_40322[(8)] = inst_40272);

(statearr_40322[(9)] = inst_40296);

(statearr_40322[(10)] = inst_40273);

(statearr_40322[(11)] = inst_40274);

(statearr_40322[(12)] = inst_40271);

return statearr_40322;
})();
var statearr_40323_40360 = state_40319__$1;
(statearr_40323_40360[(2)] = null);

(statearr_40323_40360[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (1))){
var state_40319__$1 = state_40319;
var statearr_40324_40361 = state_40319__$1;
(statearr_40324_40361[(2)] = null);

(statearr_40324_40361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (4))){
var inst_40260 = (state_40319[(13)]);
var inst_40260__$1 = (state_40319[(2)]);
var inst_40261 = (inst_40260__$1 == null);
var state_40319__$1 = (function (){var statearr_40325 = state_40319;
(statearr_40325[(13)] = inst_40260__$1);

return statearr_40325;
})();
if(cljs.core.truth_(inst_40261)){
var statearr_40326_40362 = state_40319__$1;
(statearr_40326_40362[(1)] = (5));

} else {
var statearr_40327_40363 = state_40319__$1;
(statearr_40327_40363[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (15))){
var state_40319__$1 = state_40319;
var statearr_40331_40364 = state_40319__$1;
(statearr_40331_40364[(2)] = null);

(statearr_40331_40364[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (21))){
var state_40319__$1 = state_40319;
var statearr_40332_40365 = state_40319__$1;
(statearr_40332_40365[(2)] = null);

(statearr_40332_40365[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (13))){
var inst_40272 = (state_40319[(8)]);
var inst_40273 = (state_40319[(10)]);
var inst_40274 = (state_40319[(11)]);
var inst_40271 = (state_40319[(12)]);
var inst_40281 = (state_40319[(2)]);
var inst_40282 = (inst_40274 + (1));
var tmp40328 = inst_40272;
var tmp40329 = inst_40273;
var tmp40330 = inst_40271;
var inst_40271__$1 = tmp40330;
var inst_40272__$1 = tmp40328;
var inst_40273__$1 = tmp40329;
var inst_40274__$1 = inst_40282;
var state_40319__$1 = (function (){var statearr_40333 = state_40319;
(statearr_40333[(8)] = inst_40272__$1);

(statearr_40333[(10)] = inst_40273__$1);

(statearr_40333[(11)] = inst_40274__$1);

(statearr_40333[(12)] = inst_40271__$1);

(statearr_40333[(14)] = inst_40281);

return statearr_40333;
})();
var statearr_40334_40366 = state_40319__$1;
(statearr_40334_40366[(2)] = null);

(statearr_40334_40366[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (22))){
var state_40319__$1 = state_40319;
var statearr_40335_40367 = state_40319__$1;
(statearr_40335_40367[(2)] = null);

(statearr_40335_40367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (6))){
var inst_40260 = (state_40319[(13)]);
var inst_40269 = f.call(null,inst_40260);
var inst_40270 = cljs.core.seq.call(null,inst_40269);
var inst_40271 = inst_40270;
var inst_40272 = null;
var inst_40273 = (0);
var inst_40274 = (0);
var state_40319__$1 = (function (){var statearr_40336 = state_40319;
(statearr_40336[(8)] = inst_40272);

(statearr_40336[(10)] = inst_40273);

(statearr_40336[(11)] = inst_40274);

(statearr_40336[(12)] = inst_40271);

return statearr_40336;
})();
var statearr_40337_40368 = state_40319__$1;
(statearr_40337_40368[(2)] = null);

(statearr_40337_40368[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (17))){
var inst_40285 = (state_40319[(7)]);
var inst_40289 = cljs.core.chunk_first.call(null,inst_40285);
var inst_40290 = cljs.core.chunk_rest.call(null,inst_40285);
var inst_40291 = cljs.core.count.call(null,inst_40289);
var inst_40271 = inst_40290;
var inst_40272 = inst_40289;
var inst_40273 = inst_40291;
var inst_40274 = (0);
var state_40319__$1 = (function (){var statearr_40338 = state_40319;
(statearr_40338[(8)] = inst_40272);

(statearr_40338[(10)] = inst_40273);

(statearr_40338[(11)] = inst_40274);

(statearr_40338[(12)] = inst_40271);

return statearr_40338;
})();
var statearr_40339_40369 = state_40319__$1;
(statearr_40339_40369[(2)] = null);

(statearr_40339_40369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (3))){
var inst_40317 = (state_40319[(2)]);
var state_40319__$1 = state_40319;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40319__$1,inst_40317);
} else {
if((state_val_40320 === (12))){
var inst_40305 = (state_40319[(2)]);
var state_40319__$1 = state_40319;
var statearr_40340_40370 = state_40319__$1;
(statearr_40340_40370[(2)] = inst_40305);

(statearr_40340_40370[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (2))){
var state_40319__$1 = state_40319;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40319__$1,(4),in$);
} else {
if((state_val_40320 === (23))){
var inst_40313 = (state_40319[(2)]);
var state_40319__$1 = state_40319;
var statearr_40341_40371 = state_40319__$1;
(statearr_40341_40371[(2)] = inst_40313);

(statearr_40341_40371[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (19))){
var inst_40300 = (state_40319[(2)]);
var state_40319__$1 = state_40319;
var statearr_40342_40372 = state_40319__$1;
(statearr_40342_40372[(2)] = inst_40300);

(statearr_40342_40372[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (11))){
var inst_40285 = (state_40319[(7)]);
var inst_40271 = (state_40319[(12)]);
var inst_40285__$1 = cljs.core.seq.call(null,inst_40271);
var state_40319__$1 = (function (){var statearr_40343 = state_40319;
(statearr_40343[(7)] = inst_40285__$1);

return statearr_40343;
})();
if(inst_40285__$1){
var statearr_40344_40373 = state_40319__$1;
(statearr_40344_40373[(1)] = (14));

} else {
var statearr_40345_40374 = state_40319__$1;
(statearr_40345_40374[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (9))){
var inst_40307 = (state_40319[(2)]);
var inst_40308 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_40319__$1 = (function (){var statearr_40346 = state_40319;
(statearr_40346[(15)] = inst_40307);

return statearr_40346;
})();
if(cljs.core.truth_(inst_40308)){
var statearr_40347_40375 = state_40319__$1;
(statearr_40347_40375[(1)] = (21));

} else {
var statearr_40348_40376 = state_40319__$1;
(statearr_40348_40376[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (5))){
var inst_40263 = cljs.core.async.close_BANG_.call(null,out);
var state_40319__$1 = state_40319;
var statearr_40349_40377 = state_40319__$1;
(statearr_40349_40377[(2)] = inst_40263);

(statearr_40349_40377[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (14))){
var inst_40285 = (state_40319[(7)]);
var inst_40287 = cljs.core.chunked_seq_QMARK_.call(null,inst_40285);
var state_40319__$1 = state_40319;
if(inst_40287){
var statearr_40350_40378 = state_40319__$1;
(statearr_40350_40378[(1)] = (17));

} else {
var statearr_40351_40379 = state_40319__$1;
(statearr_40351_40379[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (16))){
var inst_40303 = (state_40319[(2)]);
var state_40319__$1 = state_40319;
var statearr_40352_40380 = state_40319__$1;
(statearr_40352_40380[(2)] = inst_40303);

(statearr_40352_40380[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40320 === (10))){
var inst_40272 = (state_40319[(8)]);
var inst_40274 = (state_40319[(11)]);
var inst_40279 = cljs.core._nth.call(null,inst_40272,inst_40274);
var state_40319__$1 = state_40319;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40319__$1,(13),out,inst_40279);
} else {
if((state_val_40320 === (18))){
var inst_40285 = (state_40319[(7)]);
var inst_40294 = cljs.core.first.call(null,inst_40285);
var state_40319__$1 = state_40319;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40319__$1,(20),out,inst_40294);
} else {
if((state_val_40320 === (8))){
var inst_40273 = (state_40319[(10)]);
var inst_40274 = (state_40319[(11)]);
var inst_40276 = (inst_40274 < inst_40273);
var inst_40277 = inst_40276;
var state_40319__$1 = state_40319;
if(cljs.core.truth_(inst_40277)){
var statearr_40353_40381 = state_40319__$1;
(statearr_40353_40381[(1)] = (10));

} else {
var statearr_40354_40382 = state_40319__$1;
(statearr_40354_40382[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto__))
;
return ((function (switch__30769__auto__,c__30790__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__30770__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__30770__auto____0 = (function (){
var statearr_40355 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40355[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__30770__auto__);

(statearr_40355[(1)] = (1));

return statearr_40355;
});
var cljs$core$async$mapcat_STAR__$_state_machine__30770__auto____1 = (function (state_40319){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_40319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e40356){if((e40356 instanceof Object)){
var ex__30773__auto__ = e40356;
var statearr_40357_40383 = state_40319;
(statearr_40357_40383[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40319);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40356;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40384 = state_40319;
state_40319 = G__40384;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__30770__auto__ = function(state_40319){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__30770__auto____1.call(this,state_40319);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__30770__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__30770__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto__))
})();
var state__30792__auto__ = (function (){var statearr_40358 = f__30791__auto__.call(null);
(statearr_40358[(6)] = c__30790__auto__);

return statearr_40358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto__))
);

return c__30790__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__40386 = arguments.length;
switch (G__40386) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__40389 = arguments.length;
switch (G__40389) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__40392 = arguments.length;
switch (G__40392) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30790__auto___40439 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto___40439,out){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto___40439,out){
return (function (state_40416){
var state_val_40417 = (state_40416[(1)]);
if((state_val_40417 === (7))){
var inst_40411 = (state_40416[(2)]);
var state_40416__$1 = state_40416;
var statearr_40418_40440 = state_40416__$1;
(statearr_40418_40440[(2)] = inst_40411);

(statearr_40418_40440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40417 === (1))){
var inst_40393 = null;
var state_40416__$1 = (function (){var statearr_40419 = state_40416;
(statearr_40419[(7)] = inst_40393);

return statearr_40419;
})();
var statearr_40420_40441 = state_40416__$1;
(statearr_40420_40441[(2)] = null);

(statearr_40420_40441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40417 === (4))){
var inst_40396 = (state_40416[(8)]);
var inst_40396__$1 = (state_40416[(2)]);
var inst_40397 = (inst_40396__$1 == null);
var inst_40398 = cljs.core.not.call(null,inst_40397);
var state_40416__$1 = (function (){var statearr_40421 = state_40416;
(statearr_40421[(8)] = inst_40396__$1);

return statearr_40421;
})();
if(inst_40398){
var statearr_40422_40442 = state_40416__$1;
(statearr_40422_40442[(1)] = (5));

} else {
var statearr_40423_40443 = state_40416__$1;
(statearr_40423_40443[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40417 === (6))){
var state_40416__$1 = state_40416;
var statearr_40424_40444 = state_40416__$1;
(statearr_40424_40444[(2)] = null);

(statearr_40424_40444[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40417 === (3))){
var inst_40413 = (state_40416[(2)]);
var inst_40414 = cljs.core.async.close_BANG_.call(null,out);
var state_40416__$1 = (function (){var statearr_40425 = state_40416;
(statearr_40425[(9)] = inst_40413);

return statearr_40425;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40416__$1,inst_40414);
} else {
if((state_val_40417 === (2))){
var state_40416__$1 = state_40416;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40416__$1,(4),ch);
} else {
if((state_val_40417 === (11))){
var inst_40396 = (state_40416[(8)]);
var inst_40405 = (state_40416[(2)]);
var inst_40393 = inst_40396;
var state_40416__$1 = (function (){var statearr_40426 = state_40416;
(statearr_40426[(7)] = inst_40393);

(statearr_40426[(10)] = inst_40405);

return statearr_40426;
})();
var statearr_40427_40445 = state_40416__$1;
(statearr_40427_40445[(2)] = null);

(statearr_40427_40445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40417 === (9))){
var inst_40396 = (state_40416[(8)]);
var state_40416__$1 = state_40416;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40416__$1,(11),out,inst_40396);
} else {
if((state_val_40417 === (5))){
var inst_40396 = (state_40416[(8)]);
var inst_40393 = (state_40416[(7)]);
var inst_40400 = cljs.core._EQ_.call(null,inst_40396,inst_40393);
var state_40416__$1 = state_40416;
if(inst_40400){
var statearr_40429_40446 = state_40416__$1;
(statearr_40429_40446[(1)] = (8));

} else {
var statearr_40430_40447 = state_40416__$1;
(statearr_40430_40447[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40417 === (10))){
var inst_40408 = (state_40416[(2)]);
var state_40416__$1 = state_40416;
var statearr_40431_40448 = state_40416__$1;
(statearr_40431_40448[(2)] = inst_40408);

(statearr_40431_40448[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40417 === (8))){
var inst_40393 = (state_40416[(7)]);
var tmp40428 = inst_40393;
var inst_40393__$1 = tmp40428;
var state_40416__$1 = (function (){var statearr_40432 = state_40416;
(statearr_40432[(7)] = inst_40393__$1);

return statearr_40432;
})();
var statearr_40433_40449 = state_40416__$1;
(statearr_40433_40449[(2)] = null);

(statearr_40433_40449[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto___40439,out))
;
return ((function (switch__30769__auto__,c__30790__auto___40439,out){
return (function() {
var cljs$core$async$state_machine__30770__auto__ = null;
var cljs$core$async$state_machine__30770__auto____0 = (function (){
var statearr_40434 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40434[(0)] = cljs$core$async$state_machine__30770__auto__);

(statearr_40434[(1)] = (1));

return statearr_40434;
});
var cljs$core$async$state_machine__30770__auto____1 = (function (state_40416){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_40416);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e40435){if((e40435 instanceof Object)){
var ex__30773__auto__ = e40435;
var statearr_40436_40450 = state_40416;
(statearr_40436_40450[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40416);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40435;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40451 = state_40416;
state_40416 = G__40451;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$state_machine__30770__auto__ = function(state_40416){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30770__auto____1.call(this,state_40416);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30770__auto____0;
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30770__auto____1;
return cljs$core$async$state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto___40439,out))
})();
var state__30792__auto__ = (function (){var statearr_40437 = f__30791__auto__.call(null);
(statearr_40437[(6)] = c__30790__auto___40439);

return statearr_40437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto___40439,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__40453 = arguments.length;
switch (G__40453) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30790__auto___40519 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto___40519,out){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto___40519,out){
return (function (state_40491){
var state_val_40492 = (state_40491[(1)]);
if((state_val_40492 === (7))){
var inst_40487 = (state_40491[(2)]);
var state_40491__$1 = state_40491;
var statearr_40493_40520 = state_40491__$1;
(statearr_40493_40520[(2)] = inst_40487);

(statearr_40493_40520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (1))){
var inst_40454 = (new Array(n));
var inst_40455 = inst_40454;
var inst_40456 = (0);
var state_40491__$1 = (function (){var statearr_40494 = state_40491;
(statearr_40494[(7)] = inst_40456);

(statearr_40494[(8)] = inst_40455);

return statearr_40494;
})();
var statearr_40495_40521 = state_40491__$1;
(statearr_40495_40521[(2)] = null);

(statearr_40495_40521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (4))){
var inst_40459 = (state_40491[(9)]);
var inst_40459__$1 = (state_40491[(2)]);
var inst_40460 = (inst_40459__$1 == null);
var inst_40461 = cljs.core.not.call(null,inst_40460);
var state_40491__$1 = (function (){var statearr_40496 = state_40491;
(statearr_40496[(9)] = inst_40459__$1);

return statearr_40496;
})();
if(inst_40461){
var statearr_40497_40522 = state_40491__$1;
(statearr_40497_40522[(1)] = (5));

} else {
var statearr_40498_40523 = state_40491__$1;
(statearr_40498_40523[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (15))){
var inst_40481 = (state_40491[(2)]);
var state_40491__$1 = state_40491;
var statearr_40499_40524 = state_40491__$1;
(statearr_40499_40524[(2)] = inst_40481);

(statearr_40499_40524[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (13))){
var state_40491__$1 = state_40491;
var statearr_40500_40525 = state_40491__$1;
(statearr_40500_40525[(2)] = null);

(statearr_40500_40525[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (6))){
var inst_40456 = (state_40491[(7)]);
var inst_40477 = (inst_40456 > (0));
var state_40491__$1 = state_40491;
if(cljs.core.truth_(inst_40477)){
var statearr_40501_40526 = state_40491__$1;
(statearr_40501_40526[(1)] = (12));

} else {
var statearr_40502_40527 = state_40491__$1;
(statearr_40502_40527[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (3))){
var inst_40489 = (state_40491[(2)]);
var state_40491__$1 = state_40491;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40491__$1,inst_40489);
} else {
if((state_val_40492 === (12))){
var inst_40455 = (state_40491[(8)]);
var inst_40479 = cljs.core.vec.call(null,inst_40455);
var state_40491__$1 = state_40491;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40491__$1,(15),out,inst_40479);
} else {
if((state_val_40492 === (2))){
var state_40491__$1 = state_40491;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40491__$1,(4),ch);
} else {
if((state_val_40492 === (11))){
var inst_40471 = (state_40491[(2)]);
var inst_40472 = (new Array(n));
var inst_40455 = inst_40472;
var inst_40456 = (0);
var state_40491__$1 = (function (){var statearr_40503 = state_40491;
(statearr_40503[(10)] = inst_40471);

(statearr_40503[(7)] = inst_40456);

(statearr_40503[(8)] = inst_40455);

return statearr_40503;
})();
var statearr_40504_40528 = state_40491__$1;
(statearr_40504_40528[(2)] = null);

(statearr_40504_40528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (9))){
var inst_40455 = (state_40491[(8)]);
var inst_40469 = cljs.core.vec.call(null,inst_40455);
var state_40491__$1 = state_40491;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40491__$1,(11),out,inst_40469);
} else {
if((state_val_40492 === (5))){
var inst_40464 = (state_40491[(11)]);
var inst_40459 = (state_40491[(9)]);
var inst_40456 = (state_40491[(7)]);
var inst_40455 = (state_40491[(8)]);
var inst_40463 = (inst_40455[inst_40456] = inst_40459);
var inst_40464__$1 = (inst_40456 + (1));
var inst_40465 = (inst_40464__$1 < n);
var state_40491__$1 = (function (){var statearr_40505 = state_40491;
(statearr_40505[(11)] = inst_40464__$1);

(statearr_40505[(12)] = inst_40463);

return statearr_40505;
})();
if(cljs.core.truth_(inst_40465)){
var statearr_40506_40529 = state_40491__$1;
(statearr_40506_40529[(1)] = (8));

} else {
var statearr_40507_40530 = state_40491__$1;
(statearr_40507_40530[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (14))){
var inst_40484 = (state_40491[(2)]);
var inst_40485 = cljs.core.async.close_BANG_.call(null,out);
var state_40491__$1 = (function (){var statearr_40509 = state_40491;
(statearr_40509[(13)] = inst_40484);

return statearr_40509;
})();
var statearr_40510_40531 = state_40491__$1;
(statearr_40510_40531[(2)] = inst_40485);

(statearr_40510_40531[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (10))){
var inst_40475 = (state_40491[(2)]);
var state_40491__$1 = state_40491;
var statearr_40511_40532 = state_40491__$1;
(statearr_40511_40532[(2)] = inst_40475);

(statearr_40511_40532[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40492 === (8))){
var inst_40464 = (state_40491[(11)]);
var inst_40455 = (state_40491[(8)]);
var tmp40508 = inst_40455;
var inst_40455__$1 = tmp40508;
var inst_40456 = inst_40464;
var state_40491__$1 = (function (){var statearr_40512 = state_40491;
(statearr_40512[(7)] = inst_40456);

(statearr_40512[(8)] = inst_40455__$1);

return statearr_40512;
})();
var statearr_40513_40533 = state_40491__$1;
(statearr_40513_40533[(2)] = null);

(statearr_40513_40533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto___40519,out))
;
return ((function (switch__30769__auto__,c__30790__auto___40519,out){
return (function() {
var cljs$core$async$state_machine__30770__auto__ = null;
var cljs$core$async$state_machine__30770__auto____0 = (function (){
var statearr_40514 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40514[(0)] = cljs$core$async$state_machine__30770__auto__);

(statearr_40514[(1)] = (1));

return statearr_40514;
});
var cljs$core$async$state_machine__30770__auto____1 = (function (state_40491){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_40491);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e40515){if((e40515 instanceof Object)){
var ex__30773__auto__ = e40515;
var statearr_40516_40534 = state_40491;
(statearr_40516_40534[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40491);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40515;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40535 = state_40491;
state_40491 = G__40535;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$state_machine__30770__auto__ = function(state_40491){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30770__auto____1.call(this,state_40491);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30770__auto____0;
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30770__auto____1;
return cljs$core$async$state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto___40519,out))
})();
var state__30792__auto__ = (function (){var statearr_40517 = f__30791__auto__.call(null);
(statearr_40517[(6)] = c__30790__auto___40519);

return statearr_40517;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto___40519,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__40537 = arguments.length;
switch (G__40537) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__30790__auto___40607 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30790__auto___40607,out){
return (function (){
var f__30791__auto__ = (function (){var switch__30769__auto__ = ((function (c__30790__auto___40607,out){
return (function (state_40579){
var state_val_40580 = (state_40579[(1)]);
if((state_val_40580 === (7))){
var inst_40575 = (state_40579[(2)]);
var state_40579__$1 = state_40579;
var statearr_40581_40608 = state_40579__$1;
(statearr_40581_40608[(2)] = inst_40575);

(statearr_40581_40608[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40580 === (1))){
var inst_40538 = [];
var inst_40539 = inst_40538;
var inst_40540 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_40579__$1 = (function (){var statearr_40582 = state_40579;
(statearr_40582[(7)] = inst_40540);

(statearr_40582[(8)] = inst_40539);

return statearr_40582;
})();
var statearr_40583_40609 = state_40579__$1;
(statearr_40583_40609[(2)] = null);

(statearr_40583_40609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40580 === (4))){
var inst_40543 = (state_40579[(9)]);
var inst_40543__$1 = (state_40579[(2)]);
var inst_40544 = (inst_40543__$1 == null);
var inst_40545 = cljs.core.not.call(null,inst_40544);
var state_40579__$1 = (function (){var statearr_40584 = state_40579;
(statearr_40584[(9)] = inst_40543__$1);

return statearr_40584;
})();
if(inst_40545){
var statearr_40585_40610 = state_40579__$1;
(statearr_40585_40610[(1)] = (5));

} else {
var statearr_40586_40611 = state_40579__$1;
(statearr_40586_40611[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40580 === (15))){
var inst_40569 = (state_40579[(2)]);
var state_40579__$1 = state_40579;
var statearr_40587_40612 = state_40579__$1;
(statearr_40587_40612[(2)] = inst_40569);

(statearr_40587_40612[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40580 === (13))){
var state_40579__$1 = state_40579;
var statearr_40588_40613 = state_40579__$1;
(statearr_40588_40613[(2)] = null);

(statearr_40588_40613[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40580 === (6))){
var inst_40539 = (state_40579[(8)]);
var inst_40564 = inst_40539.length;
var inst_40565 = (inst_40564 > (0));
var state_40579__$1 = state_40579;
if(cljs.core.truth_(inst_40565)){
var statearr_40589_40614 = state_40579__$1;
(statearr_40589_40614[(1)] = (12));

} else {
var statearr_40590_40615 = state_40579__$1;
(statearr_40590_40615[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40580 === (3))){
var inst_40577 = (state_40579[(2)]);
var state_40579__$1 = state_40579;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_40579__$1,inst_40577);
} else {
if((state_val_40580 === (12))){
var inst_40539 = (state_40579[(8)]);
var inst_40567 = cljs.core.vec.call(null,inst_40539);
var state_40579__$1 = state_40579;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40579__$1,(15),out,inst_40567);
} else {
if((state_val_40580 === (2))){
var state_40579__$1 = state_40579;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_40579__$1,(4),ch);
} else {
if((state_val_40580 === (11))){
var inst_40547 = (state_40579[(10)]);
var inst_40543 = (state_40579[(9)]);
var inst_40557 = (state_40579[(2)]);
var inst_40558 = [];
var inst_40559 = inst_40558.push(inst_40543);
var inst_40539 = inst_40558;
var inst_40540 = inst_40547;
var state_40579__$1 = (function (){var statearr_40591 = state_40579;
(statearr_40591[(11)] = inst_40557);

(statearr_40591[(12)] = inst_40559);

(statearr_40591[(7)] = inst_40540);

(statearr_40591[(8)] = inst_40539);

return statearr_40591;
})();
var statearr_40592_40616 = state_40579__$1;
(statearr_40592_40616[(2)] = null);

(statearr_40592_40616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40580 === (9))){
var inst_40539 = (state_40579[(8)]);
var inst_40555 = cljs.core.vec.call(null,inst_40539);
var state_40579__$1 = state_40579;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_40579__$1,(11),out,inst_40555);
} else {
if((state_val_40580 === (5))){
var inst_40547 = (state_40579[(10)]);
var inst_40543 = (state_40579[(9)]);
var inst_40540 = (state_40579[(7)]);
var inst_40547__$1 = f.call(null,inst_40543);
var inst_40548 = cljs.core._EQ_.call(null,inst_40547__$1,inst_40540);
var inst_40549 = cljs.core.keyword_identical_QMARK_.call(null,inst_40540,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_40550 = (inst_40548) || (inst_40549);
var state_40579__$1 = (function (){var statearr_40593 = state_40579;
(statearr_40593[(10)] = inst_40547__$1);

return statearr_40593;
})();
if(cljs.core.truth_(inst_40550)){
var statearr_40594_40617 = state_40579__$1;
(statearr_40594_40617[(1)] = (8));

} else {
var statearr_40595_40618 = state_40579__$1;
(statearr_40595_40618[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40580 === (14))){
var inst_40572 = (state_40579[(2)]);
var inst_40573 = cljs.core.async.close_BANG_.call(null,out);
var state_40579__$1 = (function (){var statearr_40597 = state_40579;
(statearr_40597[(13)] = inst_40572);

return statearr_40597;
})();
var statearr_40598_40619 = state_40579__$1;
(statearr_40598_40619[(2)] = inst_40573);

(statearr_40598_40619[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40580 === (10))){
var inst_40562 = (state_40579[(2)]);
var state_40579__$1 = state_40579;
var statearr_40599_40620 = state_40579__$1;
(statearr_40599_40620[(2)] = inst_40562);

(statearr_40599_40620[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_40580 === (8))){
var inst_40547 = (state_40579[(10)]);
var inst_40543 = (state_40579[(9)]);
var inst_40539 = (state_40579[(8)]);
var inst_40552 = inst_40539.push(inst_40543);
var tmp40596 = inst_40539;
var inst_40539__$1 = tmp40596;
var inst_40540 = inst_40547;
var state_40579__$1 = (function (){var statearr_40600 = state_40579;
(statearr_40600[(7)] = inst_40540);

(statearr_40600[(8)] = inst_40539__$1);

(statearr_40600[(14)] = inst_40552);

return statearr_40600;
})();
var statearr_40601_40621 = state_40579__$1;
(statearr_40601_40621[(2)] = null);

(statearr_40601_40621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30790__auto___40607,out))
;
return ((function (switch__30769__auto__,c__30790__auto___40607,out){
return (function() {
var cljs$core$async$state_machine__30770__auto__ = null;
var cljs$core$async$state_machine__30770__auto____0 = (function (){
var statearr_40602 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40602[(0)] = cljs$core$async$state_machine__30770__auto__);

(statearr_40602[(1)] = (1));

return statearr_40602;
});
var cljs$core$async$state_machine__30770__auto____1 = (function (state_40579){
while(true){
var ret_value__30771__auto__ = (function (){try{while(true){
var result__30772__auto__ = switch__30769__auto__.call(null,state_40579);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30772__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30772__auto__;
}
break;
}
}catch (e40603){if((e40603 instanceof Object)){
var ex__30773__auto__ = e40603;
var statearr_40604_40622 = state_40579;
(statearr_40604_40622[(5)] = ex__30773__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_40579);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e40603;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30771__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40623 = state_40579;
state_40579 = G__40623;
continue;
} else {
return ret_value__30771__auto__;
}
break;
}
});
cljs$core$async$state_machine__30770__auto__ = function(state_40579){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__30770__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__30770__auto____1.call(this,state_40579);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__30770__auto____0;
cljs$core$async$state_machine__30770__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__30770__auto____1;
return cljs$core$async$state_machine__30770__auto__;
})()
;})(switch__30769__auto__,c__30790__auto___40607,out))
})();
var state__30792__auto__ = (function (){var statearr_40605 = f__30791__auto__.call(null);
(statearr_40605[(6)] = c__30790__auto___40607);

return statearr_40605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30792__auto__);
});})(c__30790__auto___40607,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1503821286598
