// Compiled by ClojureScript 1.9.908 {}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.Uri');
goog.require('no.en.core');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__28335__auto__ = v;
if(cljs.core.truth_(and__28335__auto__)){
return (v > (0));
} else {
return and__28335__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(!(clojure.string.blank_QMARK_.call(null,s))){
return cljs.core.reduce.call(null,(function (p1__41318_SHARP_,p2__41317_SHARP_){
var vec__41319 = clojure.string.split.call(null,p2__41317_SHARP_,/=/);
var k = cljs.core.nth.call(null,vec__41319,(0),null);
var v = cljs.core.nth.call(null,vec__41319,(1),null);
return cljs.core.assoc.call(null,p1__41318_SHARP_,cljs.core.keyword.call(null,no.en.core.url_decode.call(null,k)),no.en.core.url_decode.call(null,v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(!(clojure.string.blank_QMARK_.call(null,url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"scheme","scheme",90199613),cljs.core.keyword.call(null,uri.getScheme()),new cljs.core.Keyword(null,"server-name","server-name",-1012104295),uri.getDomain(),new cljs.core.Keyword(null,"server-port","server-port",663745648),cljs_http.client.if_pos.call(null,uri.getPort()),new cljs.core.Keyword(null,"uri","uri",-774711847),uri.getPath(),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),((cljs.core.not.call(null,query_data.isEmpty()))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join(''):null),new cljs.core.Keyword(null,"query-params","query-params",900640534),((cljs.core.not.call(null,query_data.isEmpty()))?cljs_http.client.parse_query_params.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,cljs.core.name.call(null,k))),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p1__41322_SHARP_){
return cljs_http.client.encode_val.call(null,k,p1__41322_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__41323){
var vec__41324 = p__41323;
var k = cljs.core.nth.call(null,vec__41324,(0),null);
var v = cljs.core.nth.call(null,vec__41324,(1),null);
if(cljs.core.coll_QMARK_.call(null,v)){
return cljs_http.client.encode_vals.call(null,k,v);
} else {
return cljs_http.client.encode_val.call(null,k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap.call(null,esc_chars,cljs.core.map.call(null,((function (esc_chars){
return (function (p1__41327_SHARP_){
return ["\\",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__41327_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.call(null,cljs.core.str,cljs.core.replace.call(null,cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__28335__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"head","head",-771383919),request_method);
if(and__28335__auto__){
var and__28335__auto____$1 = cljs.core.not_EQ_.call(null,(204),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response));
if(and__28335__auto____$1){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,["(?i)",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs_http.client.escape_special.call(null,content_type))].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__28335__auto____$1;
}
} else {
return and__28335__auto__;
}
})())){
return cljs.core.update_in.call(null,response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669)], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"edn-params","edn-params",894273052).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/edn"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"edn-params","edn-params",894273052)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.pr_str.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__41328_SHARP_){
return cljs_http.client.decode_body.call(null,p1__41328_SHARP_,cljs.reader.read_string,"application/edn",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(var_args){
var args__29523__auto__ = [];
var len__29516__auto___41335 = arguments.length;
var i__29517__auto___41336 = (0);
while(true){
if((i__29517__auto___41336 < len__29516__auto___41335)){
args__29523__auto__.push((arguments[i__29517__auto___41336]));

var G__41337 = (i__29517__auto___41336 + (1));
i__29517__auto___41336 = G__41337;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__41331){
var vec__41332 = p__41331;
var default_headers = cljs.core.nth.call(null,vec__41332,(0),null);
return ((function (vec__41332,default_headers){
return (function (request){
var temp__4655__auto__ = (function (){var or__28347__auto__ = new cljs.core.Keyword(null,"default-headers","default-headers",-43146094).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var default_headers__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc.call(null,request,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094),default_headers__$1));
} else {
return client.call(null,request);
}
});
;})(vec__41332,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq41329){
var G__41330 = cljs.core.first.call(null,seq41329);
var seq41329__$1 = cljs.core.next.call(null,seq41329);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__41330,seq41329__$1);
});

cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(var_args){
var args__29523__auto__ = [];
var len__29516__auto___41344 = arguments.length;
var i__29517__auto___41345 = (0);
while(true){
if((i__29517__auto___41345 < len__29516__auto___41344)){
args__29523__auto__.push((arguments[i__29517__auto___41345]));

var G__41346 = (i__29517__auto___41345 + (1));
i__29517__auto___41345 = G__41346;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__41340){
var vec__41341 = p__41340;
var accept = cljs.core.nth.call(null,vec__41341,(0),null);
return ((function (vec__41341,accept){
return (function (request){
var temp__4655__auto__ = (function (){var or__28347__auto__ = new cljs.core.Keyword(null,"accept","accept",1874130431).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var accept__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"accept"], null),accept__$1));
} else {
return client.call(null,request);
}
});
;})(vec__41341,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq41338){
var G__41339 = cljs.core.first.call(null,seq41338);
var seq41338__$1 = cljs.core.next.call(null,seq41338);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__41339,seq41338__$1);
});

cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(var_args){
var args__29523__auto__ = [];
var len__29516__auto___41353 = arguments.length;
var i__29517__auto___41354 = (0);
while(true){
if((i__29517__auto___41354 < len__29516__auto___41353)){
args__29523__auto__.push((arguments[i__29517__auto___41354]));

var G__41355 = (i__29517__auto___41354 + (1));
i__29517__auto___41354 = G__41355;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__41349){
var vec__41350 = p__41349;
var content_type = cljs.core.nth.call(null,vec__41350,(0),null);
return ((function (vec__41350,content_type){
return (function (request){
var temp__4655__auto__ = (function (){var or__28347__auto__ = new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var content_type__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),content_type__$1));
} else {
return client.call(null,request);
}
});
;})(vec__41350,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq41347){
var G__41348 = cljs.core.first.call(null,seq41347);
var seq41347__$1 = cljs.core.next.call(null,seq41347);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__41348,seq41347__$1);
});

cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"decoding","decoding",-568180903),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140),cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 *   Content Type header.
 * 
 *   A :transit-opts map can be optionally provided with the following keys:
 * 
 *   :encoding                #{:json, :json-verbose}
 *   :decoding                #{:json, :json-verbose}
 *   :encoding/decoding-opts  appropriate map of options to be passed to
 *                         transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"transit-params","transit-params",357261095).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var map__41356 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__41356__$1 = ((((!((map__41356 == null)))?((((map__41356.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41356.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41356):map__41356);
var encoding = cljs.core.get.call(null,map__41356__$1,new cljs.core.Keyword(null,"encoding","encoding",1728578272));
var encoding_opts = cljs.core.get.call(null,map__41356__$1,new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631));
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/transit+json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"transit-params","transit-params",357261095)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.transit_encode.call(null,params,encoding,encoding_opts)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__41360 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__41360__$1 = ((((!((map__41360 == null)))?((((map__41360.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41360.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41360):map__41360);
var decoding = cljs.core.get.call(null,map__41360__$1,new cljs.core.Keyword(null,"decoding","decoding",-568180903));
var decoding_opts = cljs.core.get.call(null,map__41360__$1,new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140));
var transit_decode = ((function (map__41360,map__41360__$1,decoding,decoding_opts){
return (function (p1__41358_SHARP_){
return cljs_http.util.transit_decode.call(null,p1__41358_SHARP_,decoding,decoding_opts);
});})(map__41360,map__41360__$1,decoding,decoding_opts))
;
return cljs.core.async.map.call(null,((function (map__41360,map__41360__$1,decoding,decoding_opts,transit_decode){
return (function (p1__41359_SHARP_){
return cljs_http.client.decode_body.call(null,p1__41359_SHARP_,transit_decode,"application/transit+json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
});})(map__41360,map__41360__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"json-params","json-params",-1112693596).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"json-params","json-params",-1112693596)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.json_encode.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__41362_SHARP_){
return cljs_http.client.decode_body.call(null,p1__41362_SHARP_,cljs_http.util.json_decode,"application/json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__41363){
var map__41364 = p__41363;
var map__41364__$1 = ((((!((map__41364 == null)))?((((map__41364.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41364.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41364):map__41364);
var req = map__41364__$1;
var query_params = cljs.core.get.call(null,map__41364__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
if(cljs.core.truth_(query_params)){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"query-params","query-params",900640534)),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),cljs_http.client.generate_query_string.call(null,query_params)));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__41366){
var map__41367 = p__41366;
var map__41367__$1 = ((((!((map__41367 == null)))?((((map__41367.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41367.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41367):map__41367);
var request = map__41367__$1;
var form_params = cljs.core.get.call(null,map__41367__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
var request_method = cljs.core.get.call(null,map__41367__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.call(null,map__41367__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
if(cljs.core.truth_((function (){var and__28335__auto__ = form_params;
if(cljs.core.truth_(and__28335__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__28335__auto__;
}
})())){
var headers__$1 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/x-www-form-urlencoded"], null),headers);
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"form-params","form-params",1884296467)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_query_string.call(null,form_params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__41369_41379 = cljs.core.seq.call(null,params);
var chunk__41370_41380 = null;
var count__41371_41381 = (0);
var i__41372_41382 = (0);
while(true){
if((i__41372_41382 < count__41371_41381)){
var vec__41373_41383 = cljs.core._nth.call(null,chunk__41370_41380,i__41372_41382);
var k_41384 = cljs.core.nth.call(null,vec__41373_41383,(0),null);
var v_41385 = cljs.core.nth.call(null,vec__41373_41383,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_41385)){
form_data.append(cljs.core.name.call(null,k_41384),cljs.core.first.call(null,v_41385),cljs.core.second.call(null,v_41385));
} else {
form_data.append(cljs.core.name.call(null,k_41384),v_41385);
}

var G__41386 = seq__41369_41379;
var G__41387 = chunk__41370_41380;
var G__41388 = count__41371_41381;
var G__41389 = (i__41372_41382 + (1));
seq__41369_41379 = G__41386;
chunk__41370_41380 = G__41387;
count__41371_41381 = G__41388;
i__41372_41382 = G__41389;
continue;
} else {
var temp__4657__auto___41390 = cljs.core.seq.call(null,seq__41369_41379);
if(temp__4657__auto___41390){
var seq__41369_41391__$1 = temp__4657__auto___41390;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__41369_41391__$1)){
var c__29186__auto___41392 = cljs.core.chunk_first.call(null,seq__41369_41391__$1);
var G__41393 = cljs.core.chunk_rest.call(null,seq__41369_41391__$1);
var G__41394 = c__29186__auto___41392;
var G__41395 = cljs.core.count.call(null,c__29186__auto___41392);
var G__41396 = (0);
seq__41369_41379 = G__41393;
chunk__41370_41380 = G__41394;
count__41371_41381 = G__41395;
i__41372_41382 = G__41396;
continue;
} else {
var vec__41376_41397 = cljs.core.first.call(null,seq__41369_41391__$1);
var k_41398 = cljs.core.nth.call(null,vec__41376_41397,(0),null);
var v_41399 = cljs.core.nth.call(null,vec__41376_41397,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_41399)){
form_data.append(cljs.core.name.call(null,k_41398),cljs.core.first.call(null,v_41399),cljs.core.second.call(null,v_41399));
} else {
form_data.append(cljs.core.name.call(null,k_41398),v_41399);
}

var G__41400 = cljs.core.next.call(null,seq__41369_41391__$1);
var G__41401 = null;
var G__41402 = (0);
var G__41403 = (0);
seq__41369_41379 = G__41400;
chunk__41370_41380 = G__41401;
count__41371_41381 = G__41402;
i__41372_41382 = G__41403;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__41404){
var map__41405 = p__41404;
var map__41405__$1 = ((((!((map__41405 == null)))?((((map__41405.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41405.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41405):map__41405);
var request = map__41405__$1;
var multipart_params = cljs.core.get.call(null,map__41405__$1,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707));
var request_method = cljs.core.get.call(null,map__41405__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core.truth_((function (){var and__28335__auto__ = multipart_params;
if(cljs.core.truth_(and__28335__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__28335__auto__;
}
})())){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_form_data.call(null,multipart_params)));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4655__auto__ = new cljs.core.Keyword(null,"method","method",55703592).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var m = temp__4655__auto__;
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"method","method",55703592)),new cljs.core.Keyword(null,"request-method","request-method",1764796830),m));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__41407_SHARP_){
return client.call(null,cljs.core.assoc.call(null,p1__41407_SHARP_,new cljs.core.Keyword(null,"server-name","server-name",-1012104295),server_name));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__41409){
var map__41410 = p__41409;
var map__41410__$1 = ((((!((map__41410 == null)))?((((map__41410.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41410.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__41410):map__41410);
var req = map__41410__$1;
var query_params = cljs.core.get.call(null,map__41410__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
var temp__4655__auto__ = cljs_http.client.parse_url.call(null,new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4655__auto__)){
var spec = temp__4655__auto__;
return client.call(null,cljs.core.update_in.call(null,cljs.core.dissoc.call(null,cljs.core.merge.call(null,req,spec),new cljs.core.Keyword(null,"url","url",276297046)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534)], null),((function (spec,temp__4655__auto__,map__41410,map__41410__$1,req,query_params){
return (function (p1__41408_SHARP_){
return cljs.core.merge.call(null,p1__41408_SHARP_,query_params);
});})(spec,temp__4655__auto__,map__41410,map__41410__$1,req,query_params))
));
} else {
return client.call(null,req);
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 *   an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(var_args){
var args__29523__auto__ = [];
var len__29516__auto___41418 = arguments.length;
var i__29517__auto___41419 = (0);
while(true){
if((i__29517__auto___41419 < len__29516__auto___41418)){
args__29523__auto__.push((arguments[i__29517__auto___41419]));

var G__41420 = (i__29517__auto___41419 + (1));
i__29517__auto___41419 = G__41420;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__41414){
var vec__41415 = p__41414;
var credentials = cljs.core.nth.call(null,vec__41415,(0),null);
return ((function (vec__41415,credentials){
return (function (req){
var credentials__$1 = (function (){var or__28347__auto__ = new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_.call(null,credentials__$1))){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),cljs_http.util.basic_auth.call(null,credentials__$1)));
} else {
return client.call(null,req);
}
});
;})(vec__41415,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq41412){
var G__41413 = cljs.core.first.call(null,seq41412);
var seq41412__$1 = cljs.core.next.call(null,seq41412);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__41413,seq41412__$1);
});

/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4655__auto__ = new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var oauth_token = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(oauth_token)].join('')));
} else {
return client.call(null,req);
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var custom_channel = temp__4655__auto__;
return cljs.core.async.pipe.call(null,client.call(null,request),custom_channel);
} else {
return client.call(null,request);
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers.call(null,cljs_http.client.wrap_channel_from_request_map.call(null,cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_json_response.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_transit_response.call(null,cljs_http.client.wrap_transit_params.call(null,cljs_http.client.wrap_edn_response.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_multipart_params.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request.call(null,cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(var_args){
var args__29523__auto__ = [];
var len__29516__auto___41427 = arguments.length;
var i__29517__auto___41428 = (0);
while(true){
if((i__29517__auto___41428 < len__29516__auto___41427)){
args__29523__auto__.push((arguments[i__29517__auto___41428]));

var G__41429 = (i__29517__auto___41428 + (1));
i__29517__auto___41428 = G__41429;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__41423){
var vec__41424 = p__41423;
var req = cljs.core.nth.call(null,vec__41424,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq41421){
var G__41422 = cljs.core.first.call(null,seq41421);
var seq41421__$1 = cljs.core.next.call(null,seq41421);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__41422,seq41421__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(var_args){
var args__29523__auto__ = [];
var len__29516__auto___41436 = arguments.length;
var i__29517__auto___41437 = (0);
while(true){
if((i__29517__auto___41437 < len__29516__auto___41436)){
args__29523__auto__.push((arguments[i__29517__auto___41437]));

var G__41438 = (i__29517__auto___41437 + (1));
i__29517__auto___41437 = G__41438;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__41432){
var vec__41433 = p__41432;
var req = cljs.core.nth.call(null,vec__41433,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq41430){
var G__41431 = cljs.core.first.call(null,seq41430);
var seq41430__$1 = cljs.core.next.call(null,seq41430);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__41431,seq41430__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(var_args){
var args__29523__auto__ = [];
var len__29516__auto___41445 = arguments.length;
var i__29517__auto___41446 = (0);
while(true){
if((i__29517__auto___41446 < len__29516__auto___41445)){
args__29523__auto__.push((arguments[i__29517__auto___41446]));

var G__41447 = (i__29517__auto___41446 + (1));
i__29517__auto___41446 = G__41447;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__41441){
var vec__41442 = p__41441;
var req = cljs.core.nth.call(null,vec__41442,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"head","head",-771383919),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq41439){
var G__41440 = cljs.core.first.call(null,seq41439);
var seq41439__$1 = cljs.core.next.call(null,seq41439);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__41440,seq41439__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(var_args){
var args__29523__auto__ = [];
var len__29516__auto___41454 = arguments.length;
var i__29517__auto___41455 = (0);
while(true){
if((i__29517__auto___41455 < len__29516__auto___41454)){
args__29523__auto__.push((arguments[i__29517__auto___41455]));

var G__41456 = (i__29517__auto___41455 + (1));
i__29517__auto___41455 = G__41456;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__41450){
var vec__41451 = p__41450;
var req = cljs.core.nth.call(null,vec__41451,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"jsonp","jsonp",226119588),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq41448){
var G__41449 = cljs.core.first.call(null,seq41448);
var seq41448__$1 = cljs.core.next.call(null,seq41448);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__41449,seq41448__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(var_args){
var args__29523__auto__ = [];
var len__29516__auto___41463 = arguments.length;
var i__29517__auto___41464 = (0);
while(true){
if((i__29517__auto___41464 < len__29516__auto___41463)){
args__29523__auto__.push((arguments[i__29517__auto___41464]));

var G__41465 = (i__29517__auto___41464 + (1));
i__29517__auto___41464 = G__41465;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__41459){
var vec__41460 = p__41459;
var req = cljs.core.nth.call(null,vec__41460,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"move","move",-2110884309),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq41457){
var G__41458 = cljs.core.first.call(null,seq41457);
var seq41457__$1 = cljs.core.next.call(null,seq41457);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__41458,seq41457__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(var_args){
var args__29523__auto__ = [];
var len__29516__auto___41472 = arguments.length;
var i__29517__auto___41473 = (0);
while(true){
if((i__29517__auto___41473 < len__29516__auto___41472)){
args__29523__auto__.push((arguments[i__29517__auto___41473]));

var G__41474 = (i__29517__auto___41473 + (1));
i__29517__auto___41473 = G__41474;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__41468){
var vec__41469 = p__41468;
var req = cljs.core.nth.call(null,vec__41469,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq41466){
var G__41467 = cljs.core.first.call(null,seq41466);
var seq41466__$1 = cljs.core.next.call(null,seq41466);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__41467,seq41466__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(var_args){
var args__29523__auto__ = [];
var len__29516__auto___41481 = arguments.length;
var i__29517__auto___41482 = (0);
while(true){
if((i__29517__auto___41482 < len__29516__auto___41481)){
args__29523__auto__.push((arguments[i__29517__auto___41482]));

var G__41483 = (i__29517__auto___41482 + (1));
i__29517__auto___41482 = G__41483;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__41477){
var vec__41478 = p__41477;
var req = cljs.core.nth.call(null,vec__41478,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq41475){
var G__41476 = cljs.core.first.call(null,seq41475);
var seq41475__$1 = cljs.core.next.call(null,seq41475);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__41476,seq41475__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(var_args){
var args__29523__auto__ = [];
var len__29516__auto___41490 = arguments.length;
var i__29517__auto___41491 = (0);
while(true){
if((i__29517__auto___41491 < len__29516__auto___41490)){
args__29523__auto__.push((arguments[i__29517__auto___41491]));

var G__41492 = (i__29517__auto___41491 + (1));
i__29517__auto___41491 = G__41492;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__41486){
var vec__41487 = p__41486;
var req = cljs.core.nth.call(null,vec__41487,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq41484){
var G__41485 = cljs.core.first.call(null,seq41484);
var seq41484__$1 = cljs.core.next.call(null,seq41484);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__41485,seq41484__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(var_args){
var args__29523__auto__ = [];
var len__29516__auto___41499 = arguments.length;
var i__29517__auto___41500 = (0);
while(true){
if((i__29517__auto___41500 < len__29516__auto___41499)){
args__29523__auto__.push((arguments[i__29517__auto___41500]));

var G__41501 = (i__29517__auto___41500 + (1));
i__29517__auto___41500 = G__41501;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__41495){
var vec__41496 = p__41495;
var req = cljs.core.nth.call(null,vec__41496,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq41493){
var G__41494 = cljs.core.first.call(null,seq41493);
var seq41493__$1 = cljs.core.next.call(null,seq41493);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__41494,seq41493__$1);
});


//# sourceMappingURL=client.js.map?rel=1503821288366
