// Compiled by ClojureScript 1.9.908 {}
goog.provide('cmr.client.common.util');
goog.require('cljs.core');
goog.require('cmr.client.common.const$');
goog.require('cljs.core.async');
cmr.client.common.util.default_environment_type = new cljs.core.Keyword(null,"prod","prod",1846120297);
cmr.client.common.util.get_endpoint = (function cmr$client$common$util$get_endpoint(environment_type,service_key){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(environment_type.call(null,cmr.client.common.const$.hosts)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,cmr.client.common.const$.endpoints,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[service_key,environment_type.call(null,cmr.client.common.const$.deployment_type)],null))))].join('');
});
cmr.client.common.util.get_default_endpoint = (function cmr$client$common$util$get_default_endpoint(options,service_key){
var or__28347__auto__ = new cljs.core.Keyword(null,"endpoint","endpoint",447890044).cljs$core$IFn$_invoke$arity$1(options);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return cmr.client.common.util.get_endpoint.call(null,cmr.client.common.util.default_environment_type,service_key);
}
});
cmr.client.common.util.parse_endpoint = (function cmr$client$common$util$parse_endpoint(var_args){
var G__37842 = arguments.length;
switch (G__37842) {
case 1:
return cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$1 = (function (endpoint){
return cmr.client.common.util.parse_endpoint.call(null,endpoint,null);
});

cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$2 = (function (endpoint,service_key){
if(typeof endpoint === 'string'){
return endpoint;
} else {
return cmr.client.common.util.get_endpoint.call(null,endpoint,service_key);
}
});

cmr.client.common.util.parse_endpoint.cljs$lang$maxFixedArity = 2;

cmr.client.common.util.with_callback = (function cmr$client$common$util$with_callback(chan,callback){
var c__31292__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31292__auto__){
return (function (){
var f__31293__auto__ = (function (){var switch__31271__auto__ = ((function (c__31292__auto__){
return (function (state_37856){
var state_val_37857 = (state_37856[(1)]);
if((state_val_37857 === (1))){
var state_37856__$1 = state_37856;
var statearr_37858_37869 = state_37856__$1;
(statearr_37858_37869[(2)] = null);

(statearr_37858_37869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37857 === (2))){
var state_37856__$1 = state_37856;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37856__$1,(4),chan);
} else {
if((state_val_37857 === (3))){
var inst_37854 = (state_37856[(2)]);
var state_37856__$1 = state_37856;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37856__$1,inst_37854);
} else {
if((state_val_37857 === (4))){
var inst_37846 = (state_37856[(7)]);
var inst_37846__$1 = (state_37856[(2)]);
var state_37856__$1 = (function (){var statearr_37859 = state_37856;
(statearr_37859[(7)] = inst_37846__$1);

return statearr_37859;
})();
if(cljs.core.truth_(inst_37846__$1)){
var statearr_37860_37870 = state_37856__$1;
(statearr_37860_37870[(1)] = (5));

} else {
var statearr_37861_37871 = state_37856__$1;
(statearr_37861_37871[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37857 === (5))){
var inst_37846 = (state_37856[(7)]);
var inst_37848 = callback.call(null,inst_37846);
var state_37856__$1 = state_37856;
var statearr_37862_37872 = state_37856__$1;
(statearr_37862_37872[(2)] = inst_37848);

(statearr_37862_37872[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37857 === (6))){
var state_37856__$1 = state_37856;
var statearr_37863_37873 = state_37856__$1;
(statearr_37863_37873[(2)] = null);

(statearr_37863_37873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37857 === (7))){
var inst_37852 = (state_37856[(2)]);
var state_37856__$1 = state_37856;
var statearr_37864_37874 = state_37856__$1;
(statearr_37864_37874[(2)] = inst_37852);

(statearr_37864_37874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__31292__auto__))
;
return ((function (switch__31271__auto__,c__31292__auto__){
return (function() {
var cmr$client$common$util$with_callback_$_state_machine__31272__auto__ = null;
var cmr$client$common$util$with_callback_$_state_machine__31272__auto____0 = (function (){
var statearr_37865 = [null,null,null,null,null,null,null,null];
(statearr_37865[(0)] = cmr$client$common$util$with_callback_$_state_machine__31272__auto__);

(statearr_37865[(1)] = (1));

return statearr_37865;
});
var cmr$client$common$util$with_callback_$_state_machine__31272__auto____1 = (function (state_37856){
while(true){
var ret_value__31273__auto__ = (function (){try{while(true){
var result__31274__auto__ = switch__31271__auto__.call(null,state_37856);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31274__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31274__auto__;
}
break;
}
}catch (e37866){if((e37866 instanceof Object)){
var ex__31275__auto__ = e37866;
var statearr_37867_37875 = state_37856;
(statearr_37867_37875[(5)] = ex__31275__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_37856);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e37866;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31273__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37876 = state_37856;
state_37856 = G__37876;
continue;
} else {
return ret_value__31273__auto__;
}
break;
}
});
cmr$client$common$util$with_callback_$_state_machine__31272__auto__ = function(state_37856){
switch(arguments.length){
case 0:
return cmr$client$common$util$with_callback_$_state_machine__31272__auto____0.call(this);
case 1:
return cmr$client$common$util$with_callback_$_state_machine__31272__auto____1.call(this,state_37856);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cmr$client$common$util$with_callback_$_state_machine__31272__auto__.cljs$core$IFn$_invoke$arity$0 = cmr$client$common$util$with_callback_$_state_machine__31272__auto____0;
cmr$client$common$util$with_callback_$_state_machine__31272__auto__.cljs$core$IFn$_invoke$arity$1 = cmr$client$common$util$with_callback_$_state_machine__31272__auto____1;
return cmr$client$common$util$with_callback_$_state_machine__31272__auto__;
})()
;})(switch__31271__auto__,c__31292__auto__))
})();
var state__31294__auto__ = (function (){var statearr_37868 = f__31293__auto__.call(null);
(statearr_37868[(6)] = c__31292__auto__);

return statearr_37868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31294__auto__);
});})(c__31292__auto__))
);

return c__31292__auto__;
});
goog.exportSymbol('cmr.client.common.util.with_callback', cmr.client.common.util.with_callback);
/**
 * This is a utility function that returns a function for creating clients of
 *   a particular type, e.g., ingest, search, or access-control clients.
 * 
 *   The arguments details are as follows:
 * 
 *   * `service-type` - must be one of the supported service types, notably
 *  `:ingest`, `:search`, or `:access-control`
 *   * `client-constructor-var` - this is the var of that is assigned the value of
 *  the call to `create-service-client-constructor`; it is passed so that the
 *  anonymous function below has something to refer to in support of multiple
 *  arities
 *   * `client-data-constructor` - this is the constrcutor for the record that is
 *  used for the implementation of the protocol (that which is extended)
 *   * `options-fn` - a functin which creates the client client options, including
 *  basic defaults, for the implementation; it should be a function that in
 *  turn calls a `CMR*ClientOpions` constructor
 *   * `http-client-constructor` - a function that instrantiates the CMR HTTP
 *  client used by all CMR service type clients (different for Clojure and
 *  ClojureScript)
 * 
 *   This docstring is a bit dense; for more clarity, be sure to view the calls
 *   made to this function in both the Clojure and ClojureScript clients.
 */
cmr.client.common.util.create_service_client_constructor = (function cmr$client$common$util$create_service_client_constructor(servie_type,client_constructor_var,client_data_constructor,options_fn,http_client_constructor){
return (function() {
var G__37877 = null;
var G__37877__0 = (function (){
return client_constructor_var.call(null,cljs.core.PersistentArrayMap.EMPTY);
});
var G__37877__1 = (function (options){
return client_constructor_var.call(null,options,cljs.core.PersistentArrayMap.EMPTY);
});
var G__37877__2 = (function (options,http_options){
var endpoint = cmr.client.common.util.get_default_endpoint.call(null,options,servie_type);
var client_options = options_fn.call(null,options);
var http_client = http_client_constructor.call(null,client_options,http_options);
return client_data_constructor.call(null,cmr.client.common.util.parse_endpoint.call(null,endpoint,servie_type),client_options,http_client);
});
G__37877 = function(options,http_options){
switch(arguments.length){
case 0:
return G__37877__0.call(this);
case 1:
return G__37877__1.call(this,options);
case 2:
return G__37877__2.call(this,options,http_options);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__37877.cljs$core$IFn$_invoke$arity$0 = G__37877__0;
G__37877.cljs$core$IFn$_invoke$arity$1 = G__37877__1;
G__37877.cljs$core$IFn$_invoke$arity$2 = G__37877__2;
return G__37877;
})()
});
/**
 * This is a utility function that returns a function for creating clients of
 *   a particular type, e.g., ingest, search, or access-control clients.
 * 
 *   The arguments details are as follows:
 * 
 *   * `client-constructor-var` - this is the var of that is assigned the value of
 *  the call to `create-service-client-constructor`; it is passed so that the
 *  anonymous function below has something to refer to in support of multiple
 *  arities
 *   * `client-data-constructor` - this is the constrcutor for the record that is
 *  used for the implementation of the protocol (that which is extended)
 */
cmr.client.common.util.create_http_client_constructor = (function cmr$client$common$util$create_http_client_constructor(client_constructor_var,client_data_constructor){
return (function() {
var G__37878 = null;
var G__37878__0 = (function (){
return client_constructor_var.call(null,cljs.core.PersistentArrayMap.EMPTY);
});
var G__37878__1 = (function (http_options){
return client_constructor_var.call(null,cljs.core.PersistentArrayMap.EMPTY,http_options);
});
var G__37878__2 = (function (parent_client_options,http_options){
return client_data_constructor.call(null,parent_client_options,http_options);
});
G__37878 = function(parent_client_options,http_options){
switch(arguments.length){
case 0:
return G__37878__0.call(this);
case 1:
return G__37878__1.call(this,parent_client_options);
case 2:
return G__37878__2.call(this,parent_client_options,http_options);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__37878.cljs$core$IFn$_invoke$arity$0 = G__37878__0;
G__37878.cljs$core$IFn$_invoke$arity$1 = G__37878__1;
G__37878.cljs$core$IFn$_invoke$arity$2 = G__37878__2;
return G__37878;
})()
});
var ret__29556__auto___37879 = /**
 * Import a single function or var:
 *   ```clj
 *   (import-def a b) => (def b a/b)
 *   ```
 */
cmr.client.common.util.import_def = (function cmr$client$common$util$import_def(_AMPERSAND_form,_AMPERSAND_env,from_ns,def_name){
var from_sym_SHARP_ = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(from_ns)].join(''),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(def_name)].join(''));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"def","def",597100991,null)),(function (){var x__29209__auto__ = def_name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29209__auto__);
})(),(function (){var x__29209__auto__ = from_sym_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29209__auto__);
})())));
});
cmr.client.common.util.import_def.cljs$lang$macro = true;

var ret__29556__auto___37892 = (function (){
/**
 * Import multiple defs from multiple namespaces.
 * 
 * This works for vars and functions, but not macros. Uses the same syntax as
 * `potemkin.namespaces/import-vars`, namely:
 * ```clj
 * (import-vars
 *   [m.n.ns1 a b]
 *   [x.y.ns2 d e f])
 *   ```
 */
cmr.client.common.util.import_vars = (function cmr$client$common$util$import_vars(var_args){
var args__29523__auto__ = [];
var len__29516__auto___37893 = arguments.length;
var i__29517__auto___37894 = (0);
while(true){
if((i__29517__auto___37894 < len__29516__auto___37893)){
args__29523__auto__.push((arguments[i__29517__auto___37894]));

var G__37895 = (i__29517__auto___37894 + (1));
i__29517__auto___37894 = G__37895;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((2) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((2)),(0),null)):null);
return cmr.client.common.util.import_vars.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29524__auto__);
});

cmr.client.common.util.import_vars.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,imports){
var expanded_imports = (function (){var iter__29155__auto__ = (function cmr$client$common$util$iter__37883(s__37884){
return (new cljs.core.LazySeq(null,(function (){
var s__37884__$1 = s__37884;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__37884__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var vec__37889 = cljs.core.first.call(null,xs__5205__auto__);
var seq__37890 = cljs.core.seq.call(null,vec__37889);
var first__37891 = cljs.core.first.call(null,seq__37890);
var seq__37890__$1 = cljs.core.next.call(null,seq__37890);
var from_ns = first__37891;
var defs = seq__37890__$1;
var iterys__29151__auto__ = ((function (s__37884__$1,vec__37889,seq__37890,first__37891,seq__37890__$1,from_ns,defs,xs__5205__auto__,temp__4657__auto__){
return (function cmr$client$common$util$iter__37883_$_iter__37885(s__37886){
return (new cljs.core.LazySeq(null,((function (s__37884__$1,vec__37889,seq__37890,first__37891,seq__37890__$1,from_ns,defs,xs__5205__auto__,temp__4657__auto__){
return (function (){
var s__37886__$1 = s__37886;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__37886__$1);
if(temp__4657__auto____$1){
var s__37886__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37886__$2)){
var c__29153__auto__ = cljs.core.chunk_first.call(null,s__37886__$2);
var size__29154__auto__ = cljs.core.count.call(null,c__29153__auto__);
var b__37888 = cljs.core.chunk_buffer.call(null,size__29154__auto__);
if((function (){var i__37887 = (0);
while(true){
if((i__37887 < size__29154__auto__)){
var d = cljs.core._nth.call(null,c__29153__auto__,i__37887);
cljs.core.chunk_append.call(null,b__37888,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cmr.client.common.util","import-def","cmr.client.common.util/import-def",708150912,null)),(function (){var x__29209__auto__ = from_ns;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29209__auto__);
})(),(function (){var x__29209__auto__ = d;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29209__auto__);
})()))));

var G__37896 = (i__37887 + (1));
i__37887 = G__37896;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37888),cmr$client$common$util$iter__37883_$_iter__37885.call(null,cljs.core.chunk_rest.call(null,s__37886__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37888),null);
}
} else {
var d = cljs.core.first.call(null,s__37886__$2);
return cljs.core.cons.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cmr.client.common.util","import-def","cmr.client.common.util/import-def",708150912,null)),(function (){var x__29209__auto__ = from_ns;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29209__auto__);
})(),(function (){var x__29209__auto__ = d;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29209__auto__);
})()))),cmr$client$common$util$iter__37883_$_iter__37885.call(null,cljs.core.rest.call(null,s__37886__$2)));
}
} else {
return null;
}
break;
}
});})(s__37884__$1,vec__37889,seq__37890,first__37891,seq__37890__$1,from_ns,defs,xs__5205__auto__,temp__4657__auto__))
,null,null));
});})(s__37884__$1,vec__37889,seq__37890,first__37891,seq__37890__$1,from_ns,defs,xs__5205__auto__,temp__4657__auto__))
;
var fs__29152__auto__ = cljs.core.seq.call(null,iterys__29151__auto__.call(null,defs));
if(fs__29152__auto__){
return cljs.core.concat.call(null,fs__29152__auto__,cmr$client$common$util$iter__37883.call(null,cljs.core.rest.call(null,s__37884__$1)));
} else {
var G__37897 = cljs.core.rest.call(null,s__37884__$1);
s__37884__$1 = G__37897;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__29155__auto__.call(null,imports);
})();
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),expanded_imports)));
});

cmr.client.common.util.import_vars.cljs$lang$maxFixedArity = (2);

cmr.client.common.util.import_vars.cljs$lang$applyTo = (function (seq37880){
var G__37881 = cljs.core.first.call(null,seq37880);
var seq37880__$1 = cljs.core.next.call(null,seq37880);
var G__37882 = cljs.core.first.call(null,seq37880__$1);
var seq37880__$2 = cljs.core.next.call(null,seq37880__$1);
return cmr.client.common.util.import_vars.cljs$core$IFn$_invoke$arity$variadic(G__37881,G__37882,seq37880__$2);
});

return null;
})()
;
cmr.client.common.util.import_vars.cljs$lang$macro = true;


//# sourceMappingURL=util.js.map?rel=1503892840989
