// Compiled by ClojureScript 1.9.908 {}
goog.provide('cmr.client.common.util');
goog.require('cljs.core');
goog.require('cmr.client.common.const$');
goog.require('cljs.core.async');
/**
 * Get the default endpoint for a given CMR service. If an environment type
 *   is provided, override the default and get the endpoint for that type.
 */
cmr.client.common.util.get_endpoint = (function cmr$client$common$util$get_endpoint(var_args){
var G__43409 = arguments.length;
switch (G__43409) {
case 1:
return cmr.client.common.util.get_endpoint.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cmr.client.common.util.get_endpoint.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cmr.client.common.util.get_endpoint.cljs$core$IFn$_invoke$arity$1 = (function (service_key){
return service_key.call(null,cmr.client.common.const$.default_endpoints);
});

cmr.client.common.util.get_endpoint.cljs$core$IFn$_invoke$arity$2 = (function (environment_type,service_key){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(environment_type.call(null,cmr.client.common.const$.hosts)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,cmr.client.common.const$.endpoints,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[service_key,environment_type.call(null,cmr.client.common.const$.deployment_type)],null))))].join('');
});

cmr.client.common.util.get_endpoint.cljs$lang$maxFixedArity = 2;

/**
 * Get the default endpoint; if the client options specify an endpoint, then
 *   use that one.
 */
cmr.client.common.util.get_default_endpoint = (function cmr$client$common$util$get_default_endpoint(options,service_key){
var or__28347__auto__ = new cljs.core.Keyword(null,"endpoint","endpoint",447890044).cljs$core$IFn$_invoke$arity$1(options);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return cmr.client.common.util.get_endpoint.call(null,service_key);
}
});
/**
 * Given a string or a deployment environment and a service key, retur the
 *   service endpoint.
 */
cmr.client.common.util.parse_endpoint = (function cmr$client$common$util$parse_endpoint(var_args){
var G__43412 = arguments.length;
switch (G__43412) {
case 1:
return cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$1 = (function (endpoint){
return cmr.client.common.util.parse_endpoint.call(null,endpoint,null);
});

cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$2 = (function (endpoint,service_key){
if(typeof endpoint === 'string'){
return endpoint;
} else {
return cmr.client.common.util.get_endpoint.call(null,endpoint,service_key);
}
});

cmr.client.common.util.parse_endpoint.cljs$lang$maxFixedArity = 2;

/**
 * A utility function for running a callback function when a channel receives
 *   data.
 */
cmr.client.common.util.with_callback = (function cmr$client$common$util$with_callback(chan,callback){
var c__30825__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30825__auto__){
return (function (){
var f__30826__auto__ = (function (){var switch__30804__auto__ = ((function (c__30825__auto__){
return (function (state_43426){
var state_val_43427 = (state_43426[(1)]);
if((state_val_43427 === (1))){
var state_43426__$1 = state_43426;
var statearr_43428_43439 = state_43426__$1;
(statearr_43428_43439[(2)] = null);

(statearr_43428_43439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43427 === (2))){
var state_43426__$1 = state_43426;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_43426__$1,(4),chan);
} else {
if((state_val_43427 === (3))){
var inst_43424 = (state_43426[(2)]);
var state_43426__$1 = state_43426;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_43426__$1,inst_43424);
} else {
if((state_val_43427 === (4))){
var inst_43416 = (state_43426[(7)]);
var inst_43416__$1 = (state_43426[(2)]);
var state_43426__$1 = (function (){var statearr_43429 = state_43426;
(statearr_43429[(7)] = inst_43416__$1);

return statearr_43429;
})();
if(cljs.core.truth_(inst_43416__$1)){
var statearr_43430_43440 = state_43426__$1;
(statearr_43430_43440[(1)] = (5));

} else {
var statearr_43431_43441 = state_43426__$1;
(statearr_43431_43441[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43427 === (5))){
var inst_43416 = (state_43426[(7)]);
var inst_43418 = callback.call(null,inst_43416);
var state_43426__$1 = state_43426;
var statearr_43432_43442 = state_43426__$1;
(statearr_43432_43442[(2)] = inst_43418);

(statearr_43432_43442[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43427 === (6))){
var state_43426__$1 = state_43426;
var statearr_43433_43443 = state_43426__$1;
(statearr_43433_43443[(2)] = null);

(statearr_43433_43443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_43427 === (7))){
var inst_43422 = (state_43426[(2)]);
var state_43426__$1 = state_43426;
var statearr_43434_43444 = state_43426__$1;
(statearr_43434_43444[(2)] = inst_43422);

(statearr_43434_43444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__30825__auto__))
;
return ((function (switch__30804__auto__,c__30825__auto__){
return (function() {
var cmr$client$common$util$with_callback_$_state_machine__30805__auto__ = null;
var cmr$client$common$util$with_callback_$_state_machine__30805__auto____0 = (function (){
var statearr_43435 = [null,null,null,null,null,null,null,null];
(statearr_43435[(0)] = cmr$client$common$util$with_callback_$_state_machine__30805__auto__);

(statearr_43435[(1)] = (1));

return statearr_43435;
});
var cmr$client$common$util$with_callback_$_state_machine__30805__auto____1 = (function (state_43426){
while(true){
var ret_value__30806__auto__ = (function (){try{while(true){
var result__30807__auto__ = switch__30804__auto__.call(null,state_43426);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30807__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30807__auto__;
}
break;
}
}catch (e43436){if((e43436 instanceof Object)){
var ex__30808__auto__ = e43436;
var statearr_43437_43445 = state_43426;
(statearr_43437_43445[(5)] = ex__30808__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_43426);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e43436;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30806__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__43446 = state_43426;
state_43426 = G__43446;
continue;
} else {
return ret_value__30806__auto__;
}
break;
}
});
cmr$client$common$util$with_callback_$_state_machine__30805__auto__ = function(state_43426){
switch(arguments.length){
case 0:
return cmr$client$common$util$with_callback_$_state_machine__30805__auto____0.call(this);
case 1:
return cmr$client$common$util$with_callback_$_state_machine__30805__auto____1.call(this,state_43426);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cmr$client$common$util$with_callback_$_state_machine__30805__auto__.cljs$core$IFn$_invoke$arity$0 = cmr$client$common$util$with_callback_$_state_machine__30805__auto____0;
cmr$client$common$util$with_callback_$_state_machine__30805__auto__.cljs$core$IFn$_invoke$arity$1 = cmr$client$common$util$with_callback_$_state_machine__30805__auto____1;
return cmr$client$common$util$with_callback_$_state_machine__30805__auto__;
})()
;})(switch__30804__auto__,c__30825__auto__))
})();
var state__30827__auto__ = (function (){var statearr_43438 = f__30826__auto__.call(null);
(statearr_43438[(6)] = c__30825__auto__);

return statearr_43438;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30827__auto__);
});})(c__30825__auto__))
);

return c__30825__auto__;
});
goog.exportSymbol('cmr.client.common.util.with_callback', cmr.client.common.util.with_callback);
/**
 * This is a utility function that returns a function for creating clients of
 *   a particular type, e.g., ingest, search, or access-control clients.
 * 
 *   The arguments details are as follows:
 * 
 *   * `service-type` - must be one of the supported service types, notably
 *  `:ingest`, `:search`, or `:access-control`
 *   * `client-constructor-var` - this is the var of that is assigned the value of
 *  the call to `create-service-client-constructor`; it is passed so that the
 *  anonymous function below has something to refer to in support of multiple
 *  arities
 *   * `client-data-constructor` - this is the constrcutor for the record that is
 *  used for the implementation of the protocol (that which is extended)
 *   * `options-fn` - a functin which creates the client client options, including
 *  basic defaults, for the implementation; it should be a function that in
 *  turn calls a `CMR*ClientOpions` constructor
 *   * `http-client-constructor` - a function that instrantiates the CMR HTTP
 *  client used by all CMR service type clients (different for Clojure and
 *  ClojureScript)
 * 
 *   This docstring is a bit dense; for more clarity, be sure to view the calls
 *   made to this function in both the Clojure and ClojureScript clients.
 */
cmr.client.common.util.create_service_client_constructor = (function cmr$client$common$util$create_service_client_constructor(servie_type,client_constructor_var,client_data_constructor,options_fn,http_client_constructor){
return (function() {
var G__43447 = null;
var G__43447__0 = (function (){
return client_constructor_var.call(null,cljs.core.PersistentArrayMap.EMPTY);
});
var G__43447__1 = (function (options){
return client_constructor_var.call(null,options,cljs.core.PersistentArrayMap.EMPTY);
});
var G__43447__2 = (function (options,http_options){
var endpoint = cmr.client.common.util.get_default_endpoint.call(null,options,servie_type);
var client_options = options_fn.call(null,options);
var http_client = http_client_constructor.call(null,client_options,http_options);
return client_data_constructor.call(null,cmr.client.common.util.parse_endpoint.call(null,endpoint,servie_type),client_options,http_client);
});
G__43447 = function(options,http_options){
switch(arguments.length){
case 0:
return G__43447__0.call(this);
case 1:
return G__43447__1.call(this,options);
case 2:
return G__43447__2.call(this,options,http_options);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__43447.cljs$core$IFn$_invoke$arity$0 = G__43447__0;
G__43447.cljs$core$IFn$_invoke$arity$1 = G__43447__1;
G__43447.cljs$core$IFn$_invoke$arity$2 = G__43447__2;
return G__43447;
})()
});
/**
 * This is a utility function that returns a function for creating clients of
 *   a particular type, e.g., ingest, search, or access-control clients.
 * 
 *   The arguments details are as follows:
 * 
 *   * `client-constructor-var` - this is the var of that is assigned the value of
 *  the call to `create-service-client-constructor`; it is passed so that the
 *  anonymous function below has something to refer to in support of multiple
 *  arities
 *   * `client-data-constructor` - this is the constrcutor for the record that is
 *  used for the implementation of the protocol (that which is extended)
 */
cmr.client.common.util.create_http_client_constructor = (function cmr$client$common$util$create_http_client_constructor(client_constructor_var,client_data_constructor){
return (function() {
var G__43448 = null;
var G__43448__0 = (function (){
return client_constructor_var.call(null,cljs.core.PersistentArrayMap.EMPTY);
});
var G__43448__1 = (function (http_options){
return client_constructor_var.call(null,cljs.core.PersistentArrayMap.EMPTY,http_options);
});
var G__43448__2 = (function (parent_client_options,http_options){
return client_data_constructor.call(null,parent_client_options,http_options);
});
G__43448 = function(parent_client_options,http_options){
switch(arguments.length){
case 0:
return G__43448__0.call(this);
case 1:
return G__43448__1.call(this,parent_client_options);
case 2:
return G__43448__2.call(this,parent_client_options,http_options);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__43448.cljs$core$IFn$_invoke$arity$0 = G__43448__0;
G__43448.cljs$core$IFn$_invoke$arity$1 = G__43448__1;
G__43448.cljs$core$IFn$_invoke$arity$2 = G__43448__2;
return G__43448;
})()
});
var ret__29556__auto___43449 = /**
 * Import a single function or var:
 *   ```
 *   (import-def a b) => (def b a/b)
 *   ```
 */
cmr.client.common.util.import_def = (function cmr$client$common$util$import_def(_AMPERSAND_form,_AMPERSAND_env,from_ns,def_name){
var from_sym_SHARP_ = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(from_ns)].join(''),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(def_name)].join(''));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"def","def",597100991,null)),(function (){var x__29209__auto__ = def_name;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29209__auto__);
})(),(function (){var x__29209__auto__ = from_sym_SHARP_;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29209__auto__);
})())));
});
cmr.client.common.util.import_def.cljs$lang$macro = true;

var ret__29556__auto___43462 = (function (){
/**
 * Import multiple defs from multiple namespaces.
 * 
 * This works for vars and functions, but not macros. Uses the same syntax as
 * `potemkin.namespaces/import-vars`, namely:
 * ```
 * (import-vars
 *   [m.n.ns1 a b]
 *   [x.y.ns2 d e f])
 *   ```
 */
cmr.client.common.util.import_vars = (function cmr$client$common$util$import_vars(var_args){
var args__29523__auto__ = [];
var len__29516__auto___43463 = arguments.length;
var i__29517__auto___43464 = (0);
while(true){
if((i__29517__auto___43464 < len__29516__auto___43463)){
args__29523__auto__.push((arguments[i__29517__auto___43464]));

var G__43465 = (i__29517__auto___43464 + (1));
i__29517__auto___43464 = G__43465;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((2) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((2)),(0),null)):null);
return cmr.client.common.util.import_vars.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29524__auto__);
});

cmr.client.common.util.import_vars.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,imports){
var expanded_imports = (function (){var iter__29155__auto__ = (function cmr$client$common$util$iter__43453(s__43454){
return (new cljs.core.LazySeq(null,(function (){
var s__43454__$1 = s__43454;
while(true){
var temp__4657__auto__ = cljs.core.seq.call(null,s__43454__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var vec__43459 = cljs.core.first.call(null,xs__5205__auto__);
var seq__43460 = cljs.core.seq.call(null,vec__43459);
var first__43461 = cljs.core.first.call(null,seq__43460);
var seq__43460__$1 = cljs.core.next.call(null,seq__43460);
var from_ns = first__43461;
var defs = seq__43460__$1;
var iterys__29151__auto__ = ((function (s__43454__$1,vec__43459,seq__43460,first__43461,seq__43460__$1,from_ns,defs,xs__5205__auto__,temp__4657__auto__){
return (function cmr$client$common$util$iter__43453_$_iter__43455(s__43456){
return (new cljs.core.LazySeq(null,((function (s__43454__$1,vec__43459,seq__43460,first__43461,seq__43460__$1,from_ns,defs,xs__5205__auto__,temp__4657__auto__){
return (function (){
var s__43456__$1 = s__43456;
while(true){
var temp__4657__auto____$1 = cljs.core.seq.call(null,s__43456__$1);
if(temp__4657__auto____$1){
var s__43456__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__43456__$2)){
var c__29153__auto__ = cljs.core.chunk_first.call(null,s__43456__$2);
var size__29154__auto__ = cljs.core.count.call(null,c__29153__auto__);
var b__43458 = cljs.core.chunk_buffer.call(null,size__29154__auto__);
if((function (){var i__43457 = (0);
while(true){
if((i__43457 < size__29154__auto__)){
var d = cljs.core._nth.call(null,c__29153__auto__,i__43457);
cljs.core.chunk_append.call(null,b__43458,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cmr.client.common.util","import-def","cmr.client.common.util/import-def",708150912,null)),(function (){var x__29209__auto__ = from_ns;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29209__auto__);
})(),(function (){var x__29209__auto__ = d;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29209__auto__);
})()))));

var G__43466 = (i__43457 + (1));
i__43457 = G__43466;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__43458),cmr$client$common$util$iter__43453_$_iter__43455.call(null,cljs.core.chunk_rest.call(null,s__43456__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__43458),null);
}
} else {
var d = cljs.core.first.call(null,s__43456__$2);
return cljs.core.cons.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("cmr.client.common.util","import-def","cmr.client.common.util/import-def",708150912,null)),(function (){var x__29209__auto__ = from_ns;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29209__auto__);
})(),(function (){var x__29209__auto__ = d;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__29209__auto__);
})()))),cmr$client$common$util$iter__43453_$_iter__43455.call(null,cljs.core.rest.call(null,s__43456__$2)));
}
} else {
return null;
}
break;
}
});})(s__43454__$1,vec__43459,seq__43460,first__43461,seq__43460__$1,from_ns,defs,xs__5205__auto__,temp__4657__auto__))
,null,null));
});})(s__43454__$1,vec__43459,seq__43460,first__43461,seq__43460__$1,from_ns,defs,xs__5205__auto__,temp__4657__auto__))
;
var fs__29152__auto__ = cljs.core.seq.call(null,iterys__29151__auto__.call(null,defs));
if(fs__29152__auto__){
return cljs.core.concat.call(null,fs__29152__auto__,cmr$client$common$util$iter__43453.call(null,cljs.core.rest.call(null,s__43454__$1)));
} else {
var G__43467 = cljs.core.rest.call(null,s__43454__$1);
s__43454__$1 = G__43467;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__29155__auto__.call(null,imports);
})();
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol(null,"do","do",1686842252,null)),expanded_imports)));
});

cmr.client.common.util.import_vars.cljs$lang$maxFixedArity = (2);

cmr.client.common.util.import_vars.cljs$lang$applyTo = (function (seq43450){
var G__43451 = cljs.core.first.call(null,seq43450);
var seq43450__$1 = cljs.core.next.call(null,seq43450);
var G__43452 = cljs.core.first.call(null,seq43450__$1);
var seq43450__$2 = cljs.core.next.call(null,seq43450__$1);
return cmr.client.common.util.import_vars.cljs$core$IFn$_invoke$arity$variadic(G__43451,G__43452,seq43450__$2);
});

return null;
})()
;
cmr.client.common.util.import_vars.cljs$lang$macro = true;


//# sourceMappingURL=util.js.map?rel=1504505457834
