// Compiled by ClojureScript 1.9.908 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__31654 = arguments.length;
switch (G__31654) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async31655 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31655 = (function (f,blockable,meta31656){
this.f = f;
this.blockable = blockable;
this.meta31656 = meta31656;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31655.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31657,meta31656__$1){
var self__ = this;
var _31657__$1 = this;
return (new cljs.core.async.t_cljs$core$async31655(self__.f,self__.blockable,meta31656__$1));
});

cljs.core.async.t_cljs$core$async31655.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31657){
var self__ = this;
var _31657__$1 = this;
return self__.meta31656;
});

cljs.core.async.t_cljs$core$async31655.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31655.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31655.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async31655.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async31655.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta31656","meta31656",331399273,null)], null);
});

cljs.core.async.t_cljs$core$async31655.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31655.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31655";

cljs.core.async.t_cljs$core$async31655.cljs$lang$ctorPrWriter = (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async31655");
});

cljs.core.async.__GT_t_cljs$core$async31655 = (function cljs$core$async$__GT_t_cljs$core$async31655(f__$1,blockable__$1,meta31656){
return (new cljs.core.async.t_cljs$core$async31655(f__$1,blockable__$1,meta31656));
});

}

return (new cljs.core.async.t_cljs$core$async31655(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__31661 = arguments.length;
switch (G__31661) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__31664 = arguments.length;
switch (G__31664) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__31667 = arguments.length;
switch (G__31667) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_31669 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_31669);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_31669,ret){
return (function (){
return fn1.call(null,val_31669);
});})(val_31669,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__31671 = arguments.length;
switch (G__31671) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__29292__auto___31673 = n;
var x_31674 = (0);
while(true){
if((x_31674 < n__29292__auto___31673)){
(a[x_31674] = (0));

var G__31675 = (x_31674 + (1));
x_31674 = G__31675;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__31676 = (i + (1));
i = G__31676;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async31677 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31677 = (function (flag,meta31678){
this.flag = flag;
this.meta31678 = meta31678;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31677.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31679,meta31678__$1){
var self__ = this;
var _31679__$1 = this;
return (new cljs.core.async.t_cljs$core$async31677(self__.flag,meta31678__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async31677.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31679){
var self__ = this;
var _31679__$1 = this;
return self__.meta31678;
});})(flag))
;

cljs.core.async.t_cljs$core$async31677.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31677.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async31677.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31677.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31677.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta31678","meta31678",-1855026730,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async31677.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31677.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31677";

cljs.core.async.t_cljs$core$async31677.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async31677");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async31677 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31677(flag__$1,meta31678){
return (new cljs.core.async.t_cljs$core$async31677(flag__$1,meta31678));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async31677(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async31680 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31680 = (function (flag,cb,meta31681){
this.flag = flag;
this.cb = cb;
this.meta31681 = meta31681;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31680.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31682,meta31681__$1){
var self__ = this;
var _31682__$1 = this;
return (new cljs.core.async.t_cljs$core$async31680(self__.flag,self__.cb,meta31681__$1));
});

cljs.core.async.t_cljs$core$async31680.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31682){
var self__ = this;
var _31682__$1 = this;
return self__.meta31681;
});

cljs.core.async.t_cljs$core$async31680.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31680.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async31680.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31680.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async31680.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta31681","meta31681",113024229,null)], null);
});

cljs.core.async.t_cljs$core$async31680.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31680.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31680";

cljs.core.async.t_cljs$core$async31680.cljs$lang$ctorPrWriter = (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async31680");
});

cljs.core.async.__GT_t_cljs$core$async31680 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31680(flag__$1,cb__$1,meta31681){
return (new cljs.core.async.t_cljs$core$async31680(flag__$1,cb__$1,meta31681));
});

}

return (new cljs.core.async.t_cljs$core$async31680(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31683_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31683_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31684_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31684_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__28347__auto__ = wport;
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return port;
}
})()], null));
} else {
var G__31685 = (i + (1));
i = G__31685;
continue;
}
} else {
return null;
}
break;
}
})();
var or__28347__auto__ = ret;
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__28335__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__28335__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__28335__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__29523__auto__ = [];
var len__29516__auto___31691 = arguments.length;
var i__29517__auto___31692 = (0);
while(true){
if((i__29517__auto___31692 < len__29516__auto___31691)){
args__29523__auto__.push((arguments[i__29517__auto___31692]));

var G__31693 = (i__29517__auto___31692 + (1));
i__29517__auto___31692 = G__31693;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31688){
var map__31689 = p__31688;
var map__31689__$1 = ((((!((map__31689 == null)))?((((map__31689.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31689.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31689):map__31689);
var opts = map__31689__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31686){
var G__31687 = cljs.core.first.call(null,seq31686);
var seq31686__$1 = cljs.core.next.call(null,seq31686);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31687,seq31686__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__31695 = arguments.length;
switch (G__31695) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__31608__auto___31741 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto___31741){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto___31741){
return (function (state_31719){
var state_val_31720 = (state_31719[(1)]);
if((state_val_31720 === (7))){
var inst_31715 = (state_31719[(2)]);
var state_31719__$1 = state_31719;
var statearr_31721_31742 = state_31719__$1;
(statearr_31721_31742[(2)] = inst_31715);

(statearr_31721_31742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31720 === (1))){
var state_31719__$1 = state_31719;
var statearr_31722_31743 = state_31719__$1;
(statearr_31722_31743[(2)] = null);

(statearr_31722_31743[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31720 === (4))){
var inst_31698 = (state_31719[(7)]);
var inst_31698__$1 = (state_31719[(2)]);
var inst_31699 = (inst_31698__$1 == null);
var state_31719__$1 = (function (){var statearr_31723 = state_31719;
(statearr_31723[(7)] = inst_31698__$1);

return statearr_31723;
})();
if(cljs.core.truth_(inst_31699)){
var statearr_31724_31744 = state_31719__$1;
(statearr_31724_31744[(1)] = (5));

} else {
var statearr_31725_31745 = state_31719__$1;
(statearr_31725_31745[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31720 === (13))){
var state_31719__$1 = state_31719;
var statearr_31726_31746 = state_31719__$1;
(statearr_31726_31746[(2)] = null);

(statearr_31726_31746[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31720 === (6))){
var inst_31698 = (state_31719[(7)]);
var state_31719__$1 = state_31719;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31719__$1,(11),to,inst_31698);
} else {
if((state_val_31720 === (3))){
var inst_31717 = (state_31719[(2)]);
var state_31719__$1 = state_31719;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31719__$1,inst_31717);
} else {
if((state_val_31720 === (12))){
var state_31719__$1 = state_31719;
var statearr_31727_31747 = state_31719__$1;
(statearr_31727_31747[(2)] = null);

(statearr_31727_31747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31720 === (2))){
var state_31719__$1 = state_31719;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31719__$1,(4),from);
} else {
if((state_val_31720 === (11))){
var inst_31708 = (state_31719[(2)]);
var state_31719__$1 = state_31719;
if(cljs.core.truth_(inst_31708)){
var statearr_31728_31748 = state_31719__$1;
(statearr_31728_31748[(1)] = (12));

} else {
var statearr_31729_31749 = state_31719__$1;
(statearr_31729_31749[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31720 === (9))){
var state_31719__$1 = state_31719;
var statearr_31730_31750 = state_31719__$1;
(statearr_31730_31750[(2)] = null);

(statearr_31730_31750[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31720 === (5))){
var state_31719__$1 = state_31719;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31731_31751 = state_31719__$1;
(statearr_31731_31751[(1)] = (8));

} else {
var statearr_31732_31752 = state_31719__$1;
(statearr_31732_31752[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31720 === (14))){
var inst_31713 = (state_31719[(2)]);
var state_31719__$1 = state_31719;
var statearr_31733_31753 = state_31719__$1;
(statearr_31733_31753[(2)] = inst_31713);

(statearr_31733_31753[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31720 === (10))){
var inst_31705 = (state_31719[(2)]);
var state_31719__$1 = state_31719;
var statearr_31734_31754 = state_31719__$1;
(statearr_31734_31754[(2)] = inst_31705);

(statearr_31734_31754[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31720 === (8))){
var inst_31702 = cljs.core.async.close_BANG_.call(null,to);
var state_31719__$1 = state_31719;
var statearr_31735_31755 = state_31719__$1;
(statearr_31735_31755[(2)] = inst_31702);

(statearr_31735_31755[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31608__auto___31741))
;
return ((function (switch__31520__auto__,c__31608__auto___31741){
return (function() {
var cljs$core$async$state_machine__31521__auto__ = null;
var cljs$core$async$state_machine__31521__auto____0 = (function (){
var statearr_31736 = [null,null,null,null,null,null,null,null];
(statearr_31736[(0)] = cljs$core$async$state_machine__31521__auto__);

(statearr_31736[(1)] = (1));

return statearr_31736;
});
var cljs$core$async$state_machine__31521__auto____1 = (function (state_31719){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_31719);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e31737){if((e31737 instanceof Object)){
var ex__31524__auto__ = e31737;
var statearr_31738_31756 = state_31719;
(statearr_31738_31756[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31719);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31737;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31757 = state_31719;
state_31719 = G__31757;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$state_machine__31521__auto__ = function(state_31719){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31521__auto____1.call(this,state_31719);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31521__auto____0;
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31521__auto____1;
return cljs$core$async$state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto___31741))
})();
var state__31610__auto__ = (function (){var statearr_31739 = f__31609__auto__.call(null);
(statearr_31739[(6)] = c__31608__auto___31741);

return statearr_31739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto___31741))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__31758){
var vec__31759 = p__31758;
var v = cljs.core.nth.call(null,vec__31759,(0),null);
var p = cljs.core.nth.call(null,vec__31759,(1),null);
var job = vec__31759;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__31608__auto___31930 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto___31930,res,vec__31759,v,p,job,jobs,results){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto___31930,res,vec__31759,v,p,job,jobs,results){
return (function (state_31766){
var state_val_31767 = (state_31766[(1)]);
if((state_val_31767 === (1))){
var state_31766__$1 = state_31766;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31766__$1,(2),res,v);
} else {
if((state_val_31767 === (2))){
var inst_31763 = (state_31766[(2)]);
var inst_31764 = cljs.core.async.close_BANG_.call(null,res);
var state_31766__$1 = (function (){var statearr_31768 = state_31766;
(statearr_31768[(7)] = inst_31763);

return statearr_31768;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31766__$1,inst_31764);
} else {
return null;
}
}
});})(c__31608__auto___31930,res,vec__31759,v,p,job,jobs,results))
;
return ((function (switch__31520__auto__,c__31608__auto___31930,res,vec__31759,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____0 = (function (){
var statearr_31769 = [null,null,null,null,null,null,null,null];
(statearr_31769[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__);

(statearr_31769[(1)] = (1));

return statearr_31769;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____1 = (function (state_31766){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_31766);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e31770){if((e31770 instanceof Object)){
var ex__31524__auto__ = e31770;
var statearr_31771_31931 = state_31766;
(statearr_31771_31931[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31766);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31770;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31932 = state_31766;
state_31766 = G__31932;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__ = function(state_31766){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____1.call(this,state_31766);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto___31930,res,vec__31759,v,p,job,jobs,results))
})();
var state__31610__auto__ = (function (){var statearr_31772 = f__31609__auto__.call(null);
(statearr_31772[(6)] = c__31608__auto___31930);

return statearr_31772;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto___31930,res,vec__31759,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__31773){
var vec__31774 = p__31773;
var v = cljs.core.nth.call(null,vec__31774,(0),null);
var p = cljs.core.nth.call(null,vec__31774,(1),null);
var job = vec__31774;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__29292__auto___31933 = n;
var __31934 = (0);
while(true){
if((__31934 < n__29292__auto___31933)){
var G__31777_31935 = type;
var G__31777_31936__$1 = (((G__31777_31935 instanceof cljs.core.Keyword))?G__31777_31935.fqn:null);
switch (G__31777_31936__$1) {
case "compute":
var c__31608__auto___31938 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__31934,c__31608__auto___31938,G__31777_31935,G__31777_31936__$1,n__29292__auto___31933,jobs,results,process,async){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (__31934,c__31608__auto___31938,G__31777_31935,G__31777_31936__$1,n__29292__auto___31933,jobs,results,process,async){
return (function (state_31790){
var state_val_31791 = (state_31790[(1)]);
if((state_val_31791 === (1))){
var state_31790__$1 = state_31790;
var statearr_31792_31939 = state_31790__$1;
(statearr_31792_31939[(2)] = null);

(statearr_31792_31939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31791 === (2))){
var state_31790__$1 = state_31790;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31790__$1,(4),jobs);
} else {
if((state_val_31791 === (3))){
var inst_31788 = (state_31790[(2)]);
var state_31790__$1 = state_31790;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31790__$1,inst_31788);
} else {
if((state_val_31791 === (4))){
var inst_31780 = (state_31790[(2)]);
var inst_31781 = process.call(null,inst_31780);
var state_31790__$1 = state_31790;
if(cljs.core.truth_(inst_31781)){
var statearr_31793_31940 = state_31790__$1;
(statearr_31793_31940[(1)] = (5));

} else {
var statearr_31794_31941 = state_31790__$1;
(statearr_31794_31941[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31791 === (5))){
var state_31790__$1 = state_31790;
var statearr_31795_31942 = state_31790__$1;
(statearr_31795_31942[(2)] = null);

(statearr_31795_31942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31791 === (6))){
var state_31790__$1 = state_31790;
var statearr_31796_31943 = state_31790__$1;
(statearr_31796_31943[(2)] = null);

(statearr_31796_31943[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31791 === (7))){
var inst_31786 = (state_31790[(2)]);
var state_31790__$1 = state_31790;
var statearr_31797_31944 = state_31790__$1;
(statearr_31797_31944[(2)] = inst_31786);

(statearr_31797_31944[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31934,c__31608__auto___31938,G__31777_31935,G__31777_31936__$1,n__29292__auto___31933,jobs,results,process,async))
;
return ((function (__31934,switch__31520__auto__,c__31608__auto___31938,G__31777_31935,G__31777_31936__$1,n__29292__auto___31933,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____0 = (function (){
var statearr_31798 = [null,null,null,null,null,null,null];
(statearr_31798[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__);

(statearr_31798[(1)] = (1));

return statearr_31798;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____1 = (function (state_31790){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_31790);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e31799){if((e31799 instanceof Object)){
var ex__31524__auto__ = e31799;
var statearr_31800_31945 = state_31790;
(statearr_31800_31945[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31790);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31799;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31946 = state_31790;
state_31790 = G__31946;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__ = function(state_31790){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____1.call(this,state_31790);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__;
})()
;})(__31934,switch__31520__auto__,c__31608__auto___31938,G__31777_31935,G__31777_31936__$1,n__29292__auto___31933,jobs,results,process,async))
})();
var state__31610__auto__ = (function (){var statearr_31801 = f__31609__auto__.call(null);
(statearr_31801[(6)] = c__31608__auto___31938);

return statearr_31801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(__31934,c__31608__auto___31938,G__31777_31935,G__31777_31936__$1,n__29292__auto___31933,jobs,results,process,async))
);


break;
case "async":
var c__31608__auto___31947 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__31934,c__31608__auto___31947,G__31777_31935,G__31777_31936__$1,n__29292__auto___31933,jobs,results,process,async){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (__31934,c__31608__auto___31947,G__31777_31935,G__31777_31936__$1,n__29292__auto___31933,jobs,results,process,async){
return (function (state_31814){
var state_val_31815 = (state_31814[(1)]);
if((state_val_31815 === (1))){
var state_31814__$1 = state_31814;
var statearr_31816_31948 = state_31814__$1;
(statearr_31816_31948[(2)] = null);

(statearr_31816_31948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31815 === (2))){
var state_31814__$1 = state_31814;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31814__$1,(4),jobs);
} else {
if((state_val_31815 === (3))){
var inst_31812 = (state_31814[(2)]);
var state_31814__$1 = state_31814;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31814__$1,inst_31812);
} else {
if((state_val_31815 === (4))){
var inst_31804 = (state_31814[(2)]);
var inst_31805 = async.call(null,inst_31804);
var state_31814__$1 = state_31814;
if(cljs.core.truth_(inst_31805)){
var statearr_31817_31949 = state_31814__$1;
(statearr_31817_31949[(1)] = (5));

} else {
var statearr_31818_31950 = state_31814__$1;
(statearr_31818_31950[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31815 === (5))){
var state_31814__$1 = state_31814;
var statearr_31819_31951 = state_31814__$1;
(statearr_31819_31951[(2)] = null);

(statearr_31819_31951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31815 === (6))){
var state_31814__$1 = state_31814;
var statearr_31820_31952 = state_31814__$1;
(statearr_31820_31952[(2)] = null);

(statearr_31820_31952[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31815 === (7))){
var inst_31810 = (state_31814[(2)]);
var state_31814__$1 = state_31814;
var statearr_31821_31953 = state_31814__$1;
(statearr_31821_31953[(2)] = inst_31810);

(statearr_31821_31953[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31934,c__31608__auto___31947,G__31777_31935,G__31777_31936__$1,n__29292__auto___31933,jobs,results,process,async))
;
return ((function (__31934,switch__31520__auto__,c__31608__auto___31947,G__31777_31935,G__31777_31936__$1,n__29292__auto___31933,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____0 = (function (){
var statearr_31822 = [null,null,null,null,null,null,null];
(statearr_31822[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__);

(statearr_31822[(1)] = (1));

return statearr_31822;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____1 = (function (state_31814){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_31814);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e31823){if((e31823 instanceof Object)){
var ex__31524__auto__ = e31823;
var statearr_31824_31954 = state_31814;
(statearr_31824_31954[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31814);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31823;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31955 = state_31814;
state_31814 = G__31955;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__ = function(state_31814){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____1.call(this,state_31814);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__;
})()
;})(__31934,switch__31520__auto__,c__31608__auto___31947,G__31777_31935,G__31777_31936__$1,n__29292__auto___31933,jobs,results,process,async))
})();
var state__31610__auto__ = (function (){var statearr_31825 = f__31609__auto__.call(null);
(statearr_31825[(6)] = c__31608__auto___31947);

return statearr_31825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(__31934,c__31608__auto___31947,G__31777_31935,G__31777_31936__$1,n__29292__auto___31933,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31777_31936__$1)].join('')));

}

var G__31956 = (__31934 + (1));
__31934 = G__31956;
continue;
} else {
}
break;
}

var c__31608__auto___31957 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto___31957,jobs,results,process,async){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto___31957,jobs,results,process,async){
return (function (state_31847){
var state_val_31848 = (state_31847[(1)]);
if((state_val_31848 === (1))){
var state_31847__$1 = state_31847;
var statearr_31849_31958 = state_31847__$1;
(statearr_31849_31958[(2)] = null);

(statearr_31849_31958[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31848 === (2))){
var state_31847__$1 = state_31847;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31847__$1,(4),from);
} else {
if((state_val_31848 === (3))){
var inst_31845 = (state_31847[(2)]);
var state_31847__$1 = state_31847;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31847__$1,inst_31845);
} else {
if((state_val_31848 === (4))){
var inst_31828 = (state_31847[(7)]);
var inst_31828__$1 = (state_31847[(2)]);
var inst_31829 = (inst_31828__$1 == null);
var state_31847__$1 = (function (){var statearr_31850 = state_31847;
(statearr_31850[(7)] = inst_31828__$1);

return statearr_31850;
})();
if(cljs.core.truth_(inst_31829)){
var statearr_31851_31959 = state_31847__$1;
(statearr_31851_31959[(1)] = (5));

} else {
var statearr_31852_31960 = state_31847__$1;
(statearr_31852_31960[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31848 === (5))){
var inst_31831 = cljs.core.async.close_BANG_.call(null,jobs);
var state_31847__$1 = state_31847;
var statearr_31853_31961 = state_31847__$1;
(statearr_31853_31961[(2)] = inst_31831);

(statearr_31853_31961[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31848 === (6))){
var inst_31828 = (state_31847[(7)]);
var inst_31833 = (state_31847[(8)]);
var inst_31833__$1 = cljs.core.async.chan.call(null,(1));
var inst_31834 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31835 = [inst_31828,inst_31833__$1];
var inst_31836 = (new cljs.core.PersistentVector(null,2,(5),inst_31834,inst_31835,null));
var state_31847__$1 = (function (){var statearr_31854 = state_31847;
(statearr_31854[(8)] = inst_31833__$1);

return statearr_31854;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31847__$1,(8),jobs,inst_31836);
} else {
if((state_val_31848 === (7))){
var inst_31843 = (state_31847[(2)]);
var state_31847__$1 = state_31847;
var statearr_31855_31962 = state_31847__$1;
(statearr_31855_31962[(2)] = inst_31843);

(statearr_31855_31962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31848 === (8))){
var inst_31833 = (state_31847[(8)]);
var inst_31838 = (state_31847[(2)]);
var state_31847__$1 = (function (){var statearr_31856 = state_31847;
(statearr_31856[(9)] = inst_31838);

return statearr_31856;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31847__$1,(9),results,inst_31833);
} else {
if((state_val_31848 === (9))){
var inst_31840 = (state_31847[(2)]);
var state_31847__$1 = (function (){var statearr_31857 = state_31847;
(statearr_31857[(10)] = inst_31840);

return statearr_31857;
})();
var statearr_31858_31963 = state_31847__$1;
(statearr_31858_31963[(2)] = null);

(statearr_31858_31963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__31608__auto___31957,jobs,results,process,async))
;
return ((function (switch__31520__auto__,c__31608__auto___31957,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____0 = (function (){
var statearr_31859 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31859[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__);

(statearr_31859[(1)] = (1));

return statearr_31859;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____1 = (function (state_31847){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_31847);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e31860){if((e31860 instanceof Object)){
var ex__31524__auto__ = e31860;
var statearr_31861_31964 = state_31847;
(statearr_31861_31964[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31847);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31860;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31965 = state_31847;
state_31847 = G__31965;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__ = function(state_31847){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____1.call(this,state_31847);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto___31957,jobs,results,process,async))
})();
var state__31610__auto__ = (function (){var statearr_31862 = f__31609__auto__.call(null);
(statearr_31862[(6)] = c__31608__auto___31957);

return statearr_31862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto___31957,jobs,results,process,async))
);


var c__31608__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto__,jobs,results,process,async){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto__,jobs,results,process,async){
return (function (state_31900){
var state_val_31901 = (state_31900[(1)]);
if((state_val_31901 === (7))){
var inst_31896 = (state_31900[(2)]);
var state_31900__$1 = state_31900;
var statearr_31902_31966 = state_31900__$1;
(statearr_31902_31966[(2)] = inst_31896);

(statearr_31902_31966[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31901 === (20))){
var state_31900__$1 = state_31900;
var statearr_31903_31967 = state_31900__$1;
(statearr_31903_31967[(2)] = null);

(statearr_31903_31967[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31901 === (1))){
var state_31900__$1 = state_31900;
var statearr_31904_31968 = state_31900__$1;
(statearr_31904_31968[(2)] = null);

(statearr_31904_31968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31901 === (4))){
var inst_31865 = (state_31900[(7)]);
var inst_31865__$1 = (state_31900[(2)]);
var inst_31866 = (inst_31865__$1 == null);
var state_31900__$1 = (function (){var statearr_31905 = state_31900;
(statearr_31905[(7)] = inst_31865__$1);

return statearr_31905;
})();
if(cljs.core.truth_(inst_31866)){
var statearr_31906_31969 = state_31900__$1;
(statearr_31906_31969[(1)] = (5));

} else {
var statearr_31907_31970 = state_31900__$1;
(statearr_31907_31970[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31901 === (15))){
var inst_31878 = (state_31900[(8)]);
var state_31900__$1 = state_31900;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31900__$1,(18),to,inst_31878);
} else {
if((state_val_31901 === (21))){
var inst_31891 = (state_31900[(2)]);
var state_31900__$1 = state_31900;
var statearr_31908_31971 = state_31900__$1;
(statearr_31908_31971[(2)] = inst_31891);

(statearr_31908_31971[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31901 === (13))){
var inst_31893 = (state_31900[(2)]);
var state_31900__$1 = (function (){var statearr_31909 = state_31900;
(statearr_31909[(9)] = inst_31893);

return statearr_31909;
})();
var statearr_31910_31972 = state_31900__$1;
(statearr_31910_31972[(2)] = null);

(statearr_31910_31972[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31901 === (6))){
var inst_31865 = (state_31900[(7)]);
var state_31900__$1 = state_31900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31900__$1,(11),inst_31865);
} else {
if((state_val_31901 === (17))){
var inst_31886 = (state_31900[(2)]);
var state_31900__$1 = state_31900;
if(cljs.core.truth_(inst_31886)){
var statearr_31911_31973 = state_31900__$1;
(statearr_31911_31973[(1)] = (19));

} else {
var statearr_31912_31974 = state_31900__$1;
(statearr_31912_31974[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31901 === (3))){
var inst_31898 = (state_31900[(2)]);
var state_31900__$1 = state_31900;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31900__$1,inst_31898);
} else {
if((state_val_31901 === (12))){
var inst_31875 = (state_31900[(10)]);
var state_31900__$1 = state_31900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31900__$1,(14),inst_31875);
} else {
if((state_val_31901 === (2))){
var state_31900__$1 = state_31900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31900__$1,(4),results);
} else {
if((state_val_31901 === (19))){
var state_31900__$1 = state_31900;
var statearr_31913_31975 = state_31900__$1;
(statearr_31913_31975[(2)] = null);

(statearr_31913_31975[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31901 === (11))){
var inst_31875 = (state_31900[(2)]);
var state_31900__$1 = (function (){var statearr_31914 = state_31900;
(statearr_31914[(10)] = inst_31875);

return statearr_31914;
})();
var statearr_31915_31976 = state_31900__$1;
(statearr_31915_31976[(2)] = null);

(statearr_31915_31976[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31901 === (9))){
var state_31900__$1 = state_31900;
var statearr_31916_31977 = state_31900__$1;
(statearr_31916_31977[(2)] = null);

(statearr_31916_31977[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31901 === (5))){
var state_31900__$1 = state_31900;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31917_31978 = state_31900__$1;
(statearr_31917_31978[(1)] = (8));

} else {
var statearr_31918_31979 = state_31900__$1;
(statearr_31918_31979[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31901 === (14))){
var inst_31880 = (state_31900[(11)]);
var inst_31878 = (state_31900[(8)]);
var inst_31878__$1 = (state_31900[(2)]);
var inst_31879 = (inst_31878__$1 == null);
var inst_31880__$1 = cljs.core.not.call(null,inst_31879);
var state_31900__$1 = (function (){var statearr_31919 = state_31900;
(statearr_31919[(11)] = inst_31880__$1);

(statearr_31919[(8)] = inst_31878__$1);

return statearr_31919;
})();
if(inst_31880__$1){
var statearr_31920_31980 = state_31900__$1;
(statearr_31920_31980[(1)] = (15));

} else {
var statearr_31921_31981 = state_31900__$1;
(statearr_31921_31981[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31901 === (16))){
var inst_31880 = (state_31900[(11)]);
var state_31900__$1 = state_31900;
var statearr_31922_31982 = state_31900__$1;
(statearr_31922_31982[(2)] = inst_31880);

(statearr_31922_31982[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31901 === (10))){
var inst_31872 = (state_31900[(2)]);
var state_31900__$1 = state_31900;
var statearr_31923_31983 = state_31900__$1;
(statearr_31923_31983[(2)] = inst_31872);

(statearr_31923_31983[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31901 === (18))){
var inst_31883 = (state_31900[(2)]);
var state_31900__$1 = state_31900;
var statearr_31924_31984 = state_31900__$1;
(statearr_31924_31984[(2)] = inst_31883);

(statearr_31924_31984[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31901 === (8))){
var inst_31869 = cljs.core.async.close_BANG_.call(null,to);
var state_31900__$1 = state_31900;
var statearr_31925_31985 = state_31900__$1;
(statearr_31925_31985[(2)] = inst_31869);

(statearr_31925_31985[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31608__auto__,jobs,results,process,async))
;
return ((function (switch__31520__auto__,c__31608__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____0 = (function (){
var statearr_31926 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31926[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__);

(statearr_31926[(1)] = (1));

return statearr_31926;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____1 = (function (state_31900){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_31900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e31927){if((e31927 instanceof Object)){
var ex__31524__auto__ = e31927;
var statearr_31928_31986 = state_31900;
(statearr_31928_31986[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31900);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31927;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31987 = state_31900;
state_31900 = G__31987;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__ = function(state_31900){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____1.call(this,state_31900);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31521__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto__,jobs,results,process,async))
})();
var state__31610__auto__ = (function (){var statearr_31929 = f__31609__auto__.call(null);
(statearr_31929[(6)] = c__31608__auto__);

return statearr_31929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto__,jobs,results,process,async))
);

return c__31608__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__31989 = arguments.length;
switch (G__31989) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__31992 = arguments.length;
switch (G__31992) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__31995 = arguments.length;
switch (G__31995) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__31608__auto___32044 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto___32044,tc,fc){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto___32044,tc,fc){
return (function (state_32021){
var state_val_32022 = (state_32021[(1)]);
if((state_val_32022 === (7))){
var inst_32017 = (state_32021[(2)]);
var state_32021__$1 = state_32021;
var statearr_32023_32045 = state_32021__$1;
(statearr_32023_32045[(2)] = inst_32017);

(statearr_32023_32045[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32022 === (1))){
var state_32021__$1 = state_32021;
var statearr_32024_32046 = state_32021__$1;
(statearr_32024_32046[(2)] = null);

(statearr_32024_32046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32022 === (4))){
var inst_31998 = (state_32021[(7)]);
var inst_31998__$1 = (state_32021[(2)]);
var inst_31999 = (inst_31998__$1 == null);
var state_32021__$1 = (function (){var statearr_32025 = state_32021;
(statearr_32025[(7)] = inst_31998__$1);

return statearr_32025;
})();
if(cljs.core.truth_(inst_31999)){
var statearr_32026_32047 = state_32021__$1;
(statearr_32026_32047[(1)] = (5));

} else {
var statearr_32027_32048 = state_32021__$1;
(statearr_32027_32048[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32022 === (13))){
var state_32021__$1 = state_32021;
var statearr_32028_32049 = state_32021__$1;
(statearr_32028_32049[(2)] = null);

(statearr_32028_32049[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32022 === (6))){
var inst_31998 = (state_32021[(7)]);
var inst_32004 = p.call(null,inst_31998);
var state_32021__$1 = state_32021;
if(cljs.core.truth_(inst_32004)){
var statearr_32029_32050 = state_32021__$1;
(statearr_32029_32050[(1)] = (9));

} else {
var statearr_32030_32051 = state_32021__$1;
(statearr_32030_32051[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32022 === (3))){
var inst_32019 = (state_32021[(2)]);
var state_32021__$1 = state_32021;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32021__$1,inst_32019);
} else {
if((state_val_32022 === (12))){
var state_32021__$1 = state_32021;
var statearr_32031_32052 = state_32021__$1;
(statearr_32031_32052[(2)] = null);

(statearr_32031_32052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32022 === (2))){
var state_32021__$1 = state_32021;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32021__$1,(4),ch);
} else {
if((state_val_32022 === (11))){
var inst_31998 = (state_32021[(7)]);
var inst_32008 = (state_32021[(2)]);
var state_32021__$1 = state_32021;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32021__$1,(8),inst_32008,inst_31998);
} else {
if((state_val_32022 === (9))){
var state_32021__$1 = state_32021;
var statearr_32032_32053 = state_32021__$1;
(statearr_32032_32053[(2)] = tc);

(statearr_32032_32053[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32022 === (5))){
var inst_32001 = cljs.core.async.close_BANG_.call(null,tc);
var inst_32002 = cljs.core.async.close_BANG_.call(null,fc);
var state_32021__$1 = (function (){var statearr_32033 = state_32021;
(statearr_32033[(8)] = inst_32001);

return statearr_32033;
})();
var statearr_32034_32054 = state_32021__$1;
(statearr_32034_32054[(2)] = inst_32002);

(statearr_32034_32054[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32022 === (14))){
var inst_32015 = (state_32021[(2)]);
var state_32021__$1 = state_32021;
var statearr_32035_32055 = state_32021__$1;
(statearr_32035_32055[(2)] = inst_32015);

(statearr_32035_32055[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32022 === (10))){
var state_32021__$1 = state_32021;
var statearr_32036_32056 = state_32021__$1;
(statearr_32036_32056[(2)] = fc);

(statearr_32036_32056[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32022 === (8))){
var inst_32010 = (state_32021[(2)]);
var state_32021__$1 = state_32021;
if(cljs.core.truth_(inst_32010)){
var statearr_32037_32057 = state_32021__$1;
(statearr_32037_32057[(1)] = (12));

} else {
var statearr_32038_32058 = state_32021__$1;
(statearr_32038_32058[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31608__auto___32044,tc,fc))
;
return ((function (switch__31520__auto__,c__31608__auto___32044,tc,fc){
return (function() {
var cljs$core$async$state_machine__31521__auto__ = null;
var cljs$core$async$state_machine__31521__auto____0 = (function (){
var statearr_32039 = [null,null,null,null,null,null,null,null,null];
(statearr_32039[(0)] = cljs$core$async$state_machine__31521__auto__);

(statearr_32039[(1)] = (1));

return statearr_32039;
});
var cljs$core$async$state_machine__31521__auto____1 = (function (state_32021){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_32021);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e32040){if((e32040 instanceof Object)){
var ex__31524__auto__ = e32040;
var statearr_32041_32059 = state_32021;
(statearr_32041_32059[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32021);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32040;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32060 = state_32021;
state_32021 = G__32060;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$state_machine__31521__auto__ = function(state_32021){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31521__auto____1.call(this,state_32021);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31521__auto____0;
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31521__auto____1;
return cljs$core$async$state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto___32044,tc,fc))
})();
var state__31610__auto__ = (function (){var statearr_32042 = f__31609__auto__.call(null);
(statearr_32042[(6)] = c__31608__auto___32044);

return statearr_32042;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto___32044,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__31608__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto__){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto__){
return (function (state_32081){
var state_val_32082 = (state_32081[(1)]);
if((state_val_32082 === (7))){
var inst_32077 = (state_32081[(2)]);
var state_32081__$1 = state_32081;
var statearr_32083_32101 = state_32081__$1;
(statearr_32083_32101[(2)] = inst_32077);

(statearr_32083_32101[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32082 === (1))){
var inst_32061 = init;
var state_32081__$1 = (function (){var statearr_32084 = state_32081;
(statearr_32084[(7)] = inst_32061);

return statearr_32084;
})();
var statearr_32085_32102 = state_32081__$1;
(statearr_32085_32102[(2)] = null);

(statearr_32085_32102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32082 === (4))){
var inst_32064 = (state_32081[(8)]);
var inst_32064__$1 = (state_32081[(2)]);
var inst_32065 = (inst_32064__$1 == null);
var state_32081__$1 = (function (){var statearr_32086 = state_32081;
(statearr_32086[(8)] = inst_32064__$1);

return statearr_32086;
})();
if(cljs.core.truth_(inst_32065)){
var statearr_32087_32103 = state_32081__$1;
(statearr_32087_32103[(1)] = (5));

} else {
var statearr_32088_32104 = state_32081__$1;
(statearr_32088_32104[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32082 === (6))){
var inst_32064 = (state_32081[(8)]);
var inst_32068 = (state_32081[(9)]);
var inst_32061 = (state_32081[(7)]);
var inst_32068__$1 = f.call(null,inst_32061,inst_32064);
var inst_32069 = cljs.core.reduced_QMARK_.call(null,inst_32068__$1);
var state_32081__$1 = (function (){var statearr_32089 = state_32081;
(statearr_32089[(9)] = inst_32068__$1);

return statearr_32089;
})();
if(inst_32069){
var statearr_32090_32105 = state_32081__$1;
(statearr_32090_32105[(1)] = (8));

} else {
var statearr_32091_32106 = state_32081__$1;
(statearr_32091_32106[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32082 === (3))){
var inst_32079 = (state_32081[(2)]);
var state_32081__$1 = state_32081;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32081__$1,inst_32079);
} else {
if((state_val_32082 === (2))){
var state_32081__$1 = state_32081;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32081__$1,(4),ch);
} else {
if((state_val_32082 === (9))){
var inst_32068 = (state_32081[(9)]);
var inst_32061 = inst_32068;
var state_32081__$1 = (function (){var statearr_32092 = state_32081;
(statearr_32092[(7)] = inst_32061);

return statearr_32092;
})();
var statearr_32093_32107 = state_32081__$1;
(statearr_32093_32107[(2)] = null);

(statearr_32093_32107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32082 === (5))){
var inst_32061 = (state_32081[(7)]);
var state_32081__$1 = state_32081;
var statearr_32094_32108 = state_32081__$1;
(statearr_32094_32108[(2)] = inst_32061);

(statearr_32094_32108[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32082 === (10))){
var inst_32075 = (state_32081[(2)]);
var state_32081__$1 = state_32081;
var statearr_32095_32109 = state_32081__$1;
(statearr_32095_32109[(2)] = inst_32075);

(statearr_32095_32109[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32082 === (8))){
var inst_32068 = (state_32081[(9)]);
var inst_32071 = cljs.core.deref.call(null,inst_32068);
var state_32081__$1 = state_32081;
var statearr_32096_32110 = state_32081__$1;
(statearr_32096_32110[(2)] = inst_32071);

(statearr_32096_32110[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__31608__auto__))
;
return ((function (switch__31520__auto__,c__31608__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__31521__auto__ = null;
var cljs$core$async$reduce_$_state_machine__31521__auto____0 = (function (){
var statearr_32097 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32097[(0)] = cljs$core$async$reduce_$_state_machine__31521__auto__);

(statearr_32097[(1)] = (1));

return statearr_32097;
});
var cljs$core$async$reduce_$_state_machine__31521__auto____1 = (function (state_32081){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_32081);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e32098){if((e32098 instanceof Object)){
var ex__31524__auto__ = e32098;
var statearr_32099_32111 = state_32081;
(statearr_32099_32111[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32081);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32098;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32112 = state_32081;
state_32081 = G__32112;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__31521__auto__ = function(state_32081){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__31521__auto____1.call(this,state_32081);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__31521__auto____0;
cljs$core$async$reduce_$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__31521__auto____1;
return cljs$core$async$reduce_$_state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto__))
})();
var state__31610__auto__ = (function (){var statearr_32100 = f__31609__auto__.call(null);
(statearr_32100[(6)] = c__31608__auto__);

return statearr_32100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto__))
);

return c__31608__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__31608__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto__,f__$1){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto__,f__$1){
return (function (state_32118){
var state_val_32119 = (state_32118[(1)]);
if((state_val_32119 === (1))){
var inst_32113 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_32118__$1 = state_32118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32118__$1,(2),inst_32113);
} else {
if((state_val_32119 === (2))){
var inst_32115 = (state_32118[(2)]);
var inst_32116 = f__$1.call(null,inst_32115);
var state_32118__$1 = state_32118;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32118__$1,inst_32116);
} else {
return null;
}
}
});})(c__31608__auto__,f__$1))
;
return ((function (switch__31520__auto__,c__31608__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__31521__auto__ = null;
var cljs$core$async$transduce_$_state_machine__31521__auto____0 = (function (){
var statearr_32120 = [null,null,null,null,null,null,null];
(statearr_32120[(0)] = cljs$core$async$transduce_$_state_machine__31521__auto__);

(statearr_32120[(1)] = (1));

return statearr_32120;
});
var cljs$core$async$transduce_$_state_machine__31521__auto____1 = (function (state_32118){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_32118);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e32121){if((e32121 instanceof Object)){
var ex__31524__auto__ = e32121;
var statearr_32122_32124 = state_32118;
(statearr_32122_32124[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32118);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32121;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32125 = state_32118;
state_32118 = G__32125;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__31521__auto__ = function(state_32118){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__31521__auto____1.call(this,state_32118);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__31521__auto____0;
cljs$core$async$transduce_$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__31521__auto____1;
return cljs$core$async$transduce_$_state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto__,f__$1))
})();
var state__31610__auto__ = (function (){var statearr_32123 = f__31609__auto__.call(null);
(statearr_32123[(6)] = c__31608__auto__);

return statearr_32123;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto__,f__$1))
);

return c__31608__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__32127 = arguments.length;
switch (G__32127) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__31608__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto__){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto__){
return (function (state_32152){
var state_val_32153 = (state_32152[(1)]);
if((state_val_32153 === (7))){
var inst_32134 = (state_32152[(2)]);
var state_32152__$1 = state_32152;
var statearr_32154_32175 = state_32152__$1;
(statearr_32154_32175[(2)] = inst_32134);

(statearr_32154_32175[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32153 === (1))){
var inst_32128 = cljs.core.seq.call(null,coll);
var inst_32129 = inst_32128;
var state_32152__$1 = (function (){var statearr_32155 = state_32152;
(statearr_32155[(7)] = inst_32129);

return statearr_32155;
})();
var statearr_32156_32176 = state_32152__$1;
(statearr_32156_32176[(2)] = null);

(statearr_32156_32176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32153 === (4))){
var inst_32129 = (state_32152[(7)]);
var inst_32132 = cljs.core.first.call(null,inst_32129);
var state_32152__$1 = state_32152;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32152__$1,(7),ch,inst_32132);
} else {
if((state_val_32153 === (13))){
var inst_32146 = (state_32152[(2)]);
var state_32152__$1 = state_32152;
var statearr_32157_32177 = state_32152__$1;
(statearr_32157_32177[(2)] = inst_32146);

(statearr_32157_32177[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32153 === (6))){
var inst_32137 = (state_32152[(2)]);
var state_32152__$1 = state_32152;
if(cljs.core.truth_(inst_32137)){
var statearr_32158_32178 = state_32152__$1;
(statearr_32158_32178[(1)] = (8));

} else {
var statearr_32159_32179 = state_32152__$1;
(statearr_32159_32179[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32153 === (3))){
var inst_32150 = (state_32152[(2)]);
var state_32152__$1 = state_32152;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32152__$1,inst_32150);
} else {
if((state_val_32153 === (12))){
var state_32152__$1 = state_32152;
var statearr_32160_32180 = state_32152__$1;
(statearr_32160_32180[(2)] = null);

(statearr_32160_32180[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32153 === (2))){
var inst_32129 = (state_32152[(7)]);
var state_32152__$1 = state_32152;
if(cljs.core.truth_(inst_32129)){
var statearr_32161_32181 = state_32152__$1;
(statearr_32161_32181[(1)] = (4));

} else {
var statearr_32162_32182 = state_32152__$1;
(statearr_32162_32182[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32153 === (11))){
var inst_32143 = cljs.core.async.close_BANG_.call(null,ch);
var state_32152__$1 = state_32152;
var statearr_32163_32183 = state_32152__$1;
(statearr_32163_32183[(2)] = inst_32143);

(statearr_32163_32183[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32153 === (9))){
var state_32152__$1 = state_32152;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32164_32184 = state_32152__$1;
(statearr_32164_32184[(1)] = (11));

} else {
var statearr_32165_32185 = state_32152__$1;
(statearr_32165_32185[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32153 === (5))){
var inst_32129 = (state_32152[(7)]);
var state_32152__$1 = state_32152;
var statearr_32166_32186 = state_32152__$1;
(statearr_32166_32186[(2)] = inst_32129);

(statearr_32166_32186[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32153 === (10))){
var inst_32148 = (state_32152[(2)]);
var state_32152__$1 = state_32152;
var statearr_32167_32187 = state_32152__$1;
(statearr_32167_32187[(2)] = inst_32148);

(statearr_32167_32187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32153 === (8))){
var inst_32129 = (state_32152[(7)]);
var inst_32139 = cljs.core.next.call(null,inst_32129);
var inst_32129__$1 = inst_32139;
var state_32152__$1 = (function (){var statearr_32168 = state_32152;
(statearr_32168[(7)] = inst_32129__$1);

return statearr_32168;
})();
var statearr_32169_32188 = state_32152__$1;
(statearr_32169_32188[(2)] = null);

(statearr_32169_32188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31608__auto__))
;
return ((function (switch__31520__auto__,c__31608__auto__){
return (function() {
var cljs$core$async$state_machine__31521__auto__ = null;
var cljs$core$async$state_machine__31521__auto____0 = (function (){
var statearr_32170 = [null,null,null,null,null,null,null,null];
(statearr_32170[(0)] = cljs$core$async$state_machine__31521__auto__);

(statearr_32170[(1)] = (1));

return statearr_32170;
});
var cljs$core$async$state_machine__31521__auto____1 = (function (state_32152){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_32152);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e32171){if((e32171 instanceof Object)){
var ex__31524__auto__ = e32171;
var statearr_32172_32189 = state_32152;
(statearr_32172_32189[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32152);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32171;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32190 = state_32152;
state_32152 = G__32190;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$state_machine__31521__auto__ = function(state_32152){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31521__auto____1.call(this,state_32152);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31521__auto____0;
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31521__auto____1;
return cljs$core$async$state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto__))
})();
var state__31610__auto__ = (function (){var statearr_32173 = f__31609__auto__.call(null);
(statearr_32173[(6)] = c__31608__auto__);

return statearr_32173;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto__))
);

return c__31608__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__29030__auto__ = (((_ == null))?null:_);
var m__29031__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,_);
} else {
var m__29031__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__29031__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,ch);
} else {
var m__29031__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m);
} else {
var m__29031__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32191 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32191 = (function (ch,cs,meta32192){
this.ch = ch;
this.cs = cs;
this.meta32192 = meta32192;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32191.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_32193,meta32192__$1){
var self__ = this;
var _32193__$1 = this;
return (new cljs.core.async.t_cljs$core$async32191(self__.ch,self__.cs,meta32192__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async32191.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_32193){
var self__ = this;
var _32193__$1 = this;
return self__.meta32192;
});})(cs))
;

cljs.core.async.t_cljs$core$async32191.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32191.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async32191.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32191.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32191.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32191.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32191.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta32192","meta32192",954458778,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async32191.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32191.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32191";

cljs.core.async.t_cljs$core$async32191.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async32191");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async32191 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async32191(ch__$1,cs__$1,meta32192){
return (new cljs.core.async.t_cljs$core$async32191(ch__$1,cs__$1,meta32192));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async32191(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__31608__auto___32413 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto___32413,cs,m,dchan,dctr,done){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto___32413,cs,m,dchan,dctr,done){
return (function (state_32328){
var state_val_32329 = (state_32328[(1)]);
if((state_val_32329 === (7))){
var inst_32324 = (state_32328[(2)]);
var state_32328__$1 = state_32328;
var statearr_32330_32414 = state_32328__$1;
(statearr_32330_32414[(2)] = inst_32324);

(statearr_32330_32414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (20))){
var inst_32227 = (state_32328[(7)]);
var inst_32239 = cljs.core.first.call(null,inst_32227);
var inst_32240 = cljs.core.nth.call(null,inst_32239,(0),null);
var inst_32241 = cljs.core.nth.call(null,inst_32239,(1),null);
var state_32328__$1 = (function (){var statearr_32331 = state_32328;
(statearr_32331[(8)] = inst_32240);

return statearr_32331;
})();
if(cljs.core.truth_(inst_32241)){
var statearr_32332_32415 = state_32328__$1;
(statearr_32332_32415[(1)] = (22));

} else {
var statearr_32333_32416 = state_32328__$1;
(statearr_32333_32416[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (27))){
var inst_32269 = (state_32328[(9)]);
var inst_32271 = (state_32328[(10)]);
var inst_32276 = (state_32328[(11)]);
var inst_32196 = (state_32328[(12)]);
var inst_32276__$1 = cljs.core._nth.call(null,inst_32269,inst_32271);
var inst_32277 = cljs.core.async.put_BANG_.call(null,inst_32276__$1,inst_32196,done);
var state_32328__$1 = (function (){var statearr_32334 = state_32328;
(statearr_32334[(11)] = inst_32276__$1);

return statearr_32334;
})();
if(cljs.core.truth_(inst_32277)){
var statearr_32335_32417 = state_32328__$1;
(statearr_32335_32417[(1)] = (30));

} else {
var statearr_32336_32418 = state_32328__$1;
(statearr_32336_32418[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (1))){
var state_32328__$1 = state_32328;
var statearr_32337_32419 = state_32328__$1;
(statearr_32337_32419[(2)] = null);

(statearr_32337_32419[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (24))){
var inst_32227 = (state_32328[(7)]);
var inst_32246 = (state_32328[(2)]);
var inst_32247 = cljs.core.next.call(null,inst_32227);
var inst_32205 = inst_32247;
var inst_32206 = null;
var inst_32207 = (0);
var inst_32208 = (0);
var state_32328__$1 = (function (){var statearr_32338 = state_32328;
(statearr_32338[(13)] = inst_32208);

(statearr_32338[(14)] = inst_32207);

(statearr_32338[(15)] = inst_32206);

(statearr_32338[(16)] = inst_32246);

(statearr_32338[(17)] = inst_32205);

return statearr_32338;
})();
var statearr_32339_32420 = state_32328__$1;
(statearr_32339_32420[(2)] = null);

(statearr_32339_32420[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (39))){
var state_32328__$1 = state_32328;
var statearr_32343_32421 = state_32328__$1;
(statearr_32343_32421[(2)] = null);

(statearr_32343_32421[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (4))){
var inst_32196 = (state_32328[(12)]);
var inst_32196__$1 = (state_32328[(2)]);
var inst_32197 = (inst_32196__$1 == null);
var state_32328__$1 = (function (){var statearr_32344 = state_32328;
(statearr_32344[(12)] = inst_32196__$1);

return statearr_32344;
})();
if(cljs.core.truth_(inst_32197)){
var statearr_32345_32422 = state_32328__$1;
(statearr_32345_32422[(1)] = (5));

} else {
var statearr_32346_32423 = state_32328__$1;
(statearr_32346_32423[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (15))){
var inst_32208 = (state_32328[(13)]);
var inst_32207 = (state_32328[(14)]);
var inst_32206 = (state_32328[(15)]);
var inst_32205 = (state_32328[(17)]);
var inst_32223 = (state_32328[(2)]);
var inst_32224 = (inst_32208 + (1));
var tmp32340 = inst_32207;
var tmp32341 = inst_32206;
var tmp32342 = inst_32205;
var inst_32205__$1 = tmp32342;
var inst_32206__$1 = tmp32341;
var inst_32207__$1 = tmp32340;
var inst_32208__$1 = inst_32224;
var state_32328__$1 = (function (){var statearr_32347 = state_32328;
(statearr_32347[(13)] = inst_32208__$1);

(statearr_32347[(14)] = inst_32207__$1);

(statearr_32347[(18)] = inst_32223);

(statearr_32347[(15)] = inst_32206__$1);

(statearr_32347[(17)] = inst_32205__$1);

return statearr_32347;
})();
var statearr_32348_32424 = state_32328__$1;
(statearr_32348_32424[(2)] = null);

(statearr_32348_32424[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (21))){
var inst_32250 = (state_32328[(2)]);
var state_32328__$1 = state_32328;
var statearr_32352_32425 = state_32328__$1;
(statearr_32352_32425[(2)] = inst_32250);

(statearr_32352_32425[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (31))){
var inst_32276 = (state_32328[(11)]);
var inst_32280 = done.call(null,null);
var inst_32281 = cljs.core.async.untap_STAR_.call(null,m,inst_32276);
var state_32328__$1 = (function (){var statearr_32353 = state_32328;
(statearr_32353[(19)] = inst_32280);

return statearr_32353;
})();
var statearr_32354_32426 = state_32328__$1;
(statearr_32354_32426[(2)] = inst_32281);

(statearr_32354_32426[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (32))){
var inst_32269 = (state_32328[(9)]);
var inst_32271 = (state_32328[(10)]);
var inst_32270 = (state_32328[(20)]);
var inst_32268 = (state_32328[(21)]);
var inst_32283 = (state_32328[(2)]);
var inst_32284 = (inst_32271 + (1));
var tmp32349 = inst_32269;
var tmp32350 = inst_32270;
var tmp32351 = inst_32268;
var inst_32268__$1 = tmp32351;
var inst_32269__$1 = tmp32349;
var inst_32270__$1 = tmp32350;
var inst_32271__$1 = inst_32284;
var state_32328__$1 = (function (){var statearr_32355 = state_32328;
(statearr_32355[(9)] = inst_32269__$1);

(statearr_32355[(22)] = inst_32283);

(statearr_32355[(10)] = inst_32271__$1);

(statearr_32355[(20)] = inst_32270__$1);

(statearr_32355[(21)] = inst_32268__$1);

return statearr_32355;
})();
var statearr_32356_32427 = state_32328__$1;
(statearr_32356_32427[(2)] = null);

(statearr_32356_32427[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (40))){
var inst_32296 = (state_32328[(23)]);
var inst_32300 = done.call(null,null);
var inst_32301 = cljs.core.async.untap_STAR_.call(null,m,inst_32296);
var state_32328__$1 = (function (){var statearr_32357 = state_32328;
(statearr_32357[(24)] = inst_32300);

return statearr_32357;
})();
var statearr_32358_32428 = state_32328__$1;
(statearr_32358_32428[(2)] = inst_32301);

(statearr_32358_32428[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (33))){
var inst_32287 = (state_32328[(25)]);
var inst_32289 = cljs.core.chunked_seq_QMARK_.call(null,inst_32287);
var state_32328__$1 = state_32328;
if(inst_32289){
var statearr_32359_32429 = state_32328__$1;
(statearr_32359_32429[(1)] = (36));

} else {
var statearr_32360_32430 = state_32328__$1;
(statearr_32360_32430[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (13))){
var inst_32217 = (state_32328[(26)]);
var inst_32220 = cljs.core.async.close_BANG_.call(null,inst_32217);
var state_32328__$1 = state_32328;
var statearr_32361_32431 = state_32328__$1;
(statearr_32361_32431[(2)] = inst_32220);

(statearr_32361_32431[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (22))){
var inst_32240 = (state_32328[(8)]);
var inst_32243 = cljs.core.async.close_BANG_.call(null,inst_32240);
var state_32328__$1 = state_32328;
var statearr_32362_32432 = state_32328__$1;
(statearr_32362_32432[(2)] = inst_32243);

(statearr_32362_32432[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (36))){
var inst_32287 = (state_32328[(25)]);
var inst_32291 = cljs.core.chunk_first.call(null,inst_32287);
var inst_32292 = cljs.core.chunk_rest.call(null,inst_32287);
var inst_32293 = cljs.core.count.call(null,inst_32291);
var inst_32268 = inst_32292;
var inst_32269 = inst_32291;
var inst_32270 = inst_32293;
var inst_32271 = (0);
var state_32328__$1 = (function (){var statearr_32363 = state_32328;
(statearr_32363[(9)] = inst_32269);

(statearr_32363[(10)] = inst_32271);

(statearr_32363[(20)] = inst_32270);

(statearr_32363[(21)] = inst_32268);

return statearr_32363;
})();
var statearr_32364_32433 = state_32328__$1;
(statearr_32364_32433[(2)] = null);

(statearr_32364_32433[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (41))){
var inst_32287 = (state_32328[(25)]);
var inst_32303 = (state_32328[(2)]);
var inst_32304 = cljs.core.next.call(null,inst_32287);
var inst_32268 = inst_32304;
var inst_32269 = null;
var inst_32270 = (0);
var inst_32271 = (0);
var state_32328__$1 = (function (){var statearr_32365 = state_32328;
(statearr_32365[(9)] = inst_32269);

(statearr_32365[(10)] = inst_32271);

(statearr_32365[(20)] = inst_32270);

(statearr_32365[(27)] = inst_32303);

(statearr_32365[(21)] = inst_32268);

return statearr_32365;
})();
var statearr_32366_32434 = state_32328__$1;
(statearr_32366_32434[(2)] = null);

(statearr_32366_32434[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (43))){
var state_32328__$1 = state_32328;
var statearr_32367_32435 = state_32328__$1;
(statearr_32367_32435[(2)] = null);

(statearr_32367_32435[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (29))){
var inst_32312 = (state_32328[(2)]);
var state_32328__$1 = state_32328;
var statearr_32368_32436 = state_32328__$1;
(statearr_32368_32436[(2)] = inst_32312);

(statearr_32368_32436[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (44))){
var inst_32321 = (state_32328[(2)]);
var state_32328__$1 = (function (){var statearr_32369 = state_32328;
(statearr_32369[(28)] = inst_32321);

return statearr_32369;
})();
var statearr_32370_32437 = state_32328__$1;
(statearr_32370_32437[(2)] = null);

(statearr_32370_32437[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (6))){
var inst_32260 = (state_32328[(29)]);
var inst_32259 = cljs.core.deref.call(null,cs);
var inst_32260__$1 = cljs.core.keys.call(null,inst_32259);
var inst_32261 = cljs.core.count.call(null,inst_32260__$1);
var inst_32262 = cljs.core.reset_BANG_.call(null,dctr,inst_32261);
var inst_32267 = cljs.core.seq.call(null,inst_32260__$1);
var inst_32268 = inst_32267;
var inst_32269 = null;
var inst_32270 = (0);
var inst_32271 = (0);
var state_32328__$1 = (function (){var statearr_32371 = state_32328;
(statearr_32371[(30)] = inst_32262);

(statearr_32371[(9)] = inst_32269);

(statearr_32371[(10)] = inst_32271);

(statearr_32371[(20)] = inst_32270);

(statearr_32371[(29)] = inst_32260__$1);

(statearr_32371[(21)] = inst_32268);

return statearr_32371;
})();
var statearr_32372_32438 = state_32328__$1;
(statearr_32372_32438[(2)] = null);

(statearr_32372_32438[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (28))){
var inst_32287 = (state_32328[(25)]);
var inst_32268 = (state_32328[(21)]);
var inst_32287__$1 = cljs.core.seq.call(null,inst_32268);
var state_32328__$1 = (function (){var statearr_32373 = state_32328;
(statearr_32373[(25)] = inst_32287__$1);

return statearr_32373;
})();
if(inst_32287__$1){
var statearr_32374_32439 = state_32328__$1;
(statearr_32374_32439[(1)] = (33));

} else {
var statearr_32375_32440 = state_32328__$1;
(statearr_32375_32440[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (25))){
var inst_32271 = (state_32328[(10)]);
var inst_32270 = (state_32328[(20)]);
var inst_32273 = (inst_32271 < inst_32270);
var inst_32274 = inst_32273;
var state_32328__$1 = state_32328;
if(cljs.core.truth_(inst_32274)){
var statearr_32376_32441 = state_32328__$1;
(statearr_32376_32441[(1)] = (27));

} else {
var statearr_32377_32442 = state_32328__$1;
(statearr_32377_32442[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (34))){
var state_32328__$1 = state_32328;
var statearr_32378_32443 = state_32328__$1;
(statearr_32378_32443[(2)] = null);

(statearr_32378_32443[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (17))){
var state_32328__$1 = state_32328;
var statearr_32379_32444 = state_32328__$1;
(statearr_32379_32444[(2)] = null);

(statearr_32379_32444[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (3))){
var inst_32326 = (state_32328[(2)]);
var state_32328__$1 = state_32328;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32328__$1,inst_32326);
} else {
if((state_val_32329 === (12))){
var inst_32255 = (state_32328[(2)]);
var state_32328__$1 = state_32328;
var statearr_32380_32445 = state_32328__$1;
(statearr_32380_32445[(2)] = inst_32255);

(statearr_32380_32445[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (2))){
var state_32328__$1 = state_32328;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32328__$1,(4),ch);
} else {
if((state_val_32329 === (23))){
var state_32328__$1 = state_32328;
var statearr_32381_32446 = state_32328__$1;
(statearr_32381_32446[(2)] = null);

(statearr_32381_32446[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (35))){
var inst_32310 = (state_32328[(2)]);
var state_32328__$1 = state_32328;
var statearr_32382_32447 = state_32328__$1;
(statearr_32382_32447[(2)] = inst_32310);

(statearr_32382_32447[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (19))){
var inst_32227 = (state_32328[(7)]);
var inst_32231 = cljs.core.chunk_first.call(null,inst_32227);
var inst_32232 = cljs.core.chunk_rest.call(null,inst_32227);
var inst_32233 = cljs.core.count.call(null,inst_32231);
var inst_32205 = inst_32232;
var inst_32206 = inst_32231;
var inst_32207 = inst_32233;
var inst_32208 = (0);
var state_32328__$1 = (function (){var statearr_32383 = state_32328;
(statearr_32383[(13)] = inst_32208);

(statearr_32383[(14)] = inst_32207);

(statearr_32383[(15)] = inst_32206);

(statearr_32383[(17)] = inst_32205);

return statearr_32383;
})();
var statearr_32384_32448 = state_32328__$1;
(statearr_32384_32448[(2)] = null);

(statearr_32384_32448[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (11))){
var inst_32227 = (state_32328[(7)]);
var inst_32205 = (state_32328[(17)]);
var inst_32227__$1 = cljs.core.seq.call(null,inst_32205);
var state_32328__$1 = (function (){var statearr_32385 = state_32328;
(statearr_32385[(7)] = inst_32227__$1);

return statearr_32385;
})();
if(inst_32227__$1){
var statearr_32386_32449 = state_32328__$1;
(statearr_32386_32449[(1)] = (16));

} else {
var statearr_32387_32450 = state_32328__$1;
(statearr_32387_32450[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (9))){
var inst_32257 = (state_32328[(2)]);
var state_32328__$1 = state_32328;
var statearr_32388_32451 = state_32328__$1;
(statearr_32388_32451[(2)] = inst_32257);

(statearr_32388_32451[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (5))){
var inst_32203 = cljs.core.deref.call(null,cs);
var inst_32204 = cljs.core.seq.call(null,inst_32203);
var inst_32205 = inst_32204;
var inst_32206 = null;
var inst_32207 = (0);
var inst_32208 = (0);
var state_32328__$1 = (function (){var statearr_32389 = state_32328;
(statearr_32389[(13)] = inst_32208);

(statearr_32389[(14)] = inst_32207);

(statearr_32389[(15)] = inst_32206);

(statearr_32389[(17)] = inst_32205);

return statearr_32389;
})();
var statearr_32390_32452 = state_32328__$1;
(statearr_32390_32452[(2)] = null);

(statearr_32390_32452[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (14))){
var state_32328__$1 = state_32328;
var statearr_32391_32453 = state_32328__$1;
(statearr_32391_32453[(2)] = null);

(statearr_32391_32453[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (45))){
var inst_32318 = (state_32328[(2)]);
var state_32328__$1 = state_32328;
var statearr_32392_32454 = state_32328__$1;
(statearr_32392_32454[(2)] = inst_32318);

(statearr_32392_32454[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (26))){
var inst_32260 = (state_32328[(29)]);
var inst_32314 = (state_32328[(2)]);
var inst_32315 = cljs.core.seq.call(null,inst_32260);
var state_32328__$1 = (function (){var statearr_32393 = state_32328;
(statearr_32393[(31)] = inst_32314);

return statearr_32393;
})();
if(inst_32315){
var statearr_32394_32455 = state_32328__$1;
(statearr_32394_32455[(1)] = (42));

} else {
var statearr_32395_32456 = state_32328__$1;
(statearr_32395_32456[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (16))){
var inst_32227 = (state_32328[(7)]);
var inst_32229 = cljs.core.chunked_seq_QMARK_.call(null,inst_32227);
var state_32328__$1 = state_32328;
if(inst_32229){
var statearr_32396_32457 = state_32328__$1;
(statearr_32396_32457[(1)] = (19));

} else {
var statearr_32397_32458 = state_32328__$1;
(statearr_32397_32458[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (38))){
var inst_32307 = (state_32328[(2)]);
var state_32328__$1 = state_32328;
var statearr_32398_32459 = state_32328__$1;
(statearr_32398_32459[(2)] = inst_32307);

(statearr_32398_32459[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (30))){
var state_32328__$1 = state_32328;
var statearr_32399_32460 = state_32328__$1;
(statearr_32399_32460[(2)] = null);

(statearr_32399_32460[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (10))){
var inst_32208 = (state_32328[(13)]);
var inst_32206 = (state_32328[(15)]);
var inst_32216 = cljs.core._nth.call(null,inst_32206,inst_32208);
var inst_32217 = cljs.core.nth.call(null,inst_32216,(0),null);
var inst_32218 = cljs.core.nth.call(null,inst_32216,(1),null);
var state_32328__$1 = (function (){var statearr_32400 = state_32328;
(statearr_32400[(26)] = inst_32217);

return statearr_32400;
})();
if(cljs.core.truth_(inst_32218)){
var statearr_32401_32461 = state_32328__$1;
(statearr_32401_32461[(1)] = (13));

} else {
var statearr_32402_32462 = state_32328__$1;
(statearr_32402_32462[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (18))){
var inst_32253 = (state_32328[(2)]);
var state_32328__$1 = state_32328;
var statearr_32403_32463 = state_32328__$1;
(statearr_32403_32463[(2)] = inst_32253);

(statearr_32403_32463[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (42))){
var state_32328__$1 = state_32328;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32328__$1,(45),dchan);
} else {
if((state_val_32329 === (37))){
var inst_32196 = (state_32328[(12)]);
var inst_32287 = (state_32328[(25)]);
var inst_32296 = (state_32328[(23)]);
var inst_32296__$1 = cljs.core.first.call(null,inst_32287);
var inst_32297 = cljs.core.async.put_BANG_.call(null,inst_32296__$1,inst_32196,done);
var state_32328__$1 = (function (){var statearr_32404 = state_32328;
(statearr_32404[(23)] = inst_32296__$1);

return statearr_32404;
})();
if(cljs.core.truth_(inst_32297)){
var statearr_32405_32464 = state_32328__$1;
(statearr_32405_32464[(1)] = (39));

} else {
var statearr_32406_32465 = state_32328__$1;
(statearr_32406_32465[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32329 === (8))){
var inst_32208 = (state_32328[(13)]);
var inst_32207 = (state_32328[(14)]);
var inst_32210 = (inst_32208 < inst_32207);
var inst_32211 = inst_32210;
var state_32328__$1 = state_32328;
if(cljs.core.truth_(inst_32211)){
var statearr_32407_32466 = state_32328__$1;
(statearr_32407_32466[(1)] = (10));

} else {
var statearr_32408_32467 = state_32328__$1;
(statearr_32408_32467[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31608__auto___32413,cs,m,dchan,dctr,done))
;
return ((function (switch__31520__auto__,c__31608__auto___32413,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__31521__auto__ = null;
var cljs$core$async$mult_$_state_machine__31521__auto____0 = (function (){
var statearr_32409 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32409[(0)] = cljs$core$async$mult_$_state_machine__31521__auto__);

(statearr_32409[(1)] = (1));

return statearr_32409;
});
var cljs$core$async$mult_$_state_machine__31521__auto____1 = (function (state_32328){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_32328);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e32410){if((e32410 instanceof Object)){
var ex__31524__auto__ = e32410;
var statearr_32411_32468 = state_32328;
(statearr_32411_32468[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32328);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32410;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32469 = state_32328;
state_32328 = G__32469;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__31521__auto__ = function(state_32328){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__31521__auto____1.call(this,state_32328);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__31521__auto____0;
cljs$core$async$mult_$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__31521__auto____1;
return cljs$core$async$mult_$_state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto___32413,cs,m,dchan,dctr,done))
})();
var state__31610__auto__ = (function (){var statearr_32412 = f__31609__auto__.call(null);
(statearr_32412[(6)] = c__31608__auto___32413);

return statearr_32412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto___32413,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__32471 = arguments.length;
switch (G__32471) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,ch);
} else {
var m__29031__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,ch);
} else {
var m__29031__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m);
} else {
var m__29031__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,state_map);
} else {
var m__29031__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__29030__auto__ = (((m == null))?null:m);
var m__29031__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,m,mode);
} else {
var m__29031__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__29523__auto__ = [];
var len__29516__auto___32483 = arguments.length;
var i__29517__auto___32484 = (0);
while(true){
if((i__29517__auto___32484 < len__29516__auto___32483)){
args__29523__auto__.push((arguments[i__29517__auto___32484]));

var G__32485 = (i__29517__auto___32484 + (1));
i__29517__auto___32484 = G__32485;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((3) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29524__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32477){
var map__32478 = p__32477;
var map__32478__$1 = ((((!((map__32478 == null)))?((((map__32478.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32478.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32478):map__32478);
var opts = map__32478__$1;
var statearr_32480_32486 = state;
(statearr_32480_32486[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__32478,map__32478__$1,opts){
return (function (val){
var statearr_32481_32487 = state;
(statearr_32481_32487[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__32478,map__32478__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_32482_32488 = state;
(statearr_32482_32488[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32473){
var G__32474 = cljs.core.first.call(null,seq32473);
var seq32473__$1 = cljs.core.next.call(null,seq32473);
var G__32475 = cljs.core.first.call(null,seq32473__$1);
var seq32473__$2 = cljs.core.next.call(null,seq32473__$1);
var G__32476 = cljs.core.first.call(null,seq32473__$2);
var seq32473__$3 = cljs.core.next.call(null,seq32473__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32474,G__32475,G__32476,seq32473__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32489 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32489 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta32490){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta32490 = meta32490;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32489.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32491,meta32490__$1){
var self__ = this;
var _32491__$1 = this;
return (new cljs.core.async.t_cljs$core$async32489(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta32490__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32489.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32491){
var self__ = this;
var _32491__$1 = this;
return self__.meta32490;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32489.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32489.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32489.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32489.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32489.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32489.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32489.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32489.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32489.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta32490","meta32490",-321199630,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32489.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32489.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32489";

cljs.core.async.t_cljs$core$async32489.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async32489");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async32489 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async32489(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta32490){
return (new cljs.core.async.t_cljs$core$async32489(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta32490));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async32489(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31608__auto___32653 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto___32653,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto___32653,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_32593){
var state_val_32594 = (state_32593[(1)]);
if((state_val_32594 === (7))){
var inst_32508 = (state_32593[(2)]);
var state_32593__$1 = state_32593;
var statearr_32595_32654 = state_32593__$1;
(statearr_32595_32654[(2)] = inst_32508);

(statearr_32595_32654[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (20))){
var inst_32520 = (state_32593[(7)]);
var state_32593__$1 = state_32593;
var statearr_32596_32655 = state_32593__$1;
(statearr_32596_32655[(2)] = inst_32520);

(statearr_32596_32655[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (27))){
var state_32593__$1 = state_32593;
var statearr_32597_32656 = state_32593__$1;
(statearr_32597_32656[(2)] = null);

(statearr_32597_32656[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (1))){
var inst_32495 = (state_32593[(8)]);
var inst_32495__$1 = calc_state.call(null);
var inst_32497 = (inst_32495__$1 == null);
var inst_32498 = cljs.core.not.call(null,inst_32497);
var state_32593__$1 = (function (){var statearr_32598 = state_32593;
(statearr_32598[(8)] = inst_32495__$1);

return statearr_32598;
})();
if(inst_32498){
var statearr_32599_32657 = state_32593__$1;
(statearr_32599_32657[(1)] = (2));

} else {
var statearr_32600_32658 = state_32593__$1;
(statearr_32600_32658[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (24))){
var inst_32544 = (state_32593[(9)]);
var inst_32553 = (state_32593[(10)]);
var inst_32567 = (state_32593[(11)]);
var inst_32567__$1 = inst_32544.call(null,inst_32553);
var state_32593__$1 = (function (){var statearr_32601 = state_32593;
(statearr_32601[(11)] = inst_32567__$1);

return statearr_32601;
})();
if(cljs.core.truth_(inst_32567__$1)){
var statearr_32602_32659 = state_32593__$1;
(statearr_32602_32659[(1)] = (29));

} else {
var statearr_32603_32660 = state_32593__$1;
(statearr_32603_32660[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (4))){
var inst_32511 = (state_32593[(2)]);
var state_32593__$1 = state_32593;
if(cljs.core.truth_(inst_32511)){
var statearr_32604_32661 = state_32593__$1;
(statearr_32604_32661[(1)] = (8));

} else {
var statearr_32605_32662 = state_32593__$1;
(statearr_32605_32662[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (15))){
var inst_32538 = (state_32593[(2)]);
var state_32593__$1 = state_32593;
if(cljs.core.truth_(inst_32538)){
var statearr_32606_32663 = state_32593__$1;
(statearr_32606_32663[(1)] = (19));

} else {
var statearr_32607_32664 = state_32593__$1;
(statearr_32607_32664[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (21))){
var inst_32543 = (state_32593[(12)]);
var inst_32543__$1 = (state_32593[(2)]);
var inst_32544 = cljs.core.get.call(null,inst_32543__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32545 = cljs.core.get.call(null,inst_32543__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32546 = cljs.core.get.call(null,inst_32543__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_32593__$1 = (function (){var statearr_32608 = state_32593;
(statearr_32608[(13)] = inst_32545);

(statearr_32608[(12)] = inst_32543__$1);

(statearr_32608[(9)] = inst_32544);

return statearr_32608;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_32593__$1,(22),inst_32546);
} else {
if((state_val_32594 === (31))){
var inst_32575 = (state_32593[(2)]);
var state_32593__$1 = state_32593;
if(cljs.core.truth_(inst_32575)){
var statearr_32609_32665 = state_32593__$1;
(statearr_32609_32665[(1)] = (32));

} else {
var statearr_32610_32666 = state_32593__$1;
(statearr_32610_32666[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (32))){
var inst_32552 = (state_32593[(14)]);
var state_32593__$1 = state_32593;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32593__$1,(35),out,inst_32552);
} else {
if((state_val_32594 === (33))){
var inst_32543 = (state_32593[(12)]);
var inst_32520 = inst_32543;
var state_32593__$1 = (function (){var statearr_32611 = state_32593;
(statearr_32611[(7)] = inst_32520);

return statearr_32611;
})();
var statearr_32612_32667 = state_32593__$1;
(statearr_32612_32667[(2)] = null);

(statearr_32612_32667[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (13))){
var inst_32520 = (state_32593[(7)]);
var inst_32527 = inst_32520.cljs$lang$protocol_mask$partition0$;
var inst_32528 = (inst_32527 & (64));
var inst_32529 = inst_32520.cljs$core$ISeq$;
var inst_32530 = (cljs.core.PROTOCOL_SENTINEL === inst_32529);
var inst_32531 = (inst_32528) || (inst_32530);
var state_32593__$1 = state_32593;
if(cljs.core.truth_(inst_32531)){
var statearr_32613_32668 = state_32593__$1;
(statearr_32613_32668[(1)] = (16));

} else {
var statearr_32614_32669 = state_32593__$1;
(statearr_32614_32669[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (22))){
var inst_32552 = (state_32593[(14)]);
var inst_32553 = (state_32593[(10)]);
var inst_32551 = (state_32593[(2)]);
var inst_32552__$1 = cljs.core.nth.call(null,inst_32551,(0),null);
var inst_32553__$1 = cljs.core.nth.call(null,inst_32551,(1),null);
var inst_32554 = (inst_32552__$1 == null);
var inst_32555 = cljs.core._EQ_.call(null,inst_32553__$1,change);
var inst_32556 = (inst_32554) || (inst_32555);
var state_32593__$1 = (function (){var statearr_32615 = state_32593;
(statearr_32615[(14)] = inst_32552__$1);

(statearr_32615[(10)] = inst_32553__$1);

return statearr_32615;
})();
if(cljs.core.truth_(inst_32556)){
var statearr_32616_32670 = state_32593__$1;
(statearr_32616_32670[(1)] = (23));

} else {
var statearr_32617_32671 = state_32593__$1;
(statearr_32617_32671[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (36))){
var inst_32543 = (state_32593[(12)]);
var inst_32520 = inst_32543;
var state_32593__$1 = (function (){var statearr_32618 = state_32593;
(statearr_32618[(7)] = inst_32520);

return statearr_32618;
})();
var statearr_32619_32672 = state_32593__$1;
(statearr_32619_32672[(2)] = null);

(statearr_32619_32672[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (29))){
var inst_32567 = (state_32593[(11)]);
var state_32593__$1 = state_32593;
var statearr_32620_32673 = state_32593__$1;
(statearr_32620_32673[(2)] = inst_32567);

(statearr_32620_32673[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (6))){
var state_32593__$1 = state_32593;
var statearr_32621_32674 = state_32593__$1;
(statearr_32621_32674[(2)] = false);

(statearr_32621_32674[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (28))){
var inst_32563 = (state_32593[(2)]);
var inst_32564 = calc_state.call(null);
var inst_32520 = inst_32564;
var state_32593__$1 = (function (){var statearr_32622 = state_32593;
(statearr_32622[(15)] = inst_32563);

(statearr_32622[(7)] = inst_32520);

return statearr_32622;
})();
var statearr_32623_32675 = state_32593__$1;
(statearr_32623_32675[(2)] = null);

(statearr_32623_32675[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (25))){
var inst_32589 = (state_32593[(2)]);
var state_32593__$1 = state_32593;
var statearr_32624_32676 = state_32593__$1;
(statearr_32624_32676[(2)] = inst_32589);

(statearr_32624_32676[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (34))){
var inst_32587 = (state_32593[(2)]);
var state_32593__$1 = state_32593;
var statearr_32625_32677 = state_32593__$1;
(statearr_32625_32677[(2)] = inst_32587);

(statearr_32625_32677[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (17))){
var state_32593__$1 = state_32593;
var statearr_32626_32678 = state_32593__$1;
(statearr_32626_32678[(2)] = false);

(statearr_32626_32678[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (3))){
var state_32593__$1 = state_32593;
var statearr_32627_32679 = state_32593__$1;
(statearr_32627_32679[(2)] = false);

(statearr_32627_32679[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (12))){
var inst_32591 = (state_32593[(2)]);
var state_32593__$1 = state_32593;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32593__$1,inst_32591);
} else {
if((state_val_32594 === (2))){
var inst_32495 = (state_32593[(8)]);
var inst_32500 = inst_32495.cljs$lang$protocol_mask$partition0$;
var inst_32501 = (inst_32500 & (64));
var inst_32502 = inst_32495.cljs$core$ISeq$;
var inst_32503 = (cljs.core.PROTOCOL_SENTINEL === inst_32502);
var inst_32504 = (inst_32501) || (inst_32503);
var state_32593__$1 = state_32593;
if(cljs.core.truth_(inst_32504)){
var statearr_32628_32680 = state_32593__$1;
(statearr_32628_32680[(1)] = (5));

} else {
var statearr_32629_32681 = state_32593__$1;
(statearr_32629_32681[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (23))){
var inst_32552 = (state_32593[(14)]);
var inst_32558 = (inst_32552 == null);
var state_32593__$1 = state_32593;
if(cljs.core.truth_(inst_32558)){
var statearr_32630_32682 = state_32593__$1;
(statearr_32630_32682[(1)] = (26));

} else {
var statearr_32631_32683 = state_32593__$1;
(statearr_32631_32683[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (35))){
var inst_32578 = (state_32593[(2)]);
var state_32593__$1 = state_32593;
if(cljs.core.truth_(inst_32578)){
var statearr_32632_32684 = state_32593__$1;
(statearr_32632_32684[(1)] = (36));

} else {
var statearr_32633_32685 = state_32593__$1;
(statearr_32633_32685[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (19))){
var inst_32520 = (state_32593[(7)]);
var inst_32540 = cljs.core.apply.call(null,cljs.core.hash_map,inst_32520);
var state_32593__$1 = state_32593;
var statearr_32634_32686 = state_32593__$1;
(statearr_32634_32686[(2)] = inst_32540);

(statearr_32634_32686[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (11))){
var inst_32520 = (state_32593[(7)]);
var inst_32524 = (inst_32520 == null);
var inst_32525 = cljs.core.not.call(null,inst_32524);
var state_32593__$1 = state_32593;
if(inst_32525){
var statearr_32635_32687 = state_32593__$1;
(statearr_32635_32687[(1)] = (13));

} else {
var statearr_32636_32688 = state_32593__$1;
(statearr_32636_32688[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (9))){
var inst_32495 = (state_32593[(8)]);
var state_32593__$1 = state_32593;
var statearr_32637_32689 = state_32593__$1;
(statearr_32637_32689[(2)] = inst_32495);

(statearr_32637_32689[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (5))){
var state_32593__$1 = state_32593;
var statearr_32638_32690 = state_32593__$1;
(statearr_32638_32690[(2)] = true);

(statearr_32638_32690[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (14))){
var state_32593__$1 = state_32593;
var statearr_32639_32691 = state_32593__$1;
(statearr_32639_32691[(2)] = false);

(statearr_32639_32691[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (26))){
var inst_32553 = (state_32593[(10)]);
var inst_32560 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_32553);
var state_32593__$1 = state_32593;
var statearr_32640_32692 = state_32593__$1;
(statearr_32640_32692[(2)] = inst_32560);

(statearr_32640_32692[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (16))){
var state_32593__$1 = state_32593;
var statearr_32641_32693 = state_32593__$1;
(statearr_32641_32693[(2)] = true);

(statearr_32641_32693[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (38))){
var inst_32583 = (state_32593[(2)]);
var state_32593__$1 = state_32593;
var statearr_32642_32694 = state_32593__$1;
(statearr_32642_32694[(2)] = inst_32583);

(statearr_32642_32694[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (30))){
var inst_32545 = (state_32593[(13)]);
var inst_32544 = (state_32593[(9)]);
var inst_32553 = (state_32593[(10)]);
var inst_32570 = cljs.core.empty_QMARK_.call(null,inst_32544);
var inst_32571 = inst_32545.call(null,inst_32553);
var inst_32572 = cljs.core.not.call(null,inst_32571);
var inst_32573 = (inst_32570) && (inst_32572);
var state_32593__$1 = state_32593;
var statearr_32643_32695 = state_32593__$1;
(statearr_32643_32695[(2)] = inst_32573);

(statearr_32643_32695[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (10))){
var inst_32495 = (state_32593[(8)]);
var inst_32516 = (state_32593[(2)]);
var inst_32517 = cljs.core.get.call(null,inst_32516,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32518 = cljs.core.get.call(null,inst_32516,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32519 = cljs.core.get.call(null,inst_32516,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_32520 = inst_32495;
var state_32593__$1 = (function (){var statearr_32644 = state_32593;
(statearr_32644[(16)] = inst_32517);

(statearr_32644[(17)] = inst_32518);

(statearr_32644[(18)] = inst_32519);

(statearr_32644[(7)] = inst_32520);

return statearr_32644;
})();
var statearr_32645_32696 = state_32593__$1;
(statearr_32645_32696[(2)] = null);

(statearr_32645_32696[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (18))){
var inst_32535 = (state_32593[(2)]);
var state_32593__$1 = state_32593;
var statearr_32646_32697 = state_32593__$1;
(statearr_32646_32697[(2)] = inst_32535);

(statearr_32646_32697[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (37))){
var state_32593__$1 = state_32593;
var statearr_32647_32698 = state_32593__$1;
(statearr_32647_32698[(2)] = null);

(statearr_32647_32698[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32594 === (8))){
var inst_32495 = (state_32593[(8)]);
var inst_32513 = cljs.core.apply.call(null,cljs.core.hash_map,inst_32495);
var state_32593__$1 = state_32593;
var statearr_32648_32699 = state_32593__$1;
(statearr_32648_32699[(2)] = inst_32513);

(statearr_32648_32699[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31608__auto___32653,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__31520__auto__,c__31608__auto___32653,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__31521__auto__ = null;
var cljs$core$async$mix_$_state_machine__31521__auto____0 = (function (){
var statearr_32649 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32649[(0)] = cljs$core$async$mix_$_state_machine__31521__auto__);

(statearr_32649[(1)] = (1));

return statearr_32649;
});
var cljs$core$async$mix_$_state_machine__31521__auto____1 = (function (state_32593){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_32593);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e32650){if((e32650 instanceof Object)){
var ex__31524__auto__ = e32650;
var statearr_32651_32700 = state_32593;
(statearr_32651_32700[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32593);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32650;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32701 = state_32593;
state_32593 = G__32701;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__31521__auto__ = function(state_32593){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__31521__auto____1.call(this,state_32593);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__31521__auto____0;
cljs$core$async$mix_$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__31521__auto____1;
return cljs$core$async$mix_$_state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto___32653,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__31610__auto__ = (function (){var statearr_32652 = f__31609__auto__.call(null);
(statearr_32652[(6)] = c__31608__auto___32653);

return statearr_32652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto___32653,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__29030__auto__ = (((p == null))?null:p);
var m__29031__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__29031__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__29030__auto__ = (((p == null))?null:p);
var m__29031__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,p,v,ch);
} else {
var m__29031__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__32703 = arguments.length;
switch (G__32703) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__29030__auto__ = (((p == null))?null:p);
var m__29031__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,p);
} else {
var m__29031__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__29030__auto__ = (((p == null))?null:p);
var m__29031__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__29030__auto__)]);
if(!((m__29031__auto__ == null))){
return m__29031__auto__.call(null,p,v);
} else {
var m__29031__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__29031__auto____$1 == null))){
return m__29031__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__32707 = arguments.length;
switch (G__32707) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__28347__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__28347__auto__,mults){
return (function (p1__32705_SHARP_){
if(cljs.core.truth_(p1__32705_SHARP_.call(null,topic))){
return p1__32705_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__32705_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__28347__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async32708 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32708 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32709){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32709 = meta32709;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32708.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_32710,meta32709__$1){
var self__ = this;
var _32710__$1 = this;
return (new cljs.core.async.t_cljs$core$async32708(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32709__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32708.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_32710){
var self__ = this;
var _32710__$1 = this;
return self__.meta32709;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32708.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32708.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32708.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32708.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32708.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32708.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32708.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32708.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta32709","meta32709",-1695605243,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32708.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32708.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32708";

cljs.core.async.t_cljs$core$async32708.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async32708");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async32708 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async32708(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32709){
return (new cljs.core.async.t_cljs$core$async32708(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32709));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async32708(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31608__auto___32828 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto___32828,mults,ensure_mult,p){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto___32828,mults,ensure_mult,p){
return (function (state_32782){
var state_val_32783 = (state_32782[(1)]);
if((state_val_32783 === (7))){
var inst_32778 = (state_32782[(2)]);
var state_32782__$1 = state_32782;
var statearr_32784_32829 = state_32782__$1;
(statearr_32784_32829[(2)] = inst_32778);

(statearr_32784_32829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (20))){
var state_32782__$1 = state_32782;
var statearr_32785_32830 = state_32782__$1;
(statearr_32785_32830[(2)] = null);

(statearr_32785_32830[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (1))){
var state_32782__$1 = state_32782;
var statearr_32786_32831 = state_32782__$1;
(statearr_32786_32831[(2)] = null);

(statearr_32786_32831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (24))){
var inst_32761 = (state_32782[(7)]);
var inst_32770 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_32761);
var state_32782__$1 = state_32782;
var statearr_32787_32832 = state_32782__$1;
(statearr_32787_32832[(2)] = inst_32770);

(statearr_32787_32832[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (4))){
var inst_32713 = (state_32782[(8)]);
var inst_32713__$1 = (state_32782[(2)]);
var inst_32714 = (inst_32713__$1 == null);
var state_32782__$1 = (function (){var statearr_32788 = state_32782;
(statearr_32788[(8)] = inst_32713__$1);

return statearr_32788;
})();
if(cljs.core.truth_(inst_32714)){
var statearr_32789_32833 = state_32782__$1;
(statearr_32789_32833[(1)] = (5));

} else {
var statearr_32790_32834 = state_32782__$1;
(statearr_32790_32834[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (15))){
var inst_32755 = (state_32782[(2)]);
var state_32782__$1 = state_32782;
var statearr_32791_32835 = state_32782__$1;
(statearr_32791_32835[(2)] = inst_32755);

(statearr_32791_32835[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (21))){
var inst_32775 = (state_32782[(2)]);
var state_32782__$1 = (function (){var statearr_32792 = state_32782;
(statearr_32792[(9)] = inst_32775);

return statearr_32792;
})();
var statearr_32793_32836 = state_32782__$1;
(statearr_32793_32836[(2)] = null);

(statearr_32793_32836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (13))){
var inst_32737 = (state_32782[(10)]);
var inst_32739 = cljs.core.chunked_seq_QMARK_.call(null,inst_32737);
var state_32782__$1 = state_32782;
if(inst_32739){
var statearr_32794_32837 = state_32782__$1;
(statearr_32794_32837[(1)] = (16));

} else {
var statearr_32795_32838 = state_32782__$1;
(statearr_32795_32838[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (22))){
var inst_32767 = (state_32782[(2)]);
var state_32782__$1 = state_32782;
if(cljs.core.truth_(inst_32767)){
var statearr_32796_32839 = state_32782__$1;
(statearr_32796_32839[(1)] = (23));

} else {
var statearr_32797_32840 = state_32782__$1;
(statearr_32797_32840[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (6))){
var inst_32761 = (state_32782[(7)]);
var inst_32763 = (state_32782[(11)]);
var inst_32713 = (state_32782[(8)]);
var inst_32761__$1 = topic_fn.call(null,inst_32713);
var inst_32762 = cljs.core.deref.call(null,mults);
var inst_32763__$1 = cljs.core.get.call(null,inst_32762,inst_32761__$1);
var state_32782__$1 = (function (){var statearr_32798 = state_32782;
(statearr_32798[(7)] = inst_32761__$1);

(statearr_32798[(11)] = inst_32763__$1);

return statearr_32798;
})();
if(cljs.core.truth_(inst_32763__$1)){
var statearr_32799_32841 = state_32782__$1;
(statearr_32799_32841[(1)] = (19));

} else {
var statearr_32800_32842 = state_32782__$1;
(statearr_32800_32842[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (25))){
var inst_32772 = (state_32782[(2)]);
var state_32782__$1 = state_32782;
var statearr_32801_32843 = state_32782__$1;
(statearr_32801_32843[(2)] = inst_32772);

(statearr_32801_32843[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (17))){
var inst_32737 = (state_32782[(10)]);
var inst_32746 = cljs.core.first.call(null,inst_32737);
var inst_32747 = cljs.core.async.muxch_STAR_.call(null,inst_32746);
var inst_32748 = cljs.core.async.close_BANG_.call(null,inst_32747);
var inst_32749 = cljs.core.next.call(null,inst_32737);
var inst_32723 = inst_32749;
var inst_32724 = null;
var inst_32725 = (0);
var inst_32726 = (0);
var state_32782__$1 = (function (){var statearr_32802 = state_32782;
(statearr_32802[(12)] = inst_32748);

(statearr_32802[(13)] = inst_32725);

(statearr_32802[(14)] = inst_32724);

(statearr_32802[(15)] = inst_32723);

(statearr_32802[(16)] = inst_32726);

return statearr_32802;
})();
var statearr_32803_32844 = state_32782__$1;
(statearr_32803_32844[(2)] = null);

(statearr_32803_32844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (3))){
var inst_32780 = (state_32782[(2)]);
var state_32782__$1 = state_32782;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32782__$1,inst_32780);
} else {
if((state_val_32783 === (12))){
var inst_32757 = (state_32782[(2)]);
var state_32782__$1 = state_32782;
var statearr_32804_32845 = state_32782__$1;
(statearr_32804_32845[(2)] = inst_32757);

(statearr_32804_32845[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (2))){
var state_32782__$1 = state_32782;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32782__$1,(4),ch);
} else {
if((state_val_32783 === (23))){
var state_32782__$1 = state_32782;
var statearr_32805_32846 = state_32782__$1;
(statearr_32805_32846[(2)] = null);

(statearr_32805_32846[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (19))){
var inst_32763 = (state_32782[(11)]);
var inst_32713 = (state_32782[(8)]);
var inst_32765 = cljs.core.async.muxch_STAR_.call(null,inst_32763);
var state_32782__$1 = state_32782;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32782__$1,(22),inst_32765,inst_32713);
} else {
if((state_val_32783 === (11))){
var inst_32737 = (state_32782[(10)]);
var inst_32723 = (state_32782[(15)]);
var inst_32737__$1 = cljs.core.seq.call(null,inst_32723);
var state_32782__$1 = (function (){var statearr_32806 = state_32782;
(statearr_32806[(10)] = inst_32737__$1);

return statearr_32806;
})();
if(inst_32737__$1){
var statearr_32807_32847 = state_32782__$1;
(statearr_32807_32847[(1)] = (13));

} else {
var statearr_32808_32848 = state_32782__$1;
(statearr_32808_32848[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (9))){
var inst_32759 = (state_32782[(2)]);
var state_32782__$1 = state_32782;
var statearr_32809_32849 = state_32782__$1;
(statearr_32809_32849[(2)] = inst_32759);

(statearr_32809_32849[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (5))){
var inst_32720 = cljs.core.deref.call(null,mults);
var inst_32721 = cljs.core.vals.call(null,inst_32720);
var inst_32722 = cljs.core.seq.call(null,inst_32721);
var inst_32723 = inst_32722;
var inst_32724 = null;
var inst_32725 = (0);
var inst_32726 = (0);
var state_32782__$1 = (function (){var statearr_32810 = state_32782;
(statearr_32810[(13)] = inst_32725);

(statearr_32810[(14)] = inst_32724);

(statearr_32810[(15)] = inst_32723);

(statearr_32810[(16)] = inst_32726);

return statearr_32810;
})();
var statearr_32811_32850 = state_32782__$1;
(statearr_32811_32850[(2)] = null);

(statearr_32811_32850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (14))){
var state_32782__$1 = state_32782;
var statearr_32815_32851 = state_32782__$1;
(statearr_32815_32851[(2)] = null);

(statearr_32815_32851[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (16))){
var inst_32737 = (state_32782[(10)]);
var inst_32741 = cljs.core.chunk_first.call(null,inst_32737);
var inst_32742 = cljs.core.chunk_rest.call(null,inst_32737);
var inst_32743 = cljs.core.count.call(null,inst_32741);
var inst_32723 = inst_32742;
var inst_32724 = inst_32741;
var inst_32725 = inst_32743;
var inst_32726 = (0);
var state_32782__$1 = (function (){var statearr_32816 = state_32782;
(statearr_32816[(13)] = inst_32725);

(statearr_32816[(14)] = inst_32724);

(statearr_32816[(15)] = inst_32723);

(statearr_32816[(16)] = inst_32726);

return statearr_32816;
})();
var statearr_32817_32852 = state_32782__$1;
(statearr_32817_32852[(2)] = null);

(statearr_32817_32852[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (10))){
var inst_32725 = (state_32782[(13)]);
var inst_32724 = (state_32782[(14)]);
var inst_32723 = (state_32782[(15)]);
var inst_32726 = (state_32782[(16)]);
var inst_32731 = cljs.core._nth.call(null,inst_32724,inst_32726);
var inst_32732 = cljs.core.async.muxch_STAR_.call(null,inst_32731);
var inst_32733 = cljs.core.async.close_BANG_.call(null,inst_32732);
var inst_32734 = (inst_32726 + (1));
var tmp32812 = inst_32725;
var tmp32813 = inst_32724;
var tmp32814 = inst_32723;
var inst_32723__$1 = tmp32814;
var inst_32724__$1 = tmp32813;
var inst_32725__$1 = tmp32812;
var inst_32726__$1 = inst_32734;
var state_32782__$1 = (function (){var statearr_32818 = state_32782;
(statearr_32818[(13)] = inst_32725__$1);

(statearr_32818[(14)] = inst_32724__$1);

(statearr_32818[(15)] = inst_32723__$1);

(statearr_32818[(16)] = inst_32726__$1);

(statearr_32818[(17)] = inst_32733);

return statearr_32818;
})();
var statearr_32819_32853 = state_32782__$1;
(statearr_32819_32853[(2)] = null);

(statearr_32819_32853[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (18))){
var inst_32752 = (state_32782[(2)]);
var state_32782__$1 = state_32782;
var statearr_32820_32854 = state_32782__$1;
(statearr_32820_32854[(2)] = inst_32752);

(statearr_32820_32854[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32783 === (8))){
var inst_32725 = (state_32782[(13)]);
var inst_32726 = (state_32782[(16)]);
var inst_32728 = (inst_32726 < inst_32725);
var inst_32729 = inst_32728;
var state_32782__$1 = state_32782;
if(cljs.core.truth_(inst_32729)){
var statearr_32821_32855 = state_32782__$1;
(statearr_32821_32855[(1)] = (10));

} else {
var statearr_32822_32856 = state_32782__$1;
(statearr_32822_32856[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31608__auto___32828,mults,ensure_mult,p))
;
return ((function (switch__31520__auto__,c__31608__auto___32828,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__31521__auto__ = null;
var cljs$core$async$state_machine__31521__auto____0 = (function (){
var statearr_32823 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32823[(0)] = cljs$core$async$state_machine__31521__auto__);

(statearr_32823[(1)] = (1));

return statearr_32823;
});
var cljs$core$async$state_machine__31521__auto____1 = (function (state_32782){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_32782);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e32824){if((e32824 instanceof Object)){
var ex__31524__auto__ = e32824;
var statearr_32825_32857 = state_32782;
(statearr_32825_32857[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32782);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32824;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32858 = state_32782;
state_32782 = G__32858;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$state_machine__31521__auto__ = function(state_32782){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31521__auto____1.call(this,state_32782);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31521__auto____0;
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31521__auto____1;
return cljs$core$async$state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto___32828,mults,ensure_mult,p))
})();
var state__31610__auto__ = (function (){var statearr_32826 = f__31609__auto__.call(null);
(statearr_32826[(6)] = c__31608__auto___32828);

return statearr_32826;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto___32828,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__32860 = arguments.length;
switch (G__32860) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__32863 = arguments.length;
switch (G__32863) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__32866 = arguments.length;
switch (G__32866) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__31608__auto___32933 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto___32933,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto___32933,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_32905){
var state_val_32906 = (state_32905[(1)]);
if((state_val_32906 === (7))){
var state_32905__$1 = state_32905;
var statearr_32907_32934 = state_32905__$1;
(statearr_32907_32934[(2)] = null);

(statearr_32907_32934[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32906 === (1))){
var state_32905__$1 = state_32905;
var statearr_32908_32935 = state_32905__$1;
(statearr_32908_32935[(2)] = null);

(statearr_32908_32935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32906 === (4))){
var inst_32869 = (state_32905[(7)]);
var inst_32871 = (inst_32869 < cnt);
var state_32905__$1 = state_32905;
if(cljs.core.truth_(inst_32871)){
var statearr_32909_32936 = state_32905__$1;
(statearr_32909_32936[(1)] = (6));

} else {
var statearr_32910_32937 = state_32905__$1;
(statearr_32910_32937[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32906 === (15))){
var inst_32901 = (state_32905[(2)]);
var state_32905__$1 = state_32905;
var statearr_32911_32938 = state_32905__$1;
(statearr_32911_32938[(2)] = inst_32901);

(statearr_32911_32938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32906 === (13))){
var inst_32894 = cljs.core.async.close_BANG_.call(null,out);
var state_32905__$1 = state_32905;
var statearr_32912_32939 = state_32905__$1;
(statearr_32912_32939[(2)] = inst_32894);

(statearr_32912_32939[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32906 === (6))){
var state_32905__$1 = state_32905;
var statearr_32913_32940 = state_32905__$1;
(statearr_32913_32940[(2)] = null);

(statearr_32913_32940[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32906 === (3))){
var inst_32903 = (state_32905[(2)]);
var state_32905__$1 = state_32905;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32905__$1,inst_32903);
} else {
if((state_val_32906 === (12))){
var inst_32891 = (state_32905[(8)]);
var inst_32891__$1 = (state_32905[(2)]);
var inst_32892 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_32891__$1);
var state_32905__$1 = (function (){var statearr_32914 = state_32905;
(statearr_32914[(8)] = inst_32891__$1);

return statearr_32914;
})();
if(cljs.core.truth_(inst_32892)){
var statearr_32915_32941 = state_32905__$1;
(statearr_32915_32941[(1)] = (13));

} else {
var statearr_32916_32942 = state_32905__$1;
(statearr_32916_32942[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32906 === (2))){
var inst_32868 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_32869 = (0);
var state_32905__$1 = (function (){var statearr_32917 = state_32905;
(statearr_32917[(9)] = inst_32868);

(statearr_32917[(7)] = inst_32869);

return statearr_32917;
})();
var statearr_32918_32943 = state_32905__$1;
(statearr_32918_32943[(2)] = null);

(statearr_32918_32943[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32906 === (11))){
var inst_32869 = (state_32905[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_32905,(10),Object,null,(9));
var inst_32878 = chs__$1.call(null,inst_32869);
var inst_32879 = done.call(null,inst_32869);
var inst_32880 = cljs.core.async.take_BANG_.call(null,inst_32878,inst_32879);
var state_32905__$1 = state_32905;
var statearr_32919_32944 = state_32905__$1;
(statearr_32919_32944[(2)] = inst_32880);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32905__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32906 === (9))){
var inst_32869 = (state_32905[(7)]);
var inst_32882 = (state_32905[(2)]);
var inst_32883 = (inst_32869 + (1));
var inst_32869__$1 = inst_32883;
var state_32905__$1 = (function (){var statearr_32920 = state_32905;
(statearr_32920[(10)] = inst_32882);

(statearr_32920[(7)] = inst_32869__$1);

return statearr_32920;
})();
var statearr_32921_32945 = state_32905__$1;
(statearr_32921_32945[(2)] = null);

(statearr_32921_32945[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32906 === (5))){
var inst_32889 = (state_32905[(2)]);
var state_32905__$1 = (function (){var statearr_32922 = state_32905;
(statearr_32922[(11)] = inst_32889);

return statearr_32922;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32905__$1,(12),dchan);
} else {
if((state_val_32906 === (14))){
var inst_32891 = (state_32905[(8)]);
var inst_32896 = cljs.core.apply.call(null,f,inst_32891);
var state_32905__$1 = state_32905;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32905__$1,(16),out,inst_32896);
} else {
if((state_val_32906 === (16))){
var inst_32898 = (state_32905[(2)]);
var state_32905__$1 = (function (){var statearr_32923 = state_32905;
(statearr_32923[(12)] = inst_32898);

return statearr_32923;
})();
var statearr_32924_32946 = state_32905__$1;
(statearr_32924_32946[(2)] = null);

(statearr_32924_32946[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32906 === (10))){
var inst_32873 = (state_32905[(2)]);
var inst_32874 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_32905__$1 = (function (){var statearr_32925 = state_32905;
(statearr_32925[(13)] = inst_32873);

return statearr_32925;
})();
var statearr_32926_32947 = state_32905__$1;
(statearr_32926_32947[(2)] = inst_32874);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32905__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32906 === (8))){
var inst_32887 = (state_32905[(2)]);
var state_32905__$1 = state_32905;
var statearr_32927_32948 = state_32905__$1;
(statearr_32927_32948[(2)] = inst_32887);

(statearr_32927_32948[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31608__auto___32933,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__31520__auto__,c__31608__auto___32933,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__31521__auto__ = null;
var cljs$core$async$state_machine__31521__auto____0 = (function (){
var statearr_32928 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32928[(0)] = cljs$core$async$state_machine__31521__auto__);

(statearr_32928[(1)] = (1));

return statearr_32928;
});
var cljs$core$async$state_machine__31521__auto____1 = (function (state_32905){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_32905);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e32929){if((e32929 instanceof Object)){
var ex__31524__auto__ = e32929;
var statearr_32930_32949 = state_32905;
(statearr_32930_32949[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32905);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32929;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32950 = state_32905;
state_32905 = G__32950;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$state_machine__31521__auto__ = function(state_32905){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31521__auto____1.call(this,state_32905);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31521__auto____0;
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31521__auto____1;
return cljs$core$async$state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto___32933,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__31610__auto__ = (function (){var statearr_32931 = f__31609__auto__.call(null);
(statearr_32931[(6)] = c__31608__auto___32933);

return statearr_32931;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto___32933,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__32953 = arguments.length;
switch (G__32953) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31608__auto___33007 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto___33007,out){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto___33007,out){
return (function (state_32985){
var state_val_32986 = (state_32985[(1)]);
if((state_val_32986 === (7))){
var inst_32964 = (state_32985[(7)]);
var inst_32965 = (state_32985[(8)]);
var inst_32964__$1 = (state_32985[(2)]);
var inst_32965__$1 = cljs.core.nth.call(null,inst_32964__$1,(0),null);
var inst_32966 = cljs.core.nth.call(null,inst_32964__$1,(1),null);
var inst_32967 = (inst_32965__$1 == null);
var state_32985__$1 = (function (){var statearr_32987 = state_32985;
(statearr_32987[(7)] = inst_32964__$1);

(statearr_32987[(9)] = inst_32966);

(statearr_32987[(8)] = inst_32965__$1);

return statearr_32987;
})();
if(cljs.core.truth_(inst_32967)){
var statearr_32988_33008 = state_32985__$1;
(statearr_32988_33008[(1)] = (8));

} else {
var statearr_32989_33009 = state_32985__$1;
(statearr_32989_33009[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32986 === (1))){
var inst_32954 = cljs.core.vec.call(null,chs);
var inst_32955 = inst_32954;
var state_32985__$1 = (function (){var statearr_32990 = state_32985;
(statearr_32990[(10)] = inst_32955);

return statearr_32990;
})();
var statearr_32991_33010 = state_32985__$1;
(statearr_32991_33010[(2)] = null);

(statearr_32991_33010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32986 === (4))){
var inst_32955 = (state_32985[(10)]);
var state_32985__$1 = state_32985;
return cljs.core.async.ioc_alts_BANG_.call(null,state_32985__$1,(7),inst_32955);
} else {
if((state_val_32986 === (6))){
var inst_32981 = (state_32985[(2)]);
var state_32985__$1 = state_32985;
var statearr_32992_33011 = state_32985__$1;
(statearr_32992_33011[(2)] = inst_32981);

(statearr_32992_33011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32986 === (3))){
var inst_32983 = (state_32985[(2)]);
var state_32985__$1 = state_32985;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32985__$1,inst_32983);
} else {
if((state_val_32986 === (2))){
var inst_32955 = (state_32985[(10)]);
var inst_32957 = cljs.core.count.call(null,inst_32955);
var inst_32958 = (inst_32957 > (0));
var state_32985__$1 = state_32985;
if(cljs.core.truth_(inst_32958)){
var statearr_32994_33012 = state_32985__$1;
(statearr_32994_33012[(1)] = (4));

} else {
var statearr_32995_33013 = state_32985__$1;
(statearr_32995_33013[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32986 === (11))){
var inst_32955 = (state_32985[(10)]);
var inst_32974 = (state_32985[(2)]);
var tmp32993 = inst_32955;
var inst_32955__$1 = tmp32993;
var state_32985__$1 = (function (){var statearr_32996 = state_32985;
(statearr_32996[(11)] = inst_32974);

(statearr_32996[(10)] = inst_32955__$1);

return statearr_32996;
})();
var statearr_32997_33014 = state_32985__$1;
(statearr_32997_33014[(2)] = null);

(statearr_32997_33014[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32986 === (9))){
var inst_32965 = (state_32985[(8)]);
var state_32985__$1 = state_32985;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32985__$1,(11),out,inst_32965);
} else {
if((state_val_32986 === (5))){
var inst_32979 = cljs.core.async.close_BANG_.call(null,out);
var state_32985__$1 = state_32985;
var statearr_32998_33015 = state_32985__$1;
(statearr_32998_33015[(2)] = inst_32979);

(statearr_32998_33015[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32986 === (10))){
var inst_32977 = (state_32985[(2)]);
var state_32985__$1 = state_32985;
var statearr_32999_33016 = state_32985__$1;
(statearr_32999_33016[(2)] = inst_32977);

(statearr_32999_33016[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32986 === (8))){
var inst_32964 = (state_32985[(7)]);
var inst_32966 = (state_32985[(9)]);
var inst_32965 = (state_32985[(8)]);
var inst_32955 = (state_32985[(10)]);
var inst_32969 = (function (){var cs = inst_32955;
var vec__32960 = inst_32964;
var v = inst_32965;
var c = inst_32966;
return ((function (cs,vec__32960,v,c,inst_32964,inst_32966,inst_32965,inst_32955,state_val_32986,c__31608__auto___33007,out){
return (function (p1__32951_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__32951_SHARP_);
});
;})(cs,vec__32960,v,c,inst_32964,inst_32966,inst_32965,inst_32955,state_val_32986,c__31608__auto___33007,out))
})();
var inst_32970 = cljs.core.filterv.call(null,inst_32969,inst_32955);
var inst_32955__$1 = inst_32970;
var state_32985__$1 = (function (){var statearr_33000 = state_32985;
(statearr_33000[(10)] = inst_32955__$1);

return statearr_33000;
})();
var statearr_33001_33017 = state_32985__$1;
(statearr_33001_33017[(2)] = null);

(statearr_33001_33017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31608__auto___33007,out))
;
return ((function (switch__31520__auto__,c__31608__auto___33007,out){
return (function() {
var cljs$core$async$state_machine__31521__auto__ = null;
var cljs$core$async$state_machine__31521__auto____0 = (function (){
var statearr_33002 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33002[(0)] = cljs$core$async$state_machine__31521__auto__);

(statearr_33002[(1)] = (1));

return statearr_33002;
});
var cljs$core$async$state_machine__31521__auto____1 = (function (state_32985){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_32985);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e33003){if((e33003 instanceof Object)){
var ex__31524__auto__ = e33003;
var statearr_33004_33018 = state_32985;
(statearr_33004_33018[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32985);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33003;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33019 = state_32985;
state_32985 = G__33019;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$state_machine__31521__auto__ = function(state_32985){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31521__auto____1.call(this,state_32985);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31521__auto____0;
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31521__auto____1;
return cljs$core$async$state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto___33007,out))
})();
var state__31610__auto__ = (function (){var statearr_33005 = f__31609__auto__.call(null);
(statearr_33005[(6)] = c__31608__auto___33007);

return statearr_33005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto___33007,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__33021 = arguments.length;
switch (G__33021) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31608__auto___33066 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto___33066,out){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto___33066,out){
return (function (state_33045){
var state_val_33046 = (state_33045[(1)]);
if((state_val_33046 === (7))){
var inst_33027 = (state_33045[(7)]);
var inst_33027__$1 = (state_33045[(2)]);
var inst_33028 = (inst_33027__$1 == null);
var inst_33029 = cljs.core.not.call(null,inst_33028);
var state_33045__$1 = (function (){var statearr_33047 = state_33045;
(statearr_33047[(7)] = inst_33027__$1);

return statearr_33047;
})();
if(inst_33029){
var statearr_33048_33067 = state_33045__$1;
(statearr_33048_33067[(1)] = (8));

} else {
var statearr_33049_33068 = state_33045__$1;
(statearr_33049_33068[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33046 === (1))){
var inst_33022 = (0);
var state_33045__$1 = (function (){var statearr_33050 = state_33045;
(statearr_33050[(8)] = inst_33022);

return statearr_33050;
})();
var statearr_33051_33069 = state_33045__$1;
(statearr_33051_33069[(2)] = null);

(statearr_33051_33069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33046 === (4))){
var state_33045__$1 = state_33045;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33045__$1,(7),ch);
} else {
if((state_val_33046 === (6))){
var inst_33040 = (state_33045[(2)]);
var state_33045__$1 = state_33045;
var statearr_33052_33070 = state_33045__$1;
(statearr_33052_33070[(2)] = inst_33040);

(statearr_33052_33070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33046 === (3))){
var inst_33042 = (state_33045[(2)]);
var inst_33043 = cljs.core.async.close_BANG_.call(null,out);
var state_33045__$1 = (function (){var statearr_33053 = state_33045;
(statearr_33053[(9)] = inst_33042);

return statearr_33053;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33045__$1,inst_33043);
} else {
if((state_val_33046 === (2))){
var inst_33022 = (state_33045[(8)]);
var inst_33024 = (inst_33022 < n);
var state_33045__$1 = state_33045;
if(cljs.core.truth_(inst_33024)){
var statearr_33054_33071 = state_33045__$1;
(statearr_33054_33071[(1)] = (4));

} else {
var statearr_33055_33072 = state_33045__$1;
(statearr_33055_33072[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33046 === (11))){
var inst_33022 = (state_33045[(8)]);
var inst_33032 = (state_33045[(2)]);
var inst_33033 = (inst_33022 + (1));
var inst_33022__$1 = inst_33033;
var state_33045__$1 = (function (){var statearr_33056 = state_33045;
(statearr_33056[(10)] = inst_33032);

(statearr_33056[(8)] = inst_33022__$1);

return statearr_33056;
})();
var statearr_33057_33073 = state_33045__$1;
(statearr_33057_33073[(2)] = null);

(statearr_33057_33073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33046 === (9))){
var state_33045__$1 = state_33045;
var statearr_33058_33074 = state_33045__$1;
(statearr_33058_33074[(2)] = null);

(statearr_33058_33074[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33046 === (5))){
var state_33045__$1 = state_33045;
var statearr_33059_33075 = state_33045__$1;
(statearr_33059_33075[(2)] = null);

(statearr_33059_33075[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33046 === (10))){
var inst_33037 = (state_33045[(2)]);
var state_33045__$1 = state_33045;
var statearr_33060_33076 = state_33045__$1;
(statearr_33060_33076[(2)] = inst_33037);

(statearr_33060_33076[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33046 === (8))){
var inst_33027 = (state_33045[(7)]);
var state_33045__$1 = state_33045;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33045__$1,(11),out,inst_33027);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31608__auto___33066,out))
;
return ((function (switch__31520__auto__,c__31608__auto___33066,out){
return (function() {
var cljs$core$async$state_machine__31521__auto__ = null;
var cljs$core$async$state_machine__31521__auto____0 = (function (){
var statearr_33061 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33061[(0)] = cljs$core$async$state_machine__31521__auto__);

(statearr_33061[(1)] = (1));

return statearr_33061;
});
var cljs$core$async$state_machine__31521__auto____1 = (function (state_33045){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_33045);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e33062){if((e33062 instanceof Object)){
var ex__31524__auto__ = e33062;
var statearr_33063_33077 = state_33045;
(statearr_33063_33077[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33045);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33062;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33078 = state_33045;
state_33045 = G__33078;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$state_machine__31521__auto__ = function(state_33045){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31521__auto____1.call(this,state_33045);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31521__auto____0;
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31521__auto____1;
return cljs$core$async$state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto___33066,out))
})();
var state__31610__auto__ = (function (){var statearr_33064 = f__31609__auto__.call(null);
(statearr_33064[(6)] = c__31608__auto___33066);

return statearr_33064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto___33066,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33080 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33080 = (function (f,ch,meta33081){
this.f = f;
this.ch = ch;
this.meta33081 = meta33081;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33080.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33082,meta33081__$1){
var self__ = this;
var _33082__$1 = this;
return (new cljs.core.async.t_cljs$core$async33080(self__.f,self__.ch,meta33081__$1));
});

cljs.core.async.t_cljs$core$async33080.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33082){
var self__ = this;
var _33082__$1 = this;
return self__.meta33081;
});

cljs.core.async.t_cljs$core$async33080.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33080.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33080.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33080.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33080.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async33083 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33083 = (function (f,ch,meta33081,_,fn1,meta33084){
this.f = f;
this.ch = ch;
this.meta33081 = meta33081;
this._ = _;
this.fn1 = fn1;
this.meta33084 = meta33084;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33083.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_33085,meta33084__$1){
var self__ = this;
var _33085__$1 = this;
return (new cljs.core.async.t_cljs$core$async33083(self__.f,self__.ch,self__.meta33081,self__._,self__.fn1,meta33084__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async33083.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_33085){
var self__ = this;
var _33085__$1 = this;
return self__.meta33084;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33083.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33083.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33083.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33083.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__33079_SHARP_){
return f1.call(null,(((p1__33079_SHARP_ == null))?null:self__.f.call(null,p1__33079_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async33083.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33081","meta33081",1069389030,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async33080","cljs.core.async/t_cljs$core$async33080",120240457,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta33084","meta33084",-1775002230,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33083.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33083.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33083";

cljs.core.async.t_cljs$core$async33083.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async33083");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async33083 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33083(f__$1,ch__$1,meta33081__$1,___$2,fn1__$1,meta33084){
return (new cljs.core.async.t_cljs$core$async33083(f__$1,ch__$1,meta33081__$1,___$2,fn1__$1,meta33084));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async33083(self__.f,self__.ch,self__.meta33081,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__28335__auto__ = ret;
if(cljs.core.truth_(and__28335__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__28335__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async33080.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33080.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async33080.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33081","meta33081",1069389030,null)], null);
});

cljs.core.async.t_cljs$core$async33080.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33080.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33080";

cljs.core.async.t_cljs$core$async33080.cljs$lang$ctorPrWriter = (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async33080");
});

cljs.core.async.__GT_t_cljs$core$async33080 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33080(f__$1,ch__$1,meta33081){
return (new cljs.core.async.t_cljs$core$async33080(f__$1,ch__$1,meta33081));
});

}

return (new cljs.core.async.t_cljs$core$async33080(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33086 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33086 = (function (f,ch,meta33087){
this.f = f;
this.ch = ch;
this.meta33087 = meta33087;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33086.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33088,meta33087__$1){
var self__ = this;
var _33088__$1 = this;
return (new cljs.core.async.t_cljs$core$async33086(self__.f,self__.ch,meta33087__$1));
});

cljs.core.async.t_cljs$core$async33086.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33088){
var self__ = this;
var _33088__$1 = this;
return self__.meta33087;
});

cljs.core.async.t_cljs$core$async33086.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33086.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33086.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33086.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33086.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33086.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async33086.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33087","meta33087",617611565,null)], null);
});

cljs.core.async.t_cljs$core$async33086.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33086.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33086";

cljs.core.async.t_cljs$core$async33086.cljs$lang$ctorPrWriter = (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async33086");
});

cljs.core.async.__GT_t_cljs$core$async33086 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async33086(f__$1,ch__$1,meta33087){
return (new cljs.core.async.t_cljs$core$async33086(f__$1,ch__$1,meta33087));
});

}

return (new cljs.core.async.t_cljs$core$async33086(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async33089 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33089 = (function (p,ch,meta33090){
this.p = p;
this.ch = ch;
this.meta33090 = meta33090;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33089.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33091,meta33090__$1){
var self__ = this;
var _33091__$1 = this;
return (new cljs.core.async.t_cljs$core$async33089(self__.p,self__.ch,meta33090__$1));
});

cljs.core.async.t_cljs$core$async33089.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33091){
var self__ = this;
var _33091__$1 = this;
return self__.meta33090;
});

cljs.core.async.t_cljs$core$async33089.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33089.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33089.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33089.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33089.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33089.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33089.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async33089.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33090","meta33090",-1508258114,null)], null);
});

cljs.core.async.t_cljs$core$async33089.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33089.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33089";

cljs.core.async.t_cljs$core$async33089.cljs$lang$ctorPrWriter = (function (this__28972__auto__,writer__28973__auto__,opt__28974__auto__){
return cljs.core._write.call(null,writer__28973__auto__,"cljs.core.async/t_cljs$core$async33089");
});

cljs.core.async.__GT_t_cljs$core$async33089 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async33089(p__$1,ch__$1,meta33090){
return (new cljs.core.async.t_cljs$core$async33089(p__$1,ch__$1,meta33090));
});

}

return (new cljs.core.async.t_cljs$core$async33089(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__33093 = arguments.length;
switch (G__33093) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31608__auto___33133 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto___33133,out){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto___33133,out){
return (function (state_33114){
var state_val_33115 = (state_33114[(1)]);
if((state_val_33115 === (7))){
var inst_33110 = (state_33114[(2)]);
var state_33114__$1 = state_33114;
var statearr_33116_33134 = state_33114__$1;
(statearr_33116_33134[(2)] = inst_33110);

(statearr_33116_33134[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33115 === (1))){
var state_33114__$1 = state_33114;
var statearr_33117_33135 = state_33114__$1;
(statearr_33117_33135[(2)] = null);

(statearr_33117_33135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33115 === (4))){
var inst_33096 = (state_33114[(7)]);
var inst_33096__$1 = (state_33114[(2)]);
var inst_33097 = (inst_33096__$1 == null);
var state_33114__$1 = (function (){var statearr_33118 = state_33114;
(statearr_33118[(7)] = inst_33096__$1);

return statearr_33118;
})();
if(cljs.core.truth_(inst_33097)){
var statearr_33119_33136 = state_33114__$1;
(statearr_33119_33136[(1)] = (5));

} else {
var statearr_33120_33137 = state_33114__$1;
(statearr_33120_33137[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33115 === (6))){
var inst_33096 = (state_33114[(7)]);
var inst_33101 = p.call(null,inst_33096);
var state_33114__$1 = state_33114;
if(cljs.core.truth_(inst_33101)){
var statearr_33121_33138 = state_33114__$1;
(statearr_33121_33138[(1)] = (8));

} else {
var statearr_33122_33139 = state_33114__$1;
(statearr_33122_33139[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33115 === (3))){
var inst_33112 = (state_33114[(2)]);
var state_33114__$1 = state_33114;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33114__$1,inst_33112);
} else {
if((state_val_33115 === (2))){
var state_33114__$1 = state_33114;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33114__$1,(4),ch);
} else {
if((state_val_33115 === (11))){
var inst_33104 = (state_33114[(2)]);
var state_33114__$1 = state_33114;
var statearr_33123_33140 = state_33114__$1;
(statearr_33123_33140[(2)] = inst_33104);

(statearr_33123_33140[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33115 === (9))){
var state_33114__$1 = state_33114;
var statearr_33124_33141 = state_33114__$1;
(statearr_33124_33141[(2)] = null);

(statearr_33124_33141[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33115 === (5))){
var inst_33099 = cljs.core.async.close_BANG_.call(null,out);
var state_33114__$1 = state_33114;
var statearr_33125_33142 = state_33114__$1;
(statearr_33125_33142[(2)] = inst_33099);

(statearr_33125_33142[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33115 === (10))){
var inst_33107 = (state_33114[(2)]);
var state_33114__$1 = (function (){var statearr_33126 = state_33114;
(statearr_33126[(8)] = inst_33107);

return statearr_33126;
})();
var statearr_33127_33143 = state_33114__$1;
(statearr_33127_33143[(2)] = null);

(statearr_33127_33143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33115 === (8))){
var inst_33096 = (state_33114[(7)]);
var state_33114__$1 = state_33114;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33114__$1,(11),out,inst_33096);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31608__auto___33133,out))
;
return ((function (switch__31520__auto__,c__31608__auto___33133,out){
return (function() {
var cljs$core$async$state_machine__31521__auto__ = null;
var cljs$core$async$state_machine__31521__auto____0 = (function (){
var statearr_33128 = [null,null,null,null,null,null,null,null,null];
(statearr_33128[(0)] = cljs$core$async$state_machine__31521__auto__);

(statearr_33128[(1)] = (1));

return statearr_33128;
});
var cljs$core$async$state_machine__31521__auto____1 = (function (state_33114){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_33114);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e33129){if((e33129 instanceof Object)){
var ex__31524__auto__ = e33129;
var statearr_33130_33144 = state_33114;
(statearr_33130_33144[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33114);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33129;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33145 = state_33114;
state_33114 = G__33145;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$state_machine__31521__auto__ = function(state_33114){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31521__auto____1.call(this,state_33114);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31521__auto____0;
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31521__auto____1;
return cljs$core$async$state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto___33133,out))
})();
var state__31610__auto__ = (function (){var statearr_33131 = f__31609__auto__.call(null);
(statearr_33131[(6)] = c__31608__auto___33133);

return statearr_33131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto___33133,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__33147 = arguments.length;
switch (G__33147) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__31608__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto__){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto__){
return (function (state_33210){
var state_val_33211 = (state_33210[(1)]);
if((state_val_33211 === (7))){
var inst_33206 = (state_33210[(2)]);
var state_33210__$1 = state_33210;
var statearr_33212_33250 = state_33210__$1;
(statearr_33212_33250[(2)] = inst_33206);

(statearr_33212_33250[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (20))){
var inst_33176 = (state_33210[(7)]);
var inst_33187 = (state_33210[(2)]);
var inst_33188 = cljs.core.next.call(null,inst_33176);
var inst_33162 = inst_33188;
var inst_33163 = null;
var inst_33164 = (0);
var inst_33165 = (0);
var state_33210__$1 = (function (){var statearr_33213 = state_33210;
(statearr_33213[(8)] = inst_33165);

(statearr_33213[(9)] = inst_33164);

(statearr_33213[(10)] = inst_33187);

(statearr_33213[(11)] = inst_33163);

(statearr_33213[(12)] = inst_33162);

return statearr_33213;
})();
var statearr_33214_33251 = state_33210__$1;
(statearr_33214_33251[(2)] = null);

(statearr_33214_33251[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (1))){
var state_33210__$1 = state_33210;
var statearr_33215_33252 = state_33210__$1;
(statearr_33215_33252[(2)] = null);

(statearr_33215_33252[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (4))){
var inst_33151 = (state_33210[(13)]);
var inst_33151__$1 = (state_33210[(2)]);
var inst_33152 = (inst_33151__$1 == null);
var state_33210__$1 = (function (){var statearr_33216 = state_33210;
(statearr_33216[(13)] = inst_33151__$1);

return statearr_33216;
})();
if(cljs.core.truth_(inst_33152)){
var statearr_33217_33253 = state_33210__$1;
(statearr_33217_33253[(1)] = (5));

} else {
var statearr_33218_33254 = state_33210__$1;
(statearr_33218_33254[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (15))){
var state_33210__$1 = state_33210;
var statearr_33222_33255 = state_33210__$1;
(statearr_33222_33255[(2)] = null);

(statearr_33222_33255[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (21))){
var state_33210__$1 = state_33210;
var statearr_33223_33256 = state_33210__$1;
(statearr_33223_33256[(2)] = null);

(statearr_33223_33256[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (13))){
var inst_33165 = (state_33210[(8)]);
var inst_33164 = (state_33210[(9)]);
var inst_33163 = (state_33210[(11)]);
var inst_33162 = (state_33210[(12)]);
var inst_33172 = (state_33210[(2)]);
var inst_33173 = (inst_33165 + (1));
var tmp33219 = inst_33164;
var tmp33220 = inst_33163;
var tmp33221 = inst_33162;
var inst_33162__$1 = tmp33221;
var inst_33163__$1 = tmp33220;
var inst_33164__$1 = tmp33219;
var inst_33165__$1 = inst_33173;
var state_33210__$1 = (function (){var statearr_33224 = state_33210;
(statearr_33224[(8)] = inst_33165__$1);

(statearr_33224[(14)] = inst_33172);

(statearr_33224[(9)] = inst_33164__$1);

(statearr_33224[(11)] = inst_33163__$1);

(statearr_33224[(12)] = inst_33162__$1);

return statearr_33224;
})();
var statearr_33225_33257 = state_33210__$1;
(statearr_33225_33257[(2)] = null);

(statearr_33225_33257[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (22))){
var state_33210__$1 = state_33210;
var statearr_33226_33258 = state_33210__$1;
(statearr_33226_33258[(2)] = null);

(statearr_33226_33258[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (6))){
var inst_33151 = (state_33210[(13)]);
var inst_33160 = f.call(null,inst_33151);
var inst_33161 = cljs.core.seq.call(null,inst_33160);
var inst_33162 = inst_33161;
var inst_33163 = null;
var inst_33164 = (0);
var inst_33165 = (0);
var state_33210__$1 = (function (){var statearr_33227 = state_33210;
(statearr_33227[(8)] = inst_33165);

(statearr_33227[(9)] = inst_33164);

(statearr_33227[(11)] = inst_33163);

(statearr_33227[(12)] = inst_33162);

return statearr_33227;
})();
var statearr_33228_33259 = state_33210__$1;
(statearr_33228_33259[(2)] = null);

(statearr_33228_33259[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (17))){
var inst_33176 = (state_33210[(7)]);
var inst_33180 = cljs.core.chunk_first.call(null,inst_33176);
var inst_33181 = cljs.core.chunk_rest.call(null,inst_33176);
var inst_33182 = cljs.core.count.call(null,inst_33180);
var inst_33162 = inst_33181;
var inst_33163 = inst_33180;
var inst_33164 = inst_33182;
var inst_33165 = (0);
var state_33210__$1 = (function (){var statearr_33229 = state_33210;
(statearr_33229[(8)] = inst_33165);

(statearr_33229[(9)] = inst_33164);

(statearr_33229[(11)] = inst_33163);

(statearr_33229[(12)] = inst_33162);

return statearr_33229;
})();
var statearr_33230_33260 = state_33210__$1;
(statearr_33230_33260[(2)] = null);

(statearr_33230_33260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (3))){
var inst_33208 = (state_33210[(2)]);
var state_33210__$1 = state_33210;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33210__$1,inst_33208);
} else {
if((state_val_33211 === (12))){
var inst_33196 = (state_33210[(2)]);
var state_33210__$1 = state_33210;
var statearr_33231_33261 = state_33210__$1;
(statearr_33231_33261[(2)] = inst_33196);

(statearr_33231_33261[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (2))){
var state_33210__$1 = state_33210;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33210__$1,(4),in$);
} else {
if((state_val_33211 === (23))){
var inst_33204 = (state_33210[(2)]);
var state_33210__$1 = state_33210;
var statearr_33232_33262 = state_33210__$1;
(statearr_33232_33262[(2)] = inst_33204);

(statearr_33232_33262[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (19))){
var inst_33191 = (state_33210[(2)]);
var state_33210__$1 = state_33210;
var statearr_33233_33263 = state_33210__$1;
(statearr_33233_33263[(2)] = inst_33191);

(statearr_33233_33263[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (11))){
var inst_33176 = (state_33210[(7)]);
var inst_33162 = (state_33210[(12)]);
var inst_33176__$1 = cljs.core.seq.call(null,inst_33162);
var state_33210__$1 = (function (){var statearr_33234 = state_33210;
(statearr_33234[(7)] = inst_33176__$1);

return statearr_33234;
})();
if(inst_33176__$1){
var statearr_33235_33264 = state_33210__$1;
(statearr_33235_33264[(1)] = (14));

} else {
var statearr_33236_33265 = state_33210__$1;
(statearr_33236_33265[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (9))){
var inst_33198 = (state_33210[(2)]);
var inst_33199 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_33210__$1 = (function (){var statearr_33237 = state_33210;
(statearr_33237[(15)] = inst_33198);

return statearr_33237;
})();
if(cljs.core.truth_(inst_33199)){
var statearr_33238_33266 = state_33210__$1;
(statearr_33238_33266[(1)] = (21));

} else {
var statearr_33239_33267 = state_33210__$1;
(statearr_33239_33267[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (5))){
var inst_33154 = cljs.core.async.close_BANG_.call(null,out);
var state_33210__$1 = state_33210;
var statearr_33240_33268 = state_33210__$1;
(statearr_33240_33268[(2)] = inst_33154);

(statearr_33240_33268[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (14))){
var inst_33176 = (state_33210[(7)]);
var inst_33178 = cljs.core.chunked_seq_QMARK_.call(null,inst_33176);
var state_33210__$1 = state_33210;
if(inst_33178){
var statearr_33241_33269 = state_33210__$1;
(statearr_33241_33269[(1)] = (17));

} else {
var statearr_33242_33270 = state_33210__$1;
(statearr_33242_33270[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (16))){
var inst_33194 = (state_33210[(2)]);
var state_33210__$1 = state_33210;
var statearr_33243_33271 = state_33210__$1;
(statearr_33243_33271[(2)] = inst_33194);

(statearr_33243_33271[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33211 === (10))){
var inst_33165 = (state_33210[(8)]);
var inst_33163 = (state_33210[(11)]);
var inst_33170 = cljs.core._nth.call(null,inst_33163,inst_33165);
var state_33210__$1 = state_33210;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33210__$1,(13),out,inst_33170);
} else {
if((state_val_33211 === (18))){
var inst_33176 = (state_33210[(7)]);
var inst_33185 = cljs.core.first.call(null,inst_33176);
var state_33210__$1 = state_33210;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33210__$1,(20),out,inst_33185);
} else {
if((state_val_33211 === (8))){
var inst_33165 = (state_33210[(8)]);
var inst_33164 = (state_33210[(9)]);
var inst_33167 = (inst_33165 < inst_33164);
var inst_33168 = inst_33167;
var state_33210__$1 = state_33210;
if(cljs.core.truth_(inst_33168)){
var statearr_33244_33272 = state_33210__$1;
(statearr_33244_33272[(1)] = (10));

} else {
var statearr_33245_33273 = state_33210__$1;
(statearr_33245_33273[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31608__auto__))
;
return ((function (switch__31520__auto__,c__31608__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__31521__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__31521__auto____0 = (function (){
var statearr_33246 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33246[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__31521__auto__);

(statearr_33246[(1)] = (1));

return statearr_33246;
});
var cljs$core$async$mapcat_STAR__$_state_machine__31521__auto____1 = (function (state_33210){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_33210);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e33247){if((e33247 instanceof Object)){
var ex__31524__auto__ = e33247;
var statearr_33248_33274 = state_33210;
(statearr_33248_33274[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33210);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33247;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33275 = state_33210;
state_33210 = G__33275;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__31521__auto__ = function(state_33210){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__31521__auto____1.call(this,state_33210);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__31521__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__31521__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto__))
})();
var state__31610__auto__ = (function (){var statearr_33249 = f__31609__auto__.call(null);
(statearr_33249[(6)] = c__31608__auto__);

return statearr_33249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto__))
);

return c__31608__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__33277 = arguments.length;
switch (G__33277) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__33280 = arguments.length;
switch (G__33280) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__33283 = arguments.length;
switch (G__33283) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31608__auto___33330 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto___33330,out){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto___33330,out){
return (function (state_33307){
var state_val_33308 = (state_33307[(1)]);
if((state_val_33308 === (7))){
var inst_33302 = (state_33307[(2)]);
var state_33307__$1 = state_33307;
var statearr_33309_33331 = state_33307__$1;
(statearr_33309_33331[(2)] = inst_33302);

(statearr_33309_33331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33308 === (1))){
var inst_33284 = null;
var state_33307__$1 = (function (){var statearr_33310 = state_33307;
(statearr_33310[(7)] = inst_33284);

return statearr_33310;
})();
var statearr_33311_33332 = state_33307__$1;
(statearr_33311_33332[(2)] = null);

(statearr_33311_33332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33308 === (4))){
var inst_33287 = (state_33307[(8)]);
var inst_33287__$1 = (state_33307[(2)]);
var inst_33288 = (inst_33287__$1 == null);
var inst_33289 = cljs.core.not.call(null,inst_33288);
var state_33307__$1 = (function (){var statearr_33312 = state_33307;
(statearr_33312[(8)] = inst_33287__$1);

return statearr_33312;
})();
if(inst_33289){
var statearr_33313_33333 = state_33307__$1;
(statearr_33313_33333[(1)] = (5));

} else {
var statearr_33314_33334 = state_33307__$1;
(statearr_33314_33334[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33308 === (6))){
var state_33307__$1 = state_33307;
var statearr_33315_33335 = state_33307__$1;
(statearr_33315_33335[(2)] = null);

(statearr_33315_33335[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33308 === (3))){
var inst_33304 = (state_33307[(2)]);
var inst_33305 = cljs.core.async.close_BANG_.call(null,out);
var state_33307__$1 = (function (){var statearr_33316 = state_33307;
(statearr_33316[(9)] = inst_33304);

return statearr_33316;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33307__$1,inst_33305);
} else {
if((state_val_33308 === (2))){
var state_33307__$1 = state_33307;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33307__$1,(4),ch);
} else {
if((state_val_33308 === (11))){
var inst_33287 = (state_33307[(8)]);
var inst_33296 = (state_33307[(2)]);
var inst_33284 = inst_33287;
var state_33307__$1 = (function (){var statearr_33317 = state_33307;
(statearr_33317[(10)] = inst_33296);

(statearr_33317[(7)] = inst_33284);

return statearr_33317;
})();
var statearr_33318_33336 = state_33307__$1;
(statearr_33318_33336[(2)] = null);

(statearr_33318_33336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33308 === (9))){
var inst_33287 = (state_33307[(8)]);
var state_33307__$1 = state_33307;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33307__$1,(11),out,inst_33287);
} else {
if((state_val_33308 === (5))){
var inst_33287 = (state_33307[(8)]);
var inst_33284 = (state_33307[(7)]);
var inst_33291 = cljs.core._EQ_.call(null,inst_33287,inst_33284);
var state_33307__$1 = state_33307;
if(inst_33291){
var statearr_33320_33337 = state_33307__$1;
(statearr_33320_33337[(1)] = (8));

} else {
var statearr_33321_33338 = state_33307__$1;
(statearr_33321_33338[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33308 === (10))){
var inst_33299 = (state_33307[(2)]);
var state_33307__$1 = state_33307;
var statearr_33322_33339 = state_33307__$1;
(statearr_33322_33339[(2)] = inst_33299);

(statearr_33322_33339[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33308 === (8))){
var inst_33284 = (state_33307[(7)]);
var tmp33319 = inst_33284;
var inst_33284__$1 = tmp33319;
var state_33307__$1 = (function (){var statearr_33323 = state_33307;
(statearr_33323[(7)] = inst_33284__$1);

return statearr_33323;
})();
var statearr_33324_33340 = state_33307__$1;
(statearr_33324_33340[(2)] = null);

(statearr_33324_33340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31608__auto___33330,out))
;
return ((function (switch__31520__auto__,c__31608__auto___33330,out){
return (function() {
var cljs$core$async$state_machine__31521__auto__ = null;
var cljs$core$async$state_machine__31521__auto____0 = (function (){
var statearr_33325 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33325[(0)] = cljs$core$async$state_machine__31521__auto__);

(statearr_33325[(1)] = (1));

return statearr_33325;
});
var cljs$core$async$state_machine__31521__auto____1 = (function (state_33307){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_33307);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e33326){if((e33326 instanceof Object)){
var ex__31524__auto__ = e33326;
var statearr_33327_33341 = state_33307;
(statearr_33327_33341[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33307);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33326;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33342 = state_33307;
state_33307 = G__33342;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$state_machine__31521__auto__ = function(state_33307){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31521__auto____1.call(this,state_33307);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31521__auto____0;
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31521__auto____1;
return cljs$core$async$state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto___33330,out))
})();
var state__31610__auto__ = (function (){var statearr_33328 = f__31609__auto__.call(null);
(statearr_33328[(6)] = c__31608__auto___33330);

return statearr_33328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto___33330,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__33344 = arguments.length;
switch (G__33344) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31608__auto___33410 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto___33410,out){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto___33410,out){
return (function (state_33382){
var state_val_33383 = (state_33382[(1)]);
if((state_val_33383 === (7))){
var inst_33378 = (state_33382[(2)]);
var state_33382__$1 = state_33382;
var statearr_33384_33411 = state_33382__$1;
(statearr_33384_33411[(2)] = inst_33378);

(statearr_33384_33411[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33383 === (1))){
var inst_33345 = (new Array(n));
var inst_33346 = inst_33345;
var inst_33347 = (0);
var state_33382__$1 = (function (){var statearr_33385 = state_33382;
(statearr_33385[(7)] = inst_33347);

(statearr_33385[(8)] = inst_33346);

return statearr_33385;
})();
var statearr_33386_33412 = state_33382__$1;
(statearr_33386_33412[(2)] = null);

(statearr_33386_33412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33383 === (4))){
var inst_33350 = (state_33382[(9)]);
var inst_33350__$1 = (state_33382[(2)]);
var inst_33351 = (inst_33350__$1 == null);
var inst_33352 = cljs.core.not.call(null,inst_33351);
var state_33382__$1 = (function (){var statearr_33387 = state_33382;
(statearr_33387[(9)] = inst_33350__$1);

return statearr_33387;
})();
if(inst_33352){
var statearr_33388_33413 = state_33382__$1;
(statearr_33388_33413[(1)] = (5));

} else {
var statearr_33389_33414 = state_33382__$1;
(statearr_33389_33414[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33383 === (15))){
var inst_33372 = (state_33382[(2)]);
var state_33382__$1 = state_33382;
var statearr_33390_33415 = state_33382__$1;
(statearr_33390_33415[(2)] = inst_33372);

(statearr_33390_33415[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33383 === (13))){
var state_33382__$1 = state_33382;
var statearr_33391_33416 = state_33382__$1;
(statearr_33391_33416[(2)] = null);

(statearr_33391_33416[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33383 === (6))){
var inst_33347 = (state_33382[(7)]);
var inst_33368 = (inst_33347 > (0));
var state_33382__$1 = state_33382;
if(cljs.core.truth_(inst_33368)){
var statearr_33392_33417 = state_33382__$1;
(statearr_33392_33417[(1)] = (12));

} else {
var statearr_33393_33418 = state_33382__$1;
(statearr_33393_33418[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33383 === (3))){
var inst_33380 = (state_33382[(2)]);
var state_33382__$1 = state_33382;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33382__$1,inst_33380);
} else {
if((state_val_33383 === (12))){
var inst_33346 = (state_33382[(8)]);
var inst_33370 = cljs.core.vec.call(null,inst_33346);
var state_33382__$1 = state_33382;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33382__$1,(15),out,inst_33370);
} else {
if((state_val_33383 === (2))){
var state_33382__$1 = state_33382;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33382__$1,(4),ch);
} else {
if((state_val_33383 === (11))){
var inst_33362 = (state_33382[(2)]);
var inst_33363 = (new Array(n));
var inst_33346 = inst_33363;
var inst_33347 = (0);
var state_33382__$1 = (function (){var statearr_33394 = state_33382;
(statearr_33394[(7)] = inst_33347);

(statearr_33394[(8)] = inst_33346);

(statearr_33394[(10)] = inst_33362);

return statearr_33394;
})();
var statearr_33395_33419 = state_33382__$1;
(statearr_33395_33419[(2)] = null);

(statearr_33395_33419[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33383 === (9))){
var inst_33346 = (state_33382[(8)]);
var inst_33360 = cljs.core.vec.call(null,inst_33346);
var state_33382__$1 = state_33382;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33382__$1,(11),out,inst_33360);
} else {
if((state_val_33383 === (5))){
var inst_33350 = (state_33382[(9)]);
var inst_33347 = (state_33382[(7)]);
var inst_33346 = (state_33382[(8)]);
var inst_33355 = (state_33382[(11)]);
var inst_33354 = (inst_33346[inst_33347] = inst_33350);
var inst_33355__$1 = (inst_33347 + (1));
var inst_33356 = (inst_33355__$1 < n);
var state_33382__$1 = (function (){var statearr_33396 = state_33382;
(statearr_33396[(12)] = inst_33354);

(statearr_33396[(11)] = inst_33355__$1);

return statearr_33396;
})();
if(cljs.core.truth_(inst_33356)){
var statearr_33397_33420 = state_33382__$1;
(statearr_33397_33420[(1)] = (8));

} else {
var statearr_33398_33421 = state_33382__$1;
(statearr_33398_33421[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33383 === (14))){
var inst_33375 = (state_33382[(2)]);
var inst_33376 = cljs.core.async.close_BANG_.call(null,out);
var state_33382__$1 = (function (){var statearr_33400 = state_33382;
(statearr_33400[(13)] = inst_33375);

return statearr_33400;
})();
var statearr_33401_33422 = state_33382__$1;
(statearr_33401_33422[(2)] = inst_33376);

(statearr_33401_33422[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33383 === (10))){
var inst_33366 = (state_33382[(2)]);
var state_33382__$1 = state_33382;
var statearr_33402_33423 = state_33382__$1;
(statearr_33402_33423[(2)] = inst_33366);

(statearr_33402_33423[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33383 === (8))){
var inst_33346 = (state_33382[(8)]);
var inst_33355 = (state_33382[(11)]);
var tmp33399 = inst_33346;
var inst_33346__$1 = tmp33399;
var inst_33347 = inst_33355;
var state_33382__$1 = (function (){var statearr_33403 = state_33382;
(statearr_33403[(7)] = inst_33347);

(statearr_33403[(8)] = inst_33346__$1);

return statearr_33403;
})();
var statearr_33404_33424 = state_33382__$1;
(statearr_33404_33424[(2)] = null);

(statearr_33404_33424[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31608__auto___33410,out))
;
return ((function (switch__31520__auto__,c__31608__auto___33410,out){
return (function() {
var cljs$core$async$state_machine__31521__auto__ = null;
var cljs$core$async$state_machine__31521__auto____0 = (function (){
var statearr_33405 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33405[(0)] = cljs$core$async$state_machine__31521__auto__);

(statearr_33405[(1)] = (1));

return statearr_33405;
});
var cljs$core$async$state_machine__31521__auto____1 = (function (state_33382){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_33382);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e33406){if((e33406 instanceof Object)){
var ex__31524__auto__ = e33406;
var statearr_33407_33425 = state_33382;
(statearr_33407_33425[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33382);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33406;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33426 = state_33382;
state_33382 = G__33426;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$state_machine__31521__auto__ = function(state_33382){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31521__auto____1.call(this,state_33382);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31521__auto____0;
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31521__auto____1;
return cljs$core$async$state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto___33410,out))
})();
var state__31610__auto__ = (function (){var statearr_33408 = f__31609__auto__.call(null);
(statearr_33408[(6)] = c__31608__auto___33410);

return statearr_33408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto___33410,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__33428 = arguments.length;
switch (G__33428) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31608__auto___33498 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31608__auto___33498,out){
return (function (){
var f__31609__auto__ = (function (){var switch__31520__auto__ = ((function (c__31608__auto___33498,out){
return (function (state_33470){
var state_val_33471 = (state_33470[(1)]);
if((state_val_33471 === (7))){
var inst_33466 = (state_33470[(2)]);
var state_33470__$1 = state_33470;
var statearr_33472_33499 = state_33470__$1;
(statearr_33472_33499[(2)] = inst_33466);

(statearr_33472_33499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (1))){
var inst_33429 = [];
var inst_33430 = inst_33429;
var inst_33431 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_33470__$1 = (function (){var statearr_33473 = state_33470;
(statearr_33473[(7)] = inst_33430);

(statearr_33473[(8)] = inst_33431);

return statearr_33473;
})();
var statearr_33474_33500 = state_33470__$1;
(statearr_33474_33500[(2)] = null);

(statearr_33474_33500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (4))){
var inst_33434 = (state_33470[(9)]);
var inst_33434__$1 = (state_33470[(2)]);
var inst_33435 = (inst_33434__$1 == null);
var inst_33436 = cljs.core.not.call(null,inst_33435);
var state_33470__$1 = (function (){var statearr_33475 = state_33470;
(statearr_33475[(9)] = inst_33434__$1);

return statearr_33475;
})();
if(inst_33436){
var statearr_33476_33501 = state_33470__$1;
(statearr_33476_33501[(1)] = (5));

} else {
var statearr_33477_33502 = state_33470__$1;
(statearr_33477_33502[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (15))){
var inst_33460 = (state_33470[(2)]);
var state_33470__$1 = state_33470;
var statearr_33478_33503 = state_33470__$1;
(statearr_33478_33503[(2)] = inst_33460);

(statearr_33478_33503[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (13))){
var state_33470__$1 = state_33470;
var statearr_33479_33504 = state_33470__$1;
(statearr_33479_33504[(2)] = null);

(statearr_33479_33504[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (6))){
var inst_33430 = (state_33470[(7)]);
var inst_33455 = inst_33430.length;
var inst_33456 = (inst_33455 > (0));
var state_33470__$1 = state_33470;
if(cljs.core.truth_(inst_33456)){
var statearr_33480_33505 = state_33470__$1;
(statearr_33480_33505[(1)] = (12));

} else {
var statearr_33481_33506 = state_33470__$1;
(statearr_33481_33506[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (3))){
var inst_33468 = (state_33470[(2)]);
var state_33470__$1 = state_33470;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33470__$1,inst_33468);
} else {
if((state_val_33471 === (12))){
var inst_33430 = (state_33470[(7)]);
var inst_33458 = cljs.core.vec.call(null,inst_33430);
var state_33470__$1 = state_33470;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33470__$1,(15),out,inst_33458);
} else {
if((state_val_33471 === (2))){
var state_33470__$1 = state_33470;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33470__$1,(4),ch);
} else {
if((state_val_33471 === (11))){
var inst_33438 = (state_33470[(10)]);
var inst_33434 = (state_33470[(9)]);
var inst_33448 = (state_33470[(2)]);
var inst_33449 = [];
var inst_33450 = inst_33449.push(inst_33434);
var inst_33430 = inst_33449;
var inst_33431 = inst_33438;
var state_33470__$1 = (function (){var statearr_33482 = state_33470;
(statearr_33482[(7)] = inst_33430);

(statearr_33482[(11)] = inst_33448);

(statearr_33482[(12)] = inst_33450);

(statearr_33482[(8)] = inst_33431);

return statearr_33482;
})();
var statearr_33483_33507 = state_33470__$1;
(statearr_33483_33507[(2)] = null);

(statearr_33483_33507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (9))){
var inst_33430 = (state_33470[(7)]);
var inst_33446 = cljs.core.vec.call(null,inst_33430);
var state_33470__$1 = state_33470;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33470__$1,(11),out,inst_33446);
} else {
if((state_val_33471 === (5))){
var inst_33438 = (state_33470[(10)]);
var inst_33431 = (state_33470[(8)]);
var inst_33434 = (state_33470[(9)]);
var inst_33438__$1 = f.call(null,inst_33434);
var inst_33439 = cljs.core._EQ_.call(null,inst_33438__$1,inst_33431);
var inst_33440 = cljs.core.keyword_identical_QMARK_.call(null,inst_33431,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_33441 = (inst_33439) || (inst_33440);
var state_33470__$1 = (function (){var statearr_33484 = state_33470;
(statearr_33484[(10)] = inst_33438__$1);

return statearr_33484;
})();
if(cljs.core.truth_(inst_33441)){
var statearr_33485_33508 = state_33470__$1;
(statearr_33485_33508[(1)] = (8));

} else {
var statearr_33486_33509 = state_33470__$1;
(statearr_33486_33509[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (14))){
var inst_33463 = (state_33470[(2)]);
var inst_33464 = cljs.core.async.close_BANG_.call(null,out);
var state_33470__$1 = (function (){var statearr_33488 = state_33470;
(statearr_33488[(13)] = inst_33463);

return statearr_33488;
})();
var statearr_33489_33510 = state_33470__$1;
(statearr_33489_33510[(2)] = inst_33464);

(statearr_33489_33510[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (10))){
var inst_33453 = (state_33470[(2)]);
var state_33470__$1 = state_33470;
var statearr_33490_33511 = state_33470__$1;
(statearr_33490_33511[(2)] = inst_33453);

(statearr_33490_33511[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33471 === (8))){
var inst_33430 = (state_33470[(7)]);
var inst_33438 = (state_33470[(10)]);
var inst_33434 = (state_33470[(9)]);
var inst_33443 = inst_33430.push(inst_33434);
var tmp33487 = inst_33430;
var inst_33430__$1 = tmp33487;
var inst_33431 = inst_33438;
var state_33470__$1 = (function (){var statearr_33491 = state_33470;
(statearr_33491[(14)] = inst_33443);

(statearr_33491[(7)] = inst_33430__$1);

(statearr_33491[(8)] = inst_33431);

return statearr_33491;
})();
var statearr_33492_33512 = state_33470__$1;
(statearr_33492_33512[(2)] = null);

(statearr_33492_33512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31608__auto___33498,out))
;
return ((function (switch__31520__auto__,c__31608__auto___33498,out){
return (function() {
var cljs$core$async$state_machine__31521__auto__ = null;
var cljs$core$async$state_machine__31521__auto____0 = (function (){
var statearr_33493 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33493[(0)] = cljs$core$async$state_machine__31521__auto__);

(statearr_33493[(1)] = (1));

return statearr_33493;
});
var cljs$core$async$state_machine__31521__auto____1 = (function (state_33470){
while(true){
var ret_value__31522__auto__ = (function (){try{while(true){
var result__31523__auto__ = switch__31520__auto__.call(null,state_33470);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31523__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31523__auto__;
}
break;
}
}catch (e33494){if((e33494 instanceof Object)){
var ex__31524__auto__ = e33494;
var statearr_33495_33513 = state_33470;
(statearr_33495_33513[(5)] = ex__31524__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33470);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33494;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31522__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33514 = state_33470;
state_33470 = G__33514;
continue;
} else {
return ret_value__31522__auto__;
}
break;
}
});
cljs$core$async$state_machine__31521__auto__ = function(state_33470){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31521__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31521__auto____1.call(this,state_33470);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31521__auto____0;
cljs$core$async$state_machine__31521__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31521__auto____1;
return cljs$core$async$state_machine__31521__auto__;
})()
;})(switch__31520__auto__,c__31608__auto___33498,out))
})();
var state__31610__auto__ = (function (){var statearr_33496 = f__31609__auto__.call(null);
(statearr_33496[(6)] = c__31608__auto___33498);

return statearr_33496;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31610__auto__);
});})(c__31608__auto___33498,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1503637700492
