// Compiled by ClojureScript 1.9.908 {}
goog.provide('cljs.reader');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('cljs.tools.reader');
goog.require('cljs.tools.reader.edn');
goog.require('goog.string.StringBuffer');
cljs.reader.zero_fill_right_and_truncate = (function cljs$reader$zero_fill_right_and_truncate(s,width){
if(cljs.core._EQ_.call(null,width,cljs.core.count.call(null,s))){
return s;
} else {
if((width < cljs.core.count.call(null,s))){
return cljs.core.subs.call(null,s,(0),width);
} else {
var b = (new goog.string.StringBuffer(s));
while(true){
if((b.getLength() < width)){
var G__30338 = b.append("0");
b = G__30338;
continue;
} else {
return b.toString();
}
break;
}

}
}
});
cljs.reader.divisible_QMARK_ = (function cljs$reader$divisible_QMARK_(num,div){
return (cljs.core.mod.call(null,num,div) === (0));
});
cljs.reader.indivisible_QMARK_ = (function cljs$reader$indivisible_QMARK_(num,div){
return cljs.core.not.call(null,cljs.reader.divisible_QMARK_.call(null,num,div));
});
cljs.reader.leap_year_QMARK_ = (function cljs$reader$leap_year_QMARK_(year){
var and__28335__auto__ = cljs.reader.divisible_QMARK_.call(null,year,(4));
if(cljs.core.truth_(and__28335__auto__)){
var or__28347__auto__ = cljs.reader.indivisible_QMARK_.call(null,year,(100));
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return cljs.reader.divisible_QMARK_.call(null,year,(400));
}
} else {
return and__28335__auto__;
}
});
cljs.reader.days_in_month = (function (){var dim_norm = new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,(31),(28),(31),(30),(31),(30),(31),(31),(30),(31),(30),(31)], null);
var dim_leap = new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,(31),(29),(31),(30),(31),(30),(31),(31),(30),(31),(30),(31)], null);
return ((function (dim_norm,dim_leap){
return (function (month,leap_year_QMARK_){
return cljs.core.get.call(null,(cljs.core.truth_(leap_year_QMARK_)?dim_leap:dim_norm),month);
});
;})(dim_norm,dim_leap))
})();
cljs.reader.timestamp_regex = /(\d\d\d\d)(?:-(\d\d)(?:-(\d\d)(?:[T](\d\d)(?::(\d\d)(?::(\d\d)(?:[.](\d+))?)?)?)?)?)?(?:[Z]|([-+])(\d\d):(\d\d))?/;
cljs.reader.parse_int = (function cljs$reader$parse_int(s){
var n = parseInt(s,(10));
if(cljs.core.not.call(null,isNaN(n))){
return n;
} else {
return null;
}
});
cljs.reader.check = (function cljs$reader$check(low,n,high,msg){
if(((low <= n)) && ((n <= high))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)," Failed:  ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(low),"<=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n),"<=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(high)].join('')));
}

return n;
});
cljs.reader.parse_and_validate_timestamp = (function cljs$reader$parse_and_validate_timestamp(s){
var vec__30339 = cljs.core.re_matches.call(null,cljs.reader.timestamp_regex,s);
var _ = cljs.core.nth.call(null,vec__30339,(0),null);
var years = cljs.core.nth.call(null,vec__30339,(1),null);
var months = cljs.core.nth.call(null,vec__30339,(2),null);
var days = cljs.core.nth.call(null,vec__30339,(3),null);
var hours = cljs.core.nth.call(null,vec__30339,(4),null);
var minutes = cljs.core.nth.call(null,vec__30339,(5),null);
var seconds = cljs.core.nth.call(null,vec__30339,(6),null);
var fraction = cljs.core.nth.call(null,vec__30339,(7),null);
var offset_sign = cljs.core.nth.call(null,vec__30339,(8),null);
var offset_hours = cljs.core.nth.call(null,vec__30339,(9),null);
var offset_minutes = cljs.core.nth.call(null,vec__30339,(10),null);
var v = vec__30339;
if(cljs.core.not.call(null,v)){
throw (new Error(["Unrecognized date/time syntax: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join('')));
} else {
var years__$1 = cljs.reader.parse_int.call(null,years);
var months__$1 = (function (){var or__28347__auto__ = cljs.reader.parse_int.call(null,months);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return (1);
}
})();
var days__$1 = (function (){var or__28347__auto__ = cljs.reader.parse_int.call(null,days);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return (1);
}
})();
var hours__$1 = (function (){var or__28347__auto__ = cljs.reader.parse_int.call(null,hours);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return (0);
}
})();
var minutes__$1 = (function (){var or__28347__auto__ = cljs.reader.parse_int.call(null,minutes);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return (0);
}
})();
var seconds__$1 = (function (){var or__28347__auto__ = cljs.reader.parse_int.call(null,seconds);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return (0);
}
})();
var fraction__$1 = (function (){var or__28347__auto__ = cljs.reader.parse_int.call(null,cljs.reader.zero_fill_right_and_truncate.call(null,fraction,(3)));
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return (0);
}
})();
var offset_sign__$1 = ((cljs.core._EQ_.call(null,offset_sign,"-"))?(-1):(1));
var offset_hours__$1 = (function (){var or__28347__auto__ = cljs.reader.parse_int.call(null,offset_hours);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return (0);
}
})();
var offset_minutes__$1 = (function (){var or__28347__auto__ = cljs.reader.parse_int.call(null,offset_minutes);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return (0);
}
})();
var offset = (offset_sign__$1 * ((offset_hours__$1 * (60)) + offset_minutes__$1));
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [years__$1,cljs.reader.check.call(null,(1),months__$1,(12),"timestamp month field must be in range 1..12"),cljs.reader.check.call(null,(1),days__$1,cljs.reader.days_in_month.call(null,months__$1,cljs.reader.leap_year_QMARK_.call(null,years__$1)),"timestamp day field must be in range 1..last day in month"),cljs.reader.check.call(null,(0),hours__$1,(23),"timestamp hour field must be in range 0..23"),cljs.reader.check.call(null,(0),minutes__$1,(59),"timestamp minute field must be in range 0..59"),cljs.reader.check.call(null,(0),seconds__$1,((cljs.core._EQ_.call(null,minutes__$1,(59)))?(60):(59)),"timestamp second field must be in range 0..60"),cljs.reader.check.call(null,(0),fraction__$1,(999),"timestamp millisecond field must be in range 0..999"),offset], null);
}
});
cljs.reader.parse_timestamp = (function cljs$reader$parse_timestamp(ts){
var temp__4655__auto__ = cljs.reader.parse_and_validate_timestamp.call(null,ts);
if(cljs.core.truth_(temp__4655__auto__)){
var vec__30342 = temp__4655__auto__;
var years = cljs.core.nth.call(null,vec__30342,(0),null);
var months = cljs.core.nth.call(null,vec__30342,(1),null);
var days = cljs.core.nth.call(null,vec__30342,(2),null);
var hours = cljs.core.nth.call(null,vec__30342,(3),null);
var minutes = cljs.core.nth.call(null,vec__30342,(4),null);
var seconds = cljs.core.nth.call(null,vec__30342,(5),null);
var ms = cljs.core.nth.call(null,vec__30342,(6),null);
var offset = cljs.core.nth.call(null,vec__30342,(7),null);
return (new Date((Date.UTC(years,(months - (1)),days,hours,minutes,seconds,ms) - ((offset * (60)) * (1000)))));
} else {
throw (new Error(["Unrecognized date/time syntax: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ts)].join('')));
}
});
cljs.reader.read_date = (function cljs$reader$read_date(s){
if(typeof s === 'string'){
return cljs.reader.parse_timestamp.call(null,s);
} else {
throw (new Error("Instance literal expects a string for its timestamp."));
}
});
cljs.reader.read_queue = (function cljs$reader$read_queue(elems){
if(cljs.core.vector_QMARK_.call(null,elems)){
return cljs.core.into.call(null,cljs.core.PersistentQueue.EMPTY,elems);
} else {
throw (new Error("Queue literal expects a vector for its elements."));
}
});
cljs.reader.read_js = (function cljs$reader$read_js(form){
if(cljs.core.vector_QMARK_.call(null,form)){
var arr = [];
var seq__30345_30361 = cljs.core.seq.call(null,form);
var chunk__30346_30362 = null;
var count__30347_30363 = (0);
var i__30348_30364 = (0);
while(true){
if((i__30348_30364 < count__30347_30363)){
var x_30365 = cljs.core._nth.call(null,chunk__30346_30362,i__30348_30364);
arr.push(x_30365);

var G__30366 = seq__30345_30361;
var G__30367 = chunk__30346_30362;
var G__30368 = count__30347_30363;
var G__30369 = (i__30348_30364 + (1));
seq__30345_30361 = G__30366;
chunk__30346_30362 = G__30367;
count__30347_30363 = G__30368;
i__30348_30364 = G__30369;
continue;
} else {
var temp__4657__auto___30370 = cljs.core.seq.call(null,seq__30345_30361);
if(temp__4657__auto___30370){
var seq__30345_30371__$1 = temp__4657__auto___30370;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30345_30371__$1)){
var c__29186__auto___30372 = cljs.core.chunk_first.call(null,seq__30345_30371__$1);
var G__30373 = cljs.core.chunk_rest.call(null,seq__30345_30371__$1);
var G__30374 = c__29186__auto___30372;
var G__30375 = cljs.core.count.call(null,c__29186__auto___30372);
var G__30376 = (0);
seq__30345_30361 = G__30373;
chunk__30346_30362 = G__30374;
count__30347_30363 = G__30375;
i__30348_30364 = G__30376;
continue;
} else {
var x_30377 = cljs.core.first.call(null,seq__30345_30371__$1);
arr.push(x_30377);

var G__30378 = cljs.core.next.call(null,seq__30345_30371__$1);
var G__30379 = null;
var G__30380 = (0);
var G__30381 = (0);
seq__30345_30361 = G__30378;
chunk__30346_30362 = G__30379;
count__30347_30363 = G__30380;
i__30348_30364 = G__30381;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
if(cljs.core.map_QMARK_.call(null,form)){
var obj = {};
var seq__30351_30382 = cljs.core.seq.call(null,form);
var chunk__30352_30383 = null;
var count__30353_30384 = (0);
var i__30354_30385 = (0);
while(true){
if((i__30354_30385 < count__30353_30384)){
var vec__30355_30386 = cljs.core._nth.call(null,chunk__30352_30383,i__30354_30385);
var k_30387 = cljs.core.nth.call(null,vec__30355_30386,(0),null);
var v_30388 = cljs.core.nth.call(null,vec__30355_30386,(1),null);
goog.object.set(obj,cljs.core.name.call(null,k_30387),v_30388);

var G__30389 = seq__30351_30382;
var G__30390 = chunk__30352_30383;
var G__30391 = count__30353_30384;
var G__30392 = (i__30354_30385 + (1));
seq__30351_30382 = G__30389;
chunk__30352_30383 = G__30390;
count__30353_30384 = G__30391;
i__30354_30385 = G__30392;
continue;
} else {
var temp__4657__auto___30393 = cljs.core.seq.call(null,seq__30351_30382);
if(temp__4657__auto___30393){
var seq__30351_30394__$1 = temp__4657__auto___30393;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30351_30394__$1)){
var c__29186__auto___30395 = cljs.core.chunk_first.call(null,seq__30351_30394__$1);
var G__30396 = cljs.core.chunk_rest.call(null,seq__30351_30394__$1);
var G__30397 = c__29186__auto___30395;
var G__30398 = cljs.core.count.call(null,c__29186__auto___30395);
var G__30399 = (0);
seq__30351_30382 = G__30396;
chunk__30352_30383 = G__30397;
count__30353_30384 = G__30398;
i__30354_30385 = G__30399;
continue;
} else {
var vec__30358_30400 = cljs.core.first.call(null,seq__30351_30394__$1);
var k_30401 = cljs.core.nth.call(null,vec__30358_30400,(0),null);
var v_30402 = cljs.core.nth.call(null,vec__30358_30400,(1),null);
goog.object.set(obj,cljs.core.name.call(null,k_30401),v_30402);

var G__30403 = cljs.core.next.call(null,seq__30351_30394__$1);
var G__30404 = null;
var G__30405 = (0);
var G__30406 = (0);
seq__30351_30382 = G__30403;
chunk__30352_30383 = G__30404;
count__30353_30384 = G__30405;
i__30354_30385 = G__30406;
continue;
}
} else {
}
}
break;
}

return obj;
} else {
throw (new Error(["JS literal expects a vector or map containing ","only string or unqualified keyword keys"].join('')));

}
}
});
cljs.reader.read_uuid = (function cljs$reader$read_uuid(uuid){
if(typeof uuid === 'string'){
return cljs.core.uuid.call(null,uuid);
} else {
throw (new Error("UUID literal expects a string as its representation."));
}
});
cljs.reader._STAR_default_data_reader_fn_STAR_ = cljs.core.atom.call(null,null);
cljs.reader._STAR_tag_table_STAR_ = cljs.core.atom.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Symbol(null,"inst","inst",-2008473268,null),cljs.reader.read_date,new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),cljs.reader.read_uuid,new cljs.core.Symbol(null,"queue","queue",-1198599890,null),cljs.reader.read_queue,new cljs.core.Symbol(null,"js","js",-886355190,null),cljs.reader.read_js], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol("xml","ns","xml/ns",2080676230,null),(function (x__30326__auto__){
return clojure.data.xml.name.uri_symbol(x__30326__auto__);
}),new cljs.core.Symbol("xml","element","xml/element",-680371045,null),(function (x__30326__auto__){
return clojure.data.xml.node.tagged_element(x__30326__auto__);
})], null)));
/**
 * Reads the first object from an cljs.tools.reader.reader-types/IPushbackReader.
 * Returns the object read. If EOF, throws if eof-error? is true otherwise returns eof.
 * If no reader is provided, *in* will be used.
 * 
 * Reads data in the edn format (subset of Clojure data):
 * http://edn-format.org
 * 
 * cljs.tools.reader.edn/read doesn't depend on dynamic Vars, all configuration
 * is done by passing an opt map.
 * 
 * opts is a map that can include the following keys:
 * :eof - value to return on end-of-file. When not supplied, eof throws an exception.
 * :readers  - a map of tag symbols to data-reader functions to be considered before default-data-readers.
 *            When not supplied, only the default-data-readers will be used.
 * :default - A function of two args, that will, if present and no reader is found for a tag,
 *            be called with the tag and the value.
 */
cljs.reader.read = (function cljs$reader$read(var_args){
var G__30408 = arguments.length;
switch (G__30408) {
case 1:
return cljs.reader.read.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.reader.read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.reader.read.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.reader.read.cljs$core$IFn$_invoke$arity$1 = (function (reader){
return cljs.tools.reader.edn.read.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"readers","readers",-2118263030),cljs.core.deref.call(null,cljs.reader._STAR_tag_table_STAR_),new cljs.core.Keyword(null,"default","default",-1987822328),cljs.core.deref.call(null,cljs.reader._STAR_default_data_reader_fn_STAR_),new cljs.core.Keyword(null,"eof","eof",-489063237),null], null),reader);
});

cljs.reader.read.cljs$core$IFn$_invoke$arity$2 = (function (p__30409,reader){
var map__30410 = p__30409;
var map__30410__$1 = ((((!((map__30410 == null)))?((((map__30410.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30410.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30410):map__30410);
var opts = map__30410__$1;
var eof = cljs.core.get.call(null,map__30410__$1,new cljs.core.Keyword(null,"eof","eof",-489063237));
return cljs.tools.reader.edn.read.call(null,cljs.core.update.call(null,cljs.core.merge.call(null,opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"default","default",-1987822328),cljs.core.deref.call(null,cljs.reader._STAR_default_data_reader_fn_STAR_)], null)),new cljs.core.Keyword(null,"readers","readers",-2118263030),((function (map__30410,map__30410__$1,opts,eof){
return (function (m){
return cljs.core.merge.call(null,cljs.core.deref.call(null,cljs.reader._STAR_tag_table_STAR_),m);
});})(map__30410,map__30410__$1,opts,eof))
),reader);
});

cljs.reader.read.cljs$core$IFn$_invoke$arity$4 = (function (reader,eof_error_QMARK_,eof,opts){
return cljs.tools.reader.edn.read.call(null,reader,eof_error_QMARK_,eof,cljs.core.update.call(null,cljs.core.merge.call(null,opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"default","default",-1987822328),cljs.core.deref.call(null,cljs.reader._STAR_default_data_reader_fn_STAR_)], null)),new cljs.core.Keyword(null,"readers","readers",-2118263030),(function (m){
return cljs.core.merge.call(null,cljs.core.deref.call(null,cljs.reader._STAR_tag_table_STAR_),m);
})));
});

cljs.reader.read.cljs$lang$maxFixedArity = 4;

/**
 * Reads one object from the string s.
 * Returns nil when s is nil or empty.
 * 
 * Reads data in the edn format (subset of Clojure data):
 * http://edn-format.org
 * 
 * opts is a map as per cljs.tools.reader.edn/read
 */
cljs.reader.read_string = (function cljs$reader$read_string(var_args){
var G__30414 = arguments.length;
switch (G__30414) {
case 1:
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.tools.reader.edn.read_string.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"readers","readers",-2118263030),cljs.core.deref.call(null,cljs.reader._STAR_tag_table_STAR_),new cljs.core.Keyword(null,"default","default",-1987822328),cljs.core.deref.call(null,cljs.reader._STAR_default_data_reader_fn_STAR_),new cljs.core.Keyword(null,"eof","eof",-489063237),null], null),s);
});

cljs.reader.read_string.cljs$core$IFn$_invoke$arity$2 = (function (opts,s){
return cljs.tools.reader.edn.read_string.call(null,cljs.core.update.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"default","default",-1987822328),cljs.core.deref.call(null,cljs.reader._STAR_default_data_reader_fn_STAR_)], null),opts),new cljs.core.Keyword(null,"readers","readers",-2118263030),(function (m){
return cljs.core.merge.call(null,cljs.core.deref.call(null,cljs.reader._STAR_tag_table_STAR_),m);
})),s);
});

cljs.reader.read_string.cljs$lang$maxFixedArity = 2;

cljs.reader.register_tag_parser_BANG_ = (function cljs$reader$register_tag_parser_BANG_(tag,f){
var old_parser = cljs.core.get.call(null,cljs.core.deref.call(null,cljs.reader._STAR_tag_table_STAR_),tag);
cljs.core.swap_BANG_.call(null,cljs.reader._STAR_tag_table_STAR_,cljs.core.assoc,tag,f);

return old_parser;
});
cljs.reader.deregister_tag_parser_BANG_ = (function cljs$reader$deregister_tag_parser_BANG_(tag){
var old_parser = cljs.core.get.call(null,cljs.core.deref.call(null,cljs.reader._STAR_tag_table_STAR_),tag);
cljs.core.swap_BANG_.call(null,cljs.reader._STAR_tag_table_STAR_,cljs.core.dissoc,tag);

return old_parser;
});
cljs.reader.register_default_tag_parser_BANG_ = (function cljs$reader$register_default_tag_parser_BANG_(f){
var old_parser = cljs.core.deref.call(null,cljs.reader._STAR_default_data_reader_fn_STAR_);
cljs.core.swap_BANG_.call(null,cljs.reader._STAR_default_data_reader_fn_STAR_,((function (old_parser){
return (function (_){
return f;
});})(old_parser))
);

return old_parser;
});
cljs.reader.deregister_default_tag_parser_BANG_ = (function cljs$reader$deregister_default_tag_parser_BANG_(){
var old_parser = cljs.core.deref.call(null,cljs.reader._STAR_default_data_reader_fn_STAR_);
cljs.core.swap_BANG_.call(null,cljs.reader._STAR_default_data_reader_fn_STAR_,((function (old_parser){
return (function (_){
return null;
});})(old_parser))
);

return old_parser;
});

//# sourceMappingURL=reader.js.map?rel=1503637698725
