// Compiled by ClojureScript 1.9.908 {}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.Uri');
goog.require('no.en.core');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__28335__auto__ = v;
if(cljs.core.truth_(and__28335__auto__)){
return (v > (0));
} else {
return and__28335__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(!(clojure.string.blank_QMARK_.call(null,s))){
return cljs.core.reduce.call(null,(function (p1__33584_SHARP_,p2__33583_SHARP_){
var vec__33585 = clojure.string.split.call(null,p2__33583_SHARP_,/=/);
var k = cljs.core.nth.call(null,vec__33585,(0),null);
var v = cljs.core.nth.call(null,vec__33585,(1),null);
return cljs.core.assoc.call(null,p1__33584_SHARP_,cljs.core.keyword.call(null,no.en.core.url_decode.call(null,k)),no.en.core.url_decode.call(null,v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(!(clojure.string.blank_QMARK_.call(null,url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"scheme","scheme",90199613),cljs.core.keyword.call(null,uri.getScheme()),new cljs.core.Keyword(null,"server-name","server-name",-1012104295),uri.getDomain(),new cljs.core.Keyword(null,"server-port","server-port",663745648),cljs_http.client.if_pos.call(null,uri.getPort()),new cljs.core.Keyword(null,"uri","uri",-774711847),uri.getPath(),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),((cljs.core.not.call(null,query_data.isEmpty()))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join(''):null),new cljs.core.Keyword(null,"query-params","query-params",900640534),((cljs.core.not.call(null,query_data.isEmpty()))?cljs_http.client.parse_query_params.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,cljs.core.name.call(null,k))),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p1__33588_SHARP_){
return cljs_http.client.encode_val.call(null,k,p1__33588_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__33589){
var vec__33590 = p__33589;
var k = cljs.core.nth.call(null,vec__33590,(0),null);
var v = cljs.core.nth.call(null,vec__33590,(1),null);
if(cljs.core.coll_QMARK_.call(null,v)){
return cljs_http.client.encode_vals.call(null,k,v);
} else {
return cljs_http.client.encode_val.call(null,k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap.call(null,esc_chars,cljs.core.map.call(null,((function (esc_chars){
return (function (p1__33593_SHARP_){
return ["\\",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__33593_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.call(null,cljs.core.str,cljs.core.replace.call(null,cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__28335__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"head","head",-771383919),request_method);
if(and__28335__auto__){
var and__28335__auto____$1 = cljs.core.not_EQ_.call(null,(204),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response));
if(and__28335__auto____$1){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,["(?i)",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs_http.client.escape_special.call(null,content_type))].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__28335__auto____$1;
}
} else {
return and__28335__auto__;
}
})())){
return cljs.core.update_in.call(null,response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669)], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"edn-params","edn-params",894273052).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/edn"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"edn-params","edn-params",894273052)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.pr_str.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__33594_SHARP_){
return cljs_http.client.decode_body.call(null,p1__33594_SHARP_,cljs.reader.read_string,"application/edn",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(var_args){
var args__29523__auto__ = [];
var len__29516__auto___33601 = arguments.length;
var i__29517__auto___33602 = (0);
while(true){
if((i__29517__auto___33602 < len__29516__auto___33601)){
args__29523__auto__.push((arguments[i__29517__auto___33602]));

var G__33603 = (i__29517__auto___33602 + (1));
i__29517__auto___33602 = G__33603;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__33597){
var vec__33598 = p__33597;
var default_headers = cljs.core.nth.call(null,vec__33598,(0),null);
return ((function (vec__33598,default_headers){
return (function (request){
var temp__4655__auto__ = (function (){var or__28347__auto__ = new cljs.core.Keyword(null,"default-headers","default-headers",-43146094).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var default_headers__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc.call(null,request,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094),default_headers__$1));
} else {
return client.call(null,request);
}
});
;})(vec__33598,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq33595){
var G__33596 = cljs.core.first.call(null,seq33595);
var seq33595__$1 = cljs.core.next.call(null,seq33595);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__33596,seq33595__$1);
});

cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(var_args){
var args__29523__auto__ = [];
var len__29516__auto___33610 = arguments.length;
var i__29517__auto___33611 = (0);
while(true){
if((i__29517__auto___33611 < len__29516__auto___33610)){
args__29523__auto__.push((arguments[i__29517__auto___33611]));

var G__33612 = (i__29517__auto___33611 + (1));
i__29517__auto___33611 = G__33612;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__33606){
var vec__33607 = p__33606;
var accept = cljs.core.nth.call(null,vec__33607,(0),null);
return ((function (vec__33607,accept){
return (function (request){
var temp__4655__auto__ = (function (){var or__28347__auto__ = new cljs.core.Keyword(null,"accept","accept",1874130431).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var accept__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"accept"], null),accept__$1));
} else {
return client.call(null,request);
}
});
;})(vec__33607,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq33604){
var G__33605 = cljs.core.first.call(null,seq33604);
var seq33604__$1 = cljs.core.next.call(null,seq33604);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__33605,seq33604__$1);
});

cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(var_args){
var args__29523__auto__ = [];
var len__29516__auto___33619 = arguments.length;
var i__29517__auto___33620 = (0);
while(true){
if((i__29517__auto___33620 < len__29516__auto___33619)){
args__29523__auto__.push((arguments[i__29517__auto___33620]));

var G__33621 = (i__29517__auto___33620 + (1));
i__29517__auto___33620 = G__33621;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__33615){
var vec__33616 = p__33615;
var content_type = cljs.core.nth.call(null,vec__33616,(0),null);
return ((function (vec__33616,content_type){
return (function (request){
var temp__4655__auto__ = (function (){var or__28347__auto__ = new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var content_type__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),content_type__$1));
} else {
return client.call(null,request);
}
});
;})(vec__33616,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq33613){
var G__33614 = cljs.core.first.call(null,seq33613);
var seq33613__$1 = cljs.core.next.call(null,seq33613);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__33614,seq33613__$1);
});

cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"decoding","decoding",-568180903),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140),cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 *   Content Type header.
 * 
 *   A :transit-opts map can be optionally provided with the following keys:
 * 
 *   :encoding                #{:json, :json-verbose}
 *   :decoding                #{:json, :json-verbose}
 *   :encoding/decoding-opts  appropriate map of options to be passed to
 *                         transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"transit-params","transit-params",357261095).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var map__33622 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__33622__$1 = ((((!((map__33622 == null)))?((((map__33622.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33622.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33622):map__33622);
var encoding = cljs.core.get.call(null,map__33622__$1,new cljs.core.Keyword(null,"encoding","encoding",1728578272));
var encoding_opts = cljs.core.get.call(null,map__33622__$1,new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631));
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/transit+json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"transit-params","transit-params",357261095)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.transit_encode.call(null,params,encoding,encoding_opts)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__33626 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__33626__$1 = ((((!((map__33626 == null)))?((((map__33626.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33626.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33626):map__33626);
var decoding = cljs.core.get.call(null,map__33626__$1,new cljs.core.Keyword(null,"decoding","decoding",-568180903));
var decoding_opts = cljs.core.get.call(null,map__33626__$1,new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140));
var transit_decode = ((function (map__33626,map__33626__$1,decoding,decoding_opts){
return (function (p1__33624_SHARP_){
return cljs_http.util.transit_decode.call(null,p1__33624_SHARP_,decoding,decoding_opts);
});})(map__33626,map__33626__$1,decoding,decoding_opts))
;
return cljs.core.async.map.call(null,((function (map__33626,map__33626__$1,decoding,decoding_opts,transit_decode){
return (function (p1__33625_SHARP_){
return cljs_http.client.decode_body.call(null,p1__33625_SHARP_,transit_decode,"application/transit+json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
});})(map__33626,map__33626__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"json-params","json-params",-1112693596).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"json-params","json-params",-1112693596)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.json_encode.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__33628_SHARP_){
return cljs_http.client.decode_body.call(null,p1__33628_SHARP_,cljs_http.util.json_decode,"application/json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__33629){
var map__33630 = p__33629;
var map__33630__$1 = ((((!((map__33630 == null)))?((((map__33630.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33630.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33630):map__33630);
var req = map__33630__$1;
var query_params = cljs.core.get.call(null,map__33630__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
if(cljs.core.truth_(query_params)){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"query-params","query-params",900640534)),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),cljs_http.client.generate_query_string.call(null,query_params)));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__33632){
var map__33633 = p__33632;
var map__33633__$1 = ((((!((map__33633 == null)))?((((map__33633.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33633.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33633):map__33633);
var request = map__33633__$1;
var form_params = cljs.core.get.call(null,map__33633__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
var request_method = cljs.core.get.call(null,map__33633__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.call(null,map__33633__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
if(cljs.core.truth_((function (){var and__28335__auto__ = form_params;
if(cljs.core.truth_(and__28335__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__28335__auto__;
}
})())){
var headers__$1 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/x-www-form-urlencoded"], null),headers);
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"form-params","form-params",1884296467)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_query_string.call(null,form_params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__33635_33645 = cljs.core.seq.call(null,params);
var chunk__33636_33646 = null;
var count__33637_33647 = (0);
var i__33638_33648 = (0);
while(true){
if((i__33638_33648 < count__33637_33647)){
var vec__33639_33649 = cljs.core._nth.call(null,chunk__33636_33646,i__33638_33648);
var k_33650 = cljs.core.nth.call(null,vec__33639_33649,(0),null);
var v_33651 = cljs.core.nth.call(null,vec__33639_33649,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_33651)){
form_data.append(cljs.core.name.call(null,k_33650),cljs.core.first.call(null,v_33651),cljs.core.second.call(null,v_33651));
} else {
form_data.append(cljs.core.name.call(null,k_33650),v_33651);
}

var G__33652 = seq__33635_33645;
var G__33653 = chunk__33636_33646;
var G__33654 = count__33637_33647;
var G__33655 = (i__33638_33648 + (1));
seq__33635_33645 = G__33652;
chunk__33636_33646 = G__33653;
count__33637_33647 = G__33654;
i__33638_33648 = G__33655;
continue;
} else {
var temp__4657__auto___33656 = cljs.core.seq.call(null,seq__33635_33645);
if(temp__4657__auto___33656){
var seq__33635_33657__$1 = temp__4657__auto___33656;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33635_33657__$1)){
var c__29186__auto___33658 = cljs.core.chunk_first.call(null,seq__33635_33657__$1);
var G__33659 = cljs.core.chunk_rest.call(null,seq__33635_33657__$1);
var G__33660 = c__29186__auto___33658;
var G__33661 = cljs.core.count.call(null,c__29186__auto___33658);
var G__33662 = (0);
seq__33635_33645 = G__33659;
chunk__33636_33646 = G__33660;
count__33637_33647 = G__33661;
i__33638_33648 = G__33662;
continue;
} else {
var vec__33642_33663 = cljs.core.first.call(null,seq__33635_33657__$1);
var k_33664 = cljs.core.nth.call(null,vec__33642_33663,(0),null);
var v_33665 = cljs.core.nth.call(null,vec__33642_33663,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_33665)){
form_data.append(cljs.core.name.call(null,k_33664),cljs.core.first.call(null,v_33665),cljs.core.second.call(null,v_33665));
} else {
form_data.append(cljs.core.name.call(null,k_33664),v_33665);
}

var G__33666 = cljs.core.next.call(null,seq__33635_33657__$1);
var G__33667 = null;
var G__33668 = (0);
var G__33669 = (0);
seq__33635_33645 = G__33666;
chunk__33636_33646 = G__33667;
count__33637_33647 = G__33668;
i__33638_33648 = G__33669;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__33670){
var map__33671 = p__33670;
var map__33671__$1 = ((((!((map__33671 == null)))?((((map__33671.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33671.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33671):map__33671);
var request = map__33671__$1;
var multipart_params = cljs.core.get.call(null,map__33671__$1,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707));
var request_method = cljs.core.get.call(null,map__33671__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core.truth_((function (){var and__28335__auto__ = multipart_params;
if(cljs.core.truth_(and__28335__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__28335__auto__;
}
})())){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_form_data.call(null,multipart_params)));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4655__auto__ = new cljs.core.Keyword(null,"method","method",55703592).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var m = temp__4655__auto__;
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"method","method",55703592)),new cljs.core.Keyword(null,"request-method","request-method",1764796830),m));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__33673_SHARP_){
return client.call(null,cljs.core.assoc.call(null,p1__33673_SHARP_,new cljs.core.Keyword(null,"server-name","server-name",-1012104295),server_name));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__33675){
var map__33676 = p__33675;
var map__33676__$1 = ((((!((map__33676 == null)))?((((map__33676.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33676.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__33676):map__33676);
var req = map__33676__$1;
var query_params = cljs.core.get.call(null,map__33676__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
var temp__4655__auto__ = cljs_http.client.parse_url.call(null,new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4655__auto__)){
var spec = temp__4655__auto__;
return client.call(null,cljs.core.update_in.call(null,cljs.core.dissoc.call(null,cljs.core.merge.call(null,req,spec),new cljs.core.Keyword(null,"url","url",276297046)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534)], null),((function (spec,temp__4655__auto__,map__33676,map__33676__$1,req,query_params){
return (function (p1__33674_SHARP_){
return cljs.core.merge.call(null,p1__33674_SHARP_,query_params);
});})(spec,temp__4655__auto__,map__33676,map__33676__$1,req,query_params))
));
} else {
return client.call(null,req);
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 *   an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(var_args){
var args__29523__auto__ = [];
var len__29516__auto___33684 = arguments.length;
var i__29517__auto___33685 = (0);
while(true){
if((i__29517__auto___33685 < len__29516__auto___33684)){
args__29523__auto__.push((arguments[i__29517__auto___33685]));

var G__33686 = (i__29517__auto___33685 + (1));
i__29517__auto___33685 = G__33686;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__33680){
var vec__33681 = p__33680;
var credentials = cljs.core.nth.call(null,vec__33681,(0),null);
return ((function (vec__33681,credentials){
return (function (req){
var credentials__$1 = (function (){var or__28347__auto__ = new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__28347__auto__)){
return or__28347__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_.call(null,credentials__$1))){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),cljs_http.util.basic_auth.call(null,credentials__$1)));
} else {
return client.call(null,req);
}
});
;})(vec__33681,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq33678){
var G__33679 = cljs.core.first.call(null,seq33678);
var seq33678__$1 = cljs.core.next.call(null,seq33678);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__33679,seq33678__$1);
});

/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4655__auto__ = new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var oauth_token = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(oauth_token)].join('')));
} else {
return client.call(null,req);
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var custom_channel = temp__4655__auto__;
return cljs.core.async.pipe.call(null,client.call(null,request),custom_channel);
} else {
return client.call(null,request);
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers.call(null,cljs_http.client.wrap_channel_from_request_map.call(null,cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_json_response.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_transit_response.call(null,cljs_http.client.wrap_transit_params.call(null,cljs_http.client.wrap_edn_response.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_multipart_params.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request.call(null,cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(var_args){
var args__29523__auto__ = [];
var len__29516__auto___33693 = arguments.length;
var i__29517__auto___33694 = (0);
while(true){
if((i__29517__auto___33694 < len__29516__auto___33693)){
args__29523__auto__.push((arguments[i__29517__auto___33694]));

var G__33695 = (i__29517__auto___33694 + (1));
i__29517__auto___33694 = G__33695;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33689){
var vec__33690 = p__33689;
var req = cljs.core.nth.call(null,vec__33690,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq33687){
var G__33688 = cljs.core.first.call(null,seq33687);
var seq33687__$1 = cljs.core.next.call(null,seq33687);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__33688,seq33687__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(var_args){
var args__29523__auto__ = [];
var len__29516__auto___33702 = arguments.length;
var i__29517__auto___33703 = (0);
while(true){
if((i__29517__auto___33703 < len__29516__auto___33702)){
args__29523__auto__.push((arguments[i__29517__auto___33703]));

var G__33704 = (i__29517__auto___33703 + (1));
i__29517__auto___33703 = G__33704;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33698){
var vec__33699 = p__33698;
var req = cljs.core.nth.call(null,vec__33699,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq33696){
var G__33697 = cljs.core.first.call(null,seq33696);
var seq33696__$1 = cljs.core.next.call(null,seq33696);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__33697,seq33696__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(var_args){
var args__29523__auto__ = [];
var len__29516__auto___33711 = arguments.length;
var i__29517__auto___33712 = (0);
while(true){
if((i__29517__auto___33712 < len__29516__auto___33711)){
args__29523__auto__.push((arguments[i__29517__auto___33712]));

var G__33713 = (i__29517__auto___33712 + (1));
i__29517__auto___33712 = G__33713;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33707){
var vec__33708 = p__33707;
var req = cljs.core.nth.call(null,vec__33708,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"head","head",-771383919),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq33705){
var G__33706 = cljs.core.first.call(null,seq33705);
var seq33705__$1 = cljs.core.next.call(null,seq33705);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__33706,seq33705__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(var_args){
var args__29523__auto__ = [];
var len__29516__auto___33720 = arguments.length;
var i__29517__auto___33721 = (0);
while(true){
if((i__29517__auto___33721 < len__29516__auto___33720)){
args__29523__auto__.push((arguments[i__29517__auto___33721]));

var G__33722 = (i__29517__auto___33721 + (1));
i__29517__auto___33721 = G__33722;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33716){
var vec__33717 = p__33716;
var req = cljs.core.nth.call(null,vec__33717,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"jsonp","jsonp",226119588),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq33714){
var G__33715 = cljs.core.first.call(null,seq33714);
var seq33714__$1 = cljs.core.next.call(null,seq33714);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__33715,seq33714__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(var_args){
var args__29523__auto__ = [];
var len__29516__auto___33729 = arguments.length;
var i__29517__auto___33730 = (0);
while(true){
if((i__29517__auto___33730 < len__29516__auto___33729)){
args__29523__auto__.push((arguments[i__29517__auto___33730]));

var G__33731 = (i__29517__auto___33730 + (1));
i__29517__auto___33730 = G__33731;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33725){
var vec__33726 = p__33725;
var req = cljs.core.nth.call(null,vec__33726,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"move","move",-2110884309),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq33723){
var G__33724 = cljs.core.first.call(null,seq33723);
var seq33723__$1 = cljs.core.next.call(null,seq33723);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__33724,seq33723__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(var_args){
var args__29523__auto__ = [];
var len__29516__auto___33738 = arguments.length;
var i__29517__auto___33739 = (0);
while(true){
if((i__29517__auto___33739 < len__29516__auto___33738)){
args__29523__auto__.push((arguments[i__29517__auto___33739]));

var G__33740 = (i__29517__auto___33739 + (1));
i__29517__auto___33739 = G__33740;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33734){
var vec__33735 = p__33734;
var req = cljs.core.nth.call(null,vec__33735,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq33732){
var G__33733 = cljs.core.first.call(null,seq33732);
var seq33732__$1 = cljs.core.next.call(null,seq33732);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__33733,seq33732__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(var_args){
var args__29523__auto__ = [];
var len__29516__auto___33747 = arguments.length;
var i__29517__auto___33748 = (0);
while(true){
if((i__29517__auto___33748 < len__29516__auto___33747)){
args__29523__auto__.push((arguments[i__29517__auto___33748]));

var G__33749 = (i__29517__auto___33748 + (1));
i__29517__auto___33748 = G__33749;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33743){
var vec__33744 = p__33743;
var req = cljs.core.nth.call(null,vec__33744,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq33741){
var G__33742 = cljs.core.first.call(null,seq33741);
var seq33741__$1 = cljs.core.next.call(null,seq33741);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__33742,seq33741__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(var_args){
var args__29523__auto__ = [];
var len__29516__auto___33756 = arguments.length;
var i__29517__auto___33757 = (0);
while(true){
if((i__29517__auto___33757 < len__29516__auto___33756)){
args__29523__auto__.push((arguments[i__29517__auto___33757]));

var G__33758 = (i__29517__auto___33757 + (1));
i__29517__auto___33757 = G__33758;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33752){
var vec__33753 = p__33752;
var req = cljs.core.nth.call(null,vec__33753,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq33750){
var G__33751 = cljs.core.first.call(null,seq33750);
var seq33750__$1 = cljs.core.next.call(null,seq33750);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__33751,seq33750__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(var_args){
var args__29523__auto__ = [];
var len__29516__auto___33765 = arguments.length;
var i__29517__auto___33766 = (0);
while(true){
if((i__29517__auto___33766 < len__29516__auto___33765)){
args__29523__auto__.push((arguments[i__29517__auto___33766]));

var G__33767 = (i__29517__auto___33766 + (1));
i__29517__auto___33766 = G__33767;
continue;
} else {
}
break;
}

var argseq__29524__auto__ = ((((1) < args__29523__auto__.length))?(new cljs.core.IndexedSeq(args__29523__auto__.slice((1)),(0),null)):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29524__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__33761){
var vec__33762 = p__33761;
var req = cljs.core.nth.call(null,vec__33762,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq33759){
var G__33760 = cljs.core.first.call(null,seq33759);
var seq33759__$1 = cljs.core.next.call(null,seq33759);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__33760,seq33759__$1);
});


//# sourceMappingURL=client.js.map?rel=1503637700846
