// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__11277 = arguments.length;
switch (G__11277) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async11278 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11278 = (function (f,blockable,meta11279){
this.f = f;
this.blockable = blockable;
this.meta11279 = meta11279;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async11278.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11280,meta11279__$1){
var self__ = this;
var _11280__$1 = this;
return (new cljs.core.async.t_cljs$core$async11278(self__.f,self__.blockable,meta11279__$1));
});

cljs.core.async.t_cljs$core$async11278.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11280){
var self__ = this;
var _11280__$1 = this;
return self__.meta11279;
});

cljs.core.async.t_cljs$core$async11278.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async11278.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11278.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async11278.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async11278.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11279","meta11279",145495050,null)], null);
});

cljs.core.async.t_cljs$core$async11278.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11278.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11278";

cljs.core.async.t_cljs$core$async11278.cljs$lang$ctorPrWriter = (function (this__8078__auto__,writer__8079__auto__,opt__8080__auto__){
return cljs.core._write.call(null,writer__8079__auto__,"cljs.core.async/t_cljs$core$async11278");
});

cljs.core.async.__GT_t_cljs$core$async11278 = (function cljs$core$async$__GT_t_cljs$core$async11278(f__$1,blockable__$1,meta11279){
return (new cljs.core.async.t_cljs$core$async11278(f__$1,blockable__$1,meta11279));
});

}

return (new cljs.core.async.t_cljs$core$async11278(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__11284 = arguments.length;
switch (G__11284) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__11287 = arguments.length;
switch (G__11287) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__11290 = arguments.length;
switch (G__11290) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11292 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11292);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_11292,ret){
return (function (){
return fn1.call(null,val_11292);
});})(val_11292,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__11294 = arguments.length;
switch (G__11294) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5455__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__8452__auto___11296 = n;
var x_11297 = (0);
while(true){
if((x_11297 < n__8452__auto___11296)){
(a[x_11297] = (0));

var G__11298 = (x_11297 + (1));
x_11297 = G__11298;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__11299 = (i + (1));
i = G__11299;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async11300 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11300 = (function (flag,meta11301){
this.flag = flag;
this.meta11301 = meta11301;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async11300.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_11302,meta11301__$1){
var self__ = this;
var _11302__$1 = this;
return (new cljs.core.async.t_cljs$core$async11300(self__.flag,meta11301__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async11300.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_11302){
var self__ = this;
var _11302__$1 = this;
return self__.meta11301;
});})(flag))
;

cljs.core.async.t_cljs$core$async11300.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async11300.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async11300.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11300.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11300.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11301","meta11301",-561252542,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async11300.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11300.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11300";

cljs.core.async.t_cljs$core$async11300.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__8078__auto__,writer__8079__auto__,opt__8080__auto__){
return cljs.core._write.call(null,writer__8079__auto__,"cljs.core.async/t_cljs$core$async11300");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async11300 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11300(flag__$1,meta11301){
return (new cljs.core.async.t_cljs$core$async11300(flag__$1,meta11301));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async11300(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async11303 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11303 = (function (flag,cb,meta11304){
this.flag = flag;
this.cb = cb;
this.meta11304 = meta11304;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async11303.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11305,meta11304__$1){
var self__ = this;
var _11305__$1 = this;
return (new cljs.core.async.t_cljs$core$async11303(self__.flag,self__.cb,meta11304__$1));
});

cljs.core.async.t_cljs$core$async11303.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11305){
var self__ = this;
var _11305__$1 = this;
return self__.meta11304;
});

cljs.core.async.t_cljs$core$async11303.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async11303.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async11303.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11303.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async11303.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11304","meta11304",-854315310,null)], null);
});

cljs.core.async.t_cljs$core$async11303.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11303.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11303";

cljs.core.async.t_cljs$core$async11303.cljs$lang$ctorPrWriter = (function (this__8078__auto__,writer__8079__auto__,opt__8080__auto__){
return cljs.core._write.call(null,writer__8079__auto__,"cljs.core.async/t_cljs$core$async11303");
});

cljs.core.async.__GT_t_cljs$core$async11303 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11303(flag__$1,cb__$1,meta11304){
return (new cljs.core.async.t_cljs$core$async11303(flag__$1,cb__$1,meta11304));
});

}

return (new cljs.core.async.t_cljs$core$async11303(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11306_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11306_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11307_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11307_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__7407__auto__ = wport;
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11308 = (i + (1));
i = G__11308;
continue;
}
} else {
return null;
}
break;
}
})();
var or__7407__auto__ = ret;
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__7395__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__7395__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__7395__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__8693__auto__ = [];
var len__8686__auto___11314 = arguments.length;
var i__8687__auto___11315 = (0);
while(true){
if((i__8687__auto___11315 < len__8686__auto___11314)){
args__8693__auto__.push((arguments[i__8687__auto___11315]));

var G__11316 = (i__8687__auto___11315 + (1));
i__8687__auto___11315 = G__11316;
continue;
} else {
}
break;
}

var argseq__8694__auto__ = ((((1) < args__8693__auto__.length))?(new cljs.core.IndexedSeq(args__8693__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8694__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11311){
var map__11312 = p__11311;
var map__11312__$1 = ((((!((map__11312 == null)))?((((map__11312.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11312.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11312):map__11312);
var opts = map__11312__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11309){
var G__11310 = cljs.core.first.call(null,seq11309);
var seq11309__$1 = cljs.core.next.call(null,seq11309);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11310,seq11309__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__11318 = arguments.length;
switch (G__11318) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11217__auto___11364 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto___11364){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto___11364){
return (function (state_11342){
var state_val_11343 = (state_11342[(1)]);
if((state_val_11343 === (7))){
var inst_11338 = (state_11342[(2)]);
var state_11342__$1 = state_11342;
var statearr_11344_11365 = state_11342__$1;
(statearr_11344_11365[(2)] = inst_11338);

(statearr_11344_11365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11343 === (1))){
var state_11342__$1 = state_11342;
var statearr_11345_11366 = state_11342__$1;
(statearr_11345_11366[(2)] = null);

(statearr_11345_11366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11343 === (4))){
var inst_11321 = (state_11342[(7)]);
var inst_11321__$1 = (state_11342[(2)]);
var inst_11322 = (inst_11321__$1 == null);
var state_11342__$1 = (function (){var statearr_11346 = state_11342;
(statearr_11346[(7)] = inst_11321__$1);

return statearr_11346;
})();
if(cljs.core.truth_(inst_11322)){
var statearr_11347_11367 = state_11342__$1;
(statearr_11347_11367[(1)] = (5));

} else {
var statearr_11348_11368 = state_11342__$1;
(statearr_11348_11368[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11343 === (13))){
var state_11342__$1 = state_11342;
var statearr_11349_11369 = state_11342__$1;
(statearr_11349_11369[(2)] = null);

(statearr_11349_11369[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11343 === (6))){
var inst_11321 = (state_11342[(7)]);
var state_11342__$1 = state_11342;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11342__$1,(11),to,inst_11321);
} else {
if((state_val_11343 === (3))){
var inst_11340 = (state_11342[(2)]);
var state_11342__$1 = state_11342;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11342__$1,inst_11340);
} else {
if((state_val_11343 === (12))){
var state_11342__$1 = state_11342;
var statearr_11350_11370 = state_11342__$1;
(statearr_11350_11370[(2)] = null);

(statearr_11350_11370[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11343 === (2))){
var state_11342__$1 = state_11342;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11342__$1,(4),from);
} else {
if((state_val_11343 === (11))){
var inst_11331 = (state_11342[(2)]);
var state_11342__$1 = state_11342;
if(cljs.core.truth_(inst_11331)){
var statearr_11351_11371 = state_11342__$1;
(statearr_11351_11371[(1)] = (12));

} else {
var statearr_11352_11372 = state_11342__$1;
(statearr_11352_11372[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11343 === (9))){
var state_11342__$1 = state_11342;
var statearr_11353_11373 = state_11342__$1;
(statearr_11353_11373[(2)] = null);

(statearr_11353_11373[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11343 === (5))){
var state_11342__$1 = state_11342;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11354_11374 = state_11342__$1;
(statearr_11354_11374[(1)] = (8));

} else {
var statearr_11355_11375 = state_11342__$1;
(statearr_11355_11375[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11343 === (14))){
var inst_11336 = (state_11342[(2)]);
var state_11342__$1 = state_11342;
var statearr_11356_11376 = state_11342__$1;
(statearr_11356_11376[(2)] = inst_11336);

(statearr_11356_11376[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11343 === (10))){
var inst_11328 = (state_11342[(2)]);
var state_11342__$1 = state_11342;
var statearr_11357_11377 = state_11342__$1;
(statearr_11357_11377[(2)] = inst_11328);

(statearr_11357_11377[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11343 === (8))){
var inst_11325 = cljs.core.async.close_BANG_.call(null,to);
var state_11342__$1 = state_11342;
var statearr_11358_11378 = state_11342__$1;
(statearr_11358_11378[(2)] = inst_11325);

(statearr_11358_11378[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11217__auto___11364))
;
return ((function (switch__11127__auto__,c__11217__auto___11364){
return (function() {
var cljs$core$async$state_machine__11128__auto__ = null;
var cljs$core$async$state_machine__11128__auto____0 = (function (){
var statearr_11359 = [null,null,null,null,null,null,null,null];
(statearr_11359[(0)] = cljs$core$async$state_machine__11128__auto__);

(statearr_11359[(1)] = (1));

return statearr_11359;
});
var cljs$core$async$state_machine__11128__auto____1 = (function (state_11342){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_11342);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e11360){if((e11360 instanceof Object)){
var ex__11131__auto__ = e11360;
var statearr_11361_11379 = state_11342;
(statearr_11361_11379[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11342);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11360;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11380 = state_11342;
state_11342 = G__11380;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$state_machine__11128__auto__ = function(state_11342){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11128__auto____1.call(this,state_11342);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11128__auto____0;
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11128__auto____1;
return cljs$core$async$state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto___11364))
})();
var state__11219__auto__ = (function (){var statearr_11362 = f__11218__auto__.call(null);
(statearr_11362[(6)] = c__11217__auto___11364);

return statearr_11362;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto___11364))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__11381){
var vec__11382 = p__11381;
var v = cljs.core.nth.call(null,vec__11382,(0),null);
var p = cljs.core.nth.call(null,vec__11382,(1),null);
var job = vec__11382;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11217__auto___11553 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto___11553,res,vec__11382,v,p,job,jobs,results){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto___11553,res,vec__11382,v,p,job,jobs,results){
return (function (state_11389){
var state_val_11390 = (state_11389[(1)]);
if((state_val_11390 === (1))){
var state_11389__$1 = state_11389;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11389__$1,(2),res,v);
} else {
if((state_val_11390 === (2))){
var inst_11386 = (state_11389[(2)]);
var inst_11387 = cljs.core.async.close_BANG_.call(null,res);
var state_11389__$1 = (function (){var statearr_11391 = state_11389;
(statearr_11391[(7)] = inst_11386);

return statearr_11391;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11389__$1,inst_11387);
} else {
return null;
}
}
});})(c__11217__auto___11553,res,vec__11382,v,p,job,jobs,results))
;
return ((function (switch__11127__auto__,c__11217__auto___11553,res,vec__11382,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____0 = (function (){
var statearr_11392 = [null,null,null,null,null,null,null,null];
(statearr_11392[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__);

(statearr_11392[(1)] = (1));

return statearr_11392;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____1 = (function (state_11389){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_11389);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e11393){if((e11393 instanceof Object)){
var ex__11131__auto__ = e11393;
var statearr_11394_11554 = state_11389;
(statearr_11394_11554[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11389);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11393;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11555 = state_11389;
state_11389 = G__11555;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__ = function(state_11389){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____1.call(this,state_11389);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto___11553,res,vec__11382,v,p,job,jobs,results))
})();
var state__11219__auto__ = (function (){var statearr_11395 = f__11218__auto__.call(null);
(statearr_11395[(6)] = c__11217__auto___11553);

return statearr_11395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto___11553,res,vec__11382,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__11396){
var vec__11397 = p__11396;
var v = cljs.core.nth.call(null,vec__11397,(0),null);
var p = cljs.core.nth.call(null,vec__11397,(1),null);
var job = vec__11397;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__8452__auto___11556 = n;
var __11557 = (0);
while(true){
if((__11557 < n__8452__auto___11556)){
var G__11400_11558 = type;
var G__11400_11559__$1 = (((G__11400_11558 instanceof cljs.core.Keyword))?G__11400_11558.fqn:null);
switch (G__11400_11559__$1) {
case "compute":
var c__11217__auto___11561 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11557,c__11217__auto___11561,G__11400_11558,G__11400_11559__$1,n__8452__auto___11556,jobs,results,process,async){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (__11557,c__11217__auto___11561,G__11400_11558,G__11400_11559__$1,n__8452__auto___11556,jobs,results,process,async){
return (function (state_11413){
var state_val_11414 = (state_11413[(1)]);
if((state_val_11414 === (1))){
var state_11413__$1 = state_11413;
var statearr_11415_11562 = state_11413__$1;
(statearr_11415_11562[(2)] = null);

(statearr_11415_11562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11414 === (2))){
var state_11413__$1 = state_11413;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11413__$1,(4),jobs);
} else {
if((state_val_11414 === (3))){
var inst_11411 = (state_11413[(2)]);
var state_11413__$1 = state_11413;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11413__$1,inst_11411);
} else {
if((state_val_11414 === (4))){
var inst_11403 = (state_11413[(2)]);
var inst_11404 = process.call(null,inst_11403);
var state_11413__$1 = state_11413;
if(cljs.core.truth_(inst_11404)){
var statearr_11416_11563 = state_11413__$1;
(statearr_11416_11563[(1)] = (5));

} else {
var statearr_11417_11564 = state_11413__$1;
(statearr_11417_11564[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11414 === (5))){
var state_11413__$1 = state_11413;
var statearr_11418_11565 = state_11413__$1;
(statearr_11418_11565[(2)] = null);

(statearr_11418_11565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11414 === (6))){
var state_11413__$1 = state_11413;
var statearr_11419_11566 = state_11413__$1;
(statearr_11419_11566[(2)] = null);

(statearr_11419_11566[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11414 === (7))){
var inst_11409 = (state_11413[(2)]);
var state_11413__$1 = state_11413;
var statearr_11420_11567 = state_11413__$1;
(statearr_11420_11567[(2)] = inst_11409);

(statearr_11420_11567[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11557,c__11217__auto___11561,G__11400_11558,G__11400_11559__$1,n__8452__auto___11556,jobs,results,process,async))
;
return ((function (__11557,switch__11127__auto__,c__11217__auto___11561,G__11400_11558,G__11400_11559__$1,n__8452__auto___11556,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____0 = (function (){
var statearr_11421 = [null,null,null,null,null,null,null];
(statearr_11421[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__);

(statearr_11421[(1)] = (1));

return statearr_11421;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____1 = (function (state_11413){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_11413);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e11422){if((e11422 instanceof Object)){
var ex__11131__auto__ = e11422;
var statearr_11423_11568 = state_11413;
(statearr_11423_11568[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11413);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11422;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11569 = state_11413;
state_11413 = G__11569;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__ = function(state_11413){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____1.call(this,state_11413);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__;
})()
;})(__11557,switch__11127__auto__,c__11217__auto___11561,G__11400_11558,G__11400_11559__$1,n__8452__auto___11556,jobs,results,process,async))
})();
var state__11219__auto__ = (function (){var statearr_11424 = f__11218__auto__.call(null);
(statearr_11424[(6)] = c__11217__auto___11561);

return statearr_11424;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(__11557,c__11217__auto___11561,G__11400_11558,G__11400_11559__$1,n__8452__auto___11556,jobs,results,process,async))
);


break;
case "async":
var c__11217__auto___11570 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11557,c__11217__auto___11570,G__11400_11558,G__11400_11559__$1,n__8452__auto___11556,jobs,results,process,async){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (__11557,c__11217__auto___11570,G__11400_11558,G__11400_11559__$1,n__8452__auto___11556,jobs,results,process,async){
return (function (state_11437){
var state_val_11438 = (state_11437[(1)]);
if((state_val_11438 === (1))){
var state_11437__$1 = state_11437;
var statearr_11439_11571 = state_11437__$1;
(statearr_11439_11571[(2)] = null);

(statearr_11439_11571[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11438 === (2))){
var state_11437__$1 = state_11437;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11437__$1,(4),jobs);
} else {
if((state_val_11438 === (3))){
var inst_11435 = (state_11437[(2)]);
var state_11437__$1 = state_11437;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11437__$1,inst_11435);
} else {
if((state_val_11438 === (4))){
var inst_11427 = (state_11437[(2)]);
var inst_11428 = async.call(null,inst_11427);
var state_11437__$1 = state_11437;
if(cljs.core.truth_(inst_11428)){
var statearr_11440_11572 = state_11437__$1;
(statearr_11440_11572[(1)] = (5));

} else {
var statearr_11441_11573 = state_11437__$1;
(statearr_11441_11573[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11438 === (5))){
var state_11437__$1 = state_11437;
var statearr_11442_11574 = state_11437__$1;
(statearr_11442_11574[(2)] = null);

(statearr_11442_11574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11438 === (6))){
var state_11437__$1 = state_11437;
var statearr_11443_11575 = state_11437__$1;
(statearr_11443_11575[(2)] = null);

(statearr_11443_11575[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11438 === (7))){
var inst_11433 = (state_11437[(2)]);
var state_11437__$1 = state_11437;
var statearr_11444_11576 = state_11437__$1;
(statearr_11444_11576[(2)] = inst_11433);

(statearr_11444_11576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11557,c__11217__auto___11570,G__11400_11558,G__11400_11559__$1,n__8452__auto___11556,jobs,results,process,async))
;
return ((function (__11557,switch__11127__auto__,c__11217__auto___11570,G__11400_11558,G__11400_11559__$1,n__8452__auto___11556,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____0 = (function (){
var statearr_11445 = [null,null,null,null,null,null,null];
(statearr_11445[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__);

(statearr_11445[(1)] = (1));

return statearr_11445;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____1 = (function (state_11437){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_11437);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e11446){if((e11446 instanceof Object)){
var ex__11131__auto__ = e11446;
var statearr_11447_11577 = state_11437;
(statearr_11447_11577[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11437);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11446;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11578 = state_11437;
state_11437 = G__11578;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__ = function(state_11437){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____1.call(this,state_11437);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__;
})()
;})(__11557,switch__11127__auto__,c__11217__auto___11570,G__11400_11558,G__11400_11559__$1,n__8452__auto___11556,jobs,results,process,async))
})();
var state__11219__auto__ = (function (){var statearr_11448 = f__11218__auto__.call(null);
(statearr_11448[(6)] = c__11217__auto___11570);

return statearr_11448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(__11557,c__11217__auto___11570,G__11400_11558,G__11400_11559__$1,n__8452__auto___11556,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__11400_11559__$1)].join('')));

}

var G__11579 = (__11557 + (1));
__11557 = G__11579;
continue;
} else {
}
break;
}

var c__11217__auto___11580 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto___11580,jobs,results,process,async){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto___11580,jobs,results,process,async){
return (function (state_11470){
var state_val_11471 = (state_11470[(1)]);
if((state_val_11471 === (1))){
var state_11470__$1 = state_11470;
var statearr_11472_11581 = state_11470__$1;
(statearr_11472_11581[(2)] = null);

(statearr_11472_11581[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11471 === (2))){
var state_11470__$1 = state_11470;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11470__$1,(4),from);
} else {
if((state_val_11471 === (3))){
var inst_11468 = (state_11470[(2)]);
var state_11470__$1 = state_11470;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11470__$1,inst_11468);
} else {
if((state_val_11471 === (4))){
var inst_11451 = (state_11470[(7)]);
var inst_11451__$1 = (state_11470[(2)]);
var inst_11452 = (inst_11451__$1 == null);
var state_11470__$1 = (function (){var statearr_11473 = state_11470;
(statearr_11473[(7)] = inst_11451__$1);

return statearr_11473;
})();
if(cljs.core.truth_(inst_11452)){
var statearr_11474_11582 = state_11470__$1;
(statearr_11474_11582[(1)] = (5));

} else {
var statearr_11475_11583 = state_11470__$1;
(statearr_11475_11583[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11471 === (5))){
var inst_11454 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11470__$1 = state_11470;
var statearr_11476_11584 = state_11470__$1;
(statearr_11476_11584[(2)] = inst_11454);

(statearr_11476_11584[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11471 === (6))){
var inst_11456 = (state_11470[(8)]);
var inst_11451 = (state_11470[(7)]);
var inst_11456__$1 = cljs.core.async.chan.call(null,(1));
var inst_11457 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11458 = [inst_11451,inst_11456__$1];
var inst_11459 = (new cljs.core.PersistentVector(null,2,(5),inst_11457,inst_11458,null));
var state_11470__$1 = (function (){var statearr_11477 = state_11470;
(statearr_11477[(8)] = inst_11456__$1);

return statearr_11477;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11470__$1,(8),jobs,inst_11459);
} else {
if((state_val_11471 === (7))){
var inst_11466 = (state_11470[(2)]);
var state_11470__$1 = state_11470;
var statearr_11478_11585 = state_11470__$1;
(statearr_11478_11585[(2)] = inst_11466);

(statearr_11478_11585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11471 === (8))){
var inst_11456 = (state_11470[(8)]);
var inst_11461 = (state_11470[(2)]);
var state_11470__$1 = (function (){var statearr_11479 = state_11470;
(statearr_11479[(9)] = inst_11461);

return statearr_11479;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11470__$1,(9),results,inst_11456);
} else {
if((state_val_11471 === (9))){
var inst_11463 = (state_11470[(2)]);
var state_11470__$1 = (function (){var statearr_11480 = state_11470;
(statearr_11480[(10)] = inst_11463);

return statearr_11480;
})();
var statearr_11481_11586 = state_11470__$1;
(statearr_11481_11586[(2)] = null);

(statearr_11481_11586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11217__auto___11580,jobs,results,process,async))
;
return ((function (switch__11127__auto__,c__11217__auto___11580,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____0 = (function (){
var statearr_11482 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11482[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__);

(statearr_11482[(1)] = (1));

return statearr_11482;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____1 = (function (state_11470){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_11470);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e11483){if((e11483 instanceof Object)){
var ex__11131__auto__ = e11483;
var statearr_11484_11587 = state_11470;
(statearr_11484_11587[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11470);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11483;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11588 = state_11470;
state_11470 = G__11588;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__ = function(state_11470){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____1.call(this,state_11470);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto___11580,jobs,results,process,async))
})();
var state__11219__auto__ = (function (){var statearr_11485 = f__11218__auto__.call(null);
(statearr_11485[(6)] = c__11217__auto___11580);

return statearr_11485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto___11580,jobs,results,process,async))
);


var c__11217__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto__,jobs,results,process,async){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto__,jobs,results,process,async){
return (function (state_11523){
var state_val_11524 = (state_11523[(1)]);
if((state_val_11524 === (7))){
var inst_11519 = (state_11523[(2)]);
var state_11523__$1 = state_11523;
var statearr_11525_11589 = state_11523__$1;
(statearr_11525_11589[(2)] = inst_11519);

(statearr_11525_11589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11524 === (20))){
var state_11523__$1 = state_11523;
var statearr_11526_11590 = state_11523__$1;
(statearr_11526_11590[(2)] = null);

(statearr_11526_11590[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11524 === (1))){
var state_11523__$1 = state_11523;
var statearr_11527_11591 = state_11523__$1;
(statearr_11527_11591[(2)] = null);

(statearr_11527_11591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11524 === (4))){
var inst_11488 = (state_11523[(7)]);
var inst_11488__$1 = (state_11523[(2)]);
var inst_11489 = (inst_11488__$1 == null);
var state_11523__$1 = (function (){var statearr_11528 = state_11523;
(statearr_11528[(7)] = inst_11488__$1);

return statearr_11528;
})();
if(cljs.core.truth_(inst_11489)){
var statearr_11529_11592 = state_11523__$1;
(statearr_11529_11592[(1)] = (5));

} else {
var statearr_11530_11593 = state_11523__$1;
(statearr_11530_11593[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11524 === (15))){
var inst_11501 = (state_11523[(8)]);
var state_11523__$1 = state_11523;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11523__$1,(18),to,inst_11501);
} else {
if((state_val_11524 === (21))){
var inst_11514 = (state_11523[(2)]);
var state_11523__$1 = state_11523;
var statearr_11531_11594 = state_11523__$1;
(statearr_11531_11594[(2)] = inst_11514);

(statearr_11531_11594[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11524 === (13))){
var inst_11516 = (state_11523[(2)]);
var state_11523__$1 = (function (){var statearr_11532 = state_11523;
(statearr_11532[(9)] = inst_11516);

return statearr_11532;
})();
var statearr_11533_11595 = state_11523__$1;
(statearr_11533_11595[(2)] = null);

(statearr_11533_11595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11524 === (6))){
var inst_11488 = (state_11523[(7)]);
var state_11523__$1 = state_11523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11523__$1,(11),inst_11488);
} else {
if((state_val_11524 === (17))){
var inst_11509 = (state_11523[(2)]);
var state_11523__$1 = state_11523;
if(cljs.core.truth_(inst_11509)){
var statearr_11534_11596 = state_11523__$1;
(statearr_11534_11596[(1)] = (19));

} else {
var statearr_11535_11597 = state_11523__$1;
(statearr_11535_11597[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11524 === (3))){
var inst_11521 = (state_11523[(2)]);
var state_11523__$1 = state_11523;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11523__$1,inst_11521);
} else {
if((state_val_11524 === (12))){
var inst_11498 = (state_11523[(10)]);
var state_11523__$1 = state_11523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11523__$1,(14),inst_11498);
} else {
if((state_val_11524 === (2))){
var state_11523__$1 = state_11523;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11523__$1,(4),results);
} else {
if((state_val_11524 === (19))){
var state_11523__$1 = state_11523;
var statearr_11536_11598 = state_11523__$1;
(statearr_11536_11598[(2)] = null);

(statearr_11536_11598[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11524 === (11))){
var inst_11498 = (state_11523[(2)]);
var state_11523__$1 = (function (){var statearr_11537 = state_11523;
(statearr_11537[(10)] = inst_11498);

return statearr_11537;
})();
var statearr_11538_11599 = state_11523__$1;
(statearr_11538_11599[(2)] = null);

(statearr_11538_11599[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11524 === (9))){
var state_11523__$1 = state_11523;
var statearr_11539_11600 = state_11523__$1;
(statearr_11539_11600[(2)] = null);

(statearr_11539_11600[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11524 === (5))){
var state_11523__$1 = state_11523;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11540_11601 = state_11523__$1;
(statearr_11540_11601[(1)] = (8));

} else {
var statearr_11541_11602 = state_11523__$1;
(statearr_11541_11602[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11524 === (14))){
var inst_11501 = (state_11523[(8)]);
var inst_11503 = (state_11523[(11)]);
var inst_11501__$1 = (state_11523[(2)]);
var inst_11502 = (inst_11501__$1 == null);
var inst_11503__$1 = cljs.core.not.call(null,inst_11502);
var state_11523__$1 = (function (){var statearr_11542 = state_11523;
(statearr_11542[(8)] = inst_11501__$1);

(statearr_11542[(11)] = inst_11503__$1);

return statearr_11542;
})();
if(inst_11503__$1){
var statearr_11543_11603 = state_11523__$1;
(statearr_11543_11603[(1)] = (15));

} else {
var statearr_11544_11604 = state_11523__$1;
(statearr_11544_11604[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11524 === (16))){
var inst_11503 = (state_11523[(11)]);
var state_11523__$1 = state_11523;
var statearr_11545_11605 = state_11523__$1;
(statearr_11545_11605[(2)] = inst_11503);

(statearr_11545_11605[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11524 === (10))){
var inst_11495 = (state_11523[(2)]);
var state_11523__$1 = state_11523;
var statearr_11546_11606 = state_11523__$1;
(statearr_11546_11606[(2)] = inst_11495);

(statearr_11546_11606[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11524 === (18))){
var inst_11506 = (state_11523[(2)]);
var state_11523__$1 = state_11523;
var statearr_11547_11607 = state_11523__$1;
(statearr_11547_11607[(2)] = inst_11506);

(statearr_11547_11607[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11524 === (8))){
var inst_11492 = cljs.core.async.close_BANG_.call(null,to);
var state_11523__$1 = state_11523;
var statearr_11548_11608 = state_11523__$1;
(statearr_11548_11608[(2)] = inst_11492);

(statearr_11548_11608[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11217__auto__,jobs,results,process,async))
;
return ((function (switch__11127__auto__,c__11217__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____0 = (function (){
var statearr_11549 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11549[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__);

(statearr_11549[(1)] = (1));

return statearr_11549;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____1 = (function (state_11523){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_11523);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e11550){if((e11550 instanceof Object)){
var ex__11131__auto__ = e11550;
var statearr_11551_11609 = state_11523;
(statearr_11551_11609[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11523);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11550;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11610 = state_11523;
state_11523 = G__11610;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__ = function(state_11523){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____1.call(this,state_11523);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11128__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto__,jobs,results,process,async))
})();
var state__11219__auto__ = (function (){var statearr_11552 = f__11218__auto__.call(null);
(statearr_11552[(6)] = c__11217__auto__);

return statearr_11552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto__,jobs,results,process,async))
);

return c__11217__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__11612 = arguments.length;
switch (G__11612) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__11615 = arguments.length;
switch (G__11615) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__11618 = arguments.length;
switch (G__11618) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11217__auto___11667 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto___11667,tc,fc){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto___11667,tc,fc){
return (function (state_11644){
var state_val_11645 = (state_11644[(1)]);
if((state_val_11645 === (7))){
var inst_11640 = (state_11644[(2)]);
var state_11644__$1 = state_11644;
var statearr_11646_11668 = state_11644__$1;
(statearr_11646_11668[(2)] = inst_11640);

(statearr_11646_11668[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11645 === (1))){
var state_11644__$1 = state_11644;
var statearr_11647_11669 = state_11644__$1;
(statearr_11647_11669[(2)] = null);

(statearr_11647_11669[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11645 === (4))){
var inst_11621 = (state_11644[(7)]);
var inst_11621__$1 = (state_11644[(2)]);
var inst_11622 = (inst_11621__$1 == null);
var state_11644__$1 = (function (){var statearr_11648 = state_11644;
(statearr_11648[(7)] = inst_11621__$1);

return statearr_11648;
})();
if(cljs.core.truth_(inst_11622)){
var statearr_11649_11670 = state_11644__$1;
(statearr_11649_11670[(1)] = (5));

} else {
var statearr_11650_11671 = state_11644__$1;
(statearr_11650_11671[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11645 === (13))){
var state_11644__$1 = state_11644;
var statearr_11651_11672 = state_11644__$1;
(statearr_11651_11672[(2)] = null);

(statearr_11651_11672[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11645 === (6))){
var inst_11621 = (state_11644[(7)]);
var inst_11627 = p.call(null,inst_11621);
var state_11644__$1 = state_11644;
if(cljs.core.truth_(inst_11627)){
var statearr_11652_11673 = state_11644__$1;
(statearr_11652_11673[(1)] = (9));

} else {
var statearr_11653_11674 = state_11644__$1;
(statearr_11653_11674[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11645 === (3))){
var inst_11642 = (state_11644[(2)]);
var state_11644__$1 = state_11644;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11644__$1,inst_11642);
} else {
if((state_val_11645 === (12))){
var state_11644__$1 = state_11644;
var statearr_11654_11675 = state_11644__$1;
(statearr_11654_11675[(2)] = null);

(statearr_11654_11675[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11645 === (2))){
var state_11644__$1 = state_11644;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11644__$1,(4),ch);
} else {
if((state_val_11645 === (11))){
var inst_11621 = (state_11644[(7)]);
var inst_11631 = (state_11644[(2)]);
var state_11644__$1 = state_11644;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11644__$1,(8),inst_11631,inst_11621);
} else {
if((state_val_11645 === (9))){
var state_11644__$1 = state_11644;
var statearr_11655_11676 = state_11644__$1;
(statearr_11655_11676[(2)] = tc);

(statearr_11655_11676[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11645 === (5))){
var inst_11624 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11625 = cljs.core.async.close_BANG_.call(null,fc);
var state_11644__$1 = (function (){var statearr_11656 = state_11644;
(statearr_11656[(8)] = inst_11624);

return statearr_11656;
})();
var statearr_11657_11677 = state_11644__$1;
(statearr_11657_11677[(2)] = inst_11625);

(statearr_11657_11677[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11645 === (14))){
var inst_11638 = (state_11644[(2)]);
var state_11644__$1 = state_11644;
var statearr_11658_11678 = state_11644__$1;
(statearr_11658_11678[(2)] = inst_11638);

(statearr_11658_11678[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11645 === (10))){
var state_11644__$1 = state_11644;
var statearr_11659_11679 = state_11644__$1;
(statearr_11659_11679[(2)] = fc);

(statearr_11659_11679[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11645 === (8))){
var inst_11633 = (state_11644[(2)]);
var state_11644__$1 = state_11644;
if(cljs.core.truth_(inst_11633)){
var statearr_11660_11680 = state_11644__$1;
(statearr_11660_11680[(1)] = (12));

} else {
var statearr_11661_11681 = state_11644__$1;
(statearr_11661_11681[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11217__auto___11667,tc,fc))
;
return ((function (switch__11127__auto__,c__11217__auto___11667,tc,fc){
return (function() {
var cljs$core$async$state_machine__11128__auto__ = null;
var cljs$core$async$state_machine__11128__auto____0 = (function (){
var statearr_11662 = [null,null,null,null,null,null,null,null,null];
(statearr_11662[(0)] = cljs$core$async$state_machine__11128__auto__);

(statearr_11662[(1)] = (1));

return statearr_11662;
});
var cljs$core$async$state_machine__11128__auto____1 = (function (state_11644){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_11644);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e11663){if((e11663 instanceof Object)){
var ex__11131__auto__ = e11663;
var statearr_11664_11682 = state_11644;
(statearr_11664_11682[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11644);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11663;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11683 = state_11644;
state_11644 = G__11683;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$state_machine__11128__auto__ = function(state_11644){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11128__auto____1.call(this,state_11644);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11128__auto____0;
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11128__auto____1;
return cljs$core$async$state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto___11667,tc,fc))
})();
var state__11219__auto__ = (function (){var statearr_11665 = f__11218__auto__.call(null);
(statearr_11665[(6)] = c__11217__auto___11667);

return statearr_11665;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto___11667,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11217__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto__){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto__){
return (function (state_11704){
var state_val_11705 = (state_11704[(1)]);
if((state_val_11705 === (7))){
var inst_11700 = (state_11704[(2)]);
var state_11704__$1 = state_11704;
var statearr_11706_11724 = state_11704__$1;
(statearr_11706_11724[(2)] = inst_11700);

(statearr_11706_11724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11705 === (1))){
var inst_11684 = init;
var state_11704__$1 = (function (){var statearr_11707 = state_11704;
(statearr_11707[(7)] = inst_11684);

return statearr_11707;
})();
var statearr_11708_11725 = state_11704__$1;
(statearr_11708_11725[(2)] = null);

(statearr_11708_11725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11705 === (4))){
var inst_11687 = (state_11704[(8)]);
var inst_11687__$1 = (state_11704[(2)]);
var inst_11688 = (inst_11687__$1 == null);
var state_11704__$1 = (function (){var statearr_11709 = state_11704;
(statearr_11709[(8)] = inst_11687__$1);

return statearr_11709;
})();
if(cljs.core.truth_(inst_11688)){
var statearr_11710_11726 = state_11704__$1;
(statearr_11710_11726[(1)] = (5));

} else {
var statearr_11711_11727 = state_11704__$1;
(statearr_11711_11727[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11705 === (6))){
var inst_11687 = (state_11704[(8)]);
var inst_11691 = (state_11704[(9)]);
var inst_11684 = (state_11704[(7)]);
var inst_11691__$1 = f.call(null,inst_11684,inst_11687);
var inst_11692 = cljs.core.reduced_QMARK_.call(null,inst_11691__$1);
var state_11704__$1 = (function (){var statearr_11712 = state_11704;
(statearr_11712[(9)] = inst_11691__$1);

return statearr_11712;
})();
if(inst_11692){
var statearr_11713_11728 = state_11704__$1;
(statearr_11713_11728[(1)] = (8));

} else {
var statearr_11714_11729 = state_11704__$1;
(statearr_11714_11729[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11705 === (3))){
var inst_11702 = (state_11704[(2)]);
var state_11704__$1 = state_11704;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11704__$1,inst_11702);
} else {
if((state_val_11705 === (2))){
var state_11704__$1 = state_11704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11704__$1,(4),ch);
} else {
if((state_val_11705 === (9))){
var inst_11691 = (state_11704[(9)]);
var inst_11684 = inst_11691;
var state_11704__$1 = (function (){var statearr_11715 = state_11704;
(statearr_11715[(7)] = inst_11684);

return statearr_11715;
})();
var statearr_11716_11730 = state_11704__$1;
(statearr_11716_11730[(2)] = null);

(statearr_11716_11730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11705 === (5))){
var inst_11684 = (state_11704[(7)]);
var state_11704__$1 = state_11704;
var statearr_11717_11731 = state_11704__$1;
(statearr_11717_11731[(2)] = inst_11684);

(statearr_11717_11731[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11705 === (10))){
var inst_11698 = (state_11704[(2)]);
var state_11704__$1 = state_11704;
var statearr_11718_11732 = state_11704__$1;
(statearr_11718_11732[(2)] = inst_11698);

(statearr_11718_11732[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11705 === (8))){
var inst_11691 = (state_11704[(9)]);
var inst_11694 = cljs.core.deref.call(null,inst_11691);
var state_11704__$1 = state_11704;
var statearr_11719_11733 = state_11704__$1;
(statearr_11719_11733[(2)] = inst_11694);

(statearr_11719_11733[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11217__auto__))
;
return ((function (switch__11127__auto__,c__11217__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__11128__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11128__auto____0 = (function (){
var statearr_11720 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11720[(0)] = cljs$core$async$reduce_$_state_machine__11128__auto__);

(statearr_11720[(1)] = (1));

return statearr_11720;
});
var cljs$core$async$reduce_$_state_machine__11128__auto____1 = (function (state_11704){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_11704);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e11721){if((e11721 instanceof Object)){
var ex__11131__auto__ = e11721;
var statearr_11722_11734 = state_11704;
(statearr_11722_11734[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11704);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11721;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11735 = state_11704;
state_11704 = G__11735;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11128__auto__ = function(state_11704){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11128__auto____1.call(this,state_11704);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11128__auto____0;
cljs$core$async$reduce_$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11128__auto____1;
return cljs$core$async$reduce_$_state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto__))
})();
var state__11219__auto__ = (function (){var statearr_11723 = f__11218__auto__.call(null);
(statearr_11723[(6)] = c__11217__auto__);

return statearr_11723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto__))
);

return c__11217__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__11217__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto__,f__$1){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto__,f__$1){
return (function (state_11741){
var state_val_11742 = (state_11741[(1)]);
if((state_val_11742 === (1))){
var inst_11736 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_11741__$1 = state_11741;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11741__$1,(2),inst_11736);
} else {
if((state_val_11742 === (2))){
var inst_11738 = (state_11741[(2)]);
var inst_11739 = f__$1.call(null,inst_11738);
var state_11741__$1 = state_11741;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11741__$1,inst_11739);
} else {
return null;
}
}
});})(c__11217__auto__,f__$1))
;
return ((function (switch__11127__auto__,c__11217__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__11128__auto__ = null;
var cljs$core$async$transduce_$_state_machine__11128__auto____0 = (function (){
var statearr_11743 = [null,null,null,null,null,null,null];
(statearr_11743[(0)] = cljs$core$async$transduce_$_state_machine__11128__auto__);

(statearr_11743[(1)] = (1));

return statearr_11743;
});
var cljs$core$async$transduce_$_state_machine__11128__auto____1 = (function (state_11741){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_11741);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e11744){if((e11744 instanceof Object)){
var ex__11131__auto__ = e11744;
var statearr_11745_11747 = state_11741;
(statearr_11745_11747[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11741);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11744;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11748 = state_11741;
state_11741 = G__11748;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__11128__auto__ = function(state_11741){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__11128__auto____1.call(this,state_11741);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__11128__auto____0;
cljs$core$async$transduce_$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__11128__auto____1;
return cljs$core$async$transduce_$_state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto__,f__$1))
})();
var state__11219__auto__ = (function (){var statearr_11746 = f__11218__auto__.call(null);
(statearr_11746[(6)] = c__11217__auto__);

return statearr_11746;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto__,f__$1))
);

return c__11217__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__11750 = arguments.length;
switch (G__11750) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11217__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto__){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto__){
return (function (state_11775){
var state_val_11776 = (state_11775[(1)]);
if((state_val_11776 === (7))){
var inst_11757 = (state_11775[(2)]);
var state_11775__$1 = state_11775;
var statearr_11777_11798 = state_11775__$1;
(statearr_11777_11798[(2)] = inst_11757);

(statearr_11777_11798[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11776 === (1))){
var inst_11751 = cljs.core.seq.call(null,coll);
var inst_11752 = inst_11751;
var state_11775__$1 = (function (){var statearr_11778 = state_11775;
(statearr_11778[(7)] = inst_11752);

return statearr_11778;
})();
var statearr_11779_11799 = state_11775__$1;
(statearr_11779_11799[(2)] = null);

(statearr_11779_11799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11776 === (4))){
var inst_11752 = (state_11775[(7)]);
var inst_11755 = cljs.core.first.call(null,inst_11752);
var state_11775__$1 = state_11775;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11775__$1,(7),ch,inst_11755);
} else {
if((state_val_11776 === (13))){
var inst_11769 = (state_11775[(2)]);
var state_11775__$1 = state_11775;
var statearr_11780_11800 = state_11775__$1;
(statearr_11780_11800[(2)] = inst_11769);

(statearr_11780_11800[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11776 === (6))){
var inst_11760 = (state_11775[(2)]);
var state_11775__$1 = state_11775;
if(cljs.core.truth_(inst_11760)){
var statearr_11781_11801 = state_11775__$1;
(statearr_11781_11801[(1)] = (8));

} else {
var statearr_11782_11802 = state_11775__$1;
(statearr_11782_11802[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11776 === (3))){
var inst_11773 = (state_11775[(2)]);
var state_11775__$1 = state_11775;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11775__$1,inst_11773);
} else {
if((state_val_11776 === (12))){
var state_11775__$1 = state_11775;
var statearr_11783_11803 = state_11775__$1;
(statearr_11783_11803[(2)] = null);

(statearr_11783_11803[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11776 === (2))){
var inst_11752 = (state_11775[(7)]);
var state_11775__$1 = state_11775;
if(cljs.core.truth_(inst_11752)){
var statearr_11784_11804 = state_11775__$1;
(statearr_11784_11804[(1)] = (4));

} else {
var statearr_11785_11805 = state_11775__$1;
(statearr_11785_11805[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11776 === (11))){
var inst_11766 = cljs.core.async.close_BANG_.call(null,ch);
var state_11775__$1 = state_11775;
var statearr_11786_11806 = state_11775__$1;
(statearr_11786_11806[(2)] = inst_11766);

(statearr_11786_11806[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11776 === (9))){
var state_11775__$1 = state_11775;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11787_11807 = state_11775__$1;
(statearr_11787_11807[(1)] = (11));

} else {
var statearr_11788_11808 = state_11775__$1;
(statearr_11788_11808[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11776 === (5))){
var inst_11752 = (state_11775[(7)]);
var state_11775__$1 = state_11775;
var statearr_11789_11809 = state_11775__$1;
(statearr_11789_11809[(2)] = inst_11752);

(statearr_11789_11809[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11776 === (10))){
var inst_11771 = (state_11775[(2)]);
var state_11775__$1 = state_11775;
var statearr_11790_11810 = state_11775__$1;
(statearr_11790_11810[(2)] = inst_11771);

(statearr_11790_11810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11776 === (8))){
var inst_11752 = (state_11775[(7)]);
var inst_11762 = cljs.core.next.call(null,inst_11752);
var inst_11752__$1 = inst_11762;
var state_11775__$1 = (function (){var statearr_11791 = state_11775;
(statearr_11791[(7)] = inst_11752__$1);

return statearr_11791;
})();
var statearr_11792_11811 = state_11775__$1;
(statearr_11792_11811[(2)] = null);

(statearr_11792_11811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11217__auto__))
;
return ((function (switch__11127__auto__,c__11217__auto__){
return (function() {
var cljs$core$async$state_machine__11128__auto__ = null;
var cljs$core$async$state_machine__11128__auto____0 = (function (){
var statearr_11793 = [null,null,null,null,null,null,null,null];
(statearr_11793[(0)] = cljs$core$async$state_machine__11128__auto__);

(statearr_11793[(1)] = (1));

return statearr_11793;
});
var cljs$core$async$state_machine__11128__auto____1 = (function (state_11775){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_11775);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e11794){if((e11794 instanceof Object)){
var ex__11131__auto__ = e11794;
var statearr_11795_11812 = state_11775;
(statearr_11795_11812[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11775);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11794;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11813 = state_11775;
state_11775 = G__11813;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$state_machine__11128__auto__ = function(state_11775){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11128__auto____1.call(this,state_11775);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11128__auto____0;
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11128__auto____1;
return cljs$core$async$state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto__))
})();
var state__11219__auto__ = (function (){var statearr_11796 = f__11218__auto__.call(null);
(statearr_11796[(6)] = c__11217__auto__);

return statearr_11796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto__))
);

return c__11217__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__8140__auto__ = (((_ == null))?null:_);
var m__8141__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__8140__auto__)]);
if(!((m__8141__auto__ == null))){
return m__8141__auto__.call(null,_);
} else {
var m__8141__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__8141__auto____$1 == null))){
return m__8141__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__8140__auto__ = (((m == null))?null:m);
var m__8141__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__8140__auto__)]);
if(!((m__8141__auto__ == null))){
return m__8141__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__8141__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__8141__auto____$1 == null))){
return m__8141__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__8140__auto__ = (((m == null))?null:m);
var m__8141__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__8140__auto__)]);
if(!((m__8141__auto__ == null))){
return m__8141__auto__.call(null,m,ch);
} else {
var m__8141__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__8141__auto____$1 == null))){
return m__8141__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__8140__auto__ = (((m == null))?null:m);
var m__8141__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__8140__auto__)]);
if(!((m__8141__auto__ == null))){
return m__8141__auto__.call(null,m);
} else {
var m__8141__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__8141__auto____$1 == null))){
return m__8141__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async11814 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11814 = (function (ch,cs,meta11815){
this.ch = ch;
this.cs = cs;
this.meta11815 = meta11815;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async11814.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_11816,meta11815__$1){
var self__ = this;
var _11816__$1 = this;
return (new cljs.core.async.t_cljs$core$async11814(self__.ch,self__.cs,meta11815__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async11814.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_11816){
var self__ = this;
var _11816__$1 = this;
return self__.meta11815;
});})(cs))
;

cljs.core.async.t_cljs$core$async11814.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async11814.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async11814.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async11814.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async11814.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async11814.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async11814.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta11815","meta11815",-1563609513,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async11814.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11814.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11814";

cljs.core.async.t_cljs$core$async11814.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__8078__auto__,writer__8079__auto__,opt__8080__auto__){
return cljs.core._write.call(null,writer__8079__auto__,"cljs.core.async/t_cljs$core$async11814");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async11814 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async11814(ch__$1,cs__$1,meta11815){
return (new cljs.core.async.t_cljs$core$async11814(ch__$1,cs__$1,meta11815));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async11814(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11217__auto___12036 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto___12036,cs,m,dchan,dctr,done){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto___12036,cs,m,dchan,dctr,done){
return (function (state_11951){
var state_val_11952 = (state_11951[(1)]);
if((state_val_11952 === (7))){
var inst_11947 = (state_11951[(2)]);
var state_11951__$1 = state_11951;
var statearr_11953_12037 = state_11951__$1;
(statearr_11953_12037[(2)] = inst_11947);

(statearr_11953_12037[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (20))){
var inst_11850 = (state_11951[(7)]);
var inst_11862 = cljs.core.first.call(null,inst_11850);
var inst_11863 = cljs.core.nth.call(null,inst_11862,(0),null);
var inst_11864 = cljs.core.nth.call(null,inst_11862,(1),null);
var state_11951__$1 = (function (){var statearr_11954 = state_11951;
(statearr_11954[(8)] = inst_11863);

return statearr_11954;
})();
if(cljs.core.truth_(inst_11864)){
var statearr_11955_12038 = state_11951__$1;
(statearr_11955_12038[(1)] = (22));

} else {
var statearr_11956_12039 = state_11951__$1;
(statearr_11956_12039[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (27))){
var inst_11899 = (state_11951[(9)]);
var inst_11819 = (state_11951[(10)]);
var inst_11894 = (state_11951[(11)]);
var inst_11892 = (state_11951[(12)]);
var inst_11899__$1 = cljs.core._nth.call(null,inst_11892,inst_11894);
var inst_11900 = cljs.core.async.put_BANG_.call(null,inst_11899__$1,inst_11819,done);
var state_11951__$1 = (function (){var statearr_11957 = state_11951;
(statearr_11957[(9)] = inst_11899__$1);

return statearr_11957;
})();
if(cljs.core.truth_(inst_11900)){
var statearr_11958_12040 = state_11951__$1;
(statearr_11958_12040[(1)] = (30));

} else {
var statearr_11959_12041 = state_11951__$1;
(statearr_11959_12041[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (1))){
var state_11951__$1 = state_11951;
var statearr_11960_12042 = state_11951__$1;
(statearr_11960_12042[(2)] = null);

(statearr_11960_12042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (24))){
var inst_11850 = (state_11951[(7)]);
var inst_11869 = (state_11951[(2)]);
var inst_11870 = cljs.core.next.call(null,inst_11850);
var inst_11828 = inst_11870;
var inst_11829 = null;
var inst_11830 = (0);
var inst_11831 = (0);
var state_11951__$1 = (function (){var statearr_11961 = state_11951;
(statearr_11961[(13)] = inst_11828);

(statearr_11961[(14)] = inst_11829);

(statearr_11961[(15)] = inst_11869);

(statearr_11961[(16)] = inst_11830);

(statearr_11961[(17)] = inst_11831);

return statearr_11961;
})();
var statearr_11962_12043 = state_11951__$1;
(statearr_11962_12043[(2)] = null);

(statearr_11962_12043[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (39))){
var state_11951__$1 = state_11951;
var statearr_11966_12044 = state_11951__$1;
(statearr_11966_12044[(2)] = null);

(statearr_11966_12044[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (4))){
var inst_11819 = (state_11951[(10)]);
var inst_11819__$1 = (state_11951[(2)]);
var inst_11820 = (inst_11819__$1 == null);
var state_11951__$1 = (function (){var statearr_11967 = state_11951;
(statearr_11967[(10)] = inst_11819__$1);

return statearr_11967;
})();
if(cljs.core.truth_(inst_11820)){
var statearr_11968_12045 = state_11951__$1;
(statearr_11968_12045[(1)] = (5));

} else {
var statearr_11969_12046 = state_11951__$1;
(statearr_11969_12046[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (15))){
var inst_11828 = (state_11951[(13)]);
var inst_11829 = (state_11951[(14)]);
var inst_11830 = (state_11951[(16)]);
var inst_11831 = (state_11951[(17)]);
var inst_11846 = (state_11951[(2)]);
var inst_11847 = (inst_11831 + (1));
var tmp11963 = inst_11828;
var tmp11964 = inst_11829;
var tmp11965 = inst_11830;
var inst_11828__$1 = tmp11963;
var inst_11829__$1 = tmp11964;
var inst_11830__$1 = tmp11965;
var inst_11831__$1 = inst_11847;
var state_11951__$1 = (function (){var statearr_11970 = state_11951;
(statearr_11970[(13)] = inst_11828__$1);

(statearr_11970[(14)] = inst_11829__$1);

(statearr_11970[(18)] = inst_11846);

(statearr_11970[(16)] = inst_11830__$1);

(statearr_11970[(17)] = inst_11831__$1);

return statearr_11970;
})();
var statearr_11971_12047 = state_11951__$1;
(statearr_11971_12047[(2)] = null);

(statearr_11971_12047[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (21))){
var inst_11873 = (state_11951[(2)]);
var state_11951__$1 = state_11951;
var statearr_11975_12048 = state_11951__$1;
(statearr_11975_12048[(2)] = inst_11873);

(statearr_11975_12048[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (31))){
var inst_11899 = (state_11951[(9)]);
var inst_11903 = done.call(null,null);
var inst_11904 = cljs.core.async.untap_STAR_.call(null,m,inst_11899);
var state_11951__$1 = (function (){var statearr_11976 = state_11951;
(statearr_11976[(19)] = inst_11903);

return statearr_11976;
})();
var statearr_11977_12049 = state_11951__$1;
(statearr_11977_12049[(2)] = inst_11904);

(statearr_11977_12049[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (32))){
var inst_11891 = (state_11951[(20)]);
var inst_11893 = (state_11951[(21)]);
var inst_11894 = (state_11951[(11)]);
var inst_11892 = (state_11951[(12)]);
var inst_11906 = (state_11951[(2)]);
var inst_11907 = (inst_11894 + (1));
var tmp11972 = inst_11891;
var tmp11973 = inst_11893;
var tmp11974 = inst_11892;
var inst_11891__$1 = tmp11972;
var inst_11892__$1 = tmp11974;
var inst_11893__$1 = tmp11973;
var inst_11894__$1 = inst_11907;
var state_11951__$1 = (function (){var statearr_11978 = state_11951;
(statearr_11978[(20)] = inst_11891__$1);

(statearr_11978[(21)] = inst_11893__$1);

(statearr_11978[(22)] = inst_11906);

(statearr_11978[(11)] = inst_11894__$1);

(statearr_11978[(12)] = inst_11892__$1);

return statearr_11978;
})();
var statearr_11979_12050 = state_11951__$1;
(statearr_11979_12050[(2)] = null);

(statearr_11979_12050[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (40))){
var inst_11919 = (state_11951[(23)]);
var inst_11923 = done.call(null,null);
var inst_11924 = cljs.core.async.untap_STAR_.call(null,m,inst_11919);
var state_11951__$1 = (function (){var statearr_11980 = state_11951;
(statearr_11980[(24)] = inst_11923);

return statearr_11980;
})();
var statearr_11981_12051 = state_11951__$1;
(statearr_11981_12051[(2)] = inst_11924);

(statearr_11981_12051[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (33))){
var inst_11910 = (state_11951[(25)]);
var inst_11912 = cljs.core.chunked_seq_QMARK_.call(null,inst_11910);
var state_11951__$1 = state_11951;
if(inst_11912){
var statearr_11982_12052 = state_11951__$1;
(statearr_11982_12052[(1)] = (36));

} else {
var statearr_11983_12053 = state_11951__$1;
(statearr_11983_12053[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (13))){
var inst_11840 = (state_11951[(26)]);
var inst_11843 = cljs.core.async.close_BANG_.call(null,inst_11840);
var state_11951__$1 = state_11951;
var statearr_11984_12054 = state_11951__$1;
(statearr_11984_12054[(2)] = inst_11843);

(statearr_11984_12054[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (22))){
var inst_11863 = (state_11951[(8)]);
var inst_11866 = cljs.core.async.close_BANG_.call(null,inst_11863);
var state_11951__$1 = state_11951;
var statearr_11985_12055 = state_11951__$1;
(statearr_11985_12055[(2)] = inst_11866);

(statearr_11985_12055[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (36))){
var inst_11910 = (state_11951[(25)]);
var inst_11914 = cljs.core.chunk_first.call(null,inst_11910);
var inst_11915 = cljs.core.chunk_rest.call(null,inst_11910);
var inst_11916 = cljs.core.count.call(null,inst_11914);
var inst_11891 = inst_11915;
var inst_11892 = inst_11914;
var inst_11893 = inst_11916;
var inst_11894 = (0);
var state_11951__$1 = (function (){var statearr_11986 = state_11951;
(statearr_11986[(20)] = inst_11891);

(statearr_11986[(21)] = inst_11893);

(statearr_11986[(11)] = inst_11894);

(statearr_11986[(12)] = inst_11892);

return statearr_11986;
})();
var statearr_11987_12056 = state_11951__$1;
(statearr_11987_12056[(2)] = null);

(statearr_11987_12056[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (41))){
var inst_11910 = (state_11951[(25)]);
var inst_11926 = (state_11951[(2)]);
var inst_11927 = cljs.core.next.call(null,inst_11910);
var inst_11891 = inst_11927;
var inst_11892 = null;
var inst_11893 = (0);
var inst_11894 = (0);
var state_11951__$1 = (function (){var statearr_11988 = state_11951;
(statearr_11988[(20)] = inst_11891);

(statearr_11988[(27)] = inst_11926);

(statearr_11988[(21)] = inst_11893);

(statearr_11988[(11)] = inst_11894);

(statearr_11988[(12)] = inst_11892);

return statearr_11988;
})();
var statearr_11989_12057 = state_11951__$1;
(statearr_11989_12057[(2)] = null);

(statearr_11989_12057[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (43))){
var state_11951__$1 = state_11951;
var statearr_11990_12058 = state_11951__$1;
(statearr_11990_12058[(2)] = null);

(statearr_11990_12058[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (29))){
var inst_11935 = (state_11951[(2)]);
var state_11951__$1 = state_11951;
var statearr_11991_12059 = state_11951__$1;
(statearr_11991_12059[(2)] = inst_11935);

(statearr_11991_12059[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (44))){
var inst_11944 = (state_11951[(2)]);
var state_11951__$1 = (function (){var statearr_11992 = state_11951;
(statearr_11992[(28)] = inst_11944);

return statearr_11992;
})();
var statearr_11993_12060 = state_11951__$1;
(statearr_11993_12060[(2)] = null);

(statearr_11993_12060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (6))){
var inst_11883 = (state_11951[(29)]);
var inst_11882 = cljs.core.deref.call(null,cs);
var inst_11883__$1 = cljs.core.keys.call(null,inst_11882);
var inst_11884 = cljs.core.count.call(null,inst_11883__$1);
var inst_11885 = cljs.core.reset_BANG_.call(null,dctr,inst_11884);
var inst_11890 = cljs.core.seq.call(null,inst_11883__$1);
var inst_11891 = inst_11890;
var inst_11892 = null;
var inst_11893 = (0);
var inst_11894 = (0);
var state_11951__$1 = (function (){var statearr_11994 = state_11951;
(statearr_11994[(20)] = inst_11891);

(statearr_11994[(30)] = inst_11885);

(statearr_11994[(21)] = inst_11893);

(statearr_11994[(29)] = inst_11883__$1);

(statearr_11994[(11)] = inst_11894);

(statearr_11994[(12)] = inst_11892);

return statearr_11994;
})();
var statearr_11995_12061 = state_11951__$1;
(statearr_11995_12061[(2)] = null);

(statearr_11995_12061[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (28))){
var inst_11891 = (state_11951[(20)]);
var inst_11910 = (state_11951[(25)]);
var inst_11910__$1 = cljs.core.seq.call(null,inst_11891);
var state_11951__$1 = (function (){var statearr_11996 = state_11951;
(statearr_11996[(25)] = inst_11910__$1);

return statearr_11996;
})();
if(inst_11910__$1){
var statearr_11997_12062 = state_11951__$1;
(statearr_11997_12062[(1)] = (33));

} else {
var statearr_11998_12063 = state_11951__$1;
(statearr_11998_12063[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (25))){
var inst_11893 = (state_11951[(21)]);
var inst_11894 = (state_11951[(11)]);
var inst_11896 = (inst_11894 < inst_11893);
var inst_11897 = inst_11896;
var state_11951__$1 = state_11951;
if(cljs.core.truth_(inst_11897)){
var statearr_11999_12064 = state_11951__$1;
(statearr_11999_12064[(1)] = (27));

} else {
var statearr_12000_12065 = state_11951__$1;
(statearr_12000_12065[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (34))){
var state_11951__$1 = state_11951;
var statearr_12001_12066 = state_11951__$1;
(statearr_12001_12066[(2)] = null);

(statearr_12001_12066[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (17))){
var state_11951__$1 = state_11951;
var statearr_12002_12067 = state_11951__$1;
(statearr_12002_12067[(2)] = null);

(statearr_12002_12067[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (3))){
var inst_11949 = (state_11951[(2)]);
var state_11951__$1 = state_11951;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11951__$1,inst_11949);
} else {
if((state_val_11952 === (12))){
var inst_11878 = (state_11951[(2)]);
var state_11951__$1 = state_11951;
var statearr_12003_12068 = state_11951__$1;
(statearr_12003_12068[(2)] = inst_11878);

(statearr_12003_12068[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (2))){
var state_11951__$1 = state_11951;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11951__$1,(4),ch);
} else {
if((state_val_11952 === (23))){
var state_11951__$1 = state_11951;
var statearr_12004_12069 = state_11951__$1;
(statearr_12004_12069[(2)] = null);

(statearr_12004_12069[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (35))){
var inst_11933 = (state_11951[(2)]);
var state_11951__$1 = state_11951;
var statearr_12005_12070 = state_11951__$1;
(statearr_12005_12070[(2)] = inst_11933);

(statearr_12005_12070[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (19))){
var inst_11850 = (state_11951[(7)]);
var inst_11854 = cljs.core.chunk_first.call(null,inst_11850);
var inst_11855 = cljs.core.chunk_rest.call(null,inst_11850);
var inst_11856 = cljs.core.count.call(null,inst_11854);
var inst_11828 = inst_11855;
var inst_11829 = inst_11854;
var inst_11830 = inst_11856;
var inst_11831 = (0);
var state_11951__$1 = (function (){var statearr_12006 = state_11951;
(statearr_12006[(13)] = inst_11828);

(statearr_12006[(14)] = inst_11829);

(statearr_12006[(16)] = inst_11830);

(statearr_12006[(17)] = inst_11831);

return statearr_12006;
})();
var statearr_12007_12071 = state_11951__$1;
(statearr_12007_12071[(2)] = null);

(statearr_12007_12071[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (11))){
var inst_11850 = (state_11951[(7)]);
var inst_11828 = (state_11951[(13)]);
var inst_11850__$1 = cljs.core.seq.call(null,inst_11828);
var state_11951__$1 = (function (){var statearr_12008 = state_11951;
(statearr_12008[(7)] = inst_11850__$1);

return statearr_12008;
})();
if(inst_11850__$1){
var statearr_12009_12072 = state_11951__$1;
(statearr_12009_12072[(1)] = (16));

} else {
var statearr_12010_12073 = state_11951__$1;
(statearr_12010_12073[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (9))){
var inst_11880 = (state_11951[(2)]);
var state_11951__$1 = state_11951;
var statearr_12011_12074 = state_11951__$1;
(statearr_12011_12074[(2)] = inst_11880);

(statearr_12011_12074[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (5))){
var inst_11826 = cljs.core.deref.call(null,cs);
var inst_11827 = cljs.core.seq.call(null,inst_11826);
var inst_11828 = inst_11827;
var inst_11829 = null;
var inst_11830 = (0);
var inst_11831 = (0);
var state_11951__$1 = (function (){var statearr_12012 = state_11951;
(statearr_12012[(13)] = inst_11828);

(statearr_12012[(14)] = inst_11829);

(statearr_12012[(16)] = inst_11830);

(statearr_12012[(17)] = inst_11831);

return statearr_12012;
})();
var statearr_12013_12075 = state_11951__$1;
(statearr_12013_12075[(2)] = null);

(statearr_12013_12075[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (14))){
var state_11951__$1 = state_11951;
var statearr_12014_12076 = state_11951__$1;
(statearr_12014_12076[(2)] = null);

(statearr_12014_12076[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (45))){
var inst_11941 = (state_11951[(2)]);
var state_11951__$1 = state_11951;
var statearr_12015_12077 = state_11951__$1;
(statearr_12015_12077[(2)] = inst_11941);

(statearr_12015_12077[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (26))){
var inst_11883 = (state_11951[(29)]);
var inst_11937 = (state_11951[(2)]);
var inst_11938 = cljs.core.seq.call(null,inst_11883);
var state_11951__$1 = (function (){var statearr_12016 = state_11951;
(statearr_12016[(31)] = inst_11937);

return statearr_12016;
})();
if(inst_11938){
var statearr_12017_12078 = state_11951__$1;
(statearr_12017_12078[(1)] = (42));

} else {
var statearr_12018_12079 = state_11951__$1;
(statearr_12018_12079[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (16))){
var inst_11850 = (state_11951[(7)]);
var inst_11852 = cljs.core.chunked_seq_QMARK_.call(null,inst_11850);
var state_11951__$1 = state_11951;
if(inst_11852){
var statearr_12019_12080 = state_11951__$1;
(statearr_12019_12080[(1)] = (19));

} else {
var statearr_12020_12081 = state_11951__$1;
(statearr_12020_12081[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (38))){
var inst_11930 = (state_11951[(2)]);
var state_11951__$1 = state_11951;
var statearr_12021_12082 = state_11951__$1;
(statearr_12021_12082[(2)] = inst_11930);

(statearr_12021_12082[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (30))){
var state_11951__$1 = state_11951;
var statearr_12022_12083 = state_11951__$1;
(statearr_12022_12083[(2)] = null);

(statearr_12022_12083[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (10))){
var inst_11829 = (state_11951[(14)]);
var inst_11831 = (state_11951[(17)]);
var inst_11839 = cljs.core._nth.call(null,inst_11829,inst_11831);
var inst_11840 = cljs.core.nth.call(null,inst_11839,(0),null);
var inst_11841 = cljs.core.nth.call(null,inst_11839,(1),null);
var state_11951__$1 = (function (){var statearr_12023 = state_11951;
(statearr_12023[(26)] = inst_11840);

return statearr_12023;
})();
if(cljs.core.truth_(inst_11841)){
var statearr_12024_12084 = state_11951__$1;
(statearr_12024_12084[(1)] = (13));

} else {
var statearr_12025_12085 = state_11951__$1;
(statearr_12025_12085[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (18))){
var inst_11876 = (state_11951[(2)]);
var state_11951__$1 = state_11951;
var statearr_12026_12086 = state_11951__$1;
(statearr_12026_12086[(2)] = inst_11876);

(statearr_12026_12086[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (42))){
var state_11951__$1 = state_11951;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11951__$1,(45),dchan);
} else {
if((state_val_11952 === (37))){
var inst_11819 = (state_11951[(10)]);
var inst_11919 = (state_11951[(23)]);
var inst_11910 = (state_11951[(25)]);
var inst_11919__$1 = cljs.core.first.call(null,inst_11910);
var inst_11920 = cljs.core.async.put_BANG_.call(null,inst_11919__$1,inst_11819,done);
var state_11951__$1 = (function (){var statearr_12027 = state_11951;
(statearr_12027[(23)] = inst_11919__$1);

return statearr_12027;
})();
if(cljs.core.truth_(inst_11920)){
var statearr_12028_12087 = state_11951__$1;
(statearr_12028_12087[(1)] = (39));

} else {
var statearr_12029_12088 = state_11951__$1;
(statearr_12029_12088[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11952 === (8))){
var inst_11830 = (state_11951[(16)]);
var inst_11831 = (state_11951[(17)]);
var inst_11833 = (inst_11831 < inst_11830);
var inst_11834 = inst_11833;
var state_11951__$1 = state_11951;
if(cljs.core.truth_(inst_11834)){
var statearr_12030_12089 = state_11951__$1;
(statearr_12030_12089[(1)] = (10));

} else {
var statearr_12031_12090 = state_11951__$1;
(statearr_12031_12090[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11217__auto___12036,cs,m,dchan,dctr,done))
;
return ((function (switch__11127__auto__,c__11217__auto___12036,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__11128__auto__ = null;
var cljs$core$async$mult_$_state_machine__11128__auto____0 = (function (){
var statearr_12032 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12032[(0)] = cljs$core$async$mult_$_state_machine__11128__auto__);

(statearr_12032[(1)] = (1));

return statearr_12032;
});
var cljs$core$async$mult_$_state_machine__11128__auto____1 = (function (state_11951){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_11951);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e12033){if((e12033 instanceof Object)){
var ex__11131__auto__ = e12033;
var statearr_12034_12091 = state_11951;
(statearr_12034_12091[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11951);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12033;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12092 = state_11951;
state_11951 = G__12092;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11128__auto__ = function(state_11951){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11128__auto____1.call(this,state_11951);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11128__auto____0;
cljs$core$async$mult_$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11128__auto____1;
return cljs$core$async$mult_$_state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto___12036,cs,m,dchan,dctr,done))
})();
var state__11219__auto__ = (function (){var statearr_12035 = f__11218__auto__.call(null);
(statearr_12035[(6)] = c__11217__auto___12036);

return statearr_12035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto___12036,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__12094 = arguments.length;
switch (G__12094) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__8140__auto__ = (((m == null))?null:m);
var m__8141__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__8140__auto__)]);
if(!((m__8141__auto__ == null))){
return m__8141__auto__.call(null,m,ch);
} else {
var m__8141__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__8141__auto____$1 == null))){
return m__8141__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__8140__auto__ = (((m == null))?null:m);
var m__8141__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__8140__auto__)]);
if(!((m__8141__auto__ == null))){
return m__8141__auto__.call(null,m,ch);
} else {
var m__8141__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__8141__auto____$1 == null))){
return m__8141__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__8140__auto__ = (((m == null))?null:m);
var m__8141__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__8140__auto__)]);
if(!((m__8141__auto__ == null))){
return m__8141__auto__.call(null,m);
} else {
var m__8141__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__8141__auto____$1 == null))){
return m__8141__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__8140__auto__ = (((m == null))?null:m);
var m__8141__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__8140__auto__)]);
if(!((m__8141__auto__ == null))){
return m__8141__auto__.call(null,m,state_map);
} else {
var m__8141__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__8141__auto____$1 == null))){
return m__8141__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__8140__auto__ = (((m == null))?null:m);
var m__8141__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__8140__auto__)]);
if(!((m__8141__auto__ == null))){
return m__8141__auto__.call(null,m,mode);
} else {
var m__8141__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__8141__auto____$1 == null))){
return m__8141__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__8693__auto__ = [];
var len__8686__auto___12106 = arguments.length;
var i__8687__auto___12107 = (0);
while(true){
if((i__8687__auto___12107 < len__8686__auto___12106)){
args__8693__auto__.push((arguments[i__8687__auto___12107]));

var G__12108 = (i__8687__auto___12107 + (1));
i__8687__auto___12107 = G__12108;
continue;
} else {
}
break;
}

var argseq__8694__auto__ = ((((3) < args__8693__auto__.length))?(new cljs.core.IndexedSeq(args__8693__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8694__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__12100){
var map__12101 = p__12100;
var map__12101__$1 = ((((!((map__12101 == null)))?((((map__12101.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12101.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12101):map__12101);
var opts = map__12101__$1;
var statearr_12103_12109 = state;
(statearr_12103_12109[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts.call(null,((function (map__12101,map__12101__$1,opts){
return (function (val){
var statearr_12104_12110 = state;
(statearr_12104_12110[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__12101,map__12101__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_12105_12111 = state;
(statearr_12105_12111[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq12096){
var G__12097 = cljs.core.first.call(null,seq12096);
var seq12096__$1 = cljs.core.next.call(null,seq12096);
var G__12098 = cljs.core.first.call(null,seq12096__$1);
var seq12096__$2 = cljs.core.next.call(null,seq12096__$1);
var G__12099 = cljs.core.first.call(null,seq12096__$2);
var seq12096__$3 = cljs.core.next.call(null,seq12096__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__12097,G__12098,G__12099,seq12096__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12112 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12112 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta12113){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta12113 = meta12113;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async12112.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12114,meta12113__$1){
var self__ = this;
var _12114__$1 = this;
return (new cljs.core.async.t_cljs$core$async12112(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta12113__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12112.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_12114){
var self__ = this;
var _12114__$1 = this;
return self__.meta12113;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12112.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12112.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12112.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12112.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12112.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12112.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12112.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12112.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12112.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta12113","meta12113",-1241836331,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async12112.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12112.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12112";

cljs.core.async.t_cljs$core$async12112.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__8078__auto__,writer__8079__auto__,opt__8080__auto__){
return cljs.core._write.call(null,writer__8079__auto__,"cljs.core.async/t_cljs$core$async12112");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async12112 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async12112(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta12113){
return (new cljs.core.async.t_cljs$core$async12112(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta12113));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async12112(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11217__auto___12276 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto___12276,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto___12276,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_12216){
var state_val_12217 = (state_12216[(1)]);
if((state_val_12217 === (7))){
var inst_12131 = (state_12216[(2)]);
var state_12216__$1 = state_12216;
var statearr_12218_12277 = state_12216__$1;
(statearr_12218_12277[(2)] = inst_12131);

(statearr_12218_12277[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (20))){
var inst_12143 = (state_12216[(7)]);
var state_12216__$1 = state_12216;
var statearr_12219_12278 = state_12216__$1;
(statearr_12219_12278[(2)] = inst_12143);

(statearr_12219_12278[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (27))){
var state_12216__$1 = state_12216;
var statearr_12220_12279 = state_12216__$1;
(statearr_12220_12279[(2)] = null);

(statearr_12220_12279[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (1))){
var inst_12118 = (state_12216[(8)]);
var inst_12118__$1 = calc_state.call(null);
var inst_12120 = (inst_12118__$1 == null);
var inst_12121 = cljs.core.not.call(null,inst_12120);
var state_12216__$1 = (function (){var statearr_12221 = state_12216;
(statearr_12221[(8)] = inst_12118__$1);

return statearr_12221;
})();
if(inst_12121){
var statearr_12222_12280 = state_12216__$1;
(statearr_12222_12280[(1)] = (2));

} else {
var statearr_12223_12281 = state_12216__$1;
(statearr_12223_12281[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (24))){
var inst_12190 = (state_12216[(9)]);
var inst_12167 = (state_12216[(10)]);
var inst_12176 = (state_12216[(11)]);
var inst_12190__$1 = inst_12167.call(null,inst_12176);
var state_12216__$1 = (function (){var statearr_12224 = state_12216;
(statearr_12224[(9)] = inst_12190__$1);

return statearr_12224;
})();
if(cljs.core.truth_(inst_12190__$1)){
var statearr_12225_12282 = state_12216__$1;
(statearr_12225_12282[(1)] = (29));

} else {
var statearr_12226_12283 = state_12216__$1;
(statearr_12226_12283[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (4))){
var inst_12134 = (state_12216[(2)]);
var state_12216__$1 = state_12216;
if(cljs.core.truth_(inst_12134)){
var statearr_12227_12284 = state_12216__$1;
(statearr_12227_12284[(1)] = (8));

} else {
var statearr_12228_12285 = state_12216__$1;
(statearr_12228_12285[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (15))){
var inst_12161 = (state_12216[(2)]);
var state_12216__$1 = state_12216;
if(cljs.core.truth_(inst_12161)){
var statearr_12229_12286 = state_12216__$1;
(statearr_12229_12286[(1)] = (19));

} else {
var statearr_12230_12287 = state_12216__$1;
(statearr_12230_12287[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (21))){
var inst_12166 = (state_12216[(12)]);
var inst_12166__$1 = (state_12216[(2)]);
var inst_12167 = cljs.core.get.call(null,inst_12166__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12168 = cljs.core.get.call(null,inst_12166__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12169 = cljs.core.get.call(null,inst_12166__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12216__$1 = (function (){var statearr_12231 = state_12216;
(statearr_12231[(13)] = inst_12168);

(statearr_12231[(10)] = inst_12167);

(statearr_12231[(12)] = inst_12166__$1);

return statearr_12231;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_12216__$1,(22),inst_12169);
} else {
if((state_val_12217 === (31))){
var inst_12198 = (state_12216[(2)]);
var state_12216__$1 = state_12216;
if(cljs.core.truth_(inst_12198)){
var statearr_12232_12288 = state_12216__$1;
(statearr_12232_12288[(1)] = (32));

} else {
var statearr_12233_12289 = state_12216__$1;
(statearr_12233_12289[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (32))){
var inst_12175 = (state_12216[(14)]);
var state_12216__$1 = state_12216;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12216__$1,(35),out,inst_12175);
} else {
if((state_val_12217 === (33))){
var inst_12166 = (state_12216[(12)]);
var inst_12143 = inst_12166;
var state_12216__$1 = (function (){var statearr_12234 = state_12216;
(statearr_12234[(7)] = inst_12143);

return statearr_12234;
})();
var statearr_12235_12290 = state_12216__$1;
(statearr_12235_12290[(2)] = null);

(statearr_12235_12290[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (13))){
var inst_12143 = (state_12216[(7)]);
var inst_12150 = inst_12143.cljs$lang$protocol_mask$partition0$;
var inst_12151 = (inst_12150 & (64));
var inst_12152 = inst_12143.cljs$core$ISeq$;
var inst_12153 = (cljs.core.PROTOCOL_SENTINEL === inst_12152);
var inst_12154 = (inst_12151) || (inst_12153);
var state_12216__$1 = state_12216;
if(cljs.core.truth_(inst_12154)){
var statearr_12236_12291 = state_12216__$1;
(statearr_12236_12291[(1)] = (16));

} else {
var statearr_12237_12292 = state_12216__$1;
(statearr_12237_12292[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (22))){
var inst_12175 = (state_12216[(14)]);
var inst_12176 = (state_12216[(11)]);
var inst_12174 = (state_12216[(2)]);
var inst_12175__$1 = cljs.core.nth.call(null,inst_12174,(0),null);
var inst_12176__$1 = cljs.core.nth.call(null,inst_12174,(1),null);
var inst_12177 = (inst_12175__$1 == null);
var inst_12178 = cljs.core._EQ_.call(null,inst_12176__$1,change);
var inst_12179 = (inst_12177) || (inst_12178);
var state_12216__$1 = (function (){var statearr_12238 = state_12216;
(statearr_12238[(14)] = inst_12175__$1);

(statearr_12238[(11)] = inst_12176__$1);

return statearr_12238;
})();
if(cljs.core.truth_(inst_12179)){
var statearr_12239_12293 = state_12216__$1;
(statearr_12239_12293[(1)] = (23));

} else {
var statearr_12240_12294 = state_12216__$1;
(statearr_12240_12294[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (36))){
var inst_12166 = (state_12216[(12)]);
var inst_12143 = inst_12166;
var state_12216__$1 = (function (){var statearr_12241 = state_12216;
(statearr_12241[(7)] = inst_12143);

return statearr_12241;
})();
var statearr_12242_12295 = state_12216__$1;
(statearr_12242_12295[(2)] = null);

(statearr_12242_12295[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (29))){
var inst_12190 = (state_12216[(9)]);
var state_12216__$1 = state_12216;
var statearr_12243_12296 = state_12216__$1;
(statearr_12243_12296[(2)] = inst_12190);

(statearr_12243_12296[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (6))){
var state_12216__$1 = state_12216;
var statearr_12244_12297 = state_12216__$1;
(statearr_12244_12297[(2)] = false);

(statearr_12244_12297[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (28))){
var inst_12186 = (state_12216[(2)]);
var inst_12187 = calc_state.call(null);
var inst_12143 = inst_12187;
var state_12216__$1 = (function (){var statearr_12245 = state_12216;
(statearr_12245[(15)] = inst_12186);

(statearr_12245[(7)] = inst_12143);

return statearr_12245;
})();
var statearr_12246_12298 = state_12216__$1;
(statearr_12246_12298[(2)] = null);

(statearr_12246_12298[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (25))){
var inst_12212 = (state_12216[(2)]);
var state_12216__$1 = state_12216;
var statearr_12247_12299 = state_12216__$1;
(statearr_12247_12299[(2)] = inst_12212);

(statearr_12247_12299[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (34))){
var inst_12210 = (state_12216[(2)]);
var state_12216__$1 = state_12216;
var statearr_12248_12300 = state_12216__$1;
(statearr_12248_12300[(2)] = inst_12210);

(statearr_12248_12300[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (17))){
var state_12216__$1 = state_12216;
var statearr_12249_12301 = state_12216__$1;
(statearr_12249_12301[(2)] = false);

(statearr_12249_12301[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (3))){
var state_12216__$1 = state_12216;
var statearr_12250_12302 = state_12216__$1;
(statearr_12250_12302[(2)] = false);

(statearr_12250_12302[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (12))){
var inst_12214 = (state_12216[(2)]);
var state_12216__$1 = state_12216;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12216__$1,inst_12214);
} else {
if((state_val_12217 === (2))){
var inst_12118 = (state_12216[(8)]);
var inst_12123 = inst_12118.cljs$lang$protocol_mask$partition0$;
var inst_12124 = (inst_12123 & (64));
var inst_12125 = inst_12118.cljs$core$ISeq$;
var inst_12126 = (cljs.core.PROTOCOL_SENTINEL === inst_12125);
var inst_12127 = (inst_12124) || (inst_12126);
var state_12216__$1 = state_12216;
if(cljs.core.truth_(inst_12127)){
var statearr_12251_12303 = state_12216__$1;
(statearr_12251_12303[(1)] = (5));

} else {
var statearr_12252_12304 = state_12216__$1;
(statearr_12252_12304[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (23))){
var inst_12175 = (state_12216[(14)]);
var inst_12181 = (inst_12175 == null);
var state_12216__$1 = state_12216;
if(cljs.core.truth_(inst_12181)){
var statearr_12253_12305 = state_12216__$1;
(statearr_12253_12305[(1)] = (26));

} else {
var statearr_12254_12306 = state_12216__$1;
(statearr_12254_12306[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (35))){
var inst_12201 = (state_12216[(2)]);
var state_12216__$1 = state_12216;
if(cljs.core.truth_(inst_12201)){
var statearr_12255_12307 = state_12216__$1;
(statearr_12255_12307[(1)] = (36));

} else {
var statearr_12256_12308 = state_12216__$1;
(statearr_12256_12308[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (19))){
var inst_12143 = (state_12216[(7)]);
var inst_12163 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12143);
var state_12216__$1 = state_12216;
var statearr_12257_12309 = state_12216__$1;
(statearr_12257_12309[(2)] = inst_12163);

(statearr_12257_12309[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (11))){
var inst_12143 = (state_12216[(7)]);
var inst_12147 = (inst_12143 == null);
var inst_12148 = cljs.core.not.call(null,inst_12147);
var state_12216__$1 = state_12216;
if(inst_12148){
var statearr_12258_12310 = state_12216__$1;
(statearr_12258_12310[(1)] = (13));

} else {
var statearr_12259_12311 = state_12216__$1;
(statearr_12259_12311[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (9))){
var inst_12118 = (state_12216[(8)]);
var state_12216__$1 = state_12216;
var statearr_12260_12312 = state_12216__$1;
(statearr_12260_12312[(2)] = inst_12118);

(statearr_12260_12312[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (5))){
var state_12216__$1 = state_12216;
var statearr_12261_12313 = state_12216__$1;
(statearr_12261_12313[(2)] = true);

(statearr_12261_12313[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (14))){
var state_12216__$1 = state_12216;
var statearr_12262_12314 = state_12216__$1;
(statearr_12262_12314[(2)] = false);

(statearr_12262_12314[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (26))){
var inst_12176 = (state_12216[(11)]);
var inst_12183 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_12176);
var state_12216__$1 = state_12216;
var statearr_12263_12315 = state_12216__$1;
(statearr_12263_12315[(2)] = inst_12183);

(statearr_12263_12315[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (16))){
var state_12216__$1 = state_12216;
var statearr_12264_12316 = state_12216__$1;
(statearr_12264_12316[(2)] = true);

(statearr_12264_12316[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (38))){
var inst_12206 = (state_12216[(2)]);
var state_12216__$1 = state_12216;
var statearr_12265_12317 = state_12216__$1;
(statearr_12265_12317[(2)] = inst_12206);

(statearr_12265_12317[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (30))){
var inst_12168 = (state_12216[(13)]);
var inst_12167 = (state_12216[(10)]);
var inst_12176 = (state_12216[(11)]);
var inst_12193 = cljs.core.empty_QMARK_.call(null,inst_12167);
var inst_12194 = inst_12168.call(null,inst_12176);
var inst_12195 = cljs.core.not.call(null,inst_12194);
var inst_12196 = (inst_12193) && (inst_12195);
var state_12216__$1 = state_12216;
var statearr_12266_12318 = state_12216__$1;
(statearr_12266_12318[(2)] = inst_12196);

(statearr_12266_12318[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (10))){
var inst_12118 = (state_12216[(8)]);
var inst_12139 = (state_12216[(2)]);
var inst_12140 = cljs.core.get.call(null,inst_12139,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12141 = cljs.core.get.call(null,inst_12139,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12142 = cljs.core.get.call(null,inst_12139,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12143 = inst_12118;
var state_12216__$1 = (function (){var statearr_12267 = state_12216;
(statearr_12267[(7)] = inst_12143);

(statearr_12267[(16)] = inst_12142);

(statearr_12267[(17)] = inst_12141);

(statearr_12267[(18)] = inst_12140);

return statearr_12267;
})();
var statearr_12268_12319 = state_12216__$1;
(statearr_12268_12319[(2)] = null);

(statearr_12268_12319[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (18))){
var inst_12158 = (state_12216[(2)]);
var state_12216__$1 = state_12216;
var statearr_12269_12320 = state_12216__$1;
(statearr_12269_12320[(2)] = inst_12158);

(statearr_12269_12320[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (37))){
var state_12216__$1 = state_12216;
var statearr_12270_12321 = state_12216__$1;
(statearr_12270_12321[(2)] = null);

(statearr_12270_12321[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12217 === (8))){
var inst_12118 = (state_12216[(8)]);
var inst_12136 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12118);
var state_12216__$1 = state_12216;
var statearr_12271_12322 = state_12216__$1;
(statearr_12271_12322[(2)] = inst_12136);

(statearr_12271_12322[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11217__auto___12276,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__11127__auto__,c__11217__auto___12276,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__11128__auto__ = null;
var cljs$core$async$mix_$_state_machine__11128__auto____0 = (function (){
var statearr_12272 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12272[(0)] = cljs$core$async$mix_$_state_machine__11128__auto__);

(statearr_12272[(1)] = (1));

return statearr_12272;
});
var cljs$core$async$mix_$_state_machine__11128__auto____1 = (function (state_12216){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_12216);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e12273){if((e12273 instanceof Object)){
var ex__11131__auto__ = e12273;
var statearr_12274_12323 = state_12216;
(statearr_12274_12323[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12216);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12273;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12324 = state_12216;
state_12216 = G__12324;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11128__auto__ = function(state_12216){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11128__auto____1.call(this,state_12216);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11128__auto____0;
cljs$core$async$mix_$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11128__auto____1;
return cljs$core$async$mix_$_state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto___12276,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11219__auto__ = (function (){var statearr_12275 = f__11218__auto__.call(null);
(statearr_12275[(6)] = c__11217__auto___12276);

return statearr_12275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto___12276,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__8140__auto__ = (((p == null))?null:p);
var m__8141__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__8140__auto__)]);
if(!((m__8141__auto__ == null))){
return m__8141__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__8141__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__8141__auto____$1 == null))){
return m__8141__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__8140__auto__ = (((p == null))?null:p);
var m__8141__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__8140__auto__)]);
if(!((m__8141__auto__ == null))){
return m__8141__auto__.call(null,p,v,ch);
} else {
var m__8141__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__8141__auto____$1 == null))){
return m__8141__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__12326 = arguments.length;
switch (G__12326) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__8140__auto__ = (((p == null))?null:p);
var m__8141__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8140__auto__)]);
if(!((m__8141__auto__ == null))){
return m__8141__auto__.call(null,p);
} else {
var m__8141__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8141__auto____$1 == null))){
return m__8141__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__8140__auto__ = (((p == null))?null:p);
var m__8141__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8140__auto__)]);
if(!((m__8141__auto__ == null))){
return m__8141__auto__.call(null,p,v);
} else {
var m__8141__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8141__auto____$1 == null))){
return m__8141__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__12330 = arguments.length;
switch (G__12330) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__7407__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__7407__auto__)){
return or__7407__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__7407__auto__,mults){
return (function (p1__12328_SHARP_){
if(cljs.core.truth_(p1__12328_SHARP_.call(null,topic))){
return p1__12328_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12328_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__7407__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async12331 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12331 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12332){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12332 = meta12332;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async12331.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_12333,meta12332__$1){
var self__ = this;
var _12333__$1 = this;
return (new cljs.core.async.t_cljs$core$async12331(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12332__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12331.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_12333){
var self__ = this;
var _12333__$1 = this;
return self__.meta12332;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12331.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12331.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12331.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12331.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12331.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12331.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12331.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12331.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12332","meta12332",-1712896917,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async12331.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12331.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12331";

cljs.core.async.t_cljs$core$async12331.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__8078__auto__,writer__8079__auto__,opt__8080__auto__){
return cljs.core._write.call(null,writer__8079__auto__,"cljs.core.async/t_cljs$core$async12331");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async12331 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async12331(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12332){
return (new cljs.core.async.t_cljs$core$async12331(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12332));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async12331(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11217__auto___12451 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto___12451,mults,ensure_mult,p){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto___12451,mults,ensure_mult,p){
return (function (state_12405){
var state_val_12406 = (state_12405[(1)]);
if((state_val_12406 === (7))){
var inst_12401 = (state_12405[(2)]);
var state_12405__$1 = state_12405;
var statearr_12407_12452 = state_12405__$1;
(statearr_12407_12452[(2)] = inst_12401);

(statearr_12407_12452[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (20))){
var state_12405__$1 = state_12405;
var statearr_12408_12453 = state_12405__$1;
(statearr_12408_12453[(2)] = null);

(statearr_12408_12453[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (1))){
var state_12405__$1 = state_12405;
var statearr_12409_12454 = state_12405__$1;
(statearr_12409_12454[(2)] = null);

(statearr_12409_12454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (24))){
var inst_12384 = (state_12405[(7)]);
var inst_12393 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12384);
var state_12405__$1 = state_12405;
var statearr_12410_12455 = state_12405__$1;
(statearr_12410_12455[(2)] = inst_12393);

(statearr_12410_12455[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (4))){
var inst_12336 = (state_12405[(8)]);
var inst_12336__$1 = (state_12405[(2)]);
var inst_12337 = (inst_12336__$1 == null);
var state_12405__$1 = (function (){var statearr_12411 = state_12405;
(statearr_12411[(8)] = inst_12336__$1);

return statearr_12411;
})();
if(cljs.core.truth_(inst_12337)){
var statearr_12412_12456 = state_12405__$1;
(statearr_12412_12456[(1)] = (5));

} else {
var statearr_12413_12457 = state_12405__$1;
(statearr_12413_12457[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (15))){
var inst_12378 = (state_12405[(2)]);
var state_12405__$1 = state_12405;
var statearr_12414_12458 = state_12405__$1;
(statearr_12414_12458[(2)] = inst_12378);

(statearr_12414_12458[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (21))){
var inst_12398 = (state_12405[(2)]);
var state_12405__$1 = (function (){var statearr_12415 = state_12405;
(statearr_12415[(9)] = inst_12398);

return statearr_12415;
})();
var statearr_12416_12459 = state_12405__$1;
(statearr_12416_12459[(2)] = null);

(statearr_12416_12459[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (13))){
var inst_12360 = (state_12405[(10)]);
var inst_12362 = cljs.core.chunked_seq_QMARK_.call(null,inst_12360);
var state_12405__$1 = state_12405;
if(inst_12362){
var statearr_12417_12460 = state_12405__$1;
(statearr_12417_12460[(1)] = (16));

} else {
var statearr_12418_12461 = state_12405__$1;
(statearr_12418_12461[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (22))){
var inst_12390 = (state_12405[(2)]);
var state_12405__$1 = state_12405;
if(cljs.core.truth_(inst_12390)){
var statearr_12419_12462 = state_12405__$1;
(statearr_12419_12462[(1)] = (23));

} else {
var statearr_12420_12463 = state_12405__$1;
(statearr_12420_12463[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (6))){
var inst_12386 = (state_12405[(11)]);
var inst_12384 = (state_12405[(7)]);
var inst_12336 = (state_12405[(8)]);
var inst_12384__$1 = topic_fn.call(null,inst_12336);
var inst_12385 = cljs.core.deref.call(null,mults);
var inst_12386__$1 = cljs.core.get.call(null,inst_12385,inst_12384__$1);
var state_12405__$1 = (function (){var statearr_12421 = state_12405;
(statearr_12421[(11)] = inst_12386__$1);

(statearr_12421[(7)] = inst_12384__$1);

return statearr_12421;
})();
if(cljs.core.truth_(inst_12386__$1)){
var statearr_12422_12464 = state_12405__$1;
(statearr_12422_12464[(1)] = (19));

} else {
var statearr_12423_12465 = state_12405__$1;
(statearr_12423_12465[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (25))){
var inst_12395 = (state_12405[(2)]);
var state_12405__$1 = state_12405;
var statearr_12424_12466 = state_12405__$1;
(statearr_12424_12466[(2)] = inst_12395);

(statearr_12424_12466[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (17))){
var inst_12360 = (state_12405[(10)]);
var inst_12369 = cljs.core.first.call(null,inst_12360);
var inst_12370 = cljs.core.async.muxch_STAR_.call(null,inst_12369);
var inst_12371 = cljs.core.async.close_BANG_.call(null,inst_12370);
var inst_12372 = cljs.core.next.call(null,inst_12360);
var inst_12346 = inst_12372;
var inst_12347 = null;
var inst_12348 = (0);
var inst_12349 = (0);
var state_12405__$1 = (function (){var statearr_12425 = state_12405;
(statearr_12425[(12)] = inst_12346);

(statearr_12425[(13)] = inst_12348);

(statearr_12425[(14)] = inst_12349);

(statearr_12425[(15)] = inst_12347);

(statearr_12425[(16)] = inst_12371);

return statearr_12425;
})();
var statearr_12426_12467 = state_12405__$1;
(statearr_12426_12467[(2)] = null);

(statearr_12426_12467[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (3))){
var inst_12403 = (state_12405[(2)]);
var state_12405__$1 = state_12405;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12405__$1,inst_12403);
} else {
if((state_val_12406 === (12))){
var inst_12380 = (state_12405[(2)]);
var state_12405__$1 = state_12405;
var statearr_12427_12468 = state_12405__$1;
(statearr_12427_12468[(2)] = inst_12380);

(statearr_12427_12468[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (2))){
var state_12405__$1 = state_12405;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12405__$1,(4),ch);
} else {
if((state_val_12406 === (23))){
var state_12405__$1 = state_12405;
var statearr_12428_12469 = state_12405__$1;
(statearr_12428_12469[(2)] = null);

(statearr_12428_12469[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (19))){
var inst_12386 = (state_12405[(11)]);
var inst_12336 = (state_12405[(8)]);
var inst_12388 = cljs.core.async.muxch_STAR_.call(null,inst_12386);
var state_12405__$1 = state_12405;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12405__$1,(22),inst_12388,inst_12336);
} else {
if((state_val_12406 === (11))){
var inst_12346 = (state_12405[(12)]);
var inst_12360 = (state_12405[(10)]);
var inst_12360__$1 = cljs.core.seq.call(null,inst_12346);
var state_12405__$1 = (function (){var statearr_12429 = state_12405;
(statearr_12429[(10)] = inst_12360__$1);

return statearr_12429;
})();
if(inst_12360__$1){
var statearr_12430_12470 = state_12405__$1;
(statearr_12430_12470[(1)] = (13));

} else {
var statearr_12431_12471 = state_12405__$1;
(statearr_12431_12471[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (9))){
var inst_12382 = (state_12405[(2)]);
var state_12405__$1 = state_12405;
var statearr_12432_12472 = state_12405__$1;
(statearr_12432_12472[(2)] = inst_12382);

(statearr_12432_12472[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (5))){
var inst_12343 = cljs.core.deref.call(null,mults);
var inst_12344 = cljs.core.vals.call(null,inst_12343);
var inst_12345 = cljs.core.seq.call(null,inst_12344);
var inst_12346 = inst_12345;
var inst_12347 = null;
var inst_12348 = (0);
var inst_12349 = (0);
var state_12405__$1 = (function (){var statearr_12433 = state_12405;
(statearr_12433[(12)] = inst_12346);

(statearr_12433[(13)] = inst_12348);

(statearr_12433[(14)] = inst_12349);

(statearr_12433[(15)] = inst_12347);

return statearr_12433;
})();
var statearr_12434_12473 = state_12405__$1;
(statearr_12434_12473[(2)] = null);

(statearr_12434_12473[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (14))){
var state_12405__$1 = state_12405;
var statearr_12438_12474 = state_12405__$1;
(statearr_12438_12474[(2)] = null);

(statearr_12438_12474[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (16))){
var inst_12360 = (state_12405[(10)]);
var inst_12364 = cljs.core.chunk_first.call(null,inst_12360);
var inst_12365 = cljs.core.chunk_rest.call(null,inst_12360);
var inst_12366 = cljs.core.count.call(null,inst_12364);
var inst_12346 = inst_12365;
var inst_12347 = inst_12364;
var inst_12348 = inst_12366;
var inst_12349 = (0);
var state_12405__$1 = (function (){var statearr_12439 = state_12405;
(statearr_12439[(12)] = inst_12346);

(statearr_12439[(13)] = inst_12348);

(statearr_12439[(14)] = inst_12349);

(statearr_12439[(15)] = inst_12347);

return statearr_12439;
})();
var statearr_12440_12475 = state_12405__$1;
(statearr_12440_12475[(2)] = null);

(statearr_12440_12475[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (10))){
var inst_12346 = (state_12405[(12)]);
var inst_12348 = (state_12405[(13)]);
var inst_12349 = (state_12405[(14)]);
var inst_12347 = (state_12405[(15)]);
var inst_12354 = cljs.core._nth.call(null,inst_12347,inst_12349);
var inst_12355 = cljs.core.async.muxch_STAR_.call(null,inst_12354);
var inst_12356 = cljs.core.async.close_BANG_.call(null,inst_12355);
var inst_12357 = (inst_12349 + (1));
var tmp12435 = inst_12346;
var tmp12436 = inst_12348;
var tmp12437 = inst_12347;
var inst_12346__$1 = tmp12435;
var inst_12347__$1 = tmp12437;
var inst_12348__$1 = tmp12436;
var inst_12349__$1 = inst_12357;
var state_12405__$1 = (function (){var statearr_12441 = state_12405;
(statearr_12441[(17)] = inst_12356);

(statearr_12441[(12)] = inst_12346__$1);

(statearr_12441[(13)] = inst_12348__$1);

(statearr_12441[(14)] = inst_12349__$1);

(statearr_12441[(15)] = inst_12347__$1);

return statearr_12441;
})();
var statearr_12442_12476 = state_12405__$1;
(statearr_12442_12476[(2)] = null);

(statearr_12442_12476[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (18))){
var inst_12375 = (state_12405[(2)]);
var state_12405__$1 = state_12405;
var statearr_12443_12477 = state_12405__$1;
(statearr_12443_12477[(2)] = inst_12375);

(statearr_12443_12477[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12406 === (8))){
var inst_12348 = (state_12405[(13)]);
var inst_12349 = (state_12405[(14)]);
var inst_12351 = (inst_12349 < inst_12348);
var inst_12352 = inst_12351;
var state_12405__$1 = state_12405;
if(cljs.core.truth_(inst_12352)){
var statearr_12444_12478 = state_12405__$1;
(statearr_12444_12478[(1)] = (10));

} else {
var statearr_12445_12479 = state_12405__$1;
(statearr_12445_12479[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11217__auto___12451,mults,ensure_mult,p))
;
return ((function (switch__11127__auto__,c__11217__auto___12451,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__11128__auto__ = null;
var cljs$core$async$state_machine__11128__auto____0 = (function (){
var statearr_12446 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12446[(0)] = cljs$core$async$state_machine__11128__auto__);

(statearr_12446[(1)] = (1));

return statearr_12446;
});
var cljs$core$async$state_machine__11128__auto____1 = (function (state_12405){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_12405);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e12447){if((e12447 instanceof Object)){
var ex__11131__auto__ = e12447;
var statearr_12448_12480 = state_12405;
(statearr_12448_12480[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12405);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12447;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12481 = state_12405;
state_12405 = G__12481;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$state_machine__11128__auto__ = function(state_12405){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11128__auto____1.call(this,state_12405);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11128__auto____0;
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11128__auto____1;
return cljs$core$async$state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto___12451,mults,ensure_mult,p))
})();
var state__11219__auto__ = (function (){var statearr_12449 = f__11218__auto__.call(null);
(statearr_12449[(6)] = c__11217__auto___12451);

return statearr_12449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto___12451,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__12483 = arguments.length;
switch (G__12483) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__12486 = arguments.length;
switch (G__12486) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__12489 = arguments.length;
switch (G__12489) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11217__auto___12556 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto___12556,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto___12556,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_12528){
var state_val_12529 = (state_12528[(1)]);
if((state_val_12529 === (7))){
var state_12528__$1 = state_12528;
var statearr_12530_12557 = state_12528__$1;
(statearr_12530_12557[(2)] = null);

(statearr_12530_12557[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12529 === (1))){
var state_12528__$1 = state_12528;
var statearr_12531_12558 = state_12528__$1;
(statearr_12531_12558[(2)] = null);

(statearr_12531_12558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12529 === (4))){
var inst_12492 = (state_12528[(7)]);
var inst_12494 = (inst_12492 < cnt);
var state_12528__$1 = state_12528;
if(cljs.core.truth_(inst_12494)){
var statearr_12532_12559 = state_12528__$1;
(statearr_12532_12559[(1)] = (6));

} else {
var statearr_12533_12560 = state_12528__$1;
(statearr_12533_12560[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12529 === (15))){
var inst_12524 = (state_12528[(2)]);
var state_12528__$1 = state_12528;
var statearr_12534_12561 = state_12528__$1;
(statearr_12534_12561[(2)] = inst_12524);

(statearr_12534_12561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12529 === (13))){
var inst_12517 = cljs.core.async.close_BANG_.call(null,out);
var state_12528__$1 = state_12528;
var statearr_12535_12562 = state_12528__$1;
(statearr_12535_12562[(2)] = inst_12517);

(statearr_12535_12562[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12529 === (6))){
var state_12528__$1 = state_12528;
var statearr_12536_12563 = state_12528__$1;
(statearr_12536_12563[(2)] = null);

(statearr_12536_12563[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12529 === (3))){
var inst_12526 = (state_12528[(2)]);
var state_12528__$1 = state_12528;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12528__$1,inst_12526);
} else {
if((state_val_12529 === (12))){
var inst_12514 = (state_12528[(8)]);
var inst_12514__$1 = (state_12528[(2)]);
var inst_12515 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_12514__$1);
var state_12528__$1 = (function (){var statearr_12537 = state_12528;
(statearr_12537[(8)] = inst_12514__$1);

return statearr_12537;
})();
if(cljs.core.truth_(inst_12515)){
var statearr_12538_12564 = state_12528__$1;
(statearr_12538_12564[(1)] = (13));

} else {
var statearr_12539_12565 = state_12528__$1;
(statearr_12539_12565[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12529 === (2))){
var inst_12491 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_12492 = (0);
var state_12528__$1 = (function (){var statearr_12540 = state_12528;
(statearr_12540[(9)] = inst_12491);

(statearr_12540[(7)] = inst_12492);

return statearr_12540;
})();
var statearr_12541_12566 = state_12528__$1;
(statearr_12541_12566[(2)] = null);

(statearr_12541_12566[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12529 === (11))){
var inst_12492 = (state_12528[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_12528,(10),Object,null,(9));
var inst_12501 = chs__$1.call(null,inst_12492);
var inst_12502 = done.call(null,inst_12492);
var inst_12503 = cljs.core.async.take_BANG_.call(null,inst_12501,inst_12502);
var state_12528__$1 = state_12528;
var statearr_12542_12567 = state_12528__$1;
(statearr_12542_12567[(2)] = inst_12503);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12528__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12529 === (9))){
var inst_12492 = (state_12528[(7)]);
var inst_12505 = (state_12528[(2)]);
var inst_12506 = (inst_12492 + (1));
var inst_12492__$1 = inst_12506;
var state_12528__$1 = (function (){var statearr_12543 = state_12528;
(statearr_12543[(10)] = inst_12505);

(statearr_12543[(7)] = inst_12492__$1);

return statearr_12543;
})();
var statearr_12544_12568 = state_12528__$1;
(statearr_12544_12568[(2)] = null);

(statearr_12544_12568[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12529 === (5))){
var inst_12512 = (state_12528[(2)]);
var state_12528__$1 = (function (){var statearr_12545 = state_12528;
(statearr_12545[(11)] = inst_12512);

return statearr_12545;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12528__$1,(12),dchan);
} else {
if((state_val_12529 === (14))){
var inst_12514 = (state_12528[(8)]);
var inst_12519 = cljs.core.apply.call(null,f,inst_12514);
var state_12528__$1 = state_12528;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12528__$1,(16),out,inst_12519);
} else {
if((state_val_12529 === (16))){
var inst_12521 = (state_12528[(2)]);
var state_12528__$1 = (function (){var statearr_12546 = state_12528;
(statearr_12546[(12)] = inst_12521);

return statearr_12546;
})();
var statearr_12547_12569 = state_12528__$1;
(statearr_12547_12569[(2)] = null);

(statearr_12547_12569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12529 === (10))){
var inst_12496 = (state_12528[(2)]);
var inst_12497 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_12528__$1 = (function (){var statearr_12548 = state_12528;
(statearr_12548[(13)] = inst_12496);

return statearr_12548;
})();
var statearr_12549_12570 = state_12528__$1;
(statearr_12549_12570[(2)] = inst_12497);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12528__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12529 === (8))){
var inst_12510 = (state_12528[(2)]);
var state_12528__$1 = state_12528;
var statearr_12550_12571 = state_12528__$1;
(statearr_12550_12571[(2)] = inst_12510);

(statearr_12550_12571[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11217__auto___12556,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__11127__auto__,c__11217__auto___12556,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__11128__auto__ = null;
var cljs$core$async$state_machine__11128__auto____0 = (function (){
var statearr_12551 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12551[(0)] = cljs$core$async$state_machine__11128__auto__);

(statearr_12551[(1)] = (1));

return statearr_12551;
});
var cljs$core$async$state_machine__11128__auto____1 = (function (state_12528){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_12528);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e12552){if((e12552 instanceof Object)){
var ex__11131__auto__ = e12552;
var statearr_12553_12572 = state_12528;
(statearr_12553_12572[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12528);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12552;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12573 = state_12528;
state_12528 = G__12573;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$state_machine__11128__auto__ = function(state_12528){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11128__auto____1.call(this,state_12528);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11128__auto____0;
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11128__auto____1;
return cljs$core$async$state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto___12556,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11219__auto__ = (function (){var statearr_12554 = f__11218__auto__.call(null);
(statearr_12554[(6)] = c__11217__auto___12556);

return statearr_12554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto___12556,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__12576 = arguments.length;
switch (G__12576) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11217__auto___12630 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto___12630,out){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto___12630,out){
return (function (state_12608){
var state_val_12609 = (state_12608[(1)]);
if((state_val_12609 === (7))){
var inst_12587 = (state_12608[(7)]);
var inst_12588 = (state_12608[(8)]);
var inst_12587__$1 = (state_12608[(2)]);
var inst_12588__$1 = cljs.core.nth.call(null,inst_12587__$1,(0),null);
var inst_12589 = cljs.core.nth.call(null,inst_12587__$1,(1),null);
var inst_12590 = (inst_12588__$1 == null);
var state_12608__$1 = (function (){var statearr_12610 = state_12608;
(statearr_12610[(7)] = inst_12587__$1);

(statearr_12610[(8)] = inst_12588__$1);

(statearr_12610[(9)] = inst_12589);

return statearr_12610;
})();
if(cljs.core.truth_(inst_12590)){
var statearr_12611_12631 = state_12608__$1;
(statearr_12611_12631[(1)] = (8));

} else {
var statearr_12612_12632 = state_12608__$1;
(statearr_12612_12632[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12609 === (1))){
var inst_12577 = cljs.core.vec.call(null,chs);
var inst_12578 = inst_12577;
var state_12608__$1 = (function (){var statearr_12613 = state_12608;
(statearr_12613[(10)] = inst_12578);

return statearr_12613;
})();
var statearr_12614_12633 = state_12608__$1;
(statearr_12614_12633[(2)] = null);

(statearr_12614_12633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12609 === (4))){
var inst_12578 = (state_12608[(10)]);
var state_12608__$1 = state_12608;
return cljs.core.async.ioc_alts_BANG_.call(null,state_12608__$1,(7),inst_12578);
} else {
if((state_val_12609 === (6))){
var inst_12604 = (state_12608[(2)]);
var state_12608__$1 = state_12608;
var statearr_12615_12634 = state_12608__$1;
(statearr_12615_12634[(2)] = inst_12604);

(statearr_12615_12634[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12609 === (3))){
var inst_12606 = (state_12608[(2)]);
var state_12608__$1 = state_12608;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12608__$1,inst_12606);
} else {
if((state_val_12609 === (2))){
var inst_12578 = (state_12608[(10)]);
var inst_12580 = cljs.core.count.call(null,inst_12578);
var inst_12581 = (inst_12580 > (0));
var state_12608__$1 = state_12608;
if(cljs.core.truth_(inst_12581)){
var statearr_12617_12635 = state_12608__$1;
(statearr_12617_12635[(1)] = (4));

} else {
var statearr_12618_12636 = state_12608__$1;
(statearr_12618_12636[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12609 === (11))){
var inst_12578 = (state_12608[(10)]);
var inst_12597 = (state_12608[(2)]);
var tmp12616 = inst_12578;
var inst_12578__$1 = tmp12616;
var state_12608__$1 = (function (){var statearr_12619 = state_12608;
(statearr_12619[(11)] = inst_12597);

(statearr_12619[(10)] = inst_12578__$1);

return statearr_12619;
})();
var statearr_12620_12637 = state_12608__$1;
(statearr_12620_12637[(2)] = null);

(statearr_12620_12637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12609 === (9))){
var inst_12588 = (state_12608[(8)]);
var state_12608__$1 = state_12608;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12608__$1,(11),out,inst_12588);
} else {
if((state_val_12609 === (5))){
var inst_12602 = cljs.core.async.close_BANG_.call(null,out);
var state_12608__$1 = state_12608;
var statearr_12621_12638 = state_12608__$1;
(statearr_12621_12638[(2)] = inst_12602);

(statearr_12621_12638[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12609 === (10))){
var inst_12600 = (state_12608[(2)]);
var state_12608__$1 = state_12608;
var statearr_12622_12639 = state_12608__$1;
(statearr_12622_12639[(2)] = inst_12600);

(statearr_12622_12639[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12609 === (8))){
var inst_12587 = (state_12608[(7)]);
var inst_12588 = (state_12608[(8)]);
var inst_12578 = (state_12608[(10)]);
var inst_12589 = (state_12608[(9)]);
var inst_12592 = (function (){var cs = inst_12578;
var vec__12583 = inst_12587;
var v = inst_12588;
var c = inst_12589;
return ((function (cs,vec__12583,v,c,inst_12587,inst_12588,inst_12578,inst_12589,state_val_12609,c__11217__auto___12630,out){
return (function (p1__12574_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__12574_SHARP_);
});
;})(cs,vec__12583,v,c,inst_12587,inst_12588,inst_12578,inst_12589,state_val_12609,c__11217__auto___12630,out))
})();
var inst_12593 = cljs.core.filterv.call(null,inst_12592,inst_12578);
var inst_12578__$1 = inst_12593;
var state_12608__$1 = (function (){var statearr_12623 = state_12608;
(statearr_12623[(10)] = inst_12578__$1);

return statearr_12623;
})();
var statearr_12624_12640 = state_12608__$1;
(statearr_12624_12640[(2)] = null);

(statearr_12624_12640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11217__auto___12630,out))
;
return ((function (switch__11127__auto__,c__11217__auto___12630,out){
return (function() {
var cljs$core$async$state_machine__11128__auto__ = null;
var cljs$core$async$state_machine__11128__auto____0 = (function (){
var statearr_12625 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12625[(0)] = cljs$core$async$state_machine__11128__auto__);

(statearr_12625[(1)] = (1));

return statearr_12625;
});
var cljs$core$async$state_machine__11128__auto____1 = (function (state_12608){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_12608);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e12626){if((e12626 instanceof Object)){
var ex__11131__auto__ = e12626;
var statearr_12627_12641 = state_12608;
(statearr_12627_12641[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12608);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12626;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12642 = state_12608;
state_12608 = G__12642;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$state_machine__11128__auto__ = function(state_12608){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11128__auto____1.call(this,state_12608);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11128__auto____0;
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11128__auto____1;
return cljs$core$async$state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto___12630,out))
})();
var state__11219__auto__ = (function (){var statearr_12628 = f__11218__auto__.call(null);
(statearr_12628[(6)] = c__11217__auto___12630);

return statearr_12628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto___12630,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__12644 = arguments.length;
switch (G__12644) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11217__auto___12689 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto___12689,out){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto___12689,out){
return (function (state_12668){
var state_val_12669 = (state_12668[(1)]);
if((state_val_12669 === (7))){
var inst_12650 = (state_12668[(7)]);
var inst_12650__$1 = (state_12668[(2)]);
var inst_12651 = (inst_12650__$1 == null);
var inst_12652 = cljs.core.not.call(null,inst_12651);
var state_12668__$1 = (function (){var statearr_12670 = state_12668;
(statearr_12670[(7)] = inst_12650__$1);

return statearr_12670;
})();
if(inst_12652){
var statearr_12671_12690 = state_12668__$1;
(statearr_12671_12690[(1)] = (8));

} else {
var statearr_12672_12691 = state_12668__$1;
(statearr_12672_12691[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12669 === (1))){
var inst_12645 = (0);
var state_12668__$1 = (function (){var statearr_12673 = state_12668;
(statearr_12673[(8)] = inst_12645);

return statearr_12673;
})();
var statearr_12674_12692 = state_12668__$1;
(statearr_12674_12692[(2)] = null);

(statearr_12674_12692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12669 === (4))){
var state_12668__$1 = state_12668;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12668__$1,(7),ch);
} else {
if((state_val_12669 === (6))){
var inst_12663 = (state_12668[(2)]);
var state_12668__$1 = state_12668;
var statearr_12675_12693 = state_12668__$1;
(statearr_12675_12693[(2)] = inst_12663);

(statearr_12675_12693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12669 === (3))){
var inst_12665 = (state_12668[(2)]);
var inst_12666 = cljs.core.async.close_BANG_.call(null,out);
var state_12668__$1 = (function (){var statearr_12676 = state_12668;
(statearr_12676[(9)] = inst_12665);

return statearr_12676;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12668__$1,inst_12666);
} else {
if((state_val_12669 === (2))){
var inst_12645 = (state_12668[(8)]);
var inst_12647 = (inst_12645 < n);
var state_12668__$1 = state_12668;
if(cljs.core.truth_(inst_12647)){
var statearr_12677_12694 = state_12668__$1;
(statearr_12677_12694[(1)] = (4));

} else {
var statearr_12678_12695 = state_12668__$1;
(statearr_12678_12695[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12669 === (11))){
var inst_12645 = (state_12668[(8)]);
var inst_12655 = (state_12668[(2)]);
var inst_12656 = (inst_12645 + (1));
var inst_12645__$1 = inst_12656;
var state_12668__$1 = (function (){var statearr_12679 = state_12668;
(statearr_12679[(8)] = inst_12645__$1);

(statearr_12679[(10)] = inst_12655);

return statearr_12679;
})();
var statearr_12680_12696 = state_12668__$1;
(statearr_12680_12696[(2)] = null);

(statearr_12680_12696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12669 === (9))){
var state_12668__$1 = state_12668;
var statearr_12681_12697 = state_12668__$1;
(statearr_12681_12697[(2)] = null);

(statearr_12681_12697[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12669 === (5))){
var state_12668__$1 = state_12668;
var statearr_12682_12698 = state_12668__$1;
(statearr_12682_12698[(2)] = null);

(statearr_12682_12698[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12669 === (10))){
var inst_12660 = (state_12668[(2)]);
var state_12668__$1 = state_12668;
var statearr_12683_12699 = state_12668__$1;
(statearr_12683_12699[(2)] = inst_12660);

(statearr_12683_12699[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12669 === (8))){
var inst_12650 = (state_12668[(7)]);
var state_12668__$1 = state_12668;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12668__$1,(11),out,inst_12650);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11217__auto___12689,out))
;
return ((function (switch__11127__auto__,c__11217__auto___12689,out){
return (function() {
var cljs$core$async$state_machine__11128__auto__ = null;
var cljs$core$async$state_machine__11128__auto____0 = (function (){
var statearr_12684 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12684[(0)] = cljs$core$async$state_machine__11128__auto__);

(statearr_12684[(1)] = (1));

return statearr_12684;
});
var cljs$core$async$state_machine__11128__auto____1 = (function (state_12668){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_12668);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e12685){if((e12685 instanceof Object)){
var ex__11131__auto__ = e12685;
var statearr_12686_12700 = state_12668;
(statearr_12686_12700[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12668);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12685;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12701 = state_12668;
state_12668 = G__12701;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$state_machine__11128__auto__ = function(state_12668){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11128__auto____1.call(this,state_12668);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11128__auto____0;
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11128__auto____1;
return cljs$core$async$state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto___12689,out))
})();
var state__11219__auto__ = (function (){var statearr_12687 = f__11218__auto__.call(null);
(statearr_12687[(6)] = c__11217__auto___12689);

return statearr_12687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto___12689,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async12703 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12703 = (function (f,ch,meta12704){
this.f = f;
this.ch = ch;
this.meta12704 = meta12704;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async12703.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12705,meta12704__$1){
var self__ = this;
var _12705__$1 = this;
return (new cljs.core.async.t_cljs$core$async12703(self__.f,self__.ch,meta12704__$1));
});

cljs.core.async.t_cljs$core$async12703.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12705){
var self__ = this;
var _12705__$1 = this;
return self__.meta12704;
});

cljs.core.async.t_cljs$core$async12703.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12703.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12703.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12703.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12703.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async12706 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12706 = (function (f,ch,meta12704,_,fn1,meta12707){
this.f = f;
this.ch = ch;
this.meta12704 = meta12704;
this._ = _;
this.fn1 = fn1;
this.meta12707 = meta12707;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async12706.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_12708,meta12707__$1){
var self__ = this;
var _12708__$1 = this;
return (new cljs.core.async.t_cljs$core$async12706(self__.f,self__.ch,self__.meta12704,self__._,self__.fn1,meta12707__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async12706.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_12708){
var self__ = this;
var _12708__$1 = this;
return self__.meta12707;
});})(___$1))
;

cljs.core.async.t_cljs$core$async12706.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12706.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async12706.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async12706.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__12702_SHARP_){
return f1.call(null,(((p1__12702_SHARP_ == null))?null:self__.f.call(null,p1__12702_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async12706.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12704","meta12704",2117132340,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async12703","cljs.core.async/t_cljs$core$async12703",-504641959,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta12707","meta12707",469550583,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async12706.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12706.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12706";

cljs.core.async.t_cljs$core$async12706.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__8078__auto__,writer__8079__auto__,opt__8080__auto__){
return cljs.core._write.call(null,writer__8079__auto__,"cljs.core.async/t_cljs$core$async12706");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async12706 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12706(f__$1,ch__$1,meta12704__$1,___$2,fn1__$1,meta12707){
return (new cljs.core.async.t_cljs$core$async12706(f__$1,ch__$1,meta12704__$1,___$2,fn1__$1,meta12707));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async12706(self__.f,self__.ch,self__.meta12704,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__7395__auto__ = ret;
if(cljs.core.truth_(and__7395__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__7395__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async12703.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12703.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async12703.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12704","meta12704",2117132340,null)], null);
});

cljs.core.async.t_cljs$core$async12703.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12703.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12703";

cljs.core.async.t_cljs$core$async12703.cljs$lang$ctorPrWriter = (function (this__8078__auto__,writer__8079__auto__,opt__8080__auto__){
return cljs.core._write.call(null,writer__8079__auto__,"cljs.core.async/t_cljs$core$async12703");
});

cljs.core.async.__GT_t_cljs$core$async12703 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12703(f__$1,ch__$1,meta12704){
return (new cljs.core.async.t_cljs$core$async12703(f__$1,ch__$1,meta12704));
});

}

return (new cljs.core.async.t_cljs$core$async12703(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async12709 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12709 = (function (f,ch,meta12710){
this.f = f;
this.ch = ch;
this.meta12710 = meta12710;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async12709.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12711,meta12710__$1){
var self__ = this;
var _12711__$1 = this;
return (new cljs.core.async.t_cljs$core$async12709(self__.f,self__.ch,meta12710__$1));
});

cljs.core.async.t_cljs$core$async12709.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12711){
var self__ = this;
var _12711__$1 = this;
return self__.meta12710;
});

cljs.core.async.t_cljs$core$async12709.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12709.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12709.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12709.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async12709.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12709.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async12709.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12710","meta12710",-2046805314,null)], null);
});

cljs.core.async.t_cljs$core$async12709.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12709.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12709";

cljs.core.async.t_cljs$core$async12709.cljs$lang$ctorPrWriter = (function (this__8078__auto__,writer__8079__auto__,opt__8080__auto__){
return cljs.core._write.call(null,writer__8079__auto__,"cljs.core.async/t_cljs$core$async12709");
});

cljs.core.async.__GT_t_cljs$core$async12709 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async12709(f__$1,ch__$1,meta12710){
return (new cljs.core.async.t_cljs$core$async12709(f__$1,ch__$1,meta12710));
});

}

return (new cljs.core.async.t_cljs$core$async12709(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async12712 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12712 = (function (p,ch,meta12713){
this.p = p;
this.ch = ch;
this.meta12713 = meta12713;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async12712.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12714,meta12713__$1){
var self__ = this;
var _12714__$1 = this;
return (new cljs.core.async.t_cljs$core$async12712(self__.p,self__.ch,meta12713__$1));
});

cljs.core.async.t_cljs$core$async12712.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12714){
var self__ = this;
var _12714__$1 = this;
return self__.meta12713;
});

cljs.core.async.t_cljs$core$async12712.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12712.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12712.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async12712.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12712.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async12712.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12712.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async12712.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12713","meta12713",-1772831912,null)], null);
});

cljs.core.async.t_cljs$core$async12712.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12712.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12712";

cljs.core.async.t_cljs$core$async12712.cljs$lang$ctorPrWriter = (function (this__8078__auto__,writer__8079__auto__,opt__8080__auto__){
return cljs.core._write.call(null,writer__8079__auto__,"cljs.core.async/t_cljs$core$async12712");
});

cljs.core.async.__GT_t_cljs$core$async12712 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async12712(p__$1,ch__$1,meta12713){
return (new cljs.core.async.t_cljs$core$async12712(p__$1,ch__$1,meta12713));
});

}

return (new cljs.core.async.t_cljs$core$async12712(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__12716 = arguments.length;
switch (G__12716) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11217__auto___12756 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto___12756,out){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto___12756,out){
return (function (state_12737){
var state_val_12738 = (state_12737[(1)]);
if((state_val_12738 === (7))){
var inst_12733 = (state_12737[(2)]);
var state_12737__$1 = state_12737;
var statearr_12739_12757 = state_12737__$1;
(statearr_12739_12757[(2)] = inst_12733);

(statearr_12739_12757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12738 === (1))){
var state_12737__$1 = state_12737;
var statearr_12740_12758 = state_12737__$1;
(statearr_12740_12758[(2)] = null);

(statearr_12740_12758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12738 === (4))){
var inst_12719 = (state_12737[(7)]);
var inst_12719__$1 = (state_12737[(2)]);
var inst_12720 = (inst_12719__$1 == null);
var state_12737__$1 = (function (){var statearr_12741 = state_12737;
(statearr_12741[(7)] = inst_12719__$1);

return statearr_12741;
})();
if(cljs.core.truth_(inst_12720)){
var statearr_12742_12759 = state_12737__$1;
(statearr_12742_12759[(1)] = (5));

} else {
var statearr_12743_12760 = state_12737__$1;
(statearr_12743_12760[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12738 === (6))){
var inst_12719 = (state_12737[(7)]);
var inst_12724 = p.call(null,inst_12719);
var state_12737__$1 = state_12737;
if(cljs.core.truth_(inst_12724)){
var statearr_12744_12761 = state_12737__$1;
(statearr_12744_12761[(1)] = (8));

} else {
var statearr_12745_12762 = state_12737__$1;
(statearr_12745_12762[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12738 === (3))){
var inst_12735 = (state_12737[(2)]);
var state_12737__$1 = state_12737;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12737__$1,inst_12735);
} else {
if((state_val_12738 === (2))){
var state_12737__$1 = state_12737;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12737__$1,(4),ch);
} else {
if((state_val_12738 === (11))){
var inst_12727 = (state_12737[(2)]);
var state_12737__$1 = state_12737;
var statearr_12746_12763 = state_12737__$1;
(statearr_12746_12763[(2)] = inst_12727);

(statearr_12746_12763[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12738 === (9))){
var state_12737__$1 = state_12737;
var statearr_12747_12764 = state_12737__$1;
(statearr_12747_12764[(2)] = null);

(statearr_12747_12764[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12738 === (5))){
var inst_12722 = cljs.core.async.close_BANG_.call(null,out);
var state_12737__$1 = state_12737;
var statearr_12748_12765 = state_12737__$1;
(statearr_12748_12765[(2)] = inst_12722);

(statearr_12748_12765[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12738 === (10))){
var inst_12730 = (state_12737[(2)]);
var state_12737__$1 = (function (){var statearr_12749 = state_12737;
(statearr_12749[(8)] = inst_12730);

return statearr_12749;
})();
var statearr_12750_12766 = state_12737__$1;
(statearr_12750_12766[(2)] = null);

(statearr_12750_12766[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12738 === (8))){
var inst_12719 = (state_12737[(7)]);
var state_12737__$1 = state_12737;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12737__$1,(11),out,inst_12719);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11217__auto___12756,out))
;
return ((function (switch__11127__auto__,c__11217__auto___12756,out){
return (function() {
var cljs$core$async$state_machine__11128__auto__ = null;
var cljs$core$async$state_machine__11128__auto____0 = (function (){
var statearr_12751 = [null,null,null,null,null,null,null,null,null];
(statearr_12751[(0)] = cljs$core$async$state_machine__11128__auto__);

(statearr_12751[(1)] = (1));

return statearr_12751;
});
var cljs$core$async$state_machine__11128__auto____1 = (function (state_12737){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_12737);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e12752){if((e12752 instanceof Object)){
var ex__11131__auto__ = e12752;
var statearr_12753_12767 = state_12737;
(statearr_12753_12767[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12737);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12752;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12768 = state_12737;
state_12737 = G__12768;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$state_machine__11128__auto__ = function(state_12737){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11128__auto____1.call(this,state_12737);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11128__auto____0;
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11128__auto____1;
return cljs$core$async$state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto___12756,out))
})();
var state__11219__auto__ = (function (){var statearr_12754 = f__11218__auto__.call(null);
(statearr_12754[(6)] = c__11217__auto___12756);

return statearr_12754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto___12756,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__12770 = arguments.length;
switch (G__12770) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11217__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto__){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto__){
return (function (state_12833){
var state_val_12834 = (state_12833[(1)]);
if((state_val_12834 === (7))){
var inst_12829 = (state_12833[(2)]);
var state_12833__$1 = state_12833;
var statearr_12835_12873 = state_12833__$1;
(statearr_12835_12873[(2)] = inst_12829);

(statearr_12835_12873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (20))){
var inst_12799 = (state_12833[(7)]);
var inst_12810 = (state_12833[(2)]);
var inst_12811 = cljs.core.next.call(null,inst_12799);
var inst_12785 = inst_12811;
var inst_12786 = null;
var inst_12787 = (0);
var inst_12788 = (0);
var state_12833__$1 = (function (){var statearr_12836 = state_12833;
(statearr_12836[(8)] = inst_12786);

(statearr_12836[(9)] = inst_12787);

(statearr_12836[(10)] = inst_12810);

(statearr_12836[(11)] = inst_12788);

(statearr_12836[(12)] = inst_12785);

return statearr_12836;
})();
var statearr_12837_12874 = state_12833__$1;
(statearr_12837_12874[(2)] = null);

(statearr_12837_12874[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (1))){
var state_12833__$1 = state_12833;
var statearr_12838_12875 = state_12833__$1;
(statearr_12838_12875[(2)] = null);

(statearr_12838_12875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (4))){
var inst_12774 = (state_12833[(13)]);
var inst_12774__$1 = (state_12833[(2)]);
var inst_12775 = (inst_12774__$1 == null);
var state_12833__$1 = (function (){var statearr_12839 = state_12833;
(statearr_12839[(13)] = inst_12774__$1);

return statearr_12839;
})();
if(cljs.core.truth_(inst_12775)){
var statearr_12840_12876 = state_12833__$1;
(statearr_12840_12876[(1)] = (5));

} else {
var statearr_12841_12877 = state_12833__$1;
(statearr_12841_12877[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (15))){
var state_12833__$1 = state_12833;
var statearr_12845_12878 = state_12833__$1;
(statearr_12845_12878[(2)] = null);

(statearr_12845_12878[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (21))){
var state_12833__$1 = state_12833;
var statearr_12846_12879 = state_12833__$1;
(statearr_12846_12879[(2)] = null);

(statearr_12846_12879[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (13))){
var inst_12786 = (state_12833[(8)]);
var inst_12787 = (state_12833[(9)]);
var inst_12788 = (state_12833[(11)]);
var inst_12785 = (state_12833[(12)]);
var inst_12795 = (state_12833[(2)]);
var inst_12796 = (inst_12788 + (1));
var tmp12842 = inst_12786;
var tmp12843 = inst_12787;
var tmp12844 = inst_12785;
var inst_12785__$1 = tmp12844;
var inst_12786__$1 = tmp12842;
var inst_12787__$1 = tmp12843;
var inst_12788__$1 = inst_12796;
var state_12833__$1 = (function (){var statearr_12847 = state_12833;
(statearr_12847[(8)] = inst_12786__$1);

(statearr_12847[(14)] = inst_12795);

(statearr_12847[(9)] = inst_12787__$1);

(statearr_12847[(11)] = inst_12788__$1);

(statearr_12847[(12)] = inst_12785__$1);

return statearr_12847;
})();
var statearr_12848_12880 = state_12833__$1;
(statearr_12848_12880[(2)] = null);

(statearr_12848_12880[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (22))){
var state_12833__$1 = state_12833;
var statearr_12849_12881 = state_12833__$1;
(statearr_12849_12881[(2)] = null);

(statearr_12849_12881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (6))){
var inst_12774 = (state_12833[(13)]);
var inst_12783 = f.call(null,inst_12774);
var inst_12784 = cljs.core.seq.call(null,inst_12783);
var inst_12785 = inst_12784;
var inst_12786 = null;
var inst_12787 = (0);
var inst_12788 = (0);
var state_12833__$1 = (function (){var statearr_12850 = state_12833;
(statearr_12850[(8)] = inst_12786);

(statearr_12850[(9)] = inst_12787);

(statearr_12850[(11)] = inst_12788);

(statearr_12850[(12)] = inst_12785);

return statearr_12850;
})();
var statearr_12851_12882 = state_12833__$1;
(statearr_12851_12882[(2)] = null);

(statearr_12851_12882[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (17))){
var inst_12799 = (state_12833[(7)]);
var inst_12803 = cljs.core.chunk_first.call(null,inst_12799);
var inst_12804 = cljs.core.chunk_rest.call(null,inst_12799);
var inst_12805 = cljs.core.count.call(null,inst_12803);
var inst_12785 = inst_12804;
var inst_12786 = inst_12803;
var inst_12787 = inst_12805;
var inst_12788 = (0);
var state_12833__$1 = (function (){var statearr_12852 = state_12833;
(statearr_12852[(8)] = inst_12786);

(statearr_12852[(9)] = inst_12787);

(statearr_12852[(11)] = inst_12788);

(statearr_12852[(12)] = inst_12785);

return statearr_12852;
})();
var statearr_12853_12883 = state_12833__$1;
(statearr_12853_12883[(2)] = null);

(statearr_12853_12883[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (3))){
var inst_12831 = (state_12833[(2)]);
var state_12833__$1 = state_12833;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12833__$1,inst_12831);
} else {
if((state_val_12834 === (12))){
var inst_12819 = (state_12833[(2)]);
var state_12833__$1 = state_12833;
var statearr_12854_12884 = state_12833__$1;
(statearr_12854_12884[(2)] = inst_12819);

(statearr_12854_12884[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (2))){
var state_12833__$1 = state_12833;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12833__$1,(4),in$);
} else {
if((state_val_12834 === (23))){
var inst_12827 = (state_12833[(2)]);
var state_12833__$1 = state_12833;
var statearr_12855_12885 = state_12833__$1;
(statearr_12855_12885[(2)] = inst_12827);

(statearr_12855_12885[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (19))){
var inst_12814 = (state_12833[(2)]);
var state_12833__$1 = state_12833;
var statearr_12856_12886 = state_12833__$1;
(statearr_12856_12886[(2)] = inst_12814);

(statearr_12856_12886[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (11))){
var inst_12799 = (state_12833[(7)]);
var inst_12785 = (state_12833[(12)]);
var inst_12799__$1 = cljs.core.seq.call(null,inst_12785);
var state_12833__$1 = (function (){var statearr_12857 = state_12833;
(statearr_12857[(7)] = inst_12799__$1);

return statearr_12857;
})();
if(inst_12799__$1){
var statearr_12858_12887 = state_12833__$1;
(statearr_12858_12887[(1)] = (14));

} else {
var statearr_12859_12888 = state_12833__$1;
(statearr_12859_12888[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (9))){
var inst_12821 = (state_12833[(2)]);
var inst_12822 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_12833__$1 = (function (){var statearr_12860 = state_12833;
(statearr_12860[(15)] = inst_12821);

return statearr_12860;
})();
if(cljs.core.truth_(inst_12822)){
var statearr_12861_12889 = state_12833__$1;
(statearr_12861_12889[(1)] = (21));

} else {
var statearr_12862_12890 = state_12833__$1;
(statearr_12862_12890[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (5))){
var inst_12777 = cljs.core.async.close_BANG_.call(null,out);
var state_12833__$1 = state_12833;
var statearr_12863_12891 = state_12833__$1;
(statearr_12863_12891[(2)] = inst_12777);

(statearr_12863_12891[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (14))){
var inst_12799 = (state_12833[(7)]);
var inst_12801 = cljs.core.chunked_seq_QMARK_.call(null,inst_12799);
var state_12833__$1 = state_12833;
if(inst_12801){
var statearr_12864_12892 = state_12833__$1;
(statearr_12864_12892[(1)] = (17));

} else {
var statearr_12865_12893 = state_12833__$1;
(statearr_12865_12893[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (16))){
var inst_12817 = (state_12833[(2)]);
var state_12833__$1 = state_12833;
var statearr_12866_12894 = state_12833__$1;
(statearr_12866_12894[(2)] = inst_12817);

(statearr_12866_12894[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12834 === (10))){
var inst_12786 = (state_12833[(8)]);
var inst_12788 = (state_12833[(11)]);
var inst_12793 = cljs.core._nth.call(null,inst_12786,inst_12788);
var state_12833__$1 = state_12833;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12833__$1,(13),out,inst_12793);
} else {
if((state_val_12834 === (18))){
var inst_12799 = (state_12833[(7)]);
var inst_12808 = cljs.core.first.call(null,inst_12799);
var state_12833__$1 = state_12833;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12833__$1,(20),out,inst_12808);
} else {
if((state_val_12834 === (8))){
var inst_12787 = (state_12833[(9)]);
var inst_12788 = (state_12833[(11)]);
var inst_12790 = (inst_12788 < inst_12787);
var inst_12791 = inst_12790;
var state_12833__$1 = state_12833;
if(cljs.core.truth_(inst_12791)){
var statearr_12867_12895 = state_12833__$1;
(statearr_12867_12895[(1)] = (10));

} else {
var statearr_12868_12896 = state_12833__$1;
(statearr_12868_12896[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11217__auto__))
;
return ((function (switch__11127__auto__,c__11217__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11128__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11128__auto____0 = (function (){
var statearr_12869 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12869[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11128__auto__);

(statearr_12869[(1)] = (1));

return statearr_12869;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11128__auto____1 = (function (state_12833){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_12833);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e12870){if((e12870 instanceof Object)){
var ex__11131__auto__ = e12870;
var statearr_12871_12897 = state_12833;
(statearr_12871_12897[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12833);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12870;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12898 = state_12833;
state_12833 = G__12898;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11128__auto__ = function(state_12833){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11128__auto____1.call(this,state_12833);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11128__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11128__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto__))
})();
var state__11219__auto__ = (function (){var statearr_12872 = f__11218__auto__.call(null);
(statearr_12872[(6)] = c__11217__auto__);

return statearr_12872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto__))
);

return c__11217__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__12900 = arguments.length;
switch (G__12900) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__12903 = arguments.length;
switch (G__12903) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__12906 = arguments.length;
switch (G__12906) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11217__auto___12953 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto___12953,out){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto___12953,out){
return (function (state_12930){
var state_val_12931 = (state_12930[(1)]);
if((state_val_12931 === (7))){
var inst_12925 = (state_12930[(2)]);
var state_12930__$1 = state_12930;
var statearr_12932_12954 = state_12930__$1;
(statearr_12932_12954[(2)] = inst_12925);

(statearr_12932_12954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12931 === (1))){
var inst_12907 = null;
var state_12930__$1 = (function (){var statearr_12933 = state_12930;
(statearr_12933[(7)] = inst_12907);

return statearr_12933;
})();
var statearr_12934_12955 = state_12930__$1;
(statearr_12934_12955[(2)] = null);

(statearr_12934_12955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12931 === (4))){
var inst_12910 = (state_12930[(8)]);
var inst_12910__$1 = (state_12930[(2)]);
var inst_12911 = (inst_12910__$1 == null);
var inst_12912 = cljs.core.not.call(null,inst_12911);
var state_12930__$1 = (function (){var statearr_12935 = state_12930;
(statearr_12935[(8)] = inst_12910__$1);

return statearr_12935;
})();
if(inst_12912){
var statearr_12936_12956 = state_12930__$1;
(statearr_12936_12956[(1)] = (5));

} else {
var statearr_12937_12957 = state_12930__$1;
(statearr_12937_12957[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12931 === (6))){
var state_12930__$1 = state_12930;
var statearr_12938_12958 = state_12930__$1;
(statearr_12938_12958[(2)] = null);

(statearr_12938_12958[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12931 === (3))){
var inst_12927 = (state_12930[(2)]);
var inst_12928 = cljs.core.async.close_BANG_.call(null,out);
var state_12930__$1 = (function (){var statearr_12939 = state_12930;
(statearr_12939[(9)] = inst_12927);

return statearr_12939;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12930__$1,inst_12928);
} else {
if((state_val_12931 === (2))){
var state_12930__$1 = state_12930;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12930__$1,(4),ch);
} else {
if((state_val_12931 === (11))){
var inst_12910 = (state_12930[(8)]);
var inst_12919 = (state_12930[(2)]);
var inst_12907 = inst_12910;
var state_12930__$1 = (function (){var statearr_12940 = state_12930;
(statearr_12940[(7)] = inst_12907);

(statearr_12940[(10)] = inst_12919);

return statearr_12940;
})();
var statearr_12941_12959 = state_12930__$1;
(statearr_12941_12959[(2)] = null);

(statearr_12941_12959[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12931 === (9))){
var inst_12910 = (state_12930[(8)]);
var state_12930__$1 = state_12930;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12930__$1,(11),out,inst_12910);
} else {
if((state_val_12931 === (5))){
var inst_12910 = (state_12930[(8)]);
var inst_12907 = (state_12930[(7)]);
var inst_12914 = cljs.core._EQ_.call(null,inst_12910,inst_12907);
var state_12930__$1 = state_12930;
if(inst_12914){
var statearr_12943_12960 = state_12930__$1;
(statearr_12943_12960[(1)] = (8));

} else {
var statearr_12944_12961 = state_12930__$1;
(statearr_12944_12961[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12931 === (10))){
var inst_12922 = (state_12930[(2)]);
var state_12930__$1 = state_12930;
var statearr_12945_12962 = state_12930__$1;
(statearr_12945_12962[(2)] = inst_12922);

(statearr_12945_12962[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12931 === (8))){
var inst_12907 = (state_12930[(7)]);
var tmp12942 = inst_12907;
var inst_12907__$1 = tmp12942;
var state_12930__$1 = (function (){var statearr_12946 = state_12930;
(statearr_12946[(7)] = inst_12907__$1);

return statearr_12946;
})();
var statearr_12947_12963 = state_12930__$1;
(statearr_12947_12963[(2)] = null);

(statearr_12947_12963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11217__auto___12953,out))
;
return ((function (switch__11127__auto__,c__11217__auto___12953,out){
return (function() {
var cljs$core$async$state_machine__11128__auto__ = null;
var cljs$core$async$state_machine__11128__auto____0 = (function (){
var statearr_12948 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12948[(0)] = cljs$core$async$state_machine__11128__auto__);

(statearr_12948[(1)] = (1));

return statearr_12948;
});
var cljs$core$async$state_machine__11128__auto____1 = (function (state_12930){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_12930);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e12949){if((e12949 instanceof Object)){
var ex__11131__auto__ = e12949;
var statearr_12950_12964 = state_12930;
(statearr_12950_12964[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12930);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12949;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12965 = state_12930;
state_12930 = G__12965;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$state_machine__11128__auto__ = function(state_12930){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11128__auto____1.call(this,state_12930);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11128__auto____0;
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11128__auto____1;
return cljs$core$async$state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto___12953,out))
})();
var state__11219__auto__ = (function (){var statearr_12951 = f__11218__auto__.call(null);
(statearr_12951[(6)] = c__11217__auto___12953);

return statearr_12951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto___12953,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__12967 = arguments.length;
switch (G__12967) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11217__auto___13033 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto___13033,out){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto___13033,out){
return (function (state_13005){
var state_val_13006 = (state_13005[(1)]);
if((state_val_13006 === (7))){
var inst_13001 = (state_13005[(2)]);
var state_13005__$1 = state_13005;
var statearr_13007_13034 = state_13005__$1;
(statearr_13007_13034[(2)] = inst_13001);

(statearr_13007_13034[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13006 === (1))){
var inst_12968 = (new Array(n));
var inst_12969 = inst_12968;
var inst_12970 = (0);
var state_13005__$1 = (function (){var statearr_13008 = state_13005;
(statearr_13008[(7)] = inst_12969);

(statearr_13008[(8)] = inst_12970);

return statearr_13008;
})();
var statearr_13009_13035 = state_13005__$1;
(statearr_13009_13035[(2)] = null);

(statearr_13009_13035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13006 === (4))){
var inst_12973 = (state_13005[(9)]);
var inst_12973__$1 = (state_13005[(2)]);
var inst_12974 = (inst_12973__$1 == null);
var inst_12975 = cljs.core.not.call(null,inst_12974);
var state_13005__$1 = (function (){var statearr_13010 = state_13005;
(statearr_13010[(9)] = inst_12973__$1);

return statearr_13010;
})();
if(inst_12975){
var statearr_13011_13036 = state_13005__$1;
(statearr_13011_13036[(1)] = (5));

} else {
var statearr_13012_13037 = state_13005__$1;
(statearr_13012_13037[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13006 === (15))){
var inst_12995 = (state_13005[(2)]);
var state_13005__$1 = state_13005;
var statearr_13013_13038 = state_13005__$1;
(statearr_13013_13038[(2)] = inst_12995);

(statearr_13013_13038[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13006 === (13))){
var state_13005__$1 = state_13005;
var statearr_13014_13039 = state_13005__$1;
(statearr_13014_13039[(2)] = null);

(statearr_13014_13039[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13006 === (6))){
var inst_12970 = (state_13005[(8)]);
var inst_12991 = (inst_12970 > (0));
var state_13005__$1 = state_13005;
if(cljs.core.truth_(inst_12991)){
var statearr_13015_13040 = state_13005__$1;
(statearr_13015_13040[(1)] = (12));

} else {
var statearr_13016_13041 = state_13005__$1;
(statearr_13016_13041[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13006 === (3))){
var inst_13003 = (state_13005[(2)]);
var state_13005__$1 = state_13005;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13005__$1,inst_13003);
} else {
if((state_val_13006 === (12))){
var inst_12969 = (state_13005[(7)]);
var inst_12993 = cljs.core.vec.call(null,inst_12969);
var state_13005__$1 = state_13005;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13005__$1,(15),out,inst_12993);
} else {
if((state_val_13006 === (2))){
var state_13005__$1 = state_13005;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13005__$1,(4),ch);
} else {
if((state_val_13006 === (11))){
var inst_12985 = (state_13005[(2)]);
var inst_12986 = (new Array(n));
var inst_12969 = inst_12986;
var inst_12970 = (0);
var state_13005__$1 = (function (){var statearr_13017 = state_13005;
(statearr_13017[(7)] = inst_12969);

(statearr_13017[(10)] = inst_12985);

(statearr_13017[(8)] = inst_12970);

return statearr_13017;
})();
var statearr_13018_13042 = state_13005__$1;
(statearr_13018_13042[(2)] = null);

(statearr_13018_13042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13006 === (9))){
var inst_12969 = (state_13005[(7)]);
var inst_12983 = cljs.core.vec.call(null,inst_12969);
var state_13005__$1 = state_13005;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13005__$1,(11),out,inst_12983);
} else {
if((state_val_13006 === (5))){
var inst_12969 = (state_13005[(7)]);
var inst_12973 = (state_13005[(9)]);
var inst_12978 = (state_13005[(11)]);
var inst_12970 = (state_13005[(8)]);
var inst_12977 = (inst_12969[inst_12970] = inst_12973);
var inst_12978__$1 = (inst_12970 + (1));
var inst_12979 = (inst_12978__$1 < n);
var state_13005__$1 = (function (){var statearr_13019 = state_13005;
(statearr_13019[(12)] = inst_12977);

(statearr_13019[(11)] = inst_12978__$1);

return statearr_13019;
})();
if(cljs.core.truth_(inst_12979)){
var statearr_13020_13043 = state_13005__$1;
(statearr_13020_13043[(1)] = (8));

} else {
var statearr_13021_13044 = state_13005__$1;
(statearr_13021_13044[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13006 === (14))){
var inst_12998 = (state_13005[(2)]);
var inst_12999 = cljs.core.async.close_BANG_.call(null,out);
var state_13005__$1 = (function (){var statearr_13023 = state_13005;
(statearr_13023[(13)] = inst_12998);

return statearr_13023;
})();
var statearr_13024_13045 = state_13005__$1;
(statearr_13024_13045[(2)] = inst_12999);

(statearr_13024_13045[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13006 === (10))){
var inst_12989 = (state_13005[(2)]);
var state_13005__$1 = state_13005;
var statearr_13025_13046 = state_13005__$1;
(statearr_13025_13046[(2)] = inst_12989);

(statearr_13025_13046[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13006 === (8))){
var inst_12969 = (state_13005[(7)]);
var inst_12978 = (state_13005[(11)]);
var tmp13022 = inst_12969;
var inst_12969__$1 = tmp13022;
var inst_12970 = inst_12978;
var state_13005__$1 = (function (){var statearr_13026 = state_13005;
(statearr_13026[(7)] = inst_12969__$1);

(statearr_13026[(8)] = inst_12970);

return statearr_13026;
})();
var statearr_13027_13047 = state_13005__$1;
(statearr_13027_13047[(2)] = null);

(statearr_13027_13047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11217__auto___13033,out))
;
return ((function (switch__11127__auto__,c__11217__auto___13033,out){
return (function() {
var cljs$core$async$state_machine__11128__auto__ = null;
var cljs$core$async$state_machine__11128__auto____0 = (function (){
var statearr_13028 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13028[(0)] = cljs$core$async$state_machine__11128__auto__);

(statearr_13028[(1)] = (1));

return statearr_13028;
});
var cljs$core$async$state_machine__11128__auto____1 = (function (state_13005){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_13005);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e13029){if((e13029 instanceof Object)){
var ex__11131__auto__ = e13029;
var statearr_13030_13048 = state_13005;
(statearr_13030_13048[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13005);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13029;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13049 = state_13005;
state_13005 = G__13049;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$state_machine__11128__auto__ = function(state_13005){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11128__auto____1.call(this,state_13005);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11128__auto____0;
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11128__auto____1;
return cljs$core$async$state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto___13033,out))
})();
var state__11219__auto__ = (function (){var statearr_13031 = f__11218__auto__.call(null);
(statearr_13031[(6)] = c__11217__auto___13033);

return statearr_13031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto___13033,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__13051 = arguments.length;
switch (G__13051) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11217__auto___13121 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11217__auto___13121,out){
return (function (){
var f__11218__auto__ = (function (){var switch__11127__auto__ = ((function (c__11217__auto___13121,out){
return (function (state_13093){
var state_val_13094 = (state_13093[(1)]);
if((state_val_13094 === (7))){
var inst_13089 = (state_13093[(2)]);
var state_13093__$1 = state_13093;
var statearr_13095_13122 = state_13093__$1;
(statearr_13095_13122[(2)] = inst_13089);

(statearr_13095_13122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13094 === (1))){
var inst_13052 = [];
var inst_13053 = inst_13052;
var inst_13054 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13093__$1 = (function (){var statearr_13096 = state_13093;
(statearr_13096[(7)] = inst_13053);

(statearr_13096[(8)] = inst_13054);

return statearr_13096;
})();
var statearr_13097_13123 = state_13093__$1;
(statearr_13097_13123[(2)] = null);

(statearr_13097_13123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13094 === (4))){
var inst_13057 = (state_13093[(9)]);
var inst_13057__$1 = (state_13093[(2)]);
var inst_13058 = (inst_13057__$1 == null);
var inst_13059 = cljs.core.not.call(null,inst_13058);
var state_13093__$1 = (function (){var statearr_13098 = state_13093;
(statearr_13098[(9)] = inst_13057__$1);

return statearr_13098;
})();
if(inst_13059){
var statearr_13099_13124 = state_13093__$1;
(statearr_13099_13124[(1)] = (5));

} else {
var statearr_13100_13125 = state_13093__$1;
(statearr_13100_13125[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13094 === (15))){
var inst_13083 = (state_13093[(2)]);
var state_13093__$1 = state_13093;
var statearr_13101_13126 = state_13093__$1;
(statearr_13101_13126[(2)] = inst_13083);

(statearr_13101_13126[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13094 === (13))){
var state_13093__$1 = state_13093;
var statearr_13102_13127 = state_13093__$1;
(statearr_13102_13127[(2)] = null);

(statearr_13102_13127[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13094 === (6))){
var inst_13053 = (state_13093[(7)]);
var inst_13078 = inst_13053.length;
var inst_13079 = (inst_13078 > (0));
var state_13093__$1 = state_13093;
if(cljs.core.truth_(inst_13079)){
var statearr_13103_13128 = state_13093__$1;
(statearr_13103_13128[(1)] = (12));

} else {
var statearr_13104_13129 = state_13093__$1;
(statearr_13104_13129[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13094 === (3))){
var inst_13091 = (state_13093[(2)]);
var state_13093__$1 = state_13093;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13093__$1,inst_13091);
} else {
if((state_val_13094 === (12))){
var inst_13053 = (state_13093[(7)]);
var inst_13081 = cljs.core.vec.call(null,inst_13053);
var state_13093__$1 = state_13093;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13093__$1,(15),out,inst_13081);
} else {
if((state_val_13094 === (2))){
var state_13093__$1 = state_13093;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13093__$1,(4),ch);
} else {
if((state_val_13094 === (11))){
var inst_13057 = (state_13093[(9)]);
var inst_13061 = (state_13093[(10)]);
var inst_13071 = (state_13093[(2)]);
var inst_13072 = [];
var inst_13073 = inst_13072.push(inst_13057);
var inst_13053 = inst_13072;
var inst_13054 = inst_13061;
var state_13093__$1 = (function (){var statearr_13105 = state_13093;
(statearr_13105[(7)] = inst_13053);

(statearr_13105[(11)] = inst_13071);

(statearr_13105[(8)] = inst_13054);

(statearr_13105[(12)] = inst_13073);

return statearr_13105;
})();
var statearr_13106_13130 = state_13093__$1;
(statearr_13106_13130[(2)] = null);

(statearr_13106_13130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13094 === (9))){
var inst_13053 = (state_13093[(7)]);
var inst_13069 = cljs.core.vec.call(null,inst_13053);
var state_13093__$1 = state_13093;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13093__$1,(11),out,inst_13069);
} else {
if((state_val_13094 === (5))){
var inst_13057 = (state_13093[(9)]);
var inst_13054 = (state_13093[(8)]);
var inst_13061 = (state_13093[(10)]);
var inst_13061__$1 = f.call(null,inst_13057);
var inst_13062 = cljs.core._EQ_.call(null,inst_13061__$1,inst_13054);
var inst_13063 = cljs.core.keyword_identical_QMARK_.call(null,inst_13054,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_13064 = (inst_13062) || (inst_13063);
var state_13093__$1 = (function (){var statearr_13107 = state_13093;
(statearr_13107[(10)] = inst_13061__$1);

return statearr_13107;
})();
if(cljs.core.truth_(inst_13064)){
var statearr_13108_13131 = state_13093__$1;
(statearr_13108_13131[(1)] = (8));

} else {
var statearr_13109_13132 = state_13093__$1;
(statearr_13109_13132[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13094 === (14))){
var inst_13086 = (state_13093[(2)]);
var inst_13087 = cljs.core.async.close_BANG_.call(null,out);
var state_13093__$1 = (function (){var statearr_13111 = state_13093;
(statearr_13111[(13)] = inst_13086);

return statearr_13111;
})();
var statearr_13112_13133 = state_13093__$1;
(statearr_13112_13133[(2)] = inst_13087);

(statearr_13112_13133[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13094 === (10))){
var inst_13076 = (state_13093[(2)]);
var state_13093__$1 = state_13093;
var statearr_13113_13134 = state_13093__$1;
(statearr_13113_13134[(2)] = inst_13076);

(statearr_13113_13134[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13094 === (8))){
var inst_13053 = (state_13093[(7)]);
var inst_13057 = (state_13093[(9)]);
var inst_13061 = (state_13093[(10)]);
var inst_13066 = inst_13053.push(inst_13057);
var tmp13110 = inst_13053;
var inst_13053__$1 = tmp13110;
var inst_13054 = inst_13061;
var state_13093__$1 = (function (){var statearr_13114 = state_13093;
(statearr_13114[(7)] = inst_13053__$1);

(statearr_13114[(14)] = inst_13066);

(statearr_13114[(8)] = inst_13054);

return statearr_13114;
})();
var statearr_13115_13135 = state_13093__$1;
(statearr_13115_13135[(2)] = null);

(statearr_13115_13135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11217__auto___13121,out))
;
return ((function (switch__11127__auto__,c__11217__auto___13121,out){
return (function() {
var cljs$core$async$state_machine__11128__auto__ = null;
var cljs$core$async$state_machine__11128__auto____0 = (function (){
var statearr_13116 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13116[(0)] = cljs$core$async$state_machine__11128__auto__);

(statearr_13116[(1)] = (1));

return statearr_13116;
});
var cljs$core$async$state_machine__11128__auto____1 = (function (state_13093){
while(true){
var ret_value__11129__auto__ = (function (){try{while(true){
var result__11130__auto__ = switch__11127__auto__.call(null,state_13093);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11130__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11130__auto__;
}
break;
}
}catch (e13117){if((e13117 instanceof Object)){
var ex__11131__auto__ = e13117;
var statearr_13118_13136 = state_13093;
(statearr_13118_13136[(5)] = ex__11131__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13093);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13117;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11129__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13137 = state_13093;
state_13093 = G__13137;
continue;
} else {
return ret_value__11129__auto__;
}
break;
}
});
cljs$core$async$state_machine__11128__auto__ = function(state_13093){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11128__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11128__auto____1.call(this,state_13093);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11128__auto____0;
cljs$core$async$state_machine__11128__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11128__auto____1;
return cljs$core$async$state_machine__11128__auto__;
})()
;})(switch__11127__auto__,c__11217__auto___13121,out))
})();
var state__11219__auto__ = (function (){var statearr_13119 = f__11218__auto__.call(null);
(statearr_13119[(6)] = c__11217__auto___13121);

return statearr_13119;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11219__auto__);
});})(c__11217__auto___13121,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map
