// Compiled by ClojureScript 1.10.217 {}
goog.provide('cmr.client.common.const$');
goog.require('cljs.core');
/**
 * A map of the supported CMR hosts, where the key is the target deployment
 *   environment.
 */
cmr.client.common.const$.hosts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"prod","prod",1846120297),"https://cmr.earthdata.nasa.gov",new cljs.core.Keyword(null,"uat","uat",223078731),"https://cmr.uat.earthdata.nasa.gov",new cljs.core.Keyword(null,"sit","sit",258756052),"https://cmr.sit.earthdata.nasa.gov",new cljs.core.Keyword(null,"local","local",-1497766724),"http://localhost"], null);
/**
 * A map of the CMR deployment types where the key is the target deployment
 *   environment and the value is the deployment type.
 */
cmr.client.common.const$.deployment_type = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"prod","prod",1846120297),new cljs.core.Keyword(null,"service","service",-1963054559),new cljs.core.Keyword(null,"uat","uat",223078731),new cljs.core.Keyword(null,"service","service",-1963054559),new cljs.core.Keyword(null,"sit","sit",258756052),new cljs.core.Keyword(null,"service","service",-1963054559),new cljs.core.Keyword(null,"local","local",-1497766724),new cljs.core.Keyword(null,"local","local",-1497766724)], null);
/**
 * A map of CMR service endpoints for each deployment type.
 */
cmr.client.common.const$.endpoints = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"access-control","access-control",-404482046),new cljs.core.Keyword(null,"index-set","index-set",-1289996317),new cljs.core.Keyword(null,"bootstrap","bootstrap",-462579128),new cljs.core.Keyword(null,"metadata-db","metadata-db",-1381872372),new cljs.core.Keyword(null,"cubby","cubby",-2087234100),new cljs.core.Keyword(null,"search","search",1564939822),new cljs.core.Keyword(null,"ingest","ingest",-1043772236),new cljs.core.Keyword(null,"indexer","indexer",-1774914315),new cljs.core.Keyword(null,"graph","graph",1558099509)],[new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"service","service",-1963054559),"/access-control",new cljs.core.Keyword(null,"local","local",-1497766724),":3011"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"local","local",-1497766724),":3005"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"local","local",-1497766724),":3006"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"local","local",-1497766724),":3001"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"local","local",-1497766724),":3007"], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"service","service",-1963054559),"/search",new cljs.core.Keyword(null,"local","local",-1497766724),":3003"], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"service","service",-1963054559),"/ingest",new cljs.core.Keyword(null,"local","local",-1497766724),":3002"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"local","local",-1497766724),":3004"], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"service","service",-1963054559),"/graph",new cljs.core.Keyword(null,"local","local",-1497766724),":3012"], null)]);
/**
 * Default deployment type for the CMR client.
 */
cmr.client.common.const$.default_environment_type = new cljs.core.Keyword(null,"local","local",-1497766724);
/**
 * A map of the CMR client's default local endpoints.
 */
cmr.client.common.const$.default_endpoints = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"access-control","access-control",-404482046),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cmr.client.common.const$.default_environment_type.cljs$core$IFn$_invoke$arity$1(cmr.client.common.const$.hosts)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,cmr.client.common.const$.endpoints,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"access-control","access-control",-404482046),new cljs.core.Keyword(null,"local","local",-1497766724)], null)))].join(''),new cljs.core.Keyword(null,"graph","graph",1558099509),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cmr.client.common.const$.default_environment_type.cljs$core$IFn$_invoke$arity$1(cmr.client.common.const$.hosts)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,cmr.client.common.const$.endpoints,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"graph","graph",1558099509),new cljs.core.Keyword(null,"local","local",-1497766724)], null)))].join(''),new cljs.core.Keyword(null,"ingest","ingest",-1043772236),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cmr.client.common.const$.default_environment_type.cljs$core$IFn$_invoke$arity$1(cmr.client.common.const$.hosts)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,cmr.client.common.const$.endpoints,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ingest","ingest",-1043772236),new cljs.core.Keyword(null,"local","local",-1497766724)], null)))].join(''),new cljs.core.Keyword(null,"search","search",1564939822),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cmr.client.common.const$.default_environment_type.cljs$core$IFn$_invoke$arity$1(cmr.client.common.const$.hosts)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,cmr.client.common.const$.endpoints,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"search","search",1564939822),new cljs.core.Keyword(null,"local","local",-1497766724)], null)))].join('')], null);

//# sourceMappingURL=const.js.map
