// Compiled by ClojureScript 1.10.217 {}
goog.provide('cmr.client.common.util');
goog.require('cljs.core');
goog.require('cmr.client.common.const$');
goog.require('cljs.core.async');
/**
 * Get the default endpoint for a given CMR service. If an environment type
 *   is provided, override the default and get the endpoint for that type.
 */
cmr.client.common.util.get_endpoint = (function cmr$client$common$util$get_endpoint(var_args){
var G__2319 = arguments.length;
switch (G__2319) {
case 1:
return cmr.client.common.util.get_endpoint.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cmr.client.common.util.get_endpoint.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cmr.client.common.util.get_endpoint.cljs$core$IFn$_invoke$arity$1 = (function (service_key){
return service_key.call(null,cmr.client.common.const$.default_endpoints);
});

cmr.client.common.util.get_endpoint.cljs$core$IFn$_invoke$arity$2 = (function (environment_type,service_key){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(environment_type.call(null,cmr.client.common.const$.hosts)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,cmr.client.common.const$.endpoints,(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[service_key,environment_type.call(null,cmr.client.common.const$.deployment_type)],null))))].join('');
});

cmr.client.common.util.get_endpoint.cljs$lang$maxFixedArity = 2;

/**
 * Get the default endpoint; if the client options specify an endpoint, then
 *   use that one.
 */
cmr.client.common.util.get_default_endpoint = (function cmr$client$common$util$get_default_endpoint(options,service_key){
var or__3921__auto__ = new cljs.core.Keyword(null,"endpoint","endpoint",447890044).cljs$core$IFn$_invoke$arity$1(options);
if(cljs.core.truth_(or__3921__auto__)){
return or__3921__auto__;
} else {
return cmr.client.common.util.get_endpoint.call(null,service_key);
}
});
/**
 * Use the token that is defined in the options data structure; if one is not
 *   provided, a null value for token will be used.
 */
cmr.client.common.util.get_default_token = (function cmr$client$common$util$get_default_token(options){
return new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(options);
});
/**
 * Given a string or a deployment environment and a service key, retur the
 *   service endpoint.
 */
cmr.client.common.util.parse_endpoint = (function cmr$client$common$util$parse_endpoint(var_args){
var G__2322 = arguments.length;
switch (G__2322) {
case 1:
return cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$1 = (function (endpoint){
return cmr.client.common.util.parse_endpoint.call(null,endpoint,null);
});

cmr.client.common.util.parse_endpoint.cljs$core$IFn$_invoke$arity$2 = (function (endpoint,service_key){
if(typeof endpoint === 'string'){
return endpoint;
} else {
return cmr.client.common.util.get_endpoint.call(null,endpoint,service_key);
}
});

cmr.client.common.util.parse_endpoint.cljs$lang$maxFixedArity = 2;

/**
 * A utility function for running a callback function when a channel receives
 *   data.
 */
cmr.client.common.util.with_callback = (function cmr$client$common$util$with_callback(chan,callback){
var c__2240__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2240__auto__){
return (function (){
var f__2241__auto__ = (function (){var switch__2217__auto__ = ((function (c__2240__auto__){
return (function (state_2336){
var state_val_2337 = (state_2336[(1)]);
if((state_val_2337 === (1))){
var state_2336__$1 = state_2336;
var statearr_2338_2349 = state_2336__$1;
(statearr_2338_2349[(2)] = null);

(statearr_2338_2349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2337 === (2))){
var state_2336__$1 = state_2336;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_2336__$1,(4),chan);
} else {
if((state_val_2337 === (3))){
var inst_2334 = (state_2336[(2)]);
var state_2336__$1 = state_2336;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_2336__$1,inst_2334);
} else {
if((state_val_2337 === (4))){
var inst_2326 = (state_2336[(7)]);
var inst_2326__$1 = (state_2336[(2)]);
var state_2336__$1 = (function (){var statearr_2339 = state_2336;
(statearr_2339[(7)] = inst_2326__$1);

return statearr_2339;
})();
if(cljs.core.truth_(inst_2326__$1)){
var statearr_2340_2350 = state_2336__$1;
(statearr_2340_2350[(1)] = (5));

} else {
var statearr_2341_2351 = state_2336__$1;
(statearr_2341_2351[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2337 === (5))){
var inst_2326 = (state_2336[(7)]);
var inst_2328 = callback.call(null,inst_2326);
var state_2336__$1 = state_2336;
var statearr_2342_2352 = state_2336__$1;
(statearr_2342_2352[(2)] = inst_2328);

(statearr_2342_2352[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2337 === (6))){
var state_2336__$1 = state_2336;
var statearr_2343_2353 = state_2336__$1;
(statearr_2343_2353[(2)] = null);

(statearr_2343_2353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2337 === (7))){
var inst_2332 = (state_2336[(2)]);
var state_2336__$1 = state_2336;
var statearr_2344_2354 = state_2336__$1;
(statearr_2344_2354[(2)] = inst_2332);

(statearr_2344_2354[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__2240__auto__))
;
return ((function (switch__2217__auto__,c__2240__auto__){
return (function() {
var cmr$client$common$util$with_callback_$_state_machine__2218__auto__ = null;
var cmr$client$common$util$with_callback_$_state_machine__2218__auto____0 = (function (){
var statearr_2345 = [null,null,null,null,null,null,null,null];
(statearr_2345[(0)] = cmr$client$common$util$with_callback_$_state_machine__2218__auto__);

(statearr_2345[(1)] = (1));

return statearr_2345;
});
var cmr$client$common$util$with_callback_$_state_machine__2218__auto____1 = (function (state_2336){
while(true){
var ret_value__2219__auto__ = (function (){try{while(true){
var result__2220__auto__ = switch__2217__auto__.call(null,state_2336);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2220__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2220__auto__;
}
break;
}
}catch (e2346){if((e2346 instanceof Object)){
var ex__2221__auto__ = e2346;
var statearr_2347_2355 = state_2336;
(statearr_2347_2355[(5)] = ex__2221__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_2336);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e2346;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2219__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__2356 = state_2336;
state_2336 = G__2356;
continue;
} else {
return ret_value__2219__auto__;
}
break;
}
});
cmr$client$common$util$with_callback_$_state_machine__2218__auto__ = function(state_2336){
switch(arguments.length){
case 0:
return cmr$client$common$util$with_callback_$_state_machine__2218__auto____0.call(this);
case 1:
return cmr$client$common$util$with_callback_$_state_machine__2218__auto____1.call(this,state_2336);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cmr$client$common$util$with_callback_$_state_machine__2218__auto__.cljs$core$IFn$_invoke$arity$0 = cmr$client$common$util$with_callback_$_state_machine__2218__auto____0;
cmr$client$common$util$with_callback_$_state_machine__2218__auto__.cljs$core$IFn$_invoke$arity$1 = cmr$client$common$util$with_callback_$_state_machine__2218__auto____1;
return cmr$client$common$util$with_callback_$_state_machine__2218__auto__;
})()
;})(switch__2217__auto__,c__2240__auto__))
})();
var state__2242__auto__ = (function (){var statearr_2348 = f__2241__auto__.call(null);
(statearr_2348[(6)] = c__2240__auto__);

return statearr_2348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2242__auto__);
});})(c__2240__auto__))
);

return c__2240__auto__;
});
goog.exportSymbol('cmr.client.common.util.with_callback', cmr.client.common.util.with_callback);
/**
 * This is a utility function that returns a function for creating clients of
 *   a particular type, e.g., ingest, search, or access-control clients.
 * 
 *   The arguments details are as follows:
 * 
 *   * `service-type` - must be one of the supported service types, notably
 *  `:ingest`, `:search`, or `:access-control`
 *   * `client-constructor-var` - this is the var of that is assigned the value of
 *  the call to `create-service-client-constructor`; it is passed so that the
 *  anonymous function below has something to refer to in support of multiple
 *  arities
 *   * `client-data-constructor` - this is the constrcutor for the record that is
 *  used for the implementation of the protocol (that which is extended)
 *   * `options-fn` - a functin which creates the client client options, including
 *  basic defaults, for the implementation; it should be a function that in
 *  turn calls a `CMR*ClientOpions` constructor
 *   * `http-client-constructor` - a function that instrantiates the CMR HTTP
 *  client used by all CMR service type clients (different for Clojure and
 *  ClojureScript)
 * 
 *   This docstring is a bit dense; for more clarity, be sure to view the calls
 *   made to this function in both the Clojure and ClojureScript clients.
 */
cmr.client.common.util.create_service_client_constructor = (function cmr$client$common$util$create_service_client_constructor(service_type,client_constructor_var,client_data_constructor,options_fn,http_client_constructor){
return (function() {
var G__2357 = null;
var G__2357__0 = (function (){
return client_constructor_var.call(null,cljs.core.PersistentArrayMap.EMPTY);
});
var G__2357__1 = (function (options){
return client_constructor_var.call(null,options,cljs.core.PersistentArrayMap.EMPTY);
});
var G__2357__2 = (function (options,http_options){
var endpoint = cmr.client.common.util.get_default_endpoint.call(null,options,service_type);
var token = cmr.client.common.util.get_default_token.call(null,options);
var client_options = options_fn.call(null,options);
var http_client = http_client_constructor.call(null,client_options,http_options);
return client_data_constructor.call(null,cmr.client.common.util.parse_endpoint.call(null,endpoint,service_type),token,client_options,http_client);
});
G__2357 = function(options,http_options){
switch(arguments.length){
case 0:
return G__2357__0.call(this);
case 1:
return G__2357__1.call(this,options);
case 2:
return G__2357__2.call(this,options,http_options);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__2357.cljs$core$IFn$_invoke$arity$0 = G__2357__0;
G__2357.cljs$core$IFn$_invoke$arity$1 = G__2357__1;
G__2357.cljs$core$IFn$_invoke$arity$2 = G__2357__2;
return G__2357;
})()
});
/**
 * This is a utility function that returns a function for creating clients of
 *   a particular type, e.g., ingest, search, or access-control clients.
 * 
 *   The arguments details are as follows:
 * 
 *   * `client-constructor-var` - this is the var of that is assigned the value of
 *  the call to `create-service-client-constructor`; it is passed so that the
 *  anonymous function below has something to refer to in support of multiple
 *  arities
 *   * `client-data-constructor` - this is the constrcutor for the record that is
 *  used for the implementation of the protocol (that which is extended)
 */
cmr.client.common.util.create_http_client_constructor = (function cmr$client$common$util$create_http_client_constructor(client_constructor_var,client_data_constructor){
return (function() {
var G__2358 = null;
var G__2358__0 = (function (){
return client_constructor_var.call(null,cljs.core.PersistentArrayMap.EMPTY);
});
var G__2358__1 = (function (http_options){
return client_constructor_var.call(null,cljs.core.PersistentArrayMap.EMPTY,http_options);
});
var G__2358__2 = (function (parent_client_options,http_options){
return client_data_constructor.call(null,parent_client_options,http_options);
});
G__2358 = function(parent_client_options,http_options){
switch(arguments.length){
case 0:
return G__2358__0.call(this);
case 1:
return G__2358__1.call(this,parent_client_options);
case 2:
return G__2358__2.call(this,parent_client_options,http_options);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__2358.cljs$core$IFn$_invoke$arity$0 = G__2358__0;
G__2358.cljs$core$IFn$_invoke$arity$1 = G__2358__1;
G__2358.cljs$core$IFn$_invoke$arity$2 = G__2358__2;
return G__2358;
})()
});
var ret__4532__auto___2359 = /**
 * Import a single function or var:
 *   ```
 *   (import-def a b) => (def b a/b)
 *   ```
 */
cmr.client.common.util.import_def = (function cmr$client$common$util$import_def(_AMPERSAND_form,_AMPERSAND_env,from_ns,def_name){
var from_sym_SHARP_ = cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(from_ns)].join(''),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(def_name)].join(''));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"def","def",597100991,null),null,(1),null)),(new cljs.core.List(null,def_name,null,(1),null)),(new cljs.core.List(null,from_sym_SHARP_,null,(1),null)))));
});
cmr.client.common.util.import_def.cljs$lang$macro = true;

var ret__4532__auto___2372 = (function (){
/**
 * Import multiple defs from multiple namespaces.
 * 
 * This works for vars and functions, but not macros. Uses the same syntax as
 * `potemkin.namespaces/import-vars`, namely:
 * ```
 * (import-vars
 *   [m.n.ns1 a b]
 *   [x.y.ns2 d e f])
 *   ```
 */
cmr.client.common.util.import_vars = (function cmr$client$common$util$import_vars(var_args){
var args__4501__auto__ = [];
var len__4498__auto___2373 = arguments.length;
var i__4499__auto___2374 = (0);
while(true){
if((i__4499__auto___2374 < len__4498__auto___2373)){
args__4501__auto__.push((arguments[i__4499__auto___2374]));

var G__2375 = (i__4499__auto___2374 + (1));
i__4499__auto___2374 = G__2375;
continue;
} else {
}
break;
}

var argseq__4502__auto__ = ((((2) < args__4501__auto__.length))?(new cljs.core.IndexedSeq(args__4501__auto__.slice((2)),(0),null)):null);
return cmr.client.common.util.import_vars.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4502__auto__);
});

cmr.client.common.util.import_vars.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,imports){
var expanded_imports = (function (){var iter__4291__auto__ = (function cmr$client$common$util$iter__2363(s__2364){
return (new cljs.core.LazySeq(null,(function (){
var s__2364__$1 = s__2364;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__2364__$1);
if(temp__5457__auto__){
var xs__6012__auto__ = temp__5457__auto__;
var vec__2369 = cljs.core.first.call(null,xs__6012__auto__);
var seq__2370 = cljs.core.seq.call(null,vec__2369);
var first__2371 = cljs.core.first.call(null,seq__2370);
var seq__2370__$1 = cljs.core.next.call(null,seq__2370);
var from_ns = first__2371;
var defs = seq__2370__$1;
var iterys__4287__auto__ = ((function (s__2364__$1,vec__2369,seq__2370,first__2371,seq__2370__$1,from_ns,defs,xs__6012__auto__,temp__5457__auto__){
return (function cmr$client$common$util$iter__2363_$_iter__2365(s__2366){
return (new cljs.core.LazySeq(null,((function (s__2364__$1,vec__2369,seq__2370,first__2371,seq__2370__$1,from_ns,defs,xs__6012__auto__,temp__5457__auto__){
return (function (){
var s__2366__$1 = s__2366;
while(true){
var temp__5457__auto____$1 = cljs.core.seq.call(null,s__2366__$1);
if(temp__5457__auto____$1){
var s__2366__$2 = temp__5457__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__2366__$2)){
var c__4289__auto__ = cljs.core.chunk_first.call(null,s__2366__$2);
var size__4290__auto__ = cljs.core.count.call(null,c__4289__auto__);
var b__2368 = cljs.core.chunk_buffer.call(null,size__4290__auto__);
if((function (){var i__2367 = (0);
while(true){
if((i__2367 < size__4290__auto__)){
var d = cljs.core._nth.call(null,c__4289__auto__,i__2367);
cljs.core.chunk_append.call(null,b__2368,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cmr.client.common.util","import-def","cmr.client.common.util/import-def",708150912,null),null,(1),null)),(new cljs.core.List(null,from_ns,null,(1),null)),(new cljs.core.List(null,d,null,(1),null))))));

var G__2376 = (i__2367 + (1));
i__2367 = G__2376;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__2368),cmr$client$common$util$iter__2363_$_iter__2365.call(null,cljs.core.chunk_rest.call(null,s__2366__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__2368),null);
}
} else {
var d = cljs.core.first.call(null,s__2366__$2);
return cljs.core.cons.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("cmr.client.common.util","import-def","cmr.client.common.util/import-def",708150912,null),null,(1),null)),(new cljs.core.List(null,from_ns,null,(1),null)),(new cljs.core.List(null,d,null,(1),null))))),cmr$client$common$util$iter__2363_$_iter__2365.call(null,cljs.core.rest.call(null,s__2366__$2)));
}
} else {
return null;
}
break;
}
});})(s__2364__$1,vec__2369,seq__2370,first__2371,seq__2370__$1,from_ns,defs,xs__6012__auto__,temp__5457__auto__))
,null,null));
});})(s__2364__$1,vec__2369,seq__2370,first__2371,seq__2370__$1,from_ns,defs,xs__6012__auto__,temp__5457__auto__))
;
var fs__4288__auto__ = cljs.core.seq.call(null,iterys__4287__auto__.call(null,defs));
if(fs__4288__auto__){
return cljs.core.concat.call(null,fs__4288__auto__,cmr$client$common$util$iter__2363.call(null,cljs.core.rest.call(null,s__2364__$1)));
} else {
var G__2377 = cljs.core.rest.call(null,s__2364__$1);
s__2364__$1 = G__2377;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4291__auto__.call(null,imports);
})();
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"do","do",1686842252,null),null,(1),null)),expanded_imports)));
});

cmr.client.common.util.import_vars.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
cmr.client.common.util.import_vars.cljs$lang$applyTo = (function (seq2360){
var G__2361 = cljs.core.first.call(null,seq2360);
var seq2360__$1 = cljs.core.next.call(null,seq2360);
var G__2362 = cljs.core.first.call(null,seq2360__$1);
var seq2360__$2 = cljs.core.next.call(null,seq2360__$1);
var self__4485__auto__ = this;
return self__4485__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2361,G__2362,seq2360__$2);
});

return null;
})()
;
cmr.client.common.util.import_vars.cljs$lang$macro = true;


//# sourceMappingURL=util.js.map
