// Compiled by ClojureScript 1.10.217 {}
goog.provide('cmr.client.graph.impl');
goog.require('cljs.core');
goog.require('cmr.client.http.util');
goog.require('cmr.client.http.core');
goog.require('cmr.client.base.impl');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cmr.client.graph.impl.CMRGraphClientData = (function (endpoint,token,options,http_client,__meta,__extmap,__hash){
this.endpoint = endpoint;
this.token = token;
this.options = options;
this.http_client = http_client;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
cmr.client.graph.impl.CMRGraphClientData.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4171__auto__,k__4172__auto__){
var self__ = this;
var this__4171__auto____$1 = this;
return this__4171__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4172__auto__,null);
});

cmr.client.graph.impl.CMRGraphClientData.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4173__auto__,k2602,else__4174__auto__){
var self__ = this;
var this__4173__auto____$1 = this;
var G__2606 = k2602;
var G__2606__$1 = (((G__2606 instanceof cljs.core.Keyword))?G__2606.fqn:null);
switch (G__2606__$1) {
case "endpoint":
return self__.endpoint;

break;
case "token":
return self__.token;

break;
case "options":
return self__.options;

break;
case "http-client":
return self__.http_client;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k2602,else__4174__auto__);

}
});

cmr.client.graph.impl.CMRGraphClientData.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4185__auto__,writer__4186__auto__,opts__4187__auto__){
var self__ = this;
var this__4185__auto____$1 = this;
var pr_pair__4188__auto__ = ((function (this__4185__auto____$1){
return (function (keyval__4189__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4186__auto__,cljs.core.pr_writer,""," ","",opts__4187__auto__,keyval__4189__auto__);
});})(this__4185__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4186__auto__,pr_pair__4188__auto__,"#cmr.client.graph.impl.CMRGraphClientData{",", ","}",opts__4187__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"endpoint","endpoint",447890044),self__.endpoint],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"token","token",-1211463215),self__.token],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"options","options",99638489),self__.options],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"http-client","http-client",-1812758074),self__.http_client],null))], null),self__.__extmap));
});

cmr.client.graph.impl.CMRGraphClientData.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__2601){
var self__ = this;
var G__2601__$1 = this;
return (new cljs.core.RecordIter((0),G__2601__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"endpoint","endpoint",447890044),new cljs.core.Keyword(null,"token","token",-1211463215),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"http-client","http-client",-1812758074)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

cmr.client.graph.impl.CMRGraphClientData.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4169__auto__){
var self__ = this;
var this__4169__auto____$1 = this;
return self__.__meta;
});

cmr.client.graph.impl.CMRGraphClientData.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4166__auto__){
var self__ = this;
var this__4166__auto____$1 = this;
return (new cmr.client.graph.impl.CMRGraphClientData(self__.endpoint,self__.token,self__.options,self__.http_client,self__.__meta,self__.__extmap,self__.__hash));
});

cmr.client.graph.impl.CMRGraphClientData.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4175__auto__){
var self__ = this;
var this__4175__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});

cmr.client.graph.impl.CMRGraphClientData.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4167__auto__){
var self__ = this;
var this__4167__auto____$1 = this;
var h__4029__auto__ = self__.__hash;
if(!((h__4029__auto__ == null))){
return h__4029__auto__;
} else {
var h__4029__auto____$1 = ((function (h__4029__auto__,this__4167__auto____$1){
return (function (coll__4168__auto__){
return (434785513 ^ cljs.core.hash_unordered_coll.call(null,coll__4168__auto__));
});})(h__4029__auto__,this__4167__auto____$1))
.call(null,this__4167__auto____$1);
self__.__hash = h__4029__auto____$1;

return h__4029__auto____$1;
}
});

cmr.client.graph.impl.CMRGraphClientData.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this2603,other2604){
var self__ = this;
var this2603__$1 = this;
return ((!((other2604 == null))) && ((this2603__$1.constructor === other2604.constructor)) && (cljs.core._EQ_.call(null,this2603__$1.endpoint,other2604.endpoint)) && (cljs.core._EQ_.call(null,this2603__$1.token,other2604.token)) && (cljs.core._EQ_.call(null,this2603__$1.options,other2604.options)) && (cljs.core._EQ_.call(null,this2603__$1.http_client,other2604.http_client)) && (cljs.core._EQ_.call(null,this2603__$1.__extmap,other2604.__extmap)));
});

cmr.client.graph.impl.CMRGraphClientData.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4180__auto__,k__4181__auto__){
var self__ = this;
var this__4180__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"http-client","http-client",-1812758074),null,new cljs.core.Keyword(null,"token","token",-1211463215),null,new cljs.core.Keyword(null,"options","options",99638489),null,new cljs.core.Keyword(null,"endpoint","endpoint",447890044),null], null), null),k__4181__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4180__auto____$1),self__.__meta),k__4181__auto__);
} else {
return (new cmr.client.graph.impl.CMRGraphClientData(self__.endpoint,self__.token,self__.options,self__.http_client,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4181__auto__)),null));
}
});

cmr.client.graph.impl.CMRGraphClientData.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4178__auto__,k__4179__auto__,G__2601){
var self__ = this;
var this__4178__auto____$1 = this;
var pred__2607 = cljs.core.keyword_identical_QMARK_;
var expr__2608 = k__4179__auto__;
if(cljs.core.truth_(pred__2607.call(null,new cljs.core.Keyword(null,"endpoint","endpoint",447890044),expr__2608))){
return (new cmr.client.graph.impl.CMRGraphClientData(G__2601,self__.token,self__.options,self__.http_client,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__2607.call(null,new cljs.core.Keyword(null,"token","token",-1211463215),expr__2608))){
return (new cmr.client.graph.impl.CMRGraphClientData(self__.endpoint,G__2601,self__.options,self__.http_client,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__2607.call(null,new cljs.core.Keyword(null,"options","options",99638489),expr__2608))){
return (new cmr.client.graph.impl.CMRGraphClientData(self__.endpoint,self__.token,G__2601,self__.http_client,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__2607.call(null,new cljs.core.Keyword(null,"http-client","http-client",-1812758074),expr__2608))){
return (new cmr.client.graph.impl.CMRGraphClientData(self__.endpoint,self__.token,self__.options,G__2601,self__.__meta,self__.__extmap,null));
} else {
return (new cmr.client.graph.impl.CMRGraphClientData(self__.endpoint,self__.token,self__.options,self__.http_client,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4179__auto__,G__2601),null));
}
}
}
}
});

cmr.client.graph.impl.CMRGraphClientData.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4183__auto__){
var self__ = this;
var this__4183__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"endpoint","endpoint",447890044),self__.endpoint,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"token","token",-1211463215),self__.token,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"options","options",99638489),self__.options,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"http-client","http-client",-1812758074),self__.http_client,null))], null),self__.__extmap));
});

cmr.client.graph.impl.CMRGraphClientData.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4170__auto__,G__2601){
var self__ = this;
var this__4170__auto____$1 = this;
return (new cmr.client.graph.impl.CMRGraphClientData(self__.endpoint,self__.token,self__.options,self__.http_client,G__2601,self__.__extmap,self__.__hash));
});

cmr.client.graph.impl.CMRGraphClientData.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4176__auto__,entry__4177__auto__){
var self__ = this;
var this__4176__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4177__auto__)){
return this__4176__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4177__auto__,(0)),cljs.core._nth.call(null,entry__4177__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4176__auto____$1,entry__4177__auto__);
}
});

cmr.client.graph.impl.CMRGraphClientData.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"endpoint","endpoint",2088421571,null),new cljs.core.Symbol(null,"token","token",429068312,null),new cljs.core.Symbol(null,"options","options",1740170016,null),new cljs.core.Symbol(null,"http-client","http-client",-172226547,null)], null);
});

cmr.client.graph.impl.CMRGraphClientData.cljs$lang$type = true;

cmr.client.graph.impl.CMRGraphClientData.cljs$lang$ctorPrSeq = (function (this__4207__auto__){
return (new cljs.core.List(null,"cmr.client.graph.impl/CMRGraphClientData",null,(1),null));
});

cmr.client.graph.impl.CMRGraphClientData.cljs$lang$ctorPrWriter = (function (this__4207__auto__,writer__4208__auto__){
return cljs.core._write.call(null,writer__4208__auto__,"cmr.client.graph.impl/CMRGraphClientData");
});

/**
 * Positional factory function for cmr.client.graph.impl/CMRGraphClientData.
 */
cmr.client.graph.impl.__GT_CMRGraphClientData = (function cmr$client$graph$impl$__GT_CMRGraphClientData(endpoint,token,options,http_client){
return (new cmr.client.graph.impl.CMRGraphClientData(endpoint,token,options,http_client,null,null,null));
});

/**
 * Factory function for cmr.client.graph.impl/CMRGraphClientData, taking a map of keywords to field values.
 */
cmr.client.graph.impl.map__GT_CMRGraphClientData = (function cmr$client$graph$impl$map__GT_CMRGraphClientData(G__2605){
return (new cmr.client.graph.impl.CMRGraphClientData(new cljs.core.Keyword(null,"endpoint","endpoint",447890044).cljs$core$IFn$_invoke$arity$1(G__2605),new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(G__2605),new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(G__2605),new cljs.core.Keyword(null,"http-client","http-client",-1812758074).cljs$core$IFn$_invoke$arity$1(G__2605),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__2605,new cljs.core.Keyword(null,"endpoint","endpoint",447890044),new cljs.core.Keyword(null,"token","token",-1211463215),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"http-client","http-client",-1812758074))),null));
});

/**
 * See protocol defintion for docstring.
 */
cmr.client.graph.impl.get_movie = (function cmr$client$graph$impl$get_movie(var_args){
var G__2612 = arguments.length;
switch (G__2612) {
case 2:
return cmr.client.graph.impl.get_movie.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cmr.client.graph.impl.get_movie.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cmr.client.graph.impl.get_movie.cljs$core$IFn$_invoke$arity$2 = (function (this$,query_str){
return cmr.client.graph.impl.get_movie.call(null,this$,query_str,cljs.core.PersistentArrayMap.EMPTY);
});

cmr.client.graph.impl.get_movie.cljs$core$IFn$_invoke$arity$3 = (function (this$,query_str,http_options){
return cmr.client.http.core.get.call(null,new cljs.core.Keyword(null,"http-client","http-client",-1812758074).cljs$core$IFn$_invoke$arity$1(this$),cmr.client.base.impl.get_url.call(null,this$,["/demo/movie/search?q=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_str)].join('')),cmr.client.http.util.merge_header.call(null,http_options,cmr.client.base.impl.get_token_header.call(null,this$)));
});

cmr.client.graph.impl.get_movie.cljs$lang$maxFixedArity = 3;

/**
 * See protocol defintion for docstring.
 */
cmr.client.graph.impl.get_collection_url_relation = (function cmr$client$graph$impl$get_collection_url_relation(var_args){
var G__2615 = arguments.length;
switch (G__2615) {
case 2:
return cmr.client.graph.impl.get_collection_url_relation.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cmr.client.graph.impl.get_collection_url_relation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cmr.client.graph.impl.get_collection_url_relation.cljs$core$IFn$_invoke$arity$2 = (function (this$,concept_id){
return cmr.client.graph.impl.get_collection_url_relation.call(null,this$,concept_id,cljs.core.PersistentArrayMap.EMPTY);
});

cmr.client.graph.impl.get_collection_url_relation.cljs$core$IFn$_invoke$arity$3 = (function (this$,concept_id,http_options){
return cmr.client.http.core.get.call(null,new cljs.core.Keyword(null,"http-client","http-client",-1812758074).cljs$core$IFn$_invoke$arity$1(this$),cmr.client.base.impl.get_url.call(null,this$,["/relationships/related-urls/collections/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(concept_id)].join('')),cmr.client.http.util.merge_header.call(null,http_options,cmr.client.base.impl.get_token_header.call(null,this$)));
});

cmr.client.graph.impl.get_collection_url_relation.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=impl.js.map
