// Compiled by ClojureScript 1.10.217 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('figwheel.client.utils');
goog.require('goog.Uri');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.net.jsloader');
goog.require('goog.html.legacyconversions');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.core.async');
goog.require('goog.async.Deferred');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.on_cssload_custom_event = (function figwheel$client$file_reloading$on_cssload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.css-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__3921__auto__ = ((cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && ((((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string'))) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372))));
if(or__3921__auto__){
return or__3921__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return goog.object.get(goog.dependencies_.nameToPath,ns);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return goog.object.get(goog.dependencies_.written,figwheel.client.file_reloading.name__GT_path.call(null,ns));
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__3921__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["cljs.nodejs",null,"goog",null,"cljs.core",null], null), null).call(null,name);
if(cljs.core.truth_(or__3921__auto__)){
return or__3921__auto__;
} else {
var or__3921__auto____$1 = goog.string.startsWith("clojure.",name);
if(cljs.core.truth_(or__3921__auto____$1)){
return or__3921__auto____$1;
} else {
return goog.string.startsWith("goog.",name);
}
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__24966_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__24966_SHARP_));
}),goog.object.getKeys(goog.object.get(goog.dependencies_.requires,figwheel.client.file_reloading.name__GT_path.call(null,ns)))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([name]));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.createAsIfByAssoc([parent_ns]));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__24967 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__24968 = null;
var count__24969 = (0);
var i__24970 = (0);
while(true){
if((i__24970 < count__24969)){
var n = cljs.core._nth.call(null,chunk__24968,i__24970);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__24971 = seq__24967;
var G__24972 = chunk__24968;
var G__24973 = count__24969;
var G__24974 = (i__24970 + (1));
seq__24967 = G__24971;
chunk__24968 = G__24972;
count__24969 = G__24973;
i__24970 = G__24974;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__24967);
if(temp__5457__auto__){
var seq__24967__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24967__$1)){
var c__4318__auto__ = cljs.core.chunk_first.call(null,seq__24967__$1);
var G__24975 = cljs.core.chunk_rest.call(null,seq__24967__$1);
var G__24976 = c__4318__auto__;
var G__24977 = cljs.core.count.call(null,c__4318__auto__);
var G__24978 = (0);
seq__24967 = G__24975;
chunk__24968 = G__24976;
count__24969 = G__24977;
i__24970 = G__24978;
continue;
} else {
var n = cljs.core.first.call(null,seq__24967__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);


var G__24979 = cljs.core.next.call(null,seq__24967__$1);
var G__24980 = null;
var G__24981 = (0);
var G__24982 = (0);
seq__24967 = G__24979;
chunk__24968 = G__24980;
count__24969 = G__24981;
i__24970 = G__24982;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.in_upper_level_QMARK_ = (function figwheel$client$file_reloading$in_upper_level_QMARK_(topo_state,current_depth,dep){
return cljs.core.some.call(null,(function (p__24983){
var vec__24984 = p__24983;
var _ = cljs.core.nth.call(null,vec__24984,(0),null);
var v = cljs.core.nth.call(null,vec__24984,(1),null);
var and__3910__auto__ = v;
if(cljs.core.truth_(and__3910__auto__)){
return v.call(null,dep);
} else {
return and__3910__auto__;
}
}),cljs.core.filter.call(null,(function (p__24987){
var vec__24988 = p__24987;
var k = cljs.core.nth.call(null,vec__24988,(0),null);
var v = cljs.core.nth.call(null,vec__24988,(1),null);
return (k > current_depth);
}),topo_state));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__25000_25008 = cljs.core.seq.call(null,deps);
var chunk__25001_25009 = null;
var count__25002_25010 = (0);
var i__25003_25011 = (0);
while(true){
if((i__25003_25011 < count__25002_25010)){
var dep_25012 = cljs.core._nth.call(null,chunk__25001_25009,i__25003_25011);
if(cljs.core.truth_((function (){var and__3910__auto__ = dep_25012;
if(cljs.core.truth_(and__3910__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_25012));
} else {
return and__3910__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_25012,(depth + (1)),state);
} else {
}


var G__25013 = seq__25000_25008;
var G__25014 = chunk__25001_25009;
var G__25015 = count__25002_25010;
var G__25016 = (i__25003_25011 + (1));
seq__25000_25008 = G__25013;
chunk__25001_25009 = G__25014;
count__25002_25010 = G__25015;
i__25003_25011 = G__25016;
continue;
} else {
var temp__5457__auto___25017 = cljs.core.seq.call(null,seq__25000_25008);
if(temp__5457__auto___25017){
var seq__25000_25018__$1 = temp__5457__auto___25017;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25000_25018__$1)){
var c__4318__auto___25019 = cljs.core.chunk_first.call(null,seq__25000_25018__$1);
var G__25020 = cljs.core.chunk_rest.call(null,seq__25000_25018__$1);
var G__25021 = c__4318__auto___25019;
var G__25022 = cljs.core.count.call(null,c__4318__auto___25019);
var G__25023 = (0);
seq__25000_25008 = G__25020;
chunk__25001_25009 = G__25021;
count__25002_25010 = G__25022;
i__25003_25011 = G__25023;
continue;
} else {
var dep_25024 = cljs.core.first.call(null,seq__25000_25018__$1);
if(cljs.core.truth_((function (){var and__3910__auto__ = dep_25024;
if(cljs.core.truth_(and__3910__auto__)){
return cljs.core.not.call(null,figwheel.client.file_reloading.in_upper_level_QMARK_.call(null,cljs.core.deref.call(null,state),depth,dep_25024));
} else {
return and__3910__auto__;
}
})())){
topo_sort_helper_STAR_.call(null,dep_25024,(depth + (1)),state);
} else {
}


var G__25025 = cljs.core.next.call(null,seq__25000_25018__$1);
var G__25026 = null;
var G__25027 = (0);
var G__25028 = (0);
seq__25000_25008 = G__25025;
chunk__25001_25009 = G__25026;
count__25002_25010 = G__25027;
i__25003_25011 = G__25028;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__25004){
var vec__25005 = p__25004;
var seq__25006 = cljs.core.seq.call(null,vec__25005);
var first__25007 = cljs.core.first.call(null,seq__25006);
var seq__25006__$1 = cljs.core.next.call(null,seq__25006);
var x = first__25007;
var xs = seq__25006__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__25005,seq__25006,first__25007,seq__25006__$1,x,xs,get_deps__$1){
return (function (p1__24991_SHARP_){
return clojure.set.difference.call(null,p1__24991_SHARP_,x);
});})(vec__25005,seq__25006,first__25007,seq__25006__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,figwheel.client.file_reloading.immutable_ns_QMARK_),cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss)))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog.basePath),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__25029 = cljs.core.seq.call(null,provides);
var chunk__25030 = null;
var count__25031 = (0);
var i__25032 = (0);
while(true){
if((i__25032 < count__25031)){
var prov = cljs.core._nth.call(null,chunk__25030,i__25032);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__25033_25041 = cljs.core.seq.call(null,requires);
var chunk__25034_25042 = null;
var count__25035_25043 = (0);
var i__25036_25044 = (0);
while(true){
if((i__25036_25044 < count__25035_25043)){
var req_25045 = cljs.core._nth.call(null,chunk__25034_25042,i__25036_25044);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_25045,prov);


var G__25046 = seq__25033_25041;
var G__25047 = chunk__25034_25042;
var G__25048 = count__25035_25043;
var G__25049 = (i__25036_25044 + (1));
seq__25033_25041 = G__25046;
chunk__25034_25042 = G__25047;
count__25035_25043 = G__25048;
i__25036_25044 = G__25049;
continue;
} else {
var temp__5457__auto___25050 = cljs.core.seq.call(null,seq__25033_25041);
if(temp__5457__auto___25050){
var seq__25033_25051__$1 = temp__5457__auto___25050;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25033_25051__$1)){
var c__4318__auto___25052 = cljs.core.chunk_first.call(null,seq__25033_25051__$1);
var G__25053 = cljs.core.chunk_rest.call(null,seq__25033_25051__$1);
var G__25054 = c__4318__auto___25052;
var G__25055 = cljs.core.count.call(null,c__4318__auto___25052);
var G__25056 = (0);
seq__25033_25041 = G__25053;
chunk__25034_25042 = G__25054;
count__25035_25043 = G__25055;
i__25036_25044 = G__25056;
continue;
} else {
var req_25057 = cljs.core.first.call(null,seq__25033_25051__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_25057,prov);


var G__25058 = cljs.core.next.call(null,seq__25033_25051__$1);
var G__25059 = null;
var G__25060 = (0);
var G__25061 = (0);
seq__25033_25041 = G__25058;
chunk__25034_25042 = G__25059;
count__25035_25043 = G__25060;
i__25036_25044 = G__25061;
continue;
}
} else {
}
}
break;
}


var G__25062 = seq__25029;
var G__25063 = chunk__25030;
var G__25064 = count__25031;
var G__25065 = (i__25032 + (1));
seq__25029 = G__25062;
chunk__25030 = G__25063;
count__25031 = G__25064;
i__25032 = G__25065;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__25029);
if(temp__5457__auto__){
var seq__25029__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25029__$1)){
var c__4318__auto__ = cljs.core.chunk_first.call(null,seq__25029__$1);
var G__25066 = cljs.core.chunk_rest.call(null,seq__25029__$1);
var G__25067 = c__4318__auto__;
var G__25068 = cljs.core.count.call(null,c__4318__auto__);
var G__25069 = (0);
seq__25029 = G__25066;
chunk__25030 = G__25067;
count__25031 = G__25068;
i__25032 = G__25069;
continue;
} else {
var prov = cljs.core.first.call(null,seq__25029__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__25037_25070 = cljs.core.seq.call(null,requires);
var chunk__25038_25071 = null;
var count__25039_25072 = (0);
var i__25040_25073 = (0);
while(true){
if((i__25040_25073 < count__25039_25072)){
var req_25074 = cljs.core._nth.call(null,chunk__25038_25071,i__25040_25073);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_25074,prov);


var G__25075 = seq__25037_25070;
var G__25076 = chunk__25038_25071;
var G__25077 = count__25039_25072;
var G__25078 = (i__25040_25073 + (1));
seq__25037_25070 = G__25075;
chunk__25038_25071 = G__25076;
count__25039_25072 = G__25077;
i__25040_25073 = G__25078;
continue;
} else {
var temp__5457__auto___25079__$1 = cljs.core.seq.call(null,seq__25037_25070);
if(temp__5457__auto___25079__$1){
var seq__25037_25080__$1 = temp__5457__auto___25079__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25037_25080__$1)){
var c__4318__auto___25081 = cljs.core.chunk_first.call(null,seq__25037_25080__$1);
var G__25082 = cljs.core.chunk_rest.call(null,seq__25037_25080__$1);
var G__25083 = c__4318__auto___25081;
var G__25084 = cljs.core.count.call(null,c__4318__auto___25081);
var G__25085 = (0);
seq__25037_25070 = G__25082;
chunk__25038_25071 = G__25083;
count__25039_25072 = G__25084;
i__25040_25073 = G__25085;
continue;
} else {
var req_25086 = cljs.core.first.call(null,seq__25037_25080__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_25086,prov);


var G__25087 = cljs.core.next.call(null,seq__25037_25080__$1);
var G__25088 = null;
var G__25089 = (0);
var G__25090 = (0);
seq__25037_25070 = G__25087;
chunk__25038_25071 = G__25088;
count__25039_25072 = G__25089;
i__25040_25073 = G__25090;
continue;
}
} else {
}
}
break;
}


var G__25091 = cljs.core.next.call(null,seq__25029__$1);
var G__25092 = null;
var G__25093 = (0);
var G__25094 = (0);
seq__25029 = G__25091;
chunk__25030 = G__25092;
count__25031 = G__25093;
i__25032 = G__25094;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel.client.file_reloading.figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__25095_25099 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__25096_25100 = null;
var count__25097_25101 = (0);
var i__25098_25102 = (0);
while(true){
if((i__25098_25102 < count__25097_25101)){
var ns_25103 = cljs.core._nth.call(null,chunk__25096_25100,i__25098_25102);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_25103);


var G__25104 = seq__25095_25099;
var G__25105 = chunk__25096_25100;
var G__25106 = count__25097_25101;
var G__25107 = (i__25098_25102 + (1));
seq__25095_25099 = G__25104;
chunk__25096_25100 = G__25105;
count__25097_25101 = G__25106;
i__25098_25102 = G__25107;
continue;
} else {
var temp__5457__auto___25108 = cljs.core.seq.call(null,seq__25095_25099);
if(temp__5457__auto___25108){
var seq__25095_25109__$1 = temp__5457__auto___25108;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__25095_25109__$1)){
var c__4318__auto___25110 = cljs.core.chunk_first.call(null,seq__25095_25109__$1);
var G__25111 = cljs.core.chunk_rest.call(null,seq__25095_25109__$1);
var G__25112 = c__4318__auto___25110;
var G__25113 = cljs.core.count.call(null,c__4318__auto___25110);
var G__25114 = (0);
seq__25095_25099 = G__25111;
chunk__25096_25100 = G__25112;
count__25097_25101 = G__25113;
i__25098_25102 = G__25114;
continue;
} else {
var ns_25115 = cljs.core.first.call(null,seq__25095_25109__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_25115);


var G__25116 = cljs.core.next.call(null,seq__25095_25109__$1);
var G__25117 = null;
var G__25118 = (0);
var G__25119 = (0);
seq__25095_25099 = G__25116;
chunk__25096_25100 = G__25117;
count__25097_25101 = G__25118;
i__25098_25102 = G__25119;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__3921__auto__ = goog.require__;
if(cljs.core.truth_(or__3921__auto__)){
return or__3921__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__25120__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__25120 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__25121__i = 0, G__25121__a = new Array(arguments.length -  0);
while (G__25121__i < G__25121__a.length) {G__25121__a[G__25121__i] = arguments[G__25121__i + 0]; ++G__25121__i;}
  args = new cljs.core.IndexedSeq(G__25121__a,0,null);
} 
return G__25120__delegate.call(this,args);};
G__25120.cljs$lang$maxFixedArity = 0;
G__25120.cljs$lang$applyTo = (function (arglist__25122){
var args = cljs.core.seq(arglist__25122);
return G__25120__delegate(args);
});
G__25120.cljs$core$IFn$_invoke$arity$variadic = G__25120__delegate;
return G__25120;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
return (
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
)
;
}
});
figwheel.client.file_reloading.gloader = ((typeof goog.net.jsloader.safeLoad !== 'undefined')?(function (p1__25123_SHARP_,p2__25124_SHARP_){
return goog.net.jsloader.safeLoad(goog.html.legacyconversions.trustedResourceUrlFromString([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__25123_SHARP_)].join('')),p2__25124_SHARP_);
}):((typeof goog.net.jsloader.load !== 'undefined')?(function (p1__25125_SHARP_,p2__25126_SHARP_){
return goog.net.jsloader.load([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__25125_SHARP_)].join(''),p2__25126_SHARP_);
}):(function(){throw cljs.core.ex_info.call(null,"No remote script loading function found.",cljs.core.PersistentArrayMap.EMPTY)})()
));
figwheel.client.file_reloading.reload_file_in_html_env = (function figwheel$client$file_reloading$reload_file_in_html_env(request_url,callback){

var G__25127 = figwheel.client.file_reloading.gloader.call(null,figwheel.client.file_reloading.add_cache_buster.call(null,request_url),({"cleanupWhenDone": true}));
G__25127.addCallback(((function (G__25127){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(G__25127))
);

G__25127.addErrback(((function (G__25127){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(G__25127))
);

return G__25127;
});
figwheel.client.file_reloading.write_script_tag_import = figwheel.client.file_reloading.reload_file_in_html_env;
goog.exportSymbol('figwheel.client.file_reloading.write_script_tag_import', figwheel.client.file_reloading.write_script_tag_import);
figwheel.client.file_reloading.worker_import_script = (function figwheel$client$file_reloading$worker_import_script(request_url,callback){

return callback.call(null,(function (){try{self.importScripts(figwheel.client.file_reloading.add_cache_buster.call(null,request_url));

return true;
}catch (e25128){if((e25128 instanceof Error)){
var e = e25128;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e25128;

}
}})());
});
goog.exportSymbol('figwheel.client.file_reloading.worker_import_script', figwheel.client.file_reloading.worker_import_script);
figwheel.client.file_reloading.create_node_script_import_fn = (function figwheel$client$file_reloading$create_node_script_import_fn(){
var node_path_lib = require("path");
var util_pattern = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.sep),cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_path_lib.join("goog","bootstrap","nodejs.js"))].join('');
var util_path = goog.object.findKey(require.cache,((function (node_path_lib,util_pattern){
return (function (v,k,o){
return goog.string.endsWith(k,util_pattern);
});})(node_path_lib,util_pattern))
);
var parts = cljs.core.pop.call(null,cljs.core.pop.call(null,clojure.string.split.call(null,util_path,/[\/\\]/)));
var root_path = clojure.string.join.call(null,node_path_lib.sep,parts);
return ((function (node_path_lib,util_pattern,util_path,parts,root_path){
return (function (request_url,callback){

var cache_path = node_path_lib.resolve(root_path,request_url);
goog.object.remove(require.cache,cache_path);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e25129){if((e25129 instanceof Error)){
var e = e25129;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e25129;

}
}})());
});
;})(node_path_lib,util_pattern,util_path,parts,root_path))
});
goog.exportSymbol('figwheel.client.file_reloading.create_node_script_import_fn', figwheel.client.file_reloading.create_node_script_import_fn);
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__25130 = cljs.core._EQ_;
var expr__25131 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__25130.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__25131))){
return figwheel.client.file_reloading.create_node_script_import_fn.call(null);
} else {
if(cljs.core.truth_(pred__25130.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__25131))){
return figwheel.client.file_reloading.write_script_tag_import;
} else {
if(cljs.core.truth_(pred__25130.call(null,new cljs.core.Keyword(null,"worker","worker",938239996),expr__25131))){
return figwheel.client.file_reloading.worker_import_script;
} else {
return ((function (pred__25130,expr__25131){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__25130,expr__25131))
}
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__25133,callback){
var map__25134 = p__25133;
var map__25134__$1 = ((((!((map__25134 == null)))?(((((map__25134.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25134.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25134):map__25134);
var file_msg = map__25134__$1;
var request_url = cljs.core.get.call(null,map__25134__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,["FigWheel: Attempting to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return (function (){var or__3921__auto__ = goog.object.get(goog.global,"FIGWHEEL_IMPORT_SCRIPT");
if(cljs.core.truth_(or__3921__auto__)){
return or__3921__auto__;
} else {
return figwheel.client.file_reloading.reload_file_STAR_;
}
})().call(null,request_url,((function (map__25134,map__25134__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,["FigWheel: Successfully loaded ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Figwheel: Error loading file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__25134,map__25134__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__23296__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23296__auto__){
return (function (){
var f__23297__auto__ = (function (){var switch__23273__auto__ = ((function (c__23296__auto__){
return (function (state_25172){
var state_val_25173 = (state_25172[(1)]);
if((state_val_25173 === (7))){
var inst_25168 = (state_25172[(2)]);
var state_25172__$1 = state_25172;
var statearr_25174_25200 = state_25172__$1;
(statearr_25174_25200[(2)] = inst_25168);

(statearr_25174_25200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25173 === (1))){
var state_25172__$1 = state_25172;
var statearr_25175_25201 = state_25172__$1;
(statearr_25175_25201[(2)] = null);

(statearr_25175_25201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25173 === (4))){
var inst_25138 = (state_25172[(7)]);
var inst_25138__$1 = (state_25172[(2)]);
var state_25172__$1 = (function (){var statearr_25176 = state_25172;
(statearr_25176[(7)] = inst_25138__$1);

return statearr_25176;
})();
if(cljs.core.truth_(inst_25138__$1)){
var statearr_25177_25202 = state_25172__$1;
(statearr_25177_25202[(1)] = (5));

} else {
var statearr_25178_25203 = state_25172__$1;
(statearr_25178_25203[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25173 === (15))){
var inst_25153 = (state_25172[(8)]);
var inst_25151 = (state_25172[(9)]);
var inst_25155 = inst_25153.call(null,inst_25151);
var state_25172__$1 = state_25172;
var statearr_25179_25204 = state_25172__$1;
(statearr_25179_25204[(2)] = inst_25155);

(statearr_25179_25204[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25173 === (13))){
var inst_25162 = (state_25172[(2)]);
var state_25172__$1 = state_25172;
var statearr_25180_25205 = state_25172__$1;
(statearr_25180_25205[(2)] = inst_25162);

(statearr_25180_25205[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25173 === (6))){
var state_25172__$1 = state_25172;
var statearr_25181_25206 = state_25172__$1;
(statearr_25181_25206[(2)] = null);

(statearr_25181_25206[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25173 === (17))){
var inst_25159 = (state_25172[(2)]);
var state_25172__$1 = state_25172;
var statearr_25182_25207 = state_25172__$1;
(statearr_25182_25207[(2)] = inst_25159);

(statearr_25182_25207[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25173 === (3))){
var inst_25170 = (state_25172[(2)]);
var state_25172__$1 = state_25172;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25172__$1,inst_25170);
} else {
if((state_val_25173 === (12))){
var state_25172__$1 = state_25172;
var statearr_25183_25208 = state_25172__$1;
(statearr_25183_25208[(2)] = null);

(statearr_25183_25208[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25173 === (2))){
var state_25172__$1 = state_25172;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25172__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_25173 === (11))){
var inst_25143 = (state_25172[(10)]);
var inst_25149 = figwheel.client.file_reloading.blocking_load.call(null,inst_25143);
var state_25172__$1 = state_25172;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25172__$1,(14),inst_25149);
} else {
if((state_val_25173 === (9))){
var inst_25143 = (state_25172[(10)]);
var state_25172__$1 = state_25172;
if(cljs.core.truth_(inst_25143)){
var statearr_25184_25209 = state_25172__$1;
(statearr_25184_25209[(1)] = (11));

} else {
var statearr_25185_25210 = state_25172__$1;
(statearr_25185_25210[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25173 === (5))){
var inst_25138 = (state_25172[(7)]);
var inst_25144 = (state_25172[(11)]);
var inst_25143 = cljs.core.nth.call(null,inst_25138,(0),null);
var inst_25144__$1 = cljs.core.nth.call(null,inst_25138,(1),null);
var state_25172__$1 = (function (){var statearr_25186 = state_25172;
(statearr_25186[(10)] = inst_25143);

(statearr_25186[(11)] = inst_25144__$1);

return statearr_25186;
})();
if(cljs.core.truth_(inst_25144__$1)){
var statearr_25187_25211 = state_25172__$1;
(statearr_25187_25211[(1)] = (8));

} else {
var statearr_25188_25212 = state_25172__$1;
(statearr_25188_25212[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25173 === (14))){
var inst_25153 = (state_25172[(8)]);
var inst_25143 = (state_25172[(10)]);
var inst_25151 = (state_25172[(2)]);
var inst_25152 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_25153__$1 = cljs.core.get.call(null,inst_25152,inst_25143);
var state_25172__$1 = (function (){var statearr_25189 = state_25172;
(statearr_25189[(8)] = inst_25153__$1);

(statearr_25189[(9)] = inst_25151);

return statearr_25189;
})();
if(cljs.core.truth_(inst_25153__$1)){
var statearr_25190_25213 = state_25172__$1;
(statearr_25190_25213[(1)] = (15));

} else {
var statearr_25191_25214 = state_25172__$1;
(statearr_25191_25214[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25173 === (16))){
var inst_25151 = (state_25172[(9)]);
var inst_25157 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_25151);
var state_25172__$1 = state_25172;
var statearr_25192_25215 = state_25172__$1;
(statearr_25192_25215[(2)] = inst_25157);

(statearr_25192_25215[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25173 === (10))){
var inst_25164 = (state_25172[(2)]);
var state_25172__$1 = (function (){var statearr_25193 = state_25172;
(statearr_25193[(12)] = inst_25164);

return statearr_25193;
})();
var statearr_25194_25216 = state_25172__$1;
(statearr_25194_25216[(2)] = null);

(statearr_25194_25216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25173 === (8))){
var inst_25144 = (state_25172[(11)]);
var inst_25146 = eval(inst_25144);
var state_25172__$1 = state_25172;
var statearr_25195_25217 = state_25172__$1;
(statearr_25195_25217[(2)] = inst_25146);

(statearr_25195_25217[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23296__auto__))
;
return ((function (switch__23273__auto__,c__23296__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__23274__auto__ = null;
var figwheel$client$file_reloading$state_machine__23274__auto____0 = (function (){
var statearr_25196 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25196[(0)] = figwheel$client$file_reloading$state_machine__23274__auto__);

(statearr_25196[(1)] = (1));

return statearr_25196;
});
var figwheel$client$file_reloading$state_machine__23274__auto____1 = (function (state_25172){
while(true){
var ret_value__23275__auto__ = (function (){try{while(true){
var result__23276__auto__ = switch__23273__auto__.call(null,state_25172);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23276__auto__;
}
break;
}
}catch (e25197){if((e25197 instanceof Object)){
var ex__23277__auto__ = e25197;
var statearr_25198_25218 = state_25172;
(statearr_25198_25218[(5)] = ex__23277__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25172);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25197;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23275__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25219 = state_25172;
state_25172 = G__25219;
continue;
} else {
return ret_value__23275__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__23274__auto__ = function(state_25172){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__23274__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__23274__auto____1.call(this,state_25172);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$state_machine__23274__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__23274__auto____0;
figwheel$client$file_reloading$state_machine__23274__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__23274__auto____1;
return figwheel$client$file_reloading$state_machine__23274__auto__;
})()
;})(switch__23273__auto__,c__23296__auto__))
})();
var state__23298__auto__ = (function (){var statearr_25199 = f__23297__auto__.call(null);
(statearr_25199[(6)] = c__23296__auto__);

return statearr_25199;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23298__auto__);
});})(c__23296__auto__))
);

return c__23296__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(var_args){
var G__25221 = arguments.length;
switch (G__25221) {
case 1:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$1 = (function (url){
return figwheel.client.file_reloading.queued_file_reload.call(null,url,null);
});

figwheel.client.file_reloading.queued_file_reload.cljs$core$IFn$_invoke$arity$2 = (function (url,opt_source_text){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,opt_source_text], null));
});

figwheel.client.file_reloading.queued_file_reload.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__25223,callback){
var map__25224 = p__25223;
var map__25224__$1 = ((((!((map__25224 == null)))?(((((map__25224.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25224.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25224):map__25224);
var file_msg = map__25224__$1;
var namespace = cljs.core.get.call(null,map__25224__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__25224,map__25224__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__25224,map__25224__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.figwheel_no_load_QMARK_ = (function figwheel$client$file_reloading$figwheel_no_load_QMARK_(p__25226){
var map__25227 = p__25226;
var map__25227__$1 = ((((!((map__25227 == null)))?(((((map__25227.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25227.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25227):map__25227);
var file_msg = map__25227__$1;
var namespace = cljs.core.get.call(null,map__25227__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
});
figwheel.client.file_reloading.ns_exists_QMARK_ = (function figwheel$client$file_reloading$ns_exists_QMARK_(namespace){
return !((cljs.core.reduce.call(null,cljs.core.fnil.call(null,goog.object.get,({})),goog.global,clojure.string.split.call(null,cljs.core.name.call(null,namespace),".")) == null));
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__25229){
var map__25230 = p__25229;
var map__25230__$1 = ((((!((map__25230 == null)))?(((((map__25230.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25230.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25230):map__25230);
var file_msg = map__25230__$1;
var namespace = cljs.core.get.call(null,map__25230__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__3910__auto__ = cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,file_msg));
if(and__3910__auto__){
var or__3921__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__3921__auto__)){
return or__3921__auto__;
} else {
var or__3921__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__3921__auto____$1)){
return or__3921__auto____$1;
} else {
var or__3921__auto____$2 = figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
if(cljs.core.truth_(or__3921__auto____$2)){
return or__3921__auto____$2;
} else {
return figwheel.client.file_reloading.ns_exists_QMARK_.call(null,namespace);
}
}
}
} else {
return and__3910__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__25232,callback){
var map__25233 = p__25232;
var map__25233__$1 = ((((!((map__25233 == null)))?(((((map__25233.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25233.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25233):map__25233);
var file_msg = map__25233__$1;
var request_url = cljs.core.get.call(null,map__25233__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__25233__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,["Figwheel: Not trying to load file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__23296__auto___25283 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23296__auto___25283,out){
return (function (){
var f__23297__auto__ = (function (){var switch__23273__auto__ = ((function (c__23296__auto___25283,out){
return (function (state_25268){
var state_val_25269 = (state_25268[(1)]);
if((state_val_25269 === (1))){
var inst_25242 = cljs.core.seq.call(null,files);
var inst_25243 = cljs.core.first.call(null,inst_25242);
var inst_25244 = cljs.core.next.call(null,inst_25242);
var inst_25245 = files;
var state_25268__$1 = (function (){var statearr_25270 = state_25268;
(statearr_25270[(7)] = inst_25243);

(statearr_25270[(8)] = inst_25244);

(statearr_25270[(9)] = inst_25245);

return statearr_25270;
})();
var statearr_25271_25284 = state_25268__$1;
(statearr_25271_25284[(2)] = null);

(statearr_25271_25284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25269 === (2))){
var inst_25245 = (state_25268[(9)]);
var inst_25251 = (state_25268[(10)]);
var inst_25250 = cljs.core.seq.call(null,inst_25245);
var inst_25251__$1 = cljs.core.first.call(null,inst_25250);
var inst_25252 = cljs.core.next.call(null,inst_25250);
var inst_25253 = (inst_25251__$1 == null);
var inst_25254 = cljs.core.not.call(null,inst_25253);
var state_25268__$1 = (function (){var statearr_25272 = state_25268;
(statearr_25272[(11)] = inst_25252);

(statearr_25272[(10)] = inst_25251__$1);

return statearr_25272;
})();
if(inst_25254){
var statearr_25273_25285 = state_25268__$1;
(statearr_25273_25285[(1)] = (4));

} else {
var statearr_25274_25286 = state_25268__$1;
(statearr_25274_25286[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25269 === (3))){
var inst_25266 = (state_25268[(2)]);
var state_25268__$1 = state_25268;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25268__$1,inst_25266);
} else {
if((state_val_25269 === (4))){
var inst_25251 = (state_25268[(10)]);
var inst_25256 = figwheel.client.file_reloading.reload_js_file.call(null,inst_25251);
var state_25268__$1 = state_25268;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25268__$1,(7),inst_25256);
} else {
if((state_val_25269 === (5))){
var inst_25262 = cljs.core.async.close_BANG_.call(null,out);
var state_25268__$1 = state_25268;
var statearr_25275_25287 = state_25268__$1;
(statearr_25275_25287[(2)] = inst_25262);

(statearr_25275_25287[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25269 === (6))){
var inst_25264 = (state_25268[(2)]);
var state_25268__$1 = state_25268;
var statearr_25276_25288 = state_25268__$1;
(statearr_25276_25288[(2)] = inst_25264);

(statearr_25276_25288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25269 === (7))){
var inst_25252 = (state_25268[(11)]);
var inst_25258 = (state_25268[(2)]);
var inst_25259 = cljs.core.async.put_BANG_.call(null,out,inst_25258);
var inst_25245 = inst_25252;
var state_25268__$1 = (function (){var statearr_25277 = state_25268;
(statearr_25277[(12)] = inst_25259);

(statearr_25277[(9)] = inst_25245);

return statearr_25277;
})();
var statearr_25278_25289 = state_25268__$1;
(statearr_25278_25289[(2)] = null);

(statearr_25278_25289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__23296__auto___25283,out))
;
return ((function (switch__23273__auto__,c__23296__auto___25283,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23274__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23274__auto____0 = (function (){
var statearr_25279 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25279[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23274__auto__);

(statearr_25279[(1)] = (1));

return statearr_25279;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__23274__auto____1 = (function (state_25268){
while(true){
var ret_value__23275__auto__ = (function (){try{while(true){
var result__23276__auto__ = switch__23273__auto__.call(null,state_25268);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23276__auto__;
}
break;
}
}catch (e25280){if((e25280 instanceof Object)){
var ex__23277__auto__ = e25280;
var statearr_25281_25290 = state_25268;
(statearr_25281_25290[(5)] = ex__23277__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25268);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25280;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23275__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25291 = state_25268;
state_25268 = G__25291;
continue;
} else {
return ret_value__23275__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23274__auto__ = function(state_25268){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23274__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23274__auto____1.call(this,state_25268);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23274__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23274__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__23274__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__23274__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__23274__auto__;
})()
;})(switch__23273__auto__,c__23296__auto___25283,out))
})();
var state__23298__auto__ = (function (){var statearr_25282 = f__23297__auto__.call(null);
(statearr_25282[(6)] = c__23296__auto___25283);

return statearr_25282;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23298__auto__);
});})(c__23296__auto___25283,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__25292,opts){
var map__25293 = p__25292;
var map__25293__$1 = ((((!((map__25293 == null)))?(((((map__25293.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25293.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25293):map__25293);
var eval_body = cljs.core.get.call(null,map__25293__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__25293__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__3910__auto__ = eval_body;
if(cljs.core.truth_(and__3910__auto__)){
return typeof eval_body === 'string';
} else {
return and__3910__auto__;
}
})())){
var code = eval_body;
try{figwheel.client.utils.debug_prn.call(null,["Evaling file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e25295){var e = e25295;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),["Unable to evaluate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,cljs.core.partial.call(null,cljs.core.re_matches,/figwheel\.connect.*/),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__5455__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__25296_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__25296_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__5455__auto__)){
var file_msg = temp__5455__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__25297){
var vec__25298 = p__25297;
var k = cljs.core.nth.call(null,vec__25298,(0),null);
var v = cljs.core.nth.call(null,vec__25298,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__25301){
var vec__25302 = p__25301;
var k = cljs.core.nth.call(null,vec__25302,(0),null);
var v = cljs.core.nth.call(null,vec__25302,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__25308,p__25309){
var map__25310 = p__25308;
var map__25310__$1 = ((((!((map__25310 == null)))?(((((map__25310.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25310.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25310):map__25310);
var opts = map__25310__$1;
var before_jsload = cljs.core.get.call(null,map__25310__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__25310__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__25310__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__25311 = p__25309;
var map__25311__$1 = ((((!((map__25311 == null)))?(((((map__25311.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25311.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25311):map__25311);
var msg = map__25311__$1;
var files = cljs.core.get.call(null,map__25311__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__25311__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__25311__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__23296__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__23297__auto__ = (function (){var switch__23273__auto__ = ((function (c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_25465){
var state_val_25466 = (state_25465[(1)]);
if((state_val_25466 === (7))){
var inst_25325 = (state_25465[(7)]);
var inst_25326 = (state_25465[(8)]);
var inst_25327 = (state_25465[(9)]);
var inst_25328 = (state_25465[(10)]);
var inst_25333 = cljs.core._nth.call(null,inst_25326,inst_25328);
var inst_25334 = figwheel.client.file_reloading.eval_body.call(null,inst_25333,opts);
var inst_25335 = (inst_25328 + (1));
var tmp25467 = inst_25325;
var tmp25468 = inst_25326;
var tmp25469 = inst_25327;
var inst_25325__$1 = tmp25467;
var inst_25326__$1 = tmp25468;
var inst_25327__$1 = tmp25469;
var inst_25328__$1 = inst_25335;
var state_25465__$1 = (function (){var statearr_25470 = state_25465;
(statearr_25470[(7)] = inst_25325__$1);

(statearr_25470[(11)] = inst_25334);

(statearr_25470[(8)] = inst_25326__$1);

(statearr_25470[(9)] = inst_25327__$1);

(statearr_25470[(10)] = inst_25328__$1);

return statearr_25470;
})();
var statearr_25471_25554 = state_25465__$1;
(statearr_25471_25554[(2)] = null);

(statearr_25471_25554[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (20))){
var inst_25368 = (state_25465[(12)]);
var inst_25376 = figwheel.client.file_reloading.sort_files.call(null,inst_25368);
var state_25465__$1 = state_25465;
var statearr_25472_25555 = state_25465__$1;
(statearr_25472_25555[(2)] = inst_25376);

(statearr_25472_25555[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (27))){
var state_25465__$1 = state_25465;
var statearr_25473_25556 = state_25465__$1;
(statearr_25473_25556[(2)] = null);

(statearr_25473_25556[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (1))){
var inst_25317 = (state_25465[(13)]);
var inst_25314 = before_jsload.call(null,files);
var inst_25315 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_25316 = (function (){return ((function (inst_25317,inst_25314,inst_25315,state_val_25466,c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__25305_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__25305_SHARP_);
});
;})(inst_25317,inst_25314,inst_25315,state_val_25466,c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25317__$1 = cljs.core.filter.call(null,inst_25316,files);
var inst_25318 = cljs.core.not_empty.call(null,inst_25317__$1);
var state_25465__$1 = (function (){var statearr_25474 = state_25465;
(statearr_25474[(14)] = inst_25315);

(statearr_25474[(13)] = inst_25317__$1);

(statearr_25474[(15)] = inst_25314);

return statearr_25474;
})();
if(cljs.core.truth_(inst_25318)){
var statearr_25475_25557 = state_25465__$1;
(statearr_25475_25557[(1)] = (2));

} else {
var statearr_25476_25558 = state_25465__$1;
(statearr_25476_25558[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (24))){
var state_25465__$1 = state_25465;
var statearr_25477_25559 = state_25465__$1;
(statearr_25477_25559[(2)] = null);

(statearr_25477_25559[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (39))){
var inst_25418 = (state_25465[(16)]);
var state_25465__$1 = state_25465;
var statearr_25478_25560 = state_25465__$1;
(statearr_25478_25560[(2)] = inst_25418);

(statearr_25478_25560[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (46))){
var inst_25460 = (state_25465[(2)]);
var state_25465__$1 = state_25465;
var statearr_25479_25561 = state_25465__$1;
(statearr_25479_25561[(2)] = inst_25460);

(statearr_25479_25561[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (4))){
var inst_25362 = (state_25465[(2)]);
var inst_25363 = cljs.core.List.EMPTY;
var inst_25364 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_25363);
var inst_25365 = (function (){return ((function (inst_25362,inst_25363,inst_25364,state_val_25466,c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__25306_SHARP_){
var and__3910__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__25306_SHARP_);
if(cljs.core.truth_(and__3910__auto__)){
return ((cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__25306_SHARP_))) && (cljs.core.not.call(null,figwheel.client.file_reloading.figwheel_no_load_QMARK_.call(null,p1__25306_SHARP_))));
} else {
return and__3910__auto__;
}
});
;})(inst_25362,inst_25363,inst_25364,state_val_25466,c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25366 = cljs.core.filter.call(null,inst_25365,files);
var inst_25367 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_25368 = cljs.core.concat.call(null,inst_25366,inst_25367);
var state_25465__$1 = (function (){var statearr_25480 = state_25465;
(statearr_25480[(17)] = inst_25364);

(statearr_25480[(18)] = inst_25362);

(statearr_25480[(12)] = inst_25368);

return statearr_25480;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_25481_25562 = state_25465__$1;
(statearr_25481_25562[(1)] = (16));

} else {
var statearr_25482_25563 = state_25465__$1;
(statearr_25482_25563[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (15))){
var inst_25352 = (state_25465[(2)]);
var state_25465__$1 = state_25465;
var statearr_25483_25564 = state_25465__$1;
(statearr_25483_25564[(2)] = inst_25352);

(statearr_25483_25564[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (21))){
var inst_25378 = (state_25465[(19)]);
var inst_25378__$1 = (state_25465[(2)]);
var inst_25379 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_25378__$1);
var state_25465__$1 = (function (){var statearr_25484 = state_25465;
(statearr_25484[(19)] = inst_25378__$1);

return statearr_25484;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25465__$1,(22),inst_25379);
} else {
if((state_val_25466 === (31))){
var inst_25463 = (state_25465[(2)]);
var state_25465__$1 = state_25465;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25465__$1,inst_25463);
} else {
if((state_val_25466 === (32))){
var inst_25418 = (state_25465[(16)]);
var inst_25423 = inst_25418.cljs$lang$protocol_mask$partition0$;
var inst_25424 = (inst_25423 & (64));
var inst_25425 = inst_25418.cljs$core$ISeq$;
var inst_25426 = (cljs.core.PROTOCOL_SENTINEL === inst_25425);
var inst_25427 = ((inst_25424) || (inst_25426));
var state_25465__$1 = state_25465;
if(cljs.core.truth_(inst_25427)){
var statearr_25485_25565 = state_25465__$1;
(statearr_25485_25565[(1)] = (35));

} else {
var statearr_25486_25566 = state_25465__$1;
(statearr_25486_25566[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (40))){
var inst_25440 = (state_25465[(20)]);
var inst_25439 = (state_25465[(2)]);
var inst_25440__$1 = cljs.core.get.call(null,inst_25439,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_25441 = cljs.core.get.call(null,inst_25439,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_25442 = cljs.core.not_empty.call(null,inst_25440__$1);
var state_25465__$1 = (function (){var statearr_25487 = state_25465;
(statearr_25487[(21)] = inst_25441);

(statearr_25487[(20)] = inst_25440__$1);

return statearr_25487;
})();
if(cljs.core.truth_(inst_25442)){
var statearr_25488_25567 = state_25465__$1;
(statearr_25488_25567[(1)] = (41));

} else {
var statearr_25489_25568 = state_25465__$1;
(statearr_25489_25568[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (33))){
var state_25465__$1 = state_25465;
var statearr_25490_25569 = state_25465__$1;
(statearr_25490_25569[(2)] = false);

(statearr_25490_25569[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (13))){
var inst_25338 = (state_25465[(22)]);
var inst_25342 = cljs.core.chunk_first.call(null,inst_25338);
var inst_25343 = cljs.core.chunk_rest.call(null,inst_25338);
var inst_25344 = cljs.core.count.call(null,inst_25342);
var inst_25325 = inst_25343;
var inst_25326 = inst_25342;
var inst_25327 = inst_25344;
var inst_25328 = (0);
var state_25465__$1 = (function (){var statearr_25491 = state_25465;
(statearr_25491[(7)] = inst_25325);

(statearr_25491[(8)] = inst_25326);

(statearr_25491[(9)] = inst_25327);

(statearr_25491[(10)] = inst_25328);

return statearr_25491;
})();
var statearr_25492_25570 = state_25465__$1;
(statearr_25492_25570[(2)] = null);

(statearr_25492_25570[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (22))){
var inst_25378 = (state_25465[(19)]);
var inst_25382 = (state_25465[(23)]);
var inst_25381 = (state_25465[(24)]);
var inst_25386 = (state_25465[(25)]);
var inst_25381__$1 = (state_25465[(2)]);
var inst_25382__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_25381__$1);
var inst_25383 = (function (){var all_files = inst_25378;
var res_SINGLEQUOTE_ = inst_25381__$1;
var res = inst_25382__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_25378,inst_25382,inst_25381,inst_25386,inst_25381__$1,inst_25382__$1,state_val_25466,c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__25307_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__25307_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_25378,inst_25382,inst_25381,inst_25386,inst_25381__$1,inst_25382__$1,state_val_25466,c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25384 = cljs.core.filter.call(null,inst_25383,inst_25381__$1);
var inst_25385 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_25386__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_25385);
var inst_25387 = cljs.core.not_empty.call(null,inst_25386__$1);
var state_25465__$1 = (function (){var statearr_25493 = state_25465;
(statearr_25493[(26)] = inst_25384);

(statearr_25493[(23)] = inst_25382__$1);

(statearr_25493[(24)] = inst_25381__$1);

(statearr_25493[(25)] = inst_25386__$1);

return statearr_25493;
})();
if(cljs.core.truth_(inst_25387)){
var statearr_25494_25571 = state_25465__$1;
(statearr_25494_25571[(1)] = (23));

} else {
var statearr_25495_25572 = state_25465__$1;
(statearr_25495_25572[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (36))){
var state_25465__$1 = state_25465;
var statearr_25496_25573 = state_25465__$1;
(statearr_25496_25573[(2)] = false);

(statearr_25496_25573[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (41))){
var inst_25440 = (state_25465[(20)]);
var inst_25444 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_25445 = cljs.core.map.call(null,inst_25444,inst_25440);
var inst_25446 = cljs.core.pr_str.call(null,inst_25445);
var inst_25447 = ["figwheel-no-load meta-data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25446)].join('');
var inst_25448 = figwheel.client.utils.log.call(null,inst_25447);
var state_25465__$1 = state_25465;
var statearr_25497_25574 = state_25465__$1;
(statearr_25497_25574[(2)] = inst_25448);

(statearr_25497_25574[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (43))){
var inst_25441 = (state_25465[(21)]);
var inst_25451 = (state_25465[(2)]);
var inst_25452 = cljs.core.not_empty.call(null,inst_25441);
var state_25465__$1 = (function (){var statearr_25498 = state_25465;
(statearr_25498[(27)] = inst_25451);

return statearr_25498;
})();
if(cljs.core.truth_(inst_25452)){
var statearr_25499_25575 = state_25465__$1;
(statearr_25499_25575[(1)] = (44));

} else {
var statearr_25500_25576 = state_25465__$1;
(statearr_25500_25576[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (29))){
var inst_25384 = (state_25465[(26)]);
var inst_25378 = (state_25465[(19)]);
var inst_25418 = (state_25465[(16)]);
var inst_25382 = (state_25465[(23)]);
var inst_25381 = (state_25465[(24)]);
var inst_25386 = (state_25465[(25)]);
var inst_25414 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_25417 = (function (){var all_files = inst_25378;
var res_SINGLEQUOTE_ = inst_25381;
var res = inst_25382;
var files_not_loaded = inst_25384;
var dependencies_that_loaded = inst_25386;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25384,inst_25378,inst_25418,inst_25382,inst_25381,inst_25386,inst_25414,state_val_25466,c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__25416){
var map__25501 = p__25416;
var map__25501__$1 = ((((!((map__25501 == null)))?(((((map__25501.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25501.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25501):map__25501);
var namespace = cljs.core.get.call(null,map__25501__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25384,inst_25378,inst_25418,inst_25382,inst_25381,inst_25386,inst_25414,state_val_25466,c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25418__$1 = cljs.core.group_by.call(null,inst_25417,inst_25384);
var inst_25420 = (inst_25418__$1 == null);
var inst_25421 = cljs.core.not.call(null,inst_25420);
var state_25465__$1 = (function (){var statearr_25503 = state_25465;
(statearr_25503[(16)] = inst_25418__$1);

(statearr_25503[(28)] = inst_25414);

return statearr_25503;
})();
if(inst_25421){
var statearr_25504_25577 = state_25465__$1;
(statearr_25504_25577[(1)] = (32));

} else {
var statearr_25505_25578 = state_25465__$1;
(statearr_25505_25578[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (44))){
var inst_25441 = (state_25465[(21)]);
var inst_25454 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_25441);
var inst_25455 = cljs.core.pr_str.call(null,inst_25454);
var inst_25456 = ["not required: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25455)].join('');
var inst_25457 = figwheel.client.utils.log.call(null,inst_25456);
var state_25465__$1 = state_25465;
var statearr_25506_25579 = state_25465__$1;
(statearr_25506_25579[(2)] = inst_25457);

(statearr_25506_25579[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (6))){
var inst_25359 = (state_25465[(2)]);
var state_25465__$1 = state_25465;
var statearr_25507_25580 = state_25465__$1;
(statearr_25507_25580[(2)] = inst_25359);

(statearr_25507_25580[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (28))){
var inst_25384 = (state_25465[(26)]);
var inst_25411 = (state_25465[(2)]);
var inst_25412 = cljs.core.not_empty.call(null,inst_25384);
var state_25465__$1 = (function (){var statearr_25508 = state_25465;
(statearr_25508[(29)] = inst_25411);

return statearr_25508;
})();
if(cljs.core.truth_(inst_25412)){
var statearr_25509_25581 = state_25465__$1;
(statearr_25509_25581[(1)] = (29));

} else {
var statearr_25510_25582 = state_25465__$1;
(statearr_25510_25582[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (25))){
var inst_25382 = (state_25465[(23)]);
var inst_25398 = (state_25465[(2)]);
var inst_25399 = cljs.core.not_empty.call(null,inst_25382);
var state_25465__$1 = (function (){var statearr_25511 = state_25465;
(statearr_25511[(30)] = inst_25398);

return statearr_25511;
})();
if(cljs.core.truth_(inst_25399)){
var statearr_25512_25583 = state_25465__$1;
(statearr_25512_25583[(1)] = (26));

} else {
var statearr_25513_25584 = state_25465__$1;
(statearr_25513_25584[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (34))){
var inst_25434 = (state_25465[(2)]);
var state_25465__$1 = state_25465;
if(cljs.core.truth_(inst_25434)){
var statearr_25514_25585 = state_25465__$1;
(statearr_25514_25585[(1)] = (38));

} else {
var statearr_25515_25586 = state_25465__$1;
(statearr_25515_25586[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (17))){
var state_25465__$1 = state_25465;
var statearr_25516_25587 = state_25465__$1;
(statearr_25516_25587[(2)] = recompile_dependents);

(statearr_25516_25587[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (3))){
var state_25465__$1 = state_25465;
var statearr_25517_25588 = state_25465__$1;
(statearr_25517_25588[(2)] = null);

(statearr_25517_25588[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (12))){
var inst_25355 = (state_25465[(2)]);
var state_25465__$1 = state_25465;
var statearr_25518_25589 = state_25465__$1;
(statearr_25518_25589[(2)] = inst_25355);

(statearr_25518_25589[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (2))){
var inst_25317 = (state_25465[(13)]);
var inst_25324 = cljs.core.seq.call(null,inst_25317);
var inst_25325 = inst_25324;
var inst_25326 = null;
var inst_25327 = (0);
var inst_25328 = (0);
var state_25465__$1 = (function (){var statearr_25519 = state_25465;
(statearr_25519[(7)] = inst_25325);

(statearr_25519[(8)] = inst_25326);

(statearr_25519[(9)] = inst_25327);

(statearr_25519[(10)] = inst_25328);

return statearr_25519;
})();
var statearr_25520_25590 = state_25465__$1;
(statearr_25520_25590[(2)] = null);

(statearr_25520_25590[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (23))){
var inst_25384 = (state_25465[(26)]);
var inst_25378 = (state_25465[(19)]);
var inst_25382 = (state_25465[(23)]);
var inst_25381 = (state_25465[(24)]);
var inst_25386 = (state_25465[(25)]);
var inst_25389 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_25391 = (function (){var all_files = inst_25378;
var res_SINGLEQUOTE_ = inst_25381;
var res = inst_25382;
var files_not_loaded = inst_25384;
var dependencies_that_loaded = inst_25386;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25384,inst_25378,inst_25382,inst_25381,inst_25386,inst_25389,state_val_25466,c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__25390){
var map__25521 = p__25390;
var map__25521__$1 = ((((!((map__25521 == null)))?(((((map__25521.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25521.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25521):map__25521);
var request_url = cljs.core.get.call(null,map__25521__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25384,inst_25378,inst_25382,inst_25381,inst_25386,inst_25389,state_val_25466,c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25392 = cljs.core.reverse.call(null,inst_25386);
var inst_25393 = cljs.core.map.call(null,inst_25391,inst_25392);
var inst_25394 = cljs.core.pr_str.call(null,inst_25393);
var inst_25395 = figwheel.client.utils.log.call(null,inst_25394);
var state_25465__$1 = (function (){var statearr_25523 = state_25465;
(statearr_25523[(31)] = inst_25389);

return statearr_25523;
})();
var statearr_25524_25591 = state_25465__$1;
(statearr_25524_25591[(2)] = inst_25395);

(statearr_25524_25591[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (35))){
var state_25465__$1 = state_25465;
var statearr_25525_25592 = state_25465__$1;
(statearr_25525_25592[(2)] = true);

(statearr_25525_25592[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (19))){
var inst_25368 = (state_25465[(12)]);
var inst_25374 = figwheel.client.file_reloading.expand_files.call(null,inst_25368);
var state_25465__$1 = state_25465;
var statearr_25526_25593 = state_25465__$1;
(statearr_25526_25593[(2)] = inst_25374);

(statearr_25526_25593[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (11))){
var state_25465__$1 = state_25465;
var statearr_25527_25594 = state_25465__$1;
(statearr_25527_25594[(2)] = null);

(statearr_25527_25594[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (9))){
var inst_25357 = (state_25465[(2)]);
var state_25465__$1 = state_25465;
var statearr_25528_25595 = state_25465__$1;
(statearr_25528_25595[(2)] = inst_25357);

(statearr_25528_25595[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (5))){
var inst_25327 = (state_25465[(9)]);
var inst_25328 = (state_25465[(10)]);
var inst_25330 = (inst_25328 < inst_25327);
var inst_25331 = inst_25330;
var state_25465__$1 = state_25465;
if(cljs.core.truth_(inst_25331)){
var statearr_25529_25596 = state_25465__$1;
(statearr_25529_25596[(1)] = (7));

} else {
var statearr_25530_25597 = state_25465__$1;
(statearr_25530_25597[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (14))){
var inst_25338 = (state_25465[(22)]);
var inst_25347 = cljs.core.first.call(null,inst_25338);
var inst_25348 = figwheel.client.file_reloading.eval_body.call(null,inst_25347,opts);
var inst_25349 = cljs.core.next.call(null,inst_25338);
var inst_25325 = inst_25349;
var inst_25326 = null;
var inst_25327 = (0);
var inst_25328 = (0);
var state_25465__$1 = (function (){var statearr_25531 = state_25465;
(statearr_25531[(7)] = inst_25325);

(statearr_25531[(32)] = inst_25348);

(statearr_25531[(8)] = inst_25326);

(statearr_25531[(9)] = inst_25327);

(statearr_25531[(10)] = inst_25328);

return statearr_25531;
})();
var statearr_25532_25598 = state_25465__$1;
(statearr_25532_25598[(2)] = null);

(statearr_25532_25598[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (45))){
var state_25465__$1 = state_25465;
var statearr_25533_25599 = state_25465__$1;
(statearr_25533_25599[(2)] = null);

(statearr_25533_25599[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (26))){
var inst_25384 = (state_25465[(26)]);
var inst_25378 = (state_25465[(19)]);
var inst_25382 = (state_25465[(23)]);
var inst_25381 = (state_25465[(24)]);
var inst_25386 = (state_25465[(25)]);
var inst_25401 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_25403 = (function (){var all_files = inst_25378;
var res_SINGLEQUOTE_ = inst_25381;
var res = inst_25382;
var files_not_loaded = inst_25384;
var dependencies_that_loaded = inst_25386;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25384,inst_25378,inst_25382,inst_25381,inst_25386,inst_25401,state_val_25466,c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__25402){
var map__25534 = p__25402;
var map__25534__$1 = ((((!((map__25534 == null)))?(((((map__25534.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25534.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25534):map__25534);
var namespace = cljs.core.get.call(null,map__25534__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__25534__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25384,inst_25378,inst_25382,inst_25381,inst_25386,inst_25401,state_val_25466,c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25404 = cljs.core.map.call(null,inst_25403,inst_25382);
var inst_25405 = cljs.core.pr_str.call(null,inst_25404);
var inst_25406 = figwheel.client.utils.log.call(null,inst_25405);
var inst_25407 = (function (){var all_files = inst_25378;
var res_SINGLEQUOTE_ = inst_25381;
var res = inst_25382;
var files_not_loaded = inst_25384;
var dependencies_that_loaded = inst_25386;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25384,inst_25378,inst_25382,inst_25381,inst_25386,inst_25401,inst_25403,inst_25404,inst_25405,inst_25406,state_val_25466,c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_25384,inst_25378,inst_25382,inst_25381,inst_25386,inst_25401,inst_25403,inst_25404,inst_25405,inst_25406,state_val_25466,c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_25408 = setTimeout(inst_25407,(10));
var state_25465__$1 = (function (){var statearr_25536 = state_25465;
(statearr_25536[(33)] = inst_25406);

(statearr_25536[(34)] = inst_25401);

return statearr_25536;
})();
var statearr_25537_25600 = state_25465__$1;
(statearr_25537_25600[(2)] = inst_25408);

(statearr_25537_25600[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (16))){
var state_25465__$1 = state_25465;
var statearr_25538_25601 = state_25465__$1;
(statearr_25538_25601[(2)] = reload_dependents);

(statearr_25538_25601[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (38))){
var inst_25418 = (state_25465[(16)]);
var inst_25436 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25418);
var state_25465__$1 = state_25465;
var statearr_25539_25602 = state_25465__$1;
(statearr_25539_25602[(2)] = inst_25436);

(statearr_25539_25602[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (30))){
var state_25465__$1 = state_25465;
var statearr_25540_25603 = state_25465__$1;
(statearr_25540_25603[(2)] = null);

(statearr_25540_25603[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (10))){
var inst_25338 = (state_25465[(22)]);
var inst_25340 = cljs.core.chunked_seq_QMARK_.call(null,inst_25338);
var state_25465__$1 = state_25465;
if(inst_25340){
var statearr_25541_25604 = state_25465__$1;
(statearr_25541_25604[(1)] = (13));

} else {
var statearr_25542_25605 = state_25465__$1;
(statearr_25542_25605[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (18))){
var inst_25372 = (state_25465[(2)]);
var state_25465__$1 = state_25465;
if(cljs.core.truth_(inst_25372)){
var statearr_25543_25606 = state_25465__$1;
(statearr_25543_25606[(1)] = (19));

} else {
var statearr_25544_25607 = state_25465__$1;
(statearr_25544_25607[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (42))){
var state_25465__$1 = state_25465;
var statearr_25545_25608 = state_25465__$1;
(statearr_25545_25608[(2)] = null);

(statearr_25545_25608[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (37))){
var inst_25431 = (state_25465[(2)]);
var state_25465__$1 = state_25465;
var statearr_25546_25609 = state_25465__$1;
(statearr_25546_25609[(2)] = inst_25431);

(statearr_25546_25609[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25466 === (8))){
var inst_25338 = (state_25465[(22)]);
var inst_25325 = (state_25465[(7)]);
var inst_25338__$1 = cljs.core.seq.call(null,inst_25325);
var state_25465__$1 = (function (){var statearr_25547 = state_25465;
(statearr_25547[(22)] = inst_25338__$1);

return statearr_25547;
})();
if(inst_25338__$1){
var statearr_25548_25610 = state_25465__$1;
(statearr_25548_25610[(1)] = (10));

} else {
var statearr_25549_25611 = state_25465__$1;
(statearr_25549_25611[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__23273__auto__,c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23274__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23274__auto____0 = (function (){
var statearr_25550 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25550[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__23274__auto__);

(statearr_25550[(1)] = (1));

return statearr_25550;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__23274__auto____1 = (function (state_25465){
while(true){
var ret_value__23275__auto__ = (function (){try{while(true){
var result__23276__auto__ = switch__23273__auto__.call(null,state_25465);
if(cljs.core.keyword_identical_QMARK_.call(null,result__23276__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__23276__auto__;
}
break;
}
}catch (e25551){if((e25551 instanceof Object)){
var ex__23277__auto__ = e25551;
var statearr_25552_25612 = state_25465;
(statearr_25552_25612[(5)] = ex__23277__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25465);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25551;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__23275__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25613 = state_25465;
state_25465 = G__25613;
continue;
} else {
return ret_value__23275__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__23274__auto__ = function(state_25465){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23274__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23274__auto____1.call(this,state_25465);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__23274__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__23274__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__23274__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__23274__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__23274__auto__;
})()
;})(switch__23273__auto__,c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__23298__auto__ = (function (){var statearr_25553 = f__23297__auto__.call(null);
(statearr_25553[(6)] = c__23296__auto__);

return statearr_25553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__23298__auto__);
});})(c__23296__auto__,map__25310,map__25310__$1,opts,before_jsload,on_jsload,reload_dependents,map__25311,map__25311__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__23296__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.protocol),"//"].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__25616,link){
var map__25617 = p__25616;
var map__25617__$1 = ((((!((map__25617 == null)))?(((((map__25617.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25617.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25617):map__25617);
var file = cljs.core.get.call(null,map__25617__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__5457__auto__ = link.href;
if(cljs.core.truth_(temp__5457__auto__)){
var link_href = temp__5457__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__5457__auto__,map__25617,map__25617__$1,file){
return (function (p1__25614_SHARP_,p2__25615_SHARP_){
if(cljs.core._EQ_.call(null,p1__25614_SHARP_,p2__25615_SHARP_)){
return p1__25614_SHARP_;
} else {
return false;
}
});})(link_href,temp__5457__auto__,map__25617,map__25617__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__5457__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__25620){
var map__25621 = p__25620;
var map__25621__$1 = ((((!((map__25621 == null)))?(((((map__25621.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25621.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25621):map__25621);
var match_length = cljs.core.get.call(null,map__25621__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__25621__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__25619_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__25619_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__5457__auto__)){
var res = temp__5457__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.distinctify = (function figwheel$client$file_reloading$distinctify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__25623_SHARP_,p2__25624_SHARP_){
return cljs.core.assoc.call(null,p1__25623_SHARP_,cljs.core.get.call(null,p2__25624_SHARP_,key),p2__25624_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.add_link_to_document = (function figwheel$client$file_reloading$add_link_to_document(orig_link,klone,finished_fn){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
parent.removeChild(orig_link);

return finished_fn.call(null);
});})(parent))
,(300));
});
if(typeof figwheel.client.file_reloading.reload_css_deferred_chain !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_css_deferred_chain = cljs.core.atom.call(null,goog.async.Deferred.succeed());
}
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(f_data,fin){
var temp__5455__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__5455__auto__)){
var link = temp__5455__auto__;
return figwheel.client.file_reloading.add_link_to_document.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href),((function (link,temp__5455__auto__){
return (function (){
return fin.call(null,cljs.core.assoc.call(null,f_data,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),true));
});})(link,temp__5455__auto__))
);
} else {
return fin.call(null,f_data);
}
});
figwheel.client.file_reloading.reload_css_files_STAR_ = (function figwheel$client$file_reloading$reload_css_files_STAR_(deferred,f_datas,on_cssload){
return figwheel.client.utils.liftContD.call(null,figwheel.client.utils.mapConcatD.call(null,deferred,figwheel.client.file_reloading.reload_css_file,f_datas),(function (f_datas_SINGLEQUOTE_,fin){
var loaded_f_datas_25625 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded","loaded",-1246482293),f_datas_SINGLEQUOTE_);
figwheel.client.file_reloading.on_cssload_custom_event.call(null,loaded_f_datas_25625);

if(cljs.core.fn_QMARK_.call(null,on_cssload)){
on_cssload.call(null,loaded_f_datas_25625);
} else {
}

return fin.call(null);
}));
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__25626,p__25627){
var map__25628 = p__25626;
var map__25628__$1 = ((((!((map__25628 == null)))?(((((map__25628.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25628.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25628):map__25628);
var on_cssload = cljs.core.get.call(null,map__25628__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
var map__25629 = p__25627;
var map__25629__$1 = ((((!((map__25629 == null)))?(((((map__25629.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25629.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25629):map__25629);
var files_msg = map__25629__$1;
var files = cljs.core.get.call(null,map__25629__$1,new cljs.core.Keyword(null,"files","files",-472457450));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var temp__5457__auto__ = cljs.core.not_empty.call(null,figwheel.client.file_reloading.distinctify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files));
if(cljs.core.truth_(temp__5457__auto__)){
var f_datas = temp__5457__auto__;
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.reload_css_deferred_chain,figwheel.client.file_reloading.reload_css_files_STAR_,f_datas,on_cssload);
} else {
return null;
}
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1521564157954
