/*
 * Decompiled with CFR 0.152.
 */
package cumulus_message_adapter.message_parser;

import com.amazonaws.services.lambda.runtime.Context;
import cumulus_message_adapter.message_parser.IMessageAdapter;
import cumulus_message_adapter.message_parser.IMessageParser;
import cumulus_message_adapter.message_parser.ITask;
import cumulus_message_adapter.message_parser.MessageAdapter;
import cumulus_message_adapter.message_parser.MessageAdapterException;

public class MessageParser
implements IMessageParser {
    private IMessageAdapter _messageAdapter;

    public MessageParser() {
        this._messageAdapter = new MessageAdapter();
    }

    public MessageParser(IMessageAdapter messageAdapter) {
        this._messageAdapter = messageAdapter;
    }

    public String HandleMessage(String input, Context context, ITask task) throws MessageAdapterException {
        Boolean messageAdapterDisabled = Boolean.valueOf(System.getenv("CUMULUS_MESSAGE_ADAPTER_DISABLED"));
        try {
            if (messageAdapterDisabled.booleanValue()) {
                return task.PerformFunction(input, context);
            }
            String remoteEvent = this._messageAdapter.LoadRemoteEvent(input);
            String eventInput = this._messageAdapter.LoadNestedEvent(remoteEvent, context);
            String taskOutput = task.PerformFunction(eventInput, context);
            return this._messageAdapter.CreateNextEvent(remoteEvent, eventInput, taskOutput);
        }
        catch (Exception e) {
            if (e.getClass().getSimpleName().contains("WorkflowError") || e.getClass().getSimpleName().contains("WorkflowException")) {
                return "{\"payload\":null,\"exception\":\"" + e.getMessage() + "\"}";
            }
            throw new MessageAdapterException(e.getMessage(), e.getCause());
        }
    }
}

