/*
 * Decompiled with CFR 0.152.
 */
package cumulus_message_adapter.message_parser;

import com.amazonaws.services.lambda.runtime.Context;
import cumulus_message_adapter.message_parser.AdapterLogger;
import cumulus_message_adapter.message_parser.IMessageAdapter;
import cumulus_message_adapter.message_parser.IMessageParser;
import cumulus_message_adapter.message_parser.ITask;
import cumulus_message_adapter.message_parser.MessageAdapter;
import cumulus_message_adapter.message_parser.MessageAdapterException;
import cumulus_message_adapter.message_parser.SchemaLocations;

public class MessageParser
implements IMessageParser {
    private IMessageAdapter _messageAdapter;

    public MessageParser() {
        this._messageAdapter = new MessageAdapter();
    }

    public MessageParser(IMessageAdapter messageAdapter) {
        this._messageAdapter = messageAdapter;
    }

    private String HandleMessage(String input, Context context, ITask task, SchemaLocations schemaLocations) throws MessageAdapterException {
        Boolean messageAdapterDisabled = Boolean.valueOf(System.getenv("CUMULUS_MESSAGE_ADAPTER_DISABLED"));
        AdapterLogger.InitializeLogger(context, input);
        try {
            if (messageAdapterDisabled.booleanValue()) {
                return task.PerformFunction(input, context);
            }
            String remoteEvent = this._messageAdapter.LoadRemoteEvent(input, schemaLocations);
            if (remoteEvent != input) {
                AdapterLogger.SetExecutions(remoteEvent);
            }
            String eventInput = this._messageAdapter.LoadNestedEvent(remoteEvent, context, schemaLocations);
            String taskOutput = task.PerformFunction(eventInput, context);
            return this._messageAdapter.CreateNextEvent(remoteEvent, eventInput, taskOutput, schemaLocations);
        }
        catch (Exception e) {
            AdapterLogger.LogError(e.getMessage());
            if (e.getClass().getSimpleName().contains("WorkflowError") || e.getClass().getSimpleName().contains("WorkflowException")) {
                return "{\"payload\":null,\"exception\":\"" + e.getMessage() + "\"}";
            }
            throw new MessageAdapterException(e.getMessage(), e.getCause());
        }
    }

    public String RunCumulusTask(String input, Context context, ITask task) throws MessageAdapterException {
        return this.HandleMessage(input, context, task, null);
    }

    public String RunCumulusTask(String input, Context context, ITask task, String inputSchemaLocation, String outputSchemaLocation, String configSchemaLocation) throws MessageAdapterException {
        SchemaLocations schemaLocations = null;
        if (inputSchemaLocation != null || outputSchemaLocation != null || configSchemaLocation != null) {
            schemaLocations = new SchemaLocations(inputSchemaLocation, outputSchemaLocation, configSchemaLocation);
        }
        return this.HandleMessage(input, context, task, schemaLocations);
    }
}

