/*
 * Decompiled with CFR 0.152.
 */
package cumulus_message_adapter.message_parser;

import com.amazonaws.services.lambda.runtime.Context;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cumulus_message_adapter.message_parser.AdapterLogger;
import cumulus_message_adapter.message_parser.IMessageAdapter;
import cumulus_message_adapter.message_parser.MessageAdapterException;
import cumulus_message_adapter.message_parser.SchemaLocations;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;

public class MessageAdapter
implements IMessageAdapter {
    private static final int MESSAGE_ADAPTER_TIMEOUT = 120;

    public String CallMessageAdapterFunction(String messageAdapterFunction, String inputJson) throws MessageAdapterException {
        String messageAdapterOutput = "";
        try {
            Scanner scanner;
            ProcessBuilder processBuilder = new ProcessBuilder("python", "cumulus-message-adapter", messageAdapterFunction);
            Process process = processBuilder.start();
            OutputStreamWriter writer = new OutputStreamWriter(process.getOutputStream());
            writer.write(inputJson);
            writer.close();
            Boolean processComplete = false;
            try {
                processComplete = process.waitFor(120L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                AdapterLogger.LogError(String.format("Cumulus Message Adapter error: %s: %s", messageAdapterFunction, e.getMessage()));
            }
            int exitValue = process.exitValue();
            if (processComplete.booleanValue() && exitValue == 0) {
                scanner = new Scanner(process.getInputStream());
                if (scanner.hasNextLine()) {
                    messageAdapterOutput = scanner.nextLine();
                }
            } else {
                Scanner scanner2 = new Scanner(process.getErrorStream());
                StringBuilder errorMessageBuilder = new StringBuilder();
                while (scanner2.hasNextLine()) {
                    errorMessageBuilder.append(scanner2.nextLine());
                }
                scanner2.close();
                AdapterLogger.LogError(String.format("Cumulus Message Adapter error: %s: %s", messageAdapterFunction, errorMessageBuilder.toString()));
                throw new MessageAdapterException("Error executing " + messageAdapterFunction);
            }
            scanner.close();
        }
        catch (IOException e) {
            AdapterLogger.LogError("Unable to find Cumulus Message Adapter");
            throw new MessageAdapterException("Unable to find Cumulus Message Adapter", e.getCause());
        }
        return messageAdapterOutput;
    }

    public String LoadAndUpdateRemoteEvent(String eventJson, Context context, SchemaLocations schemaLocations) throws MessageAdapterException {
        Gson gson = new Gson();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("event", gson.fromJson(eventJson, Map.class));
        map.put("context", context);
        map.put("schemas", schemaLocations);
        return this.CallMessageAdapterFunction("loadAndUpdateRemoteEvent", gson.toJson(map));
    }

    public String LoadNestedEvent(String eventJson, Context context, SchemaLocations schemaLocations) throws MessageAdapterException {
        Gson gson = new Gson();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("event", gson.fromJson(eventJson, Map.class));
        map.put("context", context);
        map.put("schemas", schemaLocations);
        return this.CallMessageAdapterFunction("loadNestedEvent", gson.toJson(map));
    }

    public String CreateNextEvent(String remoteEventJson, String nestedEventJson, String taskJson, SchemaLocations schemaLocations) throws MessageAdapterException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.serializeNulls();
        Gson gson = gsonBuilder.create();
        Map nestedEventMap = gson.fromJson(nestedEventJson, Map.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("event", gson.fromJson(remoteEventJson, Map.class));
        map.put("message_config", nestedEventMap.get("messageConfig"));
        map.put("handler_response", gson.fromJson(taskJson, Map.class));
        map.put("schemas", schemaLocations);
        return this.CallMessageAdapterFunction("createNextEvent", gson.toJson(map));
    }
}

