# ngap-onboarding

[![Clojars Project][clojars-badge]][clojars]
[![Clojure version][clojure-v]](project.clj)

*Managing the NGAP Application Onboarding Process*

[![Project Logo][logo]][logo-large]


#### Contents

* [About](#about-)
* [Dependencies](#dependencies-)
  * [Languages](#languages-)
  * [Tools](#tools-)
  * [AWS Services](#aws-services-)
* [Usage](#usage-)
  * [Setup](#setup-)
  * [Deploy](#deploy-)
  * [Run](#run-)
* [Acknowldgements](#acknowldgements-)
* [License](#license-)


## About [&#x219F;](#contents)

This is a Clojure and Clojurescript application for managing the NGAP
Application onboarding process. It coordinates the services and tasks necessary
to execute the NGAP onboarding workflow.


## Dependencies [&#x219F;](#contents)


### Languages [&#x219F;](#contents)

 * Java (for Clojure)
 * JavaScript (for Clojurescript)


### Tools [&#x219F;](#contents)

 * `lein`
 * `npm`
 * [AWS CLI][aws cli]


### AWS Services [&#x219F;](#contents)

This application makes (or will make) use of the following Amazon Web Services:

* [EC2][ec2]
* [ECS][ecs] / [ECR][ecr]
* [SQS][sqs]
* [SNS][sns]
* [Lambda][lambda]


## Usage [&#x219F;](#contents)


### Setup [&#x219F;](#contents)

Export the following values:

```
$ export AWS_ACCESS_KEY_ID=yourawsaccesskey
$ export AWS_SECRET_ACCESS_KEY=yourawssecretkey
$ export AWS_DEFAULT_REGION=yourpreferredregion
$ export AWS_DEFAULT_OUTPUT=json
```

Then in `project.clj` under the `cljs-lambda` section, update the
[IAM role name][cljs-lambda] with a valid value. Note that SNS & SQS
permissions must be added to enable execution


### Deploy [&#x219F;](#contents)

Deploy your function to AWS Lambda:

```
$ make lambda-deploy
```


### Run [&#x219F;](#contents)

Then to run, build the backend and execute it:

```
$ make
$ make run
```


## Acknowldgements

The initial architecture (and code) was based on work done at
[Nervous.io][nervous] by [Moe Aboulkheir][moe]. (See the related
[blog post][orig blog post].)


## License [&#x219F;](#contents)

Copyright © 2015, Nervous.io

Copyright © 2016, Clojure-Aided Enrichment Center

Copyright © 2016, Element 84, Inc.

Apache License, Version 2.0.


<!-- Named page links below: /-->

[travis]: https://travis-ci.org/clojusc/ngap-onboarding
[travis-badge]: https://travis-ci.org/clojusc/ngap-onboarding.png?branch=master
[deps]: http://jarkeeper.com/clojusc/ngap-onboarding
[deps-badge]: http://jarkeeper.com/clojusc/ngap-onboarding/status.svg
[logo]: resources/images/ngap-onboarding-small.png
[logo-large]: resources/images/ngap-onboarding-medium.png
[tag-badge]: https://img.shields.io/github/tag/clojusc/ngap-onboarding.svg
[tag]: https://github.com/clojusc/ngap-onboarding/tags
[clojure-v]: https://img.shields.io/badge/clojure-1.8.0-blue.svg
[clojars]: https://clojars.org/gov.nasa.earthdata/ngap-onboarding
[clojars-badge]: https://img.shields.io/clojars/v/gov.nasa.earthdata/ngap-onboarding.svg
[nervous]: https://github.com/nervous-systems
[moe]: https://github.com/moea
[orig blog post]: https://nervous.io/clojure/clojurescript/node/aws/2015/08/09/chemtrails/
[ec2]: http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts.html
[ecs]: http://docs.aws.amazon.com/AmazonECS/latest/developerguide/Welcome.html
[ecr]: http://docs.aws.amazon.com/AmazonECR/latest/userguide/Registries.html
[sqs]: http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/Welcome.html
[sns]: http://docs.aws.amazon.com/sns/latest/dg/welcome.html
[lambda]: https://docs.aws.amazon.com/lambda/latest/dg/welcome.html
[aws cli]: https://aws.amazon.com/cli/
[queue naming code]: https://github.com/nervous-systems/chemtrack-example/blob/master/backend/chemtrack/backend/util.cljs#L23
[cljs-lambda]: https://github.com/nervous-systems/cljs-lambda
