/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Api;

import gov.nih.nlm.nls.lexAccess.Api.LexAccessApi;
import gov.nih.nlm.nls.lexAccess.Api.LexAccessHelp;
import gov.nih.nlm.nls.lexAccess.Db.DbBase;
import gov.nih.nlm.nls.lexAccess.Lib.Configuration;
import gov.nih.nlm.nls.lexAccess.Util.Out;
import gov.nih.nlm.nls.lexAccess.Util.Platform;
import gov.nih.nlm.nls.lexCheck.Lib.GlobalVars;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.SystemOption;
import gov.nih.nlm.nls.lvg.Lib.Category;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class LexAccessCmdApi
extends SystemOption {
    protected Vector<String> quitStrList_ = new Vector();
    protected static BufferedReader inReader_ = null;
    protected static BufferedWriter outWriter_ = null;
    private static boolean fileOutput_ = false;
    protected boolean runFlag_ = true;
    private Option option_ = new Option("");
    private String promptStr_ = null;
    private String configFile_ = null;
    private Configuration conf_ = null;
    private Connection conn_ = null;
    private LexAccessApi lexAccessApi_ = null;
    private Hashtable<String, String> properties_ = null;
    private static String separator_ = gov.nih.nlm.nls.lexAccess.Util.GlobalVars.GetFieldSeparator();
    private String version_ = "2013";
    private static long category_ = 0L;
    private static long outCat_ = 2047L;
    private static boolean showTotalRecNum_ = false;
    private static boolean showQuery_ = false;
    private static String query_ = new String();
    private static boolean noOutputFlag_ = false;
    private static String noOutputMsg_ = "-No Record Found-";
    private static boolean promptFlag_ = false;
    private static int baseOpt_ = 0;
    private static int formatOpt_ = 0;
    private static int firstVersion_ = 2003;
    private static int latestVersion_ = 2053;

    public LexAccessCmdApi() {
        this.Init();
    }

    public LexAccessCmdApi(String optionStr) {
        this.option_ = new Option(optionStr);
        this.Init();
    }

    public LexAccessCmdApi(String optionStr, String configFile) {
        this.option_ = new Option(optionStr);
        this.configFile_ = configFile;
        this.Init();
    }

    public LexAccessCmdApi(Hashtable<String, String> properties) {
        this.properties_ = properties;
        this.Init();
    }

    public LexAccessCmdApi(String optionStr, Hashtable<String, String> properties) {
        this.option_ = new Option(optionStr);
        this.properties_ = properties;
        this.Init();
    }

    public LexAccessCmdApi(String optionStr, String configFile, Hashtable<String, String> properties) {
        this.option_ = new Option(optionStr);
        this.configFile_ = configFile;
        this.properties_ = properties;
        this.Init();
    }

    public void SetPromptStr(String promptStr) {
        this.promptStr_ = promptStr;
    }

    public void SetQuitStrList(Vector<String> quitStrList) {
        this.quitStrList_ = new Vector<String>(quitStrList);
    }

    public boolean IsLegalOption() {
        boolean isLegalOption = SystemOption.CheckSyntax((Option)this.option_, (Option)this.GetOption(), (boolean)false, (boolean)true);
        return isLegalOption;
    }

    public void SetOption(String optionStr) {
        this.option_ = new Option(optionStr);
        this.PreProcess();
        this.InitDb();
    }

    public Configuration GetConfiguration() {
        return this.conf_;
    }

    public Connection GetConnection() {
        return this.conn_;
    }

    public void CleanUp() {
        try {
            this.Close();
        }
        catch (Exception e) {
            System.err.println("** ERR: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public String ProcessToString() throws SQLException, IOException {
        Out.ResetOutString();
        this.Process(true);
        return Out.GetOutString();
    }

    public boolean Process() throws SQLException, IOException {
        return this.Process(false);
    }

    private boolean Process(boolean toStringFlag) throws SQLException, IOException {
        if (!this.runFlag_) {
            return false;
        }
        if (category_ == 0L) {
            if (promptFlag_) {
                this.GetPrompt();
            }
            String line = null;
            if (inReader_ == null) {
                inReader_ = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            }
            if ((line = inReader_.readLine()) == null || this.quitStrList_.contains(line)) {
                return false;
            }
            this.ProcessLine(line, toStringFlag);
            return true;
        }
        String outStr = this.lexAccessApi_.GetResultStrByCategory(category_, showQuery_, query_, noOutputFlag_, noOutputMsg_, showTotalRecNum_, formatOpt_, separator_);
        Out.Print(outWriter_, outStr, fileOutput_, toStringFlag);
        return false;
    }

    public void PrintLexAccessHelp() {
        LexAccessHelp.LexAccessHelp(outWriter_, fileOutput_);
    }

    protected void ExecuteCommand(OptionItem optionItem, Option systemOption) {
        OptionItem nameItem = OptionUtility.GetItemByName((OptionItem)optionItem, (Option)systemOption, (boolean)false);
        if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-b:b")) {
            baseOpt_ = 1;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-b:c")) {
            baseOpt_ = 2;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-b:e")) {
            baseOpt_ = 3;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-b:ex")) {
            baseOpt_ = 4;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-c:a")) {
            category_ |= Category.ToValue((String)"adj");
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-c:all")) {
            category_ |= 0x7FFL;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-c:b")) {
            category_ |= Category.ToValue((String)"adv");
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-c:c")) {
            category_ |= Category.ToValue((String)"compl");
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-c:d")) {
            category_ |= Category.ToValue((String)"det");
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-c:h")) {
            LexAccessHelp.CategoryHelp(outWriter_, fileOutput_);
            this.runFlag_ = false;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-c:j")) {
            category_ |= Category.ToValue((String)"conj");
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-c:m")) {
            category_ |= Category.ToValue((String)"modal");
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-c:n")) {
            category_ |= Category.ToValue((String)"noun");
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-c:p")) {
            category_ |= Category.ToValue((String)"prep");
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-c:r")) {
            category_ |= Category.ToValue((String)"pron");
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-c:v")) {
            category_ |= Category.ToValue((String)"verb");
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-c:x")) {
            category_ |= Category.ToValue((String)"aux");
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-ci")) {
            try {
                boolean useClassPath = false;
                String configFile = this.configFile_;
                if (configFile == null) {
                    useClassPath = true;
                    configFile = "data.config.lexAccess";
                }
                Configuration conf = new Configuration(configFile, useClassPath);
                if (this.properties_ != null) {
                    conf.OverwriteProperties(this.properties_);
                }
                Out.Println(outWriter_, conf.GetInformation(), fileOutput_, false);
            }
            catch (IOException e) {
                // empty catch block
            }
            this.runFlag_ = false;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-cn:LONG")) {
            long cat = Long.parseLong(nameItem.GetOptionArgument());
            if (cat <= 0L || cat > 2047L) {
                String temp = "*** Error: Illegal value for category (" + cat + ").";
                try {
                    Out.Println(outWriter_, temp, fileOutput_, false);
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.runFlag_ = false;
            } else {
                category_ = Long.parseLong(nameItem.GetOptionArgument());
            }
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-cnf:LONG")) {
            outCat_ = Long.parseLong(nameItem.GetOptionArgument());
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-f:b")) {
            formatOpt_ = 3;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-f:bd")) {
            formatOpt_ = 4;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-f:h")) {
            LexAccessHelp.FormatHelp(outWriter_, fileOutput_);
            this.runFlag_ = false;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-f:i")) {
            formatOpt_ = 7;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-f:id")) {
            formatOpt_ = 8;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-f:s")) {
            formatOpt_ = 5;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-f:sd")) {
            formatOpt_ = 6;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-f:t")) {
            formatOpt_ = 0;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-f:tx")) {
            formatOpt_ = 2;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-f:x")) {
            formatOpt_ = 1;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-h")) {
            LexAccessHelp.LexAccessHelp(outWriter_, fileOutput_);
            this.runFlag_ = false;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-hs")) {
            systemOption.PrintOptionHierachy();
            this.runFlag_ = false;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-i:STR")) {
            String inFile = nameItem.GetOptionArgument();
            if (inFile != null) {
                try {
                    inReader_ = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF-8"));
                }
                catch (IOException e) {
                    this.runFlag_ = false;
                    System.err.println("**Error: problem of opening/reading file " + inFile);
                }
            }
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-n")) {
            noOutputFlag_ = true;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-o:STR")) {
            String outFile = nameItem.GetOptionArgument();
            if (outFile != null) {
                try {
                    outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
                    fileOutput_ = true;
                }
                catch (IOException e) {
                    this.runFlag_ = false;
                    System.err.println("**Error: problem of opening/writing file " + outFile);
                }
            }
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-p")) {
            promptFlag_ = true;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-q")) {
            query_ = this.option_.GetOptionStr();
            showQuery_ = true;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-rv:STR")) {
            this.version_ = nameItem.GetOptionArgument();
            if (!this.SetVersionInConfig(this.version_)) {
                System.err.println("**Err@LexAccessCmdApi(): Illegal version setting (" + this.version_ + ")");
                this.runFlag_ = false;
            }
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-s:STR")) {
            separator_ = nameItem.GetOptionArgument();
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-t")) {
            showTotalRecNum_ = true;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-v")) {
            try {
                Out.Println(outWriter_, "lexAccess.2013", fileOutput_, false);
            }
            catch (IOException e) {
                // empty catch block
            }
            this.runFlag_ = false;
        } else if (LexAccessCmdApi.CheckOption((OptionItem)nameItem, (String)"-x:STR")) {
            this.configFile_ = nameItem.GetOptionArgument();
        }
    }

    protected void DefineFlag() {
        String flagStr = "-b:b:c:e:ex -c:a:all:b:c:d:h:j:m:n:p:r:v:x -ci -cn:LONG -cnf:LONG -f:b:bd:h:i:id:s:sd:t:tx:x -h -hs -i:STR -n -o:STR -p -q -rv:STR -s:STR -t -v -x:STR";
        this.systemOption_ = new Option(flagStr);
        this.systemOption_.SetFlagFullName("-b:b", "Base_begin_with");
        this.systemOption_.SetFlagFullName("-b:c", "Base_contain");
        this.systemOption_.SetFlagFullName("-b:e", "Base_end_with");
        this.systemOption_.SetFlagFullName("-b:ex", "Base_exact_match");
        this.systemOption_.SetFlagFullName("-c:a", "Category_Adj");
        this.systemOption_.SetFlagFullName("-c:all", "Category_All");
        this.systemOption_.SetFlagFullName("-c:b", "Category_Adv");
        this.systemOption_.SetFlagFullName("-c:c", "Category_Compl");
        this.systemOption_.SetFlagFullName("-c:d", "Category_Det");
        this.systemOption_.SetFlagFullName("-c:h", "Category_Help");
        this.systemOption_.SetFlagFullName("-c:j", "Category_Conj");
        this.systemOption_.SetFlagFullName("-c:m", "Category_Modal");
        this.systemOption_.SetFlagFullName("-c:n", "Category_Noun");
        this.systemOption_.SetFlagFullName("-c:p", "Category_Prep");
        this.systemOption_.SetFlagFullName("-c:r", "Category_Pron");
        this.systemOption_.SetFlagFullName("-c:v", "Category_Verb");
        this.systemOption_.SetFlagFullName("-c:x", "Category_Aux");
        this.systemOption_.SetFlagFullName("-ci", "Show_Config_Info");
        this.systemOption_.SetFlagFullName("-cn:LONG", "Category_in_value");
        this.systemOption_.SetFlagFullName("-cnf:LONG", "Category_filter");
        this.systemOption_.SetFlagFullName("-f:b", "Base_Form");
        this.systemOption_.SetFlagFullName("-f:bd", "Base_Form_Details");
        this.systemOption_.SetFlagFullName("-f:h", "Print_Help");
        this.systemOption_.SetFlagFullName("-f:i", "Inflected_Term");
        this.systemOption_.SetFlagFullName("-f:id", "Inflected_Term_Details");
        this.systemOption_.SetFlagFullName("-f:s", "Base_Spelling_Var");
        this.systemOption_.SetFlagFullName("-f:sd", "Base_Spelling_Var_Details");
        this.systemOption_.SetFlagFullName("-f:t", "Text_Record");
        this.systemOption_.SetFlagFullName("-f:tx", "Text_XML_Record");
        this.systemOption_.SetFlagFullName("-f:x", "Xml_Record");
        this.systemOption_.SetFlagFullName("-h", "Help");
        this.systemOption_.SetFlagFullName("-hs", "Hierarchy_Struture");
        this.systemOption_.SetFlagFullName("-i", "Input_File");
        this.systemOption_.SetFlagFullName("-n", "No_Record_Found");
        this.systemOption_.SetFlagFullName("-o", "Output_File");
        this.systemOption_.SetFlagFullName("-p", "Show_Prompt");
        this.systemOption_.SetFlagFullName("-q", "Print_Query");
        this.systemOption_.SetFlagFullName("-rv:STR", "Run_Specified_version");
        this.systemOption_.SetFlagFullName("-s:STR", "Field_Separator");
        this.systemOption_.SetFlagFullName("-t", "Total_Rec_Num");
        this.systemOption_.SetFlagFullName("-v", "Version");
        this.systemOption_.SetFlagFullName("-x:STR", "Load_Configuration_file");
    }

    protected void GetPrompt() throws IOException {
        Out.Println(outWriter_, this.promptStr_, fileOutput_, false);
    }

    private void Init() {
        this.PreProcess();
        this.InitConfigVars();
        this.InitDb();
        if (this.lexAccessApi_ == null) {
            this.lexAccessApi_ = new LexAccessApi(this.conn_);
        }
    }

    private void InitDb() {
        try {
            if (this.conn_ == null && this.runFlag_) {
                this.conn_ = DbBase.OpenConnection(this.conf_);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void PreProcess() {
        Vector<String> args = LexAccessCmdApi.GetOptions(this.option_.GetOptionStr());
        for (int i = 0; i < args.size(); ++i) {
            String temp = args.elementAt(i);
            Option io = new Option(temp);
            this.ExecuteCommands(io, this.GetOption());
        }
    }

    private static Vector<String> GetOptions(String inStr) {
        Vector<String> out = new Vector<String>();
        StringTokenizer buf = new StringTokenizer(inStr, " \t");
        while (buf.hasMoreTokens()) {
            out.addElement(buf.nextToken());
        }
        return out;
    }

    private void InitConfigVars() {
        String xmlHeader;
        String xmlIndent;
        boolean useClassPath = false;
        if (this.configFile_ == null) {
            useClassPath = true;
            this.configFile_ = "data.config.lexAccess";
        }
        this.conf_ = new Configuration(this.configFile_, useClassPath);
        if (this.properties_ != null) {
            this.conf_.OverwriteProperties(this.properties_);
        }
        if (noOutputMsg_ == null) {
            noOutputMsg_ = this.conf_.GetConfiguration("NO_OUTPUT_MSG");
        }
        this.promptStr_ = Platform.IsWindow() ? "- Please input a term/eui (type \"Ctl-z\" then \"Enter\" to quit) >" : "- Please input a term (type \"Ctl-d\" to quit) >";
        String textIndent = this.conf_.GetConfiguration("TEXT_INDENT");
        if (textIndent != null) {
            GlobalVars.SetTextIndent((String)LexAccessCmdApi.GetStringContent(textIndent));
        }
        if ((xmlIndent = this.conf_.GetConfiguration("XML_INDENT")) != null) {
            GlobalVars.SetXmlIndent((String)LexAccessCmdApi.GetStringContent(xmlIndent));
        }
        if ((xmlHeader = this.conf_.GetConfiguration("XML_HEADER")) != null) {
            GlobalVars.SetXmlHeader((String)LexAccessCmdApi.GetStringContent(xmlHeader));
        }
    }

    private static String GetStringContent(String inStr) {
        int length = inStr.length();
        if (inStr != null && inStr.startsWith("\"") && inStr.endsWith("\"")) {
            return inStr.substring(1, length - 1);
        }
        return inStr;
    }

    private void Close() throws IOException, SQLException {
        if (outWriter_ != null && fileOutput_) {
            outWriter_.close();
        }
        if (inReader_ != null) {
            inReader_.close();
        }
        if (this.conn_ != null) {
            DbBase.CloseConnection(this.conn_);
        }
    }

    private void ProcessLine(String line, boolean toStringFlag) throws SQLException, IOException {
        String outStr = this.GetLexRecords(line);
        Out.Print(outWriter_, outStr, fileOutput_, toStringFlag);
    }

    private String GetLexRecords(String inTerm) {
        String resultStr = new String();
        if (inTerm == null || inTerm.length() == 0) {
            return resultStr;
        }
        try {
            resultStr = baseOpt_ == 0 ? this.lexAccessApi_.GetResultStrByTerm(inTerm, outCat_, showQuery_, query_, noOutputFlag_, noOutputMsg_, showTotalRecNum_, formatOpt_, separator_) : this.lexAccessApi_.GetResultStrByBase(inTerm, baseOpt_, outCat_, showQuery_, query_, noOutputFlag_, noOutputMsg_, showTotalRecNum_, formatOpt_, separator_);
        }
        catch (Exception e) {
            System.err.println("** ERR: " + e.getMessage());
            e.printStackTrace();
        }
        return resultStr;
    }

    private boolean SetVersionInConfig(String version) {
        boolean flag = true;
        if (this.IsLegalVersion(version)) {
            this.properties_ = new Hashtable();
            String dbDir = "HSqlDb." + version + "/";
            String dbName = "lexAccess" + version;
            this.properties_.put("DB_DIR", dbDir);
            this.properties_.put("DB_NAME", dbName);
        } else {
            flag = false;
        }
        return flag;
    }

    private boolean IsLegalVersion(String version) {
        boolean flag = false;
        try {
            boolean useClassPath = false;
            String configFile = this.configFile_;
            if (configFile == null) {
                useClassPath = true;
                configFile = "data.config.lexAccess";
            }
            Configuration conf = new Configuration(configFile, useClassPath);
            firstVersion_ = Integer.parseInt(conf.GetConfiguration("FIRST_VERSION"));
            latestVersion_ = Integer.parseInt(conf.GetConfiguration("LATEST_VERSION"));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (version.length() == 4) {
            try {
                int year = Integer.parseInt(version);
                if (year >= firstVersion_ && year <= latestVersion_) {
                    flag = true;
                }
            }
            catch (Exception e) {}
        } else if (version.length() == 9 && version.endsWith("ASCII")) {
            try {
                int year = Integer.parseInt(version.substring(0, 4));
                if (year >= firstVersion_ && year <= latestVersion_) {
                    flag = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return flag;
    }

    static {
        try {
            outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        }
        catch (IOException e) {
            System.err.println("**Error: problem of opening Std-out.");
        }
    }
}

