/*
 * Decompiled with CFR 0.152.
 */
package GuiTool.Gui;

import GuiTool.Global.LvgGlobal;
import GuiTool.Gui.AddFlowDialog;
import GuiTool.Gui.ModifyFlowDialog;
import GuiTool.GuiLib.GridBag;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FlowSetupDialog
extends JDialog {
    private static JList<String> selectedList_ = new JList<String>(LvgGlobal.cmd_.GetFlowList());
    private static FlowSetupDialog dialog_ = null;
    private static JFrame owner_ = null;
    private static final long serialVersionUID = 5L;

    private FlowSetupDialog(JFrame owner) {
        super(owner, "Flow(s) Setup", true);
        owner_ = owner;
        this.setLocationRelativeTo(owner);
        this.setSize(500, 300);
        selectedList_.setSelectionMode(0);
        JScrollPane selectedSp = new JScrollPane(selectedList_);
        JPanel centerP = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        centerP.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 10;
        gbc.insets = new Insets(5, 5, 5, 5);
        GridBag.SetWeight(gbc, 100, 100);
        GridBag.SetPosSize(gbc, 0, 0, 1, 1);
        centerP.add((Component)new JLabel("Construct LVG Flow(s):"), gbc);
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 5, 5);
        GridBag.SetPosSize(gbc, 0, 1, 1, 10);
        centerP.add((Component)selectedSp, gbc);
        JPanel buttonP = new JPanel();
        JButton okB = new JButton("OK");
        JButton cancelB = new JButton("Cancel");
        JButton addB = new JButton("Add");
        JButton deleteB = new JButton("Delete");
        JButton modifyB = new JButton("Modify");
        JButton resetB = new JButton("Reset");
        buttonP.add(okB);
        buttonP.add(cancelB);
        buttonP.add(addB);
        buttonP.add(deleteB);
        buttonP.add(modifyB);
        buttonP.add(resetB);
        this.getContentPane().add((Component)centerP, "Center");
        this.getContentPane().add((Component)buttonP, "South");
        okB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LvgGlobal.UpdateCmdStr();
                FlowSetupDialog.this.setVisible(false);
            }
        });
        cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FlowSetupDialog.this.setVisible(false);
            }
        });
        addB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddFlowDialog.ShowDialog(owner_);
            }
        });
        modifyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = selectedList_.getSelectedIndex();
                if (selectedList_.getModel().getSize() <= 0) {
                    JOptionPane.showMessageDialog(owner_, "Current flow is empty!", "Setup Flow", 2);
                } else if (index < 0) {
                    JOptionPane.showMessageDialog(owner_, "Please select a flow for modifying", "Setup Flow", 2);
                } else {
                    ModifyFlowDialog.ShowDialog(owner_, index);
                }
            }
        });
        deleteB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = selectedList_.getSelectedIndex();
                if (index < 0) {
                    JOptionPane.showMessageDialog(owner_, "Please select a flow to delete", "Setup Flow", 2);
                } else {
                    LvgGlobal.cmd_.RemoveFlowComponent(index);
                }
            }
        });
        resetB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LvgGlobal.cmd_.ResetFlow();
            }
        });
    }

    public static void ShowDialog(JFrame owner) {
        if (dialog_ == null) {
            dialog_ = new FlowSetupDialog(owner);
        }
        dialog_.setVisible(true);
    }
}

