/*
 * Decompiled with CFR 0.152.
 */
package GuiTool.Gui;

import GuiTool.Global.LvgDef;
import GuiTool.Global.LvgGlobal;
import GuiTool.GuiComp.OkCancelResetButtonPanel;
import GuiTool.GuiLib.GridBag;
import GuiTool.GuiLib.LvgHtmlBrowser;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LvgFlowSpecificOption;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MutateOptionDialog
extends JDialog {
    private static int FO_SIZE = LvgDef.FLOW_SPECIFIC_OPT_NUM;
    private static int GB_SIZE = LvgDef.GLOBAL_BEHAVIOR_OPT_NUM;
    private static int SIZE = FO_SIZE + GB_SIZE;
    private static JCheckBox[] cb_ = new JCheckBox[SIZE];
    private static JButton[] setB_ = new JButton[SIZE];
    private static JButton[] helpB_ = new JButton[SIZE];
    private static JComboBox<String> kdCombo_ = new JComboBox();
    private static JComboBox<String> kdnCombo_ = new JComboBox();
    private static JComboBox<String> kdtCombo_ = new JComboBox();
    private static JComboBox<String> kiCombo_ = new JComboBox();
    private static JTextField[] valueT_ = new JTextField[SIZE];
    private static String[] defaults_ = new String[SIZE];
    private static String[] cancelText_ = new String[SIZE];
    private static boolean[] cancelCb_ = new boolean[SIZE];
    private static int[] size_ = new int[SIZE];
    private static boolean[] valueTFlag_ = new boolean[]{true, true, true, true, true, true, true, false, false, true};
    private static boolean[] setBFlag_ = new boolean[]{false, false, false, true, true, true, true, false, false, false};
    private static boolean[] helpBFlag_ = new boolean[]{false, false, false, true, true, true, true, true, true, true};
    private static JFrame owner_ = null;
    private static MutateOptionDialog dialog_ = null;
    private static LvgHtmlBrowser helpDoc_ = null;
    private static String[] kdnValue_ = new String[]{"O", "N", "B"};
    private static String[] kdtValue_ = new String[]{"Z", "S", "P", "ZS", "ZP", "SP", "ZSP"};
    private static final long serialVersionUID = 5L;

    private MutateOptionDialog(JFrame owner) {
        super(owner, "Lvg Mutate Options", true);
        owner_ = owner;
        this.setLocationRelativeTo(owner);
        this.setSize(800, 500);
        JPanel topP = new JPanel();
        topP.add(new JLabel("Please select mutate options:"));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        GridBag.SetWeight(gbc, 100, 100);
        JPanel flowP = new JPanel();
        flowP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Flow Specific Options"));
        flowP.setLayout(gbl);
        for (int i = 0; i < FO_SIZE; ++i) {
            GridBag.SetPosSize(gbc, 0, i, 1, 1);
            flowP.add((Component)cb_[i], gbc);
            if (valueTFlag_[i]) {
                GridBag.SetPosSize(gbc, 1, i, 1, 1);
                flowP.add((Component)valueT_[i], gbc);
            }
            if (setBFlag_[i]) {
                GridBag.SetPosSize(gbc, 2, i, 1, 1);
                if (i == 3) {
                    flowP.add(kdCombo_, gbc);
                } else if (i == 4) {
                    flowP.add(kdnCombo_, gbc);
                } else if (i == 5) {
                    flowP.add(kdtCombo_, gbc);
                } else if (i == 6) {
                    flowP.add(kiCombo_, gbc);
                } else {
                    flowP.add((Component)setB_[i], gbc);
                }
            }
            if (!helpBFlag_[i]) continue;
            GridBag.SetPosSize(gbc, 3, i, 1, 1);
            flowP.add((Component)helpB_[i], gbc);
        }
        JPanel globalP = new JPanel();
        globalP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Global Behavior Options"));
        globalP.setLayout(gbl);
        for (int i = 0; i < GB_SIZE; ++i) {
            int ii = i + FO_SIZE;
            GridBag.SetPosSize(gbc, 0, i, 1, 1);
            globalP.add((Component)cb_[ii], gbc);
            if (valueTFlag_[ii]) {
                GridBag.SetPosSize(gbc, 1, i, 1, 1);
                globalP.add((Component)valueT_[ii], gbc);
            }
            if (setBFlag_[ii]) {
                GridBag.SetPosSize(gbc, 2, i, 1, 1);
                globalP.add((Component)setB_[ii], gbc);
            }
            if (!helpBFlag_[ii]) continue;
            GridBag.SetPosSize(gbc, 3, i, 1, 1);
            globalP.add((Component)helpB_[ii], gbc);
        }
        JPanel centerP = new JPanel();
        centerP.setLayout(new GridBagLayout());
        gbc.fill = 2;
        gbc.insets = new Insets(6, 12, 6, 12);
        GridBag.SetPosSize(gbc, 1, 1, 1, 1);
        centerP.add((Component)flowP, gbc);
        GridBag.SetPosSize(gbc, 1, 2, 1, 1);
        centerP.add((Component)globalP, gbc);
        OkCancelResetButtonPanel bottomP = new OkCancelResetButtonPanel();
        JButton okB = bottomP.GetOkButton();
        JButton cancelB = bottomP.GetCancelButton();
        JButton resetB = bottomP.GetResetButton();
        this.getContentPane().add((Component)topP, "North");
        this.getContentPane().add((Component)centerP, "Center");
        this.getContentPane().add((Component)bottomP, "South");
        okB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int ii;
                int i;
                block14: for (i = 0; i < FO_SIZE; ++i) {
                    boolean flag = cb_[i].isSelected();
                    String valueStr = new String();
                    if (valueTFlag_[i]) {
                        valueStr = valueT_[i].getText();
                    }
                    switch (i) {
                        case 0: {
                            int minTermLength = Integer.parseInt(valueStr);
                            LvgGlobal.lvg_.SetMinTermLength(minTermLength);
                            continue block14;
                        }
                        case 1: {
                            int maxPermuteTerm = Integer.parseInt(valueStr);
                            LvgGlobal.lvg_.GetFlowSpecificOptions().SetMaxPermuteTermNum(maxPermuteTerm);
                            continue block14;
                        }
                        case 2: {
                            int maxCodeLength = Integer.parseInt(valueStr);
                            LvgGlobal.lvg_.GetFlowSpecificOptions().SetMaxMetaphoneCodeLength(maxCodeLength);
                            continue block14;
                        }
                        case 3: {
                            LvgGlobal.lvg_.GetFlowSpecificOptions().SetDerivationFilter(1);
                            continue block14;
                        }
                        case 4: {
                            LvgGlobal.lvg_.GetFlowSpecificOptions().SetDerivationNegation("O");
                            continue block14;
                        }
                        case 5: {
                            LvgGlobal.lvg_.GetFlowSpecificOptions().SetDerivationType("ZSP");
                            continue block14;
                        }
                        case 6: {
                            LvgGlobal.lvg_.GetFlowSpecificOptions().SetInflectionFilter(2);
                        }
                    }
                }
                block15: for (i = 0; i < GB_SIZE; ++i) {
                    ii = i + FO_SIZE;
                    boolean flag = cb_[ii].isSelected();
                    String valueStr = new String();
                    if (valueTFlag_[ii]) {
                        valueStr = valueT_[ii].getText();
                    }
                    switch (i) {
                        case 0: {
                            LvgGlobal.mutateFlag_ = flag;
                            continue block15;
                        }
                        case 1: {
                            LvgGlobal.detailsFlag_ = flag;
                            continue block15;
                        }
                        case 2: {
                            LvgGlobal.separator_ = flag ? valueStr : defaults_[ii];
                        }
                    }
                }
                LvgGlobal.cmd_.ResetGlobalOptions();
                for (i = 3; i < FO_SIZE; ++i) {
                    if (!cb_[i].isSelected()) continue;
                    LvgGlobal.cmd_.AddGlobalOption("-" + LvgDef.FLOW_SPECIFIC_PURE_OPT_FLAG[i] + ":" + valueT_[i].getText());
                }
                for (i = FO_SIZE; i < SIZE; ++i) {
                    ii = i - FO_SIZE;
                    if (!cb_[i].isSelected()) continue;
                    if (valueTFlag_[i]) {
                        LvgGlobal.cmd_.AddGlobalOption("-" + LvgDef.GLOBAL_BEHAVIOR_PURE_OPT_FLAG[ii] + ":" + valueT_[i].getText());
                        continue;
                    }
                    LvgGlobal.cmd_.AddGlobalOption("-" + LvgDef.GLOBAL_BEHAVIOR_PURE_OPT_FLAG[ii]);
                }
                LvgGlobal.UpdateCmdStr();
                MutateOptionDialog.this.setVisible(false);
            }
        });
        cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MutateOptionDialog.RetrieveStatus();
                MutateOptionDialog.this.setVisible(false);
            }
        });
        resetB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                for (int i = 0; i < SIZE; ++i) {
                    cb_[i].setSelected(false);
                    valueT_[i].setText(defaults_[i]);
                }
                cb_[0].setSelected(true);
                cb_[1].setSelected(true);
                cb_[2].setSelected(true);
                kdCombo_.setSelectedIndex(0);
                kdnCombo_.setSelectedIndex(0);
                kdtCombo_.setSelectedIndex(6);
                kiCombo_.setSelectedIndex(1);
            }
        });
        cb_[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                cb_[0].setSelected(true);
            }
        });
        cb_[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                cb_[1].setSelected(true);
            }
        });
        cb_[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                cb_[2].setSelected(true);
            }
        });
        kdCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = kdCombo_.getSelectedIndex() + 1;
                valueT_[3].setText(Integer.toString(index));
            }
        });
        kdnCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = kdnCombo_.getSelectedIndex();
                valueT_[4].setText(kdnValue_[index]);
            }
        });
        kdtCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = kdtCombo_.getSelectedIndex();
                valueT_[5].setText(kdtValue_[index]);
            }
        });
        kiCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = kiCombo_.getSelectedIndex() + 1;
                valueT_[6].setText(Integer.toString(index));
            }
        });
        helpB_[3].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MutateOptionDialog.this.ShowFsHelp(3);
            }
        });
        helpB_[4].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MutateOptionDialog.this.ShowFsHelp(4);
            }
        });
        helpB_[5].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MutateOptionDialog.this.ShowFsHelp(5);
            }
        });
        helpB_[6].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MutateOptionDialog.this.ShowFsHelp(6);
            }
        });
        helpB_[FO_SIZE + 0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MutateOptionDialog.this.ShowGbHelp(0);
            }
        });
        helpB_[FO_SIZE + 1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MutateOptionDialog.this.ShowGbHelp(1);
            }
        });
        helpB_[FO_SIZE + 2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MutateOptionDialog.this.ShowGbHelp(2);
            }
        });
    }

    public static void ShowDialog(JFrame owner) {
        if (dialog_ == null) {
            dialog_ = new MutateOptionDialog(owner);
        }
        MutateOptionDialog.StoreStatus();
        dialog_.setVisible(true);
    }

    private static void StoreStatus() {
        for (int i = 0; i < SIZE; ++i) {
            MutateOptionDialog.cancelCb_[i] = cb_[i].isSelected();
            MutateOptionDialog.cancelText_[i] = valueT_[i].getText();
        }
    }

    private static void RetrieveStatus() {
        for (int i = 0; i < SIZE; ++i) {
            cb_[i].setSelected(cancelCb_[i]);
            valueT_[i].setText(cancelText_[i]);
        }
        kdCombo_.setSelectedIndex(Integer.parseInt(valueT_[3].getText()) - 1);
        kdnCombo_.setSelectedIndex(LvgFlowSpecificOption.GetDerivationNegationInt(valueT_[4].getText()));
        kdtCombo_.setSelectedIndex(LvgFlowSpecificOption.GetDerivationTypeInt(valueT_[5].getText()));
        kiCombo_.setSelectedIndex(Integer.parseInt(valueT_[6].getText()) - 1);
    }

    private void ShowFsHelp(int index) {
        String lvgDir = LvgGlobal.config_.GetConfiguration("LVG_DIR");
        String optionUrl = "file:" + lvgDir + "docs/designDoc/LifeCycle/requirement/lvgOptions/" + LvgDef.FLOW_SPECIFIC_OPT_DOC[index];
        String homeUrl = "file:" + lvgDir + "docs/designDoc/LifeCycle/requirement/lvgFlowOption.html";
        String title = "Flow Specific Option Documents";
        if (helpDoc_ == null) {
            helpDoc_ = new LvgHtmlBrowser(owner_, title, 600, 800, homeUrl, optionUrl);
        } else {
            helpDoc_.setTitle(title);
            helpDoc_.SetHome(homeUrl);
            helpDoc_.SetPage(optionUrl);
        }
        helpDoc_.setVisible(true);
    }

    private void ShowGbHelp(int index) {
        String lvgDir = LvgGlobal.config_.GetConfiguration("LVG_DIR");
        String optionUrl = "file:" + lvgDir + "docs/designDoc/LifeCycle/requirement/lvgOptions/" + LvgDef.GLOBAL_BEHAVIOR_OPT_DOC[index];
        String homeUrl = "file:" + lvgDir + "docs/designDoc/LifeCycle/requirement/lvgGlobalBehavior.html";
        String title = "Global Behavior Option Documents";
        if (helpDoc_ == null) {
            helpDoc_ = new LvgHtmlBrowser(owner_, title, 600, 800, homeUrl, optionUrl);
        } else {
            helpDoc_.setTitle(title);
            helpDoc_.SetHome(homeUrl);
            helpDoc_.SetPage(optionUrl);
        }
        helpDoc_.setVisible(true);
    }

    static {
        MutateOptionDialog.defaults_[0] = LvgGlobal.config_.GetConfiguration("MIN_TERM_LENGTH");
        MutateOptionDialog.defaults_[1] = LvgGlobal.config_.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS");
        MutateOptionDialog.defaults_[2] = LvgGlobal.config_.GetConfiguration("MAX_METAPHONE");
        MutateOptionDialog.defaults_[3] = Integer.toString(1);
        MutateOptionDialog.defaults_[4] = "O";
        MutateOptionDialog.defaults_[5] = "ZSP";
        MutateOptionDialog.defaults_[6] = Integer.toString(2);
        MutateOptionDialog.defaults_[MutateOptionDialog.FO_SIZE + 2] = GlobalBehavior.GetDefaultFieldSeparator();
        MutateOptionDialog.size_[0] = 3;
        MutateOptionDialog.size_[1] = 3;
        MutateOptionDialog.size_[2] = 3;
        MutateOptionDialog.size_[3] = 3;
        MutateOptionDialog.size_[4] = 3;
        MutateOptionDialog.size_[5] = 3;
        MutateOptionDialog.size_[6] = 3;
        MutateOptionDialog.size_[MutateOptionDialog.FO_SIZE + 2] = 3;
        for (int i = 0; i < SIZE; ++i) {
            if (i <= 2) {
                MutateOptionDialog.cb_[i] = new JCheckBox(LvgDef.FLOW_SPECIFIC_OPT[i], true);
            } else if (i < FO_SIZE) {
                MutateOptionDialog.cb_[i] = new JCheckBox(LvgDef.FLOW_SPECIFIC_OPT[i] + " (-" + LvgDef.FLOW_SPECIFIC_OPT_FLAG[i] + ")");
            } else {
                int ii = i - FO_SIZE;
                MutateOptionDialog.cb_[i] = new JCheckBox(LvgDef.GLOBAL_BEHAVIOR_OPT[ii] + " (-" + LvgDef.GLOBAL_BEHAVIOR_OPT_FLAG[ii] + ")");
            }
            MutateOptionDialog.setB_[i] = new JButton("Setting");
            MutateOptionDialog.helpB_[i] = new JButton("Help");
            MutateOptionDialog.valueT_[i] = new JTextField(defaults_[i], size_[i]);
        }
        valueT_[3].setEditable(false);
        valueT_[4].setEditable(false);
        valueT_[5].setEditable(false);
        valueT_[6].setEditable(false);
        kdCombo_.addItem("Lexicon only");
        kdCombo_.addItem("Lexicon, then rules");
        kdCombo_.addItem("Lexicon and rules");
        kdCombo_.setSelectedIndex(0);
        kdnCombo_.addItem("Otherwise");
        kdnCombo_.addItem("Negation");
        kdnCombo_.addItem("Both");
        kdnCombo_.setSelectedIndex(0);
        kdtCombo_.addItem("ZeroD");
        kdtCombo_.addItem("SuffixD");
        kdtCombo_.addItem("PrefixD");
        kdtCombo_.addItem("ZeroD & SuffixD");
        kdtCombo_.addItem("ZeroD & PrefixD");
        kdtCombo_.addItem("SuffixD & PrefixD");
        kdtCombo_.addItem("ZeroD, SuffixD, & PrefixD");
        kdtCombo_.setSelectedIndex(6);
        kiCombo_.addItem("Lexicon only");
        kiCombo_.addItem("Lexicon, then rules");
        kiCombo_.addItem("Lexicon and rules");
        kiCombo_.setSelectedIndex(1);
    }
}

