/*
 * Decompiled with CFR 0.152.
 */
package GuiTool.Gui;

import GuiTool.Global.LvgDef;
import GuiTool.Global.LvgGlobal;
import GuiTool.Gui.CategoryDialog;
import GuiTool.Gui.FieldSpecifierDialog;
import GuiTool.Gui.InflectionDialog;
import GuiTool.Gui.InputPanel;
import GuiTool.Gui.OutputPanel;
import GuiTool.GuiComp.OkCancelResetButtonPanel;
import GuiTool.GuiLib.GridBag;
import GuiTool.GuiLib.LvgHtmlBrowser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class OutputOptionDialog
extends JDialog {
    private static int SIZE = LvgDef.OUT_OPT_NUM;
    private static JCheckBox[] cb_ = new JCheckBox[SIZE];
    private static JButton[] setB_ = new JButton[SIZE];
    private static JButton[] helpB_ = new JButton[SIZE];
    private static JComboBox<String> sortCombo_ = new JComboBox();
    private static JComboBox<String> caseCombo_ = new JComboBox();
    private static JComboBox<String> combineCombo_ = new JComboBox();
    private static JTextField[] valueT_ = new JTextField[SIZE];
    private static String[] defaults_ = new String[SIZE];
    private static String[] cancelText_ = new String[SIZE];
    private static boolean[] cancelCb_ = new boolean[SIZE];
    private static int[] size_ = new int[SIZE];
    private static boolean[] valueTFlag_ = new boolean[]{false, false, false, true, true, true, true, true, true, true, true, true, true, true, false};
    private static boolean[] setBFlag_ = new boolean[]{false, false, false, false, false, false, true, true, true, true, true, true, true, true, true};
    private static final int OUTPUT_NUM = 2;
    private static final int SCREEN_OUTPUT = 0;
    private static final int FILE_OUTPUT = 1;
    private static JRadioButton[] rb_ = new JRadioButton[2];
    private static ButtonGroup rbGroup_ = null;
    private static JFrame owner_ = null;
    private static OutputOptionDialog outOptionD_ = null;
    private static JCheckBox appendCb_ = new JCheckBox("Append");
    private static LvgHtmlBrowser helpDoc_ = null;
    private static final long serialVersionUID = 5L;

    private OutputOptionDialog(JFrame owner) {
        super(owner, "Lvg Output Options", true);
        owner_ = owner;
        this.setLocation(new Point(100, 200));
        this.setSize(900, 700);
        JPanel topP = new JPanel();
        topP.add(new JLabel("Please select output options:"));
        JPanel optionP = new JPanel();
        optionP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output Options"));
        GridBagLayout gbl = new GridBagLayout();
        optionP.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        GridBag.SetWeight(gbc, 100, 100);
        for (int i = 0; i < SIZE - 1; ++i) {
            GridBag.SetPosSize(gbc, 0, i, 1, 1);
            optionP.add((Component)cb_[i], gbc);
            if (valueTFlag_[i]) {
                GridBag.SetPosSize(gbc, 1, i, 1, 1);
                optionP.add((Component)valueT_[i], gbc);
            }
            if (setBFlag_[i]) {
                GridBag.SetPosSize(gbc, 2, i, 1, 1);
                switch (i) {
                    case 6: {
                        optionP.add(sortCombo_, gbc);
                        break;
                    }
                    case 7: {
                        optionP.add(caseCombo_, gbc);
                        break;
                    }
                    case 8: {
                        optionP.add(combineCombo_, gbc);
                        break;
                    }
                    default: {
                        optionP.add((Component)setB_[i], gbc);
                    }
                }
            }
            GridBag.SetPosSize(gbc, 3, i, 1, 1);
            optionP.add((Component)helpB_[i], gbc);
        }
        GridBag.SetWeight(gbc, 100, 100);
        JPanel targetP = new JPanel();
        targetP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output Target Options"));
        targetP.setLayout(gbl);
        for (int i = 0; i < 2; ++i) {
            GridBag.SetPosSize(gbc, i, 0, 1, 1);
            targetP.add((Component)rb_[i], gbc);
        }
        GridBag.SetPosSize(gbc, 2, 0, 1, 1);
        targetP.add((Component)valueT_[14], gbc);
        GridBag.SetPosSize(gbc, 3, 0, 1, 1);
        targetP.add((Component)appendCb_, gbc);
        GridBag.SetPosSize(gbc, 4, 0, 1, 1);
        targetP.add((Component)setB_[14], gbc);
        GridBag.SetPosSize(gbc, 5, 0, 1, 1);
        targetP.add((Component)helpB_[14], gbc);
        JPanel centerP = new JPanel();
        centerP.setLayout(new GridBagLayout());
        gbc.insets = new Insets(6, 12, 6, 12);
        GridBag.SetPosSize(gbc, 1, 1, 1, 1);
        centerP.add((Component)optionP, gbc);
        GridBag.SetPosSize(gbc, 1, 2, 1, 1);
        centerP.add((Component)targetP, gbc);
        OkCancelResetButtonPanel bottomP = new OkCancelResetButtonPanel();
        JButton okB = bottomP.GetOkButton();
        JButton cancelB = bottomP.GetCancelButton();
        JButton resetB = bottomP.GetResetButton();
        this.getContentPane().add((Component)topP, "North");
        this.getContentPane().add((Component)centerP, "Center");
        this.getContentPane().add((Component)bottomP, "South");
        rb_[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                valueT_[14].setEditable(false);
            }
        });
        rb_[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                valueT_[14].setEditable(true);
            }
        });
        okB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int i;
                block16: for (i = 0; i < SIZE; ++i) {
                    boolean flag = cb_[i].isSelected();
                    String valueStr = new String();
                    if (valueTFlag_[i]) {
                        valueStr = valueT_[i].getText();
                    }
                    switch (i) {
                        case 0: {
                            LvgGlobal.outputOption_.SetShowCategoryStrFlag(flag);
                            continue block16;
                        }
                        case 1: {
                            LvgGlobal.outputOption_.SetShowInflectionStrFlag(flag);
                            continue block16;
                        }
                        case 2: {
                            LvgGlobal.outputOption_.SetFilterInputFlag(flag);
                            continue block16;
                        }
                        case 3: {
                            LvgGlobal.outputOption_.SetMarkEndFlag(flag);
                            LvgGlobal.outputOption_.SetMarkEndStr(valueStr);
                            continue block16;
                        }
                        case 4: {
                            LvgGlobal.outputOption_.SetNoOutputFlag(flag);
                            LvgGlobal.outputOption_.SetNoOutputStr(valueStr);
                            continue block16;
                        }
                        case 5: {
                            if (flag) {
                                LvgGlobal.outputOption_.SetOutRecordNum(Integer.parseInt(valueStr));
                                continue block16;
                            }
                            LvgGlobal.outputOption_.SetOutRecordNum(-1);
                            continue block16;
                        }
                        case 6: {
                            if (flag) {
                                LvgGlobal.outputOption_.SetSortFlag(sortCombo_.getSelectedIndex() + 1);
                                continue block16;
                            }
                            LvgGlobal.outputOption_.SetSortFlag(0);
                            continue block16;
                        }
                        case 7: {
                            if (flag) {
                                LvgGlobal.outputOption_.SetCaseFlag(Integer.parseInt(valueStr));
                                continue block16;
                            }
                            LvgGlobal.outputOption_.SetCaseFlag(1);
                            continue block16;
                        }
                        case 8: {
                            if (flag) {
                                LvgGlobal.outputOption_.SetCombineRule(combineCombo_.getSelectedIndex() + 1);
                                continue block16;
                            }
                            LvgGlobal.outputOption_.SetCombineRule(0);
                            continue block16;
                        }
                        case 9: {
                            if (flag) {
                                LvgGlobal.outputOption_.SetOutCategory(Long.parseLong(valueStr));
                                continue block16;
                            }
                            LvgGlobal.outputOption_.SetOutCategory(2047L);
                            continue block16;
                        }
                        case 10: {
                            if (flag) {
                                LvgGlobal.outputOption_.SetOutInflection(Long.parseLong(valueStr));
                                continue block16;
                            }
                            LvgGlobal.outputOption_.SetOutInflection(0xFFFFFFL);
                            continue block16;
                        }
                        case 11: {
                            if (flag) {
                                LvgGlobal.outputOption_.SetExcludeCategory(Long.parseLong(valueStr));
                                continue block16;
                            }
                            LvgGlobal.outputOption_.SetExcludeCategory(0L);
                            continue block16;
                        }
                        case 12: {
                            if (flag) {
                                LvgGlobal.outputOption_.SetExcludeInflection(Long.parseLong(valueStr));
                                continue block16;
                            }
                            LvgGlobal.outputOption_.SetExcludeInflection(0L);
                            continue block16;
                        }
                        case 13: {
                            if (flag) {
                                LvgGlobal.outputOption_.SetOutputFieldList(FieldSpecifierDialog.GetFieldList());
                                continue block16;
                            }
                            LvgGlobal.outputOption_.SetOutputFieldList(new Vector<Integer>());
                        }
                    }
                }
                LvgGlobal.cmd_.ResetOutputOptions();
                for (i = 0; i < SIZE; ++i) {
                    if (!cb_[i].isSelected()) continue;
                    if (valueTFlag_[i]) {
                        if (i == 3 || i == 4) {
                            LvgGlobal.cmd_.AddOutputOption("-" + LvgDef.OUT_PURE_OPT_FLAG[i]);
                            continue;
                        }
                        LvgGlobal.cmd_.AddOutputOption("-" + LvgDef.OUT_PURE_OPT_FLAG[i] + ":" + valueT_[i].getText());
                        continue;
                    }
                    LvgGlobal.cmd_.AddOutputOption("-" + LvgDef.OUT_PURE_OPT_FLAG[i]);
                }
                LvgGlobal.UpdateCmdStr();
                LvgGlobal.outputToScreen_ = rb_[0].isSelected();
                LvgGlobal.outAppendFlag_ = appendCb_.isSelected();
                if (LvgGlobal.inputFromScreen_ && LvgGlobal.outputToScreen_) {
                    LvgGlobal.UpdateOutputStrings(LvgGlobal.GetOutputLexItems(), InputPanel.GetInLine(), false);
                    OutputPanel.UpdateResult();
                }
                OutputOptionDialog.this.setVisible(false);
            }
        });
        cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputOptionDialog.RetrieveStatus();
                OutputOptionDialog.this.setVisible(false);
            }
        });
        resetB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                for (int i = 0; i < SIZE; ++i) {
                    valueT_[i].setText(defaults_[i]);
                    cb_[i].setSelected(false);
                }
                sortCombo_.setSelectedIndex(0);
                caseCombo_.setSelectedIndex(0);
                combineCombo_.setSelectedIndex(0);
                rb_[0].setSelected(true);
                appendCb_.setSelected(false);
            }
        });
        sortCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = sortCombo_.getSelectedIndex();
                String sortStr = "o";
                switch (index) {
                    case 0: {
                        sortStr = "o";
                        break;
                    }
                    case 1: {
                        sortStr = "oc";
                        break;
                    }
                    case 2: {
                        sortStr = "oci";
                    }
                }
                valueT_[6].setText(sortStr);
            }
        });
        caseCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = caseCombo_.getSelectedIndex() + 1;
                valueT_[7].setText(Integer.toString(index));
            }
        });
        combineCombo_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = combineCombo_.getSelectedIndex();
                String crStr = "o";
                switch (index) {
                    case 0: {
                        crStr = "o";
                        break;
                    }
                    case 1: {
                        crStr = "oc";
                        break;
                    }
                    case 2: {
                        crStr = "oi";
                        break;
                    }
                    case 3: {
                        crStr = "oe";
                    }
                }
                valueT_[8].setText(crStr);
            }
        });
        setB_[13].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FieldSpecifierDialog.ShowDialog(owner_, valueT_[13]);
            }
        });
        setB_[9].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryDialog.ShowDialog(owner_, valueT_[9]);
            }
        });
        setB_[10].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InflectionDialog.ShowDialog(owner_, valueT_[10]);
            }
        });
        setB_[11].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryDialog.ShowDialog(owner_, valueT_[11]);
            }
        });
        setB_[12].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InflectionDialog.ShowDialog(owner_, valueT_[12]);
            }
        });
        setB_[14].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFileChooser dialog = new JFileChooser();
                dialog.setSelectedFile(LvgGlobal.outFile_);
                dialog.setDialogTitle("Choose the output file");
                dialog.setMultiSelectionEnabled(false);
                if (dialog.showDialog(owner_, "Select") == 0) {
                    LvgGlobal.outFile_ = dialog.getSelectedFile();
                    OutputOptionDialog.SetOutputFile(LvgGlobal.outFile_);
                }
            }
        });
        helpB_[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputOptionDialog.this.ShowHelp(0);
            }
        });
        helpB_[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputOptionDialog.this.ShowHelp(1);
            }
        });
        helpB_[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputOptionDialog.this.ShowHelp(2);
            }
        });
        helpB_[3].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputOptionDialog.this.ShowHelp(3);
            }
        });
        helpB_[4].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputOptionDialog.this.ShowHelp(4);
            }
        });
        helpB_[5].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputOptionDialog.this.ShowHelp(5);
            }
        });
        helpB_[6].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputOptionDialog.this.ShowHelp(6);
            }
        });
        helpB_[7].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputOptionDialog.this.ShowHelp(7);
            }
        });
        helpB_[8].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputOptionDialog.this.ShowHelp(8);
            }
        });
        helpB_[9].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputOptionDialog.this.ShowHelp(9);
            }
        });
        helpB_[10].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputOptionDialog.this.ShowHelp(10);
            }
        });
        helpB_[11].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputOptionDialog.this.ShowHelp(11);
            }
        });
        helpB_[12].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputOptionDialog.this.ShowHelp(12);
            }
        });
        helpB_[13].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputOptionDialog.this.ShowHelp(13);
            }
        });
        helpB_[14].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputOptionDialog.this.ShowHelp(14);
            }
        });
    }

    public static void SetOutputFiledsOption(String option) {
        if (option.length() <= 0) {
            cb_[13].setSelected(false);
        } else {
            cb_[13].setSelected(true);
        }
        valueT_[13].setText(option);
        FieldSpecifierDialog.SetFieldStr(option);
        LvgGlobal.outputOption_.SetOutputFieldList(FieldSpecifierDialog.GetFieldList());
    }

    public static void ShowDialog(JFrame owner) {
        if (outOptionD_ == null) {
            outOptionD_ = new OutputOptionDialog(owner);
        }
        OutputOptionDialog.StoreStatus();
        outOptionD_.setVisible(true);
    }

    public static void SetOutputFile(File file) {
        valueT_[14].setText(LvgGlobal.outFile_.getPath());
    }

    private static void StoreStatus() {
        for (int i = 0; i < SIZE; ++i) {
            OutputOptionDialog.cancelCb_[i] = cb_[i].isSelected();
            OutputOptionDialog.cancelText_[i] = valueT_[i].getText();
        }
    }

    private static void RetrieveStatus() {
        for (int i = 0; i < SIZE; ++i) {
            cb_[i].setSelected(cancelCb_[i]);
            valueT_[i].setText(cancelText_[i]);
        }
        sortCombo_.setSelectedIndex(OutputOptionDialog.GetSortComboIndex(valueT_[6].getText()));
        caseCombo_.setSelectedIndex(Integer.parseInt(valueT_[7].getText()) - 1);
        combineCombo_.setSelectedIndex(OutputOptionDialog.GetCombineComboIndex(valueT_[8].getText()));
        rb_[0].setSelected(LvgGlobal.outputToScreen_);
        rb_[1].setSelected(!LvgGlobal.outputToScreen_);
        appendCb_.setSelected(LvgGlobal.outAppendFlag_);
    }

    private static int GetSortComboIndex(String value) {
        int index = 0;
        if (value.equals("o")) {
            index = 0;
        } else if (value.equals("oc")) {
            index = 1;
        } else if (value.equals("oci")) {
            index = 2;
        }
        return index;
    }

    private static int GetCombineComboIndex(String value) {
        int index = 0;
        if (value.equals("o")) {
            index = 0;
        } else if (value.equals("oc")) {
            index = 1;
        } else if (value.equals("oi")) {
            index = 2;
        } else if (value.equals("oe")) {
            index = 3;
        }
        return index;
    }

    private void ShowHelp(int index) {
        String lvgDir = LvgGlobal.config_.GetConfiguration("LVG_DIR");
        String optionUrl = "file:" + lvgDir + "docs/designDoc/LifeCycle/requirement/lvgOptions/" + LvgDef.OUT_OPT_DOC[index];
        if (helpDoc_ == null) {
            String title = "Output Filter Option Documents";
            String homeUrl = "file:" + lvgDir + "docs/designDoc/LifeCycle/requirement/lvgOutputFilter.html";
            helpDoc_ = new LvgHtmlBrowser(owner_, title, 600, 800, homeUrl, optionUrl);
        } else {
            helpDoc_.SetPage(optionUrl);
        }
        helpDoc_.setVisible(true);
    }

    static {
        OutputOptionDialog.defaults_[3] = LvgGlobal.config_.GetConfiguration("CGI_EOP");
        OutputOptionDialog.defaults_[4] = LvgGlobal.config_.GetConfiguration("NO_OUTPUT");
        OutputOptionDialog.defaults_[5] = LvgGlobal.config_.GetConfiguration("TRUNCATED_RESULTS");
        OutputOptionDialog.defaults_[6] = "o";
        OutputOptionDialog.defaults_[7] = "1";
        OutputOptionDialog.defaults_[8] = "o";
        OutputOptionDialog.defaults_[9] = "0";
        OutputOptionDialog.defaults_[10] = "0";
        OutputOptionDialog.defaults_[11] = "0";
        OutputOptionDialog.defaults_[12] = "0";
        OutputOptionDialog.defaults_[14] = LvgGlobal.outFile_.getPath();
        OutputOptionDialog.size_[3] = 10;
        OutputOptionDialog.size_[4] = 10;
        OutputOptionDialog.size_[5] = 3;
        OutputOptionDialog.size_[6] = 3;
        OutputOptionDialog.size_[7] = 3;
        OutputOptionDialog.size_[8] = 3;
        OutputOptionDialog.size_[9] = 4;
        OutputOptionDialog.size_[10] = 8;
        OutputOptionDialog.size_[11] = 4;
        OutputOptionDialog.size_[12] = 8;
        OutputOptionDialog.size_[13] = 10;
        OutputOptionDialog.size_[14] = 40;
        for (int i = 0; i < SIZE; ++i) {
            OutputOptionDialog.cb_[i] = new JCheckBox(LvgDef.OUT_OPT[i] + " (-" + LvgDef.OUT_OPT_FLAG[i] + ")");
            OutputOptionDialog.setB_[i] = new JButton("Setting");
            OutputOptionDialog.helpB_[i] = new JButton("Help");
            OutputOptionDialog.valueT_[i] = new JTextField(defaults_[i], size_[i]);
        }
        valueT_[6].setEditable(false);
        valueT_[7].setEditable(false);
        valueT_[8].setEditable(false);
        valueT_[14].setEditable(false);
        OutputOptionDialog.rb_[0] = new JRadioButton("Screen");
        OutputOptionDialog.rb_[1] = new JRadioButton("File");
        rb_[0].setSelected(true);
        rbGroup_ = new ButtonGroup();
        rbGroup_.add(rb_[0]);
        rbGroup_.add(rb_[1]);
        sortCombo_.addItem("By term");
        sortCombo_.addItem("By term & category");
        sortCombo_.addItem("By term, category, & inflection");
        sortCombo_.setSelectedIndex(0);
        caseCombo_.addItem("Preserve case");
        caseCombo_.addItem("Lower case");
        caseCombo_.addItem("Upper case");
        caseCombo_.setSelectedIndex(0);
        combineCombo_.addItem("By term");
        combineCombo_.addItem("By term & category");
        combineCombo_.addItem("By term & infelction");
        combineCombo_.addItem("By term & Eui");
        combineCombo_.setSelectedIndex(0);
    }
}

