/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Db;

import gov.nih.nlm.nls.lexAccess.Db.DbBase;
import gov.nih.nlm.nls.lexAccess.Lib.Configuration;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DbInflVars {
    public static Vector<String> GetEuis(Connection conn, String inflVar) throws SQLException {
        String query = "SELECT eui FROM INFL_VARS where (inflVarLc = '" + DbBase.FormatSqlStr(inflVar.toLowerCase()) + "')";
        Statement statement = conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        Vector<String> outs = new Vector<String>();
        while (rs.next()) {
            String eui = rs.getString("eui");
            outs.addElement(eui);
        }
        rs.close();
        statement.close();
        return outs;
    }

    public static Vector<String> GetUniqueEuisByInflVar(Connection conn, String inflVar) throws SQLException {
        String query = "SELECT eui FROM INFL_VARS where (inflVarLc = '" + DbBase.FormatSqlStr(inflVar.toLowerCase()) + "')";
        Statement statement = conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        Vector<String> outs = new Vector<String>();
        while (rs.next()) {
            String eui = rs.getString("eui");
            if (outs.contains(eui)) continue;
            outs.addElement(eui);
        }
        rs.close();
        statement.close();
        return outs;
    }

    public static Vector<String> GetBasesByEui(Connection conn, String eui) throws SQLException {
        String query = "SELECT inflVar FROM INFL_VARS where (eui = '" + eui + "' and inflection = 1)";
        Statement statement = conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        Vector<String> outs = new Vector<String>();
        while (rs.next()) {
            String base = rs.getString("inflVar");
            outs.addElement(base);
        }
        rs.close();
        statement.close();
        return outs;
    }

    public static void main(String[] args) {
        String inflVar = "books";
        if (args.length == 1) {
            inflVar = args[0];
        }
        Configuration conf = new Configuration("data.config.la", true);
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                int i;
                Vector<String> euis = DbInflVars.GetUniqueEuisByInflVar(conn, inflVar);
                System.out.println("-- inflVar: " + inflVar + " ---");
                for (i = 0; i < euis.size(); ++i) {
                    System.out.println(euis.elementAt(i));
                }
                euis = DbInflVars.GetEuis(conn, inflVar);
                DbBase.CloseConnection(conn);
                System.out.println("-- inflVar: " + inflVar + " ---");
                for (i = 0; i < euis.size(); ++i) {
                    System.out.println(euis.elementAt(i));
                }
            }
        }
        catch (Exception e) {
            System.out.println("** Error: " + e.getMessage());
        }
    }
}

