/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Db;

import gov.nih.nlm.nls.lexAccess.Db.DbBase;
import gov.nih.nlm.nls.lexAccess.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Category;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;

public class DbLexRecord {
    public static Vector<String> GetRecordsByBase(Connection conn, String base) throws SQLException {
        String query = "SELECT lexRecord FROM LEX_RECORD where (base = '" + DbBase.FormatSqlStr(base) + "' and lastAction <> 3)";
        Statement statement = conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        Vector<String> outs = new Vector<String>();
        while (rs.next()) {
            String lexRecord = rs.getString("lexRecord");
            outs.addElement(lexRecord);
        }
        rs.close();
        statement.close();
        return outs;
    }

    public static Vector<String> GetRecordsByBase(Connection conn, String base, int baseBy) throws SQLException {
        String query = "SELECT lexRecord FROM LEX_RECORD where (base = '" + DbBase.FormatSqlStr(base) + "' and lastAction <> 3)";
        switch (baseBy) {
            case 4: {
                query = "SELECT lexRecord FROM LEX_RECORD where (base = '" + DbBase.FormatSqlStr(base) + "' and lastAction <> 3)";
                break;
            }
            case 3: {
                query = "SELECT lexRecord FROM LEX_RECORD where (base like '%" + DbBase.FormatSqlStr(base) + "' and lastAction <> 3)";
                break;
            }
            case 1: {
                query = "SELECT lexRecord FROM LEX_RECORD where (base like '" + DbBase.FormatSqlStr(base) + "%' and lastAction <> 3)";
                break;
            }
            case 2: {
                query = "SELECT lexRecord FROM LEX_RECORD where (base like '%" + DbBase.FormatSqlStr(base) + "%' and lastAction <> 3)";
            }
        }
        Statement statement = conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        Vector<String> outs = new Vector<String>();
        while (rs.next()) {
            String lexRecord = rs.getString("lexRecord");
            outs.addElement(lexRecord);
        }
        rs.close();
        statement.close();
        return outs;
    }

    public static Vector<String> GetRecordsByCat(Connection conn, long category) throws SQLException {
        String catCondition = DbLexRecord.GetCategoryCondition(category);
        String query = "SELECT lexRecord FROM LEX_RECORD where ((lastAction <> 3)" + catCondition + ")";
        Statement statement = conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        Vector<String> outs = new Vector<String>();
        while (rs.next()) {
            String lexRecord = rs.getString("lexRecord");
            outs.addElement(lexRecord);
        }
        rs.close();
        statement.close();
        return outs;
    }

    public static String GetRecordByEui(Connection conn, String eui) throws SQLException {
        String query = "SELECT lexRecord FROM LEX_RECORD WHERE (eui = '" + eui + "' AND lastAction <> 3)";
        Statement statement = conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        String lexRecord = new String();
        while (rs.next()) {
            lexRecord = rs.getString("lexRecord");
        }
        rs.close();
        statement.close();
        return lexRecord;
    }

    private static String GetCategoryCondition(long category) {
        String outStr = new String();
        String catStr = Category.ToName(category);
        if (catStr == null || catStr.length() == 0) {
            outStr = " AND (category = 'none') ";
        } else if (catStr.equals("all")) {
            outStr = new String();
        } else {
            StringTokenizer buf = new StringTokenizer(catStr, "+");
            outStr = " AND (";
            boolean firstTime = true;
            while (buf.hasMoreTokens()) {
                String curCat = buf.nextToken();
                outStr = firstTime ? outStr + "category='" + curCat + "'" : outStr + " OR category='" + curCat + "'";
                firstTime = false;
            }
            outStr = outStr + ")";
        }
        return outStr;
    }

    public static void main(String[] args) {
        String eui = "E0065088";
        String base = "left";
        Configuration conf = new Configuration("data.config.la", true);
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                String lexRecord = DbLexRecord.GetRecordByEui(conn, eui);
                System.out.println("--- eui: " + eui + " ---");
                System.out.println(lexRecord);
                Vector<String> lexRecords = DbLexRecord.GetRecordsByBase(conn, base);
                DbBase.CloseConnection(conn);
                System.out.println("-- base: " + base + " ---");
                for (int i = 0; i < lexRecords.size(); ++i) {
                    System.out.println(lexRecords.elementAt(i));
                }
            }
        }
        catch (Exception e) {
            System.out.println("** Error: " + e.getMessage());
        }
    }
}

