/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Model;

import gov.nih.nlm.nls.lexAccess.Api.LexAccessApi;
import gov.nih.nlm.nls.lexAccess.Lib.Configuration;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.ByCategoryPanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Model.ConfigObj;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class LaObj {
    private static final String LA_JAR_FILE = "lexAccess2013api.jar";
    public static final int MODE_BY_TERM_EUI = 0;
    public static final int MODE_BY_BASE = 1;
    public static final int MODE_BY_CATEGORY = 2;
    private String versionInfo_ = "LexAccess GUI Tool, 2013";
    private String configFile_ = new String();
    private ConfigObj configObj_ = null;
    private int searchMode_ = 0;
    private LexAccessApi lexAccessApi_ = new LexAccessApi();
    private int baseBy_ = 0;
    private String query_ = new String();
    private long category_ = 0L;
    private long outCat_ = 2047L;
    private boolean noOutputFlag_ = true;
    private boolean showTotalRecNum_ = false;
    private boolean showQuery_ = false;
    public static final int SOURCE_SCREEN = 0;
    public static final int SOURCE_FILE = 1;
    private int inSource_ = 0;
    private int outSource_ = 0;
    private String defaultInFile_ = null;
    private String defaultOutFile_ = null;
    private File inFile_ = null;
    private File outFile_ = null;
    private boolean appendToOutFile_ = false;
    private String noOutputMsg_ = "-No Record Found-";
    private int lexRecordFormat_ = 0;
    private String separator_ = "|";
    public static final int TYPE_UTF8 = 0;
    public static final int TYPE_ASCII = 1;
    private int dataType_ = 0;
    public static final String ASCII_STR = "ASCII";
    private String dataVersion_ = null;

    public LaObj() {
        this.Init();
    }

    public String GetVersionInfo() {
        return this.versionInfo_;
    }

    public ConfigObj GetConfigObj() {
        return this.configObj_;
    }

    public LexAccessApi GetLexAccessApi() {
        return this.lexAccessApi_;
    }

    public String GetLexAccessResultsByTerm(String inStr) {
        String outStr = new String();
        if (inStr == null || inStr.trim().length() == 0) {
            outStr = "** Empty input, please check and re-enter the input term/EUI";
        } else {
            try {
                outStr = this.lexAccessApi_.GetResultStrByTerm(inStr, this.outCat_, this.showQuery_, this.query_, this.noOutputFlag_, this.noOutputMsg_, this.showTotalRecNum_, this.lexRecordFormat_, this.separator_);
            }
            catch (Exception e) {
                System.err.println("** Err@LaObj.GetLexAccessResultsByTerm( ):" + e.getMessage());
            }
        }
        return outStr;
    }

    public String GetLexAccessResultsByBase(String inBase) {
        String outStr = new String();
        if (inBase == null || inBase.trim().length() == 0) {
            outStr = "** Empty input, please check and re-enter the input base";
        } else {
            try {
                outStr = this.lexAccessApi_.GetResultStrByBase(inBase, this.baseBy_, this.outCat_, this.showQuery_, this.query_, this.noOutputFlag_, this.noOutputMsg_, this.showTotalRecNum_, this.lexRecordFormat_, this.separator_);
            }
            catch (Exception e) {
                System.err.println("** Err@LaObj.GetLexAccessResultsByBase( ):" + e.getMessage());
            }
        }
        return outStr;
    }

    public String GetLexAccessResultsByCategory(long inCategory) {
        String outStr = new String();
        if (inCategory == 0L) {
            outStr = "** Empty input, please check and re-select category";
        } else {
            try {
                outStr = this.lexAccessApi_.GetResultStrByCategory(inCategory, this.showQuery_, this.query_, this.noOutputFlag_, this.noOutputMsg_, this.showTotalRecNum_, this.lexRecordFormat_, this.separator_);
            }
            catch (Exception e) {
                System.err.println("** Err@LaObj.GetLexAccessResultsByBase( ):" + e.getMessage());
            }
        }
        return outStr;
    }

    public void CleanUp() {
        if (this.lexAccessApi_ != null) {
            this.lexAccessApi_.CleanUp();
        }
    }

    public int GetSearchMode() {
        return this.searchMode_;
    }

    public void SetSearchMode(int searchMode) {
        this.searchMode_ = searchMode;
    }

    public void SetBaseBy(String baseBy) {
        if (baseBy.equals("EXACT_MATCH")) {
            this.baseBy_ = 0;
        } else if (baseBy.equals("BEGIN_WITH")) {
            this.baseBy_ = 1;
        } else if (baseBy.equals("CONTAIN")) {
            this.baseBy_ = 2;
        } else if (baseBy.equals("END_WITH")) {
            this.baseBy_ = 3;
        }
    }

    public void SetNoOutputFlag(boolean noOutputFlag) {
        this.noOutputFlag_ = noOutputFlag;
    }

    public boolean GetNoOutputFlag() {
        return this.noOutputFlag_;
    }

    public void SetShowTotalRecNum(boolean showTotalRecNum) {
        this.showTotalRecNum_ = showTotalRecNum;
    }

    public boolean GetShowTotalRecNum() {
        return this.showTotalRecNum_;
    }

    public void SetShowQuery(boolean showQuery) {
        this.showQuery_ = showQuery;
    }

    public boolean GetShowQuery() {
        return this.showQuery_;
    }

    public void SetSeparator(String separator) {
        this.separator_ = separator;
    }

    public String GetSeparator() {
        return this.separator_;
    }

    public void SetLexRecordFormat(int format) {
        this.lexRecordFormat_ = format;
    }

    public int GetLexRecordFormat() {
        return this.lexRecordFormat_;
    }

    public long GetOutFilterCategory() {
        return this.outCat_;
    }

    public void SetOutCategoryFilter(Vector<Boolean> outCategoryValues) {
        this.outCat_ = 0L;
        for (int i = 0; i < outCategoryValues.size(); ++i) {
            if (!outCategoryValues.elementAt(i).booleanValue()) continue;
            this.outCat_ = Bit.Add(this.outCat_, ByCategoryPanel.CATEGORY_VALUE[i]);
        }
    }

    public void ResetAllOptions() {
        this.SetInSource(0);
        this.SetInFile(new File(this.defaultInFile_));
        this.SetOutSource(0);
        this.SetOutFile(new File(this.defaultOutFile_));
        this.SetAppendToOutFile(false);
        this.SetNoOutputFlag(true);
        this.SetShowTotalRecNum(false);
        this.SetShowQuery(false);
        this.SetSeparator("|");
        this.SetLexRecordFormat(0);
        Vector<Boolean> categoryValues = new Vector<Boolean>();
        for (int i = 0; i < 11; ++i) {
            categoryValues.addElement(new Boolean(true));
        }
        this.SetOutCategoryFilter(categoryValues);
    }

    public void SetInSource(int inSource) {
        this.inSource_ = inSource;
    }

    public int GetInSource() {
        return this.inSource_;
    }

    public String GetDefaultInFile() {
        return this.defaultInFile_;
    }

    public void SetOutSource(int outSource) {
        this.outSource_ = outSource;
    }

    public int GetOutSource() {
        return this.outSource_;
    }

    public String GetDefaultOutFile() {
        return this.defaultOutFile_;
    }

    public void SetInFile(File inFile) {
        this.inFile_ = inFile;
    }

    public File GetInFile() {
        return this.inFile_;
    }

    public void SetOutFile(File outFile) {
        this.outFile_ = outFile;
    }

    public File GetOutFile() {
        return this.outFile_;
    }

    public void SetAppendToOutFile(boolean appendToOutFile) {
        this.appendToOutFile_ = appendToOutFile;
    }

    public boolean GetAppendToOutFile() {
        return this.appendToOutFile_;
    }

    public void SetDataType(int dataType) {
        this.dataType_ = dataType;
    }

    public int GetDataType() {
        return this.dataType_;
    }

    public void SetDataVersion(String dataVersion) {
        this.dataVersion_ = dataVersion;
    }

    public String GetDataVersion() {
        return this.dataVersion_;
    }

    public String GetDbVersion() {
        String dbVersion = this.dataVersion_;
        if (this.dataType_ == 1) {
            dbVersion = dbVersion + ASCII_STR;
        }
        return dbVersion;
    }

    public boolean ResetDbConnection() {
        String dbVersion = this.GetDbVersion();
        boolean flag = this.lexAccessApi_.ResetDbConnection(dbVersion);
        return flag;
    }

    private void Init() {
        this.Init(null);
    }

    private void Init(String configFile) {
        this.lexAccessApi_ = new LexAccessApi(configFile);
        boolean useClassPath = false;
        if (configFile == null) {
            useClassPath = true;
            configFile = "data.config.lexAccess";
        }
        Configuration config = new Configuration(configFile, useClassPath);
        this.configObj_ = new ConfigObj(config);
        try {
            JarFile jarFile = new JarFile(LaObj.FindJarPath(LA_JAR_FILE));
            Manifest manifest = jarFile.getManifest();
            String buildDate = manifest.getMainAttributes().getValue("Implementation-TIME");
            this.versionInfo_ = "LexAccess GUI Tool, 2013\nBuild: " + buildDate;
        }
        catch (Exception e) {
            System.err.println("** Err@LaObj.Init( ) " + e.toString());
        }
        String dataDir = this.configObj_.GetLaDir() + "data/ioFiles/";
        this.defaultInFile_ = dataDir + "in.data";
        this.defaultOutFile_ = dataDir + "out.data";
        this.inFile_ = new File(this.defaultInFile_);
        this.outFile_ = new File(this.defaultOutFile_);
        this.dataVersion_ = String.valueOf(this.configObj_.GetLatestVersion());
    }

    private static String FindJarPath(String jarFileName) {
        String jarFilePath = jarFileName;
        String classpath = System.getProperty("java.class.path");
        Vector<String> classpathList = new Vector<String>();
        StringTokenizer buf = new StringTokenizer(classpath, ":;");
        while (buf.hasMoreTokens()) {
            String temp = buf.nextToken();
            classpathList.add(temp);
        }
        for (int i = 0; i < classpathList.size(); ++i) {
            String cur = (String)classpathList.elementAt(i);
            if (!cur.endsWith(jarFileName) || !new File(cur).exists()) continue;
            jarFilePath = cur;
            break;
        }
        return jarFilePath;
    }
}

