/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Api;

import gov.nih.nlm.nls.lexCheck.Gram.CheckGrammer;
import gov.nih.nlm.nls.lexCheck.Lib.CheckSt;
import gov.nih.nlm.nls.lexCheck.Lib.InflVar;
import gov.nih.nlm.nls.lexCheck.Lib.InflVarsAndAgreements;
import gov.nih.nlm.nls.lexCheck.Lib.LineObject;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class ToInflVarsApi {
    public static Vector<InflVar> GetInflVarsFromTextFile(String inFile) {
        CheckSt st = new CheckSt();
        CheckSt catSt = new CheckSt(40);
        LineObject lineObject = new LineObject();
        Vector<InflVar> inflVars = new Vector<InflVar>();
        try {
            BufferedReader inReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF-8"));
            while (lineObject != null) {
                if (lineObject.IsGoToNext()) {
                    lineObject.SetLine(inReader.readLine());
                    lineObject.IncreaseLineNum();
                }
                if (lineObject.GetLine() == null) break;
                boolean flag = CheckGrammer.Check(lineObject, true, st, catSt, false);
                if (st.GetCurState() != 10 || !flag) continue;
                InflVarsAndAgreements infls = new InflVarsAndAgreements(CheckGrammer.GetLexRecord());
                inflVars.addAll(infls.GetInflValues());
            }
            inReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inflVars;
    }

    public static void main(String[] args) {
        String inFile = "molt";
        Vector<InflVar> temp = ToInflVarsApi.GetInflVarsFromTextFile(inFile);
    }
}

