/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Compl;

import gov.nih.nlm.nls.lexCheck.Lib.GlobalVars;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;

public class CheckPreposition {
    private static final int PREPOSITION_NUM = 200;
    private static HashSet<String> preposition_ = new HashSet(200);

    public CheckPreposition() {
        String inFile = GlobalVars.GetPrepositionFile();
        CheckPreposition.Init(inFile);
    }

    public static boolean IsLegal(String term) {
        if (preposition_.size() == 0) {
            String prepositionFile = GlobalVars.GetPrepositionFile();
            CheckPreposition.Init(prepositionFile);
        }
        boolean flag = preposition_.contains(term);
        return flag;
    }

    private static void Init(String inFile) {
        String line = null;
        int prepNo = 0;
        try {
            BufferedReader in = null;
            if (inFile.length() != 0 && new File(inFile).exists()) {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF-8"));
            } else {
                inFile = "/prepositions.data";
                in = new BufferedReader(new InputStreamReader(CheckPreposition.class.getResourceAsStream(inFile)));
            }
            while ((line = in.readLine()) != null) {
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                ++prepNo;
                preposition_.add(line);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("** Err: problem of reading file: " + inFile + " at line: " + prepNo);
            System.err.println("Exception: " + e.toString());
        }
    }
}

