/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Lib;

import gov.nih.nlm.nls.lexCheck.Lib.CatEntry;
import gov.nih.nlm.nls.lexCheck.Lib.GlobalVars;
import gov.nih.nlm.nls.lexCheck.Lib.InflVar;
import gov.nih.nlm.nls.lexCheck.Lib.InflVarsAndAgreements;
import gov.nih.nlm.nls.lexCheck.Lib.TextLib;
import gov.nih.nlm.nls.lexCheck.Lib.XmlLib;
import java.util.Vector;

public class LexRecord {
    private String base_ = null;
    private Vector<String> spellingVars_ = new Vector();
    private String eui_ = null;
    private String category_ = null;
    private CatEntry catEntry_ = null;
    private Vector<String> acronyms_ = new Vector();
    private Vector<String> abbreviations_ = new Vector();
    private Vector<String> annotations_ = new Vector();
    private String signature_ = null;
    private String end_ = "}";
    private boolean printXmlHeader_ = true;
    private static String xmlHeader_ = GlobalVars.GetXmlHeader();
    private static String xmlRootTag_ = "lexRecords";

    public LexRecord() {
        this.spellingVars_ = new Vector();
        this.acronyms_ = new Vector();
        this.abbreviations_ = new Vector();
        this.annotations_ = new Vector();
    }

    public void SetLexRecord(LexRecord lexRecord) {
        this.base_ = lexRecord.GetBase();
        this.spellingVars_ = lexRecord.GetSpellingVars();
        this.eui_ = lexRecord.GetEui();
        this.category_ = lexRecord.GetCategory();
        this.catEntry_ = lexRecord.GetCatEntry();
        this.acronyms_ = lexRecord.GetAcronyms();
        this.abbreviations_ = lexRecord.GetAbbreviations();
        this.annotations_ = lexRecord.GetAnnotations();
        this.signature_ = lexRecord.GetSignature();
        this.end_ = lexRecord.GetEnd();
    }

    public void Reset() {
        this.base_ = new String();
        this.spellingVars_ = new Vector();
        this.eui_ = null;
        this.category_ = new String();
        this.catEntry_ = null;
        this.acronyms_ = new Vector();
        this.abbreviations_ = new Vector();
        this.annotations_ = new Vector();
        this.signature_ = null;
        this.end_ = "}";
    }

    public String GetXml() {
        return this.GetXml(0);
    }

    public static String GetXmlRootBeginTag() {
        String xml = "<" + xmlRootTag_ + ">";
        return xml;
    }

    public static String GetXmlRootEndTag() {
        String xml = "</" + xmlRootTag_ + ">";
        return xml;
    }

    public String GetXml(int indLevel) {
        boolean convertFlag = true;
        String xml = new String();
        xml = XmlLib.AddToXml(xml, "<lexRecord>", indLevel);
        xml = XmlLib.AddToXml(xml, "<base>", "</base>", this.base_, indLevel + 1, convertFlag);
        xml = XmlLib.AddToXml(xml, "<eui>", "</eui>", this.eui_, indLevel + 1, convertFlag);
        xml = XmlLib.AddToXml(xml, "<cat>", "</cat>", this.category_, indLevel + 1, convertFlag);
        xml = XmlLib.AddToXml(xml, "<spellingVars>", "</spellingVars>", this.spellingVars_, indLevel + 1, convertFlag);
        xml = xml + InflVarsAndAgreements.GetXml(this);
        xml = xml + this.catEntry_.GetXml(this.category_);
        xml = XmlLib.AddToXml(xml, "<acronyms>", "</acronyms>", this.acronyms_, indLevel + 1, convertFlag);
        xml = XmlLib.AddToXml(xml, "<abbreviations>", "</abbreviations>", this.abbreviations_, indLevel + 1, convertFlag);
        xml = XmlLib.AddToXml(xml, "<annotations>", "</annotations>", this.annotations_, indLevel + 1, convertFlag);
        xml = XmlLib.AddToXml(xml, "<signature>", "</signature>", this.signature_, indLevel + 1, convertFlag);
        xml = XmlLib.AddToXml(xml, "</lexRecord>", indLevel);
        return xml;
    }

    public String GetText() {
        String text = new String();
        text = TextLib.AddToText(text, "{base=", this.base_, 0);
        text = TextLib.AddToText(text, "spelling_variant=", this.spellingVars_, 0);
        text = TextLib.AddToText(text, "entry=", this.eui_, 0);
        text = TextLib.AddToText(text, "cat=", this.category_, 1);
        text = text + this.catEntry_.GetText(this.category_);
        text = TextLib.AddToText(text, "acronym_of=", this.acronyms_, 1);
        text = TextLib.AddToText(text, "abbreviation_of=", this.abbreviations_, 1);
        text = TextLib.AddToText(text, "annotation=", this.annotations_, 0);
        text = TextLib.AddToText(text, "signature=", this.signature_, 0);
        text = TextLib.AddToText(text, "", this.end_, 0);
        return text;
    }

    public String GetReleaseFormatText() {
        String text = new String();
        text = TextLib.AddToText(text, "{base=", this.base_, 0);
        text = TextLib.AddToText(text, "spelling_variant=", this.spellingVars_, 0);
        text = TextLib.AddToText(text, "entry=", this.eui_, 0);
        text = TextLib.AddToText(text, "cat=", this.category_, 1);
        text = text + this.catEntry_.GetText(this.category_);
        text = TextLib.AddToText(text, "acronym_of=", this.acronyms_, 1);
        text = TextLib.AddToText(text, "abbreviation_of=", this.abbreviations_, 1);
        text = TextLib.AddToText(text, "", this.end_, 0);
        return text;
    }

    public String GetDbFormatText(String cDate) {
        String SP = "|";
        String cSig = this.signature_;
        String mSig = this.signature_;
        String aSig = "browne";
        int lastAct = 0;
        String text = new String();
        text = this.eui_ + SP + this.base_ + SP + this.category_ + SP + cSig + SP + mSig + SP + aSig + SP + lastAct + SP + cDate + SP + cDate + SP + cDate + SP;
        text = TextLib.AddToText(text, "{base=", this.base_, 0);
        text = TextLib.AddToText(text, "spelling_variant=", this.spellingVars_, 0);
        text = TextLib.AddToText(text, "entry=", this.eui_, 0);
        text = TextLib.AddToText(text, "cat=", this.category_, 1);
        text = text + this.catEntry_.GetText(this.category_);
        text = TextLib.AddToText(text, "acronym_of=", this.acronyms_, 1);
        text = TextLib.AddToText(text, "abbreviation_of=", this.abbreviations_, 1);
        text = TextLib.AddToText(text, "", this.end_, 0);
        return text;
    }

    public InflVarsAndAgreements GetInflVarsAndAgreements() {
        return new InflVarsAndAgreements(this);
    }

    public void Print() {
        System.out.print(this.GetText());
        System.out.print(this.GetXml());
    }

    public void PrintReleaseFormatText() {
        System.out.print(this.GetReleaseFormatText());
    }

    public void PrintDbFormatText(String cDate) {
        System.out.print(this.GetDbFormatText(cDate));
    }

    public void PrintText() {
        System.out.print(this.GetText());
    }

    public void PrintXml() {
        System.out.print(this.GetXml());
    }

    public String GetBase() {
        return this.base_;
    }

    public String GetEui() {
        return this.eui_;
    }

    public Vector<String> GetSpellingVars() {
        return this.spellingVars_;
    }

    public Vector<String> GetAcronyms() {
        return this.acronyms_;
    }

    public Vector<String> GetAbbreviations() {
        return this.abbreviations_;
    }

    public Vector<String> GetNominalizations() {
        Vector<String> nominalizations = new Vector();
        if (this.category_.equals("noun")) {
            nominalizations = this.catEntry_.GetNounEntry().GetNominalization();
        } else if (this.category_.equals("verb")) {
            nominalizations = this.catEntry_.GetVerbEntry().GetNominalization();
        } else if (this.category_.equals("adj")) {
            nominalizations = this.catEntry_.GetAdjEntry().GetNominalization();
        }
        return nominalizations;
    }

    public Vector<String> GetVariants() {
        Vector<String> variants = new Vector();
        if (this.category_.equals("noun")) {
            variants = this.catEntry_.GetNounEntry().GetVariants();
        } else if (this.category_.equals("verb")) {
            variants = this.catEntry_.GetVerbEntry().GetVariants();
        } else if (this.category_.equals("adj")) {
            variants = this.catEntry_.GetAdjEntry().GetVariants();
        } else if (this.category_.equals("adv")) {
            variants = this.catEntry_.GetAdvEntry().GetVariants();
        } else if (this.category_.equals("pron")) {
            variants = this.catEntry_.GetPronEntry().GetVariants();
        } else if (this.category_.equals("modal")) {
            variants = this.catEntry_.GetModalEntry().GetVariant();
        } else if (this.category_.equals("aux")) {
            variants = this.catEntry_.GetAuxEntry().GetVariant();
        }
        return variants;
    }

    public Vector<String> GetAnnotations() {
        return this.annotations_;
    }

    public String GetSignature() {
        return this.signature_;
    }

    public String GetCategory() {
        return this.category_;
    }

    public String GetEnd() {
        return this.end_;
    }

    public void SetBase(String base) {
        this.base_ = base;
    }

    public void SetEui(String eui) {
        this.eui_ = eui;
    }

    public void SetSpellingVar(String spellingVar) {
        this.spellingVars_.add(spellingVar);
    }

    public void SetSpellingVars(Vector<String> spellingVars) {
        this.spellingVars_ = spellingVars;
    }

    public void SetAcronym(String acronym) {
        this.acronyms_.add(acronym);
    }

    public void SetAbbreviation(String abbreviation) {
        this.abbreviations_.add(abbreviation);
    }

    public void SetAnnotation(String annotation) {
        this.annotations_.add(annotation);
    }

    public void SetAcronyms(Vector<String> acronyms) {
        this.acronyms_ = acronyms;
    }

    public void SetAbbreviations(Vector<String> abbreviations) {
        this.abbreviations_ = abbreviations;
    }

    public void SetNominalizations(Vector<String> nominalizations) {
        if (this.category_.equals("noun")) {
            this.catEntry_.GetNounEntry().SetNominalization(nominalizations);
        } else if (this.category_.equals("verb")) {
            this.catEntry_.GetVerbEntry().SetNominalization(nominalizations);
        } else if (this.category_.equals("adj")) {
            this.catEntry_.GetAdjEntry().SetNominalization(nominalizations);
        }
    }

    public void SetVariants(Vector<String> variants) {
        if (this.category_.equals("noun")) {
            this.catEntry_.GetNounEntry().SetVariants(variants);
        } else if (this.category_.equals("verb")) {
            this.catEntry_.GetVerbEntry().SetVariants(variants);
        } else if (this.category_.equals("adj")) {
            this.catEntry_.GetAdjEntry().SetVariants(variants);
        } else if (this.category_.equals("adv")) {
            this.catEntry_.GetAdvEntry().SetVariants(variants);
        } else if (this.category_.equals("pron")) {
            this.catEntry_.GetPronEntry().SetVariants(variants);
        } else if (this.category_.equals("modal")) {
            this.catEntry_.GetModalEntry().SetVariant(variants);
        } else if (this.category_.equals("aux")) {
            this.catEntry_.GetAuxEntry().SetVariant(variants);
        }
    }

    public void SetAnnotations(Vector<String> annotations) {
        this.annotations_ = annotations;
    }

    public void SetSignature(String signature) {
        this.signature_ = signature;
    }

    public void SetCat(String category) {
        this.category_ = category;
        this.catEntry_ = new CatEntry(this.category_);
    }

    public void SetCatEntry(CatEntry catEntry) {
        this.catEntry_ = catEntry;
    }

    public void SetEnd(String end) {
        this.end_ = end;
    }

    public void SetPrintXmlHeader(boolean printXmlHeader) {
        this.printXmlHeader_ = printXmlHeader;
    }

    public void SetXmlHeader(String xmlHeader) {
        xmlHeader_ = xmlHeader;
    }

    public static void SetXmlRootTag(String xmlRootTag) {
        xmlRootTag_ = xmlRootTag;
    }

    public CatEntry GetCatEntry() {
        return this.catEntry_;
    }

    public static String GetXmlHeader() {
        return xmlHeader_;
    }

    public static void main(String[] args) {
        LexRecord lexRec = new LexRecord();
        lexRec.SetBase("123");
        lexRec.SetCat("noun");
        lexRec.GetCatEntry().GetNounEntry().AddVariant("irreg|123||");
        lexRec.GetCatEntry().GetNounEntry().AddVariant("group(irreg|123|222|)");
        System.out.println("----------------");
        System.out.println(lexRec.GetText());
        System.out.println("----------------");
        InflVarsAndAgreements inflVars = lexRec.GetInflVarsAndAgreements();
        Vector<InflVar> inflValues = inflVars.GetInflValues();
        for (int i = 0; i < inflValues.size(); ++i) {
            InflVar inflectionVar = inflValues.elementAt(i);
            System.out.println(inflectionVar.GetVar() + "|" + inflectionVar.GetCat() + "|" + inflectionVar.GetInflection() + "|" + inflectionVar.GetUnInfl() + "|" + inflectionVar.GetCit() + "|" + inflectionVar.GetType());
        }
    }
}

