/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Lib;

import gov.nih.nlm.nls.lexCheck.Lib.TextLib;
import gov.nih.nlm.nls.lexCheck.Lib.XmlLib;
import java.util.Vector;

public class PronEntry {
    private Vector<String> variants_ = new Vector();
    private String gender_ = null;
    private boolean interrogative_ = false;
    private Vector<String> type_ = new Vector();

    public PronEntry() {
        this.variants_ = new Vector();
        this.type_ = new Vector();
    }

    public Vector<String> GetVariants() {
        return this.variants_;
    }

    public String GetGender() {
        return this.gender_;
    }

    public boolean IsInterrogative() {
        return this.interrogative_;
    }

    public Vector<String> GetType() {
        return this.type_;
    }

    public void AddVariant(String variant) {
        this.variants_.add(variant);
    }

    public void SetVariants(Vector<String> variants) {
        this.variants_ = variants;
    }

    public void SetGender(String gender) {
        this.gender_ = gender;
    }

    public void SetInterrogative(boolean interrogative) {
        this.interrogative_ = interrogative;
    }

    public void AddType(String type) {
        this.type_.add(type);
    }

    public void SetType(Vector<String> type) {
        this.type_ = type;
    }

    public String GetText() {
        String text = new String();
        text = TextLib.AddToText(text, "variants=", this.variants_, 1);
        text = TextLib.AddToText(text, "gender=", this.gender_, 1);
        text = TextLib.AddToText(text, "interrogative", this.interrogative_, 1);
        text = TextLib.AddToText(text, "type=", this.type_, 1);
        return text;
    }

    public String GetXml() {
        boolean convertFlag = true;
        String xml = new String();
        xml = XmlLib.AddToXml(xml, "<pronEntry>", 2);
        xml = XmlLib.AddToXml(xml, "<variants>", "</variants>", this.variants_, 3, convertFlag);
        xml = XmlLib.AddToXml(xml, "<type>", "</type>", this.type_, 3, convertFlag);
        if (this.gender_ != null) {
            String genderTag = "<gender type=\"" + this.gender_ + "\"/>";
            xml = XmlLib.AddToXml(xml, genderTag, 3);
        }
        xml = XmlLib.AddToXml(xml, "<interrogative/>", this.interrogative_, 3);
        xml = XmlLib.AddToXml(xml, "</pronEntry>", 2);
        return xml;
    }
}

