/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Api;

import gov.nih.nlm.nls.lvg.Api.LvgHelp;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionUtility;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.SystemOption;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToAcronyms;
import gov.nih.nlm.nls.lvg.Flows.ToAntiNorm;
import gov.nih.nlm.nls.lvg.Flows.ToBaseSpellingVariants;
import gov.nih.nlm.nls.lvg.Flows.ToCanonicalize;
import gov.nih.nlm.nls.lvg.Flows.ToCitation;
import gov.nih.nlm.nls.lvg.Flows.ToConvertOutput;
import gov.nih.nlm.nls.lvg.Flows.ToDerivation;
import gov.nih.nlm.nls.lvg.Flows.ToDerivationByCategory;
import gov.nih.nlm.nls.lvg.Flows.ToExpansions;
import gov.nih.nlm.nls.lvg.Flows.ToFilter;
import gov.nih.nlm.nls.lvg.Flows.ToFilterAcronym;
import gov.nih.nlm.nls.lvg.Flows.ToFilterProperNoun;
import gov.nih.nlm.nls.lvg.Flows.ToFruitfulEnhanced;
import gov.nih.nlm.nls.lvg.Flows.ToFruitfulVariants;
import gov.nih.nlm.nls.lvg.Flows.ToFruitfulVariantsDb;
import gov.nih.nlm.nls.lvg.Flows.ToFruitfulVariantsLex;
import gov.nih.nlm.nls.lvg.Flows.ToGetUnicodeNames;
import gov.nih.nlm.nls.lvg.Flows.ToGetUnicodeSynonyms;
import gov.nih.nlm.nls.lvg.Flows.ToInflection;
import gov.nih.nlm.nls.lvg.Flows.ToInflectionByCatInfl;
import gov.nih.nlm.nls.lvg.Flows.ToInflectionSimple;
import gov.nih.nlm.nls.lvg.Flows.ToLowerCase;
import gov.nih.nlm.nls.lvg.Flows.ToLuiNormalize;
import gov.nih.nlm.nls.lvg.Flows.ToMapSymbolToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToMapUnicodeToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToMetaphone;
import gov.nih.nlm.nls.lvg.Flows.ToNoOperation;
import gov.nih.nlm.nls.lvg.Flows.ToNominalization;
import gov.nih.nlm.nls.lvg.Flows.ToNormUnicode;
import gov.nih.nlm.nls.lvg.Flows.ToNormUnicodeWithSynonym;
import gov.nih.nlm.nls.lvg.Flows.ToNormUninflectWords;
import gov.nih.nlm.nls.lvg.Flows.ToNormalize;
import gov.nih.nlm.nls.lvg.Flows.ToRecursiveDerivations;
import gov.nih.nlm.nls.lvg.Flows.ToRecursiveSynonyms;
import gov.nih.nlm.nls.lvg.Flows.ToRemoveGenitive;
import gov.nih.nlm.nls.lvg.Flows.ToRemoveS;
import gov.nih.nlm.nls.lvg.Flows.ToReplacePunctuationWithSpace;
import gov.nih.nlm.nls.lvg.Flows.ToRetrieveCatInfl;
import gov.nih.nlm.nls.lvg.Flows.ToRetrieveCatInflBegin;
import gov.nih.nlm.nls.lvg.Flows.ToRetrieveCatInflDb;
import gov.nih.nlm.nls.lvg.Flows.ToRetrieveEui;
import gov.nih.nlm.nls.lvg.Flows.ToSimpleInflections;
import gov.nih.nlm.nls.lvg.Flows.ToSortWordsByOrder;
import gov.nih.nlm.nls.lvg.Flows.ToSpellingVariants;
import gov.nih.nlm.nls.lvg.Flows.ToSplitLigatures;
import gov.nih.nlm.nls.lvg.Flows.ToStripAmbiguityTags;
import gov.nih.nlm.nls.lvg.Flows.ToStripDiacritics;
import gov.nih.nlm.nls.lvg.Flows.ToStripMapUnicode;
import gov.nih.nlm.nls.lvg.Flows.ToStripNecNos;
import gov.nih.nlm.nls.lvg.Flows.ToStripPunctuation;
import gov.nih.nlm.nls.lvg.Flows.ToStripPunctuationEnhanced;
import gov.nih.nlm.nls.lvg.Flows.ToStripStopWords;
import gov.nih.nlm.nls.lvg.Flows.ToSynonyms;
import gov.nih.nlm.nls.lvg.Flows.ToSyntacticUninvert;
import gov.nih.nlm.nls.lvg.Flows.ToTokenize;
import gov.nih.nlm.nls.lvg.Flows.ToTokenizeKeepAll;
import gov.nih.nlm.nls.lvg.Flows.ToTokenizeNoHyphens;
import gov.nih.nlm.nls.lvg.Flows.ToUnicodeCoreNorm;
import gov.nih.nlm.nls.lvg.Flows.ToUninflectTerm;
import gov.nih.nlm.nls.lvg.Flows.ToUninflectWords;
import gov.nih.nlm.nls.lvg.Flows.ToUninvert;
import gov.nih.nlm.nls.lvg.Flows.ToWordSize;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Flow;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.LvgFlowSpecificOption;
import gov.nih.nlm.nls.lvg.Lib.LvgOutputOption;
import gov.nih.nlm.nls.lvg.Lib.OutputFilter;
import gov.nih.nlm.nls.lvg.Trie.RTrieTree;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Util.Out;
import gov.nih.nlm.nls.lvg.Util.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class LvgCmdApi
extends SystemOption {
    protected Vector<String> quitStrList_ = new Vector();
    protected boolean runFlag_ = true;
    protected static BufferedReader inReader_ = null;
    private static BufferedWriter outWriter_ = null;
    private static boolean fileOutput_ = false;
    protected Vector<String> flowStrs_ = new Vector();
    protected Vector<Vector<String>> flowStrsList_ = new Vector();
    private boolean dbFlag_ = false;
    private Option option_ = new Option("");
    private String promptStr_ = null;
    private String originalTerm_ = null;
    protected int termFieldNum_ = 1;
    protected int catFieldNum_ = -1;
    protected int inflFieldNum_ = -1;
    private LvgOutputOption lvgOutputOption_ = new LvgOutputOption();
    private LvgFlowSpecificOption lvgFlowSpecificOption_ = new LvgFlowSpecificOption();
    protected boolean promptFlag_ = false;
    private int wordSize_ = 2;
    private boolean detailsFlag_ = false;
    private boolean mutateFlag_ = false;
    private String startTag_ = null;
    private String endTag_ = null;
    private Vector<String> derivationCatList_ = new Vector();
    private int curDerivationCatNum_ = 0;
    private Vector<String> inflectionCatList_ = new Vector();
    private Vector<String> inflectionInflList_ = new Vector();
    private int curInflectionByCatInflCount_ = 0;
    private int curInflectionByCatInflNum_ = 0;
    private int flowNum_ = 0;
    private Connection conn_ = null;
    private RamTrie ramTrieI_ = null;
    private RamTrie ramTrieD_ = null;
    private String configFile_ = null;
    private Configuration conf_ = null;
    private Hashtable<String, String> properties_ = null;
    private Vector<String> stopWords_ = null;
    private Vector<String> nonInfoWords_ = null;
    private Vector<String> conjunctionWords_ = null;
    private Hashtable<Character, Character> diacriticMap_ = null;
    private Hashtable<Character, String> ligatureMap_ = null;
    private Hashtable<Character, Character> unicodeSynonymMap_ = null;
    private Hashtable<Character, String> symbolMap_ = null;
    private Hashtable<Character, String> unicodeMap_ = null;
    private Hashtable<Character, String> nonStripMap_ = null;
    private RTrieTree removeSTree_ = null;

    public LvgCmdApi() {
        this.Init();
    }

    public LvgCmdApi(String optionStr) {
        this.option_ = new Option(optionStr);
        this.Init();
    }

    public LvgCmdApi(String optionStr, String configFile) {
        this.option_ = new Option(optionStr);
        this.configFile_ = configFile;
        this.Init();
    }

    public LvgCmdApi(Hashtable<String, String> properties) {
        this.properties_ = properties;
        this.Init();
    }

    public LvgCmdApi(String optionStr, Hashtable<String, String> properties) {
        this.option_ = new Option(optionStr);
        this.properties_ = properties;
        this.Init();
    }

    public LvgCmdApi(String optionStr, String configFile, Hashtable<String, String> properties) {
        this.option_ = new Option(optionStr);
        this.configFile_ = configFile;
        this.properties_ = properties;
        this.Init();
    }

    public void SetPromptStr(String promptStr) {
        this.promptStr_ = promptStr;
    }

    public void SetQuitStrList(Vector<String> quitStrList) {
        this.quitStrList_ = new Vector<String>(quitStrList);
    }

    public boolean IsLegalOption() {
        boolean isLegalOption = SystemOption.CheckSyntax(this.option_, this.GetOption(), false, true) && this.CheckInflectionByCatInfl();
        return isLegalOption;
    }

    public void SetOption(String optionStr) {
        this.option_ = new Option(optionStr);
        this.PreProcess();
        this.InitDbAndTrie();
    }

    public LvgOutputOption GetLvgOutputOption() {
        return this.lvgOutputOption_;
    }

    public Configuration GetConfiguration() {
        return this.conf_;
    }

    public Connection GetConnection() {
        return this.conn_;
    }

    public void CleanUp() {
        try {
            this.Close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean ProcessLine() throws SQLException, IOException {
        if (!this.runFlag_) {
            return false;
        }
        if (this.promptFlag_) {
            this.GetPrompt();
        }
        String line = null;
        if (inReader_ == null) {
            inReader_ = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        }
        if ((line = inReader_.readLine()) == null || this.quitStrList_.contains(line)) {
            return false;
        }
        this.Process(line, false);
        return true;
    }

    public boolean GetRunFlag() {
        return this.runFlag_;
    }

    public void PrintLvgHelp() {
        LvgHelp.LvgHelp(outWriter_, fileOutput_);
    }

    public void Mutate(String inTerm) throws Exception {
        this.Process(inTerm, false);
    }

    public String MutateToString(String inTerm) throws Exception {
        Out.ResetOutString();
        this.Process(inTerm, true);
        return Out.GetOutString();
    }

    public LvgFlowSpecificOption GetFlowSpecificOptions() {
        return this.lvgFlowSpecificOption_;
    }

    public void SetMinTermLength(int minTermLength) {
        if (this.ramTrieI_ != null) {
            this.ramTrieI_.SetMinTermLength(minTermLength);
        }
        if (this.ramTrieD_ != null) {
            this.ramTrieD_.SetMinTermLength(minTermLength);
        }
    }

    @Override
    protected void ExecuteCommand(OptionItem optionItem, Option systemOption) {
        OptionItem nameItem = OptionUtility.GetItemByName(optionItem, systemOption, false);
        Vector<OptionItem> systemItems = systemOption.GetOptionItems();
        if (LvgCmdApi.CheckOption(nameItem, "-C:INT")) {
            this.lvgOutputOption_.SetCaseFlag(Integer.parseInt(nameItem.GetOptionArgument()));
        } else if (LvgCmdApi.CheckOption(nameItem, "-cf:INT")) {
            this.catFieldNum_ = Integer.parseInt(nameItem.GetOptionArgument());
        } else if (LvgCmdApi.CheckOption(nameItem, "-if:INT")) {
            this.inflFieldNum_ = Integer.parseInt(nameItem.GetOptionArgument());
        } else if (LvgCmdApi.CheckOption(nameItem, "-ccgi")) {
            this.lvgOutputOption_.SetMarkEndFlag(true);
        } else if (LvgCmdApi.CheckOption(nameItem, "-ci")) {
            try {
                boolean useClassPath = false;
                String configFile = this.configFile_;
                if (configFile == null) {
                    useClassPath = true;
                    configFile = "data.config.lvg";
                }
                Configuration conf = new Configuration(configFile, useClassPath);
                if (this.properties_ != null) {
                    conf.OverwriteProperties(this.properties_);
                }
                Out.Println(outWriter_, conf.GetInformation(), fileOutput_, false);
            }
            catch (IOException e) {
                // empty catch block
            }
            this.runFlag_ = false;
        } else if (LvgCmdApi.CheckOption(nameItem, "-CR:o")) {
            this.lvgOutputOption_.SetCombineRule(1);
        } else if (LvgCmdApi.CheckOption(nameItem, "-CR:oc")) {
            this.lvgOutputOption_.SetCombineRule(2);
        } else if (LvgCmdApi.CheckOption(nameItem, "-CR:oe")) {
            this.lvgOutputOption_.SetCombineRule(4);
        } else if (LvgCmdApi.CheckOption(nameItem, "-CR:oi")) {
            this.lvgOutputOption_.SetCombineRule(3);
        } else if (LvgCmdApi.CheckOption(nameItem, "-DC:LONG")) {
            this.lvgOutputOption_.SetOutCategory(Long.parseLong(nameItem.GetOptionArgument()));
        } else if (LvgCmdApi.CheckOption(nameItem, "-DI:LONG")) {
            this.lvgOutputOption_.SetOutInflection(Long.parseLong(nameItem.GetOptionArgument()));
        } else if (LvgCmdApi.CheckOption(nameItem, "-EC:LONG")) {
            this.lvgOutputOption_.SetExcludeCategory(Long.parseLong(nameItem.GetOptionArgument()));
        } else if (LvgCmdApi.CheckOption(nameItem, "-EI:LONG")) {
            this.lvgOutputOption_.SetExcludeInflection(Long.parseLong(nameItem.GetOptionArgument()));
        } else if (LvgCmdApi.CheckOption(nameItem, "-d")) {
            this.detailsFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-h")) {
            LvgHelp.LvgHelp(outWriter_, fileOutput_);
            this.runFlag_ = false;
        } else if (LvgCmdApi.CheckOption(nameItem, "-hs")) {
            systemOption.PrintOptionHierachy();
            this.runFlag_ = false;
        } else if (LvgCmdApi.CheckOption(nameItem, "-F:INT")) {
            Integer fieldNum = new Integer(nameItem.GetOptionArgument());
            Vector<Integer> outputFieldList = this.lvgOutputOption_.GetOutputFieldList();
            outputFieldList.addElement(fieldNum);
            this.lvgOutputOption_.SetOutputFieldList(outputFieldList);
        } else if (LvgCmdApi.CheckOption(nameItem, "-F:h")) {
            LvgHelp.OutputFieldHelp(outWriter_, fileOutput_);
            this.runFlag_ = false;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:0")) {
            this.flowStrs_.addElement(Flow.GetBitName(12));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:A")) {
            this.flowStrs_.addElement(Flow.GetBitName(16));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:An")) {
            this.flowStrs_.addElement(Flow.GetBitName(47));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:a")) {
            this.flowStrs_.addElement(Flow.GetBitName(17));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:B")) {
            this.flowStrs_.addElement(Flow.GetBitName(8));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:Bn")) {
            this.flowStrs_.addElement(Flow.GetBitName(39));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:b")) {
            this.flowStrs_.addElement(Flow.GetBitName(13));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:C")) {
            this.flowStrs_.addElement(Flow.GetBitName(10));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:Ct")) {
            this.flowStrs_.addElement(Flow.GetBitName(38));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:c")) {
            this.flowStrs_.addElement(Flow.GetBitName(21));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:ca")) {
            this.flowStrs_.addElement(Flow.GetBitName(43));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:ch")) {
            this.flowStrs_.addElement(Flow.GetBitName(22));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:d")) {
            this.flowStrs_.addElement(Flow.GetBitName(18));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:dc~LONG")) {
            this.flowStrs_.addElement(Flow.GetBitName(19));
            this.dbFlag_ = true;
            this.derivationCatList_.addElement(nameItem.GetOptionArgument());
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:e")) {
            this.flowStrs_.addElement(Flow.GetBitName(23));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:f")) {
            this.flowStrs_.addElement(Flow.GetBitName(29));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:fa")) {
            this.flowStrs_.addElement(Flow.GetBitName(31));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:fp")) {
            this.flowStrs_.addElement(Flow.GetBitName(30));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:E")) {
            this.flowStrs_.addElement(Flow.GetBitName(24));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:G")) {
            this.flowStrs_.addElement(Flow.GetBitName(42));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:Ge")) {
            this.flowStrs_.addElement(Flow.GetBitName(49));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:Gn")) {
            this.flowStrs_.addElement(Flow.GetBitName(45));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:g")) {
            this.flowStrs_.addElement(Flow.GetBitName(3));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:h")) {
            LvgHelp.FlowHelp(outWriter_, fileOutput_);
            this.runFlag_ = false;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:i")) {
            this.flowStrs_.addElement(Flow.GetBitName(1));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:is")) {
            this.flowStrs_.addElement(Flow.GetBitName(51));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:ici~STR+STR")) {
            this.flowStrs_.addElement(Flow.GetBitName(20));
            this.dbFlag_ = true;
            Vector<String> inList = OptionItem.GetArgumentList(nameItem.GetOptionArgument());
            this.inflectionCatList_.addElement(inList.elementAt(0));
            this.inflectionInflList_.addElement(inList.elementAt(1));
            ++this.curInflectionByCatInflNum_;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:L")) {
            this.flowStrs_.addElement(Flow.GetBitName(25));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:Ln")) {
            this.flowStrs_.addElement(Flow.GetBitName(26));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:Lp")) {
            this.flowStrs_.addElement(Flow.GetBitName(27));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:l")) {
            this.flowStrs_.addElement(Flow.GetBitName(37));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:m")) {
            this.flowStrs_.addElement(Flow.GetBitName(41));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:N")) {
            this.flowStrs_.addElement(Flow.GetBitName(9));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:N3")) {
            this.flowStrs_.addElement(Flow.GetBitName(11));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:n")) {
            this.flowStrs_.addElement(Flow.GetBitName(15));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:nom")) {
            this.flowStrs_.addElement(Flow.GetBitName(57));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:o")) {
            this.flowStrs_.addElement(Flow.GetBitName(4));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:P")) {
            this.flowStrs_.addElement(Flow.GetBitName(6));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:p")) {
            this.flowStrs_.addElement(Flow.GetBitName(5));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:q")) {
            this.flowStrs_.addElement(Flow.GetBitName(40));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:q0")) {
            this.flowStrs_.addElement(Flow.GetBitName(59));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:q1")) {
            this.flowStrs_.addElement(Flow.GetBitName(60));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:q2")) {
            this.flowStrs_.addElement(Flow.GetBitName(52));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:q3")) {
            this.flowStrs_.addElement(Flow.GetBitName(53));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:q4")) {
            this.flowStrs_.addElement(Flow.GetBitName(54));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:q5")) {
            this.flowStrs_.addElement(Flow.GetBitName(55));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:q6")) {
            this.flowStrs_.addElement(Flow.GetBitName(56));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:q7")) {
            this.flowStrs_.addElement(Flow.GetBitName(61));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:q8")) {
            this.flowStrs_.addElement(Flow.GetBitName(62));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:R")) {
            this.flowStrs_.addElement(Flow.GetBitName(36));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:r")) {
            this.flowStrs_.addElement(Flow.GetBitName(35));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:rs")) {
            this.flowStrs_.addElement(Flow.GetBitName(58));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:S")) {
            this.flowStrs_.addElement(Flow.GetBitName(44));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:Si")) {
            this.flowStrs_.addElement(Flow.GetBitName(50));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:s")) {
            this.flowStrs_.addElement(Flow.GetBitName(14));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:T")) {
            this.flowStrs_.addElement(Flow.GetBitName(32));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:t")) {
            this.flowStrs_.addElement(Flow.GetBitName(2));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:U")) {
            this.flowStrs_.addElement(Flow.GetBitName(34));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:u")) {
            this.flowStrs_.addElement(Flow.GetBitName(33));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:v")) {
            this.flowStrs_.addElement(Flow.GetBitName(46));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:w")) {
            this.flowStrs_.addElement(Flow.GetBitName(7));
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:ws~INT")) {
            this.flowStrs_.addElement(Flow.GetBitName(48));
            this.wordSize_ = Integer.parseInt(nameItem.GetOptionArgument());
        } else if (LvgCmdApi.CheckOption(nameItem, "-f:y")) {
            this.flowStrs_.addElement(Flow.GetBitName(28));
            this.dbFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-i:STR")) {
            String inFile = nameItem.GetOptionArgument();
            if (inFile != null) {
                try {
                    inReader_ = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF-8"));
                }
                catch (IOException e) {
                    this.runFlag_ = false;
                    System.err.println("**Error: problem of opening/reading file " + inFile);
                }
            }
        } else if (LvgCmdApi.CheckOption(nameItem, "-kd:INT")) {
            this.lvgFlowSpecificOption_.SetDerivationFilter(Integer.parseInt(nameItem.GetOptionArgument()));
        } else if (LvgCmdApi.CheckOption(nameItem, "-kdn:STR")) {
            this.lvgFlowSpecificOption_.SetDerivationNegation(nameItem.GetOptionArgument());
        } else if (LvgCmdApi.CheckOption(nameItem, "-kdt:STR")) {
            this.lvgFlowSpecificOption_.SetDerivationType(nameItem.GetOptionArgument());
        } else if (LvgCmdApi.CheckOption(nameItem, "-ki:INT")) {
            this.lvgFlowSpecificOption_.SetInflectionFilter(Integer.parseInt(nameItem.GetOptionArgument()));
        } else if (LvgCmdApi.CheckOption(nameItem, "-m")) {
            this.mutateFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-n")) {
            this.lvgOutputOption_.SetNoOutputFlag(true);
        } else if (LvgCmdApi.CheckOption(nameItem, "-o:STR")) {
            String outFile = nameItem.GetOptionArgument();
            if (outFile != null) {
                try {
                    outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
                    fileOutput_ = true;
                }
                catch (IOException e) {
                    this.runFlag_ = false;
                    System.err.println("**Error: problem of opening/writing file " + outFile);
                }
            }
        } else if (LvgCmdApi.CheckOption(nameItem, "-p")) {
            this.promptFlag_ = true;
        } else if (LvgCmdApi.CheckOption(nameItem, "-R:INT")) {
            this.lvgOutputOption_.SetOutRecordNum(Integer.parseInt(nameItem.GetOptionArgument()));
        } else if (LvgCmdApi.CheckOption(nameItem, "-SC")) {
            this.lvgOutputOption_.SetShowCategoryStrFlag(true);
        } else if (LvgCmdApi.CheckOption(nameItem, "-SI")) {
            this.lvgOutputOption_.SetShowInflectionStrFlag(true);
        } else if (LvgCmdApi.CheckOption(nameItem, "-St:o")) {
            this.lvgOutputOption_.SetSortFlag(1);
        } else if (LvgCmdApi.CheckOption(nameItem, "-St:oc")) {
            this.lvgOutputOption_.SetSortFlag(2);
        } else if (LvgCmdApi.CheckOption(nameItem, "-St:oci")) {
            this.lvgOutputOption_.SetSortFlag(3);
        } else if (LvgCmdApi.CheckOption(nameItem, "-s:STR")) {
            String separator = nameItem.GetOptionArgument();
            if (separator.equals("\\t")) {
                separator = new Character('\t').toString();
            }
            GlobalBehavior.SetFieldSeparator(separator);
        } else if (LvgCmdApi.CheckOption(nameItem, "-t:INT")) {
            this.termFieldNum_ = Integer.parseInt(nameItem.GetOptionArgument());
        } else if (LvgCmdApi.CheckOption(nameItem, "-ti")) {
            this.lvgOutputOption_.SetFilterInputFlag(true);
        } else if (LvgCmdApi.CheckOption(nameItem, "-v")) {
            try {
                String releaseStr = "lvg.2013";
                Out.Println(outWriter_, releaseStr, fileOutput_, false);
            }
            catch (IOException e) {
                // empty catch block
            }
            this.runFlag_ = false;
        } else if (LvgCmdApi.CheckOption(nameItem, "-x:STR")) {
            this.configFile_ = nameItem.GetOptionArgument();
        }
    }

    @Override
    protected void DefineFlag() {
        String flagStr = "-cf:INT -C:INT -ccgi -ci -CR:o:oc:oe:oi -DC:LONG -DI:LONG -d -EC:LONG -EI:LONG -F:INT:h -f:0:A:An:a:B:Bn:b:C:Ct:c:ca:ch:d:dc~LONG:e:E:f:fa:fp:G::Ge:Gn:g:h:i:is:ici~STR+STR:L:Ln:Lp:l:m:N:N3:n:nom:o:P:p:q:q0:q1:q2:q3:q4:q5:q6:q7:q8:R:r:rs:S:Si:s:T:t:U:u:v:w:ws~INT:y -h -hs -i:STR -if:INT -kd:INT -kdn:STR -kdt:STR -ki:INT -m -n -o:STR -p -R:INT -SC -SI -St:o:oc:oci -s:STR -t:INT -ti -v -x:STR";
        this.systemOption_ = new Option(flagStr);
        this.systemOption_.SetFlagFullName("-cf:INT", "Input_Category_Field");
        this.systemOption_.SetFlagFullName("-C:INT", "Case_Setting");
        this.systemOption_.SetFlagFullName("-ccgi", "Mark_The_End");
        this.systemOption_.SetFlagFullName("-ci", "Show_Config_Info");
        this.systemOption_.SetFlagFullName("-CR:o", "Combine_By_Output_Term");
        this.systemOption_.SetFlagFullName("-CR:oc", "Combine_By_Category");
        this.systemOption_.SetFlagFullName("-CR:oe", "Combine_By_Eui");
        this.systemOption_.SetFlagFullName("-CR:oi", "Combine_By_Inflection");
        this.systemOption_.SetFlagFullName("-DC:LONG", "Specify_Categories");
        this.systemOption_.SetFlagFullName("-DI:LONG", "Specify_Inflections");
        this.systemOption_.SetFlagFullName("-d", "Detail_Operations");
        this.systemOption_.SetFlagFullName("-EC:LONG", "Exclude_Categories");
        this.systemOption_.SetFlagFullName("-EI:LONG", "Exclude_Inflections");
        this.systemOption_.SetFlagFullName("-F:INT", "Output_Field");
        this.systemOption_.SetFlagFullName("-F:h", "Output_Field_Menu");
        this.systemOption_.SetFlagFullName("-f", "Flow");
        this.systemOption_.SetFlagFullName("-f:0", "Strip_NEC_NOS");
        this.systemOption_.SetFlagFullName("-f:A", "Acronyms");
        this.systemOption_.SetFlagFullName("-f:An", "AntiNorm");
        this.systemOption_.SetFlagFullName("-f:a", "Expansions");
        this.systemOption_.SetFlagFullName("-f:B", "Uninflect_Words");
        this.systemOption_.SetFlagFullName("-f:Bn", "Normalize_Uninflect_Words");
        this.systemOption_.SetFlagFullName("-f:b", "Uninflect_Term");
        this.systemOption_.SetFlagFullName("-f:C", "Canonicalize");
        this.systemOption_.SetFlagFullName("-f:Ct", "Citation");
        this.systemOption_.SetFlagFullName("-f:c", "Tokenize");
        this.systemOption_.SetFlagFullName("-f:ca", "Tokenize_Keep_All");
        this.systemOption_.SetFlagFullName("-f:ch", "Tokenize_No_Hyphens");
        this.systemOption_.SetFlagFullName("-f:d", "Derivation");
        this.systemOption_.SetFlagFullName("-f:dc~LONG", "Derivation_By_Category");
        this.systemOption_.SetFlagFullName("-f:e", "Base_From_Spelling_Variants");
        this.systemOption_.SetFlagFullName("-f:E", "Retrieve_Eui");
        this.systemOption_.SetFlagFullName("-f:f", "Filter_Output");
        this.systemOption_.SetFlagFullName("-f:fa", "Filter_Out_Acronym");
        this.systemOption_.SetFlagFullName("-f:fp", "Filter_Out_ProperNouns");
        this.systemOption_.SetFlagFullName("-f:G", "Fruitful_Variants");
        this.systemOption_.SetFlagFullName("-f:Ge", "Fruitful_Variants_Enhanced");
        this.systemOption_.SetFlagFullName("-f:Gn", "Fruitful_Variants_Lex");
        this.systemOption_.SetFlagFullName("-f:g", "Remove_Genitive");
        this.systemOption_.SetFlagFullName("-f:h", "Flow_Help_Menu");
        this.systemOption_.SetFlagFullName("-f:i", "Inflection");
        this.systemOption_.SetFlagFullName("-f:is", "Inflection_Simple");
        this.systemOption_.SetFlagFullName("-f:ici~STR+STR", "Inflection_By_Cat_Infl");
        this.systemOption_.SetFlagFullName("-f:L", "Retrieve_Cat_Infl");
        this.systemOption_.SetFlagFullName("-f:Ln", "Retrieve_Cat_Infl_Db");
        this.systemOption_.SetFlagFullName("-f:Lp", "Retrieve_Cat_Infl_Begin");
        this.systemOption_.SetFlagFullName("-f:l", "LowerCase");
        this.systemOption_.SetFlagFullName("-f:m", "Metaphone");
        this.systemOption_.SetFlagFullName("-f:N", "Normalize");
        this.systemOption_.SetFlagFullName("-f:N3", "LuiNormalize");
        this.systemOption_.SetFlagFullName("-f:n", "No_Operation");
        this.systemOption_.SetFlagFullName("-f:nom", "Retrieve_Nominalizations");
        this.systemOption_.SetFlagFullName("-f:o", "Replace_Punctuation_With_Space");
        this.systemOption_.SetFlagFullName("-f:P", "Strip_Punctuation_Enhanced");
        this.systemOption_.SetFlagFullName("-f:p", "Strip_Punctuation");
        this.systemOption_.SetFlagFullName("-f:q", "Strip_Diacritics");
        this.systemOption_.SetFlagFullName("-f:q0", "Map_Symbol_To_ASCII");
        this.systemOption_.SetFlagFullName("-f:q1", "Map_Unicode_To_ASCII");
        this.systemOption_.SetFlagFullName("-f:q2", "Split_Ligatures");
        this.systemOption_.SetFlagFullName("-f:q3", "Get_Unicode_Name");
        this.systemOption_.SetFlagFullName("-f:q4", "Get_Unicode_Synonym");
        this.systemOption_.SetFlagFullName("-f:q5", "Norma_Unicode");
        this.systemOption_.SetFlagFullName("-f:q6", "Norm_Unicode_With_Synonym");
        this.systemOption_.SetFlagFullName("-f:q7", "Unicode_Core_Norm");
        this.systemOption_.SetFlagFullName("-f:q8", "Strip_Map_Unicode");
        this.systemOption_.SetFlagFullName("-f:R", "Recursive_Derivations");
        this.systemOption_.SetFlagFullName("-f:r", "Recursive_Synonyms");
        this.systemOption_.SetFlagFullName("-f:rs", "Remove_(s)_(es)_(ies)");
        this.systemOption_.SetFlagFullName("-f:S", "Syntactic_Uninvert");
        this.systemOption_.SetFlagFullName("-f:Si", "Simple_Inflections");
        this.systemOption_.SetFlagFullName("-f:s", "Spelling_Variants");
        this.systemOption_.SetFlagFullName("-f:T", "Strip_Ambiguity_Tags");
        this.systemOption_.SetFlagFullName("-f:t", "Strip_Stop_Words");
        this.systemOption_.SetFlagFullName("-f:U", "Convert_Output");
        this.systemOption_.SetFlagFullName("-f:u", "Uninvert");
        this.systemOption_.SetFlagFullName("-f:v", "Fruitful_Variants_Db");
        this.systemOption_.SetFlagFullName("-f:w", "Sort_By_Word_Order");
        this.systemOption_.SetFlagFullName("-f:ws~INT", "Word_Size_Filter");
        this.systemOption_.SetFlagFullName("-f:y", "Synonyms");
        this.systemOption_.SetFlagFullName("-h", "Help");
        this.systemOption_.SetFlagFullName("-hs", "Hierarchy_Struture");
        this.systemOption_.SetFlagFullName("-i:STR", "Input_File");
        this.systemOption_.SetFlagFullName("-if:INT", "Input_Inflection_Field");
        this.systemOption_.SetFlagFullName("-kd:INT", "Restrict_Derivations");
        this.systemOption_.SetFlagFullName("-kdn:STR", "Derivation_Negative");
        this.systemOption_.SetFlagFullName("-kdt:STR", "Derivation_Types");
        this.systemOption_.SetFlagFullName("-ki:INT", "Restrict_Inflections");
        this.systemOption_.SetFlagFullName("-m", "Mutation_Information");
        this.systemOption_.SetFlagFullName("-n", "No_Output");
        this.systemOption_.SetFlagFullName("-o:STR", "Output_file");
        this.systemOption_.SetFlagFullName("-p", "Show_Prompt");
        this.systemOption_.SetFlagFullName("-R:INT", "Restrict_Out_Number");
        this.systemOption_.SetFlagFullName("-SC", "Show_Category_String");
        this.systemOption_.SetFlagFullName("-SI", "Show_Inflection_String");
        this.systemOption_.SetFlagFullName("-St:o", "Sort_By_Term");
        this.systemOption_.SetFlagFullName("-St:oc", "Sort_By_Term_Cat");
        this.systemOption_.SetFlagFullName("-St:oci", "Sort_By_Term_Cat_Infl");
        this.systemOption_.SetFlagFullName("-s:STR", "Field_Separator");
        this.systemOption_.SetFlagFullName("-t:INT", "Term_Field");
        this.systemOption_.SetFlagFullName("-ti", "Filter_Input_Term");
        this.systemOption_.SetFlagFullName("-v", "Version");
        this.systemOption_.SetFlagFullName("-x:STR", "Load_Configuration_file");
    }

    protected void GetPrompt() throws IOException {
        Out.Println(outWriter_, this.promptStr_, fileOutput_, false);
    }

    protected Vector<LexItem> ExecuteFlow(LexItem in, String flowStr) throws SQLException {
        long flowNum = Flow.Enumerate(flowStr);
        Vector<LexItem> outs = new Vector();
        this.curDerivationCatNum_ = 0;
        this.curInflectionByCatInflCount_ = 0;
        this.curInflectionByCatInflNum_ = 0;
        if (flowNum == Flow.GetBitValue(37)) {
            outs = ToLowerCase.Mutate(in, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(2)) {
            outs = ToStripStopWords.Mutate(in, this.stopWords_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(3)) {
            outs = ToRemoveGenitive.Mutate(in, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(4)) {
            outs = ToReplacePunctuationWithSpace.Mutate(in, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(5)) {
            outs = ToStripPunctuation.Mutate(in, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(6)) {
            outs = ToStripPunctuationEnhanced.Mutate(in, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(7)) {
            outs = ToSortWordsByOrder.Mutate(in, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(12)) {
            outs = ToStripNecNos.Mutate(in, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(15)) {
            outs = ToNoOperation.Mutate(in, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(21)) {
            outs = ToTokenize.Mutate(in, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(22)) {
            outs = ToTokenizeNoHyphens.Mutate(in, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(13)) {
            outs = ToUninflectTerm.Mutate(in, this.conn_, this.ramTrieI_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(1)) {
            outs = ToInflection.Mutate(in, this.conn_, this.ramTrieI_, this.lvgFlowSpecificOption_.GetInflectionFilter(), this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(8)) {
            outs = ToUninflectWords.Mutate(in, this.lvgFlowSpecificOption_.GetMaxPermuteTermNum(), this.conn_, this.ramTrieI_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(9)) {
            outs = ToNormalize.Mutate(in, this.lvgFlowSpecificOption_.GetMaxPermuteTermNum(), this.stopWords_, this.conn_, this.ramTrieI_, this.symbolMap_, this.unicodeMap_, this.ligatureMap_, this.diacriticMap_, this.nonStripMap_, this.removeSTree_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(10)) {
            outs = ToCanonicalize.Mutate(in, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(11)) {
            outs = ToLuiNormalize.Mutate(in, this.lvgFlowSpecificOption_.GetMaxPermuteTermNum(), this.stopWords_, this.conn_, this.ramTrieI_, this.symbolMap_, this.unicodeMap_, this.ligatureMap_, this.diacriticMap_, this.nonStripMap_, this.removeSTree_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(14)) {
            outs = ToSpellingVariants.Mutate(in, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(16)) {
            outs = ToAcronyms.Mutate(in, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(17)) {
            outs = ToExpansions.Mutate(in, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(18)) {
            outs = ToDerivation.Mutate(in, this.conn_, this.ramTrieD_, this.lvgFlowSpecificOption_.GetDerivationFilter(), this.lvgFlowSpecificOption_.GetDerivationType(), this.lvgFlowSpecificOption_.GetDerivationNegation(), this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(19)) {
            long category = Long.parseLong(this.derivationCatList_.elementAt(this.curDerivationCatNum_));
            ++this.curDerivationCatNum_;
            outs = ToDerivationByCategory.Mutate(in, this.conn_, this.ramTrieD_, this.lvgFlowSpecificOption_.GetDerivationFilter(), this.lvgFlowSpecificOption_.GetDerivationType(), this.lvgFlowSpecificOption_.GetDerivationNegation(), category, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(20)) {
            long category = Long.parseLong(this.inflectionCatList_.elementAt(this.curInflectionByCatInflCount_));
            long inflection = Long.parseLong(this.inflectionInflList_.elementAt(this.curInflectionByCatInflCount_));
            ++this.curInflectionByCatInflCount_;
            outs = ToInflectionByCatInfl.Mutate(in, this.conn_, this.ramTrieI_, this.lvgFlowSpecificOption_.GetInflectionFilter(), category, inflection, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(23)) {
            outs = ToBaseSpellingVariants.Mutate(in, this.conn_, this.ramTrieI_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(24)) {
            outs = ToRetrieveEui.Mutate(in, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(25)) {
            outs = ToRetrieveCatInfl.Mutate(in, this.conn_, this.ramTrieI_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(26)) {
            outs = ToRetrieveCatInflDb.Mutate(in, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(27)) {
            outs = ToRetrieveCatInflBegin.Mutate(in, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(28)) {
            outs = ToSynonyms.Mutate(in, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(29)) {
            outs = ToFilter.Mutate(in, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(30)) {
            outs = ToFilterProperNoun.Mutate(in, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(31)) {
            outs = ToFilterAcronym.Mutate(in, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(32)) {
            outs = ToStripAmbiguityTags.Mutate(in, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(33)) {
            outs = ToUninvert.Mutate(in, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(34)) {
            outs = ToConvertOutput.Mutate(in, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(35)) {
            outs = ToRecursiveSynonyms.Mutate(in, this.conn_, this.detailsFlag_, this.mutateFlag_, false);
        } else if (flowNum == Flow.GetBitValue(36)) {
            outs = ToRecursiveDerivations.Mutate(in, this.conn_, this.ramTrieD_, this.lvgFlowSpecificOption_.GetDerivationFilter(), this.lvgFlowSpecificOption_.GetDerivationType(), this.lvgFlowSpecificOption_.GetDerivationNegation(), this.detailsFlag_, this.mutateFlag_, false);
        } else if (flowNum == Flow.GetBitValue(38)) {
            outs = ToCitation.Mutate(in, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(39)) {
            outs = ToNormUninflectWords.Mutate(in, this.lvgFlowSpecificOption_.GetMaxPermuteTermNum(), this.conn_, this.ramTrieI_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(40)) {
            outs = ToStripDiacritics.Mutate(in, this.diacriticMap_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(41)) {
            outs = ToMetaphone.Mutate(in, this.lvgFlowSpecificOption_.GetMaxMetaphoneCodeLength(), this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(42)) {
            outs = ToFruitfulVariants.Mutate(in, this.conn_, this.ramTrieI_, this.ramTrieD_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(43)) {
            outs = ToTokenizeKeepAll.Mutate(in, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(44)) {
            outs = ToSyntacticUninvert.Mutate(in, this.nonInfoWords_, this.conjunctionWords_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(45)) {
            outs = ToFruitfulVariantsLex.Mutate(in, this.conn_, this.ramTrieI_, this.ramTrieD_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(46)) {
            outs = ToFruitfulVariantsDb.Mutate(in, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(47)) {
            outs = ToAntiNorm.Mutate(in, this.lvgFlowSpecificOption_.GetMaxPermuteTermNum(), this.stopWords_, this.conn_, this.ramTrieI_, this.symbolMap_, this.unicodeMap_, this.ligatureMap_, this.diacriticMap_, this.nonStripMap_, this.removeSTree_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(48)) {
            outs = ToWordSize.Mutate(in, this.wordSize_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(49)) {
            outs = ToFruitfulEnhanced.Mutate(in, this.conn_, this.ramTrieI_, this.ramTrieD_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(50)) {
            outs = ToSimpleInflections.Mutate(in, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(51)) {
            outs = ToInflectionSimple.Mutate(in, this.conn_, this.ramTrieI_, this.lvgFlowSpecificOption_.GetInflectionFilter(), this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(52)) {
            outs = ToSplitLigatures.Mutate(in, this.ligatureMap_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(53)) {
            outs = ToGetUnicodeNames.Mutate(in, this.startTag_, this.endTag_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(54)) {
            outs = ToGetUnicodeSynonyms.Mutate(in, this.unicodeSynonymMap_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(55)) {
            outs = ToNormUnicode.Mutate(in, this.symbolMap_, this.unicodeMap_, this.ligatureMap_, this.diacriticMap_, this.startTag_, this.endTag_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(56)) {
            outs = ToNormUnicodeWithSynonym.Mutate(in, this.unicodeSynonymMap_, this.symbolMap_, this.unicodeMap_, this.ligatureMap_, this.diacriticMap_, this.startTag_, this.endTag_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(57)) {
            outs = ToNominalization.Mutate(in, this.conn_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(58)) {
            outs = ToRemoveS.Mutate(in, this.removeSTree_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(59)) {
            outs = ToMapSymbolToAscii.Mutate(in, this.symbolMap_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(60)) {
            outs = ToMapUnicodeToAscii.Mutate(in, this.unicodeMap_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(61)) {
            outs = ToUnicodeCoreNorm.Mutate(in, this.symbolMap_, this.unicodeMap_, this.ligatureMap_, this.diacriticMap_, this.detailsFlag_, this.mutateFlag_);
        } else if (flowNum == Flow.GetBitValue(62)) {
            outs = ToStripMapUnicode.Mutate(in, this.nonStripMap_, this.detailsFlag_, this.mutateFlag_);
        }
        return outs;
    }

    private void Process(String line, boolean toStringFlag) throws SQLException, IOException {
        this.originalTerm_ = line;
        String fs = GlobalBehavior.GetFieldSeparator();
        String inTerm = InputFilter.GetInputTerm(line, fs, this.termFieldNum_);
        long inCat = InputFilter.GetInputCategory(line, fs, this.catFieldNum_);
        long inInfl = InputFilter.GetInputInflection(line, fs, this.inflFieldNum_);
        for (int flowNum = 0; flowNum < this.flowStrsList_.size(); ++flowNum) {
            LexItem in = new LexItem(inTerm, inCat, inInfl);
            this.flowStrs_ = this.flowStrsList_.elementAt(flowNum);
            Vector<LexItem> ins = new Vector<LexItem>();
            Vector<LexItem> outs = new Vector<LexItem>();
            ins.addElement(in);
            for (int flowComp = 0; flowComp < this.flowStrs_.size(); ++flowComp) {
                Vector<LexItem> cur = new Vector<LexItem>();
                for (int j = 0; j < ins.size(); ++j) {
                    LexItem tempIn = (LexItem)ins.elementAt(j);
                    tempIn.SetFlowNumber(flowNum + 1);
                    Vector<LexItem> tempOuts = this.ExecuteFlow(tempIn, this.flowStrs_.elementAt(flowComp));
                    cur.addAll(tempOuts);
                }
                outs.removeAllElements();
                outs.addAll(cur);
                ins = LexItem.TargetsToSources(outs);
            }
            String outStr = OutputFilter.ExecuteOutputFilter(outs, this.mutateFlag_, this.detailsFlag_, fs, this.originalTerm_, inTerm, this.lvgOutputOption_);
            Out.Print(outWriter_, outStr, fileOutput_, toStringFlag);
        }
    }

    private boolean CheckInflectionByCatInfl() {
        boolean legalFlag = true;
        for (int i = 0; i < this.curInflectionByCatInflNum_; ++i) {
            String catStr = this.inflectionCatList_.elementAt(i);
            try {
                Long.parseLong(catStr);
            }
            catch (Exception e) {
                if (catStr.equalsIgnoreCase("all")) {
                    this.inflectionCatList_.setElementAt(Long.toString(2047L), i);
                }
                System.err.println("** Error: Illegal category value (" + catStr + ") for -f:ici.");
                legalFlag = false;
            }
            String inflStr = this.inflectionInflList_.elementAt(i);
            try {
                Long.parseLong(inflStr);
                continue;
            }
            catch (Exception e) {
                if (inflStr.equalsIgnoreCase("all")) {
                    this.inflectionInflList_.setElementAt(Long.toString(0xFFFFFFL), i);
                    continue;
                }
                System.err.println("** Error: Illegal inflection value (" + inflStr + ") for -f:ici.");
                legalFlag = false;
            }
        }
        return legalFlag;
    }

    private static Vector<String> GetOptions(String inStr) {
        Vector<String> out = new Vector<String>();
        StringTokenizer buf = new StringTokenizer(inStr, " \t");
        while (buf.hasMoreTokens()) {
            out.addElement(buf.nextToken());
        }
        return out;
    }

    private void Init() {
        this.PreProcess();
        this.InitConfigVars();
        if (this.runFlag_) {
            this.InitDbAndTrie();
        }
    }

    private void PreProcess() {
        int oldFlowNum = 0;
        Vector<String> args = LvgCmdApi.GetOptions(this.option_.GetOptionStr());
        this.flowStrsList_.removeAllElements();
        this.lvgOutputOption_.GetOutputFieldList().removeAllElements();
        for (int i = 0; i < args.size(); ++i) {
            String temp = args.elementAt(i);
            Option io = new Option(temp);
            if (LvgCmdApi.IsNewFlow(temp)) {
                ++this.flowNum_;
                this.flowStrs_ = new Vector();
            }
            this.ExecuteCommands(io, this.GetOption());
            if (this.flowNum_ <= 0 || this.flowNum_ == oldFlowNum) continue;
            this.flowStrsList_.addElement(this.flowStrs_);
            oldFlowNum = this.flowNum_;
        }
    }

    private void InitDbAndTrie() {
        if (this.conf_.GetSize() > 0) {
            int minTermLen = Integer.parseInt(this.conf_.GetConfiguration("MIN_TERM_LENGTH"));
            String lvgDir = this.conf_.GetConfiguration("LVG_DIR");
            int minTrieStemLength = Integer.parseInt(this.conf_.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
            try {
                if (this.dbFlag_ && this.conn_ == null) {
                    this.conn_ = DbBase.OpenConnection(this.conf_);
                }
                if (this.ramTrieI_ == null) {
                    this.ramTrieI_ = new RamTrie(true, minTermLen, lvgDir, 0);
                }
                if (this.ramTrieD_ == null) {
                    this.ramTrieD_ = new RamTrie(false, minTermLen, lvgDir, minTrieStemLength);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void InitConfigVars() {
        boolean useClassPath = false;
        if (this.configFile_ == null) {
            useClassPath = true;
            this.configFile_ = "data.config.lvg";
        }
        this.conf_ = new Configuration(this.configFile_, useClassPath);
        if (this.properties_ != null) {
            this.conf_.OverwriteProperties(this.properties_);
        }
        this.promptStr_ = Platform.IsWindow() ? "- Please input a term (type \"Ctl-z\" then \"Enter\" to quit) >" : "- Please input a term (type \"Ctl-d\" to quit) >";
        if (this.conf_.GetSize() <= 0) {
            this.runFlag_ = false;
        } else {
            if (this.lvgOutputOption_.GetOutRecordNum() == -1) {
                this.lvgOutputOption_.SetOutRecordNum(Integer.parseInt(this.conf_.GetConfiguration("TRUNCATED_RESULTS")));
            }
            if (this.lvgOutputOption_.GetNoOutputStr() == null) {
                this.lvgOutputOption_.SetNoOutputStr(this.conf_.GetConfiguration("NO_OUTPUT"));
            }
            if (this.lvgOutputOption_.GetMarkEndStr() == null) {
                this.lvgOutputOption_.SetMarkEndStr(this.conf_.GetConfiguration("CGI_EOP"));
            }
            if (!this.conf_.GetConfiguration("LVG_PROMPT").equals("DEFAULT")) {
                this.promptStr_ = this.conf_.GetConfiguration("LVG_PROMPT");
            }
            if (this.lvgFlowSpecificOption_.GetMaxPermuteTermNum() == -1) {
                this.lvgFlowSpecificOption_.SetMaxPermuteTermNum(Integer.parseInt(this.conf_.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS")));
            }
            if (this.lvgFlowSpecificOption_.GetMaxMetaphoneCodeLength() == -1) {
                this.lvgFlowSpecificOption_.SetMaxMetaphoneCodeLength(Integer.parseInt(this.conf_.GetConfiguration("MAX_METAPHONE")));
            }
            if (this.stopWords_ == null) {
                this.stopWords_ = ToStripStopWords.GetStopWordsFromFile(this.conf_);
            }
            if (this.nonInfoWords_ == null) {
                this.nonInfoWords_ = ToSyntacticUninvert.GetNonInfoWordsFromFile(this.conf_);
            }
            if (this.conjunctionWords_ == null) {
                this.conjunctionWords_ = ToSyntacticUninvert.GetConjunctionWordsFromFile(this.conf_);
            }
            if (this.diacriticMap_ == null) {
                this.diacriticMap_ = ToStripDiacritics.GetDiacriticMapFromFile(this.conf_);
            }
            if (this.ligatureMap_ == null) {
                this.ligatureMap_ = ToSplitLigatures.GetLigatureMapFromFile(this.conf_);
            }
            if (this.startTag_ == null) {
                this.startTag_ = this.conf_.GetConfiguration("START_TAG");
            }
            if (this.endTag_ == null) {
                this.endTag_ = this.conf_.GetConfiguration("END_TAG");
            }
            if (this.unicodeSynonymMap_ == null) {
                this.unicodeSynonymMap_ = ToGetUnicodeSynonyms.GetUnicodeSynonymMapFromFile(this.conf_);
            }
            if (this.removeSTree_ == null) {
                this.removeSTree_ = ToRemoveS.GetRTrieTreeFromFile(this.conf_);
            }
            if (this.symbolMap_ == null) {
                this.symbolMap_ = ToMapSymbolToAscii.GetSymbolMapFromFile(this.conf_);
            }
            if (this.unicodeMap_ == null) {
                this.unicodeMap_ = ToMapUnicodeToAscii.GetUnicodeMapFromFile(this.conf_);
            }
            if (this.nonStripMap_ == null) {
                this.nonStripMap_ = ToStripMapUnicode.GetNonStripMapFromFile(this.conf_);
            }
        }
    }

    private void Close() throws IOException, SQLException {
        if (outWriter_ != null && fileOutput_) {
            outWriter_.close();
        }
        if (inReader_ != null) {
            inReader_.close();
        }
        if (this.conn_ != null) {
            DbBase.CloseConnection(this.conn_, this.conf_);
        }
    }

    private static boolean IsNewFlow(String option) {
        boolean flag = false;
        if (option.length() >= 3 && option.substring(0, 3).equals("-f:")) {
            flag = true;
        }
        return flag;
    }

    static {
        try {
            outWriter_ = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        }
        catch (IOException e) {
            System.err.println("**Error: problem of opening Std-out.");
        }
    }
}

