/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbInflection;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToRetrieveCatInflBegin
extends Transformation
implements Cloneable {
    private static final String INFO = "Retrieve Cat Infl, Begin";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        Vector<InflectionRecord> catInflRec = ToRetrieveCatInflBegin.GetCatInfl(in.GetSourceTerm(), conn);
        long inCat = in.GetSourceCategory().GetValue();
        long inInfl = in.GetSourceInflection().GetValue();
        Vector<LexItem> out = new Vector<LexItem>();
        for (int i = 0; i < catInflRec.size(); ++i) {
            long curInfl;
            InflectionRecord record = catInflRec.elementAt(i);
            long curCat = record.GetCategory();
            if (!InputFilter.IsLegal(inCat, inInfl, curCat, curInfl = record.GetInflection())) continue;
            String term = record.GetInflectedTerm();
            String details = null;
            String mutate = null;
            if (detailsFlag) {
                details = INFO;
            }
            if (mutateFlag) {
                String fs = GlobalBehavior.GetFieldSeparator();
                mutate = record.GetEui() + fs + term + fs + Category.ToName(record.GetCategory()) + fs + Inflection.ToName(record.GetInflection()) + fs + record.GetCitationTerm() + fs + record.GetUninflectedTerm() + fs;
            }
            LexItem temp = ToRetrieveCatInflBegin.UpdateLexItem(in, term, 27, curCat, curInfl, details, mutate);
            out.addElement(temp);
        }
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToRetrieveCatInflBegin.GetTestStr(args, "nurse");
        LexItem in = new LexItem(testStr, 2047L, 0xFFFFFFL);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                outs = ToRetrieveCatInflBegin.Mutate(in, conn, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToRetrieveCatInflBegin.PrintResults(in, outs);
    }

    private static Vector<InflectionRecord> GetCatInfl(String inStr, Connection conn) throws SQLException {
        Vector<InflectionRecord> out = DbInflection.GetCatInflBegin(inStr, conn);
        return out;
    }
}

