/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbSpellingVariants;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToSpellingVariants
extends Transformation
implements Cloneable {
    private static final String INFO = "Spelling Variants";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, boolean detailsFlag, boolean mutateFlag) {
        Vector<InflectionRecord> records = ToSpellingVariants.SpellingVariant(in.GetSourceTerm(), conn);
        long inCat = in.GetSourceCategory().GetValue();
        long inInfl = in.GetSourceInflection().GetValue();
        Vector<LexItem> out = new Vector<LexItem>();
        for (int i = 0; i < records.size(); ++i) {
            long curInfl;
            InflectionRecord record = records.elementAt(i);
            String term = record.GetInflectedTerm();
            long curCat = record.GetCategory();
            if (!InputFilter.IsLegal(inCat, inInfl, curCat, curInfl = record.GetInflection())) continue;
            String details = null;
            String mutate = null;
            if (detailsFlag) {
                details = INFO;
            }
            if (mutateFlag) {
                mutate = record.GetEui() + GlobalBehavior.GetFieldSeparator();
            }
            LexItem temp = ToSpellingVariants.UpdateLexItem(in, term, 14, curCat, curInfl, details, mutate);
            out.addElement(temp);
        }
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToSpellingVariants.GetTestStr(args, "left");
        LexItem in = new LexItem(testStr, 2047L, 0xFFFFFFL);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                outs = ToSpellingVariants.Mutate(in, conn, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToSpellingVariants.PrintResults(in, outs);
    }

    protected static Vector<InflectionRecord> SpellingVariant(String inStr, Connection conn) {
        Vector<InflectionRecord> out = new Vector<InflectionRecord>();
        try {
            out = DbSpellingVariants.GetSpellingVariants(inStr, conn);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return out;
    }
}

