/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Util.UnicodeUtil;

public class CoreNormObj {
    public static final int RECURSIVE_FACTOR = 25;
    public static final int ASCII = 0;
    public static final int SYMBOL_MAPPING = 1;
    public static final int UNICODE_MAPPING = 2;
    public static final int STRIP_DIACRITIC = 3;
    public static final int SPLIT_LIGATURE = 4;
    public static final int NO_MORE_OPERATION = 5;
    public static final int ERROR = 6;
    private int maxRecursiveNum_ = 0;
    private int recursiveNo_ = 0;
    private int curPos_ = 0;
    private String curStr_ = new String();
    private String details_ = new String();

    public CoreNormObj() {
    }

    public CoreNormObj(char curChar) {
        this.curStr_ = UnicodeUtil.CharToStr(curChar);
        this.maxRecursiveNum_ = 25 * this.curStr_.length();
        this.recursiveNo_ = 0;
    }

    public CoreNormObj(String curStr) {
        this.curStr_ = curStr;
        this.maxRecursiveNum_ = 25 * this.curStr_.length();
        this.recursiveNo_ = 0;
    }

    public void SetCurStr(String curStr) {
        this.curStr_ = curStr;
    }

    public void UpdateCurStr(String newStr) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.curStr_.substring(0, this.curPos_));
        buf.append(newStr);
        buf.append(this.curStr_.substring(this.curPos_ + 1));
        this.curStr_ = buf.toString();
    }

    public void SetCurPos(int curPos) {
        this.curPos_ = curPos;
    }

    public void UpdateCurPos() {
        ++this.curPos_;
    }

    public void UpdateCurPos(int increment) {
        this.curPos_ += increment;
    }

    public void SetRecursiveNo(int recursiveNo) {
        this.recursiveNo_ = recursiveNo;
    }

    public void SetMaxRecursiveNum(int maxRecursiveNum) {
        this.maxRecursiveNum_ = maxRecursiveNum;
    }

    public void UpdateRecursiveNo() {
        ++this.recursiveNo_;
    }

    public void SetDetails(int normProcess) {
        String plusStr = this.details_.length() > 0 ? "+" : new String();
        switch (normProcess) {
            case 0: {
                this.details_ = this.details_ + plusStr + "AS";
                break;
            }
            case 1: {
                this.details_ = this.details_ + plusStr + "SM";
                break;
            }
            case 2: {
                this.details_ = this.details_ + plusStr + "UM";
                break;
            }
            case 3: {
                this.details_ = this.details_ + plusStr + "SD";
                break;
            }
            case 4: {
                this.details_ = this.details_ + plusStr + "SL";
                break;
            }
            case 5: {
                this.details_ = this.details_ + plusStr + "NMO";
                break;
            }
            case 6: {
                this.details_ = this.details_ + plusStr + "ERR";
            }
        }
    }

    public String GetCurStr() {
        return this.curStr_;
    }

    public String GetDetails() {
        return this.details_;
    }

    public int GetCurPos() {
        return this.curPos_;
    }

    public int GetRecursiveNo() {
        return this.recursiveNo_;
    }

    public int GetMaxRecursiveNum() {
        return this.maxRecursiveNum_;
    }

    public boolean IsWithinRecursiveLimit() {
        return this.recursiveNo_ < this.maxRecursiveNum_;
    }
}

