/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Lib.BitMaskBase;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Util.Vec;
import java.util.ArrayList;
import java.util.Vector;

public class Inflection
extends BitMaskBase {
    public static final int BASE_BIT = 0;
    public static final int COMPARATIVE_BIT = 1;
    public static final int SUPERLATIVE_BIT = 2;
    public static final int PLURAL_BIT = 3;
    public static final int PRES_PART_BIT = 4;
    public static final int PAST_BIT = 5;
    public static final int PAST_PART_BIT = 6;
    public static final int PRES_3S_BIT = 7;
    public static final int POSITIVE_BIT = 8;
    public static final int SINGULAR_BIT = 9;
    public static final int INFINITIVE_BIT = 10;
    public static final int PRES_1_2_3P_BIT = 11;
    public static final int PAST_NEG_BIT = 12;
    public static final int PRES_1_2_3P_NEG_BIT = 13;
    public static final int PRES_1S_BIT = 14;
    public static final int PAST_1P_2_3P_NEG_BIT = 15;
    public static final int PAST_1P_2_3P_BIT = 16;
    public static final int PAST_1S_3S_NEG_BIT = 17;
    public static final int PRES_1P_2_3P_BIT = 18;
    public static final int PRES_1P_2_3P_NEG_BIT = 19;
    public static final int PAST_1S_3S_BIT = 20;
    public static final int PRES_BIT = 21;
    public static final int PRES_3S_NEG_BIT = 22;
    public static final int PRES_NEG_BIT = 23;
    public static final long LOWER_INFLECTIONS = 255L;
    public static final long UPPER_INFLECTIONS = 0xFFFE00L;
    public static final int SIMPLE_BITS = 7;
    public static final int TOTAL_BITS = 24;
    public static final long ALL_BIT_VALUE = 0xFFFFFFL;
    public static final long NO_BIT_VALUE = 0L;
    private static ArrayList<Vector<String>> bitStr_ = new ArrayList(63);
    public static long[] MapSimpleInfl_ = new long[]{mask_[0], mask_[1], mask_[2], mask_[3], mask_[4], mask_[5], mask_[6], mask_[7], mask_[0], mask_[0], mask_[0], mask_[0], mask_[5], mask_[21], mask_[21], mask_[5], mask_[5], mask_[5], mask_[21], mask_[21], mask_[5], mask_[21], mask_[21], mask_[21]};

    public Inflection() {
        super(0xFFFFFFL, bitStr_);
    }

    public Inflection(long value) {
        super(value, 0xFFFFFFL, bitStr_);
    }

    public static long ToValue(String valueStr) {
        long value = Inflection.ToValue(valueStr, bitStr_);
        return value;
    }

    public static String ToName(long value) {
        String valueStr = Inflection.ToName(value, 0xFFFFFFL, bitStr_);
        return valueStr;
    }

    public static String GetBitName(int bitValue) {
        return Inflection.GetBitName(bitValue, 0);
    }

    public static String GetBitName(int bitValue, int index) {
        return Inflection.GetBitName(bitValue, index, bitStr_);
    }

    public static long Enumerate(String valueStr) {
        return Inflection.Enumerate(valueStr, bitStr_);
    }

    public static Vector<Long> ToValues(long value) {
        return Inflection.ToValues(value, 24);
    }

    public static long[] ToValuesArray(long value) {
        Vector<Long> out = Inflection.ToValues(value, 24);
        return Vec.ToArray(out);
    }

    public static void main(String[] args) {
        String foo = "base+singular+plural+infinitive+pres+past+presPart+pastPart+positive+comparative+superlative";
        System.out.println(" -  ToValue(" + foo + "): " + Inflection.ToValue(foo));
        System.out.println(" -  ToName(2099071): " + Inflection.ToName(2099071L));
        foo = "base+singular+infinitive+positive";
        System.out.println(" -  ToValue(" + foo + "): " + Inflection.ToValue(foo));
        System.out.println(" -  ToName(1793): " + Inflection.ToName(1793L));
        Vector<Long> values = Inflection.ToValues(1793L);
        for (int i = 0; i < values.size(); ++i) {
            System.out.println(" - Inflection.ToValues(1793): " + values.elementAt(i));
        }
        long[] valuesArray = Inflection.ToValuesArray(1793L);
        for (int i = 0; i < valuesArray.length; ++i) {
            System.out.println(" - Inflection.ToValues(1793): " + valuesArray[i]);
        }
        System.out.println(" -  Category.ToName(2047): " + Category.ToName(2047L));
    }

    static {
        for (int i = 0; i < 63; ++i) {
            bitStr_.add(i, new Vector());
        }
        bitStr_.get(0).addElement("base");
        bitStr_.get(1).addElement("comparative");
        bitStr_.get(2).addElement("superlative");
        bitStr_.get(3).addElement("plural");
        bitStr_.get(3).addElement("p");
        bitStr_.get(4).addElement("presPart");
        bitStr_.get(4).addElement("ing");
        bitStr_.get(5).addElement("past");
        bitStr_.get(6).addElement("pastPart");
        bitStr_.get(7).addElement("pres3s");
        bitStr_.get(8).addElement("positive");
        bitStr_.get(9).addElement("singular");
        bitStr_.get(9).addElement("s");
        bitStr_.get(10).addElement("infinitive");
        bitStr_.get(10).addElement("inf");
        bitStr_.get(11).addElement("pres123p");
        bitStr_.get(12).addElement("pastNeg");
        bitStr_.get(13).addElement("pres123pNeg");
        bitStr_.get(14).addElement("pres1s");
        bitStr_.get(15).addElement("past1p23pNeg");
        bitStr_.get(16).addElement("past1p23p");
        bitStr_.get(17).addElement("past1s3sNeg");
        bitStr_.get(18).addElement("pres1p23p");
        bitStr_.get(19).addElement("pres1p23pNeg");
        bitStr_.get(20).addElement("past1s3s");
        bitStr_.get(21).addElement("pres");
        bitStr_.get(22).addElement("pres3sNeg");
        bitStr_.get(23).addElement("presNeg");
    }
}

