/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Gender;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import java.util.Vector;

public class LexItem {
    private String mutateInfo_ = null;
    private String detailInfo_ = null;
    private int flowNum_ = 1;
    private int flowComponentNum_ = 1;
    private String flowHistory_ = null;
    private long tag_ = 3L;
    private String orgTerm_ = null;
    private String srcTerm_ = null;
    private String tarTerm_ = null;
    private Category srcCategory_ = new Category(2047L);
    private Category tarCategory_ = new Category();
    private Inflection srcInflection_ = new Inflection(0xFFFFFFL);
    private Inflection tarInflection_ = new Inflection();
    private Gender srcGender_ = new Gender();
    private Gender tarGender_ = new Gender();

    public LexItem() {
    }

    public LexItem(String term) {
        this.orgTerm_ = term;
        this.srcTerm_ = term;
    }

    public LexItem(String term, long cat) {
        this.orgTerm_ = term;
        this.srcTerm_ = term;
        this.srcCategory_ = new Category(cat);
    }

    public LexItem(String term, long cat, long infl) {
        this.orgTerm_ = term;
        this.srcTerm_ = term;
        this.srcCategory_ = new Category(cat);
        this.srcInflection_ = new Inflection(infl);
    }

    public LexItem(LexItem in, boolean allFlag) {
        this.orgTerm_ = in.GetOriginalTerm();
        this.srcTerm_ = in.GetSourceTerm();
        this.srcCategory_ = new Category(in.GetSourceCategory().GetValue());
        this.srcInflection_ = new Inflection(in.GetSourceInflection().GetValue());
        this.srcGender_ = new Gender(in.GetSourceGender().GetValue());
        this.detailInfo_ = in.GetDetailInformation();
        this.flowHistory_ = in.GetFlowHistory();
        this.flowNum_ = in.GetFlowNumber();
        this.flowComponentNum_ = in.GetFlowComponentNumber();
        this.tag_ = in.GetTag();
        if (allFlag) {
            this.tarTerm_ = in.GetTargetTerm();
            this.tarCategory_ = new Category(in.GetTargetCategory().GetValue());
            this.tarInflection_ = new Inflection(in.GetTargetInflection().GetValue());
            this.tarGender_ = new Gender(in.GetTargetGender().GetValue());
            this.mutateInfo_ = in.GetMutateInformation();
        }
    }

    public boolean equals(Object anObject) {
        boolean flag = false;
        if (anObject != null && anObject instanceof LexItem && this.ToString().equals(((LexItem)anObject).ToString())) {
            flag = true;
        }
        return flag;
    }

    public int hashCode() {
        int hashCode = this.ToString().hashCode();
        return hashCode;
    }

    public String ToString() {
        String fs = GlobalBehavior.GetFieldSeparator();
        String outStr = this.orgTerm_ + fs + this.srcTerm_ + fs + this.srcCategory_.GetName() + fs + this.srcInflection_.GetName() + fs + this.tarTerm_ + fs + this.tarCategory_.GetName() + fs + this.tarInflection_.GetName() + fs + this.mutateInfo_ + fs;
        return outStr;
    }

    public String ToStringDetail() {
        String outStr = new String();
        outStr = "------------------------------------------------";
        outStr = outStr + GlobalBehavior.LS_STR;
        outStr = outStr + "Original Term: " + this.orgTerm_ + GlobalBehavior.LS_STR;
        outStr = outStr + "Source Term: " + this.srcTerm_ + GlobalBehavior.LS_STR;
        outStr = outStr + "Source Category: " + this.srcCategory_.GetValue() + GlobalBehavior.LS_STR;
        outStr = outStr + "Source Inflection: " + this.srcInflection_.GetValue() + GlobalBehavior.LS_STR;
        outStr = outStr + "Target Term: " + this.tarTerm_ + GlobalBehavior.LS_STR;
        outStr = outStr + "Target Category: " + this.tarCategory_.GetValue() + GlobalBehavior.LS_STR;
        outStr = outStr + "Target Inflection: " + this.tarInflection_.GetValue() + GlobalBehavior.LS_STR;
        outStr = outStr + "Flow History: " + this.flowHistory_ + GlobalBehavior.LS_STR;
        outStr = outStr + "Detail Information: " + this.detailInfo_ + GlobalBehavior.LS_STR;
        outStr = outStr + "Mutate Information: " + this.mutateInfo_ + GlobalBehavior.LS_STR;
        outStr = outStr + "Flow Number: " + this.flowNum_ + GlobalBehavior.LS_STR;
        return outStr;
    }

    public static LexItem TargetToSource(LexItem tar) {
        LexItem src = new LexItem();
        src.SetOriginalTerm(tar.GetOriginalTerm());
        src.SetSourceTerm(tar.GetTargetTerm());
        src.SetSourceCategory(tar.GetTargetCategory().GetValue());
        src.SetSourceInflection(tar.GetTargetInflection().GetValue());
        src.SetDetailInformation(tar.GetDetailInformation());
        src.SetMutateInformation(tar.GetMutateInformation());
        src.SetFlowHistory(tar.GetFlowHistory());
        src.SetFlowNumber(tar.GetFlowNumber());
        src.SetFlowComponentNumber(tar.GetFlowComponentNumber() + 1);
        src.SetTag(tar.GetTag());
        return src;
    }

    public static Vector<LexItem> TargetsToSources(Vector<LexItem> tars) {
        if (tars == null) {
            return null;
        }
        Vector<LexItem> outs = new Vector<LexItem>();
        for (int i = 0; i < tars.size(); ++i) {
            LexItem temp = tars.elementAt(i);
            LexItem tempIn = LexItem.TargetToSource(temp);
            outs.addElement(tempIn);
        }
        return outs;
    }

    public void SetOriginalTerm(String value) {
        this.orgTerm_ = value;
    }

    public void SetSourceTerm(String value) {
        this.srcTerm_ = value;
    }

    public void SetTargetTerm(String value) {
        this.tarTerm_ = value;
    }

    public void SetSourceCategory(long value) {
        this.srcCategory_.SetValue(value);
    }

    public void SetTargetCategory(long value) {
        this.tarCategory_.SetValue(value);
    }

    public void SetSourceInflection(long value) {
        this.srcInflection_.SetValue(value);
    }

    public void SetTargetInflection(long value) {
        this.tarInflection_.SetValue(value);
    }

    public void SetDetailInformation(String value) {
        this.detailInfo_ = value;
    }

    public void SetMutateInformation(String value) {
        this.mutateInfo_ = value;
    }

    public void SetTag(long value) {
        this.tag_ = value;
    }

    public void SetFlowHistory(String value) {
        this.flowHistory_ = value;
    }

    public void SetFlowNumber(int flowNum) {
        this.flowNum_ = flowNum;
    }

    public void SetFlowComponentNumber(int flowComponentNum) {
        this.flowComponentNum_ = flowComponentNum;
    }

    public String GetOriginalTerm() {
        return this.orgTerm_;
    }

    public String GetSourceTerm() {
        return this.srcTerm_;
    }

    public Gender GetSourceGender() {
        return this.srcGender_;
    }

    public String GetTargetTerm() {
        return this.tarTerm_;
    }

    public Category GetSourceCategory() {
        return this.srcCategory_;
    }

    public Category GetTargetCategory() {
        return this.tarCategory_;
    }

    public Inflection GetSourceInflection() {
        return this.srcInflection_;
    }

    public Inflection GetTargetInflection() {
        return this.tarInflection_;
    }

    public Gender GetTargetGender() {
        return this.tarGender_;
    }

    public String GetFlowHistory() {
        return this.flowHistory_;
    }

    public String GetDetailInformation() {
        return this.detailInfo_;
    }

    public long GetTag() {
        return this.tag_;
    }

    public String GetMutateInformation() {
        return this.mutateInfo_;
    }

    public int GetFlowNumber() {
        return this.flowNum_;
    }

    public int GetFlowComponentNumber() {
        return this.flowComponentNum_;
    }

    public static String GetResultString(LexItem in, String originalTerm, boolean mutateFlag, int caseFlag, boolean showCategoryStrFlag, boolean showInflectionStrFlag, boolean filterInputFlag, String separator) {
        String sourceTerm = originalTerm;
        if (filterInputFlag) {
            sourceTerm = in.GetOriginalTerm();
        }
        String targetTerm = in.GetTargetTerm();
        switch (caseFlag) {
            case 2: {
                targetTerm = targetTerm.toLowerCase();
                break;
            }
            case 3: {
                targetTerm = targetTerm.toUpperCase();
            }
        }
        String catStr = Long.toString(in.GetTargetCategory().GetValue());
        if (showCategoryStrFlag) {
            catStr = "<" + in.GetTargetCategory().GetName() + ">";
        }
        String inflStr = Long.toString(in.GetTargetInflection().GetValue());
        if (showInflectionStrFlag) {
            inflStr = "<" + in.GetTargetInflection().GetName() + ">";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(sourceTerm);
        buffer.append(separator);
        buffer.append(targetTerm);
        buffer.append(separator);
        buffer.append(catStr);
        buffer.append(separator);
        buffer.append(inflStr);
        buffer.append(separator);
        buffer.append(in.GetFlowHistory());
        buffer.append(separator);
        buffer.append(in.GetFlowNumber());
        buffer.append(separator);
        if (mutateFlag) {
            buffer.append(in.GetMutateInformation());
        }
        String outStr = buffer.toString();
        return outStr;
    }

    public static void main(String[] args) {
        LexItem a = new LexItem("Test");
        LexItem.PrintLexItem(a);
        LexItem b = LexItem.TargetToSource(a);
        LexItem.PrintLexItem(b);
        Vector<LexItem> ab = new Vector<LexItem>();
        ab.addElement(a);
        ab.addElement(b);
        Vector<LexItem> abs = LexItem.TargetsToSources(ab);
        for (int i = 0; i < abs.size(); ++i) {
            LexItem l = abs.elementAt(i);
            LexItem.PrintLexItem(l);
        }
        try {
            LexItem c = (LexItem)a.clone();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static void PrintLexItem(LexItem in) {
        System.out.println("------------------------------------------------");
        System.out.println("Original Term: " + in.GetOriginalTerm());
        System.out.println("Source Term: " + in.GetSourceTerm());
        System.out.println("Source Category: " + in.GetSourceCategory().GetValue());
        System.out.println("Source Inflection: " + in.GetSourceInflection().GetValue());
        System.out.println("Target Term: " + in.GetTargetTerm());
        System.out.println("Target Category: " + in.GetTargetCategory().GetValue());
        System.out.println("Target Inflection: " + in.GetTargetInflection().GetValue());
        System.out.println("Flow History: " + in.GetFlowHistory());
        System.out.println("Detail Information: " + in.GetDetailInformation());
        System.out.println("Mutate Information: " + in.GetMutateInformation());
        System.out.println("Flow Number: " + in.GetFlowNumber());
    }
}

