/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

public class LvgFlowSpecificOption {
    private int maxPermuteTermNum_ = -1;
    private int maxMetaphoneCodeLength_ = -1;
    private int derivationFilter_ = 1;
    private int inflectionFilter_ = 2;
    private int derivationType_ = 6;
    private int derivationNegation_ = 0;
    public static final String KDT_Z = "Z";
    public static final String KDT_S = "S";
    public static final String KDT_P = "P";
    public static final String KDT_ZS = "ZS";
    public static final String KDT_ZP = "ZP";
    public static final String KDT_SP = "SP";
    public static final String KDT_ZSP = "ZSP";
    public static final String KDN_O = "O";
    public static final String KDN_N = "N";
    public static final String KDN_B = "B";

    public void SetMaxPermuteTermNum(int value) {
        this.maxPermuteTermNum_ = value;
    }

    public void SetMaxMetaphoneCodeLength(int value) {
        this.maxMetaphoneCodeLength_ = value;
    }

    public void SetDerivationFilter(int value) {
        this.derivationFilter_ = value;
    }

    public void SetInflectionFilter(int value) {
        this.inflectionFilter_ = value;
    }

    public void SetDerivationType(String optionStr) {
        this.derivationType_ = LvgFlowSpecificOption.GetDerivationTypeInt(optionStr);
    }

    public void SetDerivationNegation(String optionStr) {
        this.derivationNegation_ = LvgFlowSpecificOption.GetDerivationNegationInt(optionStr);
    }

    public int GetMaxPermuteTermNum() {
        return this.maxPermuteTermNum_;
    }

    public int GetMaxMetaphoneCodeLength() {
        return this.maxMetaphoneCodeLength_;
    }

    public int GetDerivationFilter() {
        return this.derivationFilter_;
    }

    public int GetInflectionFilter() {
        return this.inflectionFilter_;
    }

    public int GetDerivationType() {
        return this.derivationType_;
    }

    public int GetDerivationNegation() {
        return this.derivationNegation_;
    }

    public static int GetDerivationTypeInt(String optionStr) {
        int kdtInt = 6;
        if (optionStr.equals(KDT_Z)) {
            kdtInt = 0;
        } else if (optionStr.equals(KDT_S)) {
            kdtInt = 2;
        } else if (optionStr.equals(KDT_P)) {
            kdtInt = 1;
        } else if (optionStr.equals(KDT_ZS)) {
            kdtInt = 4;
        } else if (optionStr.equals(KDT_ZP)) {
            kdtInt = 3;
        } else if (optionStr.equals(KDT_SP)) {
            kdtInt = 5;
        }
        return kdtInt;
    }

    public static int GetDerivationNegationInt(String optionStr) {
        int kdnInt = 0;
        if (optionStr.equals(KDN_N)) {
            kdnInt = 1;
        } else if (optionStr.equals(KDN_B)) {
            kdnInt = 2;
        }
        return kdnInt;
    }
}

