/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Trie.PersistentListNode;
import gov.nih.nlm.nls.lvg.Trie.PersistentRuleNode;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PersistentList {
    public static final int HEADER_OFFSET = 12;
    private static final int NEXT_OFFSET = 8;
    private RandomAccessFile raf_ = null;
    private int nodeNum_ = 0;
    private long beginAddress_ = -1L;
    private long lastAddress_ = 0L;

    public PersistentList(String path) {
        try {
            this.raf_ = new RandomAccessFile(path, "rw");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Add(PersistentListNode node) throws IOException {
        if (this.beginAddress_ == -1L) {
            this.WriteListHeader(this.raf_.length());
        }
        this.raf_.seek(this.lastAddress_);
        node.WriteData(this.raf_);
        this.raf_.writeLong(node.GetNext());
        node.SetAddress(this.lastAddress_);
        if (this.nodeNum_ > 0) {
            this.raf_.seek(this.lastAddress_ - 8L);
            this.raf_.writeLong(this.lastAddress_);
        }
        ++this.nodeNum_;
        this.lastAddress_ = this.raf_.length();
        this.UpdateListHeader();
    }

    public long GetAddress() {
        return this.beginAddress_;
    }

    public RandomAccessFile GetRaf() {
        return this.raf_;
    }

    public void Close() throws IOException {
        this.raf_.close();
    }

    public static void main(String[] args) {
        try {
            PersistentRuleNode.PrintList("rule.data", "exception.data", 6089L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void UpdateListHeader() throws IOException {
        this.raf_.seek(this.beginAddress_);
        this.raf_.writeInt(this.nodeNum_);
        this.raf_.writeLong(this.lastAddress_);
    }

    private void WriteListHeader(long address) throws IOException {
        this.nodeNum_ = 0;
        this.beginAddress_ = address;
        this.lastAddress_ = this.beginAddress_ + 12L;
        this.raf_.seek(address);
        this.raf_.writeInt(this.nodeNum_);
        this.raf_.writeLong(this.lastAddress_);
    }
}

